

class CapabilityDumpModel(object):
    def __init__(self, selection):
        """
        :type selection: parallels.core.utils.pmm.agent.DumpAll|parallels.core.utils.pmm.agent.DumpSelected
        """
        self._selection = selection

    def get_admin(self):
        """
        :rtype: parallels.plesk.source.plesk.capability_dump.model.base.admin.Admin
        :raises: parallels.core.MigrationError
        """
        raise NotImplementedError()

    def get_resellers(self):
        """
        :rtype: list[parallels.plesk.source.plesk.capability_dump.model.base.reseller.Reseller]
        """
        raise NotImplementedError()

    def get_clients(self, owner_id):
        """
        :type owner_id: str|unicode
        :rtype: list[parallels.plesk.source.plesk.capability_dump.model.base.client.Client]
        """
        raise NotImplementedError()

    def get_domains(self, owner_id):
        """
        :type owner_id: str|unicode
        :rtype: list[parallels.plesk.source.plesk.capability_dump.model.base.domain.Domain]
        """
        raise NotImplementedError()

    def get_server_components(self):
        """Returns list like
            [('package.asp', '8.5.9600.16384'), ('package.asp.net.4', '4.5.1') ...]

        :rtype: list[tuple[str|unicode, str|unicode]]
        """
        raise NotImplementedError()

    def get_server_resource_usage(self):
        """Returns list like
            [('resource.domains', '10'), ('resource.accounts', '6'), ('resource.aliases', '0') ...]

        :rtype: list[tuple[str|unicode, str|unicode]]
        """
        raise NotImplementedError()

    def get_server_settings(self):
        """Returns list like
            [('ftpOverSsl', 'enabled'), ('ftps_10.52.71.29', 'false') ...]

        :rtype: list[tuple[str|unicode, str|unicode]]
        """
        raise NotImplementedError()

    def get_database_servers(self):
        """
        :rtype: list[parallels.plesk.source.plesk.capability_dump.model.base.database_server.DatabaseServer]
        """
        raise NotImplementedError()

    def get_apache_modules(self):
        """Returns list like
            [('auth_basic', 'on'), ('php5', 'off') ...]

        :rtype: list[tuple[str|unicode, str|unicode]]
        """
        raise NotImplementedError()

    def get_domain_ips(self, domain_id):
        """
        :type domain_id: str|unicode
        :rtype: list[parallels.plesk.source.plesk.capability_dump.model.base.ip_address.IpAddress]
        """
        raise NotImplementedError()

    def get_domain_components(self, domain_id):
        """Returns list like
            [('webmail', 'horde'), ('asp_dot_net', 'true'), ('php_handler_type', 'fastcgi') ...]

        :type domain_id: str|unicode
        :rtype: list[tuple[str|unicode, str|unicode]]
        """
        raise NotImplementedError()

    def get_domain_resource_usage(self, domain_id):
        """Returns list like
            [('diskusage.vhost', '189478'), ('diskusage.db', '14589'), ('resource.mailaccounts', '3') ...]

        :type domain_id: str|unicode
        :rtype: list[tuple[str|unicode, str|unicode]]
        """
        raise NotImplementedError()

    def get_domain_settings(self, domain_id):
        """Returns list like
            [('sysuser', 'user29'), ('stat_ttl', '3'), ('iis_app_pool', 'true') ...]

        :type domain_id: str|unicode
        :rtype: list[tuple[str|unicode, str|unicode]]
        """
        raise NotImplementedError()
