from parallels.core.utils.entity import Entity
from parallels.plesk.source.plesk.shallow_dump.model.base.constants import PLESK_ADMIN_ID


class Template(Entity):
    """Shallow information about template (domain or reseller)"""
    TEMPLATE_TYPE_DOMAIN = 'domain'
    TEMPLATE_TYPE_DOMAIN_ADDON = 'domain_addon'
    TEMPLATE_TYPE_RESELLER = 'reseller'

    def __init__(self, template_id, name, template_type, guid=None, owner_id=PLESK_ADMIN_ID):
        self._template_id = template_id
        self._name = name
        self._template_type = template_type
        self._owner_id = owner_id
        self._guid = guid

    @property
    def template_id(self):
        """Template's ID

        :rtype: str | unicode
        """
        return self._template_id

    @property
    def name(self):
        """Template's name

        :rtype: str | unicode
        """
        return self._name

    @property
    def template_type(self):
        """Template's type - see TEMPLATE_TYPE_* constants

        :rtype: str | unicode
        """
        return self._template_type

    @property
    def owner_id(self):
        """Owner ID or template - reseller's ID or administrator

        :rtype: str | unicode
        """
        return self._owner_id

    @property
    def guid(self):
        """Template's GUID

        :rtype: str | unicode | None
        """
        return self._guid