from collections import namedtuple

from parallels.api.expand.core import parse_result_set
from parallels.core.utils.common.xml import elem, text_elem

PleskDomainAliasInfo = namedtuple('PleskDomainAliasInfo', ('id', 'name'))


class PleskDomainAliasOperator(object):
	class Get(namedtuple('Get', ('filter'))):
		class FilterByDomainId(namedtuple('DomainId', ('domain_id'))):
			def inner_xml(self):
				return [text_elem('domain_id', self.domain_id)]

		operator_name = 'exp_plesk_domainalias'
		operation_name = 'get'

		def inner_xml(self):
			return [
				elem('filter', self.filter.inner_xml())
			]

		@classmethod
		def parse(cls, elem):
			return parse_result_set(elem, cls._parse_data)

		@classmethod
		def _parse_data(cls, elem):
			return PleskDomainAliasInfo(
				id=int(elem.findtext('id')),
				name=elem.findtext('info/name')
			)

