from parallels.combination.plesk_to_plesk import messages
from parallels.source.plesk.actions.fetch.fetch_backup import FetchBackupActionBase


class FetchCapabilityInfoAction(FetchBackupActionBase):
	def get_description(self):
		return messages.ACTION_FETCH_CAPABILITY_INFO_FROM_PLESK_SERVERS

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.ACTION_FAILED_FETCH_CAPABILITY_INFO_FROM_PLESK

	@staticmethod
	def _create_dump(agent, dump_filename, selection):
		"""
		Create capability dump of specified objects via agent
		:type agent: parallels.core.utils.pmm.agent.PmmMigrationAgentBase
		:type dump_filename: str
		:type selection: parallels.core.utils.pmm.agent.DumpAll | parallels.core.utils.pmm.agent.DumpSelected
		"""
		agent.create_capability_dump(dump_filename, selection=selection)

	@staticmethod
	def _get_dump_filename(global_context, source_id):
		"""
		Return filename there fetched capability dump will be stored
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type source_id: str
		:rtype: str
		"""
		return global_context.session_files.get_path_to_capability_dump(source_id)

	@staticmethod
	def _get_selection_filename(global_context, source_id):
		"""
		Return filename there previously fetched capability dump selection was cached
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type source_id: str
		:rtype: str
		"""
		return global_context.session_files.get_path_to_capability_dump_selection(source_id)

	@staticmethod
	def _get_source_servers(global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return global_context.conn.get_source_plesks()