from parallels.core.utils.yaml_utils import read_yaml, write_yaml
from parallels.core.utils.common import if_not_none

class OldIpLimits(object):
	def __init__(self):
		self.limits = dict()

	def set_ipv4_limit(self, subscription_name, limit):
		self.limits[subscription_name] = {'ipv4': limit}
		self._save_state()

	def get_ipv4_limit(self, subscription_name):
		return if_not_none(self.limits.get(subscription_name), lambda l: l.get('ipv4'))

	def _save_state(self):
		pass

class OldIpLimitsFile(OldIpLimits):
	def __init__(self, filename):
		self.filename = filename
		self.limits = read_yaml(filename, file_may_be_absent=True, default=dict())

	def _save_state(self):
		write_yaml(self.filename, self.limits)

