from parallels.combination.ppa_sn_to_ppa_sn import messages
import logging
import os.path
from parallels.core.utils.common import mkdir_p
from parallels.core.utils.windows_utils import path_join as windows_path_join

logger = logging.getLogger(__name__)

class SessionDir(object):
	def __init__(self, session_dir):
		self.session_dir = session_dir

	def get_file_path(self, filename):
		return os.path.join(self.session_dir, filename)
	
	def init(self):
		if not os.path.exists(self.session_dir):
			mkdir_p(self.session_dir)
		logger.info(messages.TEMPORARY_FILES_LOCATION, self.session_dir)

class RemoteSessionDir(object):
	def __init__(self, session_dir, runner):
		self.session_dir = session_dir
		self.runner = runner

	def get_file_path(self, filename):
		raise NotImplementedError()
	
	def init(self):
		self.runner.mkdir(self.session_dir)

class WindowsRemoteSessionDir(RemoteSessionDir):
	def get_file_path(self, filename):
		return windows_path_join(self.session_dir, filename)

	def init(self):
		self.runner.mkdir(self.session_dir)
		icacl_commands = ['/inheritance:r', '/grant Administrators:(OI)(CI)F', '/grant SYSTEM:(OI)(CI)F']
		for icacl_command in icacl_commands:
			self.runner.sh("icacls {session-dir} %s" % (icacl_command,), {'session-dir': self.session_dir})
