from parallels.core.actions.base.common_action \
	import CommonAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties

class LegacyAction(CommonAction):
	"""Action based on Migrator object functions

	This wrapper is necessary for existing migrator functions that we can't
	move out of migrator as separate actions right now. With that class we can
	use the functions as actions and build them into workflow.
	"""
	def __init__(self, description, function, logging_properties=None, is_critical=True):
		"""Class constructor

		Arguments:
		- description - action description as string
		- function - function which performs action; it accepts global_context
		as the only argument

		:type description: basestring
		:type logging_properties: parallels.core.actions.utils.logging_properties.LoggingProperties | None
		:type is_critical: bool
		"""
		self._is_critical = is_critical
		self.description = description
		self.function = function
		if logging_properties is not None:
			self._logging_properties = logging_properties
		else:
			self._logging_properties = LoggingProperties()

	def get_description(self):
		"""Get short description of action as string"""
		return self.description

	def get_failure_message(self, global_context):
		"""Get message for situation when action failed

		Arguments:
		- global_context - registry with different objects that reused among
		different actions
		"""
		return 'Failed to perform action: %s' % self.get_description()

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return self._is_critical

	def get_logging_properties(self):
		return self._logging_properties

	def run(self, global_context):
		"""Run action

		Arguments:
		- global_context - registry with different objects that reused among
		different actions
		"""
		self.function(global_context)
