from parallels.core import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties
from parallels.core.target_panels import TargetPanels


class RemoveSmartermailUnsupportedFeatures(SubscriptionBackupAction):
	def get_description(self):
		return messages.REMOVE_FEATURES_THAT_ARE_NOT_SUPPORTED

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_REMOVE_FEATURES_THAT_ARE_NOT % (
			subscription.name
		)

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		if global_context.target_panel != TargetPanels.PPA:
			# applicable to PPA only, for Plesk we can restore all these mail
			# settings (antivirus, antispam, greylisting)
			return

		if subscription.mail_target_server is None:
			return
		if not subscription.mail_target_server.is_windows():
			return

		if subscription_backup.mailsystem is not None:
			subscription_backup.mailsystem.remove_greylisting()

		for mailbox in subscription_backup.iter_mailboxes():
			mailbox.remove_spamassassin()
			mailbox.remove_virusfilter()
