from parallels.core import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties


class RemoveSubscriptionDefaultDBServer(SubscriptionBackupAction):
	"""Remove information about defaut database servers as they should be
	controlled by POA and corresponding service template, not by Plesk.
	Otherwise when restoring subscription that had database on localhost, Plesk
	restore will set default database server to the management node, regardless
	of database resource settings. This can lead to incorrect database content
	restoration."""

	def get_description(self):
		return messages.REMOVE_DEFAULT_DATABASE_SERVER_FROM_BACKUP

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_REMOVE_DEFAULT_DATABASE_SERVERS_FOR % subscription.name

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		subscription_backup.remove_default_db_servers()
