from parallels.core import messages
from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.base.condition_action_pointer import ConditionActionPointer
from parallels.core.actions.base.legacy_action import LegacyAction
from parallels.core.actions.restore.plesk.import_clients import ImportClients
from parallels.core.actions.restore.plesk.import_subscriptions import ImportSubscriptions
from parallels.core.target_panels import TargetPanels


class ImportClientsAndSubscriptions(ConditionActionPointer):
	def __init__(self):
		description = messages.IMPORT_CLIENTS_AND_SUBSCRIPTIONS

		ppa_action = LegacyAction(
			description=description,
			function=lambda ctx: ctx.migrator._restore_impl(ctx.options, finalize=False)
		)

		plesk_action = CompoundAction(description=description)
		plesk_action.insert_action('import-clients', ImportClients())
		plesk_action.insert_action('import-subscriptions', ImportSubscriptions())

		self._actions = {
			TargetPanels.PPA: ppa_action,
			TargetPanels.PLESK: plesk_action,
			TargetPanels.PPA_WEB_SN: ppa_action,
		}

	def resolve(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""

		if global_context.target_panel not in self._actions:
			raise Exception(
				messages.CONCRETE_IMPORT_CLIENTS_AND_SUBSCRIPTIONS_ACTIONS % (
					global_context.target_panel,
				)
			)
		return self._actions[global_context.target_panel]
