from parallels.core.registry import Registry


class CommonSessionFiles(object):
	"""Common paths to files in migration session directory."""

	def __init__(self, conn, migrator_server):
		"""

		Arguments:
		- conn - instance of common.connections.connections.Connections
		"""
		self._conn = conn
		self._migrator_server = migrator_server

	def get_path_to_raw_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.raw.%s" % (
				server_id, self._get_extension(server_id)
			)
		)

	def get_path_to_raw_plesk_backup_selection(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.selection.yaml" % (
				server_id
			)
		)

	def get_path_to_shallow_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.shallow.xml" % (
				server_id
			)
		)

	def get_path_to_cut_plesk_backup(self, backup_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.cut.%s" % (backup_id, self._get_extension(backup_id))
		)

	def get_path_to_converted_plesk_backup(self, backup_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.converted.%s" % (backup_id, self._get_target_extension())
		)

	def get_path_to_last_hosting_analysis_time(self):
		return self._migrator_server.get_session_file_path(
			u"last.hosting.analysis.time"
		)

	def get_path_to_apache_restart_interval(self, ip=''):
		return self._migrator_server.get_session_file_path(
			"apache_restart_interval_%s.yaml" % ip
		)

	def get_path_to_ssh_keys_pool(self):
		return self._migrator_server.get_session_file_path(
			"ssh_key_pool.yaml"
		)

	def get_path_to_migration_progress_text(self):
		return self._migrator_server.get_session_file_path(
			"migration-progress"
		)

	def get_path_to_migration_progress_yaml(self):
		return self._migrator_server.get_session_file_path(
			"migration-progress.yaml"
		)

	@staticmethod
	def _get_extension(source_id):
		source_info = Registry.get_instance().get_context().get_source_info(source_id)
		return 'zip' if source_info.is_windows else 'tar'

	def _get_target_extension(self):
		return 'zip' if self._conn.target.is_windows else 'tar'

	def get_path_to_migration_agent(self, ip):
		return self._migrator_server.get_session_file_path('migration_agent_path_%s' % ip)

	def get_path_to_rsync(self):
		return self._migrator_server.get_session_file_path('rsync_path_')
