import logging

from parallels.hosting_analyser.hosting_analyser import HostingAnalyser
from parallels.core.utils.config_utils import ConfigSection

logger = logging.getLogger(__name__)

def apply_hosting_analyser_strategy(global_context, subscription, rsync_additional_args):
	global_section = ConfigSection(global_context.config, 'GLOBAL')
	if global_section.get('use-hosting-analyser', 'true').lower() == 'true':
		# choose transfer strategy
		hosting_analyser = HostingAnalyser(global_context.migrator_server)
		transfer_strategy = hosting_analyser.get_webspace_actual_transfer_strategy(subscription)
		if rsync_additional_args.count('-z') == 0 and transfer_strategy.need_compression:
			rsync_additional_args.append('-z')
			if transfer_strategy.compression_level is not None:
				rsync_additional_args.append('--compress-level={compression_level}'.format(
					compression_level=transfer_strategy.compression_level
				))