from parallels.core import messages
messages.MODULE_DEFINES_PATH_MIGRATORS_THIRDPARY_UTILS

import os
import parallels.core

from parallels.core.utils.common import is_run_on_windows


def get_paexec_bin():
	"""Location of paexec.exe - utility to run commands on remote Windows"""
	return os.path.join(get_thirdparties_dir(), "paexec.exe")



def get_rsync_bin():
	"""Location of rsync.exe - utility to download files from remote server"""
	return os.path.join(get_thirdparties_dir(), "rsync/rsync.exe")



def get_rsync_installer_bin():
	return os.path.join(_get_common_root_path(), 'extras', 'rsync-installer.exe')



def get_rsync_for_source_server_installer():
	"""Get installer binary for rsync on source servers"""
	return os.path.join(get_thirdparties_dir(), "rsync-for-source-server.exe")



def get_thirdparties_dir():
	if not is_run_on_windows():
		raise Exception(messages.UNABLE_GET_THIRDPARTIES_DIR_IT_IS)

	current_file_dir = os.path.dirname(__file__)
	# 6 times up - according to Windows layout
	path_elems = [current_file_dir] + [r'..'] * 6 + ['thirdparties']
	return os.path.realpath(os.path.join(*path_elems))



def get_transfer_agent_dir():
	if not is_run_on_windows():
		raise Exception(messages.UNABLE_GET_PANEL_MIGRATOR_TRANSFER_AGENT)

	current_file_dir = os.path.dirname(__file__)
	# 6 times up - according to Windows layout
	path_elems = [current_file_dir] + [r'..'] * 6 + ['agents', 'transfer-agent']
	return os.path.realpath(os.path.join(*path_elems))



def _get_common_root_path():
	# Get path to package root directory.
	dirs = [p for p in parallels.core.__path__]
	assert all(d == dirs[0] for d in dirs)
	return dirs[0]

