from parallels.core import migrator_config
from parallels.core.migrator_config import ActionRunnerType
from parallels.core.workflow.runner.by_layer import ActionRunnerByLayer
from parallels.core.workflow.runner.by_subscription import ActionRunnerBySubscription


def create_action_runner(global_context):
	"""Create runner according to global configuration

	:type global_context: parallels.core.global_context.GlobalMigrationContext
	"""
	action_runner_type = migrator_config.get_action_runner_type(global_context.config)
	multithreading = migrator_config.read_multithreading_params(global_context.config)

	if action_runner_type == ActionRunnerType.BY_LAYER:
		return ActionRunnerByLayer(global_context, multithreading)
	elif action_runner_type == ActionRunnerType.BY_SUBSCRIPTION:
		return ActionRunnerBySubscription(global_context, multithreading)
	else:
		assert False