from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import ServiceIssueType

MESSAGES = {}

MESSAGES[ServiceIssueType.SERVICE_NOT_STARTED] = format_message("""
Service '{type}' is not started on {description}.
""")

MESSAGES[ServiceIssueType.SERVICE_PORT_IS_CLOSED] = format_message("""
Service '{service}' port {port} on {description} is closed.
""")

MESSAGES[ServiceIssueType.SERVICE_CONNECTION_ERROR] = format_message("""
Unable to connect to service {service} by port {port} on {description} from local server.
""")

MESSAGES[ServiceIssueType.SERVICE_INTERNAL_ERROR] = format_message("""
Internal errors have occurred while checking that service '{type}' works correctly on {description}: {error_message}.
""")
