from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import PostgreSQLDatabaseIssueType

MESSAGES = {}

MESSAGES[PostgreSQLDatabaseIssueType.DIFFERENT_TABLES_SET] = format_message("""
Make sure that the database content was migrated successfully.
If it was not, run the "{util_name} copy-db-content" command
to retry migrating the database content, or copy the database content manually.
""")

MESSAGES[PostgreSQLDatabaseIssueType.FAILED_TO_EXECUTE_SIMPLE_QUERY_AS_USER] = format_message("""
Ensure that the database user is present both in the hosting panel and on the target database server.
Another possible reason is that password was changed for that user on the target panel after migration.
""")

MESSAGES[PostgreSQLDatabaseIssueType.CONNECTION_ERROR] = format_message("""
Please make sure that:
1. The target PostgreSQL database server is started and running.
2. There are no firewall rules that may block connection to the server.
""")

MESSAGES[PostgreSQLDatabaseIssueType.DATABASE_DOES_NOT_EXIST_IN_PANEL] = format_message("""
To transfer the database from the source server, you need to either restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command, 
or create the database manually from the hosting panel and then run the '{util_name} copy-db-content' command.
""")

MESSAGES[PostgreSQLDatabaseIssueType.DATABASE_USER_DOES_NOT_EXIST_IN_PANEL] = format_message("""
Most likely some web application, which uses the database, does not work after migration.
To transfer the database user from the source server, you need to try to restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command. 
Another way is to recreate the user manually.
""")

MESSAGES[PostgreSQLDatabaseIssueType.DATABASE_DOES_NOT_EXIST] = format_message("""
To transfer the database from the source server, you need to either restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command, 
or create the database manually from the hosting panel and then run the '{util_name} copy-db-content' command.
""")

MESSAGES[PostgreSQLDatabaseIssueType.PSQL_CLIENT_GENERIC_ERROR] = format_message("""
Refer to the official PostgreSQL documentation to learn more about this issue and about how to resolve it.
""")

MESSAGES[PostgreSQLDatabaseIssueType.INTERNAL_ERROR] = format_message("""
Manually check whether this database and database users were migrated properly.
""")

MESSAGES[PostgreSQLDatabaseIssueType.FAILED_TO_FETCH_TABLES_FROM_SOURCE] = format_message("""
Please make sure that:
1. The source PostgreSQL Server is started and running.
2. There are no firewall rules that may block connection to the server.
If that does not help, check manually that database tables were copied correctly.
""")

MESSAGES[PostgreSQLDatabaseIssueType.FAILED_TO_FETCH_TABLES_FROM_TARGET] = format_message("""
Please make sure that:
1. The target PostgreSQL Server is started and running.
2. There are no firewall rules that may block connection to the server.
If that does not help, check manually that database tables were copied correctly.
""")
