from parallels.source.legacy.pmm_agent import UnixPmmMigrationAgent

class ConfixxPmmMigrationAgent(UnixPmmMigrationAgent):
	def __init__(self, global_context, server, migrator_dump_dir, settings):
		cli_options = '--dump-all --configuration-only --server -v 5'
		super(ConfixxPmmMigrationAgent, self).__init__(global_context, server, migrator_dump_dir, settings, cli_options)

	def get_confixx_config_path(self):
		self.logger.info(u"Get Confixx config file path")

		with self._source_server.runner() as runner:
			path = runner.sh(
				ur'cd {path}; perl ConfixxConfigPath.pl',
				{
					'path':	self.agent_dir,
					'agent': self.settings.agent_script_name
				}
			).strip()
			self.logger.debug("Confixx config path = '%s'", path)
			return path

