from parallels.source.confixx import messages
from parallels.core.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.core.actions.base.legacy_action \
	import LegacyAction

from parallels.source.confixx.actions.content.web.copy_unix_content \
	import ConfixxCopyUnixWebContent
from parallels.source.confixx.actions.content.web.fix_permissions \
	import FixPermissions

class FromConfixxWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromConfixxWorkflow, self).__init__()

		self.get_shared_action('copy-web-files').insert_action(
			'copy-files', ConfixxCopyUnixWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixPermissions()
		)
		self.get_path('check/check-data').insert_action(
			'check-additional', LegacyAction(
				description='Check additional',
				function=lambda ctx: ctx.migrator._check_additional(
					ctx.pre_check_report, ctx.target_existing_objects
				)
			)
		)

		self.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description=messages.FETCH_DATA_FROM_SOURCE_CONFIXX,
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
