import logging
import posixpath

from parallels.core.actions.content.web.copy_unix_content_base import CopyWebContentItem
from parallels.core.utils.paths import web_paths
from parallels.source.plesk.actions.content.web.copy_unix_content import CopyUnixWebContentBase


logger = logging.getLogger(__name__)


class CpanelCopyUnixWebContent(CopyUnixWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		"""Make a list of source server directories to be transferred.

		Return:
			A list of (source directory -> destination directory) mappings

		:type global_context: parallels.source.cpanel.global_context.CpanelGlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:rtype: list[parallels.core.actions.content.web.copy_unix_content_base.CopyWebContentItem]
		"""
		sysuser = subscription.raw_backup.get_phosting_sysuser_name()
		source_vhosts_path = global_context.dump_agent.get_vhosts_dir(sysuser)

		return [
			CopyWebContentItem(
				source_path=web_paths.AbsolutePath(posixpath.join(source_vhosts_path)),
				target_path=web_paths.WebspaceRoot(subscription.converted_backup),
				exclude=['/mail', '/.*'],
			)
		]