from parallels.core.utils.config_utils import ConfigSection
from parallels.core.migrator_config import read_ssh_auth
from parallels.core.migrator_config import read_copy_mail_content_settings

# This is the ID used for naming config file sections and migration dump files
PANEL_ID = 'cpanel'

class CpanelConfig(object):
	def __init__(self, config):
		self.ip = config['ip']
		self.id = PANEL_ID
		self.is_windows = False
		self.ssh_auth = read_ssh_auth(config)
		self.pmm_agent_name = "cPanel"
		self.agent_script_name = 'cPanel9.pl'
		self.session_dir = config.get('session-dir', '/tmp')
		self.postgres_password = config.get('postgres-password', '')
		self.mail_settings = read_copy_mail_content_settings(
			config, is_windows=False
		)

def init(config):
	cpanel_section = ConfigSection(config, PANEL_ID)
	return CpanelConfig(cpanel_section)

