from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.content.database.copy_database_content import CopyDatabaseContent
from parallels.core.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.core.utils.backup_adapter import SubscriptionBackup
from parallels.source.custom.actions.backup.create_converted import CustomPanelCreateConverted
from parallels.source.custom.actions.backup.create_from_light import CreateFromLight
from parallels.source.custom.actions.content.database.restore_db_dumps import RestoreDBDumps
from parallels.source.custom.actions.content.mail.copy_mail_messages import CopyMailMessages
from parallels.source.custom.actions.content.web.copy_unix_content import CustomPanelCopyUnixWebContent


class FromCustomPanelWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromCustomPanelWorkflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'create-full-backup-from-light', CreateFromLight()
		)

		self.get_path('generate-migration-list').remove_action('analyse-hosting')

		self.get_path('transfer-accounts').replace(
			'fetch-source-shallow', CompoundAction()
		)

		self.replace_shared_action('copy-db-content', CompoundAction())
		self.get_shared_action('copy-db-content').insert_action(
			'copy-db-from-servers', CopyDatabaseContent()
		)
		self.get_shared_action('copy-db-content').insert_action(
			'restore-db-dumps', RestoreDBDumps()
		)
		self.replace_shared_action('copy-mail-content', CopyMailMessages())
		self.get_shared_action('copy-web-files').insert_action(
			'copy-files', CustomPanelCopyUnixWebContent()
		)

		# no need to check infrastructure in case of migration w/o source server access,
		# so just replace corresponding action with empty action
		self.replace_shared_action(
			'check-infrastructure', CompoundAction()
		)

		self.get_shared_action('convert-hosting').replace(
			'create-converted-backup',
			CustomPanelCreateConverted(SubscriptionBackup())
		)