from parallels.core.actions.content.web.copy_windows_content_base import CopyWindowsWebContentBase
from parallels.core.utils.common import obj


class CopyWindowsWebContent(CopyWindowsWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		vhost_name = subscription.name_idn

		tocopy = [
			# content
			obj(
				source_filename=vhost_name + '/',
				target_filename=vhost_name,
				exclude=[u"/Backup", u"/Certificates", u"/wwwroot", u"/SubDomains"],
				skip_if_source_not_exists=False
			),
			obj(
				source_filename=vhost_name + '/wwwroot/',
				target_filename=vhost_name + '/httpdocs',
				exclude=[],
				skip_if_source_not_exists=False
			),
		]

		for site in subscription.raw_backup.iter_subdomains():
			source_site_subdir = "%s/SubDomains/%s/" % (vhost_name, site.short_name.encode('idna'))
			target_site_subdir = "%s/%s/" % (vhost_name, site.name.encode('idna'))
			tocopy.extend([
				obj(
					source_filename=source_site_subdir,
					target_filename=target_site_subdir,
					exclude=[],
					skip_if_source_not_exists=True
				)
			])

		return tocopy
