from parallels.core.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.core.actions.base.legacy_action \
	import LegacyAction

from parallels.source.helm4.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS
from parallels.source.helm4.actions.content.web.copy_windows_content \
	import CopyWindowsWebContent
from parallels.source.plesk.actions.content.web.reset_permissions \
	import ResetPermissions
from parallels.source.helm4.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.source.helm4.actions.hosting_settings.transfer_mime_types \
	import TransferMIMETypes
from parallels.source.helm4.actions.hosting_settings.transfer_error_documents \
	import TransferErrorDocuments


class FromHelm4Workflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromHelm4Workflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description='Fetch data from source Helm',
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		self.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)
		self.get_shared_action('copy-web-files').insert_action(
			'copy-files', CopyWindowsWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'reset-permissions', ResetPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-error-documents', TransferErrorDocuments()
		)
