from parallels.source.hsphere import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core import MigrationError


class UndoNotSupported(CommonAction):
	def get_description(self):
		return messages.REPORT_THAT_UNDO_DNS_FORWARDING_NOT_SUPPORTED

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_TO_REPORT_THAT_UNDO_DNS_FORWARDING_NOT_SUPPORTED

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		raise MigrationError(
			messages.DNS_FORWARDING_CONFIG_CANNOT_BE_UNDONE)
