from parallels.core.converter.business_objects.common import EntityConverter

class HSphereEntityConverter(EntityConverter):
	def __init__(self, existing_objects, domain_os_type, contact_information):
		self.domain_os_type = domain_os_type
		self.contact_information = contact_information
		super(HSphereEntityConverter, self).__init__(existing_objects)

	def create_subscription_from_plesk_backup_subscription(self, subscription, plesk_id, is_windows):
		return super(HSphereEntityConverter, self).create_subscription_from_plesk_backup_subscription(
			subscription, plesk_id, 
			is_windows=self.domain_os_type.get(subscription.name, 'unix') == 'windows'	
		)

	def create_subscription_stub_from_existing_subscription(self, subscription, plesk_id, is_windows):
		return super(HSphereEntityConverter, self).create_subscription_stub_from_existing_subscription(
			subscription, plesk_id, 
			is_windows=self.domain_os_type.get(subscription.name, 'unix') == 'windows'	
		)

	def _get_client_first_name(self, client):
		info = self.contact_information.get(client.login)
		if info is not None:
			return info['first_name']
		else:
			return client.contact

	def _get_client_last_name(self, client):
		info = self.contact_information.get(client.login)
		if info is not None:
			return info['last_name']
		else:
			return ''

