from parallels.core.utils.message_utils import single_line_message
from parallels.core.utils.message_utils import multi_line_message

DISK_USED_SUMMARY_FOR_SUBSCRIPTION = single_line_message("""
	Disk summary is used for subscription '%s'
""")
FAILED_TO_GET_RESOURCE_LIMITS_FROM_HSPHERE = single_line_message("""
	Failed to retrieve resource limits from H-Sphere.
""")
DISK_QUOTA_IS_USED_FOR_SUBSCRIPTION = single_line_message("""
	Disk quota is used for subscription '%s'
""")
RETRIEVE_SUBSCRIPTION_LIMITS = single_line_message("""
	Retrieve subscription limits of '%s'
""")
FAILED_TO_RESTORE_RESOURCE_LIMITS = single_line_message("""
	Failed to restore resource limits.
""")
LOAD_STDIN_CONTENT_TO_HSPHERE_SERVER = single_line_message("""
	Load stdin content to Hsphere, ip: '%s'.
""")
LOAD_SCRIPT_CONTENT_HSPHERE_SERVER = single_line_message("""
	Load script content to Hsphere, ip: '%s'.
""")
REMOVE_TEMP_FILES_FROM_HSPHERE_SERVER = single_line_message("""
	Remove temp files from Hsphere, ip: '%s'.
""")
EXECUTE_REMOTE_COMMAND_AS_MULTILINE_COMMAND = single_line_message("""
	Execute remote command as multiline command.
""")
UNABLE_ADD_ACCOUNTS_DB_INCONSISTENCY = multi_line_message("""
	Unable to add accounts to the account with ID %i. This could happen because of inconsistencies in the H-Sphere's database.
	Repair such inconsistencies and re-run the migration tool.
""")
DATABASES_FROM_SERVER_WILL_NOT_BE_MIGRATED = single_line_message("""
	All databases on this database server will not be migrated to PPA. Resolve inconsistencies in the H-Sphere's
	database and re-run the migration tool.
""")
SUBSCRIPTION_WITH_NO_WEB_AND_MAIL_NOT_MIGRATED = single_line_message("""
	The subscription will not be migrated to PPA because it does not have web and mail services.
""")
DATABASE_SERVER_IP_INCONSISTENCY = multi_line_message("""
	There are inconsistencies in the H-Sphere's database.
	The SQL query: %s.
	The database server should have a valid IP address.
""")
SUBSCRIPTION_INCONSISTENCY = multi_line_message("""
	The subscription will not be migrated to PPA. Resolve inconsistencies in the H-Sphere's database and re-run the migration tool.
	To execute an H-Sphere database query:
	1. Log in to the H-Sphere management node as root.
	2. Execute the "su - cpanel -c 'psql hsphere'" command to open the PostgreSQL console.
""")
SYSUSER_EMPTY_LOGIN_INCONSISTENCY = multi_line_message("""
	H-Sphere database inconsistency.
	Query was '%s'.
	Sysuser has empty login. Expected that sysuser does not have empty login.
""")
USER_NOT_PRESENTED_IN_BACKUP = single_line_message("""
	A user with ID  %s is not present in the backup.
""")
UNABLE_TO_GET_INFO_ABOUT_SSL_CERTIFICATES = single_line_message("""
	Unable to retrieve information about SSL certificates for the domain %s: %s
""")
MSSQL_DB_USER_HAS_DIFFERENT_NAME_FOR_DB_LOGIN = single_line_message("""
	The Microsoft SQL database user '%s' of the database '%s' has name different from the associated database login '%s'
""")
FETCH_GREY_LISTING_FOR_DOMAIN = single_line_message("""
	Fetch grey listing for '#%s' domain
""")
INFORMATION_ABOUT_SSL_CERTIFICATES_FOR_DOMAIN_SKIPPED = single_line_message("""
	Information about SSL certificates for the domain with ID %s will not be retrieved.
""")
SKIP_DETECTION_OF_FTP_USERS = single_line_message("""
	Skipping the detection of FTP users of the domain with ID %s.
""")
SKIP_SSL_CERTIFICATES_NO_SYSTEM_USER = single_line_message("""
	Information about SSL certificates for the domain with ID %s will not be retrieved because there is no system user.
""")
HOSTING_SETTINGS_NODE_WILL_NOT_BE_ADDED = single_line_message("""
	An XML node describing hosting settings will not be added for the domain with ID %s.
""")
SKIP_AUTORESPONDER_WITH_SAME_NAME_EXISTS = single_line_message("""
	Skip '%s' autoresponder due to mailbox or forwarding with same name exists
""")
CUSTOMER_INCONSISTENCIES = single_line_message("""
	The customer will not be migrated to PPA. Resolve inconsistencies in the H-Sphere's database and re-run the
	migration tool.
""")
GET_INFO_ABOUT_FTP_USERS_DOMAIN = single_line_message("""
	Retrieving information about FTP users of the domain with ID %s.
""")
GET_INFO_ADDON_DOMAINS = single_line_message("""
	Retrieving information about add-on domains of the domain with ID %s.
""")
UNABLE_ATTACH_CERTIFICATE_TO_DOMAIN = single_line_message("""
	Unable to attach a certificate to the domain with ID %s.
""")
FETCH_ANTISPAM_FOR_MAILBOX = single_line_message("""
	Fetch antispam for '#%s' mailbox
""")
MYSQL_SERVER_INCONSISTENCIES = multi_line_message("""
	There are inconsistencies in the H-Sphere's database.
	The SQL query: %s.
	Unable to add information about the MySQL server to the backup because the username and password are not specified.
""")
HOW_TO_EXECUTE_HSPHERE_DB_QUERY = multi_line_message("""
	To execute an H-Sphere database query:
	1. Log in to the H-Sphere management node as root.
	2. Execute the "su - cpanel -c 'psql hsphere'" command to open the PostgreSQL console.
	Resolve inconsistencies in the H-Sphere's database and re-run the migration tool.
""")
HSPHERE_DB_INCONSISTENCIES = multi_line_message("""
	There are inconsistencies in the H-Sphere's database.
	The SQL query: %s.
	The database server should have a valid IP address.
""")
SUBSCRIPTION_WILL_NOT_BE_MIGRATED = multi_line_message("""
	The subscription will not be migrated to PPA. If you want to migrate the subscription:
	1. Try to re-run the migration tool.
	2. Migrate the failed subscription manually.
	3. Refer to the technical support to resolve the issue.
""")
SUBSCRIPTIONS_THAT_USE_DATABASE_SERVER_WILL_NOT_BE_RESTORED_CORRECTLY = multi_line_message("""
	All subscriptions that use the database server %s will not be restored correctly. Resolve inconsistencies in the H-Sphere's database and re-run the migration tool.
	If there are no subscriptions that use this database server, ignore this error.
""")
UNABLE_GET_INFO_ABOUT_SSL_CERTIFICATES_FROM_HSPHERE_NODE = multi_line_message("""
	Unable to retrieve information about SSL certificates for  the domain {domain_name} from the H-Sphere node at IP address {service_node_ip}:
	1. Try to re-run the migration tool. (This could happen because of a temporary network issue).
	2. Migrate the certificates manually.
""")
REMOVING_EXISTING_BACKUP_FILE = single_line_message("""
	Removing the existing backup file.
""")
GET_INFO_ABOUT_MAIN_DOMAIN = single_line_message("""
	Retrieving information about main domain %s of account %s.
""")
UNABLE_GET_INFO_ABOUT_ONE_OF_SUBSCRIPTIONS = single_line_message("""
	Unable to retrieve information about one of the subscriptions. Resolve inconsistencies in the H-Sphere's database
	and re-run the migration tool.
""")
SKIP_FORWARDING_MAILUSER_MAILBOX_WITH_SAME_NAME = single_line_message("""
	Skip '%s' forwarding mailuser due to mailbox with same name exists
""")
GET_INFO_ABOUT_DOMAINS_RELATED_TO_DOMAIN = single_line_message("""
	Retrieving information about domains related to the domain with ID %s.
""")
RESELLER_INCONSISTENCIES = single_line_message("""
	The reseller will not be migrated to PPA. Resolve inconsistencies in the H-Sphere's database and re-run the
	migration tool.
""")
FAILED_TO_FETCH_RESELLER_ACCOUNT = single_line_message("""
	Failed to fetch reseller account with '%i' id from Hsphere: %s
""")
FETCH_FORWARDING_FOR_MAILBOX = single_line_message("""
	Fetch forwarding for '#%s' mailbox
""")
HSPHERE_DATABASE_INCONSISTENCY_SYSUSER_EMPTY_PASSWORD = multi_line_message("""
	H-Sphere database inconsistency. 
	Query was '%s'.
	Sysuser '%s' has empty password. Expected that sysuser does not have empty password.
""")
SKIP_DOMAIN_WITH_NO_WEB_AND_MAIL = single_line_message("""
	Skip domain '%s' that has neither a Web service nor a Mail service
""")
UNABLE_GET_SSL_CERTIFICATES_NO_CREDENTIALS_FOR_SERVER = single_line_message("""
	Unable to retrieve the SSL certificates of domain %s because there are no credentials specified for the server at
	%s. Specify these credentials in the migration tool's configuration.
""")
UNABLE_TO_DETERMINE_TYPE_OF_EMAIL = single_line_message("""
	Unable to determine type of '%s' email
""")
HOW_TO_EXECUTE_HSPHERE_DB_QUERY_DB_NOT_MIGRATED = multi_line_message("""
	To execute an H-Sphere database query:
	1. Log in to the H-Sphere node as root.
	2. Execute the command "su - cpanel -c 'psql hsphere'" to open the PostgreSQL console.The database will not be migrated to PPA. Resolve inconsistencies in the H-Sphere's database and re-run the migration tool.
""")
GET_INFO_ABOUT_MAIN_DOMAIN_OF_ACCOUNT = single_line_message("""
	Retrieving information about the main domain of the account with ID %s.
""")
HOW_TO_MIGRATE_SUBSCRIPTION_WITH_NO_WEB_AND_MAIL = multi_line_message("""
	You can move the subscription to the PPA server in either of the following ways:
	1. Create a subscription on the PPA server manually.
	2. Add mail or web resource and re-run the migration tool.
""")
MSSQL_DATABASE_USERS_WITH_DIFFERENT_LOGINS_ARE_NOT_SUPPORTED = multi_line_message("""
	Such database users are not supported by PPA. PPA requires login to be equal to user name. Please do either of:
	* Adjust the data in H-Sphere: make the database login equal to the database user name, and fix the database permissions of this user.
	The migration tool will then transfer this database with corrected users.
	* Use the --ignore-fetch-source-errors option to skip transferring this database and all logins and users related to it.
	You will have to transfer this database manually afterwards.
""")
GET_INFO_ABOUT_WEBSITE_SETTINGS = single_line_message("""
	Retrieving information about website settings for the domain with ID %s.
""")
FETCH_ANTIVIRUS_FOR_MAILBOX = single_line_message("""
	Fetch antivirus for '#%s' mailbox
""")
UNABLE_TO_ADD_RESELLERS_TO_HSPHERE_BACKUP = multi_line_message("""
	Unable to add resellers to an H-Sphere backup. This could happen because of inconsistencies in the H-Sphere's database.
	Repair such inconsistencies and re-run the migration tool.
""")
DATABASES_OF_DATABASE_SERVER_NOT_MIGRATED = single_line_message("""
	All databases on this database server will not be migrated to PPA. Resolve inconsistencies in the H-Sphere's
	database and re-run the migration tool.
""")
FETCH_AUTORESPONDERS_FOR_MAILBOX = single_line_message("""
	Fetch autoresponders for '#%s' mailbox
""")
GET_INFO_ABOUT_RESELLERS_FROM_HSPHERE = single_line_message("""
	Retrieving information about resellers from H-Sphere.
""")
SKIP_MAILSYSTEM_NODE_BECAUSE_NO_MAIL_SERVICE = single_line_message("""
	Skip mailsystem node fetching for #'%s' domain: there is not mail service for domain.
""")
SKIP_ALIAS_BECAUSE_MAILBOX_EXISTS = single_line_message("""
	Skip '%s' alias for '%s' domain due to such mailbox already exists
""")
FETCH_DOMAIN_ALIASES_FOR_MAILBOX = single_line_message("""
	Fetch domain aliases for '#%s' mailbox
""")
FAILED_TO_GET_INFO_ABOUT_SUBSCRIPTION_HSPHERE_INCONSISTENCY = single_line_message("""
	Failed to retrieve information about the subscription %s from H-Sphere because of H-Sphere database inconsistency:
	%s
""")
INVALID_VALUE_FOR_BILLING_MODE = single_line_message("""
	An invalid value "%s" is specified for the "mode" setting in the ppa-billing section of tool's configuration.
	Specify one of these values: %s.
""")
UNABLE_TO_TRANSFER_HSPHERE_USER_TO_BILLING = multi_line_message("""
	Unable to transfer the H-Sphere user %s to PPA Billing: %s
	All H-Sphere accounts of this user will not be transferred to PPA Billing.
""")
GET_MAPPING_SUBSCRIPTIONS_TO_PPA_DNS_SERVERS = single_line_message("""
	Get mapping of subscriptions to PPA DNS servers
""")
RESTART_HSPHERE_CP_TO_APPLY_CHANGES = single_line_message("""
	Restart the H-Sphere CP to apply the changes.
""")
FETCH_HSPHERE_SERVERS_INFORMATION = single_line_message("""
	Fetch H-Sphere servers information.
""")
DISABLE_ACCOUNT_DELETION_RULE = multi_line_message("""
	Disable the Account Deletion rule in this account's vendor Suspension Rules/Managing Debtors menu.
	Alternatively, if automatic deletion of transferred accounts from H-Sphere, with all their content and hosting settings, is OK with you, run the migration tool with --accept-automatic-deletion option.
""")
HSPHERE_USERS_AND_ACCOUNTS_STATS = single_line_message("""
	%d H-Sphere users with %d accounts were transferred successfully.
""")
CHECKING_SCP_AND_SSH_CONNECTIONS = single_line_message("""
	Checking scp/ssh connections between source unix servers and PPA MySQL service nodes
""")
ACCOUNT_WAS_TRANSFERRED_PPA = single_line_message("""
	This account was transferred to PPA.
""")
CONNECTION_ISSUE_SOLUTION = multi_line_message("""
	Make sure that:
	1) There are no firewall rules blocking SSH connections from the PPA node to the source server:
	the incoming connections on the TCP port 22 of the source server are allowed, the outgoing connections on the TCP port 22 of the PPA service node are allowed.
	2) The SSH service on the source server is configured to allow logging in as the user 'root'.
	3) The SSH service on the source server is running.
	4) The program 'rsync' is in the PATH of user 'root' on the source server.
	5) The following command can be successfully executed on the PPA service node:
	{cmd}
""")
ADJUST_PRICE_PLAN_IN_PPA_BILLING_OR_VALUE_IN_MIGRATOR_CONFIG = multi_line_message("""
	Adjust either of: 
	* the price on %s plan in PPA Billing
	* the %s value in migration tool's configuration
""")
CHECKING_RSYNC_AND_SSH_CONNECTIONS_POSTFIX = single_line_message("""
	Checking rsync/ssh connections between source unix servers and PPA Postfix service nodes
""")
UNABLE_TO_SAFELY_SUSPEND_ACCOUNT = single_line_message("""
	Unable to safely suspend the account #%s (domain %s). According to the suspension rules of its vendor, it will be
	automatically deleted after %s days of being in the suspended state.
""")
RETRIEVE_BILLING_INFORMATION_FROM_HSPHERE = single_line_message("""
	retrieve billing information from H-Sphere
""")
FINAL_TRANSFER_OF_PPA_BILLING_WAS_CANCELLED = single_line_message("""
	Final transfer to PPA Billing was cancelled.
""")
UNABLE_TO_CALCULATE_SIZE_OF_MYSQL_DATABASE = multi_line_message("""
	Unable to calculate the size of MySQL database %s on source server at %s:
	%s
	The migration tool will skip checking available disk space for this database.
""")
CONFIGURE_ZONE_ON_SOURCE_SERVER_SLAVE = single_line_message("""
	Configure this zone on the source server to be served in slave mode, with the corresponding PPA DNS server as
	master.
""")
TRANSFER_HSPHERE_USERS_AND_THEIR_ACCOUNTS = single_line_message("""
	transfer H-Sphere users and their accounts into PPA Billing
""")
TRANSFER_ACCOUNT_RESOURCE_LIMITS_AND_USAGE = single_line_message("""
	transfer account resource limits and usage from H-Sphere
""")
UNABLE_TO_CHECK_SCP_CONNECTION = multi_line_message("""
	Unable to check the scp connection between %s and the source server at %s:
	%s
	While this problem persists, it may not be possible to copy the %s content of the following subscriptions:%s
""")
SKIP_LOADING_CACHED_SOURCE_PANEL_DATA = single_line_message("""
	Data files for Source Panel already exist, skip loading
""")
HSPHERE_ACCOUNT_NOT_TRANSFERRED_BECAUSE_OF_OTHER_ACCOUNTS_ERRORS = single_line_message("""
	The H-Sphere account #%s (domain %s) will not be transferred because of errors with other accounts belonging to this
	customer.
""")
ASSUMING_USER_MIGRATION_FAILED = single_line_message("""
	Assuming user %s migration failed because there were issues
""")
CHECK_RSYNC_AND_SSH_CONNECTIONS_APACHE = single_line_message("""
	Checking rsync/ssh connections between source unix servers and PPA Apache service nodes
""")
SKIP_TRANSFER_ACCESS_RESTRICTION_SETTINGS = single_line_message("""
	Skip transfer of access restriction settings for site '%s' of subscription '%s' as is has no virtual hosting
""")
REQUIRED_API_METHODS_ARE_ABSENT = multi_line_message("""
	One or more of the required API methods are absent in the H-Sphere XML API.
	The required methods are: %s
	They must be present in schema which is downloadable from %s
	
	Make sure that you have installed the new API methods according to the PPA migration guide.
""")
INTERNAL_ERROR_ACCOUNT_DOES_NOT_EXIST_IN_SOURCE_MODEL = single_line_message("""
	Internal error: account %s exists in target model, but does not exist in source model
""")
ENABLE_BILLING_TAB = single_line_message("""
	Enable billing tab in PPA customer's panel
""")
CHECK_ACCOUNT_STATUS_IN_HSPHERE_CP_AND_RESUME = single_line_message("""
	Check the account status in H-Sphere CP and resume the account, if necessary.
""")
CHECK_ACCOUNT_STATUS_IN_HSPHERE_AND_AND_RESUME = single_line_message("""
	Check the account status in H-Sphere and resume the account if necessary.
""")
UNABLE_TO_CONTINUE_MIGRATION = multi_line_message("""
	Unable to continue migration until there are no issues at 'error' or 'warning' level in backup creation step. 
	Please review report tree above and fix the errors and warnings. You can also use --ignore-fetch-source-errors command-line option if you're sure what you are doing.
""")
FAILED_TO_DOWNLOAD_SCHEMA_OF_XML_API = multi_line_message("""
	Failed to download the schema of XML API AdminServices: %s.
	Make sure that:
	1. The H-Sphere XML API is enabled according to the PPA migration guide.
	2. The H-Sphere CP is running.
	3. There are no firewall rules blocking access to the H-Sphere XML API from PPA management node.
""")
FAILED_TO_ROLL_BACK = single_line_message("""
	Assuming user migration failed to roll everything back (migrator running in the test mode)
""")
DISABLE_AUTO_RESUMING_RULE = single_line_message("""
	Disable the Auto Resuming rule in this account's vendor suspension rules, and re-run the migration tool's transfer-
	billing command. Please note that with Auto Resuming disabled, accounts of the other clients of this vendor will not
	be automatically resumed upon paying their debts.
""")
UNABLE_CALCULATE_DISK_SPACE_FOR_WINDOWS_USERS = multi_line_message("""
	Unable to calculate the disk space used by the following Windows system users:
	%s
	 on the source server at %s:
	%s
	The migration tool will skip checking available disk space for the corresponding subscriptions.
""")
CREATING_SUBSCRIPTIONS_IN_PPA_BILLING = single_line_message("""
	Creating subscriptions in PPA Billing
""")
CONNECTION_ISSUE_SOLUTION_SSH = multi_line_message("""
	Make sure that:
	1) There are no firewall rules blocking SSH connections from the PPA node to the source server:
	the incoming connections on the TCP port 22 of the source server are allowed, the outgoing connections on the TCP port 22 of the PPA service node are allowed.
	2) The SSH service on the source server is configured to allow logging in as the user 'root'.
	3) The SSH service on the source server is running.
	4) The program 'scp' is installed on the source server.
	5) The following command can be successfully executed on {host}:
	{cmd}
""")
FINAL_BILLING_TRANSFER_CONFIRMED = single_line_message("""
	Final transfer to PPA Billing was confirmed.
""")
CALCULATING_DISK_SPACE_USAGE_SOURCE_WINDOWS = single_line_message("""
	Calculating disk space usage on the source windows servers
""")
FETCHED_ACCOUNT_SUBSCRIPTION_ISSUES = single_line_message("""
	Fetched Accounts/Subscriptions Issues
""")
FETCH_INFO_FROM_SOURCE_SERVERS = single_line_message("""
	fetch info from source servers
""")
CHECKING_IF_THERE_IS_ENOUGH_DISK_UNIX = single_line_message("""
	Checking if there is enough disk space on PPA unix service nodes
""")
UNABLE_CALCULATE_DISK_SPACE_MAILBOXES = multi_line_message("""
	Unable to calculate the disk space used by mailboxes of domain %s on source server at %s:
	%s
	The migration tool will skip checking available disk space for the corresponding subscription.
""")
CHECK_IF_USERS_AND_ACCOUNTS_CAN_BE_TRANSFERRED = single_line_message("""
	check if H-Sphere users and their accounts can be transferred into PPA Billing
""")
FAILED_TO_OBTAIN_PPA_BILLING_API_URL = multi_line_message("""
	Failed to obtain the PPA Billing API URL and credentials: %s.
	Make sure that the PPA Billing is registered in PPA.
""")
TRANSFER_ACCESS_RESTRICTION_SETTINGS = single_line_message("""
	Transfer access restriction settings for %d sites in %d subscriptions
""")
UNABLE_TO_APPLY_CHANGES_TO_CONTACT_INFO = single_line_message("""
	Unable to apply the changes to the contact information of the account #%s (domain %s): connection refused.
""")
PPA_BILLING_VERSION_IS_LESS_THAN_REQUIRED = multi_line_message("""
	PPA Billing version %s is less than required: %s.
	Upgrade your PPA Billing.
""")
ACCOUNT_WILL_BE_AUTOMATICALY_DELETED = single_line_message("""
	The account #%s (domain %s) will be automatically deleted after %s days if we suspend it. Skipped suspending it.
""")
UNABLE_TO_CHECK_RSYNC_CONNECTION = multi_line_message("""
	Unable to check the rsync connection between %s and the source server at %s:
	%s
	While this problem persists, it may not be possible to copy the %s content of the following subscriptions:%s
""")
SUCCESSFULLY_CHECKED_SCP_CONNECTION = single_line_message("""
	Successfully checked the scp connection between %s and the source server at %s
""")
RESOLVE_ERRORS_WITH_OTHER_ACCOUNTS_OF_CUSTOMER = single_line_message("""
	Resolve the errors with other accounts of this customer.
""")
CHECKING_RSYNC_CONNECTIONS_WINDOWS = single_line_message("""
	Checking rsync connections between source windows servers and PPA IIS service nodes
""")
INTERNAL_ERROR_USER_DOES_NOT_EXIST_IN_SOURCE_MODEL = single_line_message("""
	Internal error: user %s exists in target model, but does not exist in source model
""")
ACCOUNT_AUTOMATICALLY_RESUMED = single_line_message("""
	The account #%s (domain %s) will be automatically resumed shortly after we suspend it. Skipped suspending it.
""")
HSPHERE_API_SOLUTION = multi_line_message("""
	Make sure that:
	1. You have enabled H-Sphere XML API.
	2. You have specified the actual TCP port the API is enabled on, in migration tool's configuration.
	3. The H-Sphere CP is running.
	4.The account in H-Sphere is in the expected status (active or suspended).
""")
FETCH_CONFIGURATION_DATA_FROM_SOURCE_PANEL = single_line_message("""
	Fetch configuration data from Source Panel
""")
INVALID_CHOICE_ENTER_YES_OR_NO = single_line_message("""
	Invalid choice: %s. Please enter yes or no.
""")
HSPHERE_INCONSISTENCY_PHYSICAL_SERVER_WITH_IP_DOES_NOT_EXIST = single_line_message("""
	H-Sphere CP database inconsistency: a physical server with IP %s does not exist
""")
HSPHERE_INCONSISTENCY_PHYSICAL_SERVER_FOR_LOGICAL_SERVER_IP_DOES_NOT_EXIST = single_line_message("""
	H-Sphere CP database inconsistency: a physical server corresponding to logical server IP %s does not exist
""")
TRANSFER_CUSTOMER_TO_PPA_BEFORE_BILLING = single_line_message("""
	Transfer this customer to PPA before transferring them to PPA Billing.
""")
NO_CUSTOMER_IN_PPA = single_line_message("""
	There is no customer with the username %s in PPA. Unable to import this customer into PPA Billing.
""")
UNABLE_IMPORT_CUSTOMER_INTO_BILLING = single_line_message("""
	Unable to import the customer with the username %s into PPA Billing: %s
""")
CALCULATING_DISK_SPACE_USAGE_SOURCE_UNIX = single_line_message("""
	Calculating disk space usage on the source unix servers
""")
INTERNAL_ERROR_CHECK_CONNECTION_FOR_UNKNOWN_CONTENT_TYPE = single_line_message("""
	Internal error: request to check the connection for unknown content type: '%s'
""")
FAILED_TO_FIND_SUBSCRIPTION_BY_NAME = single_line_message("""
	Failed to find subscription by name
""")
TEST_CALL_PPA_BILLING_API_FAILED = multi_line_message("""
	A test call of PPA Billing API failed: %s.
	Make sure that the PPA Billing is started and there are no firewall rules blocking access to its API.
""")
CHECKING_MSSQL_CONNECTIONS = single_line_message("""
	Checking Microsoft SQL connections between source SQL servers and PPA SQL service nodes
""")
UNABLE_TO_CALCULATE_MSSQL_DBS_SIZE = multi_line_message("""
	Unable to calculate the size of the following Microsoft SQL databases:
	%s
	 on the source server at %s:
	%s
	The migration tool will skip checking available disk space for these databases.
""")
UNABLE_TO_CALCULATE_WEB_DISK_SPACE = multi_line_message("""
	Unable to calculate the disk space used by web sites of user %s on source server at %s:
	%s
	The migration tool will skip checking available disk space for the corresponding subscription.
""")
BAD_OUTPUT_ESTIMATOR = single_line_message("""
	Malformed output from psoft.hsphere.tools.Estimator utility: %s
""")
CHECK_DISK_SPACE_TARGET_WINDOWS = single_line_message("""
	Checking if there is enough disk space on PPA windows service nodes
""")
ERROR_MAKING_BILLING_AND_CONTACT_INFO_BACKUP = single_line_message("""
	Error creating the tables for billing/contact information backup: %s
""")
CHECK_RSYNC_CONNECTION_OK = single_line_message("""
	Successfully checked the rsync connection between %s and the source server at %s
""")
UNABLE_FIND_DOMAIN_IN_HSPHERE = single_line_message("""
	Unable to find '%s' domain in Hsphere database.
""")
NOT_TRANSFERRED_STATS = single_line_message("""
	%d H-Sphere users with %d accounts were not transferred because of the issues listed above
""")
FAILED_IMPORT_GENERAL_INFO = single_line_message("""
	User %s migration failed on import of its general info
""")
ESTIMATED_BILLING_PERIOD_PAYMENT = single_line_message("""
	Estimated billing period payment
""")
BILLING_MOVE_CANNOT_BE_REVERTED_WARNING = multi_line_message("""
	You are about to finally transfer the selected accounts to PPA Billing. This move cannot be reverted.
	Enter 'yes' to confirm the transfer, 'no' to cancel it.
""")
CHECK_HSPHERE_API_RESUME_ACCOUNT = multi_line_message("""
	Make sure that:
	1. You have enabled H-Sphere XML API.
	2. You have specified the actual TCP port the API is enabled on, in migration tool's configuration.
	3. The H-Sphere CP is running.
	4. The account is in expected state (active or suspended) in H-Sphere.
""")
UNABLE_TO_SUSPEND_ACCOUNT = single_line_message("""
	Unable to safely suspend the account #%s (domain %s). According to the suspension rules of its vendor, it will be
	automatically resumed in a short while, and will continue to be charged the recurrent fees.
""")
CHECK_HSPHERE_API_RESTORE_ACCOUNT_INFO = multi_line_message("""
	Make sure that:
	1. You have enabled H-Sphere XML API.
	2. You have specified the actual TCP port the API is enabled on, in migration tool's configuration.
	3. The H-Sphere CP is running.
	Restart the H-Sphere CP to apply the changes.
""")
TRANSFER_ACCESS_RESTRICTION_SETTINGS_FOR_SITES = single_line_message("""
	Transfer access restriction settings for sites of subscription '%s'
""")
TRANSFER_SUCCESS_STATS = single_line_message("""
	All %d H-Sphere users with %d accounts were transferred successfully.
""")
TRANSFER_ACCESS_RESTRICTION_SETTINGS_OF_SITE = single_line_message("""
	Transfer access restriction settings of site '%s'
""")
UNABLE_CONNECT_HSPHERE_CP_DATABASE = multi_line_message("""
	Unable to connect to H-Sphere CP database: %s
	Make sure that:
	1. You have allowed access from PPA management node, in pg_hba.conf file on H-Sphere CP server.
	2. You have restarted postgresql service on H-Sphere CP server after that.
""")
INTERNAL_ERROR_OR_HSPHERE_CP_DATABASE_INCONSISTENCY = single_line_message("""
	Internal error, or H-Sphere CP database inconsistency: the query "%s" shall return some data, but returned nothing
""")
TRANSFER_IP_ACCESS_RESTRICTIONS = single_line_message("""
	Transfer IP access restrictions
""")
FETCH_DATA_FROM_SOURCE_HSPHERE = single_line_message("""
	Fetch data from source H-Sphere
""")
SKIPPED_COPYING_MAIL_CONTENT_DOMAIN_DOES_NOT_EXIST_ON_SOURCE = single_line_message("""
	Skipped copying mail content of domain %s because such mail domain does not exist on source server
""")
UNABLE_DETERMINE_PATH_TO_MAIL_DOMAIN_ON_SOURCE = multi_line_message("""
	Unable to determine the path to the mail domain %s on the source server at %s: %s
	%s
	The migration tool will not copy to PPA the mail content of this domain.
	Copy it manually.
""")
GET_HTTPDOCS_ON_SOURCE = single_line_message("""
	Get httpdocs of %s subscription on H-Sphere
""")
RSYNC_FAILED_TO_COPY_FILES_FROM_SOURCE = multi_line_message("""
	Rsync failed to copy files from the source (%s) to the target server (%s): %s
	1. This could happen because of a network connection issue.
								Retry copying the files with the help of the "copy-content" command.
	2. Check whether rsync is installed and configured on the source server.
""")
GET_HTTPDOCS_ON_TARGET_NODE = single_line_message("""
	Get httpdocs of '%s' subscription on target node
""")
CHANGE_SOURCE_IP_ADDRESS = single_line_message("""
	Change source ip address from '%s' to '%s'
""")
COPY_WEB_FILES_FROM_UNIX_SERVERS = single_line_message("""
	Copy web files from Unix servers
""")
CANNOT_DETERMINE_IP_ADDRESS_OF_SUBSCRIPTION = single_line_message("""
	Can not determine IP address of '%s' subscription. Most probably reason: subscription has not hosting.
""")
SUBSCRIPTION_HAS_NO_SYSUSER = single_line_message("""
	'%s' subscription does not have sys user, so skip content migration.
""")
COPY_CONTENT_FOR_MAIN_DOMAIN = single_line_message("""
	Copy content for main domain for '%s' subscription.
""")
DETECTED_SUBSCRIPTIONS_SERVER_IP = single_line_message("""
	Detected subscription's server ip - '%s'
""")
FAILED_TO_COPY_WEB_FILES = single_line_message("""
	Failed to copy web files for subscription '%s'
""")
DNS_FORWARDING_CONFIG_CANNOT_BE_UNDONE = single_line_message("""
	DNS forwarding configuration cannot be undone for this type of migration. You can revert the forwarding manually in
	the DNS server configuration if you want.
""")
REPORT_THAT_UNDO_DNS_FORWARDING_NOT_SUPPORTED = single_line_message("""
	Report that undo DNS forwarding for H-Sphere is not supported
""")
FAILED_TO_REPORT_THAT_UNDO_DNS_FORWARDING_NOT_SUPPORTED = single_line_message("""
	Failed to report that undo DNS forwarding for H-Sphere is not supported
""")
FAILED_REMOVE_MAIL_FOR_SUBDOMAINS_IN_BACKUP = single_line_message("""
	Failed to remove mail for subdomains in backup for subscription '%s'
""")
REMOVE_MAIL_FOR_SUBDOMAINS_IN_BACKUP = single_line_message("""
	Remove mail for subdomains in backup
""")
FAILED_TO_CHECK_MAIL_ON_SUBDOMAINS = single_line_message("""
	Failed to check mail on subdomains for subscription '%s'
""")
TARGET_DOES_NOT_SUPPORT_SUBDOMAIN_MAIL_ACCOUNT = single_line_message("""
	PPA does not support mail accounts on subdomains. The mail accounts of the following subdomains will not be
	transferred: %s
""")
PRESERVE_CONTENT_OF_MAILBOXES_IF_NECESSARY = single_line_message("""
	Preserve the content of these mailboxes, if necessary.
""")
TARGET_DOES_NOT_SUPPORT_SUBDOMAIN_MAIL_BOX = single_line_message("""
	PPA does not support mail accounts on subdomains. The mail boxes of the following subdomains will not be
	transferred: %s
""")
NO_BILLING_SERVICE_PLAN_SPECIFIED = single_line_message("""
	No billing service plan is specified for the subscription '%s' in the migration list file. The subscription will not
	be imported to PPAB.
""")
DOMAIN_SUBSCRIPTION_WAS_SUCCESSFULLY_IMPORTED_TO_BILLING = single_line_message("""
	Domain subscription '%s' was successfully imported to the billing
""")
DOMAIN_SUBSCRIPTION_WAS_ALREADY_IMPORTED_TO_BILLING = single_line_message("""
	Domain subscription '%s' was already imported to the billing, skip import
""")
FAILED_TO_IMPORT_SSL_SUBSCRIPTION_FOR_DOMAIN = single_line_message("""
	Failed to import the SSL subscription for the domain '%s': %s
""")
CUSTOMER_ALREADY_IMPORTED_TO_BILLING = single_line_message("""
	Customer '%s' was already imported to the billing, skip import
""")
SSL_CERTIFICATE_PROVIDER_OR_PRODUCT_NOT_SUPPORTED = multi_line_message("""
	The SSL certificate provider (code %s) or product (code %s) specified in the PPA Billing plan #%s are not supported by the migration tool.
	Edit the plan and choose one of these certificate providers: ENOM, OpenSRS, SSLStore, GlobalSign.
""")
HOSTING_SUBSCRIPTION_WAS_ALREADY_IMPORTED_TO_BILLING = single_line_message("""
	Hosting subscription '%s' was already imported to the billing, skip import
""")
SUBSCRIPTION_ALREADY_EXISTS = single_line_message("""
	Subscription #%s already exists
""")
INFO_ABOUT_DOMAIN_USERS_WAS_SUCCESSFULLY = single_line_message("""
	Information about domain users was successfully imported from registrars
""")
FAILED_TO_IMPORT_SSL_SUBSCRIPTION = single_line_message("""
	Failed to import the SSL subscription for the domain '%s': %s
""")
SSL_CERTIFICATE_SUBSCRIPTION_ALREADY_IMPORTED = single_line_message("""
	An SSL certificate subscription for domain %s was already imported, its identifier is: %s
""")
PERIOD_DOES_NOT_EXIST = single_line_message("""
	The period of %s %s%s does not exist for the service plan %s. Please define the period in service plan settings.
""")
COMODO_SSL_CERTIFICATE_FROM_HSPHERE = single_line_message("""
	Comodo SSL certificate from H-Sphere
""")
NO_DOMAIN_SERVICE_PLAN_WAS_SET_FOR_ZONE = multi_line_message("""
	No domain service plan was set for the zone %s.
	Please specify a correct domain service plan for the zone in the migration tool's configuration file, in the billing-domain-plans section.
	Otherwise the domain subscription will not be transferred.
""")
ADD_OR_REUSE_EXISTING_USERS = single_line_message("""
	Add or reuse existing users for domain subscription '%s'
""")
NO_PPAB_SSL_PLAN_IDENTIFIER_FOR_PRODUCT_IN_CONFIG = single_line_message("""
	No PPAB SSL plan identifier for the product '%s' was set in the migration tool's configuration file. The SSL
	subscription for the domain %s will not be imported to PPAB.
""")
CONFIGURE_PAYMENT_SETTINGS_FOR_CUSTOMER_MANUALLY = single_line_message("""
	Configure the payment settings for this customer manually after transfer.
""")
HSPHERE_INCONSISTENCY_SSL_CERTIFICATE_NOT_LINKED_TO_PRODUCT = single_line_message("""
	H-Sphere data inconsistency: the SSL certificate %s is not linked to an SSL certificate product. The non-certificate
	SSL products it is linked to: %s
""")
TRANSFER_CERTIFICATE_TO_BILLING_MANUALLY = single_line_message("""
	Transfer this certificate to PPA Billing manually.
""")
PURCHASING_PROCESS_WAS_NOT_COMPLETED_FOR_COMODO = single_line_message("""
	The purchasing process was not completed for the Comodo SSL certificate for the site %s. This certificate was not
	transferred.
""")
DISABLE_ENCRYPTION_CREDIT_CARD_DATA = multi_line_message("""
	Please disable the encryption of credit card data in H-Sphere.
	You can disable encryption by logging in as administrator and going to Settings > Payment Settings > CC Encryption page.
""")
CREDIT_CARD_DATA_ENCRYPTION_IS_ENABLED = single_line_message("""
	Encryption of credit card data is enabled in H-Sphere, which makes it impossible to transfer credit card data.
""")
MULTIPLE_ACTIVE_CREDIT_CARDS_NOT_SUPPORTED = single_line_message("""
	Multiple active credit cards are not supported. The card '%s' will not be active; the most used card '%s' will be
	used for all transactions.
""")
PAYMENT_SYSTEM_NOT_SUPPORTED = single_line_message("""
	The payment system '%s' used by the customer's account is not supported by PPAB. The credit card data for the card
	'%s' of that payment system will not be migrated.
""")
REVIEW_PAYMENT_SETTINGS_AFTER_TRANSFER = single_line_message("""
	Review the payment settings for this customer after transfer and correct them if necessary.
""")
