from parallels.target.plesk import messages
from parallels.source.plesk.actions.content.web.copy_unix_content import CopyUnixWebContent
from parallels.core.utils.common import cached


class ReSyncWebFilesAfterLiveMigration(CopyUnixWebContent):
	def get_description(self):
		return messages.ACTION_RESYNC_WEB_FILES_AFTER_LIVE_MIGRATION_DESCRIPTION

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.ACTION_RESYNC_WEB_FILES_AFTER_LIVE_MIGRATION_FAILURE

	def filter_subscription(self, global_context, subscription):
		"""
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return self._is_live_migration_option_enabled(global_context.config)

	@staticmethod
	@cached
	def _is_live_migration_option_enabled(config):
		"""
		:type config: ConfigParser.RawConfigParser
		"""
		return 'live-migration' in config.options('GLOBAL') \
			and config.getboolean('GLOBAL', 'live-migration')
