from parallels.core.utils.message_utils import single_line_message
from parallels.core.utils.message_utils import multi_line_message

DNS_SERVER_IS_NOT_REGISTERED_IN_PPA = single_line_message("""
	DNS server %s is not registered in PPA, consider it as external DNS server
""")
MIGRATION_TO_PPA_OF_THIS_VERSION_IS_NOT_SUPPORTED = single_line_message("""
	Migration to PPA %s is not supported. We strongly recommend that you install the latest version of PPA for
	migration. If you still want to migrate to PPA 11.1.x, please use the previous version of migration tools:
	http://autoinstall.plesk.com/PPA_11.1.0/migration-tools/ (not recommended).
""")
CLIENT_WAS_NOT_ADDED_INTO_SPECIAL_PPA_ACCOUNT = single_line_message("""
	Client '%s' should have been added into special_ppa_clients, but it is not so
""")
MAILBOX_QUOTA_SOLUTION = single_line_message("""
	Increase service template limit on the destination panel, or decrease mailbox quota on the source server and run
	migration tool with --reload-source-data option.
""")
SERVICE_TEMPLATE_HAS_NOT_ENOUGH_RESOURCES = single_line_message("""
	The service template #%s (named '%s', owned by account #%s) does not have enough resources to add the webspace '%s'
	into a new subscription based on that service template.
""")
CLIENT_MAPPED_TO_UNEXISTING_RESELLER = single_line_message("""
	Client is mapped to an unexisting reseller '%s'
""")
NEW_PASSWORD_FOR_AUX_USER = single_line_message("""
	A new password was generated for the auxiliary user '%s': '%s'. You can change the password for the corresponding
	auxiliary user in the destination panel once the data transfer is finished.
""")
DNS_ZONE_MANAGED_BY_EXT_DNS = single_line_message("""
	The DNS zone '%s' of this subscription is managed by an external server.
""")
SUBSCRIPTION_HAS_NO_PLAN_ID_AND_PLAN_NAME = single_line_message("""
	somehow, subscription '%s' has neither plan_id nor plan_name defined
""")
PPA_HAS_SPECIAL_CUSTOMER_ACCOUNT = single_line_message("""
	PPA has the special '{login}' customer account reserved for subscriptions owned by {owner}. As '{login}' already
	exists in PPA, all such subscriptions from this server will be transferred under this account.
""")
ROLE_WILL_NOT_BE_TRANSFERRED = single_line_message("""
	This role will not be transferred. The users with this role will be reassigned to the existing role. If you want to
	transfer the role, change its name.
""")
ASSIGN_SUBSCRIPTION_TO_SERVICE_TEMPLATE = single_line_message("""
	Assign the subscription to a service template using the migration list file.
""")
SUBSCRIPTION_ASSIGNED_TO_SERVICE_TEMPLATE_WITH_NO_FEATURE = single_line_message("""
	Subscription is assigned to a service template '%s' that has no '%s'
""")
DNS_SERVER_IN_SLAVE_MODE = single_line_message("""
	The DNS server in Plesk Panel works in the slave mode for the subscription's DNS zone '%s'.
""")
ROLE_FOR_AUX_USERS_EXISTS_ON_OTHER_SERVER = single_line_message("""
	A role '%s' for auxiliary users exists on the other server and has the different set of permissions
""")
UNABLE_TO_GET_AUXILIARY_USER_PASSWORD = single_line_message("""
	Unable to retrieve the auxiliary user's password as it is stored in the encrypted form
""")
SERVICE_TEMPLATE_MAY_HAVE_NOT_ENOUGH_RESOURCES = single_line_message("""
	The service template #%s (named '%s', owned by account #%s) may not have enough resources to add the webspace '%s'.
	For your convenience, the migration tool will allocate resources to a webspace even if they are not required by the
	subscription being transferred. However, because the order of creating webspaces is not defined, resources may be
	exhausted before creating a webspace for the subscription that requires them.
""")
ADJUST_LIMITS_OR_TRANSFER_IN_SINGLE_MODE_SOLUTION = single_line_message("""
	You can either adjust the subscription's limits on the hosting types: ({hostings_lacking}) and re-transfer this
	subscription, or transfer this subscription in the single-webspace mode.
""")
USER_WILL_NOT_BE_TRANSFERRED = single_line_message("""
	The user will not be transferred. If you want this user to be transferred, change its username.
""")
AUXILIARY_USER_ALREADY_EXISTS = single_line_message("""
	An auxiliary user with the username '%s' already exists in the destination panel
""")
CREATE_SERVICE_TEMPLATE_WITH_NAME = single_line_message("""
	Create a service template with this name, or assign subscription to other service template
""")
CUSTOMER_WITH_SPECIAL_USERNAME_ALREADY_EXISTS = single_line_message("""
	A customer with the special username '%s' already exists in PPA
""")
SUBSCRIPTION_IS_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
	Subscription '%s' is not listed in migration list, not including it into target model
""")
SUBSCRIPTION_IS_ASSIGNED_TO_SERVICE_TEMPLATE_WITH_BAD_MAIL_QUOTA = single_line_message("""
	Subscription is assigned to a service template '%s' that has mailbox quota limit (%s) less than mailbox quota of
	mailbox '%s' (%s). Mailbox can not be transferred.
""")
ONE_AUXILIARY_USER_WILL_BE_TRANSFERRED = single_line_message("""
	Only one auxiliary user will be transferred. The priority will be given to the user from the other server. If you
	want to transfer both users, rename one of them.
""")
ADD_MISSING_HOSTINGS_INTO_WEBSPACE = single_line_message("""
	Add missing hostings into that webspace manually and then re-transfer this subscription
""")
NO_SERVICE_TEMPLATE_WITH_SUCH_NAME = single_line_message("""
	%s does not have a service template named '%s', unable to make a subscription on it. Subscription will not be
	transferred.
""")
CONVERT_AUXILIARY_USER_ROLE = single_line_message("""
	Convert auxiliary user role '%s'
""")
ASSIGN_SUBSCRIPTION_TO_SERVICE_TEMPLATE_WITH_FEATURE = single_line_message("""
	Assign this subscription to a service template which offers %s.
""")
CLIENT_IS_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
	Client '%s' is not listed in migration list, not including it into target model
""")
CHECK_DNS_ZONES_OF_SUBSCRIPTION = single_line_message("""
	Check DNS zones of subscription '%s'
""")
SUBSCRIPTION_MAY_NOT_HAVE_ENOUGH_RESOURCES = single_line_message("""
	The subscription #%s may not have enough resources to add the webspace '%s'. For your convenience, the migration
	tool will allocate resources to a webspace even if they are not required by the subscription being transferred.
	However, because the order of creating webspaces is not defined, resources may be exhausted before creating a
	webspace for the subscription that requires them.
""")
ONE_ROLE_WILL_BE_TRANSFERRED = single_line_message("""
	Only one role will be transferred. The priority will be given to the role from the other server. If you want to
	transfer both roles separately, rename one of them.
""")
AUXILIARY_USER_WITH_DIFFERENT_CONTACT_INFO = single_line_message("""
	An auxiliary user with the username '%s' but different contact information exists on the other server
""")
IDN_DOMAIN_ADMIN_WILL_NOT_BE_TRANSFERRED = single_line_message("""
	Domain administrator of domain '%s' will not be migrated: migration of domain administrators for IDN domains is not
	supported.
""")
SUBSCRIPTION_DOES_NOT_HAVE_ENOUGH_RESOURCES = single_line_message("""
	The subscription #%s does not have enough resources to add the webspace '%s'
""")
SPECIAL_CLIENT_HAS_NO_SUBSCRIPTIONS_ASSIGNED = single_line_message("""
	Special client '%s' has no subscriptions assigned to it, not including it into target model
""")
WEBSPACE_ALREADY_EXISTS_BUT_DOES_NOT_INCLUDE_HOSTINGS = single_line_message("""
	The webspace '%s' already exists, but does not include the following hostings: %s
""")
TRANSFER_OF_INSTANT_MESSENGER_FIELD_NOT_SUPPORTED = single_line_message("""
	The transfer of the instant messenger field in the contact information is not supported
""")
CUSTOMER_DOES_NOT_EXIST = single_line_message("""
	Customer '%s' does not exist in source or in destination panel, subscription will not be transferred.
""")
SKIP_CHECKING_DNS_ZONE_OF_DOMAIN = single_line_message("""
	Skip checking DNS zone of domain '%s': it has no DNS zone
""")
CHANGE_DNS_RECORDS_MANUALLY_ON_EXT_DNS = single_line_message("""
	Once the transfer is finished, manually change DNS records on the external DNS server(s) (including MX records) and
""")
MIGRATE_ADDITIONAL_CONTACT_INFO_FIELD_MANUALLY = single_line_message("""
	Migrate additional contact information field manually
""")
RUN_TOOL_WITH_COPY_MAIL_CONTENT_COMMAND = single_line_message("""
	run the tool with the 'copy-mail-content' command to complete mail content sync.
""")
ROLE_FOR_AUXILIARY_USERS_ALREADY_EXISTS_WITH_DIFFERENT_PERMISSIONS = single_line_message("""
	A role '%s' for auxiliary users already exists in the destination panel and has the different set of permissions
""")
SUBSCRIPTION_NOT_ASSIGNED_TO_SERVICE_TEMPLATE = single_line_message("""
	This subscription is not assigned to any service template. Migration of such subscriptions is not supported
""")
FORM_UP_TARGET_MODEL = single_line_message("""
	Form up target model objects based on source backups
""")
ADJUST_SERVICE_TEMPLATES_LIMITS = single_line_message("""
	You can adjust this service template's limits on the hosting types: ({hostings_lacking}) and re-transfer this
	subscription; or you can transfer this subscription in the single-webspace mode.
""")
SOLUTION_CREATE_RESELLER_IN_DESTINATION_PANEL = single_line_message("""
	Create this reseller in destination panel, or map client to some existing reseller
""")
SOLUTION_CREATE_CUSTOMER_WITH_SUCH_LOGIN_MANUALLY = single_line_message("""
	Create the customer with such login manually, or map subscription to any other existing customer.
""")
TRANSFER_OF_ADDITIONAL_CONTACT_INFO_FIELD_NO_SUPPORTED = single_line_message("""
	The transfer of the additional contact information field is not supported
""")
CLIENT_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
	Client '%s' is not listed in migration list, not including its aux users into target model
""")
CHANGE_DNS_RECORDS_ON_EXT_DNS = single_line_message("""
	Once the transfer is finished, manually change DNS records on the external DNS server(s).
""")
MIGRATOR_INTERNAL_ERROR_ACCOUNT_OF_UNSUPPORTED_TYPE = single_line_message("""
	Migrator internal error: trying to get PPA accounts with unsupported type '%s'
""")
MIGRATOR_HAS_NO_INFO_ABOUT_WEBSPACE_PROVISIONING = single_line_message("""
	Migrator has no information about this webspace provisioning, as if it was created manually.
""")
SUBSCRIPTION_HAS_NOT_ENOUGH_RESOURCES_TO_CREATE_WEBSPACE = single_line_message("""
	Subscription #%d has not enough resources to create webspace '%s'. Following hostings are missing: %s
""")
INTERNAL_ERROR_MISSING_REQUEST_ID = single_line_message("""
	Internal error: a webspace was just created, but the corresponding request_id was not saved
""")
CHECK_TARGET_POA_API_CONNECTION = single_line_message("""
	Check target POA API connection
""")
FAILED_TO_CHECK_POA_API = multi_line_message("""
	Failed to check POA API at %s: %s. Make sure that PPA Public API is configured and there are no firewall rules that could block connections to it.
	Also the issue might be caused by incorrect PPA Public API configuration. Please verify settings at: "System" - "Settings" - "Public API":
	1. "SSL" should be enabled.
	2. "HTTP Authentication" should be enabled.
	3. "Accept connections" should have one of the values:
	   1) "Only from allowed networks". In that case you should add host where you run migration/moving tools to allowed hosts at "Allowed Networks" tab.
	   2) "From everywhere". No additional configuration is required in that case, still this option is not recommended due to security considerations.
""")
TRYING_TO_GET_RUNNER_FOR_EXTERNAL = single_line_message("""
	Trying to get runner for external database server. Running commands on external database server is not implemented.
""")
TRYING_TO_GET_OS_TYPE_FOR_EXT_DB = single_line_message("""
	Trying to get OS type for external database server. Getting OS type for external database server is not implemented.
""")
EXTERNAL_DATABASE_SERVER_IS_NOT_PPA_SN = single_line_message("""
	External database server is not a PPA service node, so we cannot get target server object for it.
""")
