from plesk_mail_migrator.core.provider.base_provider import BaseProvider


# noinspection PyAbstractClass
class RestoreProvider(BaseProvider):
    def list_message_ids(self, account):
        """List IDs of messages that were already migrated (already exist on the target server).
        That list is used on the source server to avoid backing up and transferring messages that
        were already transferred.

        See "How the tool works with message IDs" in README for more details.

        :param plesk_mail_migrator.core.entities.mail_account.MailAccount account:
            Account for which we should list existing message IDs
        :rtype: list[str]
        """
        raise NotImplementedError()

    def do_restore_message(self, account, message):
        """Restore specified mail message for specified mail account.

        :param plesk_mail_migrator.core.entities.mail_account.MailAccount account:
            Account to which message should be restored
        :param plesk_mail_migrator.core.entities.mail_message.MailMessage message:
            Mail message that should be restored
        :rtype: None
        """
        raise NotImplementedError()
