from plesk_mail_migrator.providers.imap.provider import IMAPProvider
from plesk_mail_migrator.providers.maildir.provider import MaildirProvider


class ProviderFactory(object):
    PROVIDER_IMAP = IMAPProvider()
    PROVIDER_MAILDIR = MaildirProvider()

    @classmethod
    def get_backup_providers(cls):
        """Get all backup providers

        :rtype: list[plesk_mail_migrator.core.provider.backup_provider.BackupProvider]
        """
        return [cls.PROVIDER_IMAP]

    @classmethod
    def get_restore_providers(cls):
        """Get all restore providers

        :rtype: list[plesk_mail_migrator.core.provider.restore_provider.RestoreProvider]
        """
        return [cls.PROVIDER_MAILDIR]

    @classmethod
    def get_all_providers(cls):
        """Get all providers - both backup and restore ones

        :rtype: list[plesk_mail_migrator.core.provider.base_provider.BaseProvider]
        """
        return [cls.PROVIDER_IMAP, cls.PROVIDER_MAILDIR]
