from plesk_mail_migrator.core.dumps.dump_writer import DumpWriter
from plesk_mail_migrator.core.entities.mail_message import MailMessage


class QueueDumpWriter(DumpWriter):
    def __init__(self, queue):
        self._queue = queue

    def dump_from_contents(self, message_id, folder, flags, contents):
        """Add mail message to dump. We have message as a string

        :param str|None message_id: Message identifier.
            Check "How the tool works with message IDs" in README for details.
        :param str folder: IMAP folder of the message
        :param IMAPFlags flags: IMAP flags of the message
        :param str contents: String that contains the message
        :return:
        """
        self._queue.put(MailMessage(message_id, folder, flags, contents), True)
