from plesk_mail_migrator.utils.string_utils import is_empty


class MailMessageFolderUtils(object):
    """Utilities for working with IMAP folder names"""

    # Universal folder delimiter that is used in mail message dumps
    DUMP_FOLDER_DELIMITER = "<?FolderDelimiter?>"

    # Folder delimiter that is usually used in mail servers
    DEFAULT_DELIMITER_USED_IN_PROVIDERS = "\\"

    @classmethod
    def pack_default(cls, folder_name):
        """Convert concrete folder name to standard dump representation, with default delimiter in concrete folder name.

        By default delimiter we mean "\".

        :param str folder_name: Concrete folder name
        :return str: Standard dump representation of folder name
        """
        return cls.pack(folder_name, cls.DEFAULT_DELIMITER_USED_IN_PROVIDERS)

    @classmethod
    def pack(cls, folder_name, delimiter):
        """Convert concrete folder name to standard dump representation

        :param str folder_name: Concrete folder name
        :param str delimiter: Delimiter that is used in concrete folder name
        :return str: Standard dump representation of folder name
        """
        if not is_empty(folder_name) and not is_empty(delimiter):
            return folder_name.replace(delimiter, cls.DUMP_FOLDER_DELIMITER)
        else:
            return folder_name

    @classmethod
    def unpack(cls, folder_name, delimeter):
        if not is_empty(folder_name) and not is_empty(delimeter):
            return folder_name.replace(cls.DUMP_FOLDER_DELIMITER, delimeter)
        else:
            return folder_name
