
class ProviderParameter(object):
    def __init__(self, name, description, value=None, help_value=None):
        self._name = name
        self._description = description
        self._value = value
        if help_value is None:
            self._help_value = name
        else:
            self._help_value = help_value

    @property
    def name(self):
        return self._name

    @property
    def description(self):
        return self._description

    @property
    def value(self):
        return self._value

    @value.setter
    def value(self, value):
        self._value = value

    @property
    def help_value(self):
        return self._help_value
