<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

class Agent {
    public static function autoload($class) {
        $pattern = '/(?<!^)([A-Z])/';
        if ('Task' != $class && substr($class, -4) == 'Task') {
            $file_name = strtolower(preg_replace($pattern, '_$1', substr($class, 0, -4))) . '.php';
            $file_path = 'task' . DIRECTORY_SEPARATOR . $file_name;
        } else if (substr($class, -5) == 'Utils') {
            $file_name = strtolower(preg_replace($pattern, '_$1', substr($class, 0, -5))) . '.php';
            $file_path = 'lib' . DIRECTORY_SEPARATOR . 'utils' . DIRECTORY_SEPARATOR . $file_name;
        } else {
            $file_name = strtolower(preg_replace($pattern, '_$1', $class)) . '.php';
            $file_path = 'lib' . DIRECTORY_SEPARATOR . $file_name;
        }
        /** @noinspection PhpIncludeInspection */
        if (file_exists($file_path)) {
            require_once($file_path);
        }
    }

    public static function create_dispatcher() {
        return new Dispatcher();
    }
}