<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

/**
 * Class to return results of task execution to client in JSON format.
 */
class ResultEncoderJsonPlain extends ResultEncoder
{
    private $_data;
    private $_itemsCountStack;
    private $_level = 0;

    public function __construct()
    {
        $this->_itemsCountStack = array(0);
    }

    public function startList()
    {
        $this->_itemsCountStack[] = 0;
        $this->_level++;
        $this->_data .= '[';
    }

    public function endList()
    {
        array_pop($this->_itemsCountStack);
        $this->_level--;
        $this->_data .= ']';
    }

    public function startDictionary()
    {
        $this->_itemsCountStack[] = 0;
        $this->_level++;
        $this->_data .= '{';
    }

    public function endDictionary()
    {
        array_pop($this->_itemsCountStack);
        $this->_level--;
        $this->_data .= '}';
    }

    public function addString($str)
    {
        $this->_data .= $this->_encodeString($str);
    }

    public function addBoolean($b)
    {
        $this->_data .= ($b ? 'true' : 'false');
    }

    public function addNull()
    {
        $this->_data .= 'null';
    }

    public function addInt($int)
    {
        $this->_data .= $int;
    }

    public function addRawValue($raw)
    {
        $this->_data .= $raw;
    }

    public function startDictionaryValue($key)
    {
        if ($this->_itemsCountStack[$this->_level] > 0) {
            $this->_data .= ',';
        }
        $this->_data .= $this->_encodeString($key) . ':';
        $this->_itemsCountStack[$this->_level]++;
    }

    public function startListValue()
    {
        if ($this->_itemsCountStack[$this->_level] > 0) {
            $this->_data .= ',';
        }
        $this->_itemsCountStack[$this->_level]++;
    }

    protected function _encodeString($str)
    {
        return json_encode($str);
    }

    public function getData()
    {
        return $this->_data;
    }
}