<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

abstract class Task {
    private $_data;

    public function __construct($data) {
        $this->_data = $data;
    }

    public function __get($name) {
        if (!isset($this->_data[$name])) {
            throw new Exception('Task tries to access undefined property "' . $name . '"');
        }
        return $this->_data[$name];
    }

    protected function getIfExist($name, $default=null) {
        if (!isset($this->_data[$name])) {
            return $default;
        } else {
            return $this->_data[$name];
        }
    }

    abstract public function run(ResultEncoder $resultEncoder);
}