<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

/**
 * @property $base_path
 * @property $is_recursive
 */
class GetFilePathsTask extends Task {
    /**
     * Retrieve list of file names in given directory
     *
     * @param ResultEncoder $resultEncoder
     */
    public function run(ResultEncoder $resultEncoder) {
        $resultEncoder->startList();
        $this->_addItems($resultEncoder, $this->base_path);
        $resultEncoder->endList();
    }

    private function _addItems(ResultEncoder $resultEncoder, $path)
    {
        $handle = FileUtils::open_dir($path);

        if (is_null($handle)) {
            return;
        }

        $phpFunctions = Registry::get_instance()->get_php_functions();

        while (false !== ($item = $phpFunctions->readdir($handle))) {
            if ($item == '.' || $item == '..') {
                continue;
            }

            $item_path = $path . DIRECTORY_SEPARATOR . $item;
            if ($phpFunctions->is_file($item_path)) {
                $resultEncoder->startListValue();
                $resultEncoder->addString($item_path);
            } elseif ($this->is_recursive) {
                $this->_addItems($resultEncoder, $item_path);
            }
        }
    }
}