<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

/**
 * @property $file_path
 */
class IsFileExistsTask extends Task {
    /**
     * Check if file with given path exists on file system
     *
     * @param ResultEncoder $resultEncoder
     */
    public function run(ResultEncoder $resultEncoder) {
        $phpFunctions = Registry::get_instance()->get_php_functions();
        $resultEncoder->addBoolean(
            $phpFunctions->file_exists($this->file_path)
        );
    }
}