<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

/**
 * @property $file_path
 */
class RemoveFileTask extends Task {
    /**
     * Remove file by given path on file system
     *
     * @param ResultEncoder $resultEncoder
     */
    public function run(ResultEncoder $resultEncoder) {
        $phpFunctions = Registry::get_instance()->get_php_functions();
        if ($phpFunctions->file_exists($this->file_path)) {
            $phpFunctions->unlink($this->file_path);
        }
        $resultEncoder->addNull();
    }
}