<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Acesso negado. A sua conta foi suspensa.",
    'login_up__login_has_been_locked' => "Você tentou entrar utilizando demasiadas vezes uma palavra-passe incorreta. Por razões de segurança, não será possível entrar com este nome de utilizador por algum tempo.",
    'login_up__login_label_plesk' => "Login no %1", // PFU
    'login_up__login_label_parallels' => "Login no Plesk %1",
    'login_up__login_text' => "Insira o seu nome de utilizador e a palavra-passe.",
    'login_up__unable_to_check_pass' => "Impossível verificar senha: %1",
    'login_up__warning_limits_licence_key' => "Um dos seguintes itens excedeu o limite definido pela sua chave de licença: número de contas de utilizadores, domínios, contas de correio ou utilizadores web alojados no seu servidor.\nContacte o departamento de vendas da Plesk para adquirir uma chave que lhe permitirá acolher o número desejado de utilizadores e domínios. Contacte com o departamento de assistência técnica da Plesk se considerar que recebeu esta mensagem por engano.\nO limite licenciado para contas de utilizadores/domínios/contas de correio/utilizadores web/pacotes de idioma: %2.\nO número de contas de utilizadores/domínios/contas de correio/utilizadores web/pacotes de idioma atualmente alojados: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "A quantidade de recursos operados excedeu os limites definidos pela sua licença de produto atual. Contacte o departamento de vendas da Plesk e adquira uma nova chave de licença.",
    'login_up__grace_period' => 'Está a operar actualmente dentro do período de graça da sua licença de produto. Para actualizar a licença do seu produto seleccione opção de Obter Chaves na %1Página da Gestão da Licença%2.',
    'login_up__partner_license_message' => 'Está a operar actualmente com uma licença de produto limitada, que requer o registo antes de activar todas as suas funcionalidades. Para actualizar a licença do seu produto seleccione a opção de Obter Chaves na %1Página da Gestão da Licença%2.',
    'login_up__system_admin_disabled' => 'O superutilizador (conta raiz ou do administrador) está proibido de efetuar login no Plesk por razões de segurança.',
    'login_up__mobile_application_message' => 'Para uma melhor experiência, recomendamos que instale a aplicação %%name%%.',
    'login_up__mobile_application_install' => 'Instalar agora',
    'login_up__mobile_application_hide' => 'Não, obrigado',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Guia do Administrador do Plesk",
    'plesk_guide_reseller' => "Guia do Revendedor do Plesk",
    'plesk_guide_client' => "Guia do Cliente do Plesk",
    'plesk_guide_domain_admin' => "Guia do Administrador de Domínio do Plesk",
    'plesk_guide_mailuser' => "Guia do Utilizador de E-mail do Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Pesquisar', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Clientes',
    'ui__reseller_unknown__quick-search' => 'Revendedores',
    'ui__client/domain_unknown__quick-search' => 'Domínios',
    'nav__general' => 'Menu Principal',
    '__home' => 'Início',
    '__resellers' => 'Revendedores',
    '__clients' => 'Clientes',
    '__domains' => 'Domínios',
    '__applications' => 'Aplicações',
    '__settings' => 'Configurações',
    'nav__system' => 'Sistema',
    '__master' => 'Mestre',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Nível Superior',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Eliminar',
    'bt_make_default' => 'Estabelecer como Predefinido',

    // common list object operation errors
    'class_cList__empty_selection' => 'Sem objectos seleccionados.',

    // common list object search keys
    'clist__search_show' => 'Exibir Procura',
    'clist__search_hide' => 'Ocultar Procura',

    'bt_show_all' => "Reiniciar pesquisa",

    // common object list info keys
    'clist__first' => 'Primeiro',
    'clist__last' => 'Último',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Páginas',
    'clist__page_size' => 'Entradas por página',
    'clist__info' => '%1 Total: %4',
    'clist__info_empty' => 'Sem %1',
    'clist__info_filter' => 'encontrado %5 %1 (total %4)',
    'clist__info_paging' => '%2-%3 %1 de %4 total',
    'clist__info_paging_filter' => 'encontrado %2-%3 %1 de %5 (total %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Ativo',
    '__object_off' => 'Suspenso',

    '__home_description' => 'Voltar á Página Principal.',
    'indicator_title' => '%1% utilizadas, %2% livres', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Foi solicitado um URL inválido.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Contas de Revenda",
    'ui__reseller_unknown__title' => "Contas de Revenda",
    'ui__reseller_unknown__description' => "Gerir contas de revenda.",
    'ui__reseller/client_unknown__short-title' => 'Contas de Cliente',
    'ui__reseller/client_unknown__title' => 'Contas de Cliente',
    'ui__reseller/client_unknown__description' => 'Administre as contas de cliente.',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => 'Atribuir Novo Proprietário às Contas de Cliente',
    'ui__reseller/client/chowner_multi-select__short-title' => 'Atribuir Novo Proprietário',
    'ui__reseller/client/chowner_multi-select__description' => 'Atribuir um novo proprietário às contas de cliente selecionadas.',
    'ui__client/to-reseller_multi__title' => 'Converter contas de cliente para contas de revendedor',
    'ui__client/to-reseller_multi__short-title' => 'Converter para revendedores',
    'ui__client/to-reseller_multi__description' => 'Converter as contas de cliente selecionadas para contas de revendedor.',
    'ui__reseller/to-client_multi__title' => 'Converter contas de revendedor para contas de cliente',
    'ui__reseller/to-client_multi__short-title' => 'Converter para clientes',
    'ui__reseller/to-client_multi__description' => 'Converter as contas de revendedor selecionadas para contas de cliente.',
    'ui__admin-alias_unknown__title' => "Contas de administração adicionais", // PFW
    'ui__admin-alias_unknown__short-title' => "Contas de administração adicionais", // PFW
    'ui__admin-alias_unknown__description' => "Visualizar e gerir as contas adicionais de administrador.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Definições do Servidor de Correio",
    'ui__server/mail__title' => "Definições do Servidor de Correio",
    'ui__server/mail__description' => "Configurar o servidor de correio e definições de correio de todo o servidor.",
    'ui__server/dns__short-title' => 'Configuração DNS',
    'ui__server/dns__title' => 'Configuração DNS',
    'ui__server/dns__description' => 'Verificar e actualizar definições de DNS do servidor.',
    'ui__server/components__short-title' => 'Componentes do Servidor',
    'ui__server/components__title' => 'Componentes do Servidor',
    'ui__server/components__description' => 'Ver informações sobre as componentes do sistema instaladas no servidor e utilizadas pelo Plesk.',
    'ui__server/services__short-title' => 'Gestão de Serviços',
    'ui__server/services__title' => 'Gestão de Serviços',
    'ui__server/services__description' => 'Iniciar, interromper ou reiniciar os serviços do Plesk.',
    'ui__server/db__short-title' => 'Servidores de Base de Dados',
    'ui__server/db__title' => 'Servidores de Base de Dados',
    'ui__server/db__description' => 'Ver e gerir servidores de base de dados a nível de servidor.',
    'ui__server/crontab/task_unknown__short-title' => 'Tarefas agendadas',
    'ui__server/crontab/task_unknown__title' => 'Tarefas agendadas',
    'ui__server/crontab/task_unknown__description' => 'Adicionar e remover tarefas agendadas a nível de servidor.',
    'ui__server/ip-address_unknown__short-title' => 'Endereços IP',
    'ui__server/ip-address_unknown__title' => 'Endereços IP',
    'ui__server/ip-address_unknown__description' => 'Ver, adicionar e remover endereços IP, atribuir endereços IP a revendedores.',
    'ui__promotion/smartermail__short-title' => 'Descarregar SmarterMail',
    'ui__promotion/smartermail__title' => 'Descarregar SmarterMail',
    'ui__promotion/smartermail__description' => 'Abrir uma nova janela com o site SmarterMail, onde é possível descarregar a última versão do servidor de correio SmarterMail. O site SmarterMail é produzido e suportado pelo SmarterTools Inc. O Plesk não é responsável pelos conteúdos do website SmarterMail, nem fornece assistência para o servidor de correio SmarterMail Lite.',
    // dropdowns
    'ui__server/tsclient__short-title' => 'Desktop Remoto',
    'ui__server/tsclient__title' => 'Desktop Remoto',
    'ui__server/tsclient__description' => 'Aceda ao servidor pelo Remote Desktop.',
    'ui__server/time__title' => 'Hora do sistema',
    'ui__server/time__short-title' => 'Hora do sistema',
    'ui__server/time__description' => 'Mudar a data e hora do sistema, definir a sincronização com um servidor de NTP.',
    'ui__server/odbc__title' => 'Fontes de dados ODBC', // PFW
    'ui__server/odbc__short-title' => 'Fontes de dados ODBC', // PFW
    'ui__server/odbc__description' => 'Configurar fontes de dados ODBS.', // PFW
    'ui__server/ftp-settings__short-title' => "Definições de FTP", // PFW
    'ui__server/ftp-settings__title' => "Definições de FTP", // PFW
    'ui__server/ftp-settings__description' => "Configurar as definições de FTP a nível de servidor.", // PFW
    'ui__server/maillists__title' => 'Configurar o servidor de listas de envio', // PFU
    'ui__server/maillists__short-title' => 'Configurar o servidor de listas de envio', // PFU
    'ui__server/maillists__description' => 'Configurar o servidor de listas de envio Mailman.', // PFU
    'ui__mass-email__short-title' => "Mensagens de e-mail em massa", // PFW
    'ui__mass-email__title' => "Mensagens de e-mail em massa", // PFW
    'ui__mass-email__description' => "Enviar mensagens de e-mail para vários utilizadores de uma vez.", // PFW
    'ui__mass-mail__title' => 'Mensagens de e-mail em massa', // PFU
    'ui__mass-mail__short-title' => 'Mensagens de e-mail em massa', // PFU
    'ui__mass-mail__description' => 'Enviar mensagens de e-mail para vários utilizadores de uma vez.', // PFU
    'ui__server/spam-filter__title' => 'Definições do filtro spam',
    'ui__server/spam-filter__short-title' => 'Definições do filtro spam',
    'ui__server/spam-filter__description' => 'Configurar o filtro spam a nível de servidor.',
    'ui__server/preferences__title' => "Configurações do servidor",
    'ui__server/preferences__short-title' => "Configurações do servidor",
    'ui__server/preferences__description' => "Configurar o cálculo das estatísticas do servidor, alterar o nome de host do servidor e alterar outras configurações do servidor.",

    // interface
    // icons
    'ui__logo__short-title' => 'Personalização do Plesk',
    'ui__logo__title' => 'Personalização do Plesk',
    'ui__logo__description' => 'Personalize o Plesk alterando a imagem de logótipo e a barra de título do navegador.',

    // help & support
    // icons
    'ui__support__short-title' => 'Suporte',
    'ui__support__title' => 'Suporte',
    'ui__support__description' => 'Apresentar uma requisição de suporte técnico ou rever os bilhetes de suporte feitos pelos seus clientes.',
    'ui__license__short-title' => 'Gerir Licença',
    'ui__license__title' => 'Gestão de Licenças do Plesk',
    'ui__license__description' => 'Ver informações sobre a sua licença do Plesk e solicitar novas chaves de licença.',
    'ui__help__short-title' => 'Ajuda',
    'ui__help__title' => 'Ajuda on-line',
    'ui__help__description' => 'Ver ajuda on-line.',
    'ui__news__short-title' => "Que há de novo",
    'ui__news__title' => "Que há de novo",
    'ui__news__description' => "Veja a lista das modificações nesta versão do Plesk.",
    'ui__server/autoinstaller__short-title' => 'Actualizações',
    'ui__server/autoinstaller__title' => 'Actualizações',
    'ui__server/autoinstaller__description' => 'Atualizar o Plesk ou as suas componentes.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domínios',
    'ui__client/domain_unknown__title' => 'Domínios',
    'ui__client/domain_unknown__description' => 'Gerir domínios.',
    'ui__server/skeleton__short-title' => 'Modelo de Alojamento Virtual',
    'ui__server/skeleton__title' => 'Modelo de Alojamento Virtual',
    'ui__server/skeleton__description' => 'Especifique os ficheiros e pastas que devem ser colocados nos directórios ao criar os novos domínios.',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => 'Criar domínio',
    'ui__client/domain/properties_unknown-new__short-title' => 'Criar domínio',
    'ui__client/domain/properties_unknown-new__description' => 'Criar e configurar um domínio.',
    'ui__client/domain/chowner_multi-select__title' => 'Atribuir novo proprietário as assinaturas',
    'ui__client/domain/chowner_multi-select__short-title' => 'Atribuir novo proprietário da assinatura',
    'ui__client/domain/chowner_multi-select__description' => 'Atribuir novo proprietário aos assinaturas selecionadas',
    'ui__client/domain/to-client_multi__title' => 'Converter Contas de Administrador de Domínio para Contas de Cliente',
    'ui__client/domain/to-client_multi__short-title' => 'Converter para Clientes',
    'ui__client/domain/to-client_multi__description' => 'Converter as contas de administrador de domínio selecionadas para contas de cliente',
    'ui__client/domain/disable_multi__title' => 'Suspender domínios',
    'ui__client/domain/disable_multi__short-title' => 'Suspender domínios',
    'ui__client/domain/disable_multi__description' => 'Suspender domínios seleccionados',
    'ui__client/domain/enable_multi__title' => 'Ativar domínios',
    'ui__client/domain/enable_multi__short-title' => 'Ativar domínios',
    'ui__client/domain/enable_multi__description' => 'Ativar os domínios selecionados',

    // icons
    'ui__admin/extras-domain__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Ferramentas do MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Obtenha ferramentas e serviços adicionais do MyPlesk.com',
    'ui__server/aspdotnet__short-title' => 'Definições de ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Definições de ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Configurar as definições do ASP.NET a nível de servidor.', // PFW
    'ui__server/sitebuilder__short-title' => 'Configurações do Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Configurações do Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Configurar o Presence Builder para editar páginas web alojadas neste servidor.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Registar Domínio',
    'ui__admin/register-domain__short-title' => 'Registar Domínio',
    'ui__admin/register-domain__description' => 'Registar um nome de domínio pelo MuPlesk.com.',
    'ui__admin/manage-domain__title' => 'Gerir Domínio',
    'ui__admin/manage-domain__short-title' => 'Gerir Domínio',
    'ui__admin/manage-domain__description' => 'Gerir os nomes dos domínios registados pelo MyPlesk.com.',
    'ui__server/register__title' => 'Registar o seu servidor',
    'ui__server/register__short-title' => 'Registar servidor',
    'ui__server/register__description' => 'Registe o seu servidor para se juntar a um programa filiado.',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Registo de ações',
    'ui__actionlog__title' => 'Registo de ações',
    'ui__actionlog__description' => 'Descarregar o Registo de ações e gerir as definições do log de acções.',
    'ui__notification_unknown__short-title' => 'Avisos',
    'ui__notification_unknown__title' => 'Avisos',
    'ui__notification_unknown__description' => 'Visualizar e editar as notificações enviadas sobre eventos importantes do Plesk.',
    'ui__server/resources__short-title' => 'Utilização dos Recursos',
    'ui__server/resources__title' => 'Utilização dos Recursos',
    'ui__server/resources__description' => 'Ver a utilização dos recursos do sistema.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Informação do Servidor',
    'ui__server/statistics__title' => 'Informação do Servidor',
    'ui__server/statistics__description' => 'Estatísticas dos serviços geridos pelo Plesk.',
    'ui__admin/report__title' => 'Relatório resumido',
    'ui__admin/report__short-title' => 'Relatório resumido',
    'ui__admin/report__description' => 'Ver o relatório da utilização do tráfego e recursos dos revendedores, clientes e domínios.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Tempo de Inactividade da Sessão',
    'ui__sessions/properties__title' => 'Tempo de Inactividade da Sessão',
    'ui__sessions/properties__description' => 'Definir o tempo limite para sessões do Plesk.',
    'ui__cp-access__short-title' => 'Acesso ao Plesk',
    'ui__cp-access__title' => 'Acesso ao Plesk',
    'ui__cp-access__description' => 'Restringir o acesso ao Plesk.',
    'ui__sessions__short-title' => 'Sessões Activas',
    'ui__sessions__title' => 'Sessões Activas',
    'ui__sessions__description' => 'Ver sessões ativas do Plesk.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Certificados SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Certificados SSL/TLS',
    'ui__server/certificate_unknown__description' => 'A lista de certificados SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Dados Pessoais',
    'ui__admin-info__title' => 'Dados Pessoais',
    'ui__admin-info__description' => 'Mudar os dados pessoais da sua conta.',
    'ui__admin-password__short-title' => 'Alterar senha',
    'ui__admin-password__title' => 'Mudar senha',
    'ui__admin-password__description' => 'Mudar a senha da sua conta.',
    'ui__admin/interface__short-title' => 'Preferências de interface',
    'ui__admin/interface__title' => 'Preferências do interface de administração',
    'ui__admin/interface__description' => 'Alterar as preferências de interface do administrador do servidor.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'Gestor de ficheiros',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'Gestor de ficheiros',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'Trabalhe os ficheiros e diretórios com o gestor de ficheiros.',
    'ui__client/domain/hosting/tsclient_unknown__short-title' => 'Desktop remoto', // PFW
    'ui__client/domain/hosting/tsclient_unknown__title' => 'Desktop remoto', // PFW
    'ui__client/domain/hosting/tsclient_unknown__description' => 'Acesso ao servidor pelo desktop Remoto.', // PFW
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'Utilizar o terminal de SSH para aceder ao servidor.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Directórios protegidos por senha',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Directórios protegidos por senha',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Proteger acesso a áreas selecionadas da página web.',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => 'Directórios virtuais', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => 'Directórios virtuais', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => 'Criar e gerir directórios virtuais num domínio.', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Diretórios Virtuais', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Diretórios Virtuais', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Trabalhar com ficheiros e diretórios físicos e virtuais numa página web.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => 'Estatísticas de rede',
    'ui__client/domain/report/web-stats_unknown__title' => 'Estatísticas de rede',
    'ui__client/domain/report/web-stats_unknown__description' => 'Ver estatísticas de visitas à página web.',
    'ui__reseller/limits__short-title' => 'Utilização dos Recursos',
    'ui__reseller/limits__title' => 'Utilização dos Recursos',
    'ui__reseller/limits__description' => 'Ver e gerir a utilização de recursos do revendedor %1.',
    'ui__reseller/limits_unknown__short-title' => 'Utilização de Recursos',
    'ui__reseller/limits_unknown__title' => 'Utilização de Recursos',
    'ui__reseller/limits_unknown__description' => 'Ver e gerir a utilização dos recursos de um revendedor.',
    'ui__reseller/limits_self__short-title' => 'Utilização dos Recursos',
    'ui__reseller/limits_self__title' => 'Utilização dos Recursos',
    'ui__reseller/limits_self__description' => "Ver e gerir a sua utilização de recursos.",
    'ui__reseller/limits_readonly-self__short-title' => 'Utilização dos Recursos',
    'ui__reseller/limits_readonly-self__title' => 'Utilização dos Recursos',
    'ui__reseller/limits_readonly-self__description' => "Ver os recursos utilizados por si.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Utilização de Tráfego por Clientes',
    'ui__reseller/client/traffic_unknown__title' => 'Ver a Utilização de Tráfego por Clientes',
    'ui__reseller/client/traffic_unknown__description' => 'Ver relatórios da utilização de tráfego para contas de cliente.',
    'ui__client/traffic_unknown__short-title' => "Utilização de Tráfego por Clientes", // temporary for presets
    'ui__client/traffic_unknown__title' => "Ver a utilização do tráfego por clientes", // temporary for presets
    'ui__client/traffic_unknown__description' => "Ver relatórios da utilização de tráfego para contas de cliente.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Gestor de Log',
    'ui__client/domain/hosting/logs_unknown__title' => 'Gestor de Log',
    'ui__client/domain/hosting/logs_unknown__description' => 'Ver logs e configurar a rotação dos registos.',
    // dropdowns
    'ui__reseller/report__title' => 'Relatório resumido',
    'ui__reseller/report__short-title' => 'Relatório resumido',
    'ui__reseller/report__description' => 'Ver um relatório sobre a utilização de recursos e tráfego deste revendedor.',
    'ui__reseller/report_unknown__title' => 'Relatório resumido',
    'ui__reseller/report_unknown__short-title' => 'Relatório resumido',
    'ui__reseller/report_unknown__description' => 'Ver o relatório da utilização do tráfego e recursos do revendedor.',
    'ui__reseller/report_self__title' => 'Relatório resumido',
    'ui__reseller/report_self__short-title' => 'Relatório resumido',
    'ui__reseller/report_self__description' => 'Ver relatório de sua utilização de tráfego e recursos.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Personalização do Plesk',
    'ui__client/logo_reseller__short-title' => 'Personalização do Plesk',
    'ui__client/logo_reseller__description' => 'Personalizar o Plesk para o revendedor %1.',
    'ui__client/logo_unknown__title' => 'Personalização do Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Personalização do Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Personalize o Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Personalização do Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Personalização do Plesk',
    'ui__client/logo_self-reseller__description' => 'Personalize o seu Plesk.',
    'ui__reseller/permissions__title' => 'Permissões',
    'ui__reseller/permissions__short-title' => 'Permissões',
    'ui__reseller/permissions__description' => "Ver ou alterar as ações que o revendedor %1 pode executar no Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Permissões',
    'ui__reseller/permissions_unknown__title' => 'Permissões',
    'ui__reseller/permissions_unknown__description' => "Ver ou alterar as ações que o revendedor pode executar no Plesk.",
    'ui__reseller/permissions_self__title' => 'Permissões',
    'ui__reseller/permissions_self__short-title' => 'Permissões',
    'ui__reseller/permissions_self__description' => 'Ver a lista de ações que podem ser executadas no Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Permissões',
    'ui__reseller/permissions_readonly-self__short-title' => 'Permissões',
    'ui__reseller/permissions_readonly-self__description' => 'Ver a lista de ações que podem ser executadas no Plesk.',
    // dropdowns
    'ui__reseller/to-client__title' => 'Converter conta de revendedor para conta de cliente',
    'ui__reseller/to-client__short-title' => 'Converter revendedor para cliente',
    'ui__reseller/to-client__description' => 'Converter esta conta de revendedor para uma conta de cliente.',
    'ui__reseller/to-client_unknown__title' => 'Converter conta de revendedor para conta de cliente',
    'ui__reseller/to-client_unknown__short-title' => 'Converter revendedor para cliente',
    'ui__reseller/to-client_unknown__description' => 'Converter conta de revendedor para uma conta de cliente.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Modelo de Alojamento Virtual',
    'ui__client/skeleton__short-title' => 'Modelo de Alojamento Virtual',
    'ui__client/skeleton__description' => 'Especifique os ficheiros e pastas que devem ser colocados nos directórios ao criar os novos domínios.',
    'ui__client/skeleton_unknown__short-title' => 'Modelo de Alojamento Virtual',
    'ui__client/skeleton_unknown__title' => 'Modelo de Alojamento Virtual',
    'ui__client/skeleton_unknown__description' => 'Especifique os ficheiros e pastas que devem ser colocados nos directórios ao criar os novos domínios.',
    // dropdowns
    'ui__client/domain/properties_new__title' => 'Criar domínio',
    'ui__client/domain/properties_new__short-title' => 'Criar domínio',
    'ui__client/domain/properties_new__description' => "Criar um domínio para %1.",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Nomes alternativos de domínio',
    'ui__client/domain/domain-alias_unknown__title' => 'Nomes alternativos de domínio',
    'ui__client/domain/domain-alias_unknown__description' => 'Ver os nomes alternativos para o seu domínio.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Configuração DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_unknown__description' => 'Gerir definições da zona DNS de um domínio.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Ver as definições da zona DNS de um domínio.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Ferramentas do MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Obtenha ferramentas e serviços adicionais do MyPlesk.com',
    'ui__reseller/extras-domain_unknown__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Ferramentas do MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Obtenha ferramentas e serviços adicionais do MyPlesk.com',
    'ui__reseller/extras-domain_self__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Ferramentas do MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Obtenha ferramentas e serviços adicionais do MyPlesk.com',
    'ui__client/domain/odbc_unknown__short-title' => 'Fontes de dados ODBC', // PFW
    'ui__client/domain/odbc_unknown__title' => 'Fontes de dados ODBC', // PFW
    'ui__client/domain/odbc_unknown__description' => 'Configurar as fontes de dados ODBS para um domínio.', // PFW
    'ui__reseller/register-domain__short-title' => 'Registar Domínio',
    'ui__reseller/register-domain__title' => 'Registar Domínio',
    'ui__reseller/register-domain__description' => 'Registar um nome de domínio pelo MuPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Registar Domínio',
    'ui__reseller/register-domain_unknown__title' => 'Registar Domínio',
    'ui__reseller/register-domain_unknown__description' => 'Registar um nome de domínio pelo MuPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Registar Domínio',
    'ui__reseller/register-domain_self__title' => 'Registar Domínio',
    'ui__reseller/register-domain_self__description' => 'Registar um nome de domínio pelo MuPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Gerir Domínio',
    'ui__reseller/manage-domain__short-title' => 'Gerir Domínio',
    'ui__reseller/manage-domain__description' => 'Gerir os nomes dos domínios registados pelo MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Gerir Domínio',
    'ui__reseller/manage-domain_unknown__short-title' => 'Gerir Domínio',
    'ui__reseller/manage-domain_unknown__description' => 'Gerir os nomes dos domínios registados pelo MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Gerir Domínio',
    'ui__reseller/manage-domain_self__short-title' => 'Gerir Domínio',
    'ui__reseller/manage-domain_self__description' => 'Gerir os nomes dos domínios registados pelo MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Endereços IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Endereços IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Gerir endereços IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'Certificados SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Certificados SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Instalar e gerir certificados SSL/TLS.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'Protecção Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'Protecção Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'Proteger os ficheiros contra hotlinking.', // PFW
    'ui__reseller/sessions__short-title' => 'Sessões Activas',
    'ui__reseller/sessions__title' => 'Sessões Activas',
    'ui__reseller/sessions__description' => 'Ver as sessões ativas do Plesk.',
    'ui__reseller/sessions_unknown__short-title' => 'Sessões activas',
    'ui__reseller/sessions_unknown__title' => 'Sessões activas',
    'ui__reseller/sessions_unknown__description' => 'Ver as sessões ativas do Plesk.',
    'ui__reseller/sessions_self__short-title' => 'Sessões Activas',
    'ui__reseller/sessions_self__title' => 'Sessões Activas',
    'ui__reseller/sessions_self__description' => 'Ver as sessões ativas do Plesk.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_unknown__title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_unknown__description' => 'Ver e ajustar o limite de utilização da largura de banda e o número de ligações simultâneas a uma página web.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'Ver o limite de utilização da largura de banda e o número de ligações simultâneas a uma página web.',
    'ui__client/domain/hosting/php_unknown__short-title' => 'Definições de PHP', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'Definições de PHP', // PFW
    'ui__client/domain/hosting/php_unknown__description' => 'Configurar o PHP num domínio.', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Contas de Correio na Conta de Utilizador %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Modelo de Alojamento Virtual',
    'ui__client/skeleton_self__title' => 'Modelo de Alojamento Virtual',
    'ui__client/skeleton_self__description' => 'Especifique os ficheiros e pastas que devem ser colocados nos directórios ao criar os novos domínios.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // Remote desktop - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Utilização dos recursos',
    'ui__client/limits__title' => 'Utilização dos recursos',
    'ui__client/limits__description' => "Ver e gerir a utilização dos recursos do cliente %1.",
    'ui__client/limits_unknown__short-title' => 'Utilização de recursos',
    'ui__client/limits_unknown__title' => 'Utilização de recursos',
    'ui__client/limits_unknown__description' => 'Ver e gerir a utilização dos recursos do cliente.',
    'ui__client/limits_readonly__short-title' => 'Utilização de recursos',
    'ui__client/limits_readonly__title' => 'Utilização de recursos',
    'ui__client/limits_readonly__description' => 'Ver a utilização de recursos do cliente %1.',
    'ui__client/limits_self__short-title' => 'Utilização de recursos',
    'ui__client/limits_self__title' => 'Utilização de recursos',
    'ui__client/limits_self__description' => "Ver e gerir a sua utilização de recursos.",
    'ui__client/limits_readonly-self__short-title' => 'Utilização dos recursos',
    'ui__client/limits_readonly-self__title' => 'Utilização dos recursos',
    'ui__client/limits_readonly-self__description' => "Ver a utilização dos seus recursos.",
    'ui__client/domain/traffic_unknown__short-title' => "Utilização de Tráfego por Domínios %1",
    'ui__client/domain/traffic_unknown__title' => "Ver a utilização do tráfego dos domínios",
    'ui__client/domain/traffic_unknown__description' => "Ver relatório de utilização de tráfego dos domínios.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Relatório resumido',
    'ui__client/report__short-title' => 'Relatório resumido',
    'ui__client/report__description' => 'Ver relatório sobre a utilização de tráfego e recursos deste cliente.',
    'ui__client/report_unknown__short-title' => 'Relatório resumido',
    'ui__client/report_unknown__title' => 'Relatório resumido',
    'ui__client/report_unknown__description' => 'Ver relatório da utilização do tráfego e recursos do cliente.',
    'ui__client/report_self__short-title' => 'Relatório resumido',
    'ui__client/report_self__title' => 'Relatório resumido',
    'ui__client/report_self__description' => 'Ver relatório de utilização de tráfego e recursos.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Preferências de interface',
    'ui__client/preferences__title' => 'Preferências de interface',
    'ui__client/preferences__description' => 'Definir as preferências da interface do Plesk para o cliente %1.',
    'ui__client/preferences_unknown__short-title' => 'Preferências do interface',
    'ui__client/preferences_unknown__title' => 'Preferências do interface',
    'ui__client/preferences_unknown__description' => "Definir as preferências da interface para o Plesk do cliente.",
    'ui__client/preferences_self__short-title' => 'Preferências de interface',
    'ui__client/preferences_self__title' => 'Preferências de interface',
    'ui__client/preferences_self__description' => 'Definir as preferências da interface para o seu Plesk.',
    'ui__client/logo__title' => 'Personalização do Plesk',
    'ui__client/logo__short-title' => 'Personalização do Plesk',
    'ui__client/logo__description' => "Personalize o Plesk do cliente %1.",
    'ui__client/logo_self__title' => 'Personalização do Plesk',
    'ui__client/logo_self__short-title' => 'Personalização do Plesk',
    'ui__client/logo_self__description' => 'Personalize o Plesk alterando a imagem do logótipo e a barra de título do navegador.',
    'ui__client/permissions__title' => 'Permissões',
    'ui__client/permissions__short-title' => 'Permissões',
    'ui__client/permissions__description' => "Ver ou alterar as ações que o cliente %1 pode executar no Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Permissões',
    'ui__client/permissions_unknown__title' => 'Permissões',
    'ui__client/permissions_unknown__description' => "Ver ou alterar as ações que o cliente pode executar no Plesk.",
    'ui__client/permissions_self__title' => 'Permissões',
    'ui__client/permissions_self__short-title' => 'Permissões',
    'ui__client/permissions_self__description' => "Ver a lista de ações que podem ser executadas no Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Permissões',
    'ui__client/permissions_readonly-self__short-title' => 'Permissões',
    'ui__client/permissions_readonly-self__description' => "Ver a lista de ações que podem ser executadas no Plesk.",
    // dropdowns
    'ui__client/chowner_select__title' => 'Atribuir Novo Proprietário à Conta de Cliente',
    'ui__client/chowner_select__short-title' => 'Atribuir Novo Proprietário ao Cliente',
    'ui__client/chowner_select__description' => 'Atribuir novo proprietário para esta conta de cliente.',
    'ui__client/chowner_unknown-select__short-title' => 'Atribuir Novo Proprietário à Conta de Cliente',
    'ui__client/chowner_unknown-select__title' => 'Atribuir Novo Proprietário ao Cliente',
    'ui__client/chowner_unknown-select__description' => 'Atribuir novo proprietário à conta de cliente',
    'ui__client/to-reseller__title' => 'Converter conta de cliente para conta de revendedor',
    'ui__client/to-reseller__short-title' => 'Converter cliente para revendedor',
    'ui__client/to-reseller__description' => 'Converter esta conta de cliente para conta de revendedor.',
    'ui__client/to-reseller_unknown__title' => 'Converter conta de cliente para conta de revendedor',
    'ui__client/to-reseller_unknown__short-title' => 'Converter cliente para revendedor',
    'ui__client/to-reseller_unknown__description' => 'Converter esta conta de cliente para conta de revendedor.',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__client/extras-domain__title' => 'Ferramentas do MyPlesk.com',
    'ui__client/extras-domain__description' => 'Obtenha ferramentas e serviços adicionais do MyPlesk.com',
    'ui__client/extras-domain_unknown__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Ferramentas do MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Obtenha ferramentas e serviços adicionais do MyPlesk.com',
    'ui__client/extras-domain_self__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Ferramentas do MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Obtenha ferramentas e serviços adicionais do MyPlesk.com',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Registar Domínio',
    'ui__client/register-domain__short-title' => 'Registar Domínio',
    'ui__client/register-domain__description' => 'Registar um nome de domínio pelo MuPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Registar Domínio',
    'ui__client/register-domain_unknown__short-title' => 'Registar Domínio',
    'ui__client/register-domain_unknown__description' => 'Registar um nome de domínio pelo MuPlesk.com.',
    'ui__client/register-domain_self__title' => 'Registar Domínio',
    'ui__client/register-domain_self__short-title' => 'Registar Domínio',
    'ui__client/register-domain_self__description' => 'Registar um nome de domínio pelo MuPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Gerir Domínio',
    'ui__client/manage-domain__short-title' => 'Gerir Domínio',
    'ui__client/manage-domain__description' => 'Gerir os nomes dos domínios registados pelo MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Gerir Domínio',
    'ui__client/manage-domain_unknown__short-title' => 'Gerir Domínio',
    'ui__client/manage-domain_unknown__description' => 'Gerir os nomes dos domínios registados pelo MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Gerir Domínio',
    'ui__client/manage-domain_self__short-title' => 'Gerir Domínio',
    'ui__client/manage-domain_self__description' => 'Gerir os nomes dos domínios registados pelo MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Endereços IP',
    'ui__client/ipaddress_unknown__short-title' => "Endereços IP",
    'ui__client/ipaddress_unknown__description' => "Gerir endereços IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Nomes alternativos de domínio',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Nomes alternativos de domínio',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Ver os nomes alternativos para o seu domínio.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'Sessões Activas',
    'ui__client/sessions__title' => 'Sessões Activas',
    'ui__client/sessions__description' => 'Ver as sessões ativas do Plesk.',
    'ui__client/sessions_unknown__short-title' => 'Sessões Activas',
    'ui__client/sessions_unknown__title' => 'Sessões Activas',
    'ui__client/sessions_unknown__description' => 'Ver as sessões ativas do Plesk.',
    'ui__client/sessions_self__short-title' => 'Sessões Activas',
    'ui__client/sessions_self__title' => 'Sessões Activas',
    'ui__client/sessions_self__description' => 'Ver as sessões ativas do Plesk.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'Gestor de ficheiros',
    'ui__client/domain/hosting/file-manager__title' => 'Gerir ficheiros no domínio %1',
    'ui__client/domain/hosting/file-manager__description' => "Trabalhar com ficheiros e directórios no domínio %1 com o gestor de ficheiros.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'Gestor de ficheiros',
    'ui__client/domain/hosting/file-manager_self__title' => 'Gestor de ficheiros',
    'ui__client/domain/hosting/file-manager_self__description' => "Trabalhar os seus ficheiros e directórios com o gestor de ficheiros.",
    'ui__client/domain/hosting/tsclient__short-title' => 'Desktop remoto', // PFW
    'ui__client/domain/hosting/tsclient__title' => 'Desktop remoto', // PFW
    'ui__client/domain/hosting/tsclient__description' => 'Acesso ao servidor pelo desktop Remoto.', // PFW
    'ui__client/domain/hosting/tsclient_self__short-title' => 'Desktop remoto', // PFW
    'ui__client/domain/hosting/tsclient_self__title' => 'Desktop remoto', // PFW
    'ui__client/domain/hosting/tsclient_self__description' => 'Acesso ao servidor pelo desktop Remoto.', // PFW
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'Utilizar o terminal de SSH para aceder ao servidor.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'Utilizar o terminal de SSH para aceder ao servidor.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'Directórios protegidos por senha',
    'ui__client/domain/hosting/protected-directories__title' => 'Directórios protegidos por senha',
    'ui__client/domain/hosting/protected-directories__description' => 'Proteger acesso a áreas selecionadas da página web.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Diretórios protegidos com palavra-passe',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Diretórios protegidos com palavra-passe',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Proteger acesso a áreas selecionadas da página web.',
    'ui__client/domain/hosting/virtual-directories__short-title' => 'Directórios virtuais', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => 'Directórios virtuais', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => 'Criar e gerir directórios virtuais no domínio %1.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => 'Directórios virtuais', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => 'Directórios virtuais', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => 'Criar e gerir directórios virtuais no seu domínio.', // PFW
    'ui__client/domain/hosting/web-directories__title' => 'Diretórios Virtuais', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Diretórios Virtuais', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Trabalhar com ficheiros e diretórios físicos e virtuais no site %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Diretórios Virtuais', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Diretórios Virtuais', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Trabalhar com ficheiros e diretórios físicos e virtuais na sua página web.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => 'Estatísticas de rede',
    'ui__client/domain/report/web-stats__title' => 'Estatísticas de rede',
    'ui__client/domain/report/web-stats__description' => 'Ver estatísticas de visitas à página web.',
    'ui__client/domain/report/web-stats_self__short-title' => 'Estatísticas de rede',
    'ui__client/domain/report/web-stats_self__title' => 'Estatísticas de rede',
    'ui__client/domain/report/web-stats_self__description' => 'Ver estatísticas de visitas à página web.',
    'ui__client/domain/traffic__short-title' => '%1 Utilização de Tráfego',
    'ui__client/domain/traffic__title' => 'Estatísticas de transferências de dados para Domínio %1',
    'ui__client/domain/traffic__description' => 'Ver Estatísticas de transferências de dados para o domínio %1.',
    'ui__client/domain/traffic_self__short-title' => 'Utilização de tráfego',
    'ui__client/domain/traffic_self__title' => 'Ver a utilização do tráfego para o seu domínio',
    'ui__client/domain/traffic_self__description' => 'Ver relatório de utilização de tráfego da sua conta.',
    'ui__client/domain/hosting/logs__short-title' => 'Gestor de log',
    'ui__client/domain/hosting/logs__title' => 'Gestor de log',
    'ui__client/domain/hosting/logs__description' => 'Ver logs e configurar a rotação dos registos.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Gestor de log',
    'ui__client/domain/hosting/logs_self__title' => 'Gestor de log',
    'ui__client/domain/hosting/logs_self__description' => 'Ver logs e configurar a rotação dos registos.',
    // dropdowns
    'ui__client/domain/report__title' => 'Relatório resumido',
    'ui__client/domain/report__short-title' => 'Relatório resumido',
    'ui__client/domain/report__description' =>  'Ver relatório de utilização de tráfego e recursos.',
    'ui__client/domain/report_unknown__short-title' => 'Relatório resumido',
    'ui__client/domain/report_unknown__title' => 'Relatório resumido',
    'ui__client/domain/report_unknown__description' => 'Ver relatório sobre a utilização de tráfego e recursos.',
    'ui__client/domain/report_self__short-title' => 'Relatório resumido',
    'ui__client/domain/report_self__title' => 'Relatório resumido',
    'ui__client/domain/report_self__description' => 'Ver relatório de utilização de tráfego e recursos.',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => 'Dados pessoais',
    'ui__client/domain/properties__title' => 'Dados pessoais',
    'ui__client/domain/properties__description' => 'Mudar os dados pessoais de uma conta de administrador de domínio.',
    'ui__client/domain/properties_unknown__short-title' => 'Dados pessoais',
    'ui__client/domain/properties_unknown__title' => 'Dados pessoais',
    'ui__client/domain/properties_unknown__description' => 'Mudar os dados pessoais da conta.',
    'ui__client/domain/properties_self__short-title' => 'Dados pessoais',
    'ui__client/domain/properties_self__title' => 'Dados pessoais',
    'ui__client/domain/properties_self__description' => 'Mudar os dados pessoais da sua conta.',
    // dropdowns
    'ui__client/domain/rename__title' => 'Mudar o nome do domínio',
    'ui__client/domain/rename__short-title' => 'Mudar o nome do domínio',
    'ui__client/domain/rename__description' => 'Mudar o nome do domínio %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Alterar nome do domínio',
    'ui__client/domain/rename_unknown__title' => 'Alterar nome do domínio',
    'ui__client/domain/rename_unknown__description' => 'Alterar nome do domínio',
    'ui__client/domain/chowner_select__title' => 'Atribuir novo proprietário ao domínio',
    'ui__client/domain/chowner_select__short-title' => 'Atribuir novo proprietário a assinatura',
    'ui__client/domain/chowner_select__description' => 'Atribuir novo proprietário a assinatura',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Atribuir Novo Proprietário a Assinatura',
    'ui__client/domain/chowner_unknown-select__title' => 'Atribuir Novo Proprietário a Assinatura',
    'ui__client/domain/chowner_unknown-select__description' => 'Atribuir novo proprietário a uma assinatura.',
    'ui__client/domain/to-client__title' => 'Converter conta de administrador de domínio para conta de cliente',
    'ui__client/domain/to-client__short-title' => 'Converter administrador de domínio para cliente',
    'ui__client/domain/to-client__description' => 'Converter esta conta de administrador de domínio para uma conta de cliente',
    'ui__client/domain/to-client_unknown__short-title' => 'Converter Administrador de Domínio para Cliente',
    'ui__client/domain/to-client_unknown__title' => 'Converter conta de administrador de domínio para conta de cliente',
    'ui__client/domain/to-client_unknown__description' => 'Converter a conta de administrador de domínio para uma conta de cliente',
    'ui__client/domain/toggle__title' => 'Suspender ou Ativar Domínio', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Suspender ou Ativar Domínio', // for HP customization
    'ui__client/domain/toggle__description' => 'Suspender ou ativar domínio %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Suspender ou Ativar Domínio', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Suspender ou Ativar Domínio', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Suspender ou ativar um domínio.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Ativar Domínio',
    'ui__client/domain/toggle_enable__short-title' => 'Ativar Domínio',
    'ui__client/domain/toggle_enable__description' => 'Domínio ativado %1.',
    'ui__client/domain/toggle_disable__title' => 'Suspender Domínio',
    'ui__client/domain/toggle_disable__short-title' => 'Suspender Domínio',
    'ui__client/domain/toggle_disable__description' => 'Suspender domínio %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Configuração DNS',
    'ui__client/domain/dns__short-title' => 'Configuração DNS',
    'ui__client/domain/dns__description' => 'Gerir definições da zona DNS do domínio %1.',
    'ui__client/domain/dns_self__title' => 'Configuração DNS',
    'ui__client/domain/dns_self__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_self__description' => 'Gerir definições da zona DNS do seu domínio.',
    'ui__client/domain/dns_disabled__title' => 'Configuração DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_disabled__description' => 'Gerir as definições da zona DNS do domínio %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Configuração DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Ver as definições da zona DNS do seu domínio.',
    'ui__client/domain/dns_readonly__title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly__description' => 'Ver as definições da zona DNS do domínio %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Ver as definições da zona DNS do seu domínio.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Ver as definições da zona DNS do seu domínio.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Ver as definições da zona DNS do seu domínio.',
    'ui__client/domain/dns_slave__title' => 'Configuração DNS',
    'ui__client/domain/dns_slave__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_slave__description' => 'Gerir as definições da zona DNS do domínio %1.',
    'ui__client/domain/dns_self-slave__title' => 'Configuração DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Configuração DNS',
    'ui__client/domain/dns_self-slave__description' => 'Ver as definições da zona DNS do seu domínio.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__client/domain/extras__title' => 'Ferramentas do MyPlesk.com',
    'ui__client/domain/extras__description' => 'Obtenha ferramentas adicionais e serviços do MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Ferramentas do MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Obtenha ferramentas adicionais e serviços do MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Ferramentas do MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Ferramentas do MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Obtenha ferramentas adicionais e serviços do MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'Fontes de dados ODBC', // PFW
    'ui__client/domain/odbc__title' => 'Fontes de dados ODBC', // PFW
    'ui__client/domain/odbc__description' => 'Configurar fontes de dados ODBC para o domínio %1.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'Fontes de dados ODBC', // PFW
    'ui__client/domain/odbc_self__title' => 'Fontes de dados ODBC', // PFW
    'ui__client/domain/odbc_self__description' => 'Configurar as fontes de dados ODBS do seu domínio.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Registar domínio',
    'ui__client/domain/register__title' => 'Registar domínio',
    'ui__client/domain/register__description' => 'Registar um nome de domínio através de MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Registar domínio',
    'ui__client/domain/register_unknown__title' => 'Registar domínio',
    'ui__client/domain/register_unknown__description' => 'Registar um nome de domínio através de MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Registar domínio',
    'ui__client/domain/register_self__title' => 'Registar domínio',
    'ui__client/domain/register_self__description' => 'Registar um nome de domínio através de MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'Protecção Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'Protecção Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'Proteger ficheiros no domínio %1 contra hotlinking.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'Protecção Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'Protecção Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'Proteger os seus ficheiros contra hotlinking.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance__title' => 'Limite de Utilização da Largura de Banda e Número de Ligações Permitidas à sua Página Web.',
    'ui__client/domain/hosting/performance__description' => 'Ver e ajustar o limite de utilização da largura de banda do domínio %1 e o número de conexões simultâneas.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_readonly__title' => 'Limites de Utilização da Largura de Banda e Número de Ligações Permitidas à sua Página Web.',
    'ui__client/domain/hosting/performance_readonly__description' => 'Ver o limite de utilização da largura de banda do domínio %1 e o número de conexões simultâneas.',
    'ui__client/domain/hosting/performance_self__short-title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_self__title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_self__description' => 'Ver e ajustar o limite de utilização da largura de banda do seu domínio e o número de conexões simultâneas.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'Limitar largura de banda',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'Ver o limite de utilização da largura de banda do seu domínio e o número de conexões simultâneas.',
    'ui__client/domain/hosting/php__short-title' => 'Definições de PHP', // PFW
    'ui__client/domain/hosting/php__title' => 'Definições de PHP', // PFW
    'ui__client/domain/hosting/php__description' => 'Configurar o PHP no domínio %1.', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'Definições de PHP', // PFW
    'ui__client/domain/hosting/php_self__title' => 'Definições de PHP', // PFW
    'ui__client/domain/hosting/php_self__description' => 'Configurar o PHP no seu domínio.', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => 'É necessário selecionar as contas de cliente que quer converter para contas de revendedor',
    'ui__client/chowner__empty_selection' => 'Tem de selecionar as contas de cliente que quer atribuir a um novo proprietário',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Ferramentas",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Ver estatísticas',
    'ui__client/domain-summary-report_unknown__title' => 'Ver estatísticas',
    'ui__client/domain-summary-report_unknown__description' => 'Ver informação acerca dos recursos utilizados pelos domínios.',
    'ui__client/domain-summary-report__short-title' => "Ver estatísticas",
    'ui__client/domain-summary-report__title' => "Ver estatísticas",
    'ui__client/domain-summary-report__description' => "Ver informação acerca dos recursos utilizados pelos domínios.",
    'ui__client/domain-summary-report_self__short-title' => "Ver estatísticas",
    'ui__client/domain-summary-report_self__title' => "Ver estatísticas",
    'ui__client/domain-summary-report_self__description' => "Ver a informação de utilização de recursos pelos seus domínios.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domínios", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => 'Verificar Permissões',
    'ui__client/domain/check-permissions_multi__title' => 'Verificar Permissões',
    'ui__client/domain/check-permissions_multi__description' => 'Verificar as permissões de acesso dos ficheiros e directórios de um domínio. Caso existam erros, vão ser corrigidos automaticamente',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Tem de escolher os domínios que quer remover',
    'ui__client/domain/properties__empty_selection' => 'Tem de escolher os domínios que quer modificar',
    'ui__client/domain/chowner__empty_selection' => 'Tem de escolher os domínios que quer atribuir a um novo proprietário',
    'ui__client/domain/check-permissions__empty_selection' => 'Tem de escolher os domínios cujas permissões de ficheiros e directórios quer verificar',
    'ui__client/domain/to-client__empty_selection' => 'É necessário selecionar os domínios cujas contas de administrador quer converter para contas de cliente',

    // list objects filtering
    'domains_list__name__filter_title' => 'Nome',
    'domains_list__state__filter_title' => 'Utilização dos Recursos',
    'domains_list__filter_state_any' => 'Qualquer',
    'domains_list__filter_state_overuse' => 'Sobre-utilização',
    'domains_list__filter_state_normal' => 'Dentro dos limites',
    'domains_list__status__filter_title' => 'Estado',
    'domains_list__filter_status_any' => 'Qualquer',
    'domains_list__filter_status_blocked' => 'Suspenso',
    'domains_list__filter_status_active' => 'Ativo',
    'domains_list__ownership__filter_title' => 'Propriedade',
    'domains_list__filter_ownership_all' => 'Todos os domínios',
    'domains_list__filter_ownership_personal' => 'Só os meus domínios',
    'domains_list__filter_owner_pname__filter_title' => 'Nome do proprietário',
    'domains_list__subrows__filter_title' => 'Apresentar',
    'domains_list__subrows_off' => 'Só domínios',
    'domains_list__subrows_subdomain_domainaliases' => 'Com subdomínios e nomes alternativos',
    'domains_list__subrows_subdomain' => 'Com subdomínios',
    'domains_list__subrows_domainaliases' => 'Com nomes alternativos',

    // objects list
    'domains_list__owner__title' => 'Proprietário',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Ver aplicações",
    'site_apps__promo_main_text' => "O catálogo Application Packaging Standard (APS) contém a lista de aplicações que podem ser atribuídas  a um domínio ou espaço web. Se quiser atribuir aplicações que não estão incluídas no catálogo, pode-o fazer facilmente seguindo as instruções de preparação em www.apsstandard.com",
    'site_apps__promo_download_now' => "Descarregar Aplicações:",
    'site_apps__promo_close' => "Fechar este bloco",
    'site_apps__promo_preset__mostused' => '%1 Mais Populares',
    'site_apps__promo_preset__lessused' => 'Seguintes %1 Mais Populares',
    'site_apps__promo_preset__all' => "Todas",
    'site_apps__promo_disclaimer_note' => 'Por favor, note que as aplicações instaladas a partir de APS Catalog são fornecidas por terceiros e não são suportadas pelo Plesk.',
    'site_apps__promo_preset__page_title' => '%1 Aplicações APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'A adicionar aplicações...',

    // Errors
    'site_apps__no_applications_for_update' => 'Não tem nenhuma aplicação instalada no Repositório de Aplicações.',
    'site_apps__incorrect_download_preset_configuration' => 'Foram encontrados erros na configuração de predefinição de descarregamento do Catálogo APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'O URL especificado não é válido.',
    'site_apps__no_updates_at_the_moment' => 'De momento, não existem nenhumas actualizações da aplicação.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Foi recebida informação incorrecta do catálogo de aplicações APS. Por favor tente de novo mais tarde.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'As configurações do Catálogo APS foram guardadas mas o Plesk não pode estabelecer uma ligação ao Catálogo APS especificado nestas configurações (%1). Certifique-se que o endereço do Catálogo APS está correto e que o catálogo APS neste endereço está ativo.',
    'site_apps__cannot_retrieve_updates' => 'Neste momento é impossível descarregar as actualizações da aplicação: impossível estabelecer a conexão ao catálogo APS (%1). Certifique-se que o endereço do Catálogo APS',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Não há aplicações web disponíveis para instalação.',
    'site_apps__site_applications_already_installed_in_root' => 'Já estão instaladas outras aplicações web no directório root destes alojamentos virtuais',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "As aplicações web .NET não são suportadas na plataforma Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Não são suportadas aplicações web a nível de servidor.',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "Estão agendadas mais %1 aplicações web para adicionar ao Repositório de Aplicações.",
    'site_apps__applications_all_in_vault' => "As aplicações Web seleccionadas já se encontram presentes no Repositório de Aplicações.",
    'site_apps__applications_already_in_download_queue' => "De momento, estão a ser adicionadas %1 aplicações web ao Repositório de Aplicações.",
    'site_apps__applications_already_in_valut' => "%1 aplicações web seleccionadas já estão no Repositório de Aplicações.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Outras (sem categoria)',

    // Errors
    'site_apps__no_applications_in_category' => 'Não existem aplicações nesta categoria. Por favor, seleccione outra categoria.',
    'site_apps__no_category_selected__please_specify' => 'Seleccione uma categoria no menu da esquerda. Todas as aplicações da categoria seleccionada são exibidas nesta janela.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Conta de administrador',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Geral',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Mudar o hostname',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Segurança',
    'bt_setup_firewall' => 'Configure a firewall',
    'bt_manage_firewall_rules' => 'Gerir as regras da firewall',
    'cu_firewall__rule' => 'Criar uma regra de Firewall',
    'cu_firewall__protocol' => 'Definir um protocolo para a regra (\'tcp\' ou \'udp\')',
    'cu_firewall__name' => "Definir um nome de regra",
    'cu_firewall__disabled' => 'Se \'true\', a regra é desativada após a criação',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Seleccione o servidor DNS', // PFW
    'bt_soa_records_template' => 'Modelo de registos SOA',
    'bt_dns_recursion' => 'Configurações de Repetição de DNS',
    'bt_restrict_creation_of_subzones' => 'Restringir a criação de sub-zonas',

    'databases' => 'Bases de dados',
    'bt_select_mssqlwebadmin' => 'Selecionar MS SQL Web Admin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplicações',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Correio',
    'bt_select_mailserver' => 'Seleccione o servidor de correio', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Selecionar antivírus', // PFW
    'bt_virus_protection_settings' => 'Definições da protecção de vírus',
    'bt_select_spamfilter' => 'Seleccione o filtro spam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Selecionar Webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Registos e estatísticas',
    'bt_server_statistics_settings' => 'Configuração das estatísticas do servidor',
    'bt_select_web_statistics' => 'Software de estatísticas de rede disponível', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interface do Plesk',

    'components_and_modules' => 'Componentes & módulos',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Configurar o Watchdog', // PFU
    'bt_setup_vpn' => 'Configurar VPN', // PFU
    'bt_setup_samba' => 'Configurar o samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Configurações',
    'ui__client/domain/settings_self__short-title' => 'Configurações',
    'ui__client/domain/settings_self__description' => 'Ver e mudar as configurações de domínio.',

    'domain_administrator_account' => 'Conta do administrador de domínio',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Definições de conta',

    'domain' => 'Domínio',
    'bt_dns_soa_records' => 'Registos SOA de DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Definições da agenda de tarefas',

    'website' => 'Página web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Utilização de script\'s para os utilizadores de rede',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Seleccione o certificado SSL/TLS',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Estatísticas de rede',
    'bt_log_rotation_settings' => 'Definições da rotação de registo',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limites", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Política de sobreutilização e venda excessiva",
    'limits__overuse_policy_legend' => "Sobre-utilização",
    'limits__oversell_policy_legend' => "Venda excessiva",
    'limits__reseller_overuse_description' => "A política de sobreutilização informa o Plesk sobre o que fazer quando existe sobreutilização de recursos.",
    'limits__overuse_text' => "Politica de sobreutilização",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Espaço em disco e tráfego',
    'limit__disk_space' => 'Espaço em disco',
    'limit__max_traffic' => 'Tráfego',
    'limit_group__client' => 'Clientes',
    'limit__max_cl' => 'Clientes',
    'limit_group__domain' => 'Domínios',
    'limit__max_dom' => 'Domínios',
    'limit__max_dom_powerUser' => 'Assinaturas',
    'limit__max_subdom' => 'Subdomínios',
    'limit__max_dom_aliases' => 'Nomes alternativos de domínio',
    'limit__max_wu' => 'Utilizadores de rede',
    'limit__max_subftp_users' => 'Contas FTP adicionais', // PFW
    'limit_group__mail' => 'Correio',
    'limit__max_box' => 'Caixas de correio',
    'limit__mbox_quota' => 'Tamanho da caixa de correio',
    'limit__total_mboxes_quota' => 'Quota total das caixas de email', // PFW
    'limit__max_maillists' => 'Listas de envio',
    'limit_group__database' => 'Bases de dados',
    'limit__max_mssql_db' => 'Base de dados Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Quota total de bases de dado MS SQL', // PFW
    'limit__max_odbc' => 'Conexões ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Quota da base de dados MySQL', // PFW?
    'limit_group__application' => 'Aplicações',
    'limit__max_iis_app_pools' => 'Repositórios de aplicações de IIS', // PFW
    'limit_group__security' => 'Segurança',
    'limit_group__validity' => 'Data limite',
    'limit__expiration' => 'Período de validade',
    'limit__validity' => 'Período de validade',
    'limit__max_site_builder' => 'Websites publicados com Presence Builder',
    'limit__max_site' => 'Domínios',
    'limit__mssql_dbase_filesize' => 'Tamanho de ficheiro da base de dados MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Tamanho do ficheiro de registo da base de dados MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'O tamanho máximo de um ficheiro de uma base de dados Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'O tamanho máximo de um ficheiro de registo de uma base de dados Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Limite de domínios inválido. O valor mínimo é 1.',

    'property__has_wrong_value' => 'A propriedade %1 possui um valor incorreto.',
    'property__name_outgoing_messages_domain_limit' => 'Estabelece o limite para a saída de mensagens por domínio (por hora). Para Ilimitado, especifique "-1". Especifique "default" para estabelecer o valor especificado como o padrão para o servidor.',
    'property__name_outgoing_messages_mbox_limit' => 'Estabelece o limite para a saída de mensagens por caixa de correio (por hora). Para o valor Ilimitado, especifique "-1". Especifique "default" para estabelecer o valor especificado como o padrão para o servidor.',
    'property__name_outgoing_messages_subscription_limit' => 'Estabelece o limite para a saída de mensagens por assinatura (por hora). Para o valor Ilimitado, especifique "-1". Especifique "default" para estabelecer o valor especificado como o padrão para o servidor."',

    // for CLI report & email notifications
    '__resource_notify' => 'Avisar',
    '__general' => 'Geral',
    '__template_shared' => 'Modelo partilhado',
    'limit__overuse' => 'Politica de sobreutilização',
    'limit__max_traffic_soft' => 'Avisar quando a utilização de tráfego atingir',
    'limit__disk_space_soft' => 'Avisar quando a utilização do espaço de disco for alcançada',
    '__overuse' => 'Politica de sobreutilização',
    'performance__title' => 'Desempenho',
    'performance__bandwidth' => 'Limite de utilização da largura de banda  (KB/S)',
    'performance__max_connections' => 'Ligações limitadas a',

    'gch__hosting_php_isapi' => 'Executar PHP como extensão ISAPI',
    'gch__hosting_ssi_html' => 'Utilização adicional de SSI para *.htm, *.html',
    'gch__hosting_php_handler_type' => 'executar PHP como',
    'gch__hosting_php_handler_id' => 'executar PHP como',
    'gch__hosting_php_served_by_nginx' => 'PHP servido por nginx',
    'gch__hosting_unpaid_website_status' => 'Estado de páginas web em assinaturas suspensas',
    'gch__mn_no_autoresponder' => 'Não existem respostas automáticas definidas para a conta de correio.',
    'gch__no_clients_selected' => "Nenhuma conta de cliente selecionada.",
    'gch__no_domains_selected' => "Nenhum domínio seleccionado",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/mês",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nome do recurso',
    '__resource_usage' => 'Utilizado',
    '__resource_limit' => 'Limite',

    '__used' => 'Usado',
    '__limit' => 'Limite',

    '__never_expires' => 'Nunca expira',
    '__resource_free' => '%1 livre de %2',
    '__resource_unlimited' => '%1 utilizado, sem Limite',

    '__value' => 'Valor',
    '__unlimited' => 'Ilimitado',
    '__increment' => "Incrementar (+)",
    '__decrement' => "Decrementar (-)",
    '__pt' => 'unidades',
    '__procent' => '%',
    '__overused' => 'Sobre-utilizado',
    '__left' => 'falta',
    '__available' => 'disponível',
    '__not_available' => 'Não incluído',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Ver Histórico do Tráfego',
    'ui__admin/report/traffic-history__title' => 'Ver Histórico do Tráfego',
    'ui__admin/report/traffic-history__description' => 'Ver histórico de tráfego para revendedores, clientes e domínios.',
    'admin_traffic_history__title' => 'Histórico do Tráfego',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Agenda de Entrega',
    'ui__admin/report/layout/auto_unknown__title' => 'Agendar Entrega do Relatório',
    'ui__admin/report/layout/auto_unknown__description' => 'Escolha um agendamento de entrega de relatório para o formato do relatório.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Agendar Entrega de Relatório',
    'ui__admin/report/layout/auto/properties_new__title' => 'Agendar Entrega de Relatório',
    'ui__admin/report/layout/auto/properties_new__description' => 'Agendar uma entrega do relatório %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Agendar Entrega do Relatório',
    'ui__admin/report/layout/auto/properties__title' => 'Agendar Entrega do Relatório',
    'ui__admin/report/layout/auto/properties__description' => 'Ver e mudar as propriedades da entrega de relatório agendada.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Remover Agendamento da Entrega de Relatório',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Remover Agendamento da Entrega de Relatório',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Remover agendamentos da entrega de relatório seleccionados.',

    'ui__admin/report/layout_unknown__short-title' => 'Formatos de Relatórios',
    'ui__admin/report/layout_unknown__title' => 'Formatos de Relatórios',
    'ui__admin/report/layout_unknown__description' => 'Ver e gerir os formatos de relatório.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Criar Formato de Relatório',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Criar Formato de Relatório',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Criar um formato de relatório.',
    'ui__admin/report/layout/delete_multi__short-title' => 'Remover Formatos de Relatório',
    'ui__admin/report/layout/delete_multi__title' => 'Remover Formatos de Relatório',
    'ui__admin/report/layout/delete_multi__description' => 'Remover formatos de relatório seleccionados.',
    'ui__admin/report/layout/properties__short-title' => 'Propriedades',
    'ui__admin/report/layout/properties__title' => 'Propriedades do Formato de Relatório',
    'ui__admin/report/layout/properties__description' => 'Editar as propriedades do formato do relatório.',

    // reseller
    'reseller_traffic_history__title' => "Histórico do Tráfego do Revendedor %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Ver a Utilização do Tráfego do Revendedor %1',
    'ui__reseller/traffic__description' => 'Ver relatório de utilização de tráfego do revendedor %1.',
    'ui__reseller/traffic_self__short-title' => 'Meu',
    'ui__reseller/traffic_self__title' => 'Ver a Utilização de Tráfego por Clientes',
    'ui__reseller/traffic_self__description' => 'Ver relatórios da utilização de tráfego das suas contas de cliente.',

    'ui__reseller/report/traffic-history__short-title' => 'Ver Histórico de Tráfego',
    'ui__reseller/report/traffic-history__title' => 'Ver Histórico de Tráfego',
    'ui__reseller/report/traffic-history__description' => "Ver o histórico do tráfego do revendedor %1.",
    'ui__reseller/report/traffic-history_self__short-title' => 'Ver Histórico de Tráfego',
    'ui__reseller/report/traffic-history_self__title' => 'Ver Histórico de Tráfego',
    'ui__reseller/report/traffic-history_self__description' => 'Ver histórico do seu tráfego.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Agenda de Entrega',
    'ui__reseller/report/layout/auto_unknown__title' => 'Agenda de Entrega de Relatório',
    'ui__reseller/report/layout/auto_unknown__description' => 'Escolha o agendamento de entrega de relatório para um formato de relatório.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Agendar uma Nova Entrega de Relatório',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Agendar uma Nova Entrega de Relatório',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Agendar uma entrega do relatório %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Agendar Entrega do Relatório',
    'ui__reseller/report/layout/auto/properties__title' => 'Agenda de Entrega de Relatório',
    'ui__reseller/report/layout/auto/properties__description' => 'A entrega de relatório agendada foi removida.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Remover Agendamento de Entrega de Relatório',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Remover Agendamento de Entrega de Relatório',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Remover agendamentos de entrega de relatório seleccionados.',

    'ui__reseller/report/layout_unknown__short-title' => 'Formatos de Relatório',
    'ui__reseller/report/layout_unknown__title' => 'Formatos de Relatório',
    'ui__reseller/report/layout_unknown__description' => 'Ver e gerir os formatos de relatório.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Criar Formato de Relatório',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Criar Formato de Relatório',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Criar um formato de relatório.',
    'ui__reseller/report/layout/properties_new__short-title' => 'Criar Formato de Relatório',
    'ui__reseller/report/layout/properties_new__title' => 'Criar Formato de Relatório',
    'ui__reseller/report/layout/properties_new__description' => 'Criar um formato de relatório.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Remover Formatos de Relatório',
    'ui__reseller/report/layout/delete_multi__title' => 'Remover Formatos de Relatório',
    'ui__reseller/report/layout/delete_multi__description' => 'Remover formatos de relatório seleccionados',
    'ui__reseller/report/layout/properties__short-title' => 'Propriedades',
    'ui__reseller/report/layout/properties__title' => 'Propriedades do formato de relatório',
    'ui__reseller/report/layout/properties__description' => 'Editar as propriedades do formato de relatório.',

    // customer
    'cl_traffic_history__title' => "Histórico do Tráfego do Cliente %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Ver a Utilização do Tráfego do Cliente %1',
    'ui__client/traffic__description' => 'Ver relatórios da utilização de tráfego para conta de cliente %1.',
    'ui__client/traffic_self__short-title' => 'Utilização de Tráfego',
    'ui__client/traffic_self__title' => 'Utilização de Tráfego por Domínios',
    'ui__client/traffic_self__description' => 'Ver relatórios da utilização de tráfego dos seus domínios.',

    'ui__client/report/traffic-history__short-title' => 'Ver Histórico de Tráfego',
    'ui__client/report/traffic-history__title' => 'Ver Histórico de Tráfego',
    'ui__client/report/traffic-history__description' => 'Ver o histórico do tráfego do cliente %1.',
    'ui__client/report/traffic-history_self__short-title' => 'Ver Histórico de Tráfego',
    'ui__client/report/traffic-history_self__title' => 'Ver Histórico de Tráfego',
    'ui__client/report/traffic-history_self__description' => 'Ver histórico do seu tráfego.',



    // domain
    'dom_traffic_history__title' => "Histórico do Tráfego do Domínio %1",

    'ui__client/domain/report/traffic-history__short-title' => 'Ver Histórico de Tráfego',
    'ui__client/domain/report/traffic-history__title' =>  'Ver Histórico de Tráfego',
    'ui__client/domain/report/traffic-history__description' => 'Ver o histórico do tráfego do domínio %1.',
    'ui__client/domain/report/traffic-history_self__short-title' => 'Ver Histórico de Tráfego',
    'ui__client/domain/report/traffic-history_self__title' =>  'Ver Histórico de Tráfego',
    'ui__client/domain/report/traffic-history_self__description' => 'Ver o histórico do tráfego do seu domínio.',



    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => 'Estatísticas de Visitas Seguras ao Site',
    'ui__client/domain/report/web-stats-ssl__title' => 'Estatísticas de visitas ao site seguro %1',
    'ui__client/domain/report/web-stats-ssl__description' => 'Estatísticas de visitas seguras ao site %1.',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => 'Estatísticas de rede SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_self__title' => 'Estatísticas de visitas seguras ao seu site',
    'ui__client/domain/report/web-stats-ssl_self__description' => 'Estatísticas de visitas seguras ao seu site.',
    'ui__client/domain/report/ftp-stats__short-title' => 'Estatísticas FTP',
    'ui__client/domain/report/ftp-stats__title' => 'Estatísticas de FTP para o domínio %1',
    'ui__client/domain/report/ftp-stats__description' => 'Estatísticas de FTP para o domínio %1',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'Estatísticas FTP',
    'ui__client/domain/report/ftp-stats_self__title' => 'Estatísticas FTP do seu domínio',
    'ui__client/domain/report/ftp-stats_self__description' => 'Estatísticas FTP do seu domínio',
    'ui__client/domain/report/anon-ftp-stats__short-title' => 'Estatísticas do FTP anónimo',
    'ui__client/domain/report/anon-ftp-stats__title' => 'Estatísticas do FTP anónimo para o domínio %1',
    'ui__client/domain/report/anon-ftp-stats__description' => 'Estatísticas do FTP anónimo para o domínio %1',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => 'Estatísticas do FTP Anónimo',
    'ui__client/domain/report/anon-ftp-stats_self__title' => 'Estatísticas do FTP Anónimo do domínio %1',
    'ui__client/domain/report/anon-ftp-stats_self__description' => 'Estatísticas do FTP Anónimo do domínio %1',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'Configurações do Webalizer',
    'ui__client/domain/report/webalizer-preferences__title' => 'Configurações do Webalizer para %1',
    'ui__client/domain/report/webalizer-preferences__description' => 'Ajustar o formato dos relatórios estatísticos pelo Webalizer para %1.',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'Configurações do Webalizer',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'Configurações do Webalizer para %1',
    'ui__client/domain/report/webalizer-preferences_self__description' => 'Ajustar o formato dos relatórios estatísticos pelo Webalizer para %1.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'F',
    'report__full_h' => 'T',
    'report__full_reseller_name' => 'Nome do revendedor', // reseller report
    'report__full_client_name' => 'Nome de cliente', // customer report
    'report__full_domain_name' => 'Nome de domínio', // domain report
    'report__full_owner' => 'Proprietário', // customer & domain reports
    'report__full_creation_date' => 'Data criado',
    'report__full_size' => 'Dimensão',
    'report__full_traffic' => 'Tráfego',
    'report__full_active_clients' => 'Clientes ativos', // reseller report
    'report__full_clients' => 'Clientes', // reseller report
    'report__full_active_domains' => 'Domínios activos', // reseller & customer reports
    'report__full_domains' => 'Domínios', // reseller & customer reports
    'report__full_subdomains' => 'Sub-dom',
    'report__full_mboxes' => 'CCorreio',
    'report__full_disk_space' => 'Espaço em disco',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'ListCorreio',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'BD MySQL',
    'report__full_mssql_databases' => 'BD MSSQL',

    // common summary report
    'report__section_general' => 'Geral',
    'report__version' => 'Versão do produto',
    'report__build' => 'Compilação do produto',
    'report__status' => 'Estado',
    'report__company_name' => 'Nome da empresa',
    'report__personal_name' => 'Nome',
    'report__login' => 'Nome de utilizador',
    'report__phone' => 'Telefone',
    'report__fax' => 'Fax',
    'report__email' => 'E-mail',
    'report__address' => 'Endereço',
    'report__city' => 'Cidade',
    'report__state' => 'Distrito',
    'report__zip_code' => 'Código Postal',
    'report__country' => 'País',
    'report__creation_date' => 'Data criado',
    'report__expiration_date' => 'Data limite',
    'report__dumps_total_size' => 'Tamanho dos ficheiros de backup',
    'report__section_resellers' => 'Revendedores',
    'report__active_resellers' => 'Revendedores com assinaturas ativas',
    'report__resellers' => 'Revendedores',
    'report__section_full_resellers' => 'Revendedores',
    'report__section_clients' => 'Clientes',
    'report__active_clients' => 'Clientes com assinaturas ativas',
    'report__clients' => 'Clientes',
    'report__section_full_clients' => 'Clientes',
    'report__section_personal_clients' => 'Clientes pessoais',
    'report__active_personal_clients' => 'Os seus próprios clientes com assinaturas ativas',
    'report__personal_clients' => 'Clientes pessoais',
    'report__section_full_personal_clients' => 'Clientes pessoais',
    'report__section_domains' => 'Domínios',
    'report__disk_usage' => 'Utilização em disco',
    'report__traffic' => 'Tráfego',
    'report__active_domains' => 'Domínios activos',
    'report__domains' => 'Domínios',
    'report__subdomains' => 'Subdomínios',
    'report__mboxes' => 'Caixas de correio',
    'report__mail_groups' => 'Reencaminhamentos de correio',
    'report__mail_autoresp' => 'Respostas automáticas',
    'report__mail_lists' => 'Listas de envio',
    'report__web_users' => 'Utilizadores de rede',
    'report__mysql_databases' => 'Bases de dados MySQL',
    'report__mssql_databases' => 'Bases de dados MSSQL',
    'report__section_full_domains' => 'Domínios',
    'report__section_personal_domains' => 'Domínios directos',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Domínios directos',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Websites publicados com Presence Builder',
    'report__invalid_email' => 'Por favor especifique um endereço de e-mail válido.',


    // CLI-specific sections
    'report__section_hosting' => 'Alojamento',
    'report__section_webusers' => 'Utilizadores de rede',
    'report__section_mailnames' => 'Contas de Correio',
    'report__section_maillists' => 'Listas de envio',
    'report__section_databases' => 'Bases de dados',
    'report__section_siteapps' => 'Aplicações Web',
    'report__section_aspnetapps' => 'Aplicações ASP.NET', // PFW
    'report__owner_pname' => "Nome do fornecedor",
    'report__owner_login' => "Nome de utilizador do fornecedor",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'O pacote de línguas especificado está instalado mas não está ativado no sistema.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Eliminar Sessões',
    'ui__sessions/delete__title' => 'Eliminar Sessões',
    'ui__sessions/delete__description' => 'Eliminar as sessões seleccionadas.',
    'ui__ftp-sessions__short-title' => 'Sessões FTP',
    'ui__ftp-sessions__title' => 'Sessões FTP',
    'ui__ftp-sessions__description' => 'Ver sessões de FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Eliminar Sessões de FTP',
    'ui__ftp-sessions/delete__title' => 'Eliminar Sessões de FTP',
    'ui__ftp-sessions/delete__description' => 'Eliminar as sessões de FTP seleccionadas.',
    'ui__ts-sessions__short-title' => 'Sessões TS',
    'ui__ts-sessions__title' => 'Sessões TS',
    'ui__ts-sessions__description' => 'Ver sessões de terminal service.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Eliminar Sessões',
    'ui__reseller/sessions/delete__title' => 'Eliminar Sessões',
    'ui__reseller/sessions/delete__description' => 'Eliminar as sessões seleccionadas.',
    'ui__reseller/sessions/delete_self__short-title' => 'Eliminar Sessões',
    'ui__reseller/sessions/delete_self__title' => 'Eliminar Sessões',
    'ui__reseller/sessions/delete_self__description' => 'Eliminar as sessões seleccionadas.',
    'ui__reseller/ftp-sessions__short-title' => 'Sessões FTP',
    'ui__reseller/ftp-sessions__title' => 'Sessões FTP',
    'ui__reseller/ftp-sessions__description' => 'Ver sessões de FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Sessões FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Sessões FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Ver sessões de FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Eliminar Sessões de FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Eliminar Sessões de FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Eliminar as sessões de FTP seleccionadas.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Eliminar Sessões de FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Eliminar Sessões de FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Eliminar as sessões de FTP seleccionadas.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Eliminar Sessões',
    'ui__client/sessions/delete__title' => 'Eliminar Sessões',
    'ui__client/sessions/delete__description' => 'Eliminar as sessões seleccionadas.',
    'ui__client/sessions/delete_self__short-title' => 'Eliminar Sessões',
    'ui__client/sessions/delete_self__title' => 'Eliminar Sessões',
    'ui__client/sessions/delete_self__description' => 'Eliminar as sessões seleccionadas.',

    // domain administrator

    'forgery_token_expired' => 'O token da sessão expirou.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'As seguintes contas de revendedor serão convertidas para contas de cliente',
    'downgradeResellers__downgrade' => 'Contas de revenda que vão ser convertidas',
    // controls
    'downgradeResellers__submit_downgrade' => 'Executar a conversão da conta.',
    'downgradeResellers__cancel_downgrade' => 'Cancelar a conversão da conta.',
    'downgradeResellers__confirm' => 'Confirme a conversão',
    'downgradeResellers__confirm_message' => 'Confirme a conversão da conta para prosseguir',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Selecione as Contas de Cliente',
    'upgradeClients__upgrade_clients' => 'As seguintes contas de cliente serão convertidas para contas de revendedor',
    'upgradeClients__upgrade' => 'Contas de cliente que vão ser convertidas',
    // controls
    'upgradeClients__submit_upgrade' => 'Executar a conversão da conta.',
    'upgradeClients__cancel_upgrade' => 'Cancelar a conversão da conta.',
    'upgradeClients__confirm' => 'Confirme a conversão',
    'upgradeClients__confirm_message' => 'Confirme a conversão da conta para prosseguir',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Impossível converter a conta \'%1\' numa conta de revendedor: \'%1\' já é um revendedor.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'As seguintes contas de administrador de domínio serão convertidas para contas de cliente',
    'upgradeDomainUser__upgrade' => 'Contas do administrador de domínio que vão ser convertidas',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Executar a conversão da conta.',
    'upgradeDomainUser__cancel_upgrade' => 'Cancelar a conversão da conta.',
    'upgradeDomainUser__confirm' => 'Confirme a conversão',
    'upgradeDomainUser__confirm_message' => 'Confirme a conversão da conta para prosseguir',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Contas do administrador de domínio que não podem ser convertidas',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'As seguintes contas de administrador de domínio não puderam ser convertidas para contas de cliente:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Várias contas de administrador de domínio não puderam ser convertidas para contas de cliente. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'A conta do administrador de domínio não existe',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "O domínio deve pertencer directamente ao administrador do sistema ou revendedor.",
    'upgradeDomainUser__all_logins_already_used' => 'Impossível criar uma conta para o cliente resultante.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'A conta de administrador de domínio foi convertida',
    'upgradeDomainUser__upgrade_notification_body' => 'A sua conta de administrador de domínio foi convertida para uma conta de cliente com o nome de utilizador \'%%login%%\' e palavra-passe \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => 'Atribuir Novo Proprietário à Conta de Cliente %1', // customer home
    'ui__client/chowner_multi__wizard-title' => 'Atribuir Novo Proprietário às Contas de Cliente Selecionadas', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => 'Atribuir Novo Proprietário ás Contas de Cliente Seleccionadas', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => 'Selecione as Contas de Cliente',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => 'Selecione as contas de cliente que quer transferir para outro proprietário.',
    //  owner selection
    'client_chown__select_title' => 'Escolha um Novo Proprietário para a Conta de Cliente',
    'client_chown__select-multi_title' => 'Escolha um Novo Proprietário para as Contas de Cliente',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "Escolher um novo proprietário para as contas de cliente selecionadas.", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => 'Escolher um novo proprietário para as contas de cliente selecionadas.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => 'Escolher um novo proprietário para as contas de cliente selecionadas.', // reseller & admin home
    // changes check page
    'client_chown__check_title' => 'Rever Alterações e Finalizar o Assistente',
    'ui__client/chowner__wizard__2' => 'Verifique as modificações e clicar Finalizar para completar o assistente.', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => 'Verifique as modificações e clicar Finalizar para completar o assistente.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => 'Verifique as modificações e clicar Finalizar para completar o assistente.', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => 'Tem de escolher um novo proprietário das contas de cliente selecionadas',
    'clientOwnerChanger__unable_to_transfer_some_clients' => 'Uma ou mais contas de utilizador selecionadas não podem ser transferidas para o novo proprietário.',
    'client_chown__client_warn' => 'Descrição',

    'clientOwnerChanger__owner_has_no_permission' => 'O revendedor selecionado não possui a autorização \'%1\', mas alguns dos clientes possuem-na.',
    'clientOwnerChanger__application_not_allowed' => 'A aplicação \'%1\' não está disponível para o revendedor selecionado, mas está disponível para alguns dos clientes.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Reatribuir as assinaturas selecionadas',
    // errors
    'domain_chown__empty_selection' => 'Tem de escolher um novo proprietário dos domínios seleccionados',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'Desempenho',
    'hosting_performance__traffic_bandwidth_legend' => 'Ligar a limitação de largura de banda',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'Limite á largura de banda',
    'hosting_performance__traffic_bandwidth_label' => 'Utilização máxima da Largura de Banda (%1)',
    'hosting_performance__traffic_bandwidth_hint' => 'O limite de utilização da Largura de Banda só se aplica aos dados transferidos pelo protocolo HTTP.',
    'hosting_performance__max_connection_legend' => 'Ligar limites de conexões',
    'hosting_performance__max_connection_legend_ro' => 'Limites de conexões',
    'hosting_performance__max_connection_label' => 'Conexões limitadas a',
    'hosting_performance__max_connection_hint' => 'Se limitar o uso da largura de banda, recomendamos que também limite o número de ligações simultâneas ao site. Caso contrário, os processos do servidor web vão aumentar o carregamento do servidor no caso de requisições frequentes ao site.',

    // errors:
    'performance__qos_not_installed' => 'A função está desligada porque o QoS não está instalado',
    'performance__bandwidth_throttling' => 'Não pode controlar a largura de banda porque o Qos não está instalado.',
    'performance__invalid_value' => "O valor é inválido. Deveria estar na gama entre %1 a %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Correio',
    'webmail__server_text' => 'Clientes de webmail disponíveis',
    'webmail__none' => 'Nenhum',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Repositório de IP\'s do servidor',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'A base de dados não será reposta: não existe um servidor de base de dados apropriado',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Cópia de segurança do servidor.",
    '__default_backup_comment_reseller' => "Cópia de segurança da conta de revendedor criadao por %1.",
    '__default_backup_comment_client' => "Cópia de segurança da conta de cliente criada por %1.",
    '__default_backup_comment_domain' => "Cópia de segurança da assinatura criada por %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Defina o Mapeamento dos Endereços IP',
    'backup__ip_mapping__download' => 'Salvar o Mapeamento IP Actual para um Ficheiro',
    'b_backup__ip_mapping__download' => 'Clique para descarregar a configuração do mapeamento IP.',
    'b_backup__ip_mapping__download_is_empty' => 'A configuração do mapeamento IP está vazia.',
    'backup__ip_mapping_upload__title' => 'Carregar Ficheiro de Mapeamento de IP',
    'backup__ip_mapping__upload' => 'Carregar Ficheiro de Mapeamento de IP',
    'b_backup__ip_mapping__upload' => 'Clique para carregar a configuração do mapeamento IP.',
    'backup__ip_mapping__list__header' => 'Mapeamento IP',
    'backup__ip_mapping__list__adddress' => 'Endereço IP Antigos',
    'backup__ip_mapping__list__select_ip' => 'Novos Endereços IP',
    'backup__ip_mapping__clients_ip' => "Repositório de IP do cliente %1",
    'backup__ip_mapping__resellers_ip' => "Repositório de IP do revendedor %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Endereços IP exclusivos devem ser mapeados para endereços IP únicos. Selecione um endereço IP único para cada endereço IP exclusivo na lista.',
    'backup__ip_mapping__legend' => 'Mapeamento IP',
    'backup__ip_mapping__upload_legend' => 'Carregar',
    'backup__ip_mapping__upload_file_text' => 'Ficheiro de mapeamento IP',
    'backup__ip_mapping__upload_file_hint' => 'O ficheiro de mapeamento de IP é um ficheiro de texto. Cada linha deste ficheiro contém o mapeamento IP no seguinte formato: <antigo endereço IP> <novo endereço IP>',
    'backup__ip_mapping__ip_address_not_found' => 'Endereços IP livres deste tipo não estão disponíveis.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Impossível executar a transferência do domínio: O mapeamento de endereços IP está incompleto porque não existem endereços IP livres no repositório do servidor de destino.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Ligações de FTPS não-seguro serão proibidas para domínios com este endereço IP.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Ligações de FTPS seguro serão proibidas para domínios com este endereço IP.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Conflitos',
    'backup__restore__object_vhost' => 'Alojamento virtual',
    'backup__restore__object_plesk_admin' => 'Administrador Plesk',
    'backup__restore__object_ftpuser' => 'Conta de FTP',
    'backup__restore__object_frontpageuser' => 'Conta de FrontPage',
    'backup__restore__object_webuser' => 'utilizador web',
    'backup__restore__object_domain' => 'domínio',
    'backup__restore__object_subdomain' => 'sub-domínio',
    'backup__restore__object_domainalias' => 'nome alternativo de domínio',
    'backup__restore__object_client' => 'cliente',
    'backup__restore__object_reseller' => 'revendedor',
    'backup__restore__object_autoresponder' => 'resposta automática',
    'backup__restore__object_mailalias' => 'nome alternativo de e-mail',
    'backup__restore__object_database' => 'base de dados',
    'backup__restore__object_mailname' => 'conta de correio',
    'backup__restore__object_db_user' => 'utilizador de base de dados',
    'backup__restore__object_ssl_certificate' => 'Certificado SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Os seguintes revendedores não podem ser restaurados pois foram convertidos em clientes: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Os seguintes clientes não podem ser restaurados pois foram convertidos em revendedores: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Os seguintes clientes não podem ser restaurados pois foram movidos para outro proprietário: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'O espaço no disco do servidor de destino não é suficiente para transferir as assinaturas selecionadas. Disponível: %1 MB. Necessário: %2 MB. Note que o espaço necessário é calculado como a soma dos conteúdos de web, do correio e da base de dados dos domínios. O espaço necessário é calculado diariamente e armazenado na cache, de modo que a dimensão real dos domínios pode ser diferente da dimensão calculada. Certifique-se que os domínios selecionados não ocupam mais espaço que o disponível para prosseguir com a transferência.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Por favor, crie espaço de disco no servidor de destino.',
    'backup__restore__capability_source_not_enough_disk_text' => 'O espaço de disco no servidor fonte não é suficiente para armazenar ficheiros temporários para transferência. Disponível: %1 MB. Necessário: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Por favor, crie espaço de disco no servidor de origem.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Informação do servidor',

    'backup__restore__capability_not_installed_component_text' => 'O componente %1 não está instalado no servidor de destino. %1 não estará disponível para todos os objetos repostos.',
    'backup__restore__capability_not_installed_component_resolution' => 'Por favor, instale %1. Note que isso pode levar alguns minutos.',
    'backup__restore__capability_existing_sys_user_text' => 'Um utilizador de sistema com o nome %1 já existe no servidor de destino.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Por favor, altere o nome do utilizador de sistema já existente no servidor de destino.',
    'backup__restore__capability_license_usage_text' => 'Os seguintes limites de recursos (definidos pela chave de licença) serão excedidos no servidor de destino após a transferência de dados:',
    'backup__restore__capability_license_usage_resolution' => 'Por favor, instale no servidor de destino outra chave de licença que vai fornecer a quantidade necessária de recursos.',
    'backup__restore__capability_max_allowed_packet_text' => "O parâmetro 'max_allowed_packet' no servidor fonte da base de dados é %1, que é maior no servidor de destino, onde é %2. Alguns objetos da base de dados para os domínios especificados abaixo podem não ser repostos.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Por favor, aumente o valor de 'max_allowed_packet' no servidor de destino da base de dados.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Impossível transferir as bases de dados do PostgreSQL, porque a versão do PostgreSQL no servidor de destino é anterior à do servidor fonte. A  versão atual é %1. A versão necessária é %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Por favor, instale a versão necessária do PostgreSQL no servidor de destino.',
    'backup__restore__capability_db_server_connection_problems' => 'Não foi possível ligar ao servidor de base de dados PostgreSQL. As bases de dados serão transferidas apenas se a ligação for reposta.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Por favor, verifique as configurações de ligação no servidor de base de dados.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'O componente %1 está desligado no servidor de destino.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Por favor, ligue %1 no servidor de destino.',
    'backup__restore__capability_not_configured_component_text' => 'O componente %1 está configurado no servidor de destino.',
    'backup__restore__capability_not_configured_component_resolution' => 'Por favor, configure %1 na página Ferramentas & Configurações.',

    'backup__restore__capability_webmail_is_not_available' => 'O webmail %1 não está disponível no servidor de destino. O Plesk utilizará o seguinte serviço de webmail: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Para utilizar o mesmo webmail que o servidor de origem, deve instalá-lo neste servidor.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Para utilizar o mesmo webmail do servidor de origem, deve instalá-lo no servidor de destino.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "O webmail '%1' não está disponível no servidor de destino. Nas seguintes assinaturas: %3, o Plesk utilizará o seguinte serviço de webmail: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Por favor, instale o webmail necessário no servidor de destino.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Configurações do webmail',

    'backup__restore__capability_shell_is_not_available' => 'O shell %1 não está disponível no servidor de destino. Em vez deste deste, será utilizado um dos shell disponíveis.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Para utilizar o mesmo shell do servidor de origem, deve ativá-lo (in /etc/shells) ou instalá-lo no servidor de destino.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'O servidor DNS de destino não suporta redes no Modelo de Restrições de Transferência. Não serão repostos os registos com endereços IP de rede nas restrições de transferência DNS.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'O servidor DNS de destino não suporta redes no Modelo de Restrições de Transferência, mas alguns domínios tem redes nas restrições de transferência DNS. Não serão repostos os registos com endereços IP de rede nas restrições de transferência DNS.',

    'backup__restore__capability_wrong_php_handler_text' => 'O PHP handler %1 não está disponível no servidor de destino. O Plesk utilizará o seguinte PHP handler: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Para utilizar o mesmo manipulador PHP do servidor fonte, deve ativá-lo ou instalá-lo no servidor de destino.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'O PHP handler %1 não está disponível. O Plesk utilizará %2 para os seguintes planos de serviço: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'O PHP handler %1 não está disponível. O Plesk utilizará %2 para os seguintes sites: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'O processador de PHP %1 não está disponível. Estará indisponível para os seguintes websites: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'O %1 %2 não está disponível no servidor de destino. A versão predefinida será utilizada.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Para utilizar o mesmo %1 do servidor de origem, deve ativá-lo ou instalá-lo no servidor de destino.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'A política de uso de antivírus no servidor de destino não permite as configurações pessoais (por endereço de e-mail) de antivírus para correio a sair. Estas configurações não serão transferidas.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'A política de uso de antivírus no servidor de destino não permite as configurações pessoais (por endereço de e-mail) de antivírus para correio a entrar. Estas configurações não serão transferidas.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'A política de uso de antivírus no servidor de destino não permite as configurações pessoais (por endereço de e-mail) de antivírus. Estas configurações não serão transferidas.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Para transferir configurações pessoais (por endereço de e-mail) de antivírus, por favor, ative as opções correspondentes em Ferramentas & Configurações > Configurações de Proteção a Vírus.",
    'backup__restore__capability_antivirus_not_active_text' => 'Nenhum software de antivírus está ativado. Todas as configurações de antivírus do servidor de origem não funcionarão até que seja selecionado o software de antivírus no servidor de destino.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Por favor, selecione o software de antivírus em Ferramentas & Configurações > Configurações de Proteção a Vírus > secção de configurações de Antivírus.',

    'backup__restore__capability_antivirus_another_active_text' => 'O software do antivírus %2 não está disponível no servidor de destino. %1 será utilizado.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Para utilizar o mesmo antivírus do servidor de origem, por favor o instale e selecione em Ferramentas & Configurações > Configurações de Proteção a Vírus > secção de configurações de Antivírus.',
    'backup__restore__capability_not_available_sni_text' => 'SNI não está disponível no servidor de destino. Os sites web que tem o mesmo endereço IP não poderão utilizar os certificados SSL/TLS individuais.',
    'backup__restore__capability_not_available_sni_resolution' => "Por favor, verifique se o sistema operativo no servidor de destino suporta SNI e se o suporte para SNI está ativado no Plesk (na caixa 'Ative o suporte SNI, que permite usar certificados SSL/TLS em sites com o mesmo endereço IP' em Ferramentas & Configurações > Configurações do Servidor).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Configurações do servidor',

    'backup__restore__capability_vhost_already_exists_text' => 'A página web %1 não pode ser transferida: uma página web com o mesmo nome já existe no servidor de destino.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Por favor, altere o nome ou remova do servidor a página web com o mesmo nome.',
    'backup__restore__capability_removed_vhosts' => 'As seguintes assinaturas não serão restauradas por conter nomes de domínio já existentes no servidor de destino: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'No servidor de origem existem %3 manipuladores PHP diferentes do tipo %1 e versão %2. Em vez destes, um manipulador do tipo e versão adequados serão utilizados no servidor de destino. Note que as configurações de PHP no servidor fonte e de destino podem ser diferentes.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'O Plesk Installer não suporta o Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'O Plesk Installer não suporta o Python. Por favor instale o Python manualmente.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Definições do servidor de correio',

    'backup__restore__capability_ftps_disabled' => 'A utilização de FTPS seguro é permitida no servidor de origem mas é proibido no servidor de destino. As aplicações de utilizadores que usam FTP podem não funcionar corretamente.',
    'backup__restore__capability_ftps_required' => 'A utilização de FTPS não seguro é permitida no servidor de origem mas é proibida no servidor de destino. As aplicações de utilizadores que usam FTP podem não funcionar corretamente.',
    'backup__restore__capability_ftps_policy_resolution' => 'Alterar a política de FTP Seguro em Ferramentas & Configurações > Política de Segurança.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabytes de dados serão movidos do servidor de origem para o servidor de destino em %2 horas.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Para uma transferência mais rápida, deve verificar a sua ligação de rede entre os servidores de origem e de destino e resolver os problemas (se existirem).',
    'backup__restore__too_low_download_speed' => "menos que 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Para uma transferência mais rápida, deve verificar a sua ligação de rede entre os servidores de origem e de destino e resolver os problemas (se existirem).',
    'backup__restore__capability_zero_download_speed_text' => 'A velocidade mínima aceitável de descarregamento é de %1 MBps. A velocidade de descarregamento entre o servidor de origem e de destino é de 0 MBps. Isso pode ser causado por problemas na ligação de rede. Não é possível fazer a transferência.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Por favor, verifique a sua ligação de rede entre os servidores de origem e de destino e resolva os problemas (se existirem).',
    'backup__restore__capability_too_slow_download_speed_text' => 'A velocidade mínima aceitável de transferência é de %2 MBps. A velocidade de transferência entre o servidor de origem e de destino é de %1 MBps. Isso pode aumentar o tempo de transferência. No seu ambiente atual, a migração de %3 MB demorará %4 horas.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'A velocidade mínima aceitável de transferência é de %2 MBps. A velocidade de transferência entre o servidor de origem e de destino é de %1 MBps. Isso pode aumentar o tempo de transferência.',

    'backup__restore__capability_remote_database_migration' => "Os seguintes domínios estão a utilizar bases de dados remotas: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Depois da transferência não remova esses domínios do servidor de origem se a versão do Plesk no servidor de origem for anterior à 11.5! Em vez disso, suspenda-os. Se remover os domínios, as bases de dados serão removidas do servidor remoto. Observação: Os ficheiros dump das bases de dados remotas serão armazenados no servidor de origem no %1 diretório.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Ficheiros de cópia de segurança dos servidores de base de dados MySQL anteriores à 5.1 (%1) podem não ser repostos no MySQL 5.1.x, porque MySQL 5.1.x manipula carateres Unicode de maneira diferente.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Por favor, leia o artigo de base de conhecimento relacionado #136850',

    'backup__restore__capability_firewall_not_installed_text' => 'A extensão da Firewall não está instalada no servidor de destino. Caso tenha estabelecido regras de restrição de acesso, elas não funcionarão.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'Por favor, instale a extensão da Firewall usando o Plesk Installer.',
    'backup__restore__capability_courier_not_installed_text' => 'O Courier-IMAP não está instalado no servidor de destino.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Por favor, instale o Courier-IMAP pelo Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'O Dovecot não está instalado no servidor de destino.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Por favor, instale o Dovecot usando o Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'O tempo de retenção das estatísticas de tráfego nas configurações dos seguintes objetos é inferior ao valor do servidor no servidor de destino.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Por favor, altere o valor do servidor para o tempo de retenção das estatísticas no servidor de destino. Defina este tempo para igual a ou inferior ao valor mais reduzido nas configurações de domínio.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'O tempo de retenção das estatísticas de tráfego em alguns domínios é inferior ao valor do servidor (%1). O valor será alterado para %1 para estes domínios.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'O tempo de retenção das estatísticas de tráfego em alguns planos de serviços é inferior ao valor do servidor (%1). O valor será alterado para %1 para estes planos de serviço.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'O mapeamento de um endereço IP exclusivo para um partilhado vai desativar os FTP anónimos e HTTPS (exceto se o suporte SNI estiver ligado).',

    'backup__restore__no_postgresql_commands_text' => 'A assinatura utiliza uma base de dados PostgreSQL remota e o seu ficheiro de cópia de segurança temporário não pode ser gerado pois os comandos pg_dump e psql estão em falta no servidor de origem.',
    'backup__restore__no_postgresql_commands_resolution' => 'Instale qualquer pacote de cliente do PostgreSQL que suporte estes comandos.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Os seguintes módulos do Apache estão desativados no servidor de destino: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Por favor, ative estes módulos para evitar possíveis problemas.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Os seguintes módulos do Apache não estão instalados no servidor de destino: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Por favor, instale e ative estes módulos para evitar possíveis problemas.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'O limite de mensagens enviadas não é suportado pela sua licença. As configurações correspondentes não serão transferidas.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Por favor, instale no servidor de destino outra chave de licença que forneça os recursos necessários.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'O limite de mensagens enviadas está desligado no servidor de destino. As configurações correspondentes não serão transferidas.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Por favor, ligue o limite de mensagens enviadas servidor de destino.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Preferências de Correio do Servidor',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'O limite de mensagens enviadas de uma caixa de correio não é suportado pelo servidor de correio utilizado no servidor de destino. O valor deste limite não será transferido.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Altere o servidor de correio para o mesmo utilizado no servidor de origem.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Preferências de correio do Servidor',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'O limite de mensagens enviadas de um domínio não é suportado pelo servidor de correio utilizado no servidor de destino. O valor deste limite não será transferido.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Altere o servidor de correio para o mesmo utilizado no servidor de origem.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Preferências de Correio do Servidor',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'O limite de mensagens enviadas de uma assinatura não é suportado pelo servidor de correio utilizado no servidor de destino. O valor deste limite não será transferido.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Altere o servidor de correio para o mesmo utilizado no servidor de origem.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Preferências de Correio do Servidor',

    'bu_conflict_resolver_absent_phosting' => 'Impossível restaurar os ficheiros especificados pois não existe um alojamento físico para os restaurar. Crie um domínio com alojamento físico e reinicie o backup.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Os dados dos revendedores não serão restaurados porque a administração de revendedores não é suportada.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'A componente ModSecurity não está instalada no servidor de destino.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Por favor, instale o ModSecurity para manter a firewall para aplicações web a funcionar nos sites transferidos. Note que a instalação pode demorar alguns minutos.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Instale o ModSecurity caso deseje transferir as configurações da firewall para aplicações web. Note que a instalação pode demorar alguns minutos.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'A componente ModSecurity não está configurada no servidor de destino.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Configure o ModSecurity caso deseje manter a firewall para aplicações web a funcionar nos sites transferidos.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall para Aplicações Web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'O ModSecurity está desligado no servidor de destino.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Ative o ModSecurity caso deseje manter a firewall para aplicações web a funcionar nos sites transferidos.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall para Aplicações Web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'A componente ModSecurity não está instalada. As configurações da firewall para aplicativos web não serão restauradas para os seguintes objetos: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Os websites não podem ser restaurados pois pertencem à assinatura %1 não encontrada no Plesk:",
    'backup__restore__capability_not_installed_dns_text' => 'O componente %1 não está instalado no servidor de destino. O serviço de DNS estará indisponível e as configurações serão perdidas. Todos os websites de clientes estarão indisponíveis.',
    'bu_conflict_resolver_dns_not_installed' => 'O serviço de DNS não está instalado. As configurações de DNS não serão restauradas para os seguintes objetos: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'As seguintes assinaturas não podem ser restauradas pois foram movidas para outros proprietários: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'As seguintes assinaturas não podem ser restauradas pois foram movidas para outros provedores: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Não é possível encontrar o utilitário de restauro do Construtor de Presença na Web para restaurar os dados do Construtor de Presença Web. O Construtor de Presença Web provavelmente não está instalado.',
    'backup__restore__capability_renamed_db' => 'O nome de base de dados "%1" já está a ser utilizado noutra subscrição. O nome da base de dados restaurada será mudado para "%2".',
    'backup__restore__capability_renamed_db_user' => 'O nome de utilizador de base de dados "%1" já está a ser utilizado noutra subscrição. O nome da base do utilizador da base de dados restaurada será mudado para "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'O Plesk Installer não suporta o Perl. Por favor instale o ActiveState Perl manualmente.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% servido por Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% servido por nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivírus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Conflitos de Data',
    'backup__restore__hint_timing_conflicts' => 'Os conflitos de data ocorrem quando o objecto reposto já existe no sistema com data de modificação mais recente ou quando o objecto reposto não está presente no sistema.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Utilizar a configuração e os dados do backup',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Substituir totalmente a configuração e dados dos objectos actualmente presentes no sistema com a configuração e dados do ficheiro de backup. Se o objecto reposto pertence actualmente a um outro proprietário será reposto no proprietário antigo.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Utilizar a configuração do sistema actual e os dados do backup',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Substituir os dados deste objecto com os dados do ficheiro de backup, mas manter a configuração dos objectos presentes no sistema. Se o objecto reposto pertencer agora a um proprietário diferente, o objecto será reposto no proprietário actual.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Não repor',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Não repor objectos em conflito de data.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Conflitos de Utilização de Recursos',
    'backup__restore__hint_resource_usage_conflicts' => 'Os conflitos de utilização de recursos ocorrem quando os limites de recursos do objecto reposto são excedidos após a reposição.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Permitir sobre-utilização',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Repor o objecto e permitir que utilize mais recursos que os atribuídos inicialmente.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Não repor',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Não repor objectos em conflito com a utilização de recursos.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Conflitos de Configuração',
    'backup__restore__hint_configuration_conflicts' => 'Os conflitos de configuração ocorrem quando o objecto reposto tem configurações e aplicações web que não estão disponíveis ou não tem permissões para os utilizar. Por exemplo, ocorrem conflitos de configuração se nas contas de correio repostas, existem configurações individuais de filtragem de spam e a configuração principal do servidor não o permitir.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automático',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Repor o objeto e ligar automaticamente todas as opções de configuração incompatíveis que as suas permissões permitam gerir.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Não repor',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Não repor objectos que tÊm conflitos de configuração.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Repositórios de aplicação IIS exclusiva não são permitidos nas configurações do repositório de aplicação IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Por favor, altere as suas configurações do repositório de aplicação IIS em Ferramentas & Configurações > Repositório de Aplicação IIS > Configurações Globais.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Repositórios de aplicação IIS partilhada não são permitidos nas configurações do repositório de aplicação IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Por favor, altere as suas configurações do repositório de aplicação IIS em Ferramentas & Configurações > Repositório de Aplicação IIS > Configurações Globais.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Nomes curtos de contas de correio POP3/IMAP não são permitidos no servidor de destino.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Nomes curtos para contas de correio não estarão disponíveis após a reposição de dados.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Impossível abrir o ficheiro de log.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Impossível repor o assinatura %1: Este foi removido da sua conta e você não tem a permissão para criar assinaturas. Se tiver de repor a assinatura, entre em contacto com o seu fornecedor de serviços.',

    'backup__error11' => 'Espaço insuficiente no disco para a cópia de segurança.',
    'backup__error3011' => 'A ligação foi recusada: Não há programas a verificar o endereço e a porta especificados.',
    'backup__error3012' => 'Tempo limite da ligação.',
    'backup__error3013' => 'A rede não está acessível.',
    'backup__error3014' => 'Não há rota para o host.',
    'backup__error3015' => 'Falha na ligação.',
    'backup__error3016' => 'Impossível resolver nome do host.',
    'backup__error3017' => 'Nome de utilizador ou senha incorretos.',
    'backup__error3018' => 'Falha de ligação SSH.',

    'backup__error3110' => 'Impossível ligar ao agente de migração remota. A ligação ao host não está disponível.',
    'backup__error3111' => 'O agente de migração está bloqueado devido a uma tarefa de migração falhada ou está a ser utilizada por outro processo de migração. Por favor, reinicie o agente de migração no servidor de origem.',
    'backup__error3112' => 'A ligação ao host está indisponível ou o agente de migração não está em execução no host de origem.',
    'backup__error3113' => 'Impossível iniciar o agente de migração num host Linux. Por favor, verifique a ligação SSH ao host de origem.',
    'backup__error3114' => 'Impossível iniciar o agente de migração num host Linux: Falha de ligação SSH.',
    'backup__error3115' => 'Nome de utilizador ou senha incorretos.',
    'backup__error3116' => 'O utilizador especificado não possui privilégios de administrador.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Toda a configuração e conteúdo',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Toda a configuração e conteúdo excepto correio',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Só a configuração de correio e o conteúdo',

    'dns_t__unable_to_remove_ns_record' => 'Impossível remover o registo de NS do modelo de DNS: Cada zona de DNS deve ter pelo menos um registo de NS.',
    'dns__unsupported_server_zone_transfer' => 'Impossível transferir o Modelo de Restrições de Transferência por causa da configuração de DNS do servidor: No servidor de origem, os seguintes endereços de rede são permitidos para a transferência de zona, mas estes endereços são proibidos pelo Servidor DNS da Microsoft: %1',
    'dns__unsupported_domain_zone_transfer' => 'Impossível transferir o Modelo de Restrições de Transferência por causa da configuração de DNS dos domínios: Em alguns domínios, os seguintes endereços de rede são permitidos para a transferência de zona, mas estes endereços são proibidos pelo Servidor DNS da Microsoft: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Definir Mapeamento dos Servidores de Base de Dados',
    'dbbackup__check_network_settings_failed' => 'Impossível aceder ao diretório compartilhado temporário na rede para os ficheiros de cópia de segurança. Por favor, verifique o diretório de rede, o nome de utilizador e a senha. Erro: %1',

    'migration_select_exist_db_server' => 'Selecione o servidor da base de dados de destino',

    'dbbackup__temp_dir_wrong_value' => 'Foi especificado o valor inválido para o diretório temporário.',
    'dbbackup__network_temp_dir_wrong_value' => 'Foi especificado o valor inválido para o diretório de rede temporário .',
    'dbbackup__dumpfile_name_is_invalid' => 'O nome do ficheiro de backup da base de dados é inválido. O nome deve conter apenas símbolos alfanuméricos, traço (-), ponto (.) e sublinhado (_). Não utilize nomes como descrição.* no nome do ficheiro de backup.',
    'dbbackup__server_backup_not_configured' => 'As configurações de backup da base de dados não estão configuradas no servidor.',
    'dbbackup__temp_dir' => 'Diretório temporário',
    'dbbackup__temp_dir_hint' => 'O caminho até à pasta física no servidor remoto onde se encontra o servidor MS SQL. O servidor MS SQL deve ser capaz de aceder a esta pasta para ler e escrever ficheiros temporários de cópias de segurança. Por exemplo, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'O caminho para a partilha de rede mapeou para a pasta física especificado acima. Plesk irá aceder à pasta partilhada para descarregar e carregar ficheiros de cópias de segurança. Por exemplo, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'O nome de utilizador de um utilizador da rede no servidor remoto. Por exemplo, ServerName\\UserName. O utilizador deve ter acesso à pasta partilhada especificada acima.',
    'dbbackup__network_password_hint' => 'A palavra-passe dos utilizadores da rede',

    'dbbackup__success_import_without_dublicate_users' => 'Os seguintes utilizadores não foram importados: %1. Eles já existem no servidor da base de dados.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Comprimir arquivos de log",
    'log_rot__log_rot_status' => "Estado da rotação do registo",
    'log_rot__log_rot_period' => "Condição de rotacionamento de log",
    'log_rot__log_rot_size' => "por tamanho",
    'log_rot__log_rot_time' => "por tempo",
    'log_rot__logrotation_enable' => "Ligar o rotacionamento do log",
    'log_rot__mail' => "Enviar os ficheiros de log processados para o e-mail",
    'log_rot__max_number_of_logfiles' => "Número máximo de arquivos de log",
    'log_rot__time_period' => "Período",
    'log_rot__unable_turn_off' => 'Impossível desativar a rotação de registo porque ela é forçada a nível do servidor',
    'log_rot__unable_set_period' => 'Impossível definir o período de rotação do registo diferente de \'diário\', porque ele é forçado a nível do servidor',
    'log_rot__unable_set_max_log_files' => 'Impossível definir um número máximo de ficheiros de registo superior ao limite de todo o servidor %1',

    /// action log
    // common/various
    'actionlog__confirm_clean_log' => "Tem a certeza que deseja eliminar os registos do log de acção seleccionados?",
    'actionlog__digit_expected' => "Um número esperado: %1",
    'actionlog__dont_remove_recs' => "não remover registos",
    'actionlog__from_date' => "De:",
    'actionlog__incorrect_rotation' => "Parâmetros de rotatividade do log especificados são inválidos: %1",
    'actionlog__js_incorrect_date' => "Dados especificados inválidos",
    'actionlog__js_incorrect_num_periods' => "Período de rotação inválido",
    'actionlog__js_incorrect_num_records' => "Número de registos especificados inválido.",
    'actionlog__logged_actions' => "Acções gravadas no log",
    'actionlog__period_day' => "dias",
    'actionlog__period_month' => "meses",
    'actionlog__period_week' => "semanas",
    'actionlog__settings' => "Configurações do Registo de ações",
    'actionlog__store_logs_in_db' => "Gravar registos na base de dados",
    'actionlog__store_number' => "entradas",
    'actionlog__to_date' => "Para:",
    'actionlog__unknown_rot_period' => "Período de rotação desconhecido: %1",
    'actionlog__unknown_rot_type' => "Tipo de rotação desconhecido: %1",
    'actionlog__wrong_date_period' => "Data inválida",
    'actionlog__session_preferences' => 'Configurações de Sessão',
    // items (PFU schema)
    'actionlog__admin_info' => 'Informação do administrador',
    'actionlog__admin_preferences' => "Preferências de administrador.",
    'actionlog__service' => 'Serviço',
    'actionlog__ip_addr' => 'Endereço IP',
    'actionlog__client' => 'Conta de cliente',
    'actionlog__client_status' => 'Estado da conta de cliente',
    'actionlog__client_preferences' => "Preferências de interface do cliente",
    'actionlog__client_ip_pool' => "Repositório de IP do cliente",
    'actionlog__client_siteapp' => "Repositório de aplicações do cliente",
    'actionlog__client_guid' => "GUID do cliente",
    'actionlog__domain' => 'Domínio predefinido (o primeiro domínio adicionado a uma assinatura)',
    'actionlog__domain_owner' => 'Proprietário da assinatura',
    'actionlog__domain_plan' => 'Plano de serviço da assinatura',
    'actionlog__domain_status' => 'Domínio predefinido, estado',
    'actionlog__domain_dns' => 'Domínio predefinido, zona DNS',
    'actionlog__subdomain' => 'Sub-domínio de um domínio predefinido',
    'actionlog__domain_alias' => 'Domínio predefinido, nome alternativo',
    'actionlog__domain_alias_dns' => 'Domínio predefinido, zona DNS do nome alternativo',
    'actionlog__site' => 'Domínio',
    'actionlog__site_status' => 'Estado de domínio',
    'actionlog__site_dns' => 'Zona de DNS do domínio',
    'actionlog__site_guid' => 'GUID do domínio',
    'actionlog__site_subdomain' => 'Sub-domínio',
    'actionlog__site_alias' => 'Nome alternativo de domínio',
    'actionlog__site_alias_dns' => 'Zona de DNS do nome alternativo de domínio',
    'actionlog__domain_limits' => 'Limites do assinatura',
    'actionlog__domain_limit_size' => 'Limite de espaço em disco para assinatura',
    'actionlog__domain_limit_traffic' => 'Limite de tráfego para assinatura',
    'actionlog__domain_limits_powerUser' => 'Limites do assinatura',
    'actionlog__domain_limit_size_powerUser' => 'Limite de espaço em disco para assinatura',
    'actionlog__domain_limit_traffic_powerUser' => 'Limite de tráfego para assinatura',
    'actionlog__domain_guid' => "Domínio predefinido, GUID",
    'actionlog__cp_user' => 'Utilizador do Plesk',
    'actionlog__mailname' => 'Conta de correio',
    'actionlog__maillist' => 'Lista de envio',
    'actionlog__phosting' => 'Definições de alojamento',
    'actionlog__forwarding' => 'Reendereçamento padrão ou de janela (frame forwarding)',
    'actionlog__webuser' => 'Conta do utilizador de Web',
    'actionlog__site_application' => 'Aplicação web',
    'actionlog__license' => 'Chave de licença',
    'actionlog__additional_license' => 'Chave de licença adicional',
    'actionlog__template_domain' => "Plano de serviço do revendedor",
    'actionlog__template_admin' => "Plano de serviço do administrador",
    'actionlog__template_reseller' => 'Plano do revendedor',
    'actionlog__admin_alias' => 'Conta de administrador adicional', // PFW
    'actionlog__ftpuser' => 'Sub-conta de FTP', // PFW
    'actionlog__db_server' => 'Servidor da base de dados',
    'actionlog__db' => 'Base de dados',
    'actionlog__db_user' => 'Conta de utilizador de base de dados',
    'actionlog__client_sapppkg_pool' => "Aplicações do utilizador", // PFW, not used?
    'actionlog__remote_dns' => 'Estado do servidor remoto de DNS', // PFW
    'actionlog__reseller' => 'Conta de revenda',
    'actionlog__reseller_guid' => 'GUID do revendedor',
    'actionlog__reseller_ip_pool' => "Repositório de IP's do revendedor",
    'actionlog__reseller_limit_size' => 'Limite de espaço em disco para a conta de revenda',
    'actionlog__reseller_limit_traffic' => 'Limite de tráfego da conta de revenda',
    'actionlog__reseller_limits' => 'Limites da conta de revenda',
    'actionlog__reseller_permissions' => 'Permissões do revendedor',
    'actionlog__reseller_preferences' => "Preferências de interface do revendedor",
    'actionlog__reseller_siteapp' => "Aplicações web no repositório do revendedor",
    'actionlog__reseller_status' => 'Estado da conta de revenda',
    'actionlog__health_status' => 'Estado de integridade do servidor',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'alcançado',
    'actionlog__added' => 'adicionado',
    'actionlog__removed' => 'removido',
    'actionlog__change' => 'modificado',
    'actionlog__update' => 'actualizado',
    'actionlog__move' => 'movido',
    'actionlog__upgrade' => 'actualizado', // PFU?
    'actionlog__update_or_add' => 'actualizado ou adicionado',
    'actionlog__expired' => 'expirou',
    'actionlog__create' => 'criou',
    'actionlog__delete' => 'apagou',
    'actionlog__service_stop' => 'parou',
    'actionlog__service_restart' => 'reiniciou',
    'actionlog__service_start' => 'começou',
    'actionlog__login' => 'entrou',
    'actionlog__logout' => 'saiu',
    'actionlog__install' => 'instalou',
    'actionlog__uninstall' => 'desinstalou',
    'actionlog__reconfigure' => 'reconfigurado',
    // events (PFW schema)
    'actionlog__event_admin_update' => 'A informação do Administrador foi actualizada',
    'actionlog__event_admin_preferences_update' => "Preferências de administrador atualizadas",
    'actionlog__event_service_restart' => 'O serviço reiniciou',
    'actionlog__event_service_start' => 'O serviço iniciou',
    'actionlog__event_service_stop' => 'O serviço parou',
    'actionlog__event_ip_address_create' => 'Foi criado o endereço IP',
    'actionlog__event_ip_address_delete' => 'Foi eliminado o endereço IP',
    'actionlog__event_ip_address_update' => 'Endereço IP actualizado',
    'actionlog__event_client_create' => 'A conta do cliente foi criada',
    'actionlog__event_client_delete' => 'A conta do cliente foi eliminada',
    'actionlog__event_client_update' => 'A conta do cliente foi atualizada',
    'actionlog__event_client_status_update' => 'O estado da conta do cliente foi atualizado',
    'actionlog__event_client_preferences_update' => "As preferências de interface do cliente foram atualizadas",
    'actionlog__event_client_siteapp_added' => "A aplicação foi adicionada ao repositório de aplicações do cliente",
    'actionlog__event_client_siteapp_removed' => "A aplicação foi removida do repositório de aplicações do cliente",
    'actionlog__event_domain_limit_size_reached' => 'O limite de espaço em disco para assinatura foi alcançada',
    'actionlog__event_domain_limit_traffic_reached' => 'O limite de tráfego do domínio foi alcançado',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'O limite de espaço em disco para assinatura foi alcançada',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Limite de tráfego para assinatura atingido',

    'actionlog__domain_limit_database' => 'Quota de bases de dados para subscrição',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'A quota de bases de dados MySQL da subscrição foi atingida',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'A quota não restritiva de bases de dados MySQL da subscrição foi atingida',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'A quota de bases de dados de servidor Microsoft SQL para esta subscrição foi atingida',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'A quota não restritiva de bases de dados de servidor Microsoft SQL para esta subscrição foi atingida',
    'actionlog__event_plesk_component_upgrade' => 'Componente Plesk atualizado',
    'actionlog__event_plesk_component_install' => 'Componente Plesk instalado',
    'actionlog__event_plesk_component_uninstall' => 'Componente Plesk desinstalado',
    'actionlog__event_domain_create' => 'Domínio predefinido (o primeiro domínio adicionado a uma assinatura) criado',
    'actionlog__event_domain_delete' => 'Domínio predefinido (o primeiro domínio adicionado a uma assinatura) eliminado',
    'actionlog__event_domain_update' => 'Domínio predefinido (o primeiro domínio adicionado a uma assinatura) atualizado',
    'actionlog__event_domain_owner_change' => 'O proprietário da assinatura foi alterada',
    'actionlog__event_domain_plan_change' => 'Plano de serviço da assinatura alterado',
    'actionlog__event_domain_status_update' => 'Domínio predefinido, estado atualizado',
    'actionlog__event_domain_dns_update' => 'Domínio predefinido, zona de DNS atualizada',
    'actionlog__event_subdomain_create' => 'O sub-domínio de um domínio predefinido foi criado',
    'actionlog__event_subdomain_delete' => 'O sub-domínio de um domínio predefinido foi eliminado',
    'actionlog__event_subdomain_update' => 'O sub-domínio de um domínio predefinido foi atualizado',
    'actionlog__event_domain_alias_create' => 'Domínio predefinido, nome alternativo foi criado',
    'actionlog__event_domain_alias_delete' => 'Domínio predefinido, nome alternativo foi eliminado',
    'actionlog__event_domain_alias_update' => 'Domínio predefinido, nome alternativo foi atualizado',
    'actionlog__event_domain_limits_update' => 'Limites da assinatura atualizados',
    'actionlog__event_cp_user_login' => 'O utilizador do Plesk está ligado',
    'actionlog__event_cp_user_logout' => 'O utilizador do Plesk está desligado',
    'actionlog__event_mailname_create' => 'A conta de correio criada',
    'actionlog__event_mailname_delete' => 'Conta de correio eliminada',
    'actionlog__event_mailname_update' => 'Conta de correio actualizada',
    'actionlog__event_maillist_create' => 'Foi criada lista de envio',
    'actionlog__event_maillist_delete' => 'A lista de envio foi eliminada',
    'actionlog__event_maillist_update' => 'A lista de envio foi actualizada',
    'actionlog__event_phys_hosting_create' => 'Criado alojamento físico',
    'actionlog__event_phys_hosting_delete' => 'Eliminado alojamento físico',
    'actionlog__event_phys_hosting_update' => 'Actualizado alojamento físico',
    'actionlog__event_forwarding_create' => 'Foi criado o alojamento standard ou de reendereçamento por frame',
    'actionlog__event_forwarding_delete' => 'Foi eliminado o alojamento standard ou de reendereçamento por frame',
    'actionlog__event_forwarding_update' => 'Foi actualizado o alojamento standard ou de reendereçamento por frame',
    'actionlog__event_webuser_create' => 'Criada a conta de um utilizador Web',
    'actionlog__event_webuser_delete' => 'Eliminada a conta de um utilizador Web',
    'actionlog__event_webuser_update' => 'Actualizada a conta de um utilizador Web',
    'actionlog__event_siteapp_install' => 'Aplicação web instalada',
    'actionlog__event_siteapp_reconfigure' => 'Aplicação web reconfigurada',
    'actionlog__event_siteapp_uninstall' => 'Aplicação web desinstalada',
    'actionlog__event_license_update' => 'Chave de licença actualizada',
    'actionlog__event_admin_alias_create' => 'Foi criada uma conta de administrador adicional',
    'actionlog__event_admin_alias_delete' => 'Conta de administrador adicional removida',
    'actionlog__event_admin_alias_update' => 'Conta de administrador adicional actualizada',
    'actionlog__event_ftpuser_create' => 'A sub-conta de FTP foi criada',
    'actionlog__event_ftpuser_update' => 'A sub-conta de FTP foi atualizada',
    'actionlog__event_ftpuser_delete' => 'A sub-conta de FTP foi eliminada',
    'actionlog__event_template_domain_create' => "O plano de serviço do revendedor foi criado",
    'actionlog__event_template_domain_update' => "O plano de serviço do revendedor foi atualizado",
    'actionlog__event_template_domain_delete' => "O plano de serviço do revendedor foi eliminado",
    'actionlog__event_template_admin_create' => "O plano de serviço do administrador foi criado",
    'actionlog__event_template_admin_update' => "O plano de serviço do administrador foi atualizado",
    'actionlog__event_template_admin_delete' => "O plano de serviço do administrador foi eliminado",
    'actionlog__event_database_server_create' => 'Servidor de base de dados criado',
    'actionlog__event_database_server_update' => 'Servidor de base de dados actualizado',
    'actionlog__event_database_server_delete' => 'Servidor de base de dados eliminado',
    'actionlog__event_remote_dns_status_update' => 'O estado do servidor remoto de DNS foi actualizado',
    'actionlog__event_session_preferences_update' => 'As configurações da sessão foram atualizadas',
    'actionlog__event_domain_alias_dns_update' => 'Domínio predefinido, a zona de DNS do nome alternativo de domínio foi atualizada',
    'actionlog__event_domain_move' => 'Domínio predefinido movido para uma nova assinatura',
    'actionlog__event_site_move' => 'Domínio movido para uma nova assinatura',
    'actionlog__event_site_subdomain_move' => 'Subdomínio movido para uma nova assinatura',
    'actionlog__event_subdomain_move' => 'Subdomínio de um domínio predefinido movido para uma nova assinatura',
    'actionlog__event_license_expired' => 'A licença do Plesk expirou.',
    'actionlog__event_database_create' => 'Base de dados criada',
    'actionlog__event_database_delete' => 'Base de dados removida',
    'actionlog__event_database_user_create' => 'Utilizador da base de dados criado',
    'actionlog__event_database_user_update' => 'As configurações da conta do utilizador da base de dados foram atualizadas.',
    'actionlog__event_database_user_delete' => 'A conta do utilizador da base de dados foi removida',
    'actionlog__event_client_guid_update' => "O GUID do cliente foi atualizado",
    'actionlog__event_domain_guid_update' => 'Domínio predefinido, GUID atualizado',
    'actionlog__event_reseller_create' => 'A conta de revenda foi criada',
    'actionlog__event_reseller_delete' => 'Conta de revenda eliminada',
    'actionlog__event_reseller_update' => 'Conta de revenda actualizada',
    'actionlog__event_reseller_guid_update' => 'Foi actualizado o GUID do revendedor',
    'actionlog__event_reseller_ip_pool_update' => "O repositório de IP's do revendedor foi actualizado",
    'actionlog__event_reseller_limit_size_reached' => 'O limite de espaço em disco para a conta de revenda foi alcançado',
    'actionlog__event_reseller_limit_traffic_reached' => 'O limite de tráfego da conta de revenda foi atingido',
    'actionlog__event_reseller_limits_update' => 'Os limites da conta de revenda foram actualizados',
    'actionlog__event_reseller_permissions_update' => 'As permissões da conta de revenda foram actualizadas',
    'actionlog__event_reseller_preferences_update' => "As preferências do revendedor foram actualizadas",
    'actionlog__event_reseller_siteapp_added' => "A aplicação foi adicionada ao repositório de aplicações do revendedor",
    'actionlog__event_reseller_siteapp_removed' => "A aplicação foi removida do repositório de aplicações do revendedor",
    'actionlog__event_reseller_status_update' => 'O estado da conta de revenda foi actualizado',
    'actionlog__event_template_reseller_create' => 'O plano do revendedor foi criado',
    'actionlog__event_template_reseller_delete' => 'O plano do revendedor foi eliminado',
    'actionlog__event_template_reseller_update' => 'O plano do revendedor foi atualizado',
    'actionlog__event_health_status_change' => 'O estado de integridade do servidor foi alterado',
    'actionlog__event_siteapp_upgrade' => 'As aplicações foram atualizadas',
    'actionlog__event_extension_install' => 'Extensão instalada',
    'actionlog__event_extension_uninstall' => 'Extensão desinstalada',
    'actionlog__event_extension_upgrade' => 'Extensão atualizada',
    'actionlog__event_extension_status_update' => 'Estado de extensão atualizado',
    'actionlog__event_additional_license_expired' => 'A licença adicional caducou',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "O API RPC do Plesk não está instalado no host remoto. Entre em contacto com o seu fornecedor de serviço para obter assistência.",
    'rsession_no_account_errmsg' => "Impossível aceder ao serviço remoto com a sua conta. Provavelmente o serviço para a sua conta ainda não está activado. Por favor, espere alguns minutos, e tente de novo. Se encontrar este erro de novo, contacte o seu administrador de sistemas.",
    'rsession_no_domain_errmsg' => "Impossível aceder ao serviço remoto deste domínio. Provavelmente o serviço para este domínio ainda não está activado. Por favor, espere alguns minutos, e tente de novo. Se encontrar este erro de novo, contacte o seu administrador de sistemas.",
    'rsession_unknown_errmsg' => "O servidor remoto rejeitou a tentativa de estabelecer uma sessão. Contacte o seu administrador de sistemas. O erro foi: %1",
    'rsession_unknown2_errmsg' => "Erro desconhecido ao estabelecer uma sessão remota. O mais provável é que o servidor remoto não esteja a responder correctamente ou que não esteja mesmo a responder. Contacte o seu administrador de sistema para verificar os detalhes do erro no log de erros do servidor Web.",
    'rsession_no_connect_errmsg' => "Impossível aceder ao serviço remoto: a conexão para a sessão remota falhou. Contacte o seu administrador de sistemas para obter suporte.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Permitir carregar para o directório de entrada",
    'anonftp__allow_create_dirs' => 'Permitir criação de directórios no directório de entrada',
    'anonftp__allow_download_incoming' => 'Permitir descarregar a partir do directório de entrada',
    'anonftp__display_login' => 'Apresentar mensagem de entrada',
    'anonftp__login_text' => 'Texto da mensagem',
    'anonftp__limit_incoming_disk_space' => "Limite de espaço em disco no directório de entrada",
    'anonftp__limit_maximum_bandwidth' => "Limite de largura de banda de download para este domínio FTP virtual",
    'anonftp__limit_maximum_connections' => "Limite de número de conexões simultâneas",
    'anonftp__unable_init' => "Impossível inicializar a conta de FTP anónimo: %1",
    'anonftp__unable_set_quota' => "Impossível configurar o limite de espaço em disco no directório de entrada: %1",
    'anonftp__unable_update' => "Impossível actualizar as propriedades da conta de FTP anónimo: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Certificados SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "O certificado de CA não assina o certificado.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Par chave privada/certificado incompatível",
    'class_sslcertificate__invalid_cert_format' => "Formato inválido de certificado.",
    'class_sslcertificate__invalid_private_key_format' => "Formato inválido de chave privada.",
    'class_sslcertificate__prob_invalid_priv_key' => "Provavelmente, o formato da chave privada é inválido.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Criar Directório Virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Criar Directório Virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Criar um diretório virtual.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Criar Directório Virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Criar Directório Virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Criar um diretório virtual.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Criar Directório',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Criar Directório',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Criar um diretório.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Criar Directório',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Criar Directório',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Criar um diretório.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Propriedades do Directório',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Propriedades do Directório Virtual',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Ver e mudar as propriedades do directório virtual.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Propriedades do Directório',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Propriedades do Directório Virtual',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Ver e mudar as propriedades do directório virtual.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Permissões de Acesso de Directório',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Permissões de Acesso de Directório',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Configurar as permissões de acesso a um directório.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Permissões de Acesso de Directório',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Permissões de Acesso de Directório',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Configurar as permissões de acesso a um directório.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Definições ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Definições ASP.NET para %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Configurar as definições do ASP.NET para o directório virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Definições ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Definições ASP.NET para %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Configurar as configurações do ASP.NET para o diretório virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'Alterar Versão',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'Alterar Versão',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'Alterar a versão do ASP.NET utilizada pelo directório virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'Alterar Versão',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'Alterar Versão',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'Alterar a versão do ASP.NET utilizada pelo directório virtual %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Definições PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Definições PHP para %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Configurar as configurações de PHP para o diretório virtual %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Definições PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Definições PHP para %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Configurar as configurações de PHP para o diretório virtual %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Eliminar',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Remover Diretórios Virtuais',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Remover os diretórios virtuais selecionados.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Eliminar',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Remover Diretórios Virtuais',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Remover os diretórios virtuais selecionados.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Os seguintes diretórios virtuais serão removidos:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'É necessário selecionar os diretórios que quer remover.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME Type',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME Type',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Ver a lista de MIME Types registados.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Adicionar MIME Type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Adicionar um MIME Type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Registar um novo MIME Type.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Documentos de Erros',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Documentos de Erros',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Ver e mudar os documentos de erro.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Protecção',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Protecção do Directório',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Restringir o acesso ao diretório com proteção por palavra-passe.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Protecção',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Protecção do Directório',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Restringir o acesso ao diretório com proteção por palavra-passe.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Configurações',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Ver o local do diretório e especificar um título para a área protegida.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Adicionar Utilizador',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Adicionar uma conta de utilizador para permitir o acesso ao diretório protegido.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'As novas configurações foram aplicadas.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'A conta de utilizador foi adicionada.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Remover utilizadores do diretório protegido.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Remover Contas de Utilizador',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Confirmar a remoção das contas de utilizador.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'As contas de utilizador foram removidas.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => 'O processo de verificação de permissões foi iniciado. Após o término do processo de verificação, será enviada uma notificação para o seguinte endereço de e-mail: %1', // PFW
    'additional_keys__install_done' => 'A instalação da chave de licença foi iniciada.',

    // UI
    'ui____done' => 'Operação terminada com sucesso.',
    'ui__actionlog__done' => "As alterações nas configurações de registo de ações foram guardadas.",
    'ui__admin/extras-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__admin/interface__done' => 'As alterações das preferências de interface do administrador do servidor foram guardadas.',
    'ui__admin/report/layout/delete_multi__done' => 'Os formatos de relatório foram removidos',
    'ui__admin/report/traffic-history__done' => 'Operação terminada com sucesso',
    'ui__admin/report__done' => 'Operação terminada com sucesso',
    'ui__admin-alias/delete_multi__done' => "As contas de administrador adicionais seleccionadas foram removidas.",
    'ui__admin-alias/properties__done' => "As propriedades da sub-conta de administrador foram actualizadas.",
    'ui__admin-alias/properties_new__done' => "Foi criada uma sub-conta de administrador.",
    'ui__admin-alias/properties_unknown__done' => "As propriedades da sub-conta de administrador foram actualizadas.",
    'ui__admin-alias__done' => "A informação da sub-conta de administrador foi actualizada com sucesso.",
    'ui__admin/manage-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__admin/register-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'As entregas de relatório agendadas foram removidas.',
    'ui__admin/report/layout/auto/properties__done' => 'Foi actualizada a agenda uma entrega de relatório.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Foi agendado uma entrega de relatório.',
    'ui__admin/report/layout/properties__done' => 'Foi actualizado o formato de relatório %1.',
    'ui__admin/report/layout/properties_new__done' => 'Foi criado o formato de relatório %1.',
    'ui__client/chowner__done' => 'Foi atribuído um novo proprietário da conta de cliente %1.',
    'ui__client/chowner_multi__done' => "As contas de utilizador seleccionadas foram transferidas para outro proprietário.",
    'ui__client/chowner_multi-select__done' => 'Operação terminada com sucesso.',
    'ui__client/chowner_select__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/certificate/properties__done' => 'As propriedades do certificado SSL/TLS foram actualizadas.',
    'ui__client/domain/certificate/properties_new__done' => 'Um novo certificado SSL/TLS foi adicionado. Para fazê-lo funcionar, certifique-se que ele está selecionado nas configurações de alojamento da página web (no separador Página Web & Domínios > nome de domínio).',
    'ui__client/domain/certificate__done' => 'Operação terminada com sucesso',
    'ui__client/domain/certificate_self__done' => 'Operação terminada com sucesso',
    'ui__client/domain/check-permissions_multi__done' => 'A verificação das permissões nos domínios seleccionados terminou.', // PFW
    'ui__client/domain/chowner__done' => 'A assinatura %1 pertence agora a outro utilizador.',
    'ui__client/domain/chowner_multi__done' => 'A propriedade da assinatura foi alterada.',
    'ui__client/domain/chowner_multi-select__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/chowner_select__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/dbbackup/create__done' => "O backup da base de dados foi executado com sucesso.", // PFW
    'ui__client/domain/dbbackup/get__done' => "O backup da base de dados foi executado com sucesso.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "O utilizador órfão foi reparado com sucesso.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Os ficheiros de backup foram removidos com sucesso.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "O conteúdo da base de dados foi reposto com sucesso.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "A operação foi completada com sucesso.", // PFW
    'ui__client/domain/dbbackup__done' => "A operação foi completada com sucesso.", // PFW
    'ui__client/domain/dbbackup_self__done' => "A operação foi completada com sucesso.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "A operação foi completada com sucesso.", // PFW
    'ui__client/domain/delete__done' => "O domínio %1 foi removido.",
    'ui__client/domain/delete_multi__done' => "Os domínios foram removidos.",
    'ui__client/domain/disable__done' => 'O domínio %1 foi suspenso.',
    'ui__client/domain/disable_multi__done' => 'Os domínios selecionados foram suspensos.',
    'ui__client/domain/enable__done' => 'A página web %1 foi ativada.',
    'ui__client/domain/enable_multi__done' => 'Os sites web selecionados foram ativados.',
    'ui__client/domain/extras__done' => 'A página MyPlesk.com foi aberta.',
    'ui__client/domain/extras_self__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'Os ficheiros e directórios seleccionados foram copiados ou movidos.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'O directório foi criado.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'O ficheiro foi criado.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'O ficheiro foi actualizado.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'As permissões de acesso do ficheiro ou directório foram actualizadas.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'O nome do directório ou ficheiro foi modificado.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'Os ficheiros e directórios seleccionados foram removidos.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'Os ficheiros e directórios seleccionados foram removidos.',
    'ui__client/domain/hosting/file-manager/view__done' => 'A operação foi completada com sucesso.',
    'ui__client/domain/hosting/file-manager__done' => 'A operação foi completada com sucesso.',
    'ui__client/domain/hosting/file-manager_self__done' => 'A operação foi completada com sucesso.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'As configurações de rotação de registo foram alteradas.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'As configurações de rotação de registo foram alteradas.',
    'ui__client/domain/hosting/logs__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/hosting/logs_self__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/hosting/performance__done' => 'As configurações de desempenho de host para a página web %1 foram ajustadas.',
    'ui__client/domain/hosting/performance_self__done' => 'As configurações de desempenho de host para a sua página web foram ajustadas.',
    'ui__client/domain/hosting/performance_unknown__done' => 'Foram ajustadas as configurações de desempenho do alojamento Web.',
    'ui__client/domain/hosting/php__done' => 'As configurações de PHP foram alteradas.', // PFW
    'ui__client/domain/hosting/php_self__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/hosting/protected-directories__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/hosting/setup__done' => 'Foi configurado o alojamento para %1.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operação terminada com sucesso.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operação terminada com sucesso.', // PFU
    'ui__client/domain/hosting/tsclient__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/hosting/tsclient_self__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/hosting/virtual-directories__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'A versão do ASP.NET foi alterada.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'As configurações de ASP.NET para %1 foram alteradas.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'O diretório virtual foi criado na página web %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'O diretório virtual foi criado.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Os diretórios selecionados foram removidos.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Os diretórios selecionados foram removidos.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Os documentos de erros personalizados foram actualizados.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Os MIME Types seleccionados foram removidos', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Foi registado um novo MIME Type..', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Operação terminada com sucesso', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'As permissões de acesso de directório foram actualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'As permissões de acesso de directório foram actualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'As definições PHP para %1 foram actualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'As definições PHP para %1 foram actualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'As propriedades do diretório foram atualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'As propriedades do diretório foram atualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'As configurações de proteção ao diretório foram atualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'As configurações de proteção ao diretório foram atualizadas.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "A operação foi completada com sucesso.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Certificados SSL/TLS estão disponíveis na loja virtual',
    'ui__client/domain/mpc-certificates_self__done' => 'Certificados SSL/TLS estão disponíveis na loja virtual',
    'ui__client/domain/odbc__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/odbc_self__done' => 'Operação terminada com sucesso.', // PFW
    'ui__client/domain/properties__done' => "A conta do administrador do domínio foi modificada.",
    'ui__client/domain/properties_new__done' => "Foi criado o domínio %1.",
    'ui__client/domain/properties_self__done' => "As propriedades do seu domínio foram modificadas.",
    'ui__client/domain/register__done' => 'A página MyPlesk.com foi aberta.',
    'ui__client/domain/register_self__done' => 'A página MyPlesk.com foi aberta.',
    'ui__client/domain/rename__done' => 'O nome de domínio foi alterado.',
    'ui__client/domain/rename_self__done' => "O nome de domínio foi alterado com sucesso.",
    'ui__client/domain/report/anon-ftp-stats__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/report/ftp-stats__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/report/ftp-stats_self__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/report/traffic-history__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/report/traffic-history_self__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/report/webalizer-preferences__done' => 'Operação terminada com sucesso.', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => 'Operação terminada com sucesso.', // PFU
    'ui__client/domain/report/web-stats__done' => 'A página de estatísticas de rede foi aberta.',
    'ui__client/domain/report/web-stats_self__done' => 'A página de estatísticas de rede foi aberta.',
    'ui__client/domain/report/web-stats-ssl__done' => 'A página de estatísticas de rede foi aberta.',
    'ui__client/domain/report/web-stats-ssl_self__done' => 'A página de estatísticas de rede foi aberta.',
    'ui__client/domain/report__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/report_self__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/settings_self__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/to-client__done' => 'A conta de administrador de domínio %1 foi convertida para uma conta de cliente.',
    'ui__client/domain/to-client_multi__done' => 'As contas de administrador de domínio foram convertidas para contas de cliente.',
    'ui__client/domain/toggle_disable__done' => "O domínio %1 foi suspenso.",
    'ui__client/domain/toggle_enable__done' => "O domínio %1 foi ativado.",
    'ui__client/domain/traffic__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/traffic_self__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/traffic_unknown__done' => 'Operação terminada com sucesso.',
    'ui__client/domain/web-stats__done' => 'Operação terminada com sucesso.',
    'ui__client/domain-summary-report__done' => 'Operação terminada com sucesso.',
    'ui__client/domain-summary-report_self__done' => 'Operação terminada com sucesso.',
    'ui__client/domain-summary-report_unknown__done' => 'Operação terminada com sucesso.',
    'ui__client/extras-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__client/extras-domain_self__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__client/ipaddress/delete_multi__done' => 'Operação terminada com sucesso.',
    'ui__client/ipaddress/properties__done' => 'Operação terminada com sucesso.',
    'ui__client/ipaddress/properties_new__done' => 'Operação terminada com sucesso.',
    'ui__client/ip-pool/properties__done' => "O repositório de IP do cliente %1 foi atualizado.",
    'ui__client/ip-pool/properties_self__done' => 'A operação foi completada com sucesso.',
    'ui__client/limits__done' => "Os limites de recursos para cliente %1 foram alterados.",
    'ui__client/limits_self__done' => 'Operação terminada com sucesso.',
    'ui__client/logo__done' => 'As novas configurações de marca para o cliente %1 foram aplicadas.',
    'ui__client/logo_reseller__done' => 'As novas configurações de marca do painel de controlo foram aplicadas.',
    'ui__client/logo_self__done' => 'As configurações de marca foram aplicadas.',
    'ui__client/logo_self-reseller__done' => 'As suas configurações de marca do painel de controlo foram aplicadas.',
    'ui__client/manage-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__client/manage-domain_self__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__client/permissions__done' => "As permissões do cliente %1 foram alteradas.",
    'ui__client/permissions_self__done' => 'A operação foi completada com sucesso.',
    'ui__client/preferences__done' => "As preferências para o cliente %1 foram alteradas.",
    'ui__client/preferences_self__done' => "As suas preferências foram alteradas.",
    'ui__client/register-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__client/register-domain_self__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__client/report/traffic-history__done' => 'Operação terminada com sucesso.',
    'ui__client/report/traffic-history_self__done' => 'Operação terminada com sucesso.',
    'ui__client/report__done' => 'Operação terminada com sucesso.',
    'ui__client/report_self__done' => 'Operação terminada com sucesso.',
    'ui__client/sessions/delete__done' => 'A operação foi completada com sucesso.',
    'ui__client/sessions/delete_self__done' => 'A operação foi completada com sucesso.',
    'ui__client/sessions__done' => 'Operação terminada com sucesso.',
    'ui__client/sessions_self__done' => 'Operação terminada com sucesso.',
    'ui__client/skeleton__done' => 'Operação terminada com sucesso.',
    'ui__client/skeleton_self__done' => 'Operação terminada com sucesso.',
    'ui__client/to-reseller__done' => 'A conta de cliente %1 foi convertida para uma conta de revendedor.',
    'ui__client/to-reseller_multi__done' => "As contas de cliente selecionadas foram convertidas para contas de revendedor.",
    'ui__client/traffic__done' => "A operação foi completada com sucesso.",
    'ui__client/traffic_unknown__done' => 'Operação terminada com sucesso.',
    'ui__cp-access__done' => 'Operação terminada com sucesso.',
    'ui__cp-session/properties__done' => 'Operação terminada com sucesso.',
    'ui__cp-session__done' => 'Operação terminada com sucesso.',
    'ui__ftp-sessions__done' => 'Operação terminada com sucesso.',
    'ui__license__done' => 'A operação foi completada com sucesso.',
    'ui__logo__done' => "As propriedades de personalização do Plesk foram alteradas.",
    'ui__longtasks/longtask/properties__done' => "As configurações da tarefa em segundo plano foram alteradas com sucesso.",
    'ui__mass-email/delete__done' => "O modelo de mensagem %1 foi removido.", // PFW
    'ui__mass-email/delete_multi__done' => "Foram removidos modelos de mensagens.",  // PFW
    'ui__mass-email/send_main__done' => "A operação foi completada com sucesso.",  // PFW
    'ui__mass-email/send_selectclients__done' => "As contas de cliente foram selecionadas com sucesso.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "As contas de administrador de domínio foram selecionadas com sucesso.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'As contas de revendedor foram selecionadas com sucesso.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'As alterações ao modelo de mensagem de e-mail em massa foram guardadas.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'O modelo de mensagem de e-mail em massa foi criado.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'As contas de cliente para o modelo de mensagem de e-mail em massa foram selecionadas.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'As contas de administrador de domínio para o modelo de mensagem de e-mail em massa foram selecionadas.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'As contas de revendedor para o modelo de mensagem de e-mail em massa foram selecionadas.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "O modelo de mensagem de e-mail em massa foi alterado.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Foram definidos valores inválidos.', // PFW
    'ui__mass-email__done' => "A operação foi completada com sucesso.", // PFW
    'ui__mass-mail__done' => "A operação foi completada com sucesso.", // PFU
    'ui__mass-mail/delete__done' => 'O modelo de mensagem %1 foi removido.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Os modelos de mensagem foram removidos.', // PFU
    'ui__mass-mail/properties__done' => 'O modelo %1 foi modificado.', // PFU
    'ui__mass-mail/properties_new__done' => 'O modelo %1 foi criado.', // PFU
    'ui__mass-mail/send__done' => 'As mensagens foram enviadas.', // PFU
    'ui__mass-mail/send_new__done' => 'As mensagens foram enviadas.', // PFU
    'ui__mass-mail/send_unknown__done' => 'As mensagens foram enviadas.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'As mensagens foram enviadas.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Um novo modelo de mensagem foi criado.', // PFU
    'ui__mass-mail/template/properties__done' => 'O modelo de mensagem foi alterado.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'As novas configurações de monitorização de disco foram aplicadas.', // PFU
    'ui__modules__done' => 'A operação foi completada com sucesso.',
    'ui__modules__short-title' => 'Extensões',
    'ui__modules__title' => 'Extensões',
    'ui__reseller/client/chowner_multi__done' => 'As contas de cliente selecionadas foram transferidas para outro proprietário.',
    'ui__reseller/client/chowner_multi-select__done' => 'A operação foi completada com sucesso.',
    'ui__reseller/client/traffic_unknown__done' => 'A operação foi completada com sucesso.',
    'ui__reseller/extras-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__reseller/extras-domain_self__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__reseller/ftp-sessions_self__done' => 'Operação terminada com sucesso.',
    'ui__reseller/limits__done' => "Os limites de recursos e políticas de utilização de recursos do revendedor foram alterados.",
    'ui__reseller/limits_readonly-self__done' => 'Operação terminada com sucesso.',
    'ui__reseller/limits_self__done' => 'Os seus limites de recursos e políticas de utilização de recursos foram alterados.',
    'ui__reseller/manage-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__reseller/manage-domain_self__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__reseller/permissions__done' => 'As permissões do revendedor %1 foram alteradas.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operação terminada com sucesso.',
    'ui__reseller/register-domain__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__reseller/register-domain_self__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Os formatos de relatório foram removidos.',
    'ui__reseller/report/layout/auto/properties__done' => 'A entrega de relatório agendada foi actualizada.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'A agenda de entrega de relatório foi adicionada.',
    'ui__reseller/report/layout/properties__done' => 'Formato do relatório foi alterado.',
    'ui__reseller/report/layout/properties_new__done' => 'Novo formato do relatório foi criado.',
    'ui__reseller/report/traffic-history__done' => 'Operação terminada com sucesso.',
    'ui__reseller/report/traffic-history_self__done' => 'Operação terminada com sucesso.',
    'ui__reseller/report__done' => 'Operação terminada com sucesso.',
    'ui__reseller/report_self__done' => 'Operação terminada com sucesso.',
    'ui__reseller/sessions/delete__done' => 'Operação terminada com sucesso',
    'ui__reseller/sessions/delete_self__done' => 'Operação terminada com sucesso',
    'ui__reseller/sessions__done' => 'Operação terminada com sucesso.',
    'ui__reseller/sessions_self__done' => 'Operação terminada com sucesso.',
    'ui__reseller/to-client__done' => 'A conta de revendedor %1 foi convertida para uma conta de cliente.',
    'ui__reseller/to-client_multi__done' => "As contas de revendedor selecionadas foram convertidas para contas de cliente.",
    'ui__reseller/traffic__done' => 'Operação terminada com sucesso.',
    'ui__reseller/traffic_self__done' => 'Operação terminada com sucesso.',
    'ui__reseller/traffic_unknown__done' => 'Operação terminada com sucesso.',
    'ui__reseller/logo_self__title' => 'Personalização do Plesk',
    'ui__reseller/logo_self__done' => 'As suas configurações de personalização do Plesk foram aplicadas.',
    'ui__server/aspdotnet__done' => 'As configurações de ASP.NET do servidor foram alteradas.', // PFW
    'ui__server/certificate/default_multi__done' => 'O certificado SSL/TLS selecionado foi configurado para ser utilizado em ligações seguras a novas páginas web alojadas.',
    'ui__server/certificate/delete_multi__done' => 'Os certificados SSL/TLS seleccionados foram removidos.',
    'ui__server/certificate/download__done' => 'O certificado SSL/TLS foi descarregado.',
    'ui__server/certificate/properties__done' => 'As propriedades do certificado SSL/TLS foram actualizadas.',
    'ui__server/certificate/properties_new__done' => 'O certificado SSL/TLS %1 foi criado.',
    'ui__server/certificate/setup_multi__done' => 'O certificado SSL/TLS selecionado foi configurado para ser utilizado em ligações seguras ao Plesk.',
    'ui__server/certificate__done' => 'Operação terminada com sucesso',
    'ui__server/components__done' => 'A operação foi completada com sucesso.',
    'ui__server/cp-certificate-download__done' => "O certificado SSL/TLS do Plesk foi descarregado.",
    'ui__server/crontab/properties__done' => 'As tarefas agendadas de %1 foram modificadas.',
    'ui__server/crontab/task/delete__done' => 'A tarefa foi removida.',
    'ui__server/crontab/task/delete_multi__done' => 'As tarefas foram removidas.',
    'ui__server/crontab/task/properties__done' => 'As tarefas agendadas foram actualizadas.',
    'ui__server/crontab/task/properties_new__done' => 'A nova tarefa foi agendada.',
    'ui__server/crontab/task/toggle_disable__done' => 'Foi desactivada a tarefa agendada %1.',
    'ui__server/crontab/task/toggle_enable__done' => 'Foi activada a tarefa agendada %1.',
    'ui__server/crontab__done' => 'Operação terminada com sucesso.',
    'ui__server/db__done' => 'Operação terminada com sucesso.',
    'ui__server/dns__done' => 'Operação terminada com sucesso.',
    'ui__server/ftp-settings__done' => "As configurações de FTP foram alteradas com sucesso.",
    'ui__server/ip-address/client/delete__done' => "O endereço IP foi removido do repositório do utilizador.",
    'ui__server/ip-address/client/delete_multi__done' => "O endereço IP foi removido dos repositórios dos utilizadores.",
    'ui__server/ip-address/client/properties_new__done' => 'O endereço IP foi atribuído aos utilizadores.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'O endereço IP %1 foi atribuído aos clientes selecionados.',
    'ui__server/ip-addresses__done' => "A operação foi completada com sucesso.",
    'ui__server/mail/statistics/spam/recipients__done' => "A operação foi completada com sucesso.",
    'ui__server/mail/statistics/spam/summary__done' => "A operação foi completada com sucesso.",
    'ui__server/mail/statistics/spam__done' => "A operação foi completada com sucesso.",
    'ui__server/mail/statistics/virus/recipients__done' => "A operação foi completada com sucesso.",
    'ui__server/mail/statistics/virus/summary__done' => "A operação foi completada com sucesso.",
    'ui__server/mail/statistics/virus/viruses__done' => "A operação foi completada com sucesso.",
    'ui__server/mail/statistics/virus__done' => "A operação foi completada com sucesso.",
    'ui__server/mail/statistics__done' => "A operação foi completada com sucesso.",
    'ui__server/mail__done' => 'As configurações do servidor de correio foram alteradas.',
    'ui__server/maillists__done' => 'Operação terminada com sucesso.',
    'ui__server/mpc-certificates__done' => 'Foi aberta a listagem de páginas da loja virtual disponíveis nos certificados SSL/TLS.',
    'ui__server/odbc__done' => 'As configurações de ODBC do servidor foram alteradas.', // PFW
    'ui__server/pmm__done' => 'Operação terminada com sucesso.',
    'ui__server/preferences__done' => "As configurações do servidor foram alteradas.",
    'ui__server/register__done' => 'A página do MyPlesk.com foi aberta.',
    'ui__server/resources__done' => 'Operação terminada com sucesso.',
    'ui__server/services__done' => 'Operação terminada com sucesso.',
    'ui__server/sitebuilder__done' => 'Operação terminada com sucesso.',
    'ui__server/skeleton__done' => 'Operação terminada com sucesso.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'O endereço %1 foi removido da lista negra do servidor.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Os endereços foram removidos da lista negra do servidor.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Os endereços foram adicionados à lista negra.',
    'ui__server/spam-filter/black-list/address__done' => 'Os endereços foram adicionados à lista negra.',
    'ui__server/spam-filter/black-list__done' => 'Operação terminada com sucesso.', // PFU
    'ui__server/spam-filter/properties__done' => 'As configurações do filtro de spam foram modificadas.',
    'ui__server/spam-filter/toggle_disable__done' => 'A filtragem de spam foi desativada no sistema.',
    'ui__server/spam-filter/toggle_enable__done' => 'A filtragem de spam foi ativada no sistema.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'O endereço %1 foi removido da lista branca do servidor.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Os endereços foram removidos da lista branca do servidor.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Os endereços foram adicionados à lista branca.',
    'ui__server/spam-filter/white-list/address__done' => 'Os endereços foram adicionados à lista branca.',
    'ui__server/spam-filter/white-list__done' => 'Operação terminada com sucesso.', // PFU
    'ui__server/spam-filter__done' => 'Operação terminada com sucesso.',
    'ui__server/statistics__done' => 'Operação terminada com sucesso.',
    'ui__server/time__done' => "A Data e Hora do Sistema foi modificada.",
    'ui__server/tsclient__done' => 'Foi iniciada a sessão do Remote Desktop.', // PFW
    'ui__server__done' => "A operação foi completada com sucesso.",
    'ui__sessions/properties__done' => 'Operação terminada com sucesso.',
    'ui__sessions__done' => 'Operação terminada com sucesso.',
    'ui__sessions/delete__done' => 'As sessões seleccionadas foram eliminadas.',
    'ui__start-page__done' => 'Operação terminada com sucesso.',
    'ui__support__done' => 'O formulário de requisição de assistência foi aberto numa nova janela ou separador do browser.',
    'ui__ts-sessions__done' => 'Operação terminada com sucesso',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Sem ficheiros para carregar.',
    'login_up__access_denied_no_permission' => "Acesso negado. Você não tem permissão para entrar.",
    'mail__unable_remove_pattern' => "Impossível remover o endereço da lista negra do servidor: %1", // PFW
    'mail__incorrect_network_format' => 'Formato de rede inválido: %1', // PFW
    'dbbackup__new_remote_backup_available' => 'O servidor de base de dados MS SQL está agora a funcionar num servidor remoto. Para conseguir importar e exportar bases de dados usando as capturas de bases de dados nativos, necessita de especificar as definições corretas das cópias de segurança para este servidor da base de dados.', // PFW
    'dbbackup__local_to_remote_backup_available' => 'O servidor de base de dados MS SQL está agora a funcionar num servidor remoto. Pode especificar as definições de backup para este servidor de bases de dados na sua página %1.', // PFW
    'initconf__unable_change_passwd' => "Não é possível alterar a palavra-passe: do administrador:%1",
    'initconf__unable_get_passwd' => 'Não é possível obter a palavra-passe: de administrador atual: %1 falhou: %2',
    'initconf__invalid_hostname' => 'Erro no nome do anfitrião "%1"',
    'initconf__unable_reconfig' => 'Não foi possível configurar o Plesk: reconfig falhou: %1',
    'initconf__unable_update_admin' => 'Não foi possível atualizar as informações de contacto do administrador:%1',
    '__refresh' => 'Atualizar',
    '__dalias_not_exist' => 'O nome alternativo de domínio não existe.',
    '__bug146523_explanation' => 'As versões anteriores do Plesk permitiam utilizar até 16 carateres para nomes de utilizador de FTP. Esta versão do Plesk limita para 15 o número máximo de carateres permitidos para os nomes de utilizador de FTP. Para resolver este problema, reduza o comprimento do nome de utilizador FTP para 15 carateres para nomes de FTP afetados, e altere pelo menos um caracter nos nomes afetados de FTP para evitar o conflito de nomes de utilizador. Pedimos desculpa por qualquer inconveniente causado por esta alteração.',
    'domain__cannot_change_webmail' => 'Impossível alterar o webmail para o domínio: %1',
    'sb_publish_disable_warning' => 'Se a criação de página web com Presence Builder for desligada, o site anteriormente criado no Presence Builder será removido e todos os dados serão perdidos. Clique OK se quiser continuar.',
    '__sbnet_client_use_sbnet' => "Criar uma conta de utilizador correspondente no Presence Builder",
    'mail_resp_activate' => 'Ativar resposta automática',
    'limitsManger__limit_available_error' => 'Impossível atribuir a quantidade de  recursos necessária ("%%limitName%%"): só estão disponíveis %%available%% na sua conta.',
    'limitsManger__limit_reserved_error' => 'Impossível atribuir menos recursos ("%%limitName%%") que os que já estão em uso.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Impossível renomear o domínio: Um diretório virtual com o mesmo nome já existe.',
    'domain_unable_to_rename' => 'Impossível renomear o domínio.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Geral',
    'spamfilter__spamassassin_status_legend' => 'Filtragem de spam do SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Configurações do SpamAssassin.',
    'spamfilter__spamassassin_server_status_legend' =>  "Ligar a filtragem de spam do SpamAssassin do servidor",
    'spamfilter__spamassassin_user_status_legend' => 'Ligar a filtragem de spam do SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Ligar a proteção de spam "greylisting" do servidor',
    'spamfilter__personal_settings_not_allowed' => 'A utilização de configurações individuais de filtragem de spam não é permitida pela política do sistema.',
    'spamfilter__required_score' => 'A pontuação que uma mensagem deve receber de modo a ser considerada spam',
    'spamfilter__rewrite_header_subject' => 'Adicionar o seguinte texto ao inicio do assunto de cada mensagem reconhecida como spam:',
    'spamfilter__use_mailuser_prefs' => 'Aplicar as definições individuais ao filtro de spam',
    'spamfilter_addresses__text_hint' => 'Separe os vários endereços com uma nova linha, espaço, tab, virgula ou ponto e virgula. Só podem existir caracteres ASCII depois do "@". Os endereços podem conter "*" e "?" como wildcards (ex. *@dominio.com, utilizador?@*.com). Os nomes que não sejam ASCII não podem conter wildcards.',
    'spamfilter__spamassassin__antivirus_settings_legend' => 'Usar configurações do servidor',
    'spamfilter__antivirus_use_mailuser_prefs' => 'Permitir configurações pessoais',
    'spamfilter__score_error' => 'A avaliação não deve ser negativa, a parte antes da casa decimal deve ser inferior a 100 e pode incluir não mais que dois dígitos após a casa decimal.',
    'spamfilter__rewrite_header_error' => 'O assunto da mensagem pode conter quaisquer carateres acentuados exceto o sinal numérico (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Devoluções',
    'nonexistent_mail__mode_discard' => 'Descartar',
    'nonexistent_mail__mode_catch_addr' => 'Redirecionar para endereço de e-mail',
    'nonexistent_mail__mode_catch_ip' => 'Reenviar para o IP',
    'nonexistent_mail__bounce_not_supported' => 'O modo de devolução não é suportado',
    'nonexistent_mail__discard_not_supported' => 'O modo de descarte nãoé suportado',
    'nonexistent_mail__catch_not_supported' => 'O redirecionamento para endereço de e-mail não é suportado',
    'nonexistent_mail__redirect_not_supported' => 'O reendereçamento de IP não é suportado',
    'nonexistent_mail__ip_used_on_this_host' => 'O endereço IP resolve para o localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'O endereço de email %1 para destinatários não existentes deve pertencer ao domínio selecionado, porque o controlo de mensagens enviadas está ativado. Caso contrário, então a política "Rejeitar" será aplicada na vez do reencaminhamento.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Visto que o controlo de correio a enviar está ativado, o endereço de e-mail especificado para o reencaminhamento de correio (%1) deve pertencer ao domínio selecionado. Caso contrário, então as mensagens enviadas para este endereço não serão contabilizadas no Controlo de Correio a Enviar.',
    // mail acc extras
    '__antivirus' => "Antivírus",

    // additional keys
    'additional_keys__select_to_install' => 'Não foram seleccionadas chaves. Por favor, seleccione as chaves a instalar.',
    'additional_key_update__title' => "A Actualizar Chave Adicional",
    'additional_key_update__legend' => "Estado da actualização da chave adicional",
    'additional_key_update__new_key' => "Propriedades da Chave Adicional",
    'bt_additional_key_install' => "Instalar Chave",
    'b_additional_key_install' => 'Clique para instalar a presente chave de licença.',
    'bt_additional_key_update' => "Obter a Chave Adicional",
    'bt_additional_key_revert' => "Reverter a Chave",
    'b_additional_key_upload' => 'Carregar uma nova chave de licença.',
    'b_additional_key_download' => 'Descarregar a chave de licença atual.',
    'b_additional_key_remove' => 'Remover a chave de licença atual.',
    'b_additionalkeyslist_install' => 'Instalar as chaves de licença selecionadas.',

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Não existem contas de administrador adicional disponíveis.', // PFW
    'ui__client/domain/certificate__none-available' => 'O cliente não tem certificados SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'O cliente não tem domínios com certificados SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'O domínio não tem nenhum certificado SSL/TLS.',
    'ui__reseller/client__none-available' => 'Não existem revendedores com clientes.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'É necessário selecionar os endereços IP que quer remover do repositório de IP.',
    'ui__reseller/client/chowner__empty_selection' => 'É necessário selecionar as contas de cliente que quer atribuir a um novo proprietário.',
    'ui__server/ip-address/client/delete__empty_selection' => 'É necessário selecionar as contas de revendedor das quais quer revogar um endereço IP dos repositórios de IP.',
    'ui__server/crontab/task/delete__empty_selection' => 'É necessário selecionar a tarefa que quer cancelar.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'O suporte PHP está desligado para esta página web.',
    'phosting__aspdotnet_not_enabled' => 'O suporte ASP.NET está desligado para esta página web.',
    'phosting__php_forced_by_site_isolation' => 'Impossível alterar as configurações de PHP: não foi dada a permissão de anular a política de segurança do servidor.',
    'phosting__option_forced_by_site_isolation' => 'Impossível alterar as configurações %1: não foi dada a permissão de anular a política de segurança do servidor.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'O mod_bw está desativado porque o Plesk opera no modo otimizado de VPS.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'O mod_php está desativado porque o Plesk opera no modo otimizado de VPS.',
    'phosting__perl_disabled_by_vps_optimized' => 'O Perl está desativado porque o Plesk opera no modo otimizado de VPS.',
    'phosting__asp_disabled_by_vps_optimized' => 'O ASP está desativado porque o Plesk opera no modo otimizado de VPS.',
    'phosting__python_disabled_by_vps_optimized' => 'O Python está desativado porque o Plesk opera no modo otimizado de VPS.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'O fastcgi está desativado porque o Plesk opera no modo otimizado de VPS.',
    'phosting__php_handler_id_not_registered' => 'O manipulador PHP não é permitido nas configurações de isolamento de site. O manipulador PHP predefinido será utilizado.',
    'phosting__php_served_by_nginx_is_not_available' => 'O processador PHP (aplicação FPM servida por nginx) não é permitido nas definições de isolamento site. O processador PHP predefinido será utilizado.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Ver a lista de endereços IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Ver a lista de endereços IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Ver a lista de endereços IP disponíveis para este utilizador.',
    'ui__server/certificate__short-title' => 'Certificados SSL/TLS',
    'ui__server/certificate__title' => 'Certificados SSL/TLS',
    'ui__server/certificate__description' => 'Ver e gerir os certificados SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Remover MIME Types',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Remover MIME Types',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Remover MIME Types seleccionados.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Adicionar MIME Type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Adicionar MIME Type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Registar um MIME Type.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Remover Endereços IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Selecione os endereços IP que quer remover do repositório de IP do cliente %1.',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'Criar Ficheiro',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'Criar Ficheiro',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'Criar um ficheiro.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'Criar Pasta',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'Criar Pasta',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'Criar a pasta.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'Editar o Ficheiro ou Directório',
    'ui__client/domain/hosting/file-manager/edit__title' => 'Editar o Ficheiro ou Directório',
    'ui__client/domain/hosting/file-manager/edit__description' => 'Editar o ficheiro ou directório seleccionado.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'Mudar o nome do Ficheiro ou Directório',
    'ui__client/domain/hosting/file-manager/rename__title' => 'Mudar o nome do Ficheiro ou Directório',
    'ui__client/domain/hosting/file-manager/rename__description' => 'Mudar o nome do ficheiro ou directório seleccionado',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'Alterar Permissões',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'Alterar Permissões',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'Alterar as permissões de acesso de um ficheiro ou directório.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'Remover Ficheiro ou Directório',
    'ui__client/domain/hosting/file-manager/remove__title' => 'Remover Ficheiro ou Directório',
    'ui__client/domain/hosting/file-manager/remove__description' => 'Remover este ficheiro ou directório.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'Remover Ficheiro ou Directório',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'Remover Ficheiro ou Directório',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'Remover este ficheiro ou directório.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'Copiar ou mover o ficheiro ou directório',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'Copiar ou mover o ficheiro ou directório',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'Copiar ou mover os ficheiros ou diretórios selecionados.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'Ver Ficheiro',
    'ui__client/domain/hosting/file-manager/view__title' => 'Ver Ficheiro',
    'ui__client/domain/hosting/file-manager/view__description' => 'Ver o ficheiro seleccionado.',

    'ui__client/ipaddress__short-title' => 'Endereço IP',
    'ui__client/ipaddress__title' => 'Endereço IP',
    'ui__client/ipaddress__description' => 'Ver informação acerca do endereço IP.',
    'ui__server/ip-address__short-title' => 'Endereço IP',
    'ui__server/ip-address__title' => 'Endereço IP',
    'ui__server/ip-address__description' => 'Ver informação acerca do endereço IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Configurações do Alojamento Web',
    'ui__client/domain/hosting/setup__title' => 'Configurações do alojamento web',
    'ui__client/domain/hosting/setup__description' => 'Configurar as configurações de alojamento web para página web %1.',
    'ui__reseller/client/chowner_multi__description' => 'Escolher novo proprietário para contas de cliente selecionadas.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Tipo MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Propriedades do MIME Type', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Ver as propriedades do MIME Type.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Documento de Erros', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Documento de Erros', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Propriedades do documento de erros.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Remover os formatos de relatório seleccionados.',
    'b_resellerreportslist_search' => 'Insira um padrão de procura e clique para encontrar formatos de relatório.',
    'b_resellerreportslist_show_all' => 'Exibir todos os formatos de relatório disponíveis.',

    'l_resellerreportslist_auto' => 'Ordenar formatos de relatório por automatização de envio.',
    'l_resellerreportslist_clients' => 'Ordenar os formatos de relatório pela presença de informações sobre clientes.',
    'l_resellerreportslist_domains' => 'Ordenar os formatos de relatório pela presença de informações sobre domínios.',
    'l_resellerreportslist_general' => 'Ordenar os formatos de relatório pela presença de informações gerais.',
    'l_resellerreportslist_name' => 'Ordenar formatos de relatório por nome de relatório.',
    'l_resellerreportslist_personal_domains' => 'Ordenar os formatos de relatório pela presença de informações sobre domínios pessoais.',

    'b_adminreportslist_remove' => 'Remover os formatos de relatório seleccionados.',
    'b_adminreportslist_search' => 'Insira um padrão de procura e clique para encontrar formatos de relatório.',
    'b_adminreportslist_show_all' => 'Exibir todos os formatos de relatório disponíveis.',

    'l_adminreportslist_auto' => 'Ordenar formatos de relatório por automatização de envio.',
    'l_adminreportslist_clients' => 'Ordenar os formatos de relatório pela presença de informações sobre clientes.',
    'l_adminreportslist_domains' => 'Ordenar os formatos de relatório pela presença de informações sobre domínios.',
    'l_adminreportslist_general' => 'Ordenar os formatos de relatório pela presença de informações gerais.',
    'l_adminreportslist_name' => 'Ordenar formatos de relatório por nome de relatório.',
    'l_adminreportslist_personal_clients' => 'Ordenar os formatos de relatório pela presença de informações sobre seus próprios clientes.',
    'l_adminreportslist_personal_domains' => 'Ordenar os formatos de relatório pela presença de informações sobre seus próprios domínios.',
    'l_adminreportslist_resellers' => 'Ordenar os formatos de relatório pela presença de informações sobre revendedores.',

    'b_clientsonlylist_remove' => 'Remover contas de cliente selecionadas.',
    'b_clientsonlylist_search' => 'Insira um padrão de procura e clique para encontrar contas de cliente.',
    'b_clientsonlylist_show_all' => 'Exibir todas as contas de cliente.',
    'l_clientsonlylist_cname' => 'Ordenar as contas de cliente por nome de empresa.',
    'l_clientsonlylist_date' => 'Ordenar as contas de cliente por data de criação.',
    'l_clientsonlylist_domains' => 'Ordenar as contas de cliente por número de domínios.',
    'l_clientsonlylist_name' => 'Ordenar as contas de cliente por nome.',
    'l_clientsonlylist_owner' => 'Ordenar as contas de cliente por proprietário.',
    'l_clientsonlylist_type' => 'Ordenar as contas de cliente por tipo.',

    'b_get_password_cancel' => 'Voltar para a tela anterior sem enviar o e-mail.',
    'b_get_password_send' => 'Clique OK para enviar a mensagem de recuperação da palavra-passe para o e-mail registado no sistema.',



    'b_personaltrafficlist_search' => 'Insira um padrão de procura e clique para encontrar domínios.',
    'b_personaltrafficlist_show_all' => 'Exibir todos os domínios.',

    'b_back' => 'Voltar para a página anterior.',
    'b_next' => 'Ir para a próxima página.',

    'b_dnsnstemplatelist_remove' => 'Eliminar os servidores de nome seleccionados.',
    'b_dnsnstemplatelist_search' => 'Insira um padrão de procura e clique para encontrar servidores de nome.',
    'b_dnsnstemplatelist_show_all' => 'Exibir todos os servidores de nome.',

    'l_dnsnstemplatelist_ns' => 'Ordenar os registos do modelo de DNS por servidor de nome.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Gerar botões seguros para ficheiros e pastas',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Ativar ficheiros públicos',
    'cu__serverfilesharing_fsPublicFolder' => 'Pasta para armazenamento de ficheiros públicos',
    'cu__serverfilesharing_fsPublicUrl' => 'URL para acesso de visitante a ficheiros públicos',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Ativar a proteção de palavra-passe de ficheiros públicos',
    'cu__serverfilesharing_fsPartnerFolder' => 'Pasta para armazenamento de ficheiros protegidos por palavra-passe',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nome de utilizador para acesso a ficheiro',
    'cu__serverfilesharing_fsPartnersPassword' => 'Palavra-passe para acesso a ficheiro',
    'cu__serverfilesharing_fsDomain' => 'URL da pasta raiz da Web. Nome do domínio',
    'cu__serverfilesharing_fsPrefix' => 'URL da pasta raiz da Web. Prefixo',
    'cu__serverfilesharing_commandUpdate' => 'Atualizar as configurações de partilha de ficheiros',
    'cu__serverfilesharing_commandInfo' => 'Exibir as configurações atuais de partilha de ficheiros',
    'server_preferences_include_admin_dumps_into_client_usage' => 'ficheiros de backup criados pelo administrador',
    'server_preferences__forbid_subscription_rename' => 'Proibir os clientes e revendedores de modificar o nome principal do domínio',
    'subscription_rename_is_forbidden' => 'A alteração do nome das assinaturas é proibida por uma política do servidor.',
    'server_preferences__allow_sys_user_rename' => 'Os clientes podem alterar o nome do seu utilizador do sistema',
    'server_preferences__allow_sys_user_rename_false' => 'Sempre',
    'server_preferences__allow_sys_user_rename_true' => 'Apenas se for concedida a autorização de Gestão de Alojamento',
    'server_preferences__allow_sys_user_rename_forced' => 'Nunca',
    'server_preferences__preferred_domain' => 'Domínio preferencial para websites',
    'server_preferences__preferred_domain_none' => 'Nenhum',
    'server_preferences__preferred_domain_to_landing' => 'domain.tld',
    'server_preferences__preferred_domain_to_www' => 'www.domain.tld',
    'server_preferences__anonymize_ips' => 'Anonimizar endereços IP',
    'server_preferences__anonymize_ips_text' => 'Anonimiza os endereços IP durante a rotação de registos e recolhe de estatísticas da web',
    'server_preferences__anonymize_ips_description' => 'O script pós-rotação substitui o último octeto de endereços IPv4 em ficheiros de registo rotacionados com "0" antes do arquivo. Nos endereços IPv6, o script substitui a última secção do endereço (dois octetos depois da última vírgula) por "0000" (no formato completo) ou "0" (no formato curto)',
    'server_preferences__logrotate' => 'Rotação de registo',
    'server_preferences__logrotate_force' => 'Forçar a rotação de registo diário para todos os domínios',
    'server_preferences__logrotate_period' => 'Permitir armazenar ficheiros de registo do site para',
    'server_preferences__logrotate_period_days' => 'dias',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Gerir as Tarefas Agendadas no Servidor',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Seleccione o utilizador do sistema ao qual quer gerir as tarefas agendadas.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Tarefa Agendada %1',
    'ui__server/crontab/task__description' => 'Ver as propriedades da tarefa agendada %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Utilizadores de Sistema',
    'ui__server/crontab_unknown__title' => 'Utilizadores de Sistema',
    'ui__server/crontab_unknown__description' => 'Utilizadores do sistema que podem agendar tarefas.',


    'ui__server/crontab__none-available' => 'Não tem nenhuma conta de utilizador do sistema.',
    'ui__server/crontab_readonly-unknown__description' => 'Ver as tarefas agendadas.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Tarefas agendadas',
    'ui__server/crontab_readonly-unknown__title' => 'Ver as tarefas agendadas',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Ver as tarefas agendadas.',
    'ui__server/crontab_readonly__description' => 'Visualizar a tarefa agendada %1.',
    'ui__server/crontab_readonly__short-title' => 'Tarefa agendada de %1',
    'ui__server/crontab_readonly__title' => 'Visualizar as tarefas agendadas de %1',
    'ui__server/crontab_unknown__wizard-title' => 'Gerir tarefas agendadas.',

    'ui__server/crontab/properties__description' => 'Editar as tarefas agendadas de %1.',

    'ui__server/crontab/properties__short-title' => 'Configurações',
    'ui__server/crontab/properties__title' => 'Editar as tarefas agendadas de %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Ver as tarefas agendadas.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Configurações',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Ver as tarefas agendadas',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Ver as tarefas agendadas.',
    'ui__server/crontab/properties_readonly__description' => 'Ver as tarefas agendadas de %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Configurações',
    'ui__server/crontab/properties_readonly__title' => 'Ver as tarefas agendadas de %1',
    'ui__server/crontab/properties_unknown__description' => 'Editar tarefas agendadas.',
    'ui__server/crontab/properties_unknown__short-title' => 'Propriedades',
    'ui__server/crontab/properties_unknown__title' => 'Editar tarefas agendadas',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Editar tarefas agendadas.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Seleccione o utilizador de sistema ao qual deseja visualizar as tarefas.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Seleccione o utilizador de sistema ao qual deseja modificar as tarefas.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Clique Finalizar para aplicar as modificações e sair do assistente.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Clique Finalizar para sair do assistente.',

    'ui__server/crontab/task__none-available' => 'Não tem nenhumas tarefas agendadas.',
    'ui__server/crontab/task__none-available__2' => 'O utilizador do sistema %1 não tem nenhumas tarefas agendadas.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Tarefas agendadas.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Tarefas',
    'ui__server/crontab/task_readonly-unknown__title' => 'Tarefas agendadas',

    'ui__server/crontab/task/delete__description' => 'Remover a tarefa agendada %1',

    'ui__server/crontab/task/delete__short-title' => 'Eliminar',
    'ui__server/crontab/task/delete__title' => 'Remover a tarefa agendada %1',
    'ui__server/crontab/task/delete_multi__description' => 'Remover tarefas agendadas.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Eliminar',
    'ui__server/crontab/task/delete_multi__title' => 'Remover tarefas agendadas',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Remover tarefas agendadas.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Seleccione o utilizador de sistema ao qual deseja remover as tarefas.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Seleccione as tarefas que deseja remover.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Confirme a remoção da tarefa seleccionando a checkbox e clique Finalizar para terminar o assistente.',
    'ui__server/crontab/task/delete_unknown__description' => 'Remover uma tarefa agendada.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Eliminar',
    'ui__server/crontab/task/delete_unknown__title' => 'Remover uma tarefa agendada',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Remover uma tarefa agendada.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Seleccione o utilizador de sistema ao qual deseja remover a tarefa.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Seleccione a tarefa que deseja remover.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Confirme a remoção da tarefa seleccionando a checkbox e clique Finalizar para terminar o assistente.',

    'ui__server/crontab/task/properties__description' => 'Editar tarefas agendadas.',

    'ui__server/crontab/task/properties__short-title' => 'Editar tarefa %1',
    'ui__server/crontab/task/properties__title' => 'Editar tarefas agendadas',
    'ui__server/crontab/task/properties_new__description' => 'Criar tarefas agendadas para %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Adicionar Tarefa',
    'ui__server/crontab/task/properties_new__title' => 'Criar tarefas agendadas para %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Create uma tarefa agendada.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Seleccione o utilizador de sistema para o qual deseja agendar a tarefa.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Clique Finalizar para aplicar as modificações e sair do assistente.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Ver as tarefas agendadas.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Propriedades',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Ver as tarefas agendadas',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Ver as tarefas agendadas.',
    'ui__server/crontab/task/properties_readonly__description' => 'Ver as tarefas agendadas.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Ver tarefa %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Ver as tarefas agendadas',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Criar tarefas agendadas.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Adicionar Tarefa',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Criar tarefas agendadas',
    'ui__server/crontab/task/properties_unknown__description' => 'Editar tarefas agendadas.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Propriedades',
    'ui__server/crontab/task/properties_unknown__title' => 'Editar tarefas agendadas',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Editar tarefas agendadas.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Seleccione o utilizador de sistema ao qual deseja visualizar as tarefas.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Seleccione o utilizador de sistema ao qual deseja modificar as tarefas.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Seleccione a tarefa agendada.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Seleccione a tarefa agendada que deseja modificar.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Clique Finalizar para aplicar as modificações e sair do assistente.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Clique Finalizar para sair do assistente.',

    'ui__server/crontab/task/toggle_disable__description' => 'Desactivar a tarefa agendada %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Desactivar',
    'ui__server/crontab/task/toggle_disable__title' => 'Desactivar a tarefa agendada %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Activar a tarefa agendada %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Activar',
    'ui__server/crontab/task/toggle_enable__title' => 'Activar a tarefa agendada %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Activar ou desactivar as tarefas agendadas.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Activar ou desactivar',
    'ui__server/crontab/task/toggle_unknown__title' => 'Activar ou desactivar as tarefas agendadas',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Activar ou desactivar as tarefas agendadas',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Seleccione a conta do utilizador de sistema cujas tarefas quer activar ou desactivar.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Seleccione a tarefa que deseja activar ou desactivar.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Contas de cliente', // not used on HP?
    'ui__client_unknown__title' => 'Contas de cliente', // not used on HP?
    'ui__client_unknown__description' => 'Administre as contas de cliente.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Suspender domínio', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Suspender domínio', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Suspender um domínio.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Ativar domínio', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Ativar domínio', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Ativar um domínio.', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => 'Atribuir novo proprietário às contas de cliente',
    'ui__client/chowner_multi-select__short-title' => 'Atribuir novo proprietário',
    'ui__client/chowner_multi-select__description' => 'Atribuir um novo proprietário às contas de cliente selecionadas.',


    //Additional FTP Accounts
    'directory_browser__select_folder' => 'Selecionar Pasta',
    'ftp__management_domain' => "Contas de FTP no Domínio %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Sub-contas do FTP",
    'ftp__user_name' => "Nome da sub-conta do FTP",
    'ftp__user_home' => "Directório inicial",
    'ftp__invalid_path' => "Foi especificado um caminho inválido",
    'ftp__physical_path_not_exist' => "O caminho físico não existe",
    'i_ftp_ses_sub_user' => 'Sessão da sub-conta de FTP.',
    '__new_passwd' => "Nova senha %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Impossível configurar um servidor web ao host <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Impossível gerar o ficheiro de configuração do servidor web no host <%%host%%> devido aos seguintes erros:\n\n%%error%%\n\nPor favor, resolva esses erros nos modelos de configuração do servidor web e crie o ficheiro novamente.",

    'apacheConfigurationMessageAdminTitle' => 'Falha na criação da configuração do servidor web',
    'apacheConfigurationMessageClientTitle' => 'Aviso',

    'apacheConfigurationFailedAdminHomeMessage' => 'O ficheiro da nova configuração não foi criado devido a erros nos modelos de configuração. A mensagem detalhada de erro foi enviada para o seu e-mail. Por favor, verifique o seu e-mail, resolva os erros, e clique em %1 para tentar gerar novamente a configuração.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'aqui', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'A nova configuração para o domínio %1 não foi construída devido a erros nos modelos de configuração. A mensagem detalhada de erro foi enviada para o seu e-mail. Por favor, verifique o seu e-mail, resolva os erros, e clique em %2 para tentar gerar novamente a configuração.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'aqui', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'A configuração do servidor web para o domínio %1 pode ser incompatível. Por favor, contacte o administrador do servidor para resolver o problema.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'A nova configuração para alguns domínios não foi criada devido a erros nos modelos de configuração. A mensagem detalhada de erro foi enviada para o seu e-mail. Por favor, verifique o seu e-mail, resolva os erros, e clique em %1 para tentar gerar novamente a configuração.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'aqui', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'A configuração do servidor web para alguns domínios pode ser incompatível. Por favor, contacte o administrador do servidor para resolver o problema.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Documentos personalizados de erro",
    'dom_pref__webusers_script' => "Permitir aos utilizadores de rede a utilização de scripts",
    '__seoRedirect' => 'Configurar o domínio preferencial como',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Nenhum',

    '__sites' => 'Domínios',
    'domain_plan__perm_denied_manage_phosting' => 'Não tem a permissão para gerir as configurações de alojamento.',
    '__owned_by_client' => 'pertencente ao cliente',
    'ui__client/permissions_readonly__description' => "Ver as ações que o cliente %1 pode executar no Plesk.",
    'client_chown_subscription_will_be_anonymous' => 'Os clientes deixarão de estar subscritos nos seus planos de serviço atuais.',
    'backup__restore__object_client_template' => 'Modelo de cliente',
    '__template_name' => 'Nome do plano de serviço',
    'template__not_exists' => 'Este plano de serviço não existe.',
    'template__exists' => 'Um plano com o nome %1 já existe.',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => 'O cliente tem domínios subscritos para os planos de serviço %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'O endereço IP especificado não está no repositório do revendedor.',

    //// Change owner of subscription
    'chown__select_title' => "Escolher novo assinante",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Escolha um novo proprietário para as assinaturas selecionadas e clique Seguinte >>.',
    'domains__client_info' => "%1 assinatura(s), %2 assinatura(s) ativa(s), %3 de espaço de disco utilizado, %4 de tráfego utilizado",
    '__possible_owners' => 'Possíveis novos proprietários de assinaturas',

    'clients_list__filter_owner__filter_title' => 'Fornecedor',
    'clients_list__filter_owner_any' => 'Todos os utilizadores',
    'clients_list__filter_owner_my' => 'Só os meus assinantes',
    'clients_list__filter_owner_name__filter_title' => 'Nome do fornecedor',

    '__owner' => "Fornecedor",
    'l_clientslist_owner' => 'Ordenar as contas de utilizador por fornecedor.',
    'l_clientslist_date' => 'Ordenar as contas de utilizador por data de criação.',
    'l_clientslist_name' => 'Ordenar as contas de utilizador por nome.',
    'l_clientslist_domains' => 'Ordenar as contas de utilizador por domínios.',
    'l_clientslist_cname' => 'Ordenar as contas de utilizador por nome de empresa.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Reatribuir as assinaturas selecionadas',
    'chown__check_title' => 'Alterar assinante',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Clique Concluir para terminar a reatribuição. Ao concluir, as assinaturas selecionadas serão atribuídas a um novo proprietário, o seu fornecedor será alterado para o novo fornecedor do proprietário e serão desvinculados dos seus planos de serviço e tornar-se-ão 'Personalizados'.",

    'chown__error_check' => 'Foram encontrados alguns problemas durante a tentativa de atribuir alguns das assinaturas a um novo proprietário.',
    'domain_chown_subscription_will_be_anonymous' => "As assinaturas serão separadas dos seus planos de serviço atuais e tornar-se-ão 'Custom'.",
    'chown__error_domains_exclude' => "Foram encontrados alguns problemas durante a tentativa de atribuir alguns das assinaturas a um novo proprietário. Estas assinaturas estão destacadas.",
    'chown__ip_not_in_client_pool' => "O endereço IP associado a esta assinatura não foi adicionada ao repositório de IP do novo proprietário.",
    'chown__already_owned_by_client' => "Esta assinatura já pertence a este utilizador.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Diretório protegido /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Administração do diretório protegido /%1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'Criar um diretório protegido no site %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'Adicionar Diretório Protegido',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'Criar diretório protegido.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'O diretório protegido /%1 foi criado com sucesso.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'Configurações do diretório protegido /%1',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'Configurações de Diretório',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'Alterar local, nome, e título da área do diretório protegido.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'As configurações do diretório protegido foram alteradas.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'Confirmação de remoção',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'Remover Proteção',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'Remover a proteção dos diretórios selecionados.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'Selecione um diretório do qual quer remover a proteção.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'Esta operação resultará na remoção da proteção dos diretórios. Os diretórios irão tornar-se livremente acessíveis aos utilizadores de Internet.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'A proteção foi removida dos diretórios selecionados com sucesso.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Adicionar um utilizador',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Adicionar um utilizador',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Configure uma conta de utilizador para o acesso ao diretório protegido %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'A conta de utilizador para acesso ao diretório protegido foi criada.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "As credenciais do utilizador foram guardadas.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Remoção de utilizadores do diretório protegido',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Selecione os utilizadores que quer remover.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Remover utilizadores do diretório',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Serão removidos os seguintes utilizadores do diretório protegido:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'As contas de utilizador selecionadas foram removidas.',

    '__redirect_hint' => 'Você será redirecionado ao novo endereço em 15 segundos... Se não for automaticamente levado para o novo local, por favor, ative o javascript ou clique na hiperligação %%link%%.',

    'backup__restore__object_maillist' => 'Lista de envio',
    'backup__restore__object_site' => 'Site',
    'backup__restore__object_user' => 'Utilizador',
    'backup__restore__object_role' => 'Função',

    'limit__name_max_site' => 'sites web',

    'iis_pool__unable_rename_client' => "Impossível alterar o nome do Repositório de Aplicações IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'O serviço de FTP anónimo é suportado apenas para o domínio principal de uma assinatura.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'O serviço de FTP anónimo é suportado apenas para o domínio principal de uma assinatura.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/mês',
    '__tb_month' => 'TB/mês',

    '__customers' => 'Clientes',
    '__customer_name' => 'Nome de cliente',
    '__customer_total' => 'Total de clientes',
    '__site' => 'Site',
    '__def_site' => 'Site predefinido',
    '__subscription_name' => 'Nome da assinatura',
    '__subscription_name_powerUser' => 'Nome da assinatura',

    'limit__units_max_traffic_suffix' => '/mês',

    'dom_pref__discard' => "Rejeitar",

    'mail__pattern_already_exists' => 'O padrão "%1" já está na lista negra.',

    '__not_supported' => 'Não suportado',

    'plesk_key__sitebuilder' => 'Websites publicados com Presence Builder',
    'limit__name_max_site_builder' => 'Websites publicados com Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Suporte para sites em diversos idiomas no Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Estatísticas de transferência de dados para o domínio %1',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Estatísticas de transferência de dados para o domínio %1',
    'ui__client/domain/traffic-hosting#list__title' => "Transferência de dados por serviços",

    'login_up__access_denied_no_subscriptions' => "Acesso negado. Não existem assinaturas disponíveis para esta conta.",

    'interval__day' => '%1 dia(s)',
    'interval__hour' => '%1 hora(s)',
    'interval__minute' => '%1 minuto(s)',
    'interval__second' => '%1 segundo(s)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Está a tentar utilizar uma chave de licença criada para outra versão do Plesk. Contacte os representantes de vendas da Plesk para obter uma chave de licença adequada.',
    //Standalone or virtualization
    'virtualization_any' => "Servidor físico ou qualquer solução de virtualização",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Servidor Virtuozzo",
    'plesk_key__virtualization' => "Válido para os seguintes ambientes:",
    'plesk_key__virtualization_only_key' => 'A chave de licença só pode ser utilizada no Plesk dentro de um ambiente virtual %1.',
    'plesk_key__virtualizations_only_key' => 'A chave de licença só pode ser utilizada no Plesk dentro dos seguintes ambientes virtuais: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'É proibida a utilização de pacotes personalizados de idioma',
    'plesk_key__allowed-locales' => 'Idiomas disponíveis',
    'plesk_key__allowed-locales-any' => 'Qualquer idioma',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'o diretório cgi-bin está localizado em',
    '_cgi_bin_mode_webspace' => 'o diretório raiz da assinatura',
    '_cgi_bin_mode_www_root' => 'o documento raiz deste domínio',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'Adicionar um ODBC DSN',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'Adicionar fonte de dados ODBC.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'Eliminar',
    'ui__server/odbc/dsn/delete_multi__title' => 'Confirmação de remoção',
    'ui__server/odbc/dsn/delete_multi__description' => 'Remover as fontes de dados ODBC DSN selecionadas.',
    'ui__server/odbc/dsn/delete#legend__description' => 'As seguintes ligações ODBC DSN serão removidas:',
    'ui__server/odbc/dsn/delete__empty_selection' => 'Nenhuma ligação ODBC DSN foi selecionada.',
    'ui__server/odbc/dsn/delete_multi__done' => 'As fontes de dados selecionadas foram removidas.',
    'ui__server/odbc/dsn__title' => 'Ligação ODBC DSN %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'Adicionar um ODBC DSN',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'Adicionar fonte de dados ODBC.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'Confirmação de remoção',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'Remover as fontes de dados ODBC DSN selecionadas.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'As seguintes ligações ODBC DSN serão removidas:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'Nenhuma ligação ODBC DSN foi selecionada.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'As fontes de dados selecionadas foram removidas.',
    'ui__client/domain/odbc/dsn__title' => 'Ligação ODBC DSN %1',


    /// Custom buttons
    'custom_button__sort_key' => 'Prioridade',
    'custom_button__place' => 'Local',
    'custom_button__place_navigation' => 'Acesso Comum',
    'custom_button__place_admin' => 'Página Inicial do Administrador',
    'custom_button__place_admin-settings' => 'Página de Ferramentas & Configurações do Administrador',
    'custom_button__place_reseller' => "Página Inicial do revendedor",
    'custom_button__place_reseller-settings' => 'Página de Ferramentas & Utilitários do Revendedor',
    'custom_button__place_client' => 'Página Inicial do Cliente',
    'custom_button__place_domain' => "Página de Sites Web & Domínios da Assinatura",
    'custom_button__place_domain_powerUser' => "Página de Sites Web & Domínios da Assinatura",
    'custom_button__place_domain-properties' => 'Ferramentas de Website',
    'custom_button__private' => 'Exibir apenas a mim',
    'custom_button__image' => 'Imagem de fundo',
    'custom_button__conhelp' => "Texto de dica de ferramenta",
    'custom_button__edit' => "Configurações para um Botão com um Serviço Adicional",
    'custom_button__include_client_cname' => "Incluir nome da empresa do cliente",
    'custom_button__include_client_email' => "Incluir e-mail do cliente",
    'custom_button__include_client_id' => "Incluir identificação do cliente",
    'custom_button__include_client_pname' => "Incluir nome de contacto do cliente",
    'custom_button__include_domain_id' => "Incluir o ID da assinatura, o ID do domínio e o ID do nome alternativo do domínio",
    'custom_button__include_domain_id_powerUser' => "Incluir o ID da assinatura, o ID do domínio e o ID do nome alternativo do domínio",

    'custom_button__include_domain_name' => "Incluir nome do Domínio Principal",
    'custom_button__include_ftp_user' => "Incluir o nome de utilizador de FTP",
    'custom_button__include_ftp_pass' => "Incluir a senha de FTP",
    'custom_button__internal_open' => "Abrir a URL no Plesk",
    'custom_button__text' => "Rótulo do botão",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'O ficheiro não é um ficheiro de imagem.',
    'custom_button__big_image' => 'O arquivo não deve exceder 100 KB.',
    'custom_button__failed_copy_image' => 'Impossível copiar o ficheiro: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Não é possível repor um backup de não-utilizador do Power User na visualização por Power User.',
    '__unknown_network_interface' => 'Interface de rede desconhecida',

    'init_conf__ip_address' => 'Endereço IP',

    //Confirmation page
    'bt_confirm' => 'Confirme',
    'b_confirm' => 'Confirmar a propriedade de seus sites web.',

    //// New VZPP Integration
    '__vzpp_integration_warning' => 'Esta instância Plesk está instalada num Virtuozzo container. As configurações atuais de administração offline do Container fazem o Plesk ficar indisponível.',
    '__vzpp_integration_contact_admin' => 'Se tem privilégios suficientes para alterar a configuração do Container, %1. Caso contrário, contacte seu fornecedor para fazer isso.',
    '__vzpp_integration_help_link' => 'alterar as configurações de administração offline',



    'performance__iss_app_pool_forced_by_site_isolation' => 'As configurações do repositório de aplicação IIS exclusivo são definidas de acordo com a política de segurança do servidor (configuração de isolamento de site).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'As configurações do repositório de aplicação IIS exclusivo são definidas de acordo com as configurações de desempenho do servidor.',

    '__current' => 'Atual',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'As propriedades do utilizador foram atualizadas.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Utilizou quase todos os domínios fornecidos com a sua licença do Plesk (90% ou mais).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Você utilizou quase todos os domínios.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Utilizou quase todos os sites do Presence Builder fornecidos com a sua licença do Plesk (90% ou mais).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Você utilizou quase todos os sites do Presence Builder.',
    'promo__button_hide' => 'Ocultar',
    'promo__button_next' => 'Seguinte >>',
    'promo__button_prev' => '<< Anterior',
    'promo__button_license' => 'Atualizar Licença',

    'promo__google_integration_title' => 'Integração com serviços do Google',
    'promo__google_integration' => 'Configurar a integração com serviços do Google, como AdSense, Google Apps, ferramentas do Webmaster.',
    'promo__google_integration_button' => 'Configurar',

    'promo__button_learn_more' => 'Aprender Mais',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Pode personalizar a aparência da interface e as configurações de marca através dos temas personalizados. Para instruções de personalização dos temas do Plesk, consulte %1.',
    'panel_branding__description_link' => 'seguinte documento',
    'mail__enable_mail_ui_label' => 'Ativar as funções de administração de correio no Plesk',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extrair ficheiros',
    'b_filemanager__extract' => 'Extrair ficheiros selecionados para o diretório atual. Note que os nomes dos ficheiros podem ser exibidos indevidamente após a extração, caso tenham carateres nacionais.',
    'filemanager_error_extracting_files' => 'Ocorreu um erro ao extrair os ficheiros: %1',
    'filemanager_no_archive_files_specified' => 'Especifique os ficheiros que deseja extrair.',
    'filemanager_not_zip_archive_specified' => '%1 não pode ser extraído, não é um ficheiro ZIP.',
    'filemanager_files_successfully_extracted' => 'Os ficheiros foram extraídos.',
    'filemanager_error_file_download' => 'Falha no descarregamento do ficheiro: %1',
    'filemanager__user_poolgrp' => 'Grupo do repositório de aplicações',

    'loading' => 'A carregar',
    'bt_create_archive' => 'Adicionar ao arquivo',
    'filemanager__pack' => "Caminho para o ficheiro: %1",
    'filemanager__archive_name' => 'Nome do ficheiro',
    'filemanager__empty_filename' => 'Por favor, insira o nome do ficheiro.',
    'filemanager_archive_created' => 'O ficheiro foi criado com sucesso.',
    'filemanager_error_creating_archive' => 'Impossível criar o ficheiro. %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Este registo estará em conflito com o AAAA registro para a zona.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(o servidor de FTP não suporta endereços IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Este registo estará em conflito com o glue record para a zona \'%1\'.',
    '__ftp_ipv6_not_supported' => "(o servidor de FTP não suporta endereços IPv6.)",
    '__ipv6_not_supported' => 'IPv6 não é suportado.',
    'mail__ipv6_not_supported' => 'IPv6 não é suportado pelo servidor de correio.',
    'mail__relay_while_list_ipv6_not_supported' => 'A lista branca de encaminhamento de IPv6 não é suportada pelo servidor de correio.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'O valor de máscara deve ser um múltiplo de 16.',
    'mail__ip_or_mask_is_invalid' => 'O endereço ou máscara de IP é inválido.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'O redirecionamento para endereços IPv6 não é suportado.',
    'sa__invalid_trusted_networks' => 'Redes confiáveis especificadas incorretamente: %1',
    'dns_add__enter_ipv6_address' => "Endereço IPv6",
    'license_trial_days_left' => 'O seu Plesk está a operar com uma licença de teste que irá expirar em %1 dias.',
    'excl_ipv6_num' => 'Endereço IPv6 exclusivo',
    '__ip_mask' => "Máscara de sub-rede",
    '__ipv4_addr' => 'Endereço IPv4',
    '__ipv6_addr' => 'Endereço IPv6',
    'template__num_excl_ipv6s' => 'Atribuir endereços IPv6 exclusivos ao revendedor',
    'anonftp__exclusive_ipv4_required' => 'É necessário um endereço de IPv4 exclusivo para configurar e utilizar o FTP anónimo.',
    'anonftp__ipv4_already_used' => 'Impossível configurar o serviço de FTP anónimo para esta página web porque este já está configurado em outro domínio no mesmo endereço IPv4.',


    'restart__kav' => "Kaspersky Antivírus",
    'panel_branding__page_description_admin' => 'Marque a interface Plesk, alterando o título da página na barra de título do navegador e/ou substitua o logótipo Plesk no canto superior esquerdo.',
    '__view_migration_log_detailed_info' => 'Ver o log',

    'chown__ip_address_warn' => 'Antes de mover o domínio para o novo proprietário, um novo endereço IP para este domínio deve ser selecionado.',
    'chown__no_ip_address' => 'Nenhum',
    'chown__no_ipv4_address' => 'Nenhum endereço IPv4',
    'chown__no_ipv6_address' => 'Nenhum endereço IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'A assinatura %1 já pertence a outro utilizador.',
    'chown__error_ip_absent_in_ip_pool' => 'O endereço IP %1 não está presente no repositório de IP do utilizador alvo.',
    'chown__error_ip_not_exist' => 'O endereço IP com identificação \'%1\' não existe.',
    'chown__error_domain_ip_not_selected' => 'Deve ser selecionado pelo menos um endereço IP para o domínio %1. Verifique os valores selecionados para o mapeamento de IP.',

    '__new_passwd_single' => "Palavra-passe",
    '__confirm_passwd_single' => "Confirmar a palavra-chave",

    'mail__ip_or_mask_is_invalid_ipv6' => 'O endereço ou máscara de IPv6 é inválido: O endereço IP deve ser um endereço unicast válido.',

    '__subscriptions' => 'Assinaturas',

    '__owned_by_reseller' => 'pertencente ao revendedor',
    '__owned_by_provider' => 'pertencente ao fornecedor',

    'service_plan__anonymous' => 'Personalizado',
    'subscription_not_locked__change_limits_warning' => 'Esta assinatura não está bloqueada: Os limites de utilização de recursos serão alterados durante a sincronização com o plano de serviço.',
    'subscription_not_locked__change_permissions_warning' => 'Esta assinatura não está bloqueada: As permissões serão alteradas durante a sincronização com o plano de serviço.',

    'subscription__conflict_resolution_policy' => 'Política de resolução de conflitos',
    'subscription__conflict_resolution_policy_lock' => "Bloquear assinatura",

    'backup__list__backup_warnings' => 'Avisos',
    'backup__list__backup_info' => 'Informação',
    'backup__restore__object_reseller_template' => 'Modelo de revendedor',
    'backup__restore__object_domain_template' => 'Modelo de domínio',

    'ui__client/permissions_readonly__title' => 'Permissões',
    'ui__client/permissions_readonly__short-title' => 'Permissões',

    'subscription__unable_lock_anonymous' => 'Esta assinatura não está ligada a um plano de serviço, portanto, não pode ser desbloqueado.',
    'subscription__unable_sync_anonymous' => 'Esta assinatura não está ligada a um plano de serviço, portanto, não pode ser sincronizada.',
    'subscription__unable_sync_locked' => 'Esta assinatura está bloqueada, portanto, não pode ser sincronizada.',
    'subscription__locked' => 'A assinatura está bloqueada.',
    'component_name__urlrewrite' => "Reescrever URL",
    '__quantity' => 'Quantidade',
    'hst__www_root_dir_absent' =>  'Atenção: O diretório especificado como raiz do documento não existe.',
    'object_creation__domain_is_not_a_webspace' => 'Este objeto pode ser criado apenas numa assinatura.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'A assinatura contém sítios, portanto, não pode alterar o tipo de alojamento ou eliminá-lo.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Erro: Falha ao atualizar o endereço IP.Os domínios de adição não podem ser atribuídos a um endereço IP não atribuído ao domínio principal da assinatura.',
    'domain_plan__unable_change' => 'Impossível alterar o plano de serviço: %1.',
    'domain_plan__different_hosting_type' => 'O atual tipo de alojamento é diferente do tipo especificado no plano de serviço.',
    'domain_plan__addon_text' => 'Plano de complemento',
    'domain_plan__addon_description' => 'O plano de complemento é utilizado para suplementar um plano de alojamento.',
    'asp_net__managed_runtime_version' => 'Versão do tempo de execução gerido por ASP.NET',
    'plan__can_not_change_hosting_type' => 'É impossível alterar o tipo de alojamento durante a edição de um plano.',
    'plan__apply_problems' => 'O plano não foi aplicado por a problemas com as seguintes funcionalidades: %1',
    'plan_save__subscription_update_problem' => 'Impossível aplicar alterações do plano para %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "A assinatura está temporariamente suspensa até o término do processo de backup ou reposição. Por favor, volte mais tarde.",
    'mail__whitenet_exists' => "Lista branca com prefixo %1 já existe.",
    '__login_incorrect_plain_shadow_password' => 'Foi especificada a palavra-passe incorreta para a conta de administrador. Por favor, utilize as credenciais do administrador (raiz) do sistema, ou obtenha a palavra-passe correta. Para saber mais sobre como obter a palavra-passe, leia o ficheiro /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Não pode enviar o endereço IP que não possui.',

    'dns__dns_zone_not_synchronized' => 'A zona de DNS foi alterada. Se desejar aplicar alterações ao modelo de DNS desta zona, clique no botão \'Aplicar Alterações do Modelo de DNS\' nesta página, ou escolha a opção \'Aplicar as alterações para todas as zonas\' no Painel de Administração do Servidor > Ferramentas & Configurações > Configurações do Modelo de DNS > Aplicar Alterações no Modelo de DNS.',
    'dns__dns_zone_synchronize_link' => 'Clique',
    'dns__dns_zone_synchronize_done' => 'A zona de DNS foi sincronizada com sucesso.',

    'dns__dns_zone_template_not_synchronized' => 'O modelo da zona DNS foi alterado e será aplicado a todos os domínios recém-criados. Também pode %1.',
    'dns__dns_zone_soa_template_not_synchronized' => 'O modelo SOA foi alterado e será aplicado a todos os domínios recém-criados. Também pode %1.',
    'dns__dns_zone_template_synchronize_link' => 'aplicar as alterações a todos os domínios hospedados',
    'dns__dns_zone_template_error_details' => 'Detalhes',
    'dns__dns_zone_template_error' => 'Ocorreram problemas ao sincronizar zonas DNS com o modelo de zona DNS.%1',

    'dns__soa_rname_type_owner' => 'Endereço de e-mail do proprietário do website',
    'dns__soa_rname_type_domain' => 'Endereço de e-mail do domínio',
    'dns__soa_rname_type_external' => 'Endereço de e-mail externo',
    'dns__soa_rname_enforce_email' => 'Proibir a alteração do endereço de e-mail RNAME por domínio',
    'dns__soa_rname_label' => 'E-mail (RNAME)',
    'dns__soa_rname_hint' => 'O endereço de e-mail da pessoa responsável pela zona de domínio DNS. Devolvido pelo servidor DNS em resposta a consultas SOA.',

    'dns__dns_zone_soa_sync_title' => 'Substituir configurações de SOA para todos os domínios existentes',
    'dns__dns_zone_soa_sync_legend' => 'Necessária confirmação',
    'dns__dns_zone_soa_sync_text' => 'Atualizar registos SOA de todos os domínios alojados, aplicando as alterações feitas no modelo SOA?',

    'cu_db__repair_mysql_dbus' => "Reparar as senhas de utilizador do MySQL. Esta operação é necessária caso tenha atualizado para o Plesk 11 a partir de versões antigas.",

    'scheduled_backup_settings__start_at_hint' => 'O intervalo de verificação para tarefas agendadas de cópia de segurança é de 15 minutos. Caso deseje que o Plesk inicie o processo de cópia de segurança num determinado horário, agende a tarefa para, pelo menos, 15 minutos antes do horário desejado.',
    'cu_scheduled_backup_comment' => 'Cópia de segurança agendada',
    'cu_scheduled_backup_error' => 'Ocorreu um erro durante o procedimento de cópia de segurança: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Ocorreu um erro durante a cópia de segurança agendada.',
    'cu_scheduled_backup_mail_message' => "%1\nPonto de entrada do Plesk: %2\n\nOcorreu o erro seguinte durante o procedimento de cópia de segurança agendado:\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'Cópia de segurança agendada. Toda a configuração e conteúdo.',
    'cu_scheduled_backup_comment_backup_vhost' => 'Cópia de segurança agendada. Toda a configuração e conteúdo, exceto o correio.',
    'cu_scheduled_backup_comment_backup_mail' => 'Cópia de segurança agendada. Apenas configuração e conteúdo do correio.',
    'cu_scheduled_backup_comment_backup_domain' => 'Cópia de segurança agendada. Configuração do domínio.',

    'i_backup_invalid_file' => 'Este não é um ficheiro de backup válido. Os dados não podem ser repostos deste ficheiro. Clique no nome de backup para detalhes.',

    'ui__server/migration/download-agent__short-title' => 'Descarregar Migration & Transfer Agent',
    'ui__server/migration/download-agent__title' => 'Descarregar Migration & Transfer Agent',
    'ui__server/migration/download-agent__description' => 'Transfira a versão mais recente do Agente de Migração e Transferência partir do site do Plesk.',

    'filemanager_resulting_archive_exists' => 'O ficheiro %1 já existe no diretório alvo.',

    'agent_unable_to_connect' => 'Impossível ligar ao agente em \'%2\'. Por favor, verifique se o agente está instalado e a executar e se existem problemas de ligação com o host \'%2\'.',
    'agent_test_connection_failed' => 'Falha na ligação com o agente em \'%2\'.',

    'agent_unable_to_resolve_host' => 'Impossível localizar o host remoto \'%1\'. Por favor, verifique se há problemas na ligação com o host.',
    'agent_unknown_curl_error' => 'Ocorreu o erro \'%1\' durante a ligação ao agente em \'%2\'.',
    'agent_unexpected_htp_code' => 'O código HTTP inesperado \'%1\' foi recebido na requisição HTTP ao agente em \'%2\'.',
    'agent_unable_to_auth' => 'Impossível autenticar no host \'%1\'. Para resolver este problema, siga as instruções em http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Foi encontrado um erro interno do servidor durante a execução do comando no host remoto \'%1\'.',
    'agent_response_is_empty' => 'Foi recebida uma resposta vazia à requisição HTTP ao agente em \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Impossível encontrar o Migration & Transfer Agent no cache local. Por favor, reabra o Migration & Transfer Agent para resolver o problema.',

    '__hosting_webdeploy' => "Publicação do Web Deploy",
    'cu_domain__webdeploy' => "Publicação do Web Deploy (predefinido: %1)",
    'cu_dom_tpl__webdeploy' => "Publicação do Web Deploy (predefinido: %1)",
    'cu_subdomain__webdeploy' => "Publicação do Web Deploy (predefinido: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy não está instalado no servidor",
    'webdeploy__forced_by_site_isolation' => "Impossível alterar as configurações de publicação do Web Deploy: Não tem permissão para anular a política de segurança do servidor. Contacte o seu fornecedor para mais detalhes.",



    'backup__restore_options__admin__server_configuration_license' => 'Chave de licença',
    'migration_start_migrate_server_license' => 'Chave de licença de transferência',

    'defaultcomponents__delegation_rule_not_exist' => '(a regra de delegação necessária \'appPoolPipeline, appPoolNetFx\' não existe)',

    '__o' => 'D',

    'i_backup_created_by_admin' => 'O backup foi criado pelo administrador.',
    'i_backup_created_by_reseller' => 'O backup foi criado por um revendedor.',
    'i_backup_created_by_client' => 'O backup foi criado por um cliente.',

    'migration__object_exists_on_target_host' => '(já existe no host de destino)',

    '__customers_total' => 'Total por clientes',
    '__resellers_total' => 'Total por revendedores',
    '__reseller_total' => 'Total de revendedores',


    'cu__mailserver_update_webmail_command' => "Especifica um cliente de webmail que deseja ativar ou desativar",
    'cu__mailserver_webmail_state' => "Especifica o estado do cliente de webmail selecionado (\"true\" ativa o cliente, \"false\" desativa-o)",

    'cu_db_set_default_user' => 'Faça uma predefinição específica do utilizador para uma base de dados. A opção é utilizada com os comandos: add_user, update_user',

    'cu_role__opt_subscription_name' => 'Permitir que utilizadores tenham acesso apenas a uma assinatura específica',
    'cu_role__opt_for_all_subscription' => 'Permitir que utilizadores tenham acesso a todos as assinaturas dentro de uma conta de alojamento',
    'cu_role__subscription_not_found_role_is_not_limited' => 'Impossível aplicar alterações na função: A assinatura %1 não foi encontrada.',

    'cu_cl_pref__manage_website_maintenance' => 'Acesso a operações avançadas: Cópia de Websites',
    'cu_cl_pref__manage_protected_dirs' => 'Administração dos diretórios protegidos por palavra-passe.',
    'cu_cl_pref__manage_mail_settings' => 'Capacidade de alterar as configurações de correio',


    'cu__command_update_php_settings' => 'Atualiza as configurações de PHP.',
    'cu__php_settings_option' => 'Define o caminho para o ficheiro com configurações de PHP.',

    'cu__additional_php_settings_option' => 'Define o caminho para o ficheiro com diretivas adicionais de PHP.',
    'cu__command_show_php_settings' => 'Exibe as configurações atuais de PHP.',
    'cu__general_settings' => 'Configurações gerais:',
    'cu__performance_settings' => 'Configurações de desempenho:',
    'cu__php_fpm_settings' => 'Definições PHP-FPM:',
    'cu__additional_directives' => 'Diretrizes adicionais:',

    'b_filemanager__pack' => 'Adicionar para guardar os ficheiros selecionados.',

    'php_settings_permission_required' => 'Administração das configurações de PHP comum',
    'php_settings_performance_permission_required' => 'Administração das configurações de desempenho de host',
    'php_settings_customized' => 'Configurações PHP foram personalizadas',
    'php_settings_synchronized_with_plan' => 'As configurações de PHP devem estar sincronizadas com o plano.',
    'phosting__unknown_shell_type' => 'Shell não disponível',

    'login_up__access_denied_subscription_deleted' => 'Acesso negado: O sua assinatura foi removida.',

    'role_restricted_to_subscription' => '(transferida com a assinatura: %1)',

    'filemanager__extract' => "Extrair ficheiros para: %1",

    'cu__license_command_check_installed_license' => 'Verificar a validade da chave de licença instalada (volta para o código de saída 0 se a chave estiver válida e para 1 se estiver inválida)',

    'promo__mobile_manager_title' => 'Plesk Mobile Server Manager',
    'promo__mobile_manager' => "Amplie a funcionalidade do Plesk para poder controlar e monitorizar o servidor a partir de dispositivos móveis (BlackBerry, iPhone e Androide).",
    'promo__mobile_monitor_title' => 'Plesk Mobile Server Monitor',
    'promo__mobile_monitor' => 'Obtenha as informações mais importantes sobre os servidores do Plesk a qualquer hora e em qualquer lugar a partir de um dispositivo móvel (BlackBerry, iPhone e Androide).',
    'promo__mobile_button' => 'Aprender Mais',

    'ui__server/migration/video__short-title' => 'Tutoriais de vídeo',
    'ui__server/migration/video__title' => 'Assistir tutoriais de vídeo',
    'ui__server/migration/video__description' => 'Assistir tutoriais de vídeo.',

    'auto_install_updates_moved_to_separate_page' => 'Configurar política de atualização',

    '__system_preferences' => 'Preferências do sistema',
    'subDomainNameHint' => 'Introduzir * para criar um subdomínio universal. Os visitantes do website serão redirecionados para este subdomínio, independentemente do nome do subdomínio introduzido no navegador.',
    'subdomains__wildcard_name_invalid' => "O nome de sub-domínio é inválido. Pode utilizar apenas carateres alfanuméricos, um hífen (-) e um asterisco (*) para nomes de sub-domínio wildcard.",
    'subdomains__name_invalid' => "O nome de sub-domínio é inválido. Pode utilizar apenas carateres alfanuméricos e um hífen (-) para nomes de sub-domínio.",

    'domain__wildcard_no_www_prefix' => 'Não é possível utilizar o prefixo www para subdomínios com wildcard.',

    '__service_title__milter' => "Milter do Plesk Postfix",
    '__service_description__milter' => "Filtro de correio Plesk Postfix",
    '__milter' => "Milter do Postfix",
    'restart__milter' => "Milter do Plesk (%1)",
    'restart__pop3' => "Servidor do Courier POP3",
    'restart__pop3s' => "Servidor do Courier POP3 com suporte SSL/TLS",
    'restart__imap' => "Servidor do Courier IMAP",
    'restart__imaps' => "Servidor do Courier IMAP com suporte SSL/TLS",
    'restart__authdaemon' => "Daemon de autenticação do Courier IMAP",
    'restart__imap-pop3' => "Servidor Dovecot IMAP e POP3",


    'addon_packages_not_supported' => 'Complementos para o pacote de aplicações APS não são suportados.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Impossível atribuir automaticamente um endereço IP para o domínio. Por favor, introduza um endereço IP utilizando a opção -ip',

    'plesk_key__mb_accounts' => 'Contas de utilizador (revendedores e clientes) no Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Zona de DNS do sub-domínio',
    'actionlog__site_subdomain_dns' => 'Zona DNS de um sub-domínio num domínio adicional',

    // PfW only
    'actionlog__event_site_create' => 'O domínio foi criado',
    'actionlog__event_site_delete' => 'O domínio foi eliminado',
    'actionlog__event_site_update' => 'O domínio foi atualizado',

    'actionlog__event_site_status_update' => 'O estado do domínio foi atualizado',
    'actionlog__event_site_dns_update' => 'Zona DNS do domínio atualizada',
    'actionlog__event_site_guid_update' => 'O GUID do domínio foi atualizado',

    'actionlog__event_site_subdomain_create' => 'O sub-domínio foi criado',
    'actionlog__event_site_subdomain_delete' => 'O sub-domínio foi eliminado',
    'actionlog__event_site_subdomain_update' => 'O sub-domínio foi atualizado',

    'actionlog__event_site_alias_create' => 'O nome alternativo de domínio foi criado',
    'actionlog__event_site_alias_delete' => 'O nome alternativo de domínio foi eliminado',
    'actionlog__event_site_alias_update' => 'O nome alternativo de domínio foi atualizado',

    'actionlog__event_site_alias_dns_update' => 'A zona DNS de um nome alternativo de domínio foi atualizada',
    'actionlog__event_subdomain_dns_update' => 'A zona DNS de um sub-domínio num domínio predefinido foi atualizada',
    'actionlog__event_site_subdomain_dns_update' => 'A zona DNS de um sub-domínio foi atualizada',
    // End of PfW only

    'rdp_app__type' => 'Aplicação para sessão de terminal',
    'rdp_app__msactivex' => 'MS RDP ActiveX',
    'rdp_info__prop_title' => "Ligar ao Servidor via Remote Desktop",
    'rdp_info__session_title' => 'Sessão de terminal com o servidor %1 (%2)',
    'rdp_info__prop_legend' => "Propriedades de sessão terminal",
    'rdp_screen_resolution' => 'Resolução do écran para a sessão terminal',
    'rdp_user_name' => 'Nome de utilizador da sessão de terminal',

    'win_policy__bad_password' => 'Falha na validação. A senha é inválida.',
    'win_policy__password_too_short' => 'Falha na validação. A senha não preenche os requisitos da politica de senhas porque é muito curta.',
    'win_policy__password_too_long' => 'Falha na validação. A senha não preenche os requisitos da politica de senhas porque é muito longa.',
    'win_policy__password_not_complex_enough' => 'A validação falhou. A palavra-passe não é suficientemente complexa e não cumpre os requisitos da política de palavra-passe. As palavras-passe fortes têm de conter, pelo menos, todos os seguintes itens: oito carateres; um caráter de letra maiúscula ou minúscula; três números e um caráter especial (!, @, #, $, %, ^, &, *, ?, _, ~) ou um número e dois carateres especiais.',

    //// Activation Code feature
    'key__tabs_activation' => 'Activação da Chave de Licença',
    'key__description' => 'Aqui pode instalar a chave de licença, inserindo um código de ativação ou carregando um ficheiro da chave de licença.',
    'key__description_code_only' => 'Aqui, pode instalar a sua chave de licença introduzindo um código de ativação.',
    'key__license_key' => 'Escolha uma das seguintes:',
    'key__code_text' => 'Insira o código de ativação',
    'key__code_hint' => 'Cole o código de ativação recebido.',
    'key__file_text' => 'Carregar um ficheiro da chave de licença.',
    'key__file_hint' => 'Especifique o caminho para o ficheiro que contém a chave de licença.',
    'plesk_key__code_check_wrong' => 'O código de ativação não é válido.',
    'plesk_key__license_update_failed' => 'Não é possível atualizar a licença de produto.',


    'filemanager__error_path_is_not_allowed' => 'O caminho não é permitido',
    'filemanager__error_path_is_invalid' => 'O caminho é inválido',
    'filemanager__error_path_not_found' => 'Caminho não encontrado',
    'filemanager__error_path_already_exists' => 'O caminho já existe',
    'filemanager__error_access_is_denied' => 'Acesso recusado',
    'filemanager__error_directory_not_empty' => 'A pasta não está vazia',
    'filemanager__error_sharing_violation' => 'Violação da partilha',
    'filemanager__error_not_same_device' => 'O caminho de destino não é no mesmo equipamento',
    'filemanager__binary_data_access' => 'O ficheiro pode ser do tipo binário. Abrir na mesma?',
    'filemanager__unable_to_resolve_realpath' => "Impossível encontrar o ficheiro %1 no local especificado",
    'filemanager__access_to_realpath_denied' => "Acesso ao caminho real negado: %1 a %2.",
    'bt_exit' => 'Sair',

    'filemanager__chdir_error__' => "Impossível alterar directório para %1: %2",
    'filemanager__chmod_dir' => "Alterar permissões para o directório %1",
    'filemanager__chmod_error__' => "Impossível alterar permissões para o arquivo %1: %2",
    'filemanager__chmod_file' => "Alterar permissões para o arquivo %1",
    'filemanager__copy_error__' => "Impossível copiar %1 para %2: %3",
    'filemanager__copy_move' => "Copiar (mover) arquivos de %1",
    'filemanager__count_size__' => 'Tamanho da selecção: %1',
    'filemanager__count_size_error__' => 'Não foi possível contar o tamanho de %1: %2',
    'filemanager__create_dir' => "Criação de directório",
    'filemanager__create_dir_error__' => "Impossível criar directório %1: %2",
    'filemanager__dir_not_exists' => "Directório %1 não existe.",
    'filemanager__dirname' => "Nome do directório",
    'filemanager__filename' => "Nome do arquivo",
    'filemanager__is_no_such' => "Não há nenhum arquivo ou directório com o nome %1",
    'filemanager__empty_selection' => "Nenhum arquivo(s) seleccionado.",
    'filemanager__file_exists' => "Arquivo %1 já existe.",
    'filemanager__move_error__' => "Impossível mover %1 para %2: %3",
    'filemanager__new_dir' => "Nome do directório",
    'filemanager__not_allowed' => "Não lhe é permitido alterar as permissões deste ficheiro.",
    'filemanager__r_perm_dir' => "Lista do directório",
    'filemanager__r_perm_file' => "Ler dados",
    'filemanager__remove' => "Remover arquivos de %1",
    'filemanager__remove_error__' => "Impossível remover arquivo %1: %2",
    'filemanager__rename_dir' => "Renomear directório %1",
    'filemanager__rename_error__' => "Impossível renomear %1 para %2: %3",
    'filemanager__rename_file' => "Renomear arquivo %1",
    'filemanager__set_win_permissions_dir' => "Definir permissões para a pasta %1",
    'filemanager__set_win_permissions_file' => "Definir permissões para o arquivo %1",
    'filemanager__touch_confirm' => "Você tem certeza de que deseja alterar o timestamp para os arquivos seleccionados?",
    'filemanager__no_perms_or_unsupported_file_type' => 'Não foi possível ler o arquivo ou o tipo de arquivo não é suportado.',
    'filemanager__upload_error__' => "Impossível carregar %1 para %2: %3",
    'filemanager__upload_file' => "Carregar arquivo",
    'filemanager__upload_file_src' => "Caminho para o ficheiro",
    'filemanager__username' => "Utilizador",
    'filemanager__w_perm_dir' => "Criar ficheiros",
    'filemanager__w_perm_file' => "Escrever dados",
    'filemanager__x_perm_dir' => "Abrir directório",
    'filemanager__x_perm_file' => "Executar ficheiro",
    'filemanager__max_image_size_exceeded' => 'Impossível exibir a imagem. O tamanho da imagem não pode ser maior que %2 bytes',

    '__fastcgi_unix_support' => 'Suporte FastCGI',

    'ts_sessions_list' => 'Esta página exibe uma lista de todas as Sessões de Terminal de Serviços.',
    'b_tssessionslist_search' => 'Procurar sessões por nome.',
    'b_tssessionslist_show_all' => 'Exibir todas as sessões de Terminal Services',
    'l_tssessionslist_state' => 'Ordenar por estado.',
    'l_tssessionslist_name' => 'Ordenar por nome.',
    'l_tssessionslist_user' => 'Ordenar por utilizador.',
    'b_tssessionslist_logoff' => 'Clique para fechar as sessões seleccionadas.',
    'b_tssessionslist_disconnect' => 'Clique para desligar as sessões seleccionadas.',
    'tssessions_info' => 'Visualizar as propriedades da sessão.',
    'tssessions_disconnect' => 'Selecione a caixa de verificação Confirmar Remoção e clique OK para desligar as sessões de terminal de servidor selecionadas.',
    'tssessions_logoff' => 'Selecione a caixa de verificação Confirmar Remoção e clique OK para sair das sessões de terminal de servidor selecionadas.',
    'b_tssession_disconnect_submit' => 'Clique para submeter as modificações.',
    'b_tssession_logoff' => 'Clique para sair da sessão.',
    'b_tssession_logoff_submit' => 'Clique para submeter as modificações.',
    'i_tssession_active' => 'Activa',
    'i_tssession_connected' => 'Ligado',
    'i_tssession_disconnected' => 'Desligada',
    'i_tssession_listen' => 'Á escuta',
    'tssessions__tssessionslist' => 'Sessões',
    'tssessionslist__state' => 'F',
    'tssessionslist__name' => 'Nome',
    'tssessionslist__user' => 'Utilizador',
    'bt_logoff_selected' => 'Sair',
    'bt_logoff' => "Sair",
    'bt_disconnect_selected' => 'Desligar',
    'bt_tssession_logoff' => 'Sair',
    'bt_tssession_disconnect' => 'Desligar',
    'bt_tssession_disconect' => 'Desligar',
    'b_tssession_disconnect' => 'Clique para desligar a sessão.',
    'b_tssession_logoff_disabled' => 'Impossível sair da sessão.',
    'b_tssession_disconnect_disabled' => 'Impossível desligar a sessão.',
    'tssessions_info__title' => 'Propriedades da Sessão %1',
    'tssessions_info__property_name' => 'Nome da Propriedade',
    'tssessions_info__property_value' => 'Valor da Propriedade',
    'tssessions__disconnect_title' => 'As seguintes sessões de Serviços Terminais serão desconectadas:',
    'tssessions__session_cant_disconnect' => 'A sessão não pode ser desconectada',
    'tssessions__logoff_title' => 'As seguintes sessões de Serviços Terminais serão desligadas:',
    'tssessions__session_cant_logoff' => 'A sessão não pode ser desligada',
    'tssessions__select_sessions_to_logoff' => 'Por favor, seleccione as sessões a serem desligadas.',
    'tssessions__select_sessions_to_disconnect' => 'Por favor, seleccione as sessões a serem desconectadas.',
    'dns__subdomain_dns_zone_parent' => 'Os registos de DNS deste sub-domínio estão armazenados na zona principal de DNS. Pode alterar a zona principal %1 ou criar uma zona separada para o sub-domínio.',
    'dns__subdomain_dns_zone_parent_link' => 'aqui',
    'dns__no_dns_zone' => 'Nenhuma zona de DNS atribuída ao domínio. Para gerir a zona de DNS para seu domínio, clique no botão \'Restore Defaults\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Impossível habilitar a zona do subdomínio pois há um registro CNAME para este subdomínio em sua zona de domínio.',

    '__hosting_write_modify' => 'Permissões adicionais de escrita/modificação',


    'aspdotnet__title' => "Configuração de ASP.NET para todo o Servidor",
    'aspdotnet__dom_title' => "Configuração ASP.NET para Página Web",
    'aspdotnet__wdir_title' => "Configuração ASP.NET para Diretório Virtual %1",
    'aspdotnet__group_cas_settings' => "Segurança de Acesso ao Código",
    'aspdotnet__group_client_scripts' => "Configurações da Biblioteca de Script",
    'aspdotnet__group_conn_strings' => "Administrador da String de Conexão",
    'aspdotnet__group_custom_errors' => "Configurações personalizadas de erro",
    'aspdotnet__group_framework_version' => "Versão do Framework",
    'aspdotnet__group_globalization' => "Configurações Globais",
    'aspdotnet__group_other' => "Configurações de Sessão",
    'aspdotnet__group_page_and_runtime' => "Compilação e Debugging",
    'aspdotnet__invalid_dom_config_file' => "O ficheiro de configuração ASP.NET para esta página web está corrompido. Para repor, aplique a configuração ASP.NET predefinida do servidor, clicando em Definir Padrão.",
    'aspdotnet__invalid_file_enc' => "Valor inválido para o parâmetro de codificação do Ficheiro.",
    'aspdotnet__invalid_req_enc' => "Valor inválido para o parâmetro de codificação da Requisição.",
    'aspdotnet__invalid_res_enc' => "Valor inválido para o parâmetro de codificação da Resposta.",
    'aspdotnet__invalid_parent_wdir_config_file' => "O ficheiro de configuração ASP.NET está corrompido devido a danos na configuração ASP.NET do %1 diretório principal. \nRepor o %1 configuração ASP.NET para resolver este problema.",
    'aspdotnet__invalid_global_config_file_admin' => "A configuração ASP.NET está corrompida devido a danos no ficheiro de configuração ASP.NET do servidor.",
    'aspdotnet__invalid_global_config_file' => "A configuração ASP.NET está corrompida devido a danos no ficheiro de configuração ASP.NET do servidor. Por favor, contacte o seu fornecedor de serviços.",
    'aspdotnet__invalid_sess_timeout' => "Valor inválido para o parâmetro de tempo de ócio da Sessão. Insira um número inteiro positivo menor ou igual a %1.",
    'aspdotnet__invalid_wdir_config_file' => "O ficheiro de configuração ASP.NET para este diretório virtual está corrompido. Para repor, aplique a configuração ASP.NET predefinida do diretório virtual principal, clicando em Definir Padrão.",
    'aspdotnet__param_auth_mode' => "Modo de Autenticação",
    'aspdotnet__param_conn_strings' => "String de Conexão",
    'aspdotnet__param_conn_string_name' => "Nome",
    'aspdotnet__param_conn_string_value' => "Parâmetros de Conexão",
    'aspdotnet__param_culture' => "Cultura",
    'aspdotnet__param_custom_err_mode' => "Modo de erro personalizado",
    'aspdotnet__param_custom_error_redirect' => "Redireccionar o URL",
    'aspdotnet__param_custom_error_status' => "Código do Estado",
    'aspdotnet__param_custom_errors' => "Erros personalizados",
    'aspdotnet__param_debug_mode' => "Ligar debugging",
    'aspdotnet__param_def_language' => "Linguagem predefinida da página",
    'aspdotnet__param_temp_directory' => "Diretório temporário",
    'aspdotnet__param_file_enc' => "Codificação de Arquivo",
    'aspdotnet__param_req_enc' => "Codificação de Pedido",
    'aspdotnet__param_res_enc' => "Codificação de Resposta",
    'aspdotnet__param_sess_timeout' => "Timeout da Sessão (minutos)",
    'aspdotnet__param_trust_level' => "Nível de confiança CAS",
    'aspdotnet__param_ui_culture' => "Cultura UI",
    'aspdotnet__param_version' => "Versão",
    'aspdotnet__param_trust_level_allow_override' => 'Permitir alteração no nível de confiança CAS para sites web individuais',
    'aspdotnet__restore_default_confirm' => "Repor as configurações predefinidas do ASP.NET?",

    'bt_restore_default' => "Repor predefinição",
    'b_aspdotnet' => 'Editar as configurações do ASP.NET.',
    'b_aspdotnet__restore_default' => 'Repor as configurações predefinidas do ASP.NET.',
    'b_aspdotnet__restore_wdir_default' => "Repor as configurações do ASP.NET do diretório principal para este diretório virtual.",
    'b_aspdotnet__restore_default_disabled' => 'Reposição da configuração predefinida do ASP.NET não está disponível: A configuração do ASP.NET está corrompida no servidor ou num nível do diretório principal.',
    'b_autoinstaller' => 'Atualizar o Plesk ou as suas componentes.',
    'b_autoinstaller_configure' => 'Atualizar configurações.',
    'b_autoinstaller_install' => 'Instale os componentes seleccionados.',

    '__iis_app_pool__use_dedicated' => 'Repositório de aplicações IIS exclusivo',
    '__iis_app_pool__use_dedicated_addons' => 'Conjunto de aplicações IIS dedicado para cada página web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Ativar aplicações de 32 bits',
    'bt_iis_app_pool' => "Repositório de aplicações do IIS",

    'performance__cpu_usage' => 'Utilização máxima de CPU (%)',
    'performance__cpu_usage_action' => 'Ação de limite',
    'performance__cpu_usage_interval' => 'Intervalo do limite (minutos)',
    'performance__cpu_usage_action_not_supported' => 'A ação especificada não é suportada pelo servidor de rede.',

    'performance__idle_timeout_action_not_supported' => 'A ação de tempo limite especificada não é suportada pelo servidor de rede.',
    'performance__max_worker_processes' => 'Número máximo de processos de trabalho',
    'performance__idle_timeout' => 'Tempo limite inativo (minutos)',
    'performance__idle_timeout_action' => 'Ação de tempo limite',
    'performance__recycling_by_time' => 'Reciclagem em intervalos regulares (minutos)',
    'performance__recycling_by_requests' => 'Reciclagem quando o número máximo de solicitações é alcançado',
    'performance__recycling_by_virtual_memory' => 'Reciclagem quando a quantidade máxima de memória virtual é utilizada',
    'performance__recycling_by_private_memory' => 'Reciclagem quando a quantidade máxima de memória privada é utilizada',
    'performance__managed_pipeline_mode' => 'Gerir o modo pipeline',
    'performance__managed_pipeline_mode_not_supported' => 'O modo indicado não é suportado pelo servidor web.',

    'iis_app_pool' => 'Administração do repositório de aplicações do IIS.',
    'b_iis_app_pool' => 'Administrar o repositório de aplicações do IIS.',
    'iis_app_pool_cl_dom' => 'Gestão do repositório de aplicações IIS.',

    'i_webdirs_not_protected' => 'Este diretório não está protegido.',
    'i_webdirs_protected' => 'Este diretório está protegido.',
    'i_webdirs_manage_protection' => 'Gerir proteção.',
    'i_webdirs_open' => 'Abra o diretório/ficheiro via browser.',
    'i_webdirs_preferences_disabled' => 'Não é um directório Virtual.',
    'i_webdirs_permissions' => 'Gerir permissões.',
    'i_webdirs_permissions_disabled' => 'A administração das permissões do diretório não está disponível.',
    'i_webdirs_type_dir' => 'Directório Físico',
    'i_webdirs_type_vdir' => 'Directório Virtual',
    'i_webdirs_browse' => 'Navegue pelo conteúdo do diretório.',
    'i_webdirs_preferences' => 'Gestão das configurações do diretório Web.',

    'l_webdirslist_type' => 'Ordenar diretórios por tipo.',
    'l_webdirslist_protected' => 'Ordenar diretórios por estado de proteção.',
    'l_webdirslist_name' => 'Ordenar diretórios por nome.',

    'b_webdirslist_remove' => 'Eliminar os diretórios virtuais selecionados.',
    'b_webdirslist_search' => 'Insira um padrão de procura e clique no botão para procurar diretórios virtuais.',
    'b_webdirslist_show_all' => 'Mostrar todos os diretórios.',

    'l_webdirerrordocslist_code' => 'Ordenar os documento de erro por numero de erro',
    'l_webdirerrordocslist_name' => 'Ordenar os documento de erro por descrição',
    'l_webdirerrordocslist_type' => 'Ordenar os documento de erro por tipo',
    'l_webdirerrordocslist_location' => 'Ordenar os documento de erro por localização.',

    'b_webdirerrordocslist_search' => 'Insira um padrão de procura e clique no botão para procurar documentos de erro.',
    'b_webdirerrordocslist_remove' => 'Eliminar os documentos de erro seleccionados.',
    'b_webdirerrordocslist_show_all' => 'Visualizar todos os documentos de erro.',

    'l_webdirmimetypeslist_name' => 'Ordenar os tipos de MIME por extensão',
    'l_webdirmimetypeslist_content' => 'Ordenar os tipos de MIME por conteúdo',

    'b_webdirmimetypeslist_remove' => 'Eliminar os tipos de MIME seleccionados.',
    'b_webdirmimetypeslist_search' => 'Insira um padrão de pesquisa e clique no botão para procurar nos tipos de MIME.',
    'b_webdirmimetypeslist_show_all' => 'Visualizar todos os tipos de MIME.',

    'b_webdir_preferences' => "Configurações dos diretórios virtuais.",
    'b_webdir_permissions' => "Permissões do diretório virtual.",
    'b_webdir_permissions_disabled' => "A administração das permissões do diretório virtual não está disponível.",
    'b_to_webdirs' => 'Voltar para gerir os diretórios.',
    'b_to_webdir_mime_types' => 'Voltar à gestão dos Tipos de MIME.',
    'b_to_webdir_error_docs' => 'Voltar para gerir os documentos de erro.',
    'b_to_webdir_protection' => 'Voltar para gerir a proteção do diretório virtual.',

    'webdirs__title' => 'Diretório Virtual %1',
    'webdirs__preferences_title' => 'Configurações do Diretório Virtual',
    'webdirs__list_legend' => 'Diretórios virtuais',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Nome',
    'webdirs__list_header' => '%1 itens',
    'webdirs__tabs_general' => 'Geral',
    'webdirs__tabs_mime_types' => 'Tipos MIME',
    'webdirs__tabs_error_docs' => 'Documento de erro',

    'webdirs__tabs_permissions' => 'Permissões',
    'webdir__remove_vdirs' => 'Os seguintes diretórios virtuais serão eliminados:',
    'webdir__remove_mime_types' => 'Os seguintes tipos de MIME serão eliminados:',
    'webdir__mime_types_title' => 'Tipos MIME',
    'webdir__protection_disable_confirm' => 'Quer realmente remover a protecção do directório?',
    'webdir__protect_title' => 'Utilizadores do directório protegido',
    'webdirs__permissions_title' => 'Permissões do diretório virtual',
    'webdirs__browse_content_permission_denied' => 'Não tem permissão para ver os conteúdos deste diretório.',
    'error_doc__list_code' => 'Erro',
    'error_doc__list_code_description' => 'Descrição',
    'error_doc__list_type' => 'Tipo',
    'error_doc__list_location' => 'Local',
    'error_doc__code' => 'Erro',
    'error_doc__type' => 'Tipo',
    'error_doc__type_file' => 'Arquivo',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Local',
    'error_doc__legend' => 'Documento de Erro',
    'error_doc__edit_title' => 'Editar documento de erro',
    'error_doc_erorr_invalid_url_location' => 'O URL é inválido. Por favor, introduza o URL correto.',
    'error_doc_erorr_invalid_file_location' => 'O caminho do ficheiro é inválido. Por favor, introduza o caminho correto do ficheiro.',
    'error_doc__type_default' => 'Predefinido',

    'webdirs__tabs_protection' => 'Protecção',
    'pb_webdirs' => 'Diretórios Virtuais',

    'webdirs_remove_title' => 'Os seguintes diretórios virtuais serão removidos:',
    'webdirs_mime_types_remove_title' => 'Os seguinte tipos MIME serão removidos:',
    'webdirs_preferences_title' => 'Configurações do Diretório Virtual',
    'webdirs_permissions_title' => 'Permissões Especiais para Ficheiros e Pastas',
    'webdi_protection_disable_confirm' => 'Tem a certeza que quer remover a proteção do diretório virtual? Isso também removerá todos os utilizadores do diretório protegido e as configurações de proteção de diretório.',
    'bt_protect' => 'Proteger',
    'bt_unprotect' => 'Remover Protecção',
    'bt_show_additional_users' => 'Mostra utilizadores adicionais',
    'bt_hide_additional_users' => 'Ocultar utilizadores adicionais',
    'error_doc__list_title' => 'Documentos de erro',
    'error_doc__list_header' => 'Documentos de erro',
    'error_doc__code_400' => 'Pedido Errado',
    'error_doc__code_401' => 'Não autorizado',
    'error_doc__code_401.1' => 'Sem autorização - O Login falhou',
    'error_doc__code_401.2' => 'Sem autorização - O Login falhou devido à configuração do servidor',
    'error_doc__code_401.3' => 'Sem autorização - Sem autorização devido ao ACL estar no recurso',
    'error_doc__code_401.4' => 'Sem autorização - Autorização falhada por filtro',
    'error_doc__code_401.5' => 'Sem autorização - Autorização falhada pela app de ISAPI/CGI',
    'error_doc__code_401.7' => 'Não autorizado - Negado devido a política de autorização de URL',
    'error_doc__code_403' => 'Proibido',
    'error_doc__code_403.1' => 'Proibido - Acesso negado para execução',
    'error_doc__code_403.2' => 'Proibido - Acesso negado para leitura',
    'error_doc__code_403.3' => 'Proibido - Acesso negado para escrita',
    'error_doc__code_403.4' => 'Proibido - requer SSL',
    'error_doc__code_403.5' => 'Proibido - Requer SSL 128',
    'error_doc__code_403.6' => 'Proibido - endereço de IP rejeitado',
    'error_doc__code_403.7' => 'Proibido - requer certificado de Cliente',
    'error_doc__code_403.8' => 'Proibido - Foi-lhe negado o acesso ao site',
    'error_doc__code_403.9' => 'Proibido - muitos utilizadores',
    'error_doc__code_403.10' => 'Proibido - Configuração inválida',
    'error_doc__code_403.11' => 'Proibido - Alteração de palavra-passe',
    'error_doc__code_403.12' => 'Proibido - Acesso negado para mapeador',
    'error_doc__code_403.13' => 'Proibido - certificado de Cliente revogado',
    'error_doc__code_403.14' => 'Proibido - Listagem de diretórios negada',
    'error_doc__code_403.15' => 'Proibido - Licenças de acesso do cliente foi excedida',
    'error_doc__code_403.16' => 'Proibido - Certificado do cliente é suspeito ou mal formado',
    'error_doc__code_403.17' => 'Proibido - certificado de Cliente expirou ou ainda não è válido',
    'error_doc__code_403.18' => 'Proibido - não pode executar o pedido deste repositório da aplicação',
    'error_doc__code_403.19' => 'Proibido - Acesso negado para CGI',
    'error_doc__code_403.20' => 'Proibido - Falha no login de passaporte',
    'error_doc__code_404' => 'Não encontrado',
    'error_doc__code_404.2' => 'Não Encontrado - Negado devido a política de suspensão',
    'error_doc__code_404.3' => 'Não Encontrado - Negado devido a política de MIMEMAP',
    'error_doc__code_405' => 'Método não permitido',
    'error_doc__code_406' => 'Não aceitável',
    'error_doc__code_407' => 'Requer autenticação de proxy',
    'error_doc__code_412' => 'Falha na pré-condição',
    'error_doc__code_414' => 'Requisição-URI muito longa',
    'error_doc__code_415' => 'Tipo de mídia não suportada',
    'error_doc__code_500' => 'Erro interno do servidor',
    'error_doc__code_500.12' => 'Erro interno do servidor - Reinício da aplicação',
    'error_doc__code_500.13' => 'Erro interno do servidor - Servidor ocupado',
    'error_doc__code_500.15' => 'Erro interno do servidor - Proibida a requisição direta para GLOBAL.ASA',
    'error_doc__code_500.16' => 'Erro interno do servidor - Erro de acesso ao UNC',
    'error_doc__code_500.17' => 'Erro interno do servidor - Armazenamento da autorização de URL não encontrado',
    'error_doc__code_500.18' => 'Erro interno do servidor - Armazenamento da autorização de URL não pode ser aberto',
    'error_doc__code_500.19' => 'Erro interno do servidor - Metadados de ficheiros rejeitados',
    'error_doc__code_500.100' => 'Erro interno do servidor - Erro do ASP',
    'error_doc__code_501' => 'Não está implementado',
    'error_doc__code_502' => 'Bad gateway',
    'error_doc__code_503' => 'O serviço está temporariamente indisponível',

    'mimetype__extension' => 'Extensão',
    'mimetype__content' => 'Conteúdo',
    'mimetypeslist__title' => 'Tipos MIME',
    'mimetypes__title' => 'Tipos MIME',
    'mimetypes__select_to_remove' => 'Selecione os tipos MIME que quer remover.',
    'mimetypes__select_for_remove' => "Seleccione os tipos de MIME a serem removidos.",
    'mimetypes_remove__title' => 'Remova o tipo de MIME',
    'mimetype__legend' => 'Tipo MIME',
    'mimetype_edit__title' => 'Editar o tipo MIME',
    'mimetype_edit__already_exists' => 'Já está definido para esta extensão o tipo MIME.',
    'mimetype_edit__not_exists' => 'O tipo MIME não existe.',
    'mimetype__content_type_other' => 'Personalizado...',

    'b_webdir_protection_enable' => 'Fazer um URL que corresponda ao diretório protegido por palavra-passe.',
    'b_webdir_protection_disable' => 'Fazer um URL que corresponda ao diretório acessível para todos.',
    'b_webdir_protection_disabled' => 'A proteção do diretório virtual está desligada.',

    'b_pd_usr_create' => 'Clique para criar este utilizador do URL protegido.',
    'php__changeversion_title' => "Seleccione a Versão do PHP",
    'php__group_php_version' => "Versão do PHP",

    'virtualdir__name' => 'Nome',
    'virtualdir__path' => 'Caminho',
    'virtualdir__read' => 'Permissão de Leitura',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Permissão de escrita',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Acesso à fonte do Script',
    'virtualdir__source_short' => 'F',
    'virtualdir__browse' => 'Browsing do Directório',
    'virtualdir__browse_short' => 'C',
    'virtualdir__script_execute' => 'Permissões de Execução',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Log das visitas',
    'virtualdir__app_create' => 'Criar aplicação',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Ativa a autenticação anónima.',
    'virtualdir__auth_windows' => 'Ativa a autenticação pelo Windows.',
    'virtualdir__auth_not_enabled' => 'A autenticação anónima ou pelo Windows deve estar ativada.',
    'virtualdir__require_ssl' => 'Exigir SSL/TLS',
    'virtualdir__enable_default_doc' => 'Utilizar os documentos predefinidos',
    'virtualdir__default_doc' => 'Ordem de procura dos documentos predefinida',
    'virtualdir__enable_parent_paths' => 'Permitir a utilização de caminhos parentais',
    'virtualdir__execute_in_mta' => 'Permitir correr a aplicação em modo MTA (multi-threaded apartment)',
    'virtualdir_create__title' => 'Criar directório virtual em %1',
    'virtualdir_edit__title' => 'Propriedades do directório virtual %1',
    'virtualdir_edit__legend' => 'Directório Virtual',
    'virtualdir_edit__application_legend' => 'Configurações da Aplicação',
    'virtualdir_edit__security_legend' => 'Segurança do Directório',
    'virtualdir_edit__documents_legend' => 'Documentos',
    'virtualdir_edit__list_legend' => 'Directórios virtuais aninhados(nested)',
    'virtualdir_error__path_not_in__' => 'O caminho especificado não è válido',
    'virtualdir_error__already_exists' => 'Já existe um diretório com esse nome.',
    'virtualdir_root' => 'Directórios Virtuais',
    'virtualdir_root__title' => 'Directórios Virtuais',
    'virtualdir_root__list_legend' => 'Directórios Virtuais',
    'virtualdir_se__none' => 'Nenhum',
    'virtualdir_se__script' => 'Só Scripts',
    'virtualdir_se__script_execute' => 'Scripts e Executáveis',
    'virtualdirs__title' => 'Directórios Virtuais',
    'virtualdirs__path_not_exists' => 'Caminho Inválido.',
    'virtualdirs__select_for_remove' => "Seleccione os directórios virtuais a serem removidos.",
    'virtualdirs_remove__title' => 'Remover os directórios virtuais',
    'virtualdirs_phys_dir_exist' => 'Já existe um diretório físico com esse nome. Se continuar, este ficará inacessível. Deseja continuar?',
    'virtualdir_auto_create_dir' => "Criar directório físico com o mesmo nome do directório virtual",

    'asp_max_default_text' => 'Definido pelo directório pai (%1 KB)',
    'asp_max_default_text_site' => 'Definido pelo IIS (%1 KB)',
    'asp_max_buffer_text' =>'Tamanho máximo da buffer de ASP (KB)',
    'asp_max_body_text' => 'Tamanho máximo do corpo de um pedido em ASP (KB)',
    'asp_buffers_legend' =>'Definições de ASP',

    'asp_debug_default_text' =>'Definido pelo directório pai',
    'asp_debug_default_text_site' =>'Definido pelo IIS',
    'asp_client_debug_text' =>'Permitir o debugging do script pelo lado do cliente de ASP',
    'asp_server_debug_text' =>'Permitir o debugging do script pelo lado do servidor de ASP',

    'webdirs__list_with_broken_dirs' => "Existem diretórios virtuais ligados a pastas físicas inexistentes.",
    'webdirs__vdir_physical_path_not_exist' => "O diretório virtual está ligado a uma pasta física inexistente.",
    'webdirs__physical_path_not_exist' => "O caminho especificado não existe.",

    'filemanager__new_dir_title' => 'Criar Directório',
    'php__configuration_title' => "Configuração do PHP",

    'permissions__title' => 'Configurar as Permissões de Acesso',
    'permissions__title_advanced' => 'A configurar as Permissões de Acesso Avançado',
    'permissions__inherit_from_parent' => 'Permitir permissões hereditárias do principal para propagar a este objeto e todos os objetos filhos. Incluir estes com as entradas claramente definidas aqui.',
    'permissions__replace_on_children' => 'Substituir entradas de permissão em objetos filho pelas entradas exibidas aqui.',
    'permissions__group_or_user_name' => 'Grupo ou nomes de utilizadores',
    'permissions__Permissions_for' => 'Permissões para',
    'permissions__allow' => 'Permitir',
    'permissions__deny' => 'Negar',
    'permissions__FullControl' => 'Controlo Total',
    'permissions__Modify' => 'Modifica',
    'permissions__ReadAndExecute' => 'Ler & Executar',
    'permissions__ListFolderContents' => 'Exibir o Conteúdo da Pasta',
    'permissions__Read' => 'Ler',
    'permissions__Write' => 'Escrita',
    'permissions__ReadControl' => 'Controlo de leitura',
    'permissions__WriteControl' => 'Controlo de Escrita',
    'permissions__ExecuteControl' => 'Executar Controlo',
    'permissions__TraverseFolderOrExecuteFile' => 'Atravessar Pasta / Executar Ficheiro',
    'permissions__ListFolderOrRead' => 'Exibir Pasta / Ler Dados',
    'permissions__CreateFilesOrWrite' => 'Criar Ficheiros / Escrever Dados',
    'permissions__CreateFoldersOrAppend' => 'Criar Pastas / Adicionar Dados',
    'permissions__DeleteSubfoldersandFiles' => 'Eliminar Sub-pastas e Ficheiros',
    'permissions__Delete' => 'Eliminar',
    'permissions__ChangePermissions' => 'Mudar as permissões',
    'permissions__TakeOwnership' => 'Assume a Propriedade',
    'permissions__inherited_from' => 'Herdado de',
    'permissions__not_inherited' => '<não foi herdado>',
    'permissions__apply_to' => 'Aplicar a',
    'permissions__apply_onto' => 'Aplicar a:',
    'permissions__apply_onto1' => 'Só nesta pasta',
    'permissions__apply_onto2' => 'Só sub-pasta',
    'permissions__apply_onto3' => 'Esta pasta e sub-pastas',
    'permissions__apply_onto4' => 'Só ficheiros',
    'permissions__apply_onto5' => 'Esta pasta e ficheiros',
    'permissions__apply_onto6' => 'Só sub-pasta e ficheiros',
    'permissions__apply_onto7' => 'Esta pasta, sub-pastas, e ficheiros',

    'filemanager__not_allowed_dir' => "Não tem permissão para alterar as permissões da pasta.",

    'filemanager__allow' => "Permita",
    'filemanager__deny' => "Negar",
    'filemanager__user_domusr' => 'Administrador de página web',
    'filemanager__user_webusr' => 'Utilizador Web',
    'filemanager__user_admins' => 'Administrador Local',
    'filemanager__user_system' => 'Utilizador de sistema',
    'filemanager__user_aspnet' => 'Utilizador de ASP.NET',
    'filemanager__user_poolusr' => 'Utilizador do repositório de Aplicações',
    'filemanager__user_sysaccount' => 'Utilizador adicional de sistema',

    'bt_permissions_advanced' => 'Avançado',
    'b_permissions_advanced' => 'Clique para visualizar e definir permissões especiais.',

    'b_hotlinkprotection' => 'Configurar a proteção hotlink para a página web.',
    'b_hotlinkprotection_on' => 'Ativar a proteção hotlink do conteúdo da página web.',
    'b_hotlinkprotection_off' => 'Desativar a proteção hotlink do conteúdo da página web.',

    'bt_hotlinkprotection' => 'Protecção de Hotlink',
    'hotlinkprotection__title' =>'Protecção de Hotlink',
    'hotlinkprotection__friend_domains' => 'Endereços das páginas web amigáveis',
    'hotlinkprotection__extensions' => 'Extensões de arquivos protegidos',

    'hotlinkprotection_invalid_friend_domains' => 'Nomes inválidos para domínios amigáveis.',
    'hotlinkprotection_invalid_extensions' => 'As extensões de ficheiros contêm carateres indevidos.',

    'i_domain_alias_status_on' => 'O nome alternativo de domínio está activado.',
    'i_domain_alias_status_off' => 'O nome alternativo de domínio está desactivado.',
    'i_domain_alias_status_with_parent' => 'O nome alternativo de domínio está desactivado porque o domínio está desligado.',
    'i_domain_alias_turn_off' => 'Clique para desactivar.',
    'i_domain_alias_turn_on' => 'Clique para activar',
    'i_domain_alias_mail_on' => 'O serviço de correio está activado para este nome alternativo de domínio.',
    'i_domain_alias_mail_off' => 'O serviço de correio está desactivado para este nome alternativo de domínio.',
    'i_domain_alias_mail_with_parent' => 'O serviço de correio está desactivado porque o nome alternativo de domínio está desligado.',
    'i_domain_alias_web_on' => 'O serviço Web está activado para o nome alternativo do domínio.',
    'i_domain_alias_web_off' => 'O serviço Web está desactivado para o nome alternativo do domínio.',
    'i_domain_alias_web_with_parent' => 'O serviço Web está desactivado porque o nome alternativo do domínio está desligado.',
    'i_domain_alias_dns_on' => 'O serviço de pseudónimos DNS está ativado para este pseudónimo de domínio.',
    'i_domain_alias_dns_off' => 'O serviço de pseudónimos DNS está desativado para este pseudónimo de domínio.',
    'i_domain_alias_dns_with_parent' => 'A sincronização do DNS com o domínio principal está desativada porque o nome alternativo de domínio está desligado.',
    'i_domain_alias_seoRedirect_on' => 'O redirecionamento com o código HTTP 301 está ativado para este pseudónimo de domínio.',
    'i_domain_alias_seoRedirect_off' => 'O redirecionamento com o código HTTP 301 está desativado para este pseudónimo de domínio.',
    'i_domain_alias_seoRedirect_with_parent' => 'O redirecionamento com o código HTTP 301 está desativado porque o pseudónimo do domínio está desativado.',

    'domain_alias__control_title' => 'Nome alternativo de domínio %1',
    'domain_alias__control_info_legend' => 'Informações',
    'domain_alias__control_status_title' => 'E',
    'domain_alias__control_name_title' => 'Nome do serviço',
    'domain_alias__control_details_title' => 'Detalhes',

    'domain_alias__invalid_values' => 'O nome de domínio especificado é inválido. Nomes de domínio podem conter letras, algarismos e hifens. Cada parte do nome de domínio entre dois pontos não pode ser maior que 63 símbolos.',
    'domain_alias__domain_already_exists' => "Nome incorreto do nome alternativo de domínio %1. O domínio %1 já existe.",
    'domain_alias__www_prefix_domain_already_exists' => "Nome incorreto do nome alternativo de domínio www.%1. Este nome alternativo já foi criado para o domínio %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nome incorreto do webmail do nome alternativo de domínio %1. Este nome alternativo já foi criado para o domínio %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nome incorreto das listas de nome alternativo de domínio %1. Este nome alternativo já foi criado para o domínio %1.',
    'domain_alias__dns_record_already_exists' => 'Impossível configurar o nome alternativo de domínio %1 porque já existe um registo DNS a apontar ao host %1.',
    'domain_alias__domain_alias_already_exists' => "Já existe um nome alternativo de domínio com esse nome.",
    'domain_aliases__mail_server_not_support_aliases' => 'O servidor de correio não permite a funcionalidade de nomes alternativos de domínio. Os nomes alternativos de domínio podem não funcionar correctamente.',
    'domain_alias__restrict_domain_creation' => 'O nome especificado para o nome alternativo de domínio é proibido por uma política do servidor. Se este nome alternativo de domínio lhe pertencer, entre em contacto com seu fornecedor de alojamento.',
    'domain_alias__restrict_creation_with_www' => 'Por favor introduza um nome de domínio sem o prefixo \'www\'\\. O prefixo www para o domínio será adicionado automaticamente à configuração do servidor web.',
    'domain_unable_to_set_name' => 'Nome incorreto %1.',

    'domain_alias__domain_service_dns_disabled' => 'Este domínio é servido por outro servidor DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Este servidor DNS é agora o servidor de nomes master para esta zona de DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Este servidor DNS é agora o servidor de nomes escravo para esta zona de DNS.',
    'domain_alias__domain_service_mail_enabled' => 'O serviço de correio está ligado no domínio.',
    'domain_alias__domain_service_mail_disabled' => 'O serviço de correio está desligado no domínio.',
    'domain_alias__domain_service_mail_mx' => '%1 é utilizado como o servidor de correio.',

    'domain_alias__service_seoRedirect_hint' => 'Ao abrir a URL do nome alternativo, os visitantes serão redirecionados para a URL do domínio primário. O Plesk utiliza o redirecionamento HTTP 301 compatível com mecanismos de pesquisa, o que significa que a classificação do mecanismo de pesquisa não será dividida entre as URLs.',

    'bt_task_run_now' => 'Executar Agora',
    'ftp__read_perm' => "Permissão de ler",
    'ftp__write_perm' => "Permissão de escrita",

    'filemanager__upload_backup_file_hint' => 'Aqui, pode carregar ficheiros de cópias de segurança para o armazenamento Plesk. O tamanho máximo do ficheiro é limitado a dois gigabytes.',

    'additional_key__used' => 'ativado',

    '__default_for_mssql' => 'predefinição para o MS SQL',

    '__login_does_not_pass_validation' => "O nome de utilizador é inválido. Certifique-se que ele preenche os seguintes requisitos: %1",
    '__login_allowed_symbols' => 'São permitidos apenas carateres alfanuméricos, incluindo pontos, traços e sublinhados. O primeiro caratere deve ser alfanumérico.',

    'restart__nginx' => 'Servidor de Proxy Reverso (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Gostaria de receber informações gerais e anúncios sobre produtos Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Gostaria de receber informação relativa a segurança e outros avisos técnicos da Plesk.",

    'server_preferences__webdeploy_include_password' => 'Incluir a palavra-passe de utilizador no ficheiro com as configurações de publicação pelo Web Deploy',

    '__login_status_inactive' => 'A sua conta está inativa. Contacte o administrador do Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Voltar à página de Ferramentas & Configurações. A migração vai continuar em segundo plano.',

    'ui__admin-alias-info__description' => "Editar as informações de contacto da conta adicional do administrador.",
    'ui__admin-alias-info__short-title' => "Informaçaõ de contacto",
    'ui__admin-alias-info__title' => "Informações Adicionais da Conta do Administrador",
    'ui__admin-alias-password__description' => "Alterar a palavra-passe adicional do administrador.",

    'ui__admin-alias-password__short-title' => "Alterar Senha",
    'ui__admin-alias-password__title' => "Palavra-passe adicional de administrador",
    'ui__admin-alias__description' => "Ver e alterar as informações adicionais de contas do administrador.",

    'chk_js__warning_about_login_syntax' => "Pode utilizar símbolos minúsculos alfanuméricos, traços e sublinhados no nome de utilizador. O nome de utilizador deve começar com um símbolo alfanumérico. A palavra-passe não deve conter o nome de utilizador e aspas.",
    'chk_js__warning_about_ftp_login_syntax' => "Pode utilizar símbolos alfanuméricos, traços e sublinhados no nome de utilizador.",
    'chk_js__warning_about_login_syntax_win' => "Pode utilizar símbolos alfanuméricos minúsculos, traços, ponto e sublinhado no nome de utilizador. O nome de utilizador deve começar por um símbolo alfabético ou um número. A palavra-passe não deve conter o nome de utilizador e aspas.",
    'chk_js__warning_about_passwd_syntax' => "Não utilize aspas, espaço e carateres do alfabeto nacional na sua palavra-passe.\nO comprimento da palavra-passe deve ser entre %1 e %2 carateres, e não deverá conter o nome do utilizador.",
    'chk_js__warning_about_plesk_login_syntax' => "Pode utilizar carateres minúsculos alfanuméricos, ponto, traço e sublinhados no nome de utilizador.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Pode utilizar símbolos minúsculos alfanuméricos, traços e sublinhados no nome de utilizador. O nome de utilizador deve começar com um símbolo alfanumérico.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Não utilize aspas, espaço e carateres do alfabeto nacional na sua palavra-passe.\nO comprimento da palavra-passe deve ser entre %1 e %2 carateres, e não deverá conter o nome do utilizador.",
    'chk_js__warning_about_pam_passwd_error' => "Foi especificada uma conta de utilizador de sistema errado: %1",

    'cmd_server__admin_alias_not_found' => "Impossível encontrar a sub-conta de administrador.",

    'panel_branding__skins_already_exists' => "Observação: O tema '%1' já existe. Ele será substituído pelo tema que está a instalar atualmente.",
    'panel_branding__skins_file_exists' => "Impossível criar um diretório para o tema '%1': Já existe um ficheiro com esse nome.",

    'actionlog__login_failed' => 'falha no login',
    'actionlog__event_cp_user_login_failed' => 'Falha no login do utilizador do Plesk',
    'actionlog__api_login_failed' => 'falha no login através do API',
    'actionlog__event_cp_user_api_login_failed' => 'Falha no login do utilizador do Plesk através do API',
    'actionlog__pw_reset' => 'redefinição de palavra-passe solicitada',

    'ch_pass_by_secret__email_subject' => "Lembrete da senha do Plesk",
    'ch_pass_by_secret__email_body' => "Olá %2,\n\nPara definir uma nova palavra-passe, siga a hiperligação: %1\n\nO seu início de sessão: %3",
    'ch_pass_by_secret__message_send_error' => 'Impossível enviar o código secreto: %1',
    'ch_pass_by_secret__title' => 'Modifique a Sua Senha',
    'ch_pass_by_secret__secret' => 'Código secreto',

    'custom_button__noframe' => "Não utilizar janelas",

    'custom_button__internal_hint' => 'Especificar se a URL deve abrir numa página do Plesk ou numa nova janela do navegador.',
    'custom_button__noframe_hint' => 'Se adicionar uma tecla personalizada que leve para uma extensão do Plesk ou uma aplicação no Painel de Cliente, pode definir de que forma esta extensão/aplicação deve ser apresentada: num quadro ou como parte do GUI do Plesk.',


    'actionlog__patch' => 'Atualizar',
    'actionlog__patch_available' => 'disponível',
    'actionlog__event_patch_available' => 'Atualização disponível',
    'actionlog__patch_installed' => 'instalou',
    'actionlog__event_patch_installed' => 'Atualização instalada',

    'actionlog__extension' => 'Extensão',
    'actionlog__extension_status' => 'Estado da extensão',
    'actionlog__cloning' => 'Clonagem de servidor',
    'actionlog__cloning_complete' => 'completa',
    'actionlog__event_cloning_complete' => 'Clonagem de servidor completa',

    'actionlog__ssl_web_binding' => 'Certificado SSL/TLS no domínio',
    'actionlog__ssl_web_binding_update' => 'atribuído/não atribuído',
    'actionlog__event_ssl_web_binding_update' => 'Certificado SSL/TLS no domínio atribuído/não atribuído',

    'actionlog__ssl_web_mail_binding' => 'Certificado SSL/TLS para webmail',
    'actionlog__ssl_web_mail_binding_update' => 'atribuído/não atribuído',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certificado SSL/TLS no webmail atribuído/não atribuído',

    'actionlog__ssl_mail_binding' => 'Certificado SSL/TLS no servidor de correio',
    'actionlog__ssl_mail_binding_update' => 'atribuído/não atribuído',
    'actionlog__event_ssl_mail_binding_update' => 'Certificado SSL/TLS no servidor de correio atribuído/não atribuído',

    'actionlog__ssl_panel_binding' => 'Certificado SSL/TLS no Plesk',
    'actionlog__ssl_panel_binding_update' => 'atribuído/não atribuído',
    'actionlog__event_ssl_panel_binding_update' => 'Certificado SSL/TLS no Plesk atribuído/não atribuído',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Total por domínios',

    'chk_js__warning_about_admin_passwd_syntax' => "Gebruik geen aanhalingstekens, spaties, puntkomma of landspecifieke karakters in een wachtwoord.Het wachtwoord moet tussen de %1 en %2 tekens lang zijn en mag niet de gebruikersnaam bevatten.",

    'passwordSecurityLevelCheckFailed' => 'A sua palavra-passe não é suficientemente complexa. De acordo com a política do servidor, a força mínima da palavra-passe é %1. Para melhorar a resistência da palavra-passe, utilize números, carateres maiúsculos e minúsculos, e carateres especiais como !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Muito fraca',
    'passwordSecurityLevelCheckFailedWeak' => 'Fraca',
    'passwordSecurityLevelCheckFailedMediocre' => 'Média',
    'passwordSecurityLevelCheckFailedStrong' => 'Forte',
    'passwordSecurityLevelCheckFailedStronger' => 'Muito forte',

    'cu__php_settings__command_update_all' => "Atualizar as configurações de PHP por domínio de todos os domínios de acordo com o ficheiro php.ini do servidor.",
    'cu__php_settings__update_all_done' => "As configurações de PHP por domínio de todos os domínios foram atualizadas com sucesso.",

    'filemanager__invalid_path' => "Foi especificado um caminho inválido",

    'rdp_app__msactivex_comment' => 'Recomendamos a utilização do Internet Explorer porque o componente do Microsoft RDP ActiveX pode não funcionar com outros browsers.',

    'additional_key__descr_app' => 'Aplicações',
    'additional_keys__used_keys' => ', %1 chaves utilizadas',
    'additional_key__descr_key_mailboxes' => 'Caixas de correio',

    'ui__client/domain/dns/sync__description' => 'Aplicar alterações do modelo de DNS do servidor para a zona.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Impossível aplicar as alterações do modelo DNS para a zona porque a zona é servida por outro servidor DNS.',
    'ui__client/domain/dns/sync__short-title' => 'Aplicar Alterações do Modelo de DNS',
    'ui__client/domain/dns/sync__done' => 'As alterações do modelo de DNS foram aplicadas à zona com sucesso.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Aplicar alterações do modelo de DNS do servidor para a zona.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Impossível aplicar as alterações do modelo DNS para a zona porque a zona é servida por outro servidor DNS.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Aplicar Alterações do Modelo de DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'As alterações do modelo de DNS foram aplicadas à zona com sucesso.',
    'bt_dns_zone_sync' => 'Aplicar Alterações do Modelo de DNS',
    'b_dns_zone_sync' => 'Aplicar as alterações de modelo nas zonas DNS existentes.',
    'dns__dns_zone_sync_form' => 'Aplicar Alterações do Modelo de DNS',
    'dns__dns_zone_sync_legend' => 'Opções',
    'dns__dns_zone_sync_ways' => 'Escolha uma das seguintes',
    'dns__dns_zone_sync_way_safe' => 'Aplicar as alterações às zonas inalteradas. Se uma zona foi personalizada (novos registos adicionados ou os já existentes foram alterados), o Plesk não aplicará as alterações do modelo a essas zonas.',
    'dns__dns_zone_sync_way_forced' => 'Aplicar as alterações a todas as zonas. O Plesk aplicará as alterações no modelo a todas as zonas de DNS, incluindo as personalizadas. Note que os registos alterados pelo utilizador irão sempre permanecer intactos. Por exemplo, se o modelo contiver um novo registo que já tivesse sido adicionado por um cliente, o Plesk manterá o registo do cliente.',
    'dns__dns_default_ipv4_modified' => 'Registos com este endereço IP serão considerados como alterados pelo cliente e não serão sincronizados com o modelo de DNS do servidor.',
    'dns__dns_default_ipv6_modified' => 'Registos com este endereço IP serão considerados como alterados pelo cliente e não serão sincronizados com o modelo de DNS do servidor.',

    'dns__view_dns_record_master_title' => 'A visualizar os Registos de Recursos',
    'dns__view_dns_record_off_title' => 'A visualizar os Registos de Servidor de Nome',
    'dns__view_dns_record_slave_title' => 'A visualizar os Registos de Servidor DNS Primário',

    'dns_unable_to_resolve_hostname' => "Não foi possível resolver o nome do anfitrião \"%1\": %2\nCertifique-se de que o sistema operativo da resolução DNS está definido e funciona corretamente.",

    'no_database_server_available' => 'Não existem servidores de base de dados disponíveis para esta assinatura.',

    'database_server_edit_form__admin_add_hint' => "Especificar as credenciais do administrador da base de dados a ser utilizada pelo Plesk para aceder ao servidor da base de dados. Uma conta de administrador com estas credenciais deve existir no servidor da base de dados.",
    'database_server_edit_form__admin_edit_hint' => "Aqui pode alterar as credenciais que o Plesk utiliza para aceder ao servidor da base de dados. Estas credenciais devem corresponder às credenciais do administrador da base de dados. Por exemplo, depois de alterar as credenciais do administrador no servidor da base de dados, é também necessário alterá-las no Plesk.",
    'database_server_edit_form__admin_change_hint' => 'Aqui pode alterar as credenciais que o Plesk utiliza para aceder ao servidor da base de dados. Caso altere o nome de utilizador ou a senha abaixo, a conta do utilizador da base de dados com direitos de administrador será atualizada no servidor da base de dados e no Plesk.',
    'database_server_edit_form__version' => 'Versão do servidor da base de dados',
    'database_used_by_application_can_not_be_moved' => 'Não é possível mover a base de dados: Esta base de dados é utilizada por uma aplicação de sítio web.',
    'database_server_database_list__subscription' => 'Assinatura',
    'database_server_database_list__webspace' => 'Subscrição',
    'bt_assign_subscription_selected' => 'Mover para subscrição',
    'bt_cp_login' => 'Abrir no Painel de Cliente',
    'bt_cp_login_classic_mode' => 'Gerir Alojamento',
    'hint_cp_login' => 'Gerir a base de dados no Painel de Cliente do assinante.',
    'hint_cp_admin_login' => 'Gerir a base de dados.',
    'hint_cp_login_classic_mode' => 'Gerir a base de dados.',
    'database_user_update_orphaned_is_restricted' => 'É proibido atualizar contas de utilizador de base de dados órfãs. Apenas as pode apagar ou reparar.',

    'database_unable_to_get_max_filesize_default_message' => 'Impossível determinar o tamanho máximo da base de dados: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Impossível definir o tamanho máximo do ficheiro da base de dados: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Impossível determinar o tamanho máximo do ficheiro de registo da base de dados: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Impossível definir o tamanho máximo do ficheiro de registo da base de dados: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Impossível determinar o limite existente num ficheiro com tamanho \'%1\' da base de dados Microsoft SQL. É impossível determinar um novo limite.',
    'database_unable_to_set_max_filesize' => 'Impossível determinar o limite de tamanho de ficheiro da base de dados Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Impossível determinar o limite existente num ficheiro de registo com tamanho \'%1\' da base de dados Microsoft SQL. É impossível determinar um novo limite.',
    'database_unable_to_set_max_log_filesize' => 'Impossível determinar o limite de tamanho de ficheiro de registo da base de dados Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Impossível criar a base de dados Microsoft SQL \'%1\': O seu tamanho de ficheiro é superior ao tamanho máximo permitido.',
    'database_unable_to_move_because_max_filesize' => 'Impossível mover a base de dados Microsoft SQL \'%1\': O seu tamanho de ficheiro é superior ao tamanho máximo permitido: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Impossível criar a base de dados Microsoft SQL \'%1\': O seu tamanho de ficheiro de registo é superior ao tamanho máximo permitido.',
    'database_unable_to_move_because_max_log_filesize' => 'Impossível mover a base de dados Microsoft SQL \'%1\': O seu tamanho de ficheiro de registo é superior ao tamanho máximo permitido: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Impossível restaurar a base de dados Microsoft SQL \'%1\': O seu tamanho de ficheiro é superior ao tamanho máximo permitido.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Um servidor MS SQL idêntico já se encontra registado em Plesk. Especifique outro servidor MS SQL como uma sandbox.',
    'database_server__mssql_server_registered_as_sandbox' => 'Um servidor sandbox MS SQL idêntico já se encontra registado em Plesk. Especifique outro servidor MS SQL como uma sandbox.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Não foi possível ligar ao servidor através de \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'A funcionalidade %1 não é suportada pelos seguintes nós de serviço: %2. Esta funcionalidade estará desativada para todos os objetos criados nestes nós.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'A funcionalidade %1 não é suportada por este servidor. Esta funcionalidade estará desativada para todos os objetos repostos.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'O componente %1 não está instalado. Não estará disponível para os seguintes sites: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'O componente %1 não está instalado. Será substituído por %2 para os seguintes sites: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'A versão atual do Plesk não suporta nomes de utilizador com o carater ponto (.). Não serão restaurados clientes e revendedores com esses nomes de utilizador.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Impossível encontrar um ficheiro de backup com os dados para o %1 %2. Os dados para o %1 %2 não serão repostos.',

    'bu_conflict_resolver_zone_master_removed' => "Impossível restaurar o registo de DNS principal: O registo na zona secundária aponta para o endereço IP existente %1. O registo de DNS principal será removido da zona secundária.",

    'bu_conflict_resolver_not_available_scripting' => '%1 não é suportado.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 não é suportado. Não estará disponível para os seguintes sites: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'O componente %1 não está instalado.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Não estará disponível para os seguintes nós de serviço: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Não estará disponível para os seguintes objetos: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Os seguintes servidores de base de dados não estão disponíveis neste servidor: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'O ficheiro de cópia de segurança da base de dados MS SQL está armazenado em formato nativo MS SQL, que apenas pode ser restaurado para o servidor MS SQL local ou para o servidor remoto MS SQL com definições de cópia de segurança completamente configuradas. Algumas das suas bases de dados não foram restauradas porque não há servidor MS SQL apropriado registado no Plesk. Os seguintes domínios foram afetados: {{objects}}. Por favor, contacte o seu fornecedor de serviços.',

    'bu_conflict_resolver_not_available_webmail' => 'O serviço de webmail %1 não está disponível. Será substituído por %2 para os seguintes objetos: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'O serviço de webmail %1 não está disponível. Será substituído por %2 para os seguintes planos de serviço: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Bases de dados do tipo '%1' não suportam nomes de login que coincidem com nomes de base de dados. O utilizador '%2' será renomeado '%3' para a base de dados '%4' .",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'O limite de uso do espaço de disco não está definido na configuração do servidor de destino. O valor desta configuração será alterado para "Sem Limites".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'O limite do número de ligações não está definido na configuração do servidor de destino. O valor desta configuração será alterado para "Sem Limites".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'O limite de uso de tráfego não está definido na configuração do servidor de destino. O valor desta configuração será alterado para "Sem Limites".',
    'cu__pleskrestore_backup_file_extracted' => 'O ficheiro de backup foi extraído para "%1".',
    '__mod_bw_not_supported' => 'O módulo mod_bw para o servidor web Apache não é suportado devido à configuração do sistema de ficheiros. Os limites de utilização de tráfego e o número máximo de ligações não funcionarão.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Não é suportada a autorização POP3 para encaminhamento de correio, em vez disso, será utilizado POP3 antes da autorização SMTP. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Plano de serviço \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 não é suportado. Será substituído por %2 para os seguintes planos de serviço: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 não é suportado. Será substituído por %2 para os seguintes sites web: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Os seguintes objetos não foram encontrados no ficheiro de cópia de segurança: %1',
    'bu_conflict_resolver_absent_domains' => 'Alguns objetos não podem ser restaurados pois pertencem aos seguintes domínios não encontrados no Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Alguns websites não podem ser restaurados pois pertencem aos seguintes domínios principais não encontrados no Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Impossível restaurar as zonas de DNS: O serviço de DNS foi desligado nas configurações do servidor.',
    'bu_conflict_resolver_mail_not_supported' => 'Impossível restaurar as caixas de correio: O serviço de correio foi desligado nas configurações do servidor.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'O tempo limite especificado não é suportado pelo servidor de rede IIS. O valor será restaurado para %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'A ação de limite de CPU especificada não é suportada pelo servidor de rede IIS. O valor será restaurado para %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Certificado SSL/TLS %1 do servidor',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certificado SSL/TLS %2 do domínio %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certificado SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'O conteúdo dos seguintes objetos não pode ser restaurado pois os objetos não foram encontrados no Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'O conteúdo das seguintes caixas de correio não podem ser restaurados pois as caixas de correio não foram encontrados no Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'O conteúdo das seguintes listas de envio não pode ser restaurado pois as bases de dados não foram encontrados no Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'O conteúdo das seguintes bases de dados não pode ser restaurado pois as bases de dados não foram encontradas no Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'A recuperação da aplicação "%1" em "%2" falhou porque outra aplicação já está instalada em "%3". Poderá remover a aplicação instalada e tentar novamente.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'A função de resposta automática no correio não é suportado.',
    'bu_conflict_resolver_not_available_mail_content' => 'A restauração de conteúdo do correio não é suportado.',
    'bu_conflict_resolver_invalid_mail_name' => 'As seguintes caixas de correio não foram restauradas porque o subendereçamento de email está ativado e certos endereços de email contêm o símbolo "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Os seguintes utilizadores não foram restauradas porque o subendereçamento de email está ativado e certos endereços de email contêm o símbolo "%1": %2',
    'expiration_unsupported' => "O limite 'expiration' não é suportado.",

    'component_name__dbconnector' => "Ligar da Base de Dados",
    'component_name__mysqlserver' => 'Servidor MySQL',
    'component_name__troubleshooting' => 'Resolução de problemas',

    '__subscription_has_no_license_key' => 'Os recursos da assinatura são fornecidos pelo nó de serviço #%1, que não tem uma chave de licença associada.',
    '__subscription_has_expired_license_key' => 'Os recursos da assinatura são fornecidos pelo nó de serviço #%1, cuja chave de licença %2 está expirada.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Impossível guardar ficheiros de configuração',
    '__cfgmonConfigurationFileSaveErrorBody' => "Impossível guardar alguns ficheiros de configurações no host <%%host%%>: Ocorreram os seguintes erros:\n\n%%errors%%",

    'mail__allow_short_pop3_names' => "Nomes para contas de e-mail POP3/IMAP",
    'mail__allow_short_pop3_names_disabled' => "Apenas podem ser utilizados nomes completos de contas de correio POP3/IMAP.",
    'mail__allow_short_pop3_names_enabled' => "Podem ser utilizados nomes abreviados (webmaster) e completos (webmaster@domain.com) das contas de correio POP3/IMAP.",
    'mail__baddomain_exists' => "Este domínio já está na lista negra.",
    'mail__block_mail_from_doms' => "Lista Negra",
    'mail__blockers' => "Domínios bloqueados",
    'mail__blockers_remove' => "Remover domínios bloqueados",
    'mail__blocker_add' => "Adicionar domínios à lista negra.",
    'mail__closed' => "Fechado",
    'mail__crypted_passwd_match' => "Existem contas de correio que coincidem com as senhas encriptadas.",
    'mail__enable_email_subaddressing' => 'Subendereçamento de email ativado',
    'mail__enable_email_subaddressing_hint' => 'Esta opção ativa a capacidade de configurar endereços de email %%verpStyleLink%% para listas de correio',
    'mail__enable_email_subaddressing_cli_desc' => 'Esta opção ativa a capacidade de configurar endereços de email do estilo VERP para listas de correio',
    'mail__dom_in_list' => "Este domínio já está na lista negra.",
    'mail__enable_rbl' => "Ative a proteção contra spam com base nas listas negras de DNS.",
    'mail__enter_rbl_server' => "Insira a zona DNS.",
    'mail__enter_right_ip_mask' => "Insira a máscara IP entre 1 e 32",
    'mail__enter_right_ip_mask_24' => "Insira a máscara IP entre 24 e 32",
    'mail__install_rblsmtpd_program' => "Instale o software rblsmtp.",
    'mail__invalid_dom_name' => "O nome de domínio %1 é inválido.",
    'mail__invalid_pop_lock_time' => "Tempo de bloqueio de POP3 é inválido.",
    'mail__invalid_rbl_server' => "O nome da área DNS é inválido.",
    'mail__ip_and_mask' => "Endereço/máscara IP",
    'mail__ip_and_mask_exists' => "Este par de endereço IP/máscara de rede já existe.",
    'mail__lock_time' => "Tempo de bloqueio",
    'mail__general_options' => 'Opções gerais',
    'mail__relay_options' => 'Opções de relay',
    'mail__mailnames_passwd_match' => "Existem pares de conta de correio e senha coincidentes.",
    'mail__select_domains_for_remove' => "Seleccione os domínios a serem removidos.",
    'mail__max_size' => "Tamanho máximo de mensagem",
    'mail__mbox_quota' => "Quota da caixa de correio",
    'mail__min' => "min",
    'mail__total_files_size' => "Tamanho total de repositório: %1",
    'mail__filename_already_in_repository' => "Já existe um ficheiro com o mesmo nome no repositório.",
    'mail__no_white_list_mask_feature_24' => "Utilize um valor de máscara de 24 ou superior.\nO seu servidor de e-mail não suporta a configuração de máscaras. Nós podemos apenas emular configuração de máscara para valores não menores do que 24.",
    'mail__open' => "aberto",
    'mail__open_relay_warning' => "A abertura da retransmissão de correio expõe o seu servidor a spam.\n\nMantenha a configuração apenas se pretender testar temporariamente o servidor de correio ou se o servidor Plesk estiver dentro da rede interna não acessível pela Internet.\n\nManter a configuração?",
    'mail__pop3' => "POP3 antes de SMTP",
    'mail__rbl_zones' => "Zonas DNS para o serviço DNSBL",
    'mail__rbl_zones_hint' => "Separe as entradas por um ponto e virgula (semicolon), por exemplo: 'zen.spamhaus.org;dnsbl.example.net'",
    'mail__relay_from_ip' => "Lista Branca",
    'mail__relaying' => "Transmissão",
    'mail__reqr_auth' => "Autorização é requerida:",
    'mail__smtp' => "SMTP",
    'mail__unable_add_new_mail_name' => "Não foi possível adicionar a conta de correio: %1",
    'mail_server_is_not_installed' => 'O servidor de correio eletrónico (Postfix ou Qmail) não está instalado. Instale-o para continuar o trabalho.',
    'mail_server_not_available' => 'Não existem servidores de correio suportados disponíveis no nó de serviço.',
    '__not_installed' => '(não está instalado)',
    'mail__server_name_label' => 'Servidor de correio instalado',
    'mail__imap_server_name_label' => 'Servidor IMAP/POP3 instalado',
    'mail__server_change_hint' => 'Pode %%serverChangeLink%%',
    'mail__server_change_link' => 'instalar e utilizar outro servidor de correio',
    'mail__imap_server_change_link' => 'instalar e utilizar outro servidor IMAP/POP3',
    'mail__message_submission' => 'Ativar o serviço SMTP na porta 587',
    'mail__message_submission_on_all_ips' => 'Ative o serviço SMTP na porta 587 em todos os endereços IP',
    'mail__message_submission_bind_to' => 'Ligar',
    'mail__message_submission_all_ip_addresses' => 'todos os endereços IP',
    'mail__service_node_outgoing_messages_is_disabled' => 'A filtragem de spam nas mensagens de e-mail enviadas está desativada.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'O nó de serviço não suporta o limite do número de mensagens de e-mail enviadas de um domínio para o domínio %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'O nó de serviço não suporta o limite do número de mensagens de e-mail enviadas de uma caixa de correio para o domínio %1.',
    'mail__max_outgoing_messages_enable_text' => 'Ativar limitações nas mensagens de e-mail enviadas.',
    'mail__max_outgoing_messages_enable_hint' => 'Os seguintes limites são predefinidos. Podem ser substituídos em cada plano de serviço e assinatura. Os limites não funcionam em todo o servidor, mas servem como modelo para os planos e assinaturas para os quais limites personalizados não tenham sido especificados. Alterar o limite de e-mails enviados pode afetar o desempenho do servidor de correio.',
    'mail__outgoing_messages_mbox_limit_text' => 'Limite predefinido para a saída de mensagens por caixa de correio (por hora)',
    'mail__outgoing_messages_domain_limit_text' => 'Limite predefinido para a saída de mensagens por domínio (por hora)',
    'mail__outgoing_messages_subscription_limit_text' => 'Limite predefinido para a saída de mensagens por assinatura (por hora)',
    'mail__outgoing_messages_enable_sendmail_text' => 'Permitir que utilizadores e scripts usem o Sendmail',
    'mail__outgoing_messages_enable_sendmail_hint' => 'Os scripts e os utilizadores poderão enviar mensagens de e-mail (em nome do utilizador da assinatura) utilizando Sendmail mesmo que os limites para a caixa de correio e para o domínio sejam excedidos. O número máximo de mensagens que podem ser enviadas por Sendmail será definido pelo limite total para a assinatura. Esta configuração não permite que scripts utilizem o Sendmail em todo o servidor, mas funciona como a configuração padrão para os planos de serviço e assinaturas.',
    'mail__outgoing_messages_report_period_text' => 'Apresentar relatórios com base nas estatísticas para os últimos',
    'mail__max_outgoing_messages_period_P1D' => '1 dias',
    'mail__max_outgoing_messages_period_P1W' => '1 semana',
    'mail__max_outgoing_messages_period_P2W' => '2 semanas',
    'mail__max_outgoing_messages_period_P1M' => '1 mês',
    'mail__outgoing_messages_report_period_hint' => 'Os relatórios são criados e o alerta é apresentado na página inicial indicando tentativas para exceder os limites para saída de mensagens durante o período especificado.',
    'mail__outgoing_messages_notification_period_text' => 'Enviar notificação por e-mail a cada',
    'mail__max_outgoing_messages_period_PT15M' => '15 minutos',
    'mail__max_outgoing_messages_period_PT1H' => '1 hora',
    'mail__max_outgoing_messages_period_PT6H' => '6 horas',
    'mail__max_outgoing_messages_period_PT12H' => '12 horas',
    'mail__outgoing_messages_notification_period_hint' => 'As notificações disponibilizam estatísticas sobre tentativas para exceder os limites para saída de mensagens durante o período especificado.',

    'mail__outgoing_email_mode_explicit_ip_none' => 'Nenhum',
    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Especificar um endereço de pelo menos um tipo (IPv4 ou IPv6).',

    'mail__max_connections_text_courier' => 'Número máximo de ligações (IMAP, POP3, IMAP por SSL/TLS ou POP3 por SSL/TLS)',
    'mail__max_connections_text_dovecot' => 'Número máximo de ligações (IMAP, POP3, IMAP por SSL/TLS ou POP3 por SSL/TLS)',
    'mail__max_connections_hint_courier' => 'Número máximo de servidores (IMAP ou POP3) iniciados.',
    'mail__max_connections_hint_dovecot' => 'Número máximo de utilizadores de correio que podem estar ligados ao mesmo tempo.',

    'mail__max_connections_per_ip_text_courier' => 'Número máximo de ligações por endereço de IP',
    'mail__max_connections_per_ip_text_dovecot' => 'Número máximo de ligações para um utilizador por endereço de IP',
    'mail__max_connections_per_ip_hint_courier' => 'Número máximo de ligações (IMAP, POP3, IMAP por SSL/TLS ou POP3 por SSL/TLS) aceites do mesmo endereço de IP.',
    'mail__max_connections_per_ip_hint_dovecot' => 'Número máximo de ligações (IMAP, POP3, IMAP por SSL/TLS ou POP3 por SSL/TLS) permitidas para um utilizador de cada endereço de IP.',

    'mail__outgoing_email_mode' => 'Modo de saída de correio',
    'mail__outgoing_email_mode_domain_ip' => 'Enviar dos endereços IP do domínio',
    'mail__outgoing_email_mode_domain_name' => 'Envia de endereços IP e utiliza nomes de domínio na saudação SMTP',
    'mail__outgoing_email_mode_explicit_ip' => 'Enviar dos endereços IP especificados',
    'mail__outgoing_email_mode_explicit_ip_v4' => 'IPv4',
    'mail__outgoing_email_mode_explicit_ip_v6' => 'IPv6',
    'mail__outgoing_email_mode_invalid' => 'Foi especificado um modo inválido de saída de correio.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Foi especificado um endereço IPv4 inválido.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Foi especificado um endereço IPv6 inválido.',
    'mail__outgoing_email_mode_unavailable' => 'A alteração do modo de envio de mensagens não é suportada, provavelmente porque o servidor de correio do Postfix não está instalado neste servidor.',

    'mail__smtp_settings_change_hint' => 'Para permitir que o Plesk envie avisos quando o relé estiver fechado, pode %%changeLink%%',
    'mail__smtp_settings_change_link' => 'alterar definições de SMTP',

    'mail__autoresponder_attachment_not_supported' => 'O servidor de correio utilizado atualmente não suporta a gestгo de anexos de resposta automática.',

    'sfdk_server_wide_legend' => 'Proteção contra spam DKIM',
    'sfdk_server_wide_sign_text' => 'Permitir assinar o correio a sair',
    'sfdk_server_wide_verify_text' => 'Verificar correio a entrar',
    'sfdk_server_wide_verify_failed' => 'Impossível alterar as configurações para o serviço de verificação DKIM',

    'sfdk_domain__serverwide_disabled' => 'Desligado de acordo com as politicas do servidor',
    'feature__domainkeys__serverwide_disabled' => 'A proteção DKIM de spam em todo o servidor está desligada',

    'defaultcomponents__error_set_default' => 'Impossível definir %1 como %2 predefinido',
    'defaultcomponents__required_package_not_default' => 'O componente %1 necessário para este trabalho não é predefinido.',

    '__percentage' => '%',
    '__seconds' => 'Segundos',
    '__resource_remain' => 'Faltam',

    '__not_registered' => '(não está registado)',
    '__php_handler_id' => 'Versão de PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'O PHP handler "%1" não está registado. Provavelmente foi removido do servidor. Registe um processador com as mesmas propriedades e tente novamente.',
    '__php_handler_not_registered_on_domain' => 'Domínio "%1": o processador PHP "%2" não está registado. Provavelmente foi removido do servidor. Registe um processador com as mesmas propriedades e tente novamente.',
    '__php_fpm_handler' => 'Aplicação FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Impossível criar um utilizador para a caixa de correio. O utilizador com o nome de utilizador %1 já existe e tem outra caixa de correio.',
    'mailname_create_assigned_user_role_absent_error' => 'Impossível criar um utilizador para a caixa de correio. A função predefinida %1 do utilizador não existe.',

    'gphd__mime_types' => 'Tipos MIME',
    'gphd__handlers' => 'Manipuladores Apache',
    'gphd__ip_restrictions_allow' => 'Permitir acesso ao site para hosts e redes específicos (exceto os negados)',
    'gphd__ip_restrictions_deny' => 'Negar acesso ao site para hosts e redes específicos',
    'gphd__directory_index' => 'Ficheiros de Índice',
    'gphd__nginx_transparent_mode' => 'O modo em que o Apache manipula o conteúdo estático e dinâmico, enquanto que o nginx apenas passa requisições HTTP e respostas sem alteração.',
    'gphd__nginx_serve_static' => 'Servir ficheiros estáticos diretamente pelo nginx',
    'gphd__nginx_static_extensions' => 'Extensões de ficheiros estáticos que podem ser manipulados pelo nginx',
    'gphd__nginx_serve_php' => 'Processar ficheiros PHP pelo nginx',
    'gphd__www_root' => 'Diretório de raiz WWW',

    'eol__none' => 'não modificar',
    'eol__lf' => 'converter para estilo Unix',
    'eol__cr' => 'converter para estilo MacOS',
    'eol__crlf' => 'converter para estilo Windows',

    'ui__dns_bad_zone' => 'Zona inconsistente "%1":',
    'ui__dns_ns_has_no_address_records' => 'O registo NS "%1" não possui registos de endereço (A ou AAAA).',
    '__dns_bad_zone' => 'Zona inconsistente "%1":',
    '__dns_ns_has_no_address_records' => 'O registo NS "%1" não possui registos de endereço (A ou AAAA).',
    '__dns_ptr_is_wildcard' => 'O registo PTR "%1" é inválido: O registo aponta para um domínio genérico.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Permite acesso remoto para o usuário de base de dados \'%3\' do cliente \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Impossível permitir ligações remotas para o utilizador \'%1\' da base de dados: Impossível determinar o número da porta TCP utilizado pelo servidor Microsoft SQL \'%2\'. Estas são as possíveis razões: o protocolo TCP/IP não está ativado nas configurações de rede do servidor ou o servidor está configurado para utilizar portas TCP dinâmicas. Configure o servidor para uma porta TCP fixa e reinicie a ligação remota.',

    'command__convertResellerHasCustomer' => 'A conta de revendedor \'%1\' possui uma ou várias contas de cliente. Para converter esta conta de revendedor para uma conta de cliente, transfira primeiro estas contas de cliente para um novo proprietário ou converta-as em contas de revendedor.',
    'command__convertResellerNotReseller' => 'Apenas contas de revendedor podem ser convertidas em contas de cliente \'%1\' não é um revendedor.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Impossível sincronizar a assinatura com o plano de serviços. As seguintes configurações da assinatura entram em conflito com o plano de serviços: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'A conta \'%1\' é uma conta de revendedor. As contas de revendedor não podem ser transferidas para um novo proprietário, pois o proprietário é o administrador do servidor.',
    'moveCustomer__wrong_owner_type' => "A conta de cliente '%1' pode ser transferida apenas para um revendedor ou administrador, nunca para outro cliente.",
    'moveCustomer__customer_already_belongs_to_owner' => 'A conta de cliente \'%1\' já pertence ao utilizador selecionado.',
    'upgradeClient__user_is_admin' => 'A conta \'%1\' não pode ser convertida numa conta de revendedor por ser uma conta de administrador.',

    'mail__error_setting_max_connections_courier' => 'Impossível definir o número máximo de ligações (IMAP, POP3, IMAP por SSL/TLS ou POP3 por SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Impossível definir o número máximo de ligações (IMAP, POP3, IMAP por SSL/TLS ou POP3 por SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Impossível definir o número máximo de ligações (IMAP, POP3, IMAP por SSL/TLS ou POP3 por SSL/TLS) por endereço de IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Impossível definir o número máximo de ligações (IMAP, POP3, IMAP por SSL/TLS ou POP3 por SSL/TLS) por endereço de IP para um utilizador de correio específico: %1',
    'mail__error_no_localhost_for_maillists_in_server_white_list' => 'Para utilizar listas de correio, o localhost (127.0.0.0/8, ::1/128) deve estar na lista branca do servidor de correio eletrónico. No entanto, para utilizar o controlo de correio enviado, o localhost não deve estar na lista branca. Como compromisso, se ativar o controlo de correio enviado, pode utilizar o reencaminhamento de correio na caixa de correio em vez de listas de envio.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv4' => 'Para utilizar listas de correio, o localhost deve estar na lista branca do servidor de correio eletrónico. No entanto, para utilizar o controlo de correio enviado, o localhost não deve estar na lista branca. Como compromisso, se ativar o controlo de correio enviado, pode utilizar o reencaminhamento de correio na caixa de correio em vez de listas de envio. Note que não existem endereços localhost IPv4 (127.0.0.0/8) na lista branca atualmente, pelo que o controlo de correio de saída funcionará para endereços IPv4.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv6' => 'Para utilizar listas de correio, o localhost deve estar na lista branca do servidor de correio eletrónico. No entanto, para utilizar o controlo de correio enviado, o localhost não deve estar na lista branca. Como compromisso, se ativar o controlo de correio enviado, pode utilizar o reencaminhamento de correio na caixa de correio em vez de listas de envio. Note que não existem endereços localhost IPv6 (::1/128) na lista branca atualmente, pelo que o controlo de correio de saída funcionará para endereços IPv6.',
    'mail__outgoing_messages_with_open_relay_error' => 'Para limitar corretamente o número de mensagens enviadas, feche o relé.',
    'outgoing_messages_limit_value_invalid' => 'O valor deve situar-se entre %%MIN%% e %%MAX%%. Apenas o administrador do Plesk pode alterar esta configuração.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Os seguintes domínios usam endereços de e-mail externos para o reencaminhamento de correio, de correio enviado para endereços inexistentes. As mensagens enviadas para esses endereços não serão consideradas no Controlo de Mensagens Enviadas:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Grenser for utgående e-postmeldinger vil ikke fungere for avsendere som har IP-adresser på mailserverens hviteliste. For eksempel, hvis localhost (127.0.0.0 / 8, ::1 / 128) er på hvitelisten, vil all e-post fra den lokale serveren bli sendt, uansett begrensninger. Avsendere kan bruke enten lokale IP-adresser (nettsteder og brukerdefinerte skript som hostes på den lokale serveren) eller eksterne IP-adresser (kunder som sender e-post fra e-postklienter installert på datamaskinen eller mobile enheter). For å få grensene til å fungere for alle avsendere (både lokale og eksterne), fjern alle IP-adresser og nettverk fra hvitelisten. Merk at å fjerne localhost (127.0.0.0 / 8, ::1 / 128) fra the hvitelisten kan forstyrre driften av nettsteder og skript som sender e-post fra denne serveren. For detaljer om begrensninger for utgående e-post, se Administratorveiledningen, Beskyttelse mot utgående spam.',
    'outgoing_messages_relay_open' => 'A transmissão de correio está aberta: os limites para mensagens enviadas não funcionarão.',

    'spf_dsnignore' => 'A verificação de SPF continua quando não houver problemas na consulta de DNS',
    'spf_dnsignore_hint' => 'Primeiro, o SPF realiza uma consulta de DNS. Selecione esta opção para continuar a verificação caso a consulta de DNS falhe. Esta opção será desmarcada se não afetar o modo de verificação atual.',
    'spf_behavior_hint' => 'O SPF aplica então as regras locais e de suposição. A mensagem pode ser rejeitada dependendo do modo de verificação selecionado e do resultado da verificação.',

    'notification_aps_app_updates_available' => 'Atualizações disponíveis para as seguintes aplicações:',
    'notification_aps_app_updates_installed' => 'As atualizações foram instaladas automaticamente para as seguintes aplicações:',
    'notification_aps_app_updates_requirements' => 'Estão disponíveis atualizações para as seguintes aplicações, mas não podem ser instaladas pois as configurações de alojamento dos websites correspondentes não cumprem os requisitos de instalação:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Versão instalada: %%from%%. Versão disponível: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" em %%parentName%% (%%url%%). Versão instalada: %%from%%. Versão disponível: %%to%%."',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" em %%parentName%% (%%url%%). Versão instalada: %%from%%. Versão disponível: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Versão instalada: %%from%%. Versão disponível: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" em %%parentName%% (%%url%%). Versão instalada: %%from%%. Versão disponível: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" em %%parentName%% (%%url%%). Versão instalada: %%from%%. Versão disponível: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). A sua versão: %%from%%. Versão disponível: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" em %%parentName%% (%%url%%). A sua versão: %%from%%. Versão disponível: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" em %%parentName%% (%%url%%). A sua versão: %%from%%. Versão disponível: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Novas versão: %%to%%. Versão anterior: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Novas versão: %%to%%. Versão anterior: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nova versão: %%to%%. Versão anterior: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versão instalada: %%from%%. Versão disponível: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versão instalada: %%from%%. Versão disponível: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). A sua versão: %%from%%. Versão disponível: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'aplicação externa',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domínios',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Endereços de E-mail',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Assinaturas',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 mensagens por hora',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Ilimitado',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, o limite é %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 tentativa(s) para exceder os limites de %2 até %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 tentativa(s) para exceder os limites de %2 até ao momento',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Exclusão de Endereços IP (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'O Fail2ban não está instalado no servidor de destino.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Instale o Fail2ban. Note que isso pode demorar alguns minutos.',

    'plesk_key__no_reseller_support' => 'Não é possível gerir os revendedores devido a restrições da licença.',
    'plesk_key__no_customers_support' => 'Não é possível gerir os clientes devido a restrições da licença.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Impossível trocar para a visualização de Fornecedor de Serviço devido a restrições da licença.',
    'plesk_key__no_security_core_support' => 'As funcionalidades do Security Core (ModSecurity e Fail2Ban) não estão disponíveis devido a restrições da licença.',
    'plesk_key__outgoing-antispam' => 'Controlo de mensagens enviadas',
    'plesk_key__security-core' => 'Security Core (ModSecurity e Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Gestão de contas',
    'plesk_key__can-manage-subscriptions' => 'Gestão de assinaturas',
    'plesk_key__can-manage-customers' => 'Gestão de clientes',
    'plesk_key__can-manage-resellers' => 'Gestão de revendedores',
    'plesk_key__can-manage-custom-view' => 'Disponibilidade do modo restrito',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'A gestão de assinaturas está desligada, mas possui diversas assinaturas (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'A gestão de revendedores está desligada, mas possui diversos revendedores (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'A gestão de clientes está desligada, mas tem vários clientes (%1).',
    'plesk_key__no_subscriptions_support' => 'Não é possível gerir as assinaturas devido a restrições da licença.',
    'plesk_key__no_custom_view_support' => 'Não pode utilizar o modo restrito devido a restrições de licença.',
    'plesk_key__trial_forbidden_region' => 'Lamentamos, o Plesk não está disponível atualmente na sua região.',
    'additional_key__main_key' => 'A chave é uma chave principal: Não é possível carregar uma chave principal como chave adicional.',

    'gch__hosting_waf_rule_engine' => 'Modo da firewall para aplicações web',

    'backup__fieldset__restoration_options' => 'Opções de reposição',
    'backup__restore_options__restore' => 'Reposição',
    'backup__restore_options__domain__domain_configuration' => 'Configuração de domínio',
    'backup__restore_options__domain__virtual_host_content' => 'Conteúdo do alojamento virtual',
    'backup__restore_options__domain__mail' => 'Correio',
    'backup__restore_options__domain__databases' => 'Bases de dados',
    'backup__restore_options__client__client_configuration' => 'Configuração da conta do cliente',
    'backup__restore_options__client__domains' => "Domínios do cliente",
    'backup__restore_options__reseller__reseller_configuration' => 'Configuração da conta de revenda',
    'backup__restore_options__reseller__personal_domains' => "Domínios do revendedor",
    'backup__restore_options__reseller__clients' => "Clientes do revendedor",
    'backup__restore_options__admin__server_configuration' => 'Configurações do servidor',
    'backup__restore_options__admin__administrator_configuration' => 'Configuração da conta de administrador',
    'backup__restore_options__admin__personal_domains' => "Domínios do administrador",
    'backup__restore_options__admin__personal_clients' => "Clientes do administrador",
    'backup__restore_options__admin__resellers' => 'Revendedores',

    'badge_new' => 'Novo',
    'upgrade_php_on_subscription' => 'Oppgrader PHP på abonnementet ditt til versjon 5.3.0 eller nyere.',

    'pkey_notify__body_expiration_notification' => 'A chave de licença expirou. Algumas funcionalidades podem estar indisponíveis. Por favor, contacte o seu fornecedor de serviços.',

    'crontab__crontab_entry_exists' => "A tarefa programada já existe.",
    'crontab__crontab_entry_not_exists' => "A tarefa programada não existe.",
    'crontab__invalid_values_found' => "Valores incorretos nos parâmetros",
    'crontab__cmd_max_len' => "O comando não pode exceder %1 caracteres.",

    'domain__domain_exists' => "Existe um domínio com o prefixo 'www' e o mesmo nome: %1.%2.",
    'domain__subdomain_exists' => "Existe um subdomínio com o prefixo 'www' e o mesmo nome: %1.%2.",
    'domain__dalias_exists' => "Existe um nome alternativo de domínio com o prefixo 'www' e o mesmo nome: %1.%2.",
    'domain__record_exists' => "Existe um registo DNS a apontar para o host %1. %2.",

    'ip_addr__cannot_assign_certificate' => "Certificado '%1' não pode ser definido como padrão: chave privada em falta.",
    'ip_addr__update_dns_error' => 'Problemas ao atualizar o endereço IP em zonas DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Não é possível adicionar o endereço IP.Esta interface de rede obtém os endereços IP automaticamente.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Não é possível remover o endereço IP %1.Esta interface de rede obtém os endereços IP automaticamente.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Não é possível reparar o endereço IP %1.Esta interface de rede obtém os endereços IP automaticamente.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Não é possível alterar a interface do endereço IP %1 porque a interface de rede %2 obtém os endereços IP automaticamente.',

    'shm_lmsg__limit_for_resource_exceeded' => 'O limite da assinatura do número de %%type%% foi excedido. O limite é %%limit%% e atualmente está em utilização %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'A criação de %%type%% não é permitida para esta assinatura.',
    'shm_lmsg__resource_title__db-mysql' => 'Bases de dados MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Base de dados MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Bases de dados PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'utilizadores da base de dados',
    'shm_lmsg__resource_title__iis-application-pool' => 'Repositórios de aplicações de IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'contas FTP adicionais',

    'db_user_unable_remove_mysql_global_privileges' => 'Impossível remover os privilégios globais MySQL do utilizador da base de dados %1. Motivo: %2',
    'report__client_description' => 'Descrição',

    'db__user_role_error' => 'Foi definida uma função incorreta do utilizador da base de dados: %1. Por favor, escolha uma das seguintes funções: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Impossível definir o limite de tamanho do ficheiro para as seguintes bases de dados do servidor Microsoft SQL dado que têm um tamanho de ficheiro maior: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Impossível definir o limite de tamanho do ficheiro de registo para as seguintes bases de dados do servidor Microsoft SQL dado que têm um tamanho de ficheiro de registo maior: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Impossível definir um endereço IP público: deve existir um endereço IP privado.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Impossível definir um endereço IPv4 público para o endereço IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Impossível definir um endereço IPv6 público para o endereço IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Não foi possível configurar um endereço IP público: endereço IP inválido.',

    '__user_already_exists' => "O utilizador %1 já existe.",
    '__user_name_is_empty' => "Especifique um nome de utilizador.",

    'upgrade_php_on_domain' => 'Impossível encontrar a versão PHP 5.3.0 ou posterior em qualquer um dos seus domínios WordPress. Tente atualizar o PHP.',

    'component_name__waf' => 'Firewall para Aplicações Web',
    'component_name__vcs' => 'Sistema de Controlo de Versão',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Foi detetada uma possível tentativa de falsificação: A ligação tentou apresentar conteúdo irrelevante.',

    'php_handlers_error_no_available_instance' => 'Não é possível criar um domínio: não há processadores PHP disponíveis.',
    'domain_error_unable_to_apply_hosting_settings' => 'Não é possível aplicar as configurações de alojamento: %1',

    'plesk_not_configured' => 'O Plesk não está configurado. Vá para o painel de controle para executar a configuração pós-instalação.',
    'cmd_mail__mail_password_duplicated' => 'O par de endereço de e-mail e palavra-passe especificado já existe no servidor de correio. Especifique outro endereço de e-mail ou palavra-passe.',

    'extensionRequirementOs' => 'O sistema operativo (%1) não é suportado pelo pacote.',
    'extensionRequirementPleskMinVersion' => 'O Plesk %1 é a versão mais antiga suportada pelo pacote.',
    'extensionRequirementPleskMaxVersion' => 'As versões a partir de Plesk %1 não são suportadas pelo pacote.',
    'extensionBlacklisted' => 'A extensão %1 não é autorizada para instalação.',
    'extensionDisabled' => 'A extensão está desativada.',


    'optimization_settings__unable_set_mpm_event' => 'Não é possível definir o modo mpm_event: exige módulo do Apache PHP5 desligado, mas este módulo é utilizado por domínios.',
    'optimization_settings__unable_turn_off_php' => 'Não é possível desligar o módulo Apache PHP5: é utilizado por domínios.',

    'hst_def__fp_admin_login' =>  'Utilizador FTP',
    'hst_def__fp_admin_passwd' =>  'Palavra-passe FTP',

    'database_user_orphaned_old_password_wrong' => "Não é possível reparar o utilizador órfão '%1': a palavra-passe está incorreta.",
    'cannot_load_partner_central_property_key_no_exist' => "Não é possível recuperar as propriedades personalizadas: a chave de licença não existe.",
    'extensionScriptFailure' => "A execução de %1 falhou com a mensagem seguinte:\n%3",
    '__ssl_redirect' => "Redirecionamento permanente seguro para SEO 301 de HTTP para HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'A gestão DKIM não é suportada.',
    'mail__dmarc_not_supported' => 'A gestão DMARC não é suportada.',
    'mail__relay_white_list_not_supported' => 'A gestão de passagem à lista branca  não é suportada.',
    'mail__black_list_not_supported' => 'A gestão de lista negra não é suportada.',
    'mail__autoresponder_not_supported' => 'A gestão de resposta automática não é suportada.',
    'defaultcomponents__not_supported_version' => '(versão não suportada)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'O certificado "%1" não foi encontrado.',
    'certificate__unable_setup_certificate' => 'Impossível instalar o certificado: O conteúdo da chave e certificado privado estão em falta.',
    'certificate__used_by_panel' => 'Um dos certificados que vai eliminar é utilizado como segurança do Plesk.',
    'certificate__used_by_mail_server' => 'Um dos certificados que vai eliminar é utilizado para a segurança do servidor de correio.',
    'certificate__used_by_domain_service' => 'Um dos certificados que vai eliminar é utilizado pelo serviço do domínio.',
    'mail_server__not_installed' => 'Impossível instalar o certificado para o servidor de correio porque o servidor de correio não está instalado.',

    'email_activation_mail_subject' => 'Por favor, ative a sua conta no Plesk',
    'email_activation_mail_body' => "Foi criada uma conta no servidor do Plesk %1\n\nInformações da conta:\nNome: %2\nEndereço de e-mail: %3\n\nSe esta informação estiver correta e a conta tiver sido criada para si, ative-a na hiperligação seguinte:\n\n%4\n\nAo ativar a conta, autoriza o proprietário do servidor a recolher, armazenar, processar e utilizar os seus dados pessoais (nome e e-mail) para criar e dar suporte à sua conta, de acordo com a legislação de proteção de dados aplicável ​​em vigor, como parte de um contrato.",

    'backup_transport_permission_name' => '%1 gestão',
    'backup_transport_permission_description' => 'Permite utilizar %1 para armazenar cópias de segurança.',

    'domain_move_err_target_no_hosting' => 'Impossível mover o domínio para uma assinatura sem alojamento.',
    'domain_move_err_already_in_target' => 'O domínio já pertence à assinatura de destino.',
    'domain_move_err_main_domain' => 'O domínio principal não pode ser movido.',
    'domain_move_err_subdomain_without_parent' => 'Impossível mover o subdomínio %1 sem o domínio principal %2.',
    'domain_move_err_root_exists' => 'O caminho de destino para www_root%1 já existe.',
    'domain_move_err_nested_roots' => 'Impossível mover o domínio porque partilha a raiz do documento com outro domínio: %1.',
    'domain_move_err_no_mail_service' => 'Impossível mover o domínio porque o serviço de correio está desativado na assinatura de destino.',
    'domain_move_err_app' => "A aplicação instalada em %1 não foi movida para a assinatura '%2': %3",
    'domain_move_database_used_by_app' => "A base de dados '%1' em %2 é utilizada pela aplicação movida. Para reatribuir a base de dados a '%3', execute `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "A assinatura de destino '%1' foi bloqueada para sincronização.",
    'domain_move_filesharing_disabled' => 'A partilha de ficheiros foi desativada.',
    'domain_move_website_preview_disabled' => 'A pré-visualização do website foi desativada.',
    'domain_move_additional_webserver_settings' => "Analise as diretivas do servidor de rede do domínio adicional para prevenir configurações interrompidas.",
    'domain_move_no_permission' => "%1 não é permitido para a assinatura '%2'.",
    'domain_move_no_access' => "Sem acesso à assinatura '%1'.",
    'domain_split_no_create_permission' => "A criação de domínio não é permitida.",
    'domain_split_empty_login' => 'É obrigatório o nome de utilizador do sistema.',
    'domain_split_empty_password' => 'É obrigatória a palavra-passe do utilizador do sistema.',
    'domain_split_err_home_exists' => 'O domínio %1 não pode ser movido porque o seu caminho inicial de destino já existe em %2. Renomeie o domínio para o mover para uma nova assinatura.',
    'domain_split_err_no_hosting_subdomains' => 'O domínio não pode ser movido para uma nova assinatura porque o domínio não tem alojamento, mas possui subdomínios. Para mover o domínio, altere o seu valor "Tipo de alojamento" para "Alojamento de websites" (em Configurações de alojamento).',
    'domain_split_target_locked' => "A assinatura de destino '%1' está bloqueada para sincronização.",
    'domain_split_target_unsynced' => "A assinatura de destino '%1' não foi sincronizada com o plano devido a: %2.",
    'domain_merge_scheduled_backup_deactivated' => "A cópia de segurança agendada foi desativada em '%1'.",
    'domain_merge_database_error' => "A base de dados '%1' em %2 não foi movida para a assinatura '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "O FTP anónimo em '%1' foi desligado.",
    'domain_merge_smb_user_access' => "O utilizador adicional '%1' foi movido para a assinatura '%2' mas o seu acesso à assinatura foi revogado.",
    'domain_merge_scheduled_tasks' => "As tarefas agendadas foram movidas para a assinatura de destino. Rever a configuração de tarefas.",
    'domain_merge_scheduled_tasks_deactivated' => "As tarefas agendadas foram movidas para assinatura de destino e desativadas. Rever a configuração de tarefas.",
    'domain_merge_no_remove_permission' => "A remoção de assinaturas não é permitida.",
    'domain_merge_err_has_addons' => 'Impossível mover o domínio principal com os seus domínios adicionais; mova o(s) domínio(s) %1 primeiro.',
    'domain_merge_err_has_webusers' => 'Impossível mover o domínio principal com utilizadores de rede.',
    'domain_merge_err_root_exists' => 'O caminho de destino para %1 já existe.',

    'database_server_edit_used_for_psa' => 'Não é permitido atualizar o servidor da base de dados MySQL local.',
    'suggest_repair_main_suggestion_ui' => '<b>Pode corrigir este erro</b> utilizando o utilitário "plesk repair".',
    'suggest_repair_main_suggestion_cli' =>  'Pode corrigir este erro utilizando o utilitário "plesk repair".',
    'suggest_repair_repair_kit_link_title' => 'aceda a Diagnosticar e Reparar',
    'suggest_repair_using_cli_and_ui' => 'Para tal, execute o comando "plesk repair %1" através da CLI ou %2 e clique em Reparar junto a "Base de Dados Plesk"',
    'suggest_repair_using_cli' => 'Para tal, execute o comando "plesk repair %1" através da CLI',
    'verp_style_link' => 'Estilo VERP',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'O serviço DNS estava indisponível quando a cópia de segurança foi criada. No entanto, há zonas DNS ativas na cópia de segurança, que serão ativadas para os seguintes objetos: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Controlador de Recursos (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Suporte para SmarterMail remoto',
    'plesk_key__complete-backup-solution' => 'Efetuar cópia de segurança para Cloud Pro',
    'defaultcomponents__no_license' => '(não é permitida pela chave de licença)',
    'plesk_key__validation_failed' => '%1 (Código de erro: %2)',
    'promo__button_details' => 'Detalhes',
    'promo__extension_catalog_title' => 'Catálogo de Extensões',
    'promo__extension_catalog_description' => 'Descubra o novo catálogo de extensões e reforce o seu Plesk através de uma variedade de extensões potentes!',
    'promo__button_open_catalog' => 'Abrir o Catálogo',

    'backup__repository_check_login' => "Não foi possível aceder ao armazenamento: %1 Certifique-se de que introduziu as credenciais de armazenamento corretas.",
    'backup__repository_check_error_list' => "Não foi possível aceder ao armazenamento: %1 Certifique-se de que introduziu as definições de armazenamento corretas.",
    'backup__repository_check_error_mkdir' => "Não foi possível criar o diretório: %1 Verifique se tem permissões para criar pastas no armazenamento.",
    'backup__repository_check_error_upload' => "Não foi possível enviar o ficheiro para o armazenamento: %1 Verifique se tem permissões para enviar ficheiros para o armazenamento.",
    'backup__repository_check_error_download' => "Não foi possível transferir o ficheiro do armazenamento: %1 Verifique se tem permissões para enviar e transferir ficheiros do armazenamento.",
    'backup__repository_check_error_resume-upload' => "Não foi possível retomar o envio do ficheiro para o armazenamento: %1 Verifique se tem permissões para retomar envios para o armazenamento.",
    'backup__repository_check_error_resume-download' => "Não foi possível retomar a transferência do ficheiro do armazenamento: %1 Verifique se tem permissões para retomar transferências de ficheiros do armazenamento.",
    'backup__repository_check_error_enable-utf8' => "Não foi possível operar o armazenamento: %1 Verifique se o armazenamento suporta a codificação UTF8.",
    'backup__repository_check_error_rm' => "Não foi possível operar o armazenamento: %1 Verifique se tem permissões para apagar ficheiros do armazenamento.",
    'backup__repository_check_error_rmdir' => "Não foi possível operar o armazenamento: %1 Verifique se tem permissões para apagar pastas do armazenamento.",

    'backup__ftp_repository_check_login' => "%1 Pode verificá-los independentemente com o comando: %2",
    'backup__ftp_repository_check_error_list' => "%1 Pode verificá-los independentemente com o comando: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Pode verificá-lo independentemente com o comando: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Pode verificá-lo independentemente com os comandos: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Pode verificá-lo independentemente com os comandos: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Pode verificá-lo independentemente com os comandos: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Pode verificá-lo independentemente com os comandos: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Pode verificá-lo independentemente com o comando: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Pode verificá-lo independentemente com os comandos: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Pode verificá-lo independentemente com os comandos: %2 %3",

    'link_to_extension_developer_guide' => 'Como desenvolver uma extensão?',

    'sfdmarc_server_wide_legend' => 'DMARC',
    'sfdmarc_server_wide_enable_dmarc' => 'Ativar DMARC para verificar correio recebido',
    'sfdmarc_server_wide_enable_failed' => 'Não foi possível mudar as definições de DMARC. Para ativar esta opção, ative a proteção DKIM e SPF contra spam.',
    'sfdmarc_server_wide_enable_hint' => 'Esta opção está indisponível quando DKIM e SPF estão ativas para correio recebido.',
    'spf_server_wide_enable_hint' => 'Esta opção não pode ser desativada enquanto DMARC está ativa para correio recebido',
    'spf_server_wide_disable_failed' => 'Não foi possível mudar as definições para a proteção SPF contra spam. Para desativar SPF, desative DMARC para correio recebido.',
    'sfdk_server_wide_enable_hint' => 'Esta opção não pode ser desativada enquanto DMARC está ativa para correio recebido',
    'sfdk_server_wide_verify_disable_failed' => 'Não foi possível mudar as definições para a proteção DKIM contra spam. Para desativar DKIM, desative DMARC para correio recebido.',

    'ccs_not_supported' => 'A IIS Central Certificate Store não está configurada no sistema.',
    'ccs_not_enabled' => 'A gestão de IIS Central Certificate Store não está ativada no Plesk.',
    'ad_not_supported' => 'O servidor não está ligado a um domínio.',

    'component_name__appinit' => "Inicialização da Aplicação",
    'component_name__httpcompression' => 'Compressão de Conteúdo HTTP',
    'common_feature_is_not_supported' => 'Esta funcionalidade já não é suportada.',
    'common_feature_is_not_supported_in_proto' => 'Esta funcionalidade não é suportada para a versão %1 do protocolo.',
    'autoinstaller__plesk_component' => 'Componente do Plesk',
    'plesk_key__key_expired' => 'A sua chave de licença perdeu a validade. Para continuar a utilizar Plesk, deve adquirir uma %1 comercial que não perca a validade.',
    'plesk_key__key_purchase' => 'chave de licença',

    'sa_action_move' => 'Mover spam para a pasta "Junk E-mail"',

    'bu_conflict_resolver_tomcat_not_supported' => 'As aplicações Java já não são suportadas. Elas estarão indisponível para os seguintes websites: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'As versões móveis de websites alojados com UNITY Mobile já não são suportadas. Elas estarão indisponível para os seguintes websites: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'A política de utilização do servidor não permite a utilização de definições personalizadas de antivírus. Elas serão restauradas de forma incompleta para contas de email dos seguintes domínios: {{objects}}',

    'server_preferences__ip_logging' => 'Registo de IP',
    'server_preferences__disable_ip_logging' => 'Desativar o registo de IP em IIS, FTP e registos de correio',
    'server_preferences__disable_ip_logging_description' => 'Caso sejam selecionados, IIS e MailEnable já não escrevem endereços de IP nos ficheiros de registo',

    'module__not_installed' => "A extensão %1 não está instalada",

    'mail__mailbox_quota_warning_text' => 'Ativar o aviso da quota da caixa de correio',
    'mail__mailbox_quota_warning_hint' => 'Enviar uma notificação para utilizadores do correio quando a sua quota de caixa de correio ultrapassa 95%',
    'mail__mailbox_quota_warning_customization_text' => 'Personalizar o aviso da quota predefinida da caixa de correio',
    'mail__mailbox_fix-incorrectly-set-sender-text' => 'Corrigir remetente definido incorretamente no correio enviado',
    'mail__mailbox_fix-incorrectly-set-sender-hint' => 'Defina automaticamente cabeçalhos válidos de email e endereços do remetente para email enviado a partir de domínios de forma a reduzir as possibilidades de serem considerados correio eletrónico não solicitado (spam)',
    'mail__mail_autodiscovery' => 'Autodescoberta de correio',
    'mail__mail_autodiscovery_description_text' => 'Veja como funciona na %%link%%',
    'mail__mail_autodiscovery_description_text_link' => 'base de conhecimento',
    'mail__mail_autodiscovery_text' => 'Ativar a autodescoberta de correio',
    'mail__mail_autodiscovery_hint' => 'Ativar esta funcionalidade reconfigura todos os domínios que tenham a autodescoberta ativada',
    'mail__mail_autodiscovery_server_text' => 'Especificar um nome personalizado de domínio para a autodescoberta de correio',
    'mail__mail_autodiscovery_server_hint' => 'Nota: o nome do domínio deve estar seguro com uma certificado SSL/TLS válido.',
    'mail__mail_autodiscovery_server_error' => 'Especificar um nome personalizado de domínio para a autodescoberta de correio',
    'mail__mail_autodiscovery_reconfigure_dns_text' => 'Reconfigurar a autodescoberta de registos DNS',
    'mail__mail_autodiscovery_reconfigure_dns_hint' => 'Ativar esta funcionalidade reconfigura todos os domínios autodescoberta de registos DNS que tenham a autodescoberta ativada',
    'mail__error_mail_autodiscovery_enable' => 'Não é possível definir a autodescoberta de correio: %1',
    'mail__error_mail_autodiscovery_server' => 'Não é possível definir um nome personalizado de domínio para a autodescoberta de correio: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Não é possível reconfigurar a autodescoberta de domínios de registos DNS: %1',

    '__invalid_url' => 'URL "%1" não é válido',
    'actionlog__cloning_start' => 'início',
    'actionlog__event_cloning_start' => 'Servidor a clonar início',

        '__show_hide_title' => 'Minimizar/Repor',
    '__show_hide_navigation_pane' => 'Ocultar/exibir o painel de navegação',
    '__UPLOAD_ERR_FORM_SIZE' => "Tamanho do arquivo carregado excede o limite permitido",
    '__UPLOAD_ERR_INI_SIZE' => "Tamanho do arquivo carregado excede o limite permitido",
    '__UPLOAD_ERR_NO_FILE' => "Nenhum arquivo recebido",
    '__UPLOAD_ERR_OK' => "Arquivo carregado com sucesso",
    '__UPLOAD_ERR_PARTIAL' => "O Arquivo foi parcialmente carregado, por favor tente novamente",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Falta o directório temporário',
    '__UPLOAD_ERR_CANT_WRITE' => 'Falha ao escrever o ficheiro para o disco',
    '__UPLOAD_ERR_UNKNOWN' => 'Ocorreu um erro desconhecido ao carregar o ficheiro',
    '__accounts' => "Contas",
    '__access' => "Acesso",
    '__address' => "Endereço",
    '__addresses' => "Endereços",
    '__acl_records' => 'Registos ACL',
    '__admin_repository' => "Repositório do administrador",
    '__all' => 'Tudo',
    '__allowed' => "Permitido",
    '__anonftp_status' => "FTP Anónimo",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 o servidor de rede está a ser reinicializado, aguarde por favor...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Suporte para Microsoft ASP.NET",
    '__asp_win_support' => "Suporte para Microsoft ASP",
    '__attachments' => "Anexos",
    '__attachments_list' => "Anexos",
    '__author' => 'Autor',
    '__autoresp_name_already_exists' => "Resposta automática com o nome %1 já existe.",
    '__autoresponder' => "Resposta automática",
    '__autoresponders' => "Respostas automáticas",
    '__autoresponders_list' => "Respostas automáticas",
    '__autoresponder_attachment_files' => "Ficheiros anexos da resposta automática",
    '__auto_updates_list' => 'Atualizações disponíveis',
    '__avail' => "Disponível",
    '__backup_utilites' => "Utilitários de Backup",
    '__bind_status' => "Status do servidor DNS",
    '__bu_is_not_installed' => "Este serviço está temporariamente indisponível, pois as ferramentas de backup não foram instaladas.",
    '__bu_not_support_in_key' => "Capacidade de backup não é suportada pela sua chave de licença.",
    '__notifications_not_support_in_key' => 'Não são suportados avisos pela chave de licença',
    'disabled_by_key' => 'Não é suportado pela chave de licença',
    '__bytes' => "bytes",
    '__can_not_use_reserved_words' => "Não pode usar as palavras reservadas.",
    '__certificate' => "Certificado",
    '__cgi_support' => "Suporte para CGI",
    '__change_date' => "Data de modificação",
    '__choose_logo' => "Arquivo do logo",
    '__city' => "Cidade",
    '__cl_not_exist' => "Conta de cliente não existe.",
    '__client' => 'Cliente',
    '__client_card' => "Informações do cliente",
    '__client_contact_name' => "Nome de contacto do cliente",
    '__client_form' => "Formulário do cliente",
    '__client_ip_pool' => "Repositório de IP do cliente",
    '__client_limits' => "Limites da conta de cliente",
    '__client_permissions' => "Permissões do cliente",
    '__client_preferences' => "Preferências do cliente",
    '__client_status' => "Estado do cliente",
    '__client_name' => "Nome do Cliente",
    '__client_total' => "Total de clientes",
    '__client_with_login_name_already_exists' => "Já existe um utilizador com o nome de utilizador \"%1\".",
    '__client_domuser_with_login_already_exists' => "O nome de utilizador  '%1' já está em utilização pelo administrador do domínio '%1'.",
    '__clients_global_changes' => "Operações em grupo em contas de clientes",
    '__clients_list' => "Clientes",
    '__cmd_not_found' => "Comando desconhecido: %1",
    '__comments' => "Comentários",
    '__company_name' => "Nome da empresa",
    '__component_version' => "Versão do componente",
    '__allow_zone_transfer_list' => 'Lista comum de permissões de transferência de zonas ACL',
    '__component_not_installed' => "O componente %1 não foi instalado",
    '__confirm_del' => "Você precisa confirmar a remoção.",
    '__confirm_overwrite' => "Confirme a substituição.",
    '__confirm_stop' => "Tem de confirmar a interrupção do processo.",
    '__confirm_passwd' => "Confirme a senha %1",
    '__confirm_removal' => "Confirme a remoção",
    '__conhelp' => "Descrição",
    '__contact_name' => "Nome de contacto",
    '__country' => "País",
    '__countries' => 'País',
    '__country_unknown' => 'Não foi possível reconhecer o subcódigo do país.',
    '__courier-imap' => 'Servidor Courier',
    '__create_domain' => 'Criar um domínio',
    '__crypted' => 'Encriptado',
    '__cp_access' => "Acesso ao Plesk",
    '__cp_user' => "Utilizador do Plesk",
    '__create' => "Criar",
    '__create_client_template_without_template' => "Criar conta de utilizador sem modelo",
    '__create_domain_for' => "Criar um domínio para <b />%1</b>",
    '__create_domain_template_without_template' => "Criar domínio sem modelo",
    '__creation_date' => "Data de criação",
    '__crontab_unix' => "Agenda de Tarefas",
    '__crontab_win' => "Agenda de Tarefas",
    '__ct_month_jan' => 'Janeiro',
    '__ct_month_feb' => 'Fevereiro',
    '__ct_month_mar' => 'Março',
    '__ct_month_apr' => 'Abril',
    '__ct_month_may' => 'Mai.',
    '__ct_month_jun' => 'Junho',
    '__ct_month_jul' => 'Julho',
    '__ct_month_aug' => 'Agosto',
    '__ct_month_sep' => 'Setembro',
    '__ct_month_oct' => 'Outubro',
    '__ct_month_nov' => 'Novembro',
    '__ct_month_dec' => 'Dezembro',
    '__custom_button' => "Botões personalizados",
    '__custom_buttons_list' => "Botões personalizados",
    '__daily' => "Diariamente",
    '__database_not_activated' => "%1 não foi activado na página de administração do servidor.",
    '__database_not_installed' => "Base de dados %1 não está instalada.",
    '__database_not_run' => "Base de dados %1 não está rodando.",
    '__database_is_corrupt' => "A base de dados do Plesk está corrompida. Execute o Reconfigurador para o reparar.",
    '__databases' => "Bases de dados",
    '__databases_list' => "Bases de dados",
    '__database_type_not_supported_by_key' => 'Para utilizar o servidor %1, é necessário possuir suporte na sua chave de licença. Por favor, consulte o seu representante de vendas Plesk.',
    '__date_immediately' => "hoje",
    '__date_never' => "nunca",
    '__day(s)' => "Dia(s)",
    '__day0' => "Dom",
    '__day1' => "Seg",
    '__day2' => "Ter",
    '__day3' => "Qua",
    '__day4' => "Qui",
    '__day5' => "Sex",
    '__day6' => "Sáb",
    '__days' => "%1 dia(s)",
    '__db_admin_login_empty' => "Inseriu um nome de utilizador vazio, desativando assim o controlo sobre %1 na interface. Deseja continuar?",
    '__db_unable_to_unregister' => 'Não é possível remover os parâmetros da conexão à base de dados',
    '__db_db_exists' => 'Existe pelo menos uma base de dados no servidor.',
    '__db_unable_to_change_server_name' => 'O nome para o servidor não pode ser mudado.',
    '__db_unable_to_change_port' => 'A porta para o servidor não pode ser mudado.',
    '__db_already_exist' => "Base de dados %1 já existe.",
    '__db_credentials_invalid' => "As credenciais da Base de dados não são válidas.",
    '__db_engine' => "Engenho de base de dados", // indirect
    '__db_type' => "Tipo de base de dados",
    '__db_user' => "Utilizador de base de dados",
    '__db_server' => 'Servidor da base de dados',
    '__def_domain' => "Domínio predefinido",
    '__default_for_mysql' => 'predefinições do MySQL',
    '__default_for_mariadb' => 'predefinido para MariaDB',
    '__default_for_percona' => 'predefinido para Percona',
    '__default_for_postgresql' => 'predefinições do PostgreSQL',
    '__delete' => "Eliminar",
    '__demo' => "Esta função não está disponível na versão de demonstração.",
    '__directory' => "Diretório",
    '__disable_lock_screen' => 'Impeça os utilizadores de trabalhar no Plesk até que as interfaces estejam completamente carregadas',
    '__dismiss_news?' => "Tem a certeza que quer fechar completamente o bloco de notícias?\n\nNão poderá viszualizar o bloco de notícias até que estejam disponiveis mais noticias.",
    '__description' => "Descrição",
    '__disabled' => "desligado",
    '__disk_space_limit' => "Limite de espaço em disco",
    '__cgroups_cpu_usage_limit' => 'Limite de utilização de CPU',
    '__cgroups_ram_usage_limit' => 'Limite de utilização de RAM',
    '__cgroups_disk_read_usage_limit' => 'Limite de largura de banda para leitura de disco',
    '__cgroups_disk_write_usage_limit' => 'Limite de largura de banda para gravaзгo de disco',
    '__disk_usage_by' => "Espaço de disco usado por %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "O registo DNS '%1' já existe.",
    '__dns_master_should_be_remote' => "Deve ter dois servidores de nome autoritativos em hosts separados.",
    '__dns_record_not_exist' => "Registo DNS não existe.",
    '__dns_server' => "Servidor de DNS", // indirect
    '__dom_id_is_undefined' => "ID de domínio está indefinida.",
    '__dom_name' => "Nome do domínio",
    '__dom_name_is_invalid' => "Nome do domínio é invalido. Por favor, assegure-se que o nome do domínio só contem símbolos alfanuméricos, pontos e hífenes, e não tem mais do que 255 símbolos de comprimento. Cada parte do domínio entre dois pontos não pode ser maior que 63 símbolos.",
    '__dom_not_exist' => "Domínio não existe.",
    '__domain' => "Domínio",
    '__domain_' => 'Domínio %1',
    '__domain_form' => "Formulário de domínio",
    '__domain_id' => "ID do domínio",
    '__domain_is_turned_off_for_backup' => "O website %1 é temporariamente desligado para back-up ou restauração e não está disponível atualmente.",
    '__domain_limits' => "Limites do domínio",
    '__domain_name' => "Nome do domínio",
    '__mail_name_in_ASCII_form' => "Nome da conta de correio em formato ASCII",
    '__message_error' => 'Erro',
    '__message_warning' => 'Aviso',
    '__message_info' => 'Informação',
    '__domain_name_in_ASCII_form' => "nome de domínio em forma de ASCII",
    '__domain_repository' => "Repositório de domínio %1",
    '__domain_status' => "Estado de domínio",
    '__domain_dns' => 'Zona de DNS do domínio',
    '__domain_total' => "Quantidade total para a assinatura",
    '__domain_total_powerUser' => "Quantidade total para a assinatura",
    '__domain_user' => "Administrador de domínio",
    '__domains_global_changes' => "Operações de grupo em domínios",
    '__mailnames_global_changes' => "Operações de Grupo nas Contas de Correio",
    '__backup_manager' => 'Gestão de cópias de segurança',
    '__domains_list' => "Domínios",
    'domains_list__list_header' => "domínios", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "O nome de domínio começa por www, no entanto é utilizado o prefixo WWW.\nContinuar mesmo assim?",
    '__dovecot' => 'Servidor Dovecot IMAP e POP3',
    '__dsmail' => "Serviço de correio",
    '__dsmaillist' => "Serviço de lista de envio",
    '__dsr_db' => "BD",
    '__dsr_dname' => "Nome do domínio",
    '__dsr_du' => "UD",
    '__dsr_ma' => "RA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "LM",
    '__dsr_mn' => "CxMsg",
    '__dsr_pname' => "Nome de Cliente",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "UW",
    '__dumps_tot_size' => "Tamanho total dos ficheiros de cópia de segurança no armazenamento local",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "Endereço de e-mail é inválido.",
    '__enabled' => "ligado",
    '__enter_cert_text' => "Insira o texto de certificado",
    '__enter_logo_url' => "URL do logo",
    '__enter_size' => "Insira tamanho",
    '__exclusive' => "Dedicado",
    '__expiration_date' => "Data de expiração",
    '__fax' => "Fax",
    '__file' => "Ficheiro",
    '__file_is_empty' => "O ficheiro está vazio.",
    '__file_name' => "Nome do ficheiro",
    '__file_type' => 'Tipo de arquivo',
    '__filemanager' => "Gestor de Ficheiros",
    '__filepath_is_empty' => "Caminho para o arquivo está vazio",
    '__files_list' => "Ficheiros",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Definições de FTP",
    '__ftp_serv' => "Servidor de FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Primeiro deve configurar as propriedades da conta de FTP",
    '__ftp_status' => "Estado do servidor de FTP",
    '__full_day0' => "Domingo",
    '__full_day1' => "Segunda-feira",
    '__full_day2' => "Terça-feira",
    '__full_day3' => "Quarta-feira",
    '__full_day4' => "Quinta-feira",
    '__full_day5' => "Sexta-feira",
    '__full_day6' => "Sábado",
    '__full_month1' => "Janeiro",
    '__full_month10' => "Outubro",
    '__full_month11' => "Novembro",
    '__full_month12' => "Dezembro",
    '__full_month2' => "Fevereiro",
    '__full_month3' => "Março",
    '__full_month4' => "Abril",
    '__full_month5' => "Mai.",
    '__full_month6' => "Junho",
    '__full_month7' => "Julho",
    '__full_month8' => "Agosto",
    '__full_month9' => "Setembro",
    '__giga' => "G",
    '__group' => "Grupo",
    '__h' => "T",
    '__hard_disk_quota' => "Quota de disco rígido",
    '__hard_disk_quota_not_supported' => 'a quota do disco rígido não é suportada devido á configuração dos sistema de ficheiros do servidor',
    '__header_text_is_invalid' => "Título da área protegida é invalido.",
    '__help_topic_not_found' => 'O tópico de ajuda que pediu (%1) não existe.',
    '__hosting' => "Alojamento",
    '__hosting_ip_dns_ip_not_equiv' => "Nenhum dos endereços IP especificados nos registos DNS A conferem com os endereços IP usados para alojamento.",
    '__hosting_scripting' => "Suporte para script de Alojamento",
    '__hosting_setup_page_title' => "Página de configuração de alojamento físico para o domínio %1",
    '__hosting_title' => "Alojamento (%1)",
    '__hosting_type' => "Tipo de alojamento",
    '__hostname' => "Nome de anfitrião",
    '__hostname_is_empty' => "Nome do host está vazio.",
    '__hour(s)' => 'Hora(s)',
    '__hst_type_incorrect' => "Tipo de alojamento está incorrecto.",
    '__http' => "HTTP", //indirect
    '__htype' => "T",
    '__idle_time' => "Tempo de inação",
    '__iface' => "Interface",
    '__image' => "Imagem",
    '__imap_status' => "Status do servidor IMAP",
    '__in' => "Entrada",
    '__in_%' => "em %",
    '__incorrect_databases_login_pass' => "As credenciais que especificou para aceder ao PostgreSQL estão incorrectas.",
    '__incorrect_ip_or_network_address' => 'Endereço IP ou rede incorrecta.',
    '__info' => 'Informações',
    '__install' => "Instalar",
    '__install_prefix' => "Instalar prefixo",
    '__invalid_cert_id' => "ID de certificado inválida",
    '__invalid_context' => "Contexto inválido: %1",
    '__invalid_db_usr_name' => "O nome de utilizador de base de dados é inválido.",
    '__invalid_dir_name' => "O nome do directório não é válido",
    '__invalid_dom_name' => "Nome de domínio é inválido.",
    '__invalid_filename' => "Nome de arquivo inválido. Não use aspas simples e/ou combinação com \"../\".",
    '__invalid_id' => "Identificador inválido.",
    '__invalid_lines_num' => "Valor de número de linhas inapropriado, somente dígitos são permitidos.",
    '__invalid_max_letter_size' => "Tamanho máximo de mensagem inválido.",
    '__invalid_pdir_name' => "Nome de directório protegido é inválido.",
    '__invalid_restart_apache_interval' => "Intervalo de reinicio do Apache é inválido",
    '__invalid_tmpl_name' => "Nome do modelo é inválido.",
    '__invalid_value' => "O valor não é válido.",
    '__ip_addr' => "Endereço IP",
    '__ip_address_and_mask' => "Máscara do endereço IP e Sub-Rede",
    '__ip_alias__mask' => "Máscara do endereço IP e Sub-Rede",
    '__ip_addr_form' => "Formulário de endereço IP",
    '__ip_addr_is_invalid' => "Endereço IP é inválido.",
    '__ip_addr_list' => "Endereços IP",
    '__ip_address_does_not_exist' => "Endereços IP não existem.",
    '__ip_addresses' => "Endereços IP",
    '__ip_address_and_mask_hint' => 'Por exemplo, %1',
    '__is_owner' => "D",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "A sua chave de licença é apropriada para uso apenas no ambiente do Virtuozzo containers.",
    '__key_limits_exceeding' => "Esta acção excede o limite definido pela sua licença. Se você recebeu esta mensagem, deve contactar seu fornecedor ou o fabricante para estender os limites da sua licença.",
    '__kilo' => "K",
    '__keywords' => 'Palavras chave',
    '__lang_unknown' => 'Não foi possível reconhecer o idioma.',
    '__languages' => 'Idioma',
    '__learn_more' => 'Saber mais',
    '__loading' => 'A carregar...',
    '__locales' => "Pacotes de idiomas",
    '__link_url_is_invalid' => "O URL do logótipo não é válido.",
    '__lists' => "Listas de envio",
    '__literal_bytes' => "B",
    '__processing' => "Espere por favor.<br>A Carregar",
    '__locale' => "Idioma da interface",
    '__locale_is_not_defined' => "Idioma da interface não está definido.",
    '__local_server_mysql' => 'Servidor local de MySQL',
    '__local_server_postgresql' => 'Servidor local de PostgreSQL',
    '__log_files' => "Arquivos de log",
    '__log_and_statistics_files' => 'Ficheiros de log e relatórios estatísticos',
    '__config_files' => 'Ficheiros de Config',
    '__chroot_files' => 'Ambiente Chrooted',
    '__login' => "%1 Login",
    '__login1' => "Entrar",
    '__login_disabled' => "Login proibido",
    '__login_enabled' => "Login permitido",
    '__login_incorrect' => "Você inseriu uma senha ou nome de usuário incorreto.",
    '__login_name' => "%1 nome de utilizador",
    '__login_name_is_invalid' => "%1 nome de utilizador é inválido.",
    '__logon_time' => "Hora de entrada",
    '__ma' => "Nomes alternativos de e-mail",
    '__mail' => "Correio.",
    '__mail_alias_name' => "Nome alternativo de e-mail",
    '__mail_autodiscovery' => 'Autodescoberta de correio',
    '__mail_exchanger_name_is_invalid' => "Nome do servidor de troca de e-mail é inválido.",
    '__mail_groups' => "Grupos de e-mail",
    '__mail_list_engine' => "Software de listas de envio",
    '__mail_name' => "Conta de correio",
    '__mail_name_form' => "Propriedades da conta de correio",
    '__mail_names' => "Contas de correio",
    '__mail_serv' => "Servidor de Correio",
    '__mail_user' => 'Utilizador de e-mail',
    '__mailgroup' => "Grupo de e-mail",
    '__maillist' => "Lista de envio",
    '__maillists' => "Listas de envio",
    '__maillist_member' => 'Membro da lista de envio',
    '__mailname' => "Conta de correio",
    '__mailname_redir_self' => "A conta de correio não pode redirecionar o correio para si própria.",
    '__max_dom_num_reached_for_cl' => "O limite do número de domínios foi alcançado para esta conta de cliente.",
    '__max_file_size_available' => "Tamanho máximo de arquivo permitido %1",
    '__max_subdom_num_reached_for_cl' => "O limite do número de subdomínios foi alcançado para esta conta de cliente.",
    '__max_subdom_num_reached_for_dom' => "O limite do número de subdomínios foi alcançado para o domínio.",
    '__max_subdom_num_reached_for_key' => "O limite do número de subdomínios permitido pela chave de licença foi alcançado.",
    '__max_traffic_limit' => "Limite de tráfego",
    '__maximum_excl_ip_num' => "Contas de correio",
    '__mb' => "MB",
    '__mbytes' => "megabytes",
    '__mb_month' => "MB/mês",
    '__mb_sec' => "MB/Seg",
    '__gb_sec' => "GB/Seg",
    '__tb_sec' => "TB/Seg",
    '__mega' => "M",
    '__minute(s)' => 'Minuto(s)',
    '__mls_not_in_key' => "A sua chave de produto não suporta a interface multilingue.",
    '__modification_date' => "Data de modificação",
    '__module' => "Extensão",
    '__month' => "Mês",
    '__month(s)' => "Mês(es)",
    '__month1' => "Jan.",
    '__month10' => "Out",
    '__month11' => "Nov.",
    '__month12' => "Dez",
    '__month2' => "Fev",
    '__month3' => "Mar.",
    '__month4' => "Abril",
    '__month5' => "Mai.",
    '__month6' => "Junho",
    '__month7' => "Julho",
    '__month8' => "Ago",
    '__month9' => "Set",
    '__monthly' => "Mensalmente",
    '__months' => "Meses",
    '__moved_permanently' => 'Movido Permanentemente',
    '__mssql' => "Servidor Microsoft SQL",
    '__mssql__server' => "Servidor",
    'mssql__server' => "Nome do servidor Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "O nome para o servidor não pode ser mudado: existe pelo menos uma base de dados nele.",
    '__mssql_status' => "Status do servidor Microsoft SQL",
    '__multiply_login_deny' => "Impossível efetuar o login. Um outro utilizador com o mesmo nome de utilizador (%1) já está a utilizar o Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Estado do servidor de SQL",
    '__mysql_version' => "Versão SQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Estado do servidor MariaDB",
    '__mariadb_version' => "Versão MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Estado do servidor Percona",
    '__percona_version' => "Versão Percona",
    '__name' => "Nome",
    '__name_invalid' => "Nome é inválido.",
    '__nameserver' => "Nome do servidor",
    '__network' => "Rede",
    '__networks' => "Redes",
    '__no' => "Não",
    '__no_ip_address_with_properly_type_available' => "Não foi possível repor o backup dos dados porque não existe um endereço de IP adequado para o repor.",
    '__no_clients_specified' => "Não há contas de clientes especificadas.",
    '__no_comments' => "Não há comentários.",
    '__no_ip_specified' => "Sem IP especificado.",
    '__nologin' => "Proibido",
    '__none' => "Nenhum",
    '__not_configured' => "Não configurado",
    '__not_implemented_yet' => "Ainda não está implementado",
    '__not_supported_by_ftp' => "(não suportado pelo servidor FTP)",
    '__not_supported_by_mailmng' => "Não suportado pelo servidor de e-mail",
    '__notification' => "Notificação",
    '__num_displayed' => "%1 de %2 exibidos",
    '__num_is_invalid' => "Número é inválido.",
    '__object_not_found' => 'Objecto não encontrado: %1',
    '__of_all' => "% de todos",
    '__off' => "Desligado",
    '__ok' => "OK",
    '__old_passwd' => "Antiga %1 senha",
    '__on' => "Ligado",
    '__others' => "Outros",
    '__other_ip__will_be_added' => 'Outros endereços IP disponíveis (vão ser adicionados ao repositório de IP do cliente)',
    '__out' => "Saída",
    '__p' => "P",
    '__passwd' => "%1 Senha",
    '__passwd_hint' => "No mínimo 5 caracteres, caracteres nacionais não são permitidos",
    '__passwd_is_invalid' => "%1 senha é inválida.",
    '__passwd_not_match' => "As senhas não são iguais!",
    '__path' => "Caminho",
    '__perl_unix_support' => "Suporte para Perl",
    '__perl_win_support' => "Suporte para Perl",
    '__perm_denied' => "Permissão negada.",
    '__permissions' => "Autorizações",
    '__personal_name' => "Nome",
    '__pg_admin_not_activated' => "PostgreSQL não foi activado na página de administração do servidor.",
    '__pg_not_inst' => "PostgreSQL não foi instalado.",
    '__pg_not_run_or_inst' => "PostgreSQL não foi instalado ou não está rodando.",
    '__pg_not_support_in_key' => "PostgreSQL não é suportado pela chave de licença",
    '__phone' => "Telefone",
    '__phosting' => "Alojamento Físico",
    '__php_support' => "Suporte para PHP",
    '__php_run_as_isapi' => "executar como extensão de ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' ligado",
    '__php_version' => "Versão de PHP",
    '__physical' => "Alojamento Físico",
    '__plesk_stat_pdir' => "Proteger o directório '/plesk-stat/webstat/ '",
    '__plesk_stat_dir_name' => "Estatísticas de domínio",
    '__plesk_stat_protect' => "Proteger o acesso às estatísticas da web com nome de utilizador e palavra-passe do utilizador FTP",
    '__plesk_stat_protect_install' => "Acessível através de um diretório protegido por palavra-passe '/ plesk-stat/webstat/ '",
    '__plesk_stat_webstat_not_activate' => "Não selecionou um programa de estatísticas de rede para este site.",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Estado do servidor POP3",
    '__popen_error' => "Um erro ocorreu durante a chamada à função popen.",
    '__port' => 'Porta',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Status do PostgreSQL",
    '__preferences' => "Configurações",
    '__account_preferences' => "Preferências da Conta",
    '__interface_preferences_general' => 'Geral',
    '__interface_preferences_default' => 'Preferências Predefinidas do Interface',
    '__interface_preferences_admin' => "Preferências do Interface de Administrador",
    '__interface_template' => 'Modelo de personalização de interface',
    '__interface_preferences' => "Preferências de interface",
    '__proceed?' => "Você deseja continuar?",
    '__protect_dir_user' => "Utilizador de directório protegido",
    '__protect_dir_users' => "Utilizadores de directório protegido",
    '__protect_dirs' => "Directórios protegidos",
    '__provider_contact_name' => "Nome de contato do proprietário",
    '__python_unix_support' => "Suporte para Python",
    '__python_win_support' => "Suporte para Python",
    '__quota' => "Quota",
    '__r' => "R",
    '__reconfigure' => "Reconfigurar",
    '__record_type' => "Tipo de registo",
    '__release' => "Revisão",
    '__remote_db_not_supported_by_key' => 'O alojamento de bases de dados remotas não é suportado pela sua chave de licença.',
    '__remove' => "Eliminar",
    '__remove_confirmation' => "Confirmação de remoção",
    '__remove_protection' => 'Remover Proteção',
    '__report' => "Relatório",
    '__report_auto' => 'Horário da entrega',
    '__report_form' => "Formulário de Relatório",
    '__report_size_na' => "O serviço não está disponível",
    '__reports_list' => "Relatórios",
    '__requested' => "Necessário",
    '__required_fields' => "Campos obrigatórios",
    '__resp_name_invalid' => "Nome de resposta automática é inválido. Use apenas carateres alfanuméricos, pontos, sublinhado e espaços em branco.",
    '__c' => "A", // Access to panel
    '__s' => "F",
    '__server_name_is_invalid' => "O nome de Servidor não é válido.",
    '__screenshots' => 'Imagens',
    '__script_warning' => "Ao remover a capacidade de scripting deste domínio irá fazer com que todos os scripts sejam exibidos em texto claro quando forem chamados por um browser. É aconselhável que o administrador remova todos os scripts dependentes deste domínio.",
    '__sec' => "Segundos",
    '__second(s)' => "Segundo(s)",
    '__see_list_of_logged_in' => "Veja a lista dos utilizadores logados actualmente.",
    '__select_certs_to_remove' => "Seleccione certificados a serem removidos.",
    '__select_domains_to_default_host' => "Seleccione um domínio como predefinido.",
    '__select_domains_to_remove' => "Seleccione domínios a serem removidos.",
    '__type_domain_name_to_add' => "Insira o nome de domínio a ser adicionado.",
    '__select_files_to_remove' => "Seleccione arquivos a serem removidos.",
    '__select_ip' => "Atribuir um endereço IP",
    '__select_ip_to_remove' => "Seleccione um endereço IP a serem removido.",
    '__select_domain_template' => "Utilizar a configuração do modelo de domínio",
    '__select_templates_to_remove' => "Seleccione modelos a serem removidos.",
    '__server' => "Servidor",
    '__server_total' => "Total do cliente",
    '__service' => "Serviço",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Servidor da base de dados MySQL",
    '__service_description__mysql' => "Servidor da base de dados MySQL",
    '__service_title__web' => "Servidor Web",
    '__service_description__web' => "Servidor Web",
    '__service_title__smtp' => "Servidor SMTP",
    '__service_description__smtp' => "Servidor SMTP",
    '__service_title__mail' => "Servidor IMAP/POP3",
    '__service_description__mail' => "Servidor IMAP/POP3",
    '__service_title__dns' => "Servidor de DNS",
    '__service_description__dns' => "Servidor de DNS",
    '__service_title__postgresq' => "Servidor da base de dados PostgreSQL",
    '__service_description__postgresq' => "Servidor da base de dados PostgreSQL",
    '__service_title__spamassassin' => "Serviço de filtro de spam SpamAssassin",
    '__service_description__spamassassin' => "Serviço de filtro de spam SpamAssassin",
    '__services' => "Serviços",
    '__all_services' => "Todos os serviços",
    '__sessions' => "Sessões",
    'sessions__feature_ftp_session_manager_not_supported' => "As sessões de FTP não são suportadas pelo servidor de FTP actual",
    '__sessions_list' => "Sessões",
    '__set' => "Ligar",
    '__setup_logo_pref' => "Logo",
    '__shared' => "Partilhado",
    '__shell_access_warning' => "Permitir o acesso ao sistema é altamente perigoso para a segurança do sistema. Permita o acesso ao sistema só se compreender claramente, o que está a fazer, e só a utilizadores em que confia. Quer na realidade permitir o acesso ao sistema?",
    '__siteapp_not_support_in_key' => "As aplicações web não são suportadas pela chave de licença",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'A configuração desta aplicação Web foi modificada manualmente. De modo a proteger essas modificações manuais, a reconfiguração pelo Plesk não está disponível.',
    '__site_management' => "Publicação na rede", // indirect
    '__size' => "Dimensão",
    '__skeleton' => 'Modelo de alojamento virtual',
    '__skins' => 'Skin',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Status de servidor SMTP",
    '__some_fields_are_empty_or_invalid' => "Alguns campos estão vazios ou contêm valores impróprios.",
    '__spamassassin' => "Filtro de Spam",
    '__spamassassin_status' => "Status do SpamAssassin",
    '__spamd_status' => 'Status do SpamAssassin',
    '__splited_backup' => "(Cópia de Segurança multi-volume)",
    '__split_backup_file' => "Criar cópia de segurança multi-volume",
    '__split_backup_size' => "Tamanho do Volume",
    '__split_backup_less_than_500' => "Não são suportados volumes com menos de 500 megabytes",
    '__ssi' => "SSI",
    '__ssi_support' => "Suporte para SSI",
    '__ssi_with_html' => "Utilização adicional de SSI para *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Suporte SSL/TLS",
    '__same_ssl' => "Utilizar um só directório para alojar conteúdo SSL/TLS e não-SSL/TLS",
    '__same_ssl_cu' => "Conteúdo comum SSL/TLS e não SSL/TLS",
    '__state' => "Estado/Província",

    '__status__Active' => 'Ativo',
    '__status__active' => 'ativo',
    '__status__Passive' => 'Desligado',
    '__status__passive' => 'desligado',
    '__status__off' => 'desligado',
    '__status__with_parent' => 'desligado',
    '__status__backup_restore' => 'temporariamente suspenso para backup ou reposição',
    '__status__admin' => 'suspenso pelo administrador do servidor',
    '__status__resseler' => 'suspenso pelo revendedor',
    '__status__client' => 'suspenso pelo cliente',
    '__status__unknown' => 'estado desconhecido',

    '__status_of' => "%1 status",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Servidor Stunnel", // indirect
    '__subdomain' => "Sub-domínio",
    '__subdomain_name' => "Nome de subdomínio",
    '__subdomain_name_in_ASCII_form' => "Nome do sub-domínio em formato ASCII",
    '__subdomains' => "Subdomínios",
    '__domainaliases' => "Nomes alternativos de domínio",
    '__subdomains_list' => "Subdomínios",
    '__subdomains_not_support_in_key' => "Operações de sub-domínio não são suportados pela sua chave de licença",
    '__sys_user_type' => "Utilizador FTP",
    '__sys_user_type_main' => "Use a conta do utilizador de FTP do domínio principal",
    '__sys_user_type_native' => "Criar uma conta de utilizador de FTP separada para este sub-domínio",
    '__t' => "T",
    '__target_domain' => "Domínio destino",
    '__template' => "Modelo",
    '__template_not_accepted' => "Não foi possível aceitar o modelo: as seguintes limitações foram excedidas.",
    '__templates' => "Modelos",
    '__templates_list' => "Modelos",
    '__tera' => "T",
    '__title' => "Título",
    '__tools' => "Ferramentas",
    '__total' => "Total %1",
    '__total_size' => "Tamanho total",
    '__total_used' => "Total usado",
    '__traffic' => "Tráfego",
    '__traffic_by_client' => "Tráfego por cliente",
    '__traffic_by_domain' => "Tráfego por domínio",
    '__traffic_by_service' => "Tráfego por serviço",
    '__traffic_history' => "Histórico de tráfego",
    '__unable_change_locale' => "Não foi possível mudar o idioma do interface: %1",
    '__unable_create_new_dom' => "Impossível criar um domínio: %1",
    '__unable_define_dom_name' => "Impossível definir nome do domínio: %1",
    '__unable_define_necessary_properties' => "Impossível definir todas as propriedades requeridas.",
    '__unable_define_properties' => "Impossível definir propriedades: %1",
    '__unable_exec_util' => "Impossível executar utilidade: %1",
    '__unable_get_dns_a_recs' => "Impossível obter os endereços IP para a zona DNS A nesta conta de alojamento: %1",
    '__unable_get_mbox_quota' => "Impossível obter a informação sobre o limite de tamanho da caixa de correio.",
    '__unable_redirect_to_myself' => "Impossível redirecionar para si próprio.",
    '__unable_redirect_to_my_alias' => "Impossível redirecionar para o nome alternativo.",
    '__default_domain_redirect_to_myself' => "Impossível definir o domínio como o predefinido para o endereço IP:\n detectada uma redirecção para si próprio.",
    '__unable_remove_client' => "Impossível remover cliente: %1",
    '__unable_set_up_mbox_quota' => "Impossível configurar quota de caixa de correio: %1",
    '__unable_setup_pass' => "Impossível definir senha: %1",
    '__unable_to_create_new_account' => "Impossível criar um conta: %1",
    '__unable_to_define_db_size' => "Impossível definir tamanho da base de dados",
    '__unable_to_enable_short_names' => "Impossível permitir a utilização de nomes de correio curtos para contas POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Impossível recolher os dados submetidos: %1",
    '__unable_to_open_file' => "Impossível abrir o arquivo %1: %2.",
    '__unable_to_update_subdomain' => "Impossível realizar alterações no sub-domínio: %1",
    '__unable_update_cl_data' => "Impossível salvar as modificações da conta de utilizador: %1",
    '__unable_update_db_params' => "Impossível actualizar parâmetros da base de dados: %1",
    '__unable_update_dom_data' => "Impossível actualizar os dados do cliente do domínio: %1",
    '__undefined' => "indefinido",
    '__uninstall' => "Desinstalar",
    '__unknown_error' => "Erro desconhecido",
    '__unlimited_lower' => "Ilimitado",
    '__unset' => "Desligar",
    '__update' => "Atualizar",
    '__uploaded_file_is_invalid' => "Arquivo carregado é inválido: %1",
    '__url' => "URL",
    '__usage' => "Utilização em disco",
    '__user' => 'Utilizador',
    '__user_already_logged' => "Um outro utilizador com o mesmo nome de utilizador (%1) já está a utilizar o Plesk.",
    '__version' => "Versão",
    '__aps_license' => "Chave de licença",
    '__vh_type' => "Tipo de alojamento virtual",
    '__vhosts_apache_status' => "Estado do servidor de rede",
    '__wrong_charset_conversion' => 'Caracteres(charset) errados, a conversão de "%1" para "%2" não é permitida',
    '__warning_' => "Aviso!",
    '__warning_excl_ip_num' => "Endereço IP exclusivo",
    '__warning_expiration' => "Data de expiração",
    '__web_scripting' => "Web scripting", // indirect
    '__web_serv' => "Servidor Web", // indirect
    '__web_statistic' => "Estatísticas de rede", // indirect
    '__webmail' => "Correio", // +indirect
    '__webstat_not_installed' => "Webalizer não está atualmente instalado no servidor. Contacte o administrador do servidor para ter o Webalizer instalado.",
    '__webstat_support' => "Estatísticas de rede",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Quando troca o programa de estatísticas, todos os relatórios criados com esse programa anterior são eliminados e os novos relatórios são criados de acordo com a informação contida nos ficheiros de log ainda no servidor. O que significa que se configurou o sistema (em Domínios > nome de domínio > gestor de Log > Rotação de Log) para manter os ficheiros de log para o mês anterior, então as estatísticas de rede vão estar disponíveis só a partir do mês anterior. Quer trocar de programa estatístico ?",
    '__webstat_perm_denied' => 'Não tem as permissões para gerir as estatísticas de rede.',
    '__webuser' => "Utilizador Web",
    '__sysusers_list' => "Utilizadores do sistema",
    '__sysuser' => "Utilizador do sistema",
    '__weekly' => "Semanalmente",
    '__whats_new_in_version' => "Novidades no Plesk %1?",
    '__wrong_hosting_type__none' => 'Não existe alojamento físico configurado no domínio %1.',
    '__wrong_hosting_type__std_fwd' => 'O domínio %1 tem configurado o reencaminhamento padrão. Esta operação só é permitida em domínios com alojamento Web.',
    '__wrong_hosting_type__frm_fwd' => 'O domínio %1 tem configurado o reencaminhamento por janela. Esta operação só é permitida em domínios com alojamento Web.',
    '__wu' => "Utilizadores de rede",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Prefixo WWW foi alterado. Modifique o certificado SSL/TLS de acordo.",
    '__year' => "Ano",
    '__year(s)' => "Ano(s)",
    '__yes' => "Sim",
    '__you' => "Você",
    '__zip_code' => "Código Postal/CEP",
    '__form_normal' => "Normal",
    '__form_advanced' => "Avançado",

    'admin_ed__edit_administrator_info' => "Edição de perfil do administrador",
    'admin_ed__create_default_client' => "Eu gostaria de criar uma conta de cliente padrão.",
    'admin_ed__unable_update' => "Impossível actualizar informações do administrador: %1",

    'auth__update_admin_info' => "Por favor insira as informações do administrador. Estas informações são necessárias para operar %1.",
    'auth__you_not_have_perm' => "Não tem permissão para administrar este domínio.",
    'auth__key_expired_admin' => 'A sua licença Plesk caducou. Para continuar a utilizar o Plesk, renove a sua licença ou compre uma nova.',
    'auth__key_expired_admin_restricted' => 'A sua licença Plesk caducou. Contacte o seu fornecedor de serviços para continuar a utilizar o Plesk.',
    'auth__key_expired_client' => 'A licença Plesk caducou. Contacte o seu fornecedor de alojamento.',
    'autoinstaller__not_installed' => 'O componente da instalação automática não está instalado.',
    'autoinstaller__release_action' => 'Operações disponíveis',
    'autoinstaller__release_action_icon' => 'F',
    'autoinstaller__release_action_upgrade' => 'A atualizar para uma nova versão do Plesk',
    'autoinstaller__release_action_update' => 'A actualizar ou a adicionar novos componentes',
    'autoinstaller__release_action_up2date' => 'Tem uma versão actualizada',
    'autoinstaller__component_action' => 'Estado',
    'autoinstaller__component_action_icon' => 'F',
    'autoinstaller__component_action_install' => 'Não instalado',
    'autoinstaller__component_action_update' => 'Estão disponíveis actualizações',
    'autoinstaller__component_action_upgrade' => 'Está disponível uma actualização',
    'autoinstaller__component_action_up2date' => 'Tem uma versão actualizada',
    'autoinstaller__component_action_error' => 'Não estão disponíveis actualizações',
    'autoinstaller__component_serverbuildtime' => 'Ultima versão',
    'autoinstaller__component_localbuildtime' => 'A sua versão',
    'autoinstaller__component_installed_version' => 'A sua versão',
    'autoinstaller__component_available_version' => 'Ultima versão',
    'autoinstaller__component' => 'Componente',
    'autoinstaller__components' => 'Componentes',
    'autoinstaller__components_title' => '%1 Componentes',
    'autoinstaller__component_dependency_note' => 'necessário para a instalação dos componentes que seleccionou',
    'autoinstaller__install_confirm' => 'Sim, eu desejo instalar estes componentes',
    'autoinstaller__install_confirm_request' => 'Por favor seleccione a checkbox para confirmar',
    'autoinstaller__install_title' => 'Confirme a instalação dos Componentes Seleccionados',
    'autoinstaller__key_update_confirm' => 'Confirme que quer ignorar a actualização da chave e instalar a chave predefinida',
    'autoinstaller__key_update_confirm_request' => 'Por favor seleccione a checkbox para confirmar.',
    'autoinstaller__key_update_failed' => '<p> Plesk não pode atualizar a licença do produto.</p> <p> %1</p> <p> Continuar com a atualização sem ter uma licença de produto apropriada resultará na instalação de uma licença predefinida de funcionalidade limitada. Aconselha-se que os administradores adquiram primeiro a licença apropriada antes de continuar com a atualização do produto.</p>',
    'autoinstaller__email' => 'Envie notificação para',
    'autoinstaller__email_admin' => "E-mail do administrador",
    'autoinstaller__email_email' => 'lizado',
    'autoinstaller__release' => 'Nome da versão',
    'autoinstaller__releases' => 'Versões disponíveis',
    'autoinstaller__releases_title' => 'Atualizador do Plesk',
    'autoinstaller__select_components_to_install' => 'Seleccione os componentes que deseja instalar',
    'autoinstaller__status_error' => 'Erro: %1.',
    'autoinstaller__status_install_error' => 'A instalação não pôde ser começada: %1.',
    'autoinstaller__status_install_busy' => 'A instalação não pôde ser iniciada: outro procedimento de instalação está actualmente a correr.',
    'autoinstaller__status_install_ok' => 'A instalação foi iniciada. Será notificado de progresso de instalação através de e-mail (%1).',
    'autoinstaller__status_query_busy' => 'A instalação está em progresso.',
    'autoinstaller__status_query_error' => 'Foi impossível saber o estado da instalação: %1',
    'autoinstaller__status_unknown' => 'Impossível obter o estado da instalação automática.',
    'autoinstaller__status_busy' => 'A instalação automática está ocupada, espere por favor.',
    'autoinstaller__configure_title' => 'Configurações de Actualização',
    'autoinstaller__preferences_legend' => 'Configurações',
    'autoinstaller__target' => 'Directório temporário de transferência',
    'autoinstaller__target_invalid' => "Especifique o caminho absoluto(absolute path)",
    'autoinstaller__check_updates' => 'Verificar as atualizações quando o administrador entrar no Plesk',
    'autoinstaller__check_updates_warning' => 'Estão disponíveis novas <a href="%1">actualizações</a> para %2',
    'autoinstaller__source_type' => 'Tipo de fonte',
    'autoinstaller__source' => 'URL da fonte',
    'autoinstaller_source__preferences_legend' => 'Configurações',
    'autoinstaller_source__type' => 'Tipo de fonte',
    'autoinstaller_source__url_invalid' => 'Fonte inválida',
    'autoinstaller_source__url_invalid_network' => 'URL da fonte é inválido (Exemplo: http://fonte, ftp://fonte)',
    'autoinstaller_source__url' => 'URL da fonte',
    'autoinstaller__source_invalid_network' => 'Especificou um endereço de rede inválido',
    'backup__repository' => 'Localização de armazenamento dos ficheiros de cópias de segurança',
    'backup__error_notify_email' => 'Enviar o aviso de erros, caso ocorram durante a backup, para o e-mail',
    'backup__dump_info' => "Informação do Backup",
    'backup__dump_file_name_not_defined' => "O nome do arquivo de backup não está especificado",
    'backup__local_file' => 'Ficheiro local de backup',
    'backup__domain_ftp' => 'servidor de FTP remoto',
    'backup__wrong_path' => "Caminho incorrecto para armazenamento dos ficheiros de cópias de segurança: Não utilize a sequência de caracteres ../../",
    'backup__unable_to_connect_to_ftp_server' => "Não foi possível conectar ao servidor de ftp: %1",
    'backup__unable_to_read_file' => 'Impossível ler o ficheiro de backup.',
    'backup__backup_task_does_not_exist' => "Não existe uma tarefa de backup, deve criar a tarefa antes de a ligar.",
    'backup__restore_params' => "Parâmetros de restauração",
    'backup__confirmation' => "Aviso: o domínio estará inactivo durante o backup/reposição.",
    'backup__backup_method' => 'Método de backup',
    'backup__dumpfile_name' => "Nome do ficheiro de cópias de segurança",
    'backup__dumpfile_name_is_invalid' => "Nome de arquivo de backup inválido: use somente caracteres alfanuméricos, traço, ponto e sublinhado, não use nome como description.* como nome de arquivo de backup.",
    'backup__email_required' => "É necessário o seu endereço de e-mail para o manter informado sobre o progresso do procedimento de backup/reposição. Por favor especifique o seu e-mail nos detalhes da conta.",
    'backup__error_during_backup' => "Impossível criar arquivo de backup: %1",
    'backup__input_email_warning' => "Deve especificar um e-mail para a notificação ou não selecionar a caixa de verificação.",
    'backup__make_download' => "não grave o arquivo de backup no armazenamento, só o descarregue",
    'backup__make_dump' => 'crie um ficheiro de cópia de segurança e guarde-o no armazenamento local',
    'backup__makedump_to_ftp' => 'criar o ficheiro de backup e guardá-lo no servidor de FTP remoto',
    'backup__restore_ip' => "Endereço IP para reposição",
    'backup__select_dumpfile' => "Seleccione um arquivo de backup.",
    'backup__time' => "Hora do backup",
    'backup__day' => 'Dia do Backup',
    'backup__view_dump_info' => "Visualizar as informações de backup para o domínio %1",
    'backup__wrong_domain_name' => "O arquivo de backup contém os dados para o domínio %1, por isso não pode ser usado no domínio %2",
    'backup__incorrect_ftp_user_or_passwd' => "Palavra passe ou utilizador de FTP incorrecta(o). Corrija as Propriedades da Conta de FTP",
    'backup__access_denied' => "Acesso negado. Por favor, corrija as Propriedades da Conta de FTP",
    'backup__restore_from' => "Repor %1",
    'backup__domain_session_failed' => 'Não foi feito o backup ao domínio %1',
    'backup__client_session_failed' => 'Não foi feito o backup ao cliente %1',
    'backup__domain_session_restore_failed' => 'O domínio %1 não foi reposto',
    'backup__client_session_restore_failed' => 'Conta do cliente %1 não foi restaurada',
    'backup__domain_session_complete' => 'Foi feito o backup ao domínio %1',
    'backup__domain_session_backup' => 'Backup do domínio %1',
    'backup__client_session_backup' => 'Backup do cliente %1',
    'backup__domain_stop_title' => 'A cancelar o backup do domínio %1',
    'backup__client_stop_title' => 'Cancelar backup da conta do cliente %1',
    'backup__domain_restore_stop_title' => 'A cancelar a reposição do domínio %1',
    'backup__client_restore_stop_title' => 'Cancelar restauração da conta do cliente %1',
    'backup__domain_session_backup_stop' => 'Está quase a cancelar o processo de backup! O ficheiro de backup não será criado.',
    'backup__backup_stop_confirm' => 'Sim, quero interromper o processo de backup',
    'backup__restore_stop_confirm' => 'Sim, quero interromper o processo de reposição',
    'backup__domain_session_restore' => 'Reposição do domínio %1',
    'backup__domain_session_restore_stop' => 'Está perto de cancelar o processo de reposição ativo!',
    'backup__domain_backup_file_info' => 'Informação do Arquivo de Backup do Domínio',
    'backup__domain_backup_file_list' => 'arquivos de backup existentes',
    'backup__domain_backup_progress' => 'Progresso do Back-up do website %1',
    'backup__domain_restore_progress' => 'Progresso da restauração do website %1',
    'backup__domain_backup_progress_elapsed_time' => 'Duração: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Duração: %1',
    'backup__ip_map_legend' => 'Mapeamento IP',
    'backup__ip_map_list_count' => 'Endereços IP',
    'backup__domain_restore_session_complete' => 'Domínio %1 foi reposto',
    'backup__domain_restore_session_complete_message' => 'O domínio %1 foi reposto.',
    'backup__domain_backup_file_delete' => 'Os seguintes arquivos de backup serão removidos:',
    'backup__domain_backup_file_for_remove' => 'Seleccione os arquivos de backup que quer remover',
    'backup__backup_overwrite_file_confirm' => 'Confirme a substituição',
    'backup__backup_overwrite_file_confirm_text' => 'Um arquivo de backup com o nome "%1" já existe. Quer substitui-lo ?',
    'backup__backup_confirm_overwrite' => 'Confirme a substituição do ficheiro',
    'backup__backup_overwrite_legeng' => 'Substituir',
    'backup__backup_not_contain_domain' => 'O arquivo de backup não contém informação acerca do domínio %1',
    'backup__backup_not_contain_client' => 'O ficheiro de backup não contém informação acerca do cliente %1',
    'backup__backup_client_info' => "Backup das preferências e detalhes da conta de cliente.",
    'backup__client_backup_progress' => 'Progresso do Back-up da Conta do Cliente %1',
    'backup__client_session_complete' => 'Conta do cliente %1 é armazenada',
    'backup__client_backup_file_info' => 'Informação do ficheiro de Backup do Cliente',
    'backup__restore_client_info' => "Repor as preferências e detalhes da conta de cliente.",
    'backup__client_session_restore' => 'Restaurar Conta do Cliente %1',
    'backup__client_db_server_map' => 'Mapeamento dos Servidores de Base de Dados',
    'backup__domain_db_server_map' => 'Mapeamento dos Servidores de Base de Dados',
    'backup__client_restore_session_complete_message' => 'Conta do cliente %1 foi restaurada.',
    'backup__client_restore_session_complete' => 'Conta do cliente %1 foi restaurada.',
    'backup__restore_select_some' => 'Seleccione, por favor, os objectos que deseja repor.',
    'backup__client_restore_progress' => 'Progresso da restauração para a Conta do Cliente %1',
    'backup__new_backup' => 'Criar Novo Backup',
    'backup__done' => 'Executado:',
    'backup__done_domains' => '%1 domínios(s) de %2',
    'backup__done_clients' => '%1 cliente(s) de %2',
    'backup__remaining' => 'Faltam:',
    'backup__remaining_domains' => '%1 domínio(s)',
    'backup__remaining_clients' => '%1 cliente(s)',
    'backup__overall_backup_progress' => 'Progresso geral do backup',
    'backup__comment_n_a' => 'Nd.',
    'backup__command_ignore' => 'O comando "%1" é ignorado',
    'backup__no_objects' => 'não existem objectos para backup',
    'backup__cli_warning_not_enough_ip' => 'ATENÇÃO: não tem endereços IP suficientes para executar o mapeamento de IP predefinido:',
    'backup__local_repository' => "Armazenamento do Plesk",
    'backup__ftp_repository' => 'Armazenamento FTP',
    'backup__ftp_login' => 'Nome de utilizador',
    'backup__ftp_password' => 'Senha',
    'backup__ftp_directory_hint' => 'Exemplo: /minhapasta/meusbackups',
    'backup__ftp_account_settings' => 'Definições da Conta de FTP',
    'backup__ftp_account_preferences' => 'Preferências da conta de FTP',
    'backup__repository_not_exist' => 'O diretório não existe',
    'backup__repository_not_readable' => 'Não é possível ler o directório especificado',
    'backup__ftp_repository_not_configure' => 'Para usar um armazenamento de cópia de segurança FTP, <a href="%1">especifique primeiro a conta de FTP</a>',
    'backup__ftp_repository_list_not_configure' => 'Não foram especificadas as configurações da conta',
    'backup__repository_list_unable_listing' => 'Impossível obter a lista dos ficheiros',
    'backup__ftp_repository_unable_listing' => 'Impossível obter a listagem do directório "%1":',
    'backup__repository_legend' => 'Armazenamento de ficheiros de cópias de segurança',
    'backup__store_in_repository' => 'Guardar ficheiros em',
    'backup__local_repository_lable' => 'Armazenamento local',
    'backup__ftp_repository_lable' => 'Armazenamento FTP',
    'backup__ftp_repository_not_configure_hint' => '(configurações da conta não especificadas)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(a conta de FTP não foi especificada ou não é suportada)',
    'backup__ftp_directory_not_exist' => 'O directório especificado não existe',
    'backup__other_user_process_modified' => 'O processo de backup ou de migração foi parado por outro utilizador.',
    'backup__another_user_exist' => 'A operação em curso foi iniciada por outro utilizador do Plesk. Este utilizador ainda está no Plesk.',
    'backup__ftp_repository_wait' => 'Aguarde enquanto se recolhe a informação sobre o armazenamento FTP',
    'backup__ftp_write_test_failed' => 'Falha no teste de escrita para a conta de FTP %1:',
    'bt_upload_to_repository' => 'Carregar ficheiros para armazenamento local',
    'bt_new_restore' => "Restaurar",
    'bt_backup_schedule' => "Agendar Backup",
    'backup_exist_backups' => "Arquivos de backup existentes",
    'backup_dialog__page_title' => "Criação do arquivo de backup",
    'backup_dialog__please_wait' => "O processo de backup está prestes a começar. Esta operação pode levar algum tempo. Por favor, espere...",
    'backup_conf__page_title' => 'Configuração de Backup',
    'bt_accept' => "Aceitar",
    'bt_access' => "Acesso",
    'bt_action_log' => "Registo de ações",
    'bt_add' => "Adicionar",
    'bt_add_client' => "Atribuir a Utilizadores",
    'bt_database_server_add' => 'Adicionar Servidor de Base de Dados',
    'bt_add_services' => "Adicionar Serviços",
    'bt_add_address_to_acl' => 'Adicionar endereço',
    'bt_anonftp_stats' => "Estat. FTP anónimo.",
    'bt_anonymous_ftp' => "FTP Anónimo",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Anexar",
    'bt_autoinstaller' => 'Sistema de actualizações',
    'bt_auto-updates' => 'Sistema de actualizações',
    'bt_back' => "<< Anterior",
    'bt_backup' => "Cópia de segurança",
    'bt_backup_configure' => "Definições de Backup",
    'bt_buy_certs' => "Adquirir Certificados",
    'bt_blocked_domains' => 'Lista Negra',
    'bt_blocked_domain_add' => 'Adicionar um domínio',
    'bt_card' => "Cartão",
    'bt_cert' => "Certificado",
    'bt_certificates' => "Certificados",
    'bt_change_passwd' => "Alterar Palavra-passe",
    'bt_clean_log' => "Limpar Log",
    'bt_clear' => "Limpar",
    'bt_client_templates' => "Modelos de cliente",
    'bt_clients' => "Clientes",
    'bt_codepage_change' => 'Mudar Código de Página(Codepage)',
    'bt_comp_info' => "Informações de componente",
    'bt_common_acl' => 'Modelo das Restrições de Transferência',
    'bt_configure_maillists' => "Configurar o Mailman",
    'bt_configure_odbc' => "Fontes de Dados ODBC",
    'bt_configure' => 'Configurar',
    'bt_copy' => "Copiar",
    'bt_copy_move' => "Copiar/Mover",
    'bt_create' => "Criar",
    'bt_create_account' => "Criar uma conta",
    'bt_create_dir' => "Adicionar um directório",
    'bt_create_file' => "Adicionar um ficheiro",
    'bt_count_size' => "Calcular Tamanho",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Agenda de Tarefas",
    'bt_custom_button_new' => "Adicionar um botão",
    'bt_custom_buttons' => "Personalizar teclas",
    'bt_customize' => "Personalizar",
    'bt_databases' => "Bases de dados",
    'bt_database_servers' => 'Servidores de Base de Dados',
    'bt_sqlservers' => "Servidores de Base de Dados",
    'bt_db_usr_new' => "Adicionar um utilizador da base de dados",
    'bt_db_new' => "Adicionar uma base de dados",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Predefinição para o DB Web Admin",
    'bt_decline' => "Recusar",
    'bt_default' => "Predefinido",
    'bt_defaultcomponents' => "Serviços de Terceiros",
    'bt_defaults' => "Predefinições",
    'bt_delete' => "Eliminar",
    'bt_directories' => "Diretórios Protegidos",
    'bt_disable' => "Desativar",
    'bt_dns' => "Definições de DNS",
    'bt_dns_add' => "Adicionar Registo DNS",
    'bt_dnsrecord_add' => 'Adicionar Registo DNS',
    'bt_dns_soa' => "Modelo Registos SOA",
    'bt_dns_zone_settings_template' => "Modelo das Definições da Zona",
    'bt_dns_preferences' => "Recursividade de DNS",
    'bt_do_backup' => "Efetuar cópia de segurança",
    'bt_do_restore' => "Restaurar",
    'bt_do_upload' => "Carregar",
    'bt_domain_aliases' => "Nomes alternativos de Domínio",
    'bt_domain_templates' => "Modelos de Domínio",
    'bt_domain_user' => "Administrador de Domínio",
    'bt_domain_user_passwd' => "Senha do Administrador do Domínio",
    'bt_domains' => "Domínios",
    'bt_domain_alias_add' => 'Adicionar Nome alternativo de Domínio',
    'bt_download' => "Transferência",
    'bt_download_log' => "Transferência",
    'bt_edit' => "Editar",
    'bt_enable' => "Ligar",
    'bt_export' => 'Exporta',
    'bt_extras' => "Extras",
    'bt_file_manager' => "Gestor de Ficheiros",
    'bt_finish' => "Concluir",
    'bt_ftp_account' => "Propriedades da Conta de FTP",
    'bt_forget_password' => "Esqueceu-se da sua senha?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP Stats",
    'bt_get_password' => "Obter Senha",
    'bt_global_changes' => "Modifica",
    'bt_help' => "Ajuda",
    'bt_hide_aliases' => "Ocultar nomes alternativos",
    'bt_hide_toolbar' => 'Ocultar barra de ferramentas',
    'bt_hide_subdomains' => "Ocultar subdomínios",
    'bt_hide_domainaliases' => "Ocultar os Nomes alternativos de Domínio",
    'bt_home' => "Início",
    'bt_hosting' => "Alojamento",
    'bt_icf' => 'Firewall',
    'bt_install' => "Instalar",
    'bt_ip_aliasing' => "Endereços IP",
    'bt_ip_add' => "Adicionar Endereço IP",
    'bt_ip_pool' => "Repositório de IP",
    'bt_key_info' => "Gestão da Licença",
    'bt_key_buyonline_addons' => 'Solicitar Suplementos do Plesk.',
    'bt_key_buyonline_upgrades' => 'Solicitar Atualizações do Plesk.',
    'bt_key_buyonline_new' => 'Encomendar Nova Chave',
    'bt_key_update' => 'Obter Chaves',
    'bt_key_upload' => 'Instalar Chave',
    'bt_key_download' => 'Descarregar Chave',
    'bt_key_revert' => 'Reverter a Chave',
    'bt_limits' => "Limites",
    'bt_locale_add' => 'Adicionar Idioma',
    'bt_locales' => 'Pacotes de idiomas',
    'bt_log_manager' => "Gestor de Log",
    'bt_login' => "Login",
    'bt_login_vzpp' => "Realize o log in para o Power Panel",
    'bt_logo' => "Aplicação de imagem corporativa",
    'bt_logo_default' => "Logo Predefinido",
    'bt_logo_send_link' => "Anexar Link",
    'bt_logo_send_logo' => "Anexar Logo",
    'bt_logout' => "Sair",
    'bt_logrotation' => "Rotação de registo",
    'bt_mail' => "Correio.",
    'bt_mail_alias_add' => "Adicionar nome alternativo de correio",
    'bt_mail_aliases' => "Nomes alternativos de E-mail",
    'bt_mail_group_add' => "Adicionar membro",
    'bt_mail_groups' => "Grupos",
    'bt_mail_name_add' => "Adicionar conta de correio",
    'bt_mail_preferences' => "Configurações",
    'bt_mail_group' => "Grupo de E-mail",
    'bt_mail_mailbox' => "Caixa de Correio",
    'bt_mail_redirect' => "Redirecionar",
    'bt_mail_resp_add' => "Adicionar resposta automática",
    'bt_mail_resp_attach_add' => "Adicionar anexo",
    'bt_mail_resp_files' => "Arquivos Anexados",
    'bt_mail_responders' => "Respostas automáticas",
    'bt_mail_spamfilter' => "Filtro de Spam",
    'bt_mail_webmail' => "Correio",
    'bt_maillist_new' => "Adicionar lista de envio",
    'bt_maillists' => "Listas de envio",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Criar Backup",
    'bt_manage' => "Gerir",
    'bt_master' => "Mestre",
    'bt_migrate' => 'Migrar mais',
    'bt_modules_add' => 'Adicionar Módulo',
    'bt_modules_manage' => 'Gerir Módulos',
    'bt_move' => "Mover",
    'bt_mimetypes' => 'MIME Type',
    'bt_mimetype_new' => 'Adicionar MIME Type',
    'bt_new_client' => "Adicionar conta de cliente",
    'bt_new_domain' => "Adicionar um domínio",
    'bt_next' => "Seguinte >>",
    'bt_next_page' => "Seguinte",
    'bt_network_add' => "Adicionar rede",
    'bt_notifications' => "Avisos",
    'bt_odbc_dsn_add' => "Adicionar ODBC DSN",
    'bt_off' => "Desligado",
    'bt_on' => "Ligado",
    'bt_on_off' => "Ligar/Desligar",
    'bt_pd_new' => "Adicionar Diretório Protegido",
    'bt_pd_user_new' => "Adicionar Utilizador",
    'bt_performance' => 'Desempenho',
    'bt_permissions' => "Autorizações",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Configurações",
    'bt_prev_page' => "Anterior",
    'bt_preview' => 'Antever Site',
    'bt_print' => "Imprimir",
    'bt_reboot' => "Reinicializar",
    'bt_reload' => "Recarregar",
    'bt_refresh' => "Atualizar",
    'bt_register' => "Registar",
    'bt_remove' => "Eliminar",
    'bt_enable_selected' => 'Ligar',
    'bt_disable_selected' => 'Desativar',
    'bt_repair_ip' => "Reparar IP",
    'bt_report' => "Relatório",
    'bt_report_auto' => 'Entrega de Relatório',
    'bt_report_auto_new' => 'Agendar Entrega',
    'bt_report_new' => "Adicionar esquema",
    'bt_reset' => "Restaurar",
    'bt_restart_services' => "Gestão de Serviços",
    'bt_save' => "Gravar",
    'bt_send_by_email' => "Enviar Por E-mail",
    'bt_send_file' => "Enviar Arquivo",
    'bt_send_mail' => "Enviar E-mail",
    'bt_send_passwd' => "Enviar Senha",
    'bt_send_text' => "Enviar Texto",
    'bt_server' => "Servidor",
    'bt_server_add' => "Adicionar Servidor",
    'bt_server_preferences' => "Definições do Servidor",
    'bt_servers_list' => "Servidores",
    'bt_sessions' => "Sessões",
    'bt_set' => "Definir",
    'bt_set_as_default' => "Configurar Como Predefinido",
    'bt_setup' => 'Configurações',
    'bt_show_aliases' => "Mostrar nomes alternativos",
    'bt_show_subdomains' => "Mostrar subdomínios",
    'bt_show_domainaliases' => "Exibir nomes alternativos de domínio",
    'bt_shutdown' => "Desligar",
    'bt_site_apppkgs' => "Cofre de aplicações",
    'bt_site_apppool' => "Repositório de Aplicações",
    'bt_application-pool' => "Aplicações Web",
    'bt_site_apps' => "Aplicações Web",
    'bt_site_app_add' => "Instalar Aplicação",
    'bt_additional_key_upload' => 'Carregar uma Nova Chave',
    'bt_additional_key_download' => 'Descarregar Chave',
    'bt_additional_key_remove' => 'Remova uma Chave',
    'bt_additional_key_activate' => 'Ativar',
    'bt_site_builder' => "Suporte do Presence Builder",
    'bt_skeleton' => 'Modelo de Alojamento Virtual',
    'bt_skins' => 'Skin',
    'bt_skin_add' => 'Adicionar máscara',
    'bt_skin_manual' => 'Referência das Máscaras Personalizadas do Plesk', // not used
    'bt_skin_download' => 'Descarregar a Skin',
    'bt_skin_replace' => 'Actualizar a Skin',
    'bt_skip' => 'Saltar',
    'bt_spamassassin' => "Filtro de Spam",
    'bt_spamassassin_train' => "Treinando",
    'bt_spamfilter' => "Filtro de Spam",
    'bt_sshterm' => 'Terminal de SSH',
    'bt_start' => "Iniciar",
    'bt_stop' => "Parar",
    'bt_recycle' => "Recicle",
    'bt_statistics' => "Estatísticas",
    'bt_subdomain_new' => "Adicionar subdomínio",
    'bt_subdomains' => "Subdomínios",
    'bt_submit' => "Submeter",
    'bt_summary_report' => "Relatório resumido",
    'bt_support' => "Suporte",
    'bt_switch' => "Trocar",
    'bt_system_time' => "Hora do sistema",
    'bt_task_new' => "Adicionar Tarefa",
    'bt_dom_tmpl_add' => 'Adicionar modelo do domínio',
    'bt_cl_tmpl_add' => 'Adicionar um modelo do cliente',
    'bt_cron_backup' => 'Configurações de Cópias de Segurança Agendadas',
    'bt_test' => "Testar Ligação",
    'bt_text' => "Texto",
    'bt_touch' => "Alterar o grupo data-hora",
    'bt_traffic' => "Tráfego",
    'bt_traffic_history' => "Histórico do Tráfego",
    'bt_tsclient' => "Desktop Remoto",
    'bt_update' => "Atualizar",
    'bt_upload' => "Carregar",
    'bt_upload_from_ftp' => "Carregar por FTP",
    'bt_virtualdirs' => 'Diretórios Virtuais',
    'bt_virtualdir_new' => 'Adicionar directório virtual',
    'bt_virtualdir_add' => 'Adicionar directório virtual',
    'bt_web_app_new' => "Instalar Aplicação Java",
    'bt_web_stats' => "Web Stats",
    'bt_web_stats_ssl' => "Estatísticas de rede SSL/TLS",
    'bt_web_user_add' => "Adicionar utilizador da Web",
    'bt_web_users' => "Utilizadores de rede",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "Preferências das estatísticas de rede",
    'bt_hidden-referrer-add' => 'Ocultar Entradas',
    'bt_group-referrer-add' => 'Agrupar Origens (Referrers)',
    'bt_whats_new_full' => "Ver a lista completa das modificações",
    'bt_white_list' => "Lista Branca",
    'bt_white_list_add' => "Adicionar rede",
    'cert_add__unable_set_ca_cert' => "Impossível configurar certificado CA: %1",
    'cert_add__unable_set_cert' => "Impossível configurar certificado: %1",
    'cert_add__unable_set_private_key' => "Impossível configurar a chave privada: %1",
    'certificates_list__certificate_used_as_default' => "Um dos certificados que vai eliminar é usado como Certificado Predefinido.",
    'certificates_list__certificates_assigned_on_ip' => "Um ou vários certificados estão atribuídos aos endereços IP.",
    'ch_pass__admin_pass' => "A alterar palavra-passe do administrador",
    'ch_pass__old_pass' => "Palavra-passe antiga",
    'ch_pass__pass_confirm' => "Confirme",
    'ch_pass__unable_change_admin_pass' => "Não é possível alterar a palavra-passe: do administrador:%1",
    'check_mail_cycle__aliases' => "Foi detectado um ciclo no correio, o endereço \"%1\" faz parte dos nomes alternativos desta conta.",
    'check_mail_cycle__autoresponders' => "Foi detetado um ciclo no correio, o endereço \"%1\" faz parte das respostas automáticas desta conta.",
    'check_mail_cycle__mail_groups' => "Foi detectado um ciclo no correio, o endereço \"%1\" faz parte do grupo de correio desta conta.",
    'check_mail_cycle__mail_name' => "Foi detectado um ciclo no correio, o endereço \"%1\" coincide com esta conta de correio.",
    'check_mail_cycle__redirect' => "Foi detetado um ciclo no correio, o endereço \"%1\" coincide com o redirecionamento desta conta.",
    'check_mail_dup__redirect' => "Foi detetado um redirecionamento duplicado, o endereço \"%1\" coincide com o redirecionamento desta conta de correio.",
    'check_mail_dup__mail_groups' => "Foi detetado um redirecionamento duplicado, o endereço \"%1\" está englobado pelo grupo de correio desta conta de correio.",
    'check_maillist_cycle__admin' => "Foi detetado um ciclo no correio, o email do Administrador \"%1\" coincide com o endereço da lista de envio.",
    'check_maillist_cycle__member' => "Foi detectado um circuito fechado no email, o endereço \"%1\" coincide com o endereço da lista de envio.",
    'chk_js__enter_login_and_passwd' => "Insira nome de utilizador e a palavra-passe.",
    'chk_js__enter_login_name' => "Insira o nome de utilizador.",
    'chk_js__enter_passwd' => "Insira a senha.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Detalhes da conta %1",
    'cl_limits__cl' => "Limites do cliente %1",
    'cl_logo__setup_logo_pref' => "Configurar propriedades de logo para o cliente %1",
    'cl_new__enter_new_cl_data' => "Insira as informações sobre o novo cliente",
    'cl_new__unable_to_sent_notification' => 'A conta de utilizador foi criada, no entanto, o envio da notificação ao cliente falhou: %1',
    'cl_perm__all_ip' => "Todos os IP's disponíveis",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Todas contas de alojamento baseadas em IP, para o cliente, serão transferidas para baseadas em nome.",
    'cl_perm__allow_client_create_domain' => "Os campos que está a tentar selecionar são aplicáveis apenas a Clientes que têm permissão para criar domínios.",
    'cl_perm__allow_create_nb_w_ip' => "Cliente pode criar alojamento baseado em nome usando %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Permitir criação de contas de alojamento baseadas em IP",
    'cl_perm__available_ips' => "IP's Disponíveis",
    'cl_perm__change_limits' => "Ajuste de limites",
    'cl_perm__cl_disk_space' => "Espaço total em disco disponível",
    'cl_perm__cl_expiration' => "Período de validade da conta do cliente",
    'cl_perm__cl_max_box' => "Caixas de correio",
    'cl_perm__cl_max_db' => "Bases de dados",
    'cl_perm__cl_max_dom' => "Domínios",
    'cl_perm__cl_max_maillists' => "Listas de envio",
    'cl_perm__cl_max_subdom' => "Subdomínios",
    'cl_perm__cl_max_traffic' => "Quantidade total de tráfego disponível",
    'cl_perm__cl_max_wu' => "Utilizadores de rede",
    'cl_perm__cl_mbox_quota' => "Tamanho máximo da caixa de correio desta conta de utilizador",
    'cl_perm__current_maximum_exp_date' => "O valor máximo actual de período de validade do domínio é %1; requerido %2",
    'cl_perm__current_maximum_mailbox_quota' => "O valor do limite actualmente definido quanto à quantidade de espaço de disco atribuído para alojar as caixas de correio nesta conta de utilizador é de %1; pedido %2",
    'cl_perm__current_total_requested' => "O valor total actual de limites do domínio para %1 é %2; requerido %3",
    'cl_perm__current_total_requested_dom' => "Número atual de %1 pertencentes a este cliente é %2; pedido %3",
    'cl_perm__disk_space' => "quantidade máxima de espaço em disco",
    'cl_perm__dashboard_stdgui' => 'Interface do utilizador',
    'cl_perm__dashboard' => 'Vista da página Inicial',
    'cl_perm__stdgui' => 'Vista padrão',
    'cl_perm__manage_dashboard' => 'Gestão da página Inicial',
    'cl_perm__dashboard_and_stdgui' => 'Permitido visualizar a página Inicial e padrão',
    'cl_perm__dashboard_only' => 'Só permitir visualizar a página Inicial',
    'cl_perm__stdgui_only' => 'Só permitir visualizar a vista padrão',
    'cl_perm__edit_cl' => "Permissões do cliente %1",
    'cl_perm__exp_date_exceeded' => "O período de validade que está a tentar estabelecer excede o limite especificado para os domínios individuais relacionados com este cliente.",
    'cl_perm__invalid_value' => "Valor inválido, só são permitidos dígitos.",
    'cl_perm__limit_disk_space' => "%1 Limitar a quantidade de espaço total em disco",
    'cl_perm__limit_expiration' => "%1 Limitar o período de validade para a conta do cliente",
    'cl_perm__limit_max_box' => "%1 Limite de número máximo de caixas de correio",
    'cl_perm__limit_max_db' => "%1 Limite de número máximo de bases de dados",
    'cl_perm__limit_max_dom' => "%1 Limite de número máximo de domínios",
    'cl_perm__limit_max_maillists' => "%1 Limite de número máximo de listas de envio",
    'cl_perm__limit_max_subdom' => "%1 Limite de número máximo de subdomínios",
    'cl_perm__limit_max_traffic' => "%1 Limite de quantidade total de tráfego",
    'cl_perm__limit_max_wu' => "%1 Limite de número máximo de utilizadores de rede",
    'cl_perm__limit_mbox_quota' => "%1 Definir a quota da caixa de correio",
    'cl_perm__limits_exceeded' => "Um ou vários limites que está a tentar definir já foram excedidos pelos limites definidos para os domínios individuais pertencentes a este cliente. O limite total para o cliente tem que ser maior ou igual à soma total dos limites do domínio definidos para esta conta de cliente.",
    'cl_perm__mailbox_quota_exceeded' => "O limite da quantidade de espaço de disco atribuído para as caixas de correio que está a tentar inserir excede os limites definidos para os domínios pertencentes a este cliente.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "O limite da quantidade de espaço atribuído para as caixas de correio que está a tentar definir excede o limite imposto a nível de servidor.",
    'cl_perm__make_dumps' => "Backup e reposição de dados",

    'cl_perm__max_box' => "número máximo de caixas de correio",
    'cl_perm__max_db' => "Número máximo de bases de dados",
    'cl_perm__max_dom' => "domínios",
    'cl_perm__max_maillists' => "número máximo de listas de envio",
    'cl_perm__max_subdom' => "subdomínios",
    'cl_perm__max_traffic' => "quantidade máxima de tráfego",
    'cl_perm__max_wu' => "número máximo de utilizadores de rede",
    'cl_perm__max_dom_aliases' => "nomes alternativos de domínio",
    'cl_perm__mbox_quota' => "Quota da caixa de correio",
    'cl_perm__not_allow_create_nb_hst' => "Cliente não pode criar alojamento baseado em nome.",
    'cl_perm__select_ip_addrs' => "Seleccione endereços IP",
    'cl_perm__this_ip_used_vrt_hst' => "Este endereço IP é usado para alojamento virtual.\nPara eliminar este endereço IP, remova o serviço de alojamento ou mude o seu tipo para baseado em nome.",
    'cl_perm__unable_off_ipb_creating' => "O cliente já tem o serviço de alojamento baseado em IP. Para desactivar esta funcionalidade ao cliente, desseleccione a checkbox \"Criação de Domínio\" ou remova todas as contas de alojamento baseadas em IP.",
    'cl_perm__unable_off_nb_creating' => "Este cliente já tem o serviço de alojamento baseado no nome. Para desactivar esta característica do cliente, desseleccione a checkbox \"Criação de Domínio\" ou remova todas as contas de alojamento baseadas em nome.",
    'cl_perm__unable_set_domain_limit' => "Impossível limitar o número máximo de domínios: cliente já tem %1 domínios",
    'cl_perm__unable_update_client_limitations' => "Impossível modificar os limites da conta do cliente: %1",
    'cl_pref__edit_cl' => "Preferências do cliente %1",
    'class_anonftp__create_ftp_domain' => "Não há domínio de FTP virtual para esta dom_id, tente criá-lo primeiro.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "O limite de espaço de disco que está a tentar estabelecer (%1) não deverá exceder o disco o limite de espaço total definido para o domínio (%2)",
    'class_anonftp__invalid_input_only_digits' => "Valor especificado inválido, somente dígitos são permitidos",
    'class_anonftp__unable_change_ownerships' => "Impossível alterar a propriedade ou as permissões para o arquivo de quota: %1",
    'class_anonftp__unable_copy_quota_file' => "Impossível copiar arquivo de quota: %1",
    'class_anonftp__unable_get_disk_usage' => "Impossível recuperar informação de uso em disco no directório de entrada: %1",
    'class_anonftp__unable_parse_quota_file' => "Impossível analisar o arquivo de quota.",
    'class_anonftp__unable_read_quota_file' => "Impossível ler o arquivo de quota: %1",
    'class_anonftp__unable_update_quota' => "Foi impossível actualizar a quota: os arquivos no directório de entrada usam %1 KBs de espaço de disco o que excede o novo valor de quota",
    'class_anonftp__unable_write_temp_file' => "Não foi possível escrever no arquivo temporário: %1",
    'class_bsdomain__warn_max_date__' => "O período de validade foi fixado em %1",
    'class_cList__empty' => "Nenhum %1.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Não foram encontradas ocorrências de <b>\\%1\\</b> em %2 (%3 de %4)",
    'class_cList__search_result' => "Encontradas ocorrências de <b>\\%1\\</b> em %2 (%3 de %4)",
    'class_client__client_creation_notification' => "Notificação de criação de cliente.",
    'class_client__client_with_contact_name_already_exists' => "Já existe um cliente com o nome %1.",
    'class_client__disk_space' => "Espaço em disco",
    'class_client__invalid_max_dom' => "O valor do números de domínios é inválido, só são permitidos dígitos.",
    'class_client__limit_exceed' => "A quantidade pretendida de %1 não pode ser atribuída porque iria exceder os limites da conta do cliente %2 da conta (%3). Se quiser atribuir mais recursos, vá a Clientes > nome de cliente > Limites e modifique os limites como desejado. Depois volte a este ecrã e tente ajustar as atribuições de novo.",
    'class_client__limit_exceed_unlimited' => "Caso deseje atribuir uma quantidade ilimitada de recursos (%1), primeiro deve ir a Clientes > nome de cliente > Limites e selecione a caixa de verificação ilimitada correspondente ao tipo de recurso pretendido. Depois volte a este ecrã e tente ajustar as atribuições de novo.",
    'class_client__max_box' => "Caixas de correio",
    'class_client__max_db' => "Bases de dados",
    'class_client__max_maillists' => "Listas de envio",
    'class_client__max_subdom' => "Subdomínios",
    'class_client__max_traffic' => "Tráfego máximo",
    'class_client__max_wu' => "Utilizadores de rede",
    'class_client__max_dom_aliases' => "Nomes alternativos de domínio",
    'class_client__mbox_quota' => "Quota da caixa de correio",
    'class_client__unable_define_cl_status' => "Impossível definir estado da conta do cliente: %1",
    'class_client__unable_define_inactive_dom' => "Impossível definir domínios inactivos %1",
    'class_client__unable_del_ip' => "Não foi possível remover os IP's: %1",
    'class_db__db_name_not_set' => "O nome de base de dados não foi definido.",
    'class_db__db_not_exist_for_curr_dom' => "A base de dados não existe neste domínio.",
    'class_db__invalid_db_or_dom_name' => "O domínio ou a ID da base de dados é inválida ou nome de base de dados não está definido.",
    'class_db__invalid_pass' => "A senha é inválida.",
    'class_db__mailgrp_member_exist' => "O membro de grupo de e-mail já existe.",
    'class_db__access_hosts_notsupport' => 'As configurações de acesso ao host não são suportadas para este tipo de base de dados',
    'class_db__unable_add' => 'Impossível adicionar o registo de acesso ao host: %1',
    'class_db__unable_del' => 'Impossível eliminar o registo de acesso ao host: %1',
    'class_db__inc_user_not_exist' => 'O utilizador de base de dados "%1" não existe',
    'class_db__inc_access_record_exist' => 'Este registo de acesso já existe',
    'class_db__inc_access_record_not_exist' => 'O registo de acesso inserido não existe',
    'class_db__inc_unable_del_last_record' => 'Impossível eliminar o ultimo registo de acesso ao host',
    'class_domtmpleditform__dns_master' => "Mestre",
    'class_domtmpleditform__dns_slave' => "Escravo",
    'class_domtmpleditform__dns_type' => "Tipo de zona de DNS do domínio",
    'class_traffichistory__no_data_available' => "Não há dados disponíveis.",
    'class_traffichistory__reten_pref' => 'Preferências da retenção das estatísticas de tráfego e Web',
    'class_traffichistory__traffic_usage' => "Utilização de tráfego",
    'clienttrafficlist_header' => "Tráfego nos domínios",
    'clienttrafficlist_header_of_client__' => "Tráfego nos domínios do cliente %1",
    'cmd_dns__a_dns_record_already_exist' => "Este registo estará em conflito com o A registro para a zona.",
    'cmd_dns__domain_has_no_ns' => 'O domínio não tem um registo DNS NS',
    'cmd_dns__domain_last_ns' => 'Não é possível eliminar o último registo DNS NS para o domínio.',
    'cmd_dns__canonical_dom_name_is_invalid' => "O nome canónico do domínio é inválido.",
    'cmd_dns__cname_dns_record_already_exist' => "Este registo estará em conflito com o CNAME registro para a zona.",
    'cmd_dns__cname_in_rr_combination' => 'Existe um combinação incorrecta de registos DNS na zona DNS',
    'cmd_dns__cname_coexist_with_data' => 'Um registo DNS CNAME não pode coexistir com outros registos DNS na mesma zona.',
    'cmd_dns__dns_record_type_is_invalid' => "Tipo de registo DNS é inválido.",
    'cmd_dns__ext_host_is_not_resolved' => "O nome canónico %1 não é resolvido para um registo A ou AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Impossível adicionar o registo %1 à zona %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Nome do servidor de troca de e-mail é inválido.",
    'cmd_dns__mx_priority_is_invalid' => "Prioridade MX inválida.",
    'cmd_dns__name_server_is_invalid' => "Servidor de nome é inválido.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Máscara de rede deve ser 24, 16 ou 8.",
    'cmd_dns__this_dns_record_already_exists' => "Este registo DNS já existe.",
    'cmd_dns__unable_add_record' => "Impossível adicionar o registo '%1': %2",
    'cmd_dns__unable_add_a_record' => "Impossível adicionar registo A: %1",
    'cmd_dns__unable_add_cname_record' => "Impossível adicionar registo CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Impossível adicionar registo DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Impossível adicionar registo EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Impossível adicionar registo NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Impossível adicionar registo PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Não foi possível adicionar o registo TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Impossível criar a zona DNS %1",
    'cmd_dns__unable_define_dns_record' => "Impossível definir o registo DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Impossível obter o status predefinido da zona DNS: %1",
    'cmd_dns__unable_insert_a_record' => "Impossível inserir registo A: %1",
    'cmd_dns__unable_insert_mx_record' => "Impossível inserir registo MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Impossível inserir registo NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Impossível definir o status da zona DNS: %1",
    'cmd_domains__dom_already_exists' => "O domínio %1 já existe.",
    'cmd_domains__dns_record_already_exists' => "Impossível criar o domínio %1 porque já existe um registo DNS a apontar ao host %1.",
    'cmd_domains__dom_already_exists1' => "Existem %2 subdomínios neste domínio. O domínio %1 já existe.",
    'cmd_domains__dom_already_exists2' => "o sub-domínio %1 já existe.",
    'cmd_domains__dalias_already_exists' => "Este nome alternativo de domínio já existe.",
    'cmd_domains__domain_alias_already_exists' => 'Já existe um nome alternativo de domínio com esse nome.',
    'cmd_domains__unable_del_mail_for_dom' => "Impossível eliminar os serviços de correio para o domínio: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Impossível eliminar a conta de FTP anónimo para o domínio: %1",
    'cmd_domains__unable_update_dom_param' => "Impossível actualizar os parâmetros do domínio: %1.",
    'cmd_domains__unable_rename_client_exist' => "o nome para login de administrador já se encontra em uso.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "O tipo de alojamento não é físico.",
    'cmd_hosting__unable_create_user' => "Impossível criar o utilizador %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Impossível definir endereço IP para os alojamentos virtuais baseados em nomes: %1",
    'cmd_hosting__unable_del_old_hst' => "Impossível eliminar o alojamento previamente configurado: %1",
    'cmd_hosting__unable_del_protected_directory' => "Impossível eliminar directório protegido: %1.",
    'cmd_hosting__unable_del_web_user' => "Impossível eliminar o utilizador web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Impossível criar ou actualizar o Alojamento Virtual: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Impossível activar o alojamento de reendereçamento por janela.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Impossível reconstruir o arquivo de configuração proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Impossível configurar SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Impossível remover protecção do directório SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Não foi possível actualizar o URL de destino %1",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Não foi possível actualizar a zona de DNS para o domínio: a execução do utilitário falhou.",
    'cmd_hosting__unable_update_ftp_passwd' => "Impossível actualizar senha de FTP %1",
    'cmd_hosting__unable_update_user' => "Impossível actualizar o utilizador %2: %1",
    'cmd_hosting__unknown_hst_type' => "Tipo de alojamento desconhecido.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Não tem a permissão para terminar o serviço de alojamento.",
    'cmd_mail__autoresponder__not_configured' => "A resposta automática para esta conta de correio não está configurada",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Endereço %1 já está a ser usado num redirecionamento de e-mail.",
    'cmd_mail__alias_already_exists' => "o nome alternativo já existe.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "O ID da resposta automática e o ID da conta de correio não correspondem.",
    'cmd_mail__autoresp_id_is_undefined' => "ID de resposta automática está indefinido.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Um nome alternativo de correio com este nome já existe para a conta de correio %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "A conta de correio %1 já está inscrita nesta lista de envio.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "A conta de correio %1 já existe no domínio.",
    'cmd_mail__mail_name_not_exist' => "A conta de correio não existe.",
    'cmd_mail__mail_name_passwd_part' => "A senha não deve conter o nome da conta de correio.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "A lista de envio %1 já existe neste domínio.",
    'cmd_mail__mailname_already_exist_in_mg' => "A conta de correio %1 já existe no grupo de correio.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "A conta de correio %1 já existe no domínio.",
    'cmd_mail__mailname_already_exists' => "A conta de correio já existe.",
    'cmd_mail__mailname_is_invalid' => "O nome da conta de correio %1 é inválido.",
    'cmd_mail__mailname_unable_update' => "Impossível actualizar as propriedades da conta de correio:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "O número máximo de respostas automáticas foi atingido neste domínio.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "O número máximo de grupos de correio foi atingido neste domínio.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "O número máximo de redirecionamentos foi atingido neste domínio.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "O número máximo de caixas de correio foi atingido.",
    'cmd_mail__no_members_specified' => "não tem membros especificados.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "A senha é muito simples, escolha outra.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Este endereço e-mail já está a ser utilizado.",
    'cmd_mail__unable_define_autoresp_id' => "Impossível definir ID de reposta automática %1",
    'cmd_mail__unable_update_mail_for_dom' => "Falhou a modificação das definições do serviço de correio para o domínio %1",
    'cmd_mail__unable_del_mail_for_dom' => "Não foi possível remover o serviço de correio do domínio %1",
    'cmd_mail__unable_del_mail_redirection' => "Impossível remover redirecionamento de e-mail %1",
    'cmd_mail__unable_remove_autoresp' => "Impossível remover respostas automáticas: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Impossível remover os membros do grupo de e-mail: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Falha ao desligar o grupo de correio: %1",
    'cmd_mail__unable_update_mail_redirect' => "Impossível atualizar o redirecionamento de e-mail %1",
    'cmd_mail__uploaded_file_is_too_big' => "O tamanho do arquivo carregado é muito grande.",
    'cmd_mail__additionally' => "Adicionalmente:",
    'cmd_pd__invalid_login' => "Nome de utilizador incorreto.",
    'cmd_pd__this_user_already_exist' => "Este utilizador já existe.",
    'cmd_pd__unable_define_hst_type' => "Impossível definir tipo de alojamento.",
    'cmd_pd__unable_upd_pd_usr' => "Impossível actualizar as propriedades do utilizador do directório protegido: %1.",
    'cmd_pd__user_is_undefined' => "Utilizador indefinido.",
    'cmd_server__no_enough_free_disk_space' => "Espaço em disco insuficiente.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "a senha antiga está incorrecta. Por favor, tente novamente.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "o limite máximo de utilizadores de rede foi alcançado para este domínio.",
    'cmd_web_usr__unable_create_user' => "impossível criar utilizador de sistema: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "impossível definir o limite máximo de utilizadores de rede: %1",
    'cmd_web_usr__user_already_exists' => "o utilizador já existe.",
    'cmd_web_usr__web_user_name_is_invalid' => "o nome do utilizador web %1 é inválido.",
    'cmd_web_usr__web_user_not_exist' => "o utilizador web não existe.",
    'common_func__exec_bad_argument' => "o argumento exec não deve conter o símbolo das aspas simples.",
    'common_acl__add_address' => 'Adicionar à lista das Permissões do Controlo de Acesso Comum à Zona (ACL)',
    'common_acl_add_record' => 'Adicionar um registo de ACL',
    'enter_ip_or_network_address' => 'Insira um IP ou um endereço de rede',
    '__eol' => 'Quebras de linha',
    'eol__binary_file' => 'Impossível modificar o estilo de quebra de linha no ficheiro binário.',
    'comp_info__header' => 'Componentes',
    'comp_info__comp_name' => "Nome do componente",
    'comp_info__comp_disabled' => 'Desligado',
    'comp_info__comp_active' => 'Ativo',
    'comp_info__comp_not_configured' => 'Não configurado',
    'comp_info__comp_not_started' => 'Não iniciado, verificar configurações dos componentes',
    'comp_info__comp_version' => "Versão do componente",
    'comp_info__integration_error' => "Erro de integração",
    'comp_info__title' => "Componentes do Plesk",
    'comp_info__service_name' => "Serviço",
    'comp_info__last_updated' => '(ultima actualização: %1)',
    'configure__full_hostname' => "Nome de host completo (hostname)",
    'cp_access_admin_deny' => "Acesso do administrador para o endereço '%1' é restrito de acordo com a política de restrição actualmente aplicada.",
    'create_domain_warn__' => "As seguintes excepções foram feitas durante a criação do domínio:",
    'create_domain__client_select' => 'Selecione o cliente para o qual você deseja criar o domínio',

    'dashboard__nav_button_name' => "Início",
    'dalias__list_title' => 'Nomes alternativos de domínio para o domínio %1',
    'dalias__list_legend' => 'Nomes alternativos de domínio',
    'dalias__list_header' => 'Nomes alternativos de domínio',
    'dalias__list_status' => 'F',
    'dalias__list_name' => 'Nome do nome alternativo de domínio',
    'dalias__list_ascii_name' => 'Em formato ASCII',
    'dalias__remove_title' => 'Os seguintes nomes alternativos de domínio para o domínio %1 serão removidos:',
    'dalias__select_domain_aliases_to_remove' => 'Seleccione os nomes alternativos de domínio a serem removidos.',
    'dalias__mail_turn_on_failed' => 'Impossível ligar o serviço de e-mail: %1',
    'dalias__web_turn_on_failed' => 'Incapaz de ativar o serviço web: %1',
    'db_usr_edit__db_usr_name_old' => "Antigo nome de utilizador da base de dados",
    'databases__db_title' => "Credenciais e ferramentas do administrador do Servidor MS SQL",
    'databases__server_title' => "Senha de administrador %1",
    'databases__connection' => "Conexão",
    'databases__db_server' => "Nome do Servidor",
    'databases__db_admin_login' => "Nome de usuário do administrador",
    'databases__db_admin_passwd' => "Senha do administrador",
    'databases__db_confirm_passwd' => "Confirmar a palavra-passe",
    'databases__can_not_manage' => "Não pode administrar o servidor de base de dados",
    'databases__not_installed' => "(não está instalado)",
    'databases__not_supported_license' => "(não é suportado pela sua chave de licença)",
    'databases__title' => "Configurar as Credenciais de Administração e do Administrador da Base de Dados",
    'databases__unable_connect' => "Impossível aceder à base de dados. Parâmetros incorrectos.",
    'databases__incorrect_db_admin_login' => 'O nome do usuário pode conter apenas símbolos alfanuméricos, traço e sublinhado, e deve iniciar com um símbolo alfaumérico.',
    'databases__incorrect_db_admin_passwd' => 'A palavra-passe não pode conter o nome de utilizador.',
    'database_servers_form__title' => 'Servidores de Base de Dados',
    'database_servers_form__server_list_legend' => 'Servidores de base de dados',
    'database_servers_form__remove_empty_selection' => 'Não seleccionou os servidores de base de dados.',
    'database_servers_form__remove_title' => 'Os seguintes servidores de base de dados serão removidos:',
    'database_server_database_list__client' => 'Cliente',
    'database_server_database_list__domain' => 'Domínio',
    'database_server_database_list__header' => 'Bases de dados',
    'database_server_database_list__name' => 'Nome',
    'database_server_databases_form__databases_list_legend' => 'Bases de dados',
    'database_server_databases_form__remove_empty_selection' => 'Não seleccionou as bases de dados.',
    'database_server_databases_form__remove_title' => 'As seguintes bases de dados serão removidas:',
    'database_server_databases_form__tab' => 'Bases de dados (%1)',
    'database_server_edit_form__admin_login' => "Nome de utilizador",
    'database_server_edit_form__admin_password' => "Senha",
    'database_server_edit_form__admin_password2' => "Confirmar a palavra-passe",

    'database_server_edit_form__default' => 'Utilizar este servidor como predefinido para %1',
    'database_server_edit_form__duplicate' => 'Um servidor de base de dados com esta combinação de endereço e numero de porta já se encontra registado.',
    'database_server_edit_form__host' => 'Nome de Host ou endereço IP',
    'database_server_edit_form__legend_authentication' => 'Autenticação',
    'database_server_edit_form__legend_general' => 'Geral',
    'database_server_edit_form__port' => 'Número da porta',
    'database_server_edit_form__port_hint' => 'Deixe em branco para o numero de porta predefinido',
    'database_server_edit_form__tab' => 'Servidor da base de dados',
    'database_server_edit_form__title_new' => 'Novo servidor de base de dados',
    'database_server_edit_form__title_edit' => 'Servidor de base de dados em %1',
    'database_server_edit_form__type' => 'Tipo de servidor de base de dados',
    'database_server_edit_form__unix_socket' => '(conexão local)',
    'database_server_edit_form__external_connection' => 'Permitir que o servidor MySQL local aceite ligações externas',
    'database_server_edit_form__external_connection_hint' => 'A alteração desta configuração resultará na reinicialização do servidor MySQL local. Para ativar o acesso remoto a outros servidores MySQL registados no Plesk, altere a sua configuração manualmente.',
    'database_server_edit_form__external_connection__configured_to_local' => 'O servidor MySQL local foi configurado para rejeitar ligações remotas',
    'database_server_edit_form__external_connection__configured_to_remote' => 'O servidor MySQL local foi configurado para aceitar ligações remotas',
    'database_server_error__consult_admin' => 'Contacte o administrador do servidor.',
    'database_server_error__last__connection_failed' => 'A ultima tentativa de controlar este servidor de bases de dados falhou por problemas de rede.',
    'database_server_error__last__permission_denied' => 'A ultima tentativa de controlar este servidor de bases de dados falhou porque a conta inserida não tinha privilégios de administração.',
    'database_server_error__last__credentials_not_set' => "A última tentativa de ligação a este servidor falhou porque não foram especificados um nome de utilizador e senha de administrador válidos.",
    'database_server_error__last__other_error' => 'A ultima tentativa de controlar este servidor de bases de dados falhou.',
    'database_server_error__real__connection_failed' => 'A conexão ao servidor de base de dados falhou por causa de problemas de rede:',
    'database_server_error__real__permission_denied' => 'A conexão ao servidor de base de dados falhou porque a conta inserida não tem privilégios de administração:',
    'database_server_error__real__duplicate_object' => 'A conexão ao servidor de base de dados falhou por um conflito de nomes:',
    'database_server_error__real__unacceptable_name' => 'A conexão ao servidor de base de dados falhou por causa do nome do objecto ser inválido;',
    'database_server_error__real__unacceptable_password' => 'A conexão ao servidor de base de dados falhou por não ser possível aceitar a senha:',
    'database_server_error__real__credentials_not_set' => "O Plesk não pode ligar-se ao servidor da base de dados porque não foram especificados um nome de utilizador e senha de administrador válidos.",
    'database_server_error__real__other_error' => 'A ligação ao servidor de bases de dados falhou:',
    'database_server_error__test__connection_failed' => 'O teste de ligação ao servidor da base de dados falhou por causa de problemas de rede:',
    'database_server_error__test__permission_denied' => 'O teste da ligação ao servidor da base de dados falhou porque a conta inserida não tem privilégios de administração:',
    'database_server_error__test__duplicate_object' => 'O teste da ligação ao servidor da base de dados falhou por causa de um conflito de nomes:',
    'database_server_error__test__unacceptable_name' => 'O teste da ligação ao servidor da base de dados falhou por causa do nome do objeto ser inválido:',
    'database_server_error__test__unacceptable_password' => 'O teste da ligação ao servidor de base de dados falhou por não ser possível aceitar a senha:',
    'database_server_error__test__credentials_not_set' => "O teste de ligação a este servidor falhou porque não foram especificados um nome de utilizador e senha de administrador válidos.",
    'database_server_error__test__other_error' => 'O teste da ligação ao servidor da base de dados falhou:',
    'database_server_list__header' => 'Servidores de base de dados',
    'database_server_list__last_error' => 'F',
    'database_server_list__type' => 'Tipo de servidor',
    'database_server_list__host' => 'Nome de Host',
    'database_server_list__port' => 'Porta',
    'database_server_list__version' => 'Versão',
    'database_server_list__dbcount' => 'Bases de dados',
    'db__create_new_db' => "Adicionar uma base de dados",
    'db__db_add' => "Adicionar base de dados",
    'db__db_for_dom' => "Banco de dados do Website %1",
    'db__db_id_undefined' => "ID de base de dados está indefinida.",
    'db__db_name' => "Nome da base de dados",
    'db__db_not_exist' => "A base de dados não existe.",
    'db__db_type' => "Tipo",
    'db__db_server' => "Servidor da base de dados",
    'db_server_not_exist' => "O servidor de Base de Dados não existe.",
    'db__db_user_not_exist' => "O utilizador de base de dados não existe.",
    'db__domain_not_exist' => "Domínio não existe.",
    'db__enter_db_name' => "Insira novo nome da base de dados.",
    'db__invalid_db_id' => "Identificador da base de dados é inválido.",
    'db__invalid_db_name' => "O nome da base de dados não é válido. O nome da base de dados só pode conter símbolos do alfabeto latino, dígitos, sublinhado ou traço. Não pode ser maior que 63 símbolos.",
    'db__max_db_reached_for_dom' => "O limite do número de bases de dados foi atingido para este domínio.",
    'db__max_mssql_db_reached_for_dom' => "Foi alcançado o limite máximo do número de bases de dados no servidor de SQL Microsoft para este domínio",
    'db__postgres_not_connect_for_admin' => "Impossível conectar ao PostgreSQL. Ligue o suporte ao PostgreSQL na página de administração do servidor.",
    'db__postgres_not_connect_for_client' => "Impossível conectar ao PostgreSQL. Contacte o administrador do sistema para obter ajuda.",
    'db__remove_db_on_domain' => "Serão removidas as seguintes bases de dados do domínio %2 pertencente ao cliente %1:",
    'db__remove_db_on_domain_of_cl' => "Serão removidas as seguintes bases de dados do domínio %2 pertencente ao cliente %1:",
    'db__remove_db_linked_resource' => 'Esta base de dados está em uso por uma aplicação web. Só pode ser removida após desinstalar a aplicação web.',
    'db__remove_db_users' => "Serão removidos os seguintes utilizadores das bases de dados %3 do domínio %2 pertencente ao cliente %1:",
    'db__remove_db_users_of_cl' => "Serão removidos os seguintes utilizadores das bases de dados %3 do domínio %2 pertencente ao cliente %1:",
    'db__select_db_for_remove' => "Seleccione as bases de dados a serem removidas.",
    'db__select_db_users_for_remove' => "Seleccione os utilizadores de bases de dados para remoção.",
    'db__unable_create_db_user' => "Impossível criar o utilizador de base de dados: %1",
    'db__unable_define_db_name' => "Impossível definir nome de base de dados: %1",
    'db__unable_define_db_user' => "Impossível definir o utilizador de base de dados: %1",
    'db__unable_define_db_users' => "Impossível definir os utilizadores de base de dados: %1",
    'db__unable_select_dom_name' => "Impossível seleccionar nome de domínio: %1",
    'db_edit__db_for_dom' => "Utilizadores para a base de dados %1 no domínio %2",
    'db_edit__invalid_db_name' => "O nome da base de dados é inválido.",
    'db_edit__no_users' => "Não existe nenhum utilizador com credenciais para esta base de dados.",
    'db_edit__unable_define_db_usrs' => "Impossível definir utilizadores da base de dados: %1",
    'db_edit__unable_select_db_usr' => "Impossível seleccionar utilizador da base de dados.",
    'db_edit__db_user_password_for_' => "Por favor, insira a senha para entrar como o utilizador  %1 da base de dados",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Adicionar utilizador de base de dados",
    'db_usr_edit__db_usr_name' => "Nome do utilizador de base de dados",
    'db_usr_edit__edit_db_usr' => "Configurar autenticações para uma conta de utilizador de base de dados",
    'db_usr_edit__for_db' => "na base de dados %1",
    'db_usr_edit__not_create_pass' => "Esta operação resultará na criação de uma conta de utilizador da base de dados sem senha.\nDeseja criar um utilizador sem atribuir uma senha?",
    'dbuser__only_one_user_can_be_default' => "Só um utilizador pode ser o predefinido.",
    'db_server__cannot_delete_default' => "O servidor de base de dados predefinido não pode ser eliminado.",
    'db_server__cannot_delete_local' => "O servidor local de bases de dados não pode ser eliminado.",
    'db_server__cannot_delete_used' => 'Um servidor da base de dados não pode ser excluído enquanto existirem bases de dados ou utilizadores da base de dados hospedados nele.',
    'demo__disabled_in_demo' => "Esta operação não é suportada na versão de demonstração.",
    'defaultcomponents__title' => "Seleccionando Serviços de Terceiros",
    'defaultcomponents__select_default' => "Seleccione o componente %1 predefinido",//to check
    'defaultcomponents__not_installed' => "(não está instalado)",
    'defaultcomponents__not_configured' => "(não configurado)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Algumas das categorias de serviços contêm selecções inválidas, ou nenhuma selecção foi feita.",
    'defaultcomponents__depends_on' => "(requer %1)",
    'defaultcomponents__parameters' => "Parâmetros de %1",
    'component_name__antivirus' => "Antivírus",
    'component_name__database' => "Servidor SQL",
    'component_name__sqladmin' => "MySQL Web Admin",
    'component_name__sqladminmysql' => "MySQL Web Admin",
    'component_name__dnsserver' => "Servidor DNS",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "Servidor FYP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Servidor de correio",
    'component_name__local_mailserver' => "Servidor de correio local",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Scripting web",
    'component_name__spamfilter' => "Filtro de Spam",
    'component_name__stats' => "Estatísticas de rede",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Correio",
    'component_name__webpublish' => "Publicação na rede",
    'component_name__webserver' => "Servidor de rede",
    'dns__dns_zone_legend' => 'Registos DNS',
    'dns__dns_record_invalid_values' => 'Foram especificados valores de registo DNS incorretos: %1: %2',
    'dns__dns_zone_invalid_values' => 'Foram especificados valores incorrectos na Zona DNS.',

    'dns__soa_mname_title' => 'Nome do servidor principal',
    'dns__soa_mname_legend' => 'Servidor do nome',
    'dns__soa_mname_autoselect' => '(Seleção automática)',

    'dns__dns_soa_title' => 'Registo SOA',
    'dns__dns_zone_default' => 'Predefinições de zona',
    'dns__dns_zone_settings_template_title' => 'Definições da Zona',
    'dns__dns_soa_legend' => 'Registo SOA',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'Atualizar',
    'dns__dns_soa_retry' => 'Repetir',
    'dns__dns_soa_expire' => 'Expira',
    'dns__dns_soa_minimum' => 'Mínimo',
    'dns__dns_soa_ttl_error' => 'O valor TTL é inválido. Pode ser de 1 segundo a 68 anos.',
    'dns__dns_soa_refresh_error' => 'O valor Refresh é inválido. Pode ser de 1 segundo a 68 anos.',
    'dns__dns_soa_retry_error' => 'O valor Retry é inválido. Pode ser de 1 segundo a 68 anos.',
    'dns__dns_soa_expire_error' => 'O valor Expire é inválido. Pode ser de 1 segundo a 68 anos.',
    'dns__dns_soa_minimum_error' => 'O valor Minimum é inválido. Pode ser de 1 segundo a 68 anos.',
    'dns__dns_default_title' => 'Repor a zona DNS',
    'dns__dns_default_legend' => "Opções da reposição da zona",
    'dns__dns_default_text' => "Escolha as definições para a reposição da zona de DNS, confirme-as e clique OK",
    'dns__dns_default_confirm' => "Confirme a reposição da zona de DNS",
    'dns__dns_default_confirm_required' => "Por favor, confirme a reposição da zona DNS",
    'dns__dns_default_invalid_ip_address' => 'Endereço IP inválido',

    'dns_t__dns_default_title' => 'Repor o modelo da zona DNS original',
    'dns_t__dns_default_legend' => "Opções de reposição",
    'dns_t__dns_default_text' => 'Escolha a configuração para repor o modelo da zona DNS, confirme e clique OK.',
    'dns_t__dns_default_confirm' => "Confirmar restauração",
    'dns_t__dns_default_confirm_required' => "Por favor, confirme a reposição do modelo da zona DNS",
    'dns_t__dns_zone_off_remove_title' => "Os seguintes registos do modelo da zona DNS serão removidos:",
    'dns_t__dns_zone_master_remove_title' => "Os seguintes registos do modelo da zona DNS serão removidos:",
    'dns_t__add_dns_record_master_title' => 'Adicionar um registo ao modelo de zona DNS.',
    'dns_t__add_dns_record_off_title' => 'Adicionar servidor de nome',
    'dns_t__edit_dns_record_master_title' => 'Editar um registo',
    'dns_t__edit_dns_record_off_title' => 'Editar o servidor de nome',
    'dns_t__select_record_to_remove' => "Seleccione os registos a remover do modelo da zona DNS",
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__unit_seconds' => 'segundos',
    'dns__unit_minutes' => 'minutos',
    'dns__unit_hours' => 'horas',
    'dns__unit_days' => 'dias',
    'dns__unit_weeks' => 'semanas',
    'dns__dns_zone_off_remove_title' => "Os seguintes registos de recursos serão removidos da zona %1:",
    'dns__dns_zone_master_remove_title' => "Remover os Registros de Recursos da Zona de DNS %1",
    'dns__dns_zone_slave_remove_title' => "Os seguintes registos, dos servidores de nome principal %1 serão removidos:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Insira o registo SPF',
    'dns_add__is_spf_syntax' => 'Registo SPF',
    'dns_add__spf_value_is_invalid' => "O valor do registo de SPF é incorrecto, tem que começar com 'v=spf'",
    'dns__dns_zone_status' => "Status de zona DNS.",
    'dns__dns_zone_template' => "Modelo de zona DNS",
    'dns__host' => "Sistema anfitrião",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "O endereço IP do novo servidor master DNS é inválido ou vazio.",
    'dns__ip_address' => "Endereço IP",
    'dns__master_dns_type' => "O servidor de DNS é master",
    'dns__masters' => "Servidores master de DNS",
    'dns__soa_minimum_too_large' => 'Não é recomendável fazer a cache das respostas negativas por mais de três horas.',
    'dns__select_masters_to_remove' => "Seleccione os servidores primários de DNS a remover.",
    'dns__select_template_record_to_remove' => 'Seleccione os registos DNS do modelo a remover.',
    'dns__select_common_acl_record_to_remove' => 'Seleccione os registos ACL DNS a remover.',
    'dns__select_record_to_remove' => 'Seleccione os registos DNS a serem removidos.',
    'dns__nameservers_for_domain' => "Nomes de servidores para o domínio",
    'dns__ns' => "Servidor de nome",
    'dns__ns_record' => "Servidores de nome",
    'dns__remove_dns_zone_of_domain__' => "Remoção de registos DNS do domínio %1",
    'dns__remove_dns_zone_template__' => "Os seguintes registos DNS serão removidos do modelo:",
    'dns__remove_common_acl_record' => "Os seguintes registos de ACL serão removidos",
    'dns__remove_this_dns_record?' => "Você tem certeza de que deseja remover este registo DNS?",
    'dns__restore_default' => "A repor a zona DNS pelo modelo",
    'dns__restore_default_confirm' => "Ao repor a zona de DNS, descartará a configuração DNS atualmente usada. Quer prosseguir ?",
    'dns__restore_default_error' => "Erro ao repor a zona DNS:",
    'dns__slave_dns_type' => "é um servidor de DNS secundário",
    'dns__soa_refresh_value_is_small' => 'O valor do Intervalo de Refrescamento é menor de uma hora o que pode aumentar de forma crítica o tráfego no servidor e a utilização de recursos. Continuar a usar este valor?',
    'dns__subdomain_dns_rec_removed' => "O registo tipo A foi removido da zona do sub-domínio %1.",
    'dns__zone_switched_off_no_ns' => "A zona foi desligada porque não existe nenhum registo NS %1, o qual deve estar presente na zona. Para adicionar o registo à zona, clique o botão Adicionar Registo.",
    'dns__cant_switch_on_no_ns' => "A zona não pode ser ligada porque não existe nenhum registo NS %1, o qual deve estar presente na zona. Para adicionar o registo à zona, clique o botão Adicionar Registo.",
    'dns__type' => "Tipo de registo",
    'dns__unable_activate/deactivate_dns' => "Impossível activar/desactivar DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Impossível adicionar servidor master de DNS: entrada duplicada.",
    'dns__unable_add_dns_master_local_ip' => "Impossível adicionar este endereço IP para o servidor de DNS principal: este registo deve ser criado no servidor remoto.",
    'dns__unable_define_dns_record' => "Impossível definir o registo DNS: %1",
    'dns__unable_get_dns_template_status' => "Impossível obter o status do modelo de DNS.",
    'dns__unable_remove_dns_rec' => "Impossível remover o registo DNS: %1",
    'dns__val' => "Valor",
    'dns__warnings__' => "Resultado da modificação da zona DNS:",
    'dns__you_not_have_perm_manage_dns' => "Não tem permissão para administrar a zona de DNS para este domínio.",
    'dns__zone_record' => "Registos DNS",
    'dns__dns_preferences_form' => 'Configurações de Repetição de DNS',
    'dns__dns_recursion_settings' => 'Definições da recursividade de DNS',
    'dns__allow_recursion' => 'Permitir recursividade',
    'dns__cant_create_record_with_server_ip' => "Impossível adicionar este endereço IP pois correspondente ao endereço IP deste servidor.",

    'dns__tabs_acl' => "Restrições de Transferência",
    'dns__acl_add_network_legend' => "Adicionar rede",
    'dns__acl_add_ip_legend' => "Adicionar Endereço IP",
    'dns__acl_network_not_allowed' => "Este endereço de rede não é autorizado pelo DNS no Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Endereço/máscara IP",
    'dns__acl_enter_ip_address' => "Endereço IP",
    'dns__acl_list_network_legend' => "Lista de redes autorizadas a obter uma cópia da zona DNS.",
    'dns__acl_list_ip_legend' => "Endereços IP autorizados a obter uma cópia da zona DNS.",
    'dns__acl_record_network' => "Redes permitidas",
    'dns__acl_record_ip' => "Endereços IP permitidos",
    'bt_dns_acl_add_network' => "Adicionar rede",
    'bt_dns_acl_add_ip' => "Adicionar Endereço IP",

    'dns_add__add_rec_for_zone' => "Adicionar %1 à zona %2",
    'dns_add__canonical_dom_name_is_invalid' => "O nome canónico do domínio é inválido.",
    'dns_add__enter_canonical_name' => "Insira um nome canónico",
    'dns_add__enter_dom_name' => "Nome do domínio",
    'dns_add__enter_ip_address' => "Endereço IP",
    'dns_add__enter_ip_mask' => "Endereço de IP e máscara de rede",
    'dns_add__enter_mail_domain' => "Domínio do e-mail",
    'dns_add__enter_mail_exchanger' => "Servidor exchange de e-mail",
    'dns_add__enter_nameserver' => "Servidor de nome",
    'dns_add__enter_txt_record' => "Insira um registo TXT",
    'dns_add__enter_service_name' => "Nome do serviço",
    'dns_add__hint_service_name' => "Exemplo: SIP",
    'dns_add__enter_protocol' => "Protocolo",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioridade",
    'dns_add__specify_weight_of_service' => "Peso relativo para registos com a mesma prioridade",
    'dns_add__enter_target_host' => "Host alvo",
    'dns_add__hint_target_host' => "Exemplo: exemplo.com",
    'dns_add__enter_target_port' => "Porta alvo",
    'dns_add__caa_tag' => "Etiqueta",
    'dns_add__caa_value' => "Valor",

    'dns_add__invalid_ip' => "Endereço IP é inválido.",
    'dns_add__low' => "baixo",
    'dns_add__mail_dom_name_is_invalid' => "Nome de domínio de e-mail é inválido.",
    'dns_add__nameserver_is_invalid' => "Servidor de nome é inválido.",
    'dns_add__record' => "registo %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Especifique a prioridade do servidor de troca de e-mail",
    'dns_add__unable_insert_new_dns_rec' => "Impossível inserir novo registo DNS: %1",
    'dns_add__very_high' => "muito alta",
    'dns_check__test_dns_zone' => "Testar zona DNS %1 em %2",
    'dns_check__unable_get_dom_properties' => "Impossível obter as propriedades do domínio: %1",
    'dom_ctrl__allowed' => "Permitido",
    'dom_ctrl__db' => "Bases de dados do MySQL",
    'dom_ctrl__mssql_db' => "Base de dados MS SQL",
    'dom_ctrl__disk_space' => "Espaço em disco",
    'dom_ctrl__dom_adm' => "Domínio %1 de %2",
    'dom_ctrl__dom_cl' => "Domínio %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domínio tem configuração de encaminhamento com URL indefinida",
    'dom_ctrl__domain_has_frame_forwarding' => "O domínio está  ser reendereçado por janela para a URL %1",
    'dom_ctrl__domain_has_no_hosting' => "O domínio não tem nenhum alojamento configurado",
    'dom_ctrl__domain_has_physical_hosting' => "O domínio tem alojamento Web no endereço IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "O domínio está  ser reendereçado para a URL %1",
    'dom_ctrl__maillists' => "Listas de envio",
    'dom_ctrl__mboxes' => "Caixas de correio",
    'dom_ctrl__mg' => "Reencaminhamentos de correio",
    'dom_ctrl__resource_name' => "Recurso",
    'dom_ctrl__resp' => "Respostas automáticas",
    'dom_ctrl__subdom' => "Subdomínios",
    'dom_ctrl__dom_aliases' => "Nomes alternativos de domínio",
    'dom_ctrl__traffic' => "Tráfego",
    'dom_ctrl__unable_activate/deactivate_dom' => "Impossível activar/desactivar domínio: %1",
    'dom_ctrl__used' => "Usada",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Utilizadores de rede",
    'dom_pref__bounce_with_phrase' => "Devolver incluindo mensagem",
    'dom_pref__bounce' => "Devoluções",
    'dom_pref__catch_addr' => "Enviar para endereço determinado",
    'dom_pref__reject' => 'Rejeitar',
    'dom_pref__confirm_domain_removing' => "Por favor, não se esqueça de informar os visitantes do domínio sobre a mudança do nome deste domínio. Tem certeza que deseja modificar o nome do domínio?",
    'dom_pref__db_inconsystency' => "Inconsistência de base de dados.",
    'dom_pref__dbs' => "bases de dados",
    'dom_pref__delete_traffic_stat' => "Reter as estatísticas de tráfego e Web",
    'dom_pref__delete_traffic_stat_older' => "Reter as estatísticas de tráfego e Web",
    'dom_pref__dom_level_name_conflict' => "O nome de utilizador do administrador do domínio conflitua com o nome de utilizador de um dos clientes.",
    'dom_pref__invalid_disk_space_limit' => "Limite de espaço de disco inválido. Valor máximo: %1",
    'dom_pref__invalid_expiration_date_limit' => "Período de validade inválido.",
    'dom_pref__invalid_max_traffic_limit' => "Limite de tráfego inválido. Valor máximo: %1",
    'dom_pref__limits_of_dom' => "Limites para o domínio %1",
    'dom_pref__mail_grps' => "Grupos de e-mail",
    'dom_pref__mail_nonexistent_user' => "O que fazer com e-mail enviado a um utilizador não existente?",
    'dom_pref__mail_redirs' => "Redirecionamentos de e-mail",
    'dom_pref__mail_resps' => "Respostas automáticas",
    'dom_pref__max_limit_is_invalid' => "%1 é inválido.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Número máximo de %1 é inválido.",
    'dom_pref__new_limit_less_currently_used' => "%1: necessários - %2, actualmente usados - %3",
    'dom_pref__older_that' => "para",
    'dom_pref__postboxes' => "caixas de correio",
    'dom_pref__preferences_of_dom' => "Preferências para o domínio %1",
    'dom_pref__redirect_to_itself' => "O domínio será reendereçado para si próprio",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Você especificou o tempo de retenção de estatísticas de tráfego de domínio para ser menor do que o valor total definido para o servidor (%1 mês(es)). O período de retenção de estatísticas será definido como igual ao valor predefinido para o servidor (%1 mês(es)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Impossível adicionar um prefixo www ao domínio: %1",
    'dom_pref__unable_define_physical_hst_param' => "Impossível definir parâmetros de alojamento físico: %1",
    'dom_pref__unable_rename_domain' => "Impossível renomear o domínio para %1",
    'dom_pref__unable_set_up_mbox_quota' => "Impossível definir quota da caixa de correio para este domínio: %1",
    'dom_pref__unable_set_up_web_user_script' => "Não foi possível activar o scripting para os utilizadores de rede: %1",
    'dom_pref__unlimited' => "Ilimitado",
    'dom_pref__web_usrs' => "utilizadores de rede",
    'dom_pref__you_already_have_%object' => "Você já tem %1",
    'dom_cli__warning_ignore_quota' => 'AVISO: A opção "-hard_quota" foi ignorada: não são suportadas quotas de  disco rígido',
    'dom_user_client_login_exist' => "Impossível permitir o acesso do administrador de domínio ao Plesk no domínio %1: o nome de utilizador já se encontra em utilização.",
    'domain__unable_to_turn_on_service' => "Falha ao ligar o serviço %1.",
    'domains__change_the_status_of_domain?' => "Você tem certeza de que deseja alterar o status do domínio %1?",
    'domains__client_info_hiding_traffic' => "%1 domínios, %2 domínios activos, %3 disco utilizado",
    'domains__unable_to_change_client_status' => "Impossível alterar o estado da conta do cliente: %1",
    'domains__unable_update_apache_settings' => "Impossível actualizar configurações Apache",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Não tem permissões para eliminar domínios.",
    'domains__you_want_change_the_status_of_the_cl??' => "Você tem a certeza de que deseja alterar o estado da conta do cliente?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Tem a certeza que deseja executar esta operação?",
    'domains_list__unable_remove_doms' => "Impossível remover domínios: %1",
    'domaintrafficlist_header_of_domain__' => "Tráfego no domínio %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Seleccione os nomes alternativos de domínio a serem removidos.',
    'domain_aliases_remove__title' => 'A remover os nomes alternativos do domínio',
    'domain_aliases__max_aliases_reached_for_dom' => "O limite do número de nome alternativo foi alcançado para este domínio.",
    'domain_edit__edit_title' => 'Editar o nome de nome alternativo do domínio',
    'domain_alias_edit__type' => 'Tipo de nome alternativo do domínio',
    'domain_aliases__list_header' => 'Nomes alternativos de domínio',
    'domain_aliases__name' => 'Nome',
    'domain_aliases__type' => 'Tipo',
    'domain_aliases__type_full' => 'Web+FTP+EMail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Nomes alternativos de domínio',
    'domain_aliases__legend' => 'Nomes alternativos de domínio',
    'domain_alias__domain_exists' => 'Já existe um domínio com esse nome.',
    'domain_alias__subdomain_exists' => 'Já existe um subdomínio com esse nome.',
    'domain_alias__dns_record_exists' => 'Já existe um registo de DNS com esse nome de nome alternativo de domínio',
    'domain_alias__domain_alias_exists' => "Já existe um nome alternativo de domínio com esse nome.",
    'domain_alias__invalid_type_full' => 'O servidor de correio não suporta nome alternativo de domínio',
    'domain_alias__redirect_exists' => 'Detetado um redirecionamento para si próprio',

    'ds__anonymous_ftp' => "FTP Anónimo",
    'drweb__pagetitle' => 'Configurações do Antivirus',
    'drweb__drweb' => 'Verificação de correio por Antivírus',
    'drweb__drweb_direction' => 'A verificar o correio por viroses',
    'drweb__drweb_direction_off' => 'Não verificar os virús',
    'drweb__drweb_direction_any' => 'Correio a entrar e a sair',
    'drweb__drweb_direction_from' => 'Só correio a sair',
    'drweb__drweb_direction_to' => 'Só correio a entrar',
    'drweb__disable_reason_key' => 'O Dr.Web não é suportado pela chave de licença.',
    'drweb__disable_reason_perm' => 'Não tem permissão para administrar o Dr.Web.',
    'drweb__disable_reason_install' => 'O Dr.Web não está instalado.',
    'drweb__filters' => 'Filtros Antivírus',
    'ds__dns' => "Zona DNS",
    'ds__mail' => "Correio.",
    'dsr__of_client_title' => "Sumário de domínio de %1",
    'dsr__report_has_been_sent_email' => "O relatório foi enviado para o e-mail: %1",
    'dsr__title' => "Sumário de domínio",
    'dumps_list__deletion_page_title' => "Serão removidos os seguintes ficheiros de backup do domínio %1:",
    'dumps_list__dumpfile_is_invalid' => "O arquivo %1 não é um arquivo de backup de domínio válido.",
    'dumps_list__page_title' => "Armazenamento de ficheiros de cópias de segurança",
    'dumps_upload__page_title' => "A carregar ficheiros de cópias de segurança para armazenamento",
    'dumps_list__repository_is_not_exist' => "Armazenamento dos ficheiros de cópias de segurança não existe.",
    'dumps_list__unable_to_remove' => "Impossível remover arquivo de backup: %1",
    'dumps_list__dumpfile_can_conflict' => "O nome de ficheiro especificado entra em conflito com o ficheiro %1 Por favor, introduza outro nome de ficheiro.",
    'dusr_ed__allow_dl_usr_access' => "Permitir o acesso ao administrador do domínio",
    'dusr_ed__information' => "Editar as propriedades do Administrador de Domínio %1",
    'dusr_ed__locale' => "Idioma do administrador de domínio",
    'dusr_ed__skin' => "Skin do interface do administrador de domínio",
    'dusr_ed__personal_information' => 'Formulário do cliente',
    'ess__error' => "Erro",
    'example__' => "Exemplo: %1",
    'extras__allow_certificate_purchasing' => "Permitir aquisição de certificado",
    'extras__allow_domain_registration' => "Permitir registo de domínio",
    'extras__allow_extras' => "Permitir serviços extra",
    'extras__buy_new_key' => "A sua licença atual não permite que modifique estes objetos.",
    'extras__setup_services' => "Configurar serviços adicionais",

    'firewallmainform__title' => 'Gestão da Firewall',
    'firewallmainform__interfaces_list_legend' => 'Lista de interfaces de rede',
    'firewall__interfacelist' => 'Interfaces de rede',
    'interfacelist__enabled' => 'F',
    'interfacelist__status' => 'I',

    'interfacelist__interface' => 'Nome de Interface',
    'interfacelist__type' => 'Tipo de Interface',
    'bt_rule_add' => 'Adicionar Regra da Firewall',
    'bt_panic' => 'Modo de Pânico',
    'firewallmainform__rules_list_legend' => 'Listagem das Regras',
    'firewall__rulelist' => 'Regras',
    'rulelist__enable' => 'F',
    'rulelist__name' => 'Nome',
    'rulelist__allow_input_from_any_port_profiles' => '[Permitir] ligações de [todos] na porta [%1], perfis: [%2]',
    'rulelist__allow_input_from_port_profiles' => '[Permitir] ligações de [%1] na porta [%2], perfis: [%3]',
    'rulelist__block_input_from_any_port_profiles' => '[Recusar] ligações de [todos] na porta [%1], perfis: [%2]',
    'rulelist__block_input_from_port_profiles' => '[Recusar] ligações de [%1] na porta [%2], perfis: [%3]',
    'rulelist__description' => 'Descrição',
    'ruleeditform__add_title' => 'Adicionar Nova Regra',
    'ruleeditform__properties' => 'Propriedades da regra',
    'ruleeditform__name' => 'Nome de regra',
    'ruleeditform__port' => 'Permitir conexões através da seguinte porta ou gama de portas',
    'ruleeditform__protocol_tcp' => 'Protocolo TCP',
    'ruleeditform__protocol_udp' => 'Protocolo UDP',
    'ruleeditform__edit_title' => 'A editar uma Regra da Firewall',
    'ruleeditform__newrule' => 'Nova regra',
    'ruleeditform__enabled' => 'Ligue a regra',
    'ruleeditform__profiles_text' => 'Perfis',
    'ruleeditform__profiles_domain_text' => 'Domínio',
    'ruleeditform__profiles_private_text' => 'Privado',
    'ruleeditform__profiles_public_text' => 'Público',
    'ruleeditform__action' => 'Ação',
    'ruleeditform__action_allow' => 'Permitir',
    'ruleeditform__action_deny' => 'Negar',
    'ruleeditform__from' => 'Remover endereços',
    'ruleeditform__from_add' => 'Adicionar um endereço IP ou uma rede:',
    'ruleeditform__profiles_hint' => 'Deve selecionar pelo menos um perfil.',
    'ruleeditform__port_hint' => 'Por exemplo: 1000 ou 1000-1051',
    'ruleeditform__from_hint' => 'Por exemplo: 192.168.0.1 ou 192.168.0.0/16',
    'ruleeditform__ip_any' => 'Tudo',
    'firewall_from_add' => 'Adicionar',
    'firewall_from_remove' => 'Eliminar',
    'firewall_from_clear' => 'Limpar Lista',
    'bt_firewall_from_add' => 'Adicionar',
    'bt_firewall_from_remove' => 'Eliminar',
    'bt_firewall_from_clear' => 'Limpar Lista',
    'ruleeditform__name_is_required' => 'Especifique o nome da regra.',
    'ruleeditform__profiles_is_required' => 'Selecione pelo menos um perfil.',
    'ruleeditform__invalid_action' => 'A ação especificada é inválida. Os valores permitidos são "Permitir" ou "Recusar".',
    'ruleeditform__invalid_ip' => 'O endereço IP ou rede especificados são inválidos.',
    'ruleeditform__invalid_protocol' => 'O protocolo especificado é inválido. Os valores permitidos são "udp" ou "tcp".',
    'ruleeditform__invalid_port' => 'A porta especificada é inválida. Os valores permitidos são 1000 ou 1000-1051',
    'firewall__panic_configuration' => 'Quer realmente ligar o Modo de Pânico? Os utilizadores não poderão aceder aos seus domínios.',
    'firewall__reset_configuration' => 'Quer realmente reiniciar as configurações da Firewall parar a configuração inicial?',
    'rulelist__remove_selected' => 'Deseja remover as regras selecionadas?',

    'filemanager__items' => 'itens no diretório %1',
    'filemanager__items_paging' => 'itens no diretório %1',

    'get_password__encrypted_password' => "Impossível enviar informações da palavra-passe: a palavra-passe está gravada de forma encriptada.",
    'get_password__mail_error' => "Ocorreu um erro durante a tentativa de enviar a palavra-passe para o e-mail %1: %2",
    'get_password__mail_ok' => "A palavra-passe foi enviada com sucesso para o e-mail: %1",
    'get_password__message' => "O seu nome de utilizador para aceder ao sistema: %1\nA sua palavra-passe é %2",
    'get_password__subject' => "A senha para acesso ao sistema",
    'groups__available' => "Grupos de e-mail disponíveis",
    'groups__groups_for_mailname' => "Grupos de correio aos quais a conta de correio %1 pertence",
    'groups__member_of' => "Membro dos seguintes grupos de e-mail",
    'help__help_area' => "Área de ajuda.",
    'hst_def__auth_disabled' => "proibido",
    'hst_def__auth_enabled' => "permitido",
    'hst_def__change_curr_dns_ip' => "O endereço IP atual do registo DNS A será alterado",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Nenhum dos endereços IP do registo DNS A coincide com o endereço IP designado para a conta de alojamento a ser criada",
    'hst_def__dest_url' => "URL destino",
    'hst_def__disk_quota' => "Quota de disco",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "O limite de espaço em disco que você está tentando definir é excedido pelo limite de espaço em disco no directório de entrada de FTP anónimo. O limite de espaço em disco no directório de entrada de FTP anónimo não pode exceder o limite de espaço em disco do domínio.",
    'hst_def__frame_forwarding_definition' => "Atribuição de reendereçamento por janela para o domínio %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Atenção: O utilizador FTP %1 é utilizado numa conta de alojamento mas não existe no sistema.",
    'hst_def__hst_type_is_not_defined' => "Tipo de alojamento não está definido",
    'hst_def__ip_based' => "Baseado em IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "A transferência desta conta de alojamento para um endereço IP partilhado irá indisponibilizar o FTP Anónimo do domínio. Quer prosseguir ?",
    'hst_def__password_is_invalid_password_syntax' => "A senha não é válida.\nNão use aspas, espaços e caracteres de alfabetos nacionais na sua senha.\nO comprimento da senha deverá ser de 5 a 14 caracteres. A senha não deverá conter o nome do utilizador.",
    'hst_def__shell' => "Acesso SSH ao shell do servidor no utilizador do sistema de assinatura",
    'hst_def__shell_windows' => "Acesso ao Desktop remoto para o servidor sob o usuário do sistema do assinante",
    'hst_def__standard_forwarding_definition' => "Atribuição do reendereçamento padrão para o domínio %1",
    'hst_def__title_name_based' => "Baseado em nome",
    'hst_def__unable_create/update_physic_hst' => "Impossível criar/actualizar alojamento físico: %1",
    'hst_def__unable_create/update_std_fwd' => "Impossível criar/actualizar reendereçamento padrão: %1",
    'hst_def__unable_create_forwarding_myself' => "Impossível criar um reendereçamento para o próprio domínio.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Impossível permitir a utilização de um único directório para guardar o conteúdo SSL/TLS e não-SSL/TLS: O suporte ao SSL/TLS está desligado..",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Não foi possível ligar o suporte de SSL: não existe um certificado de SSL/TLS instalado.",
    'hst_def__url_is_invalid' => "URL é inválida.",
    'hst_def__virtual_host_access' => "Acesso ao alojamento virtual para o domínio %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ATENÇÃO. Este alojamento virtual está a usar um endereço IP inexistente para alojamento.",
    'hst_def__you_have_no_ips' => "Não tem endereços IP disponíveis e não tem permissão para criar alojamento baseado em nome.",
    'hst_sel__header' => "Para alojar um site Web nesta máquina, selecione a opção de alojamento Físico.\n Para configurar o reencaminhamento de um domínio para um site noutra máquina, selecione a opção de Reencaminhamento de Janela ou Reencaminhamento padrão.\n Com o reencaminhamento padrão, um utilizador é direcionado para o site e o endereço URL do site de destino é apresentado no browser do utilizador, assim o utilizador sabe que foi reencaminhamento. Com o reencaminhamento em janela, o utilizador é reencaminhamento para o site sem se aperceber que o site reside, na realidade, noutro local.",
    'hst_sel__physical_hst' => "Alojamento Físico",
    'hst_sel__select_hst_type' => "Seleccione um tipo de alojamento para o domínio",
    'hst_sel__select_hst_type_warning' => "Seleccione um tipo de alojamento para o domínio",
    'hst_sel__hosting_exists' => "Impossível criar o alojamento, já se encontra configurado para este domínio. Será redireccionado à página de administração de Alojamento.",
    'hst_sel__standard_frw' => "Reendereçamento padrão",
    'hst_sel__frame_frw' => "Re-endereçamento em Janela",
    '__frame_frw' => "Re-endereçamento em Janela",
    '__hosting_exists' => "Impossível criar o alojamento, já se encontra configurado para este domínio. Será redireccionado à página de administração de Alojamento.",
    '__choose_hst_type' => "Seleccione o tipo de alojamento que requer.",
    '__no_hst_conf' => "Não existe nenhum tipo de alojamento configurado para seu domínio.",
    '__physical_hst' => "Alojamento Físico",
    '__select_hst_type' => "Seleccione um tipo de alojamento para o domínio",
    '__standard_frw' => "Reendereçamento padrão",
    '__warning' => "Atenção! Todos os parâmetros previamente fixados serão perdidos. Tem a certeza que quer mudar o tipo de alojamento?",
    'i_cl_off' => "Cliente está inativo.",
    'i_cl_off_by_admin' => "A conta de cliente foi suspensa pelo administrador do servidor.",
    'i_cl_off_expired' => "Conta do cliente expirou.",
    'i_cl_on' => "Cliente está ativo.",

    'icf__title' => 'Firewall de Conexão Internet',
    'icf__if_legend' => 'Interfaces',
    'icf__mode' => 'Modo',

    'invalid_value' => 'O valor é inválido',

    'ip_addr__already_exists' => "Endereço IP %1 já existe.",
    'ip_addr__cant_add' => "IP %1 não existe ou pertence ao Repositório de IP de outro cliente",
    'ip_addr__cl_list_for_ip' => "Revendedores que usam %1 endereço de IP %2",
    'ip_addr__cl_list_for_ip_add' => "Adicionar endereço de IP para conjunto de revendedores",
    'ip_addr__domains_list_for_ip' => "Websites que utilizam %1 endereço de IP %2",
    'ip_addr__ip_used_by_hst_or_frw' => "O endereço IP %1 é usado para alojamento ou reendereçamento.",
    'ip_addr__only_one_ip_and_client_have_domain' => "Impossível remover este endereço IP porque existem domínios alojados neste endereço IP.",
    'ip_addr__remove_ip_addr' => "Estes endereços IP serão removidos do sistema:",
    'ip_addr__select_clients' => "Selecione clientes",
    'ip_addr__select_ip_addr_to_remove' => "Seleccione o endereço IP a ser removido.",
    'ip_addr__unallowed_by_license' => "Esta cópia do Plesk não está licenciada para trabalhar no endereço de IP %1.\nOs intervalos de IP permitidos são: %2.",
    'ip_alias__interface' => "Interface",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "Endereço IP para alojamento virtual baseado em nome %1 é inválido.",
    'ip_alias__invalid_ip_or_netmask' => "Par endereço IP/máscara da rede é inválido.",
    'ip_alias__orig_ip_can_not_be_deleted' => "O endereço IP %1 é o IP original do servidor, por isso não o pode remover.",
    'ip_alias__ip_is_invalid' => "Endereço IP %1 é inválido.",
    'ip_alias__ip_mask_is_invalid' => "Máscara de IP %1 é inválida.",
    'ip_alias__ip_not_exist' => "O endereço IP %1 não existe.",
    'ip_alias__ip_address_and_mask' => 'endereço IP e máscara da rede',
    'ip_alias__mask' => "Máscara de sub-rede",
    'ip_alias__remove_selected_ip_aliases?' => "Tem a certeza de que quer remover os endereços IP seleccionados?",
    'ip_alias__select_ip' => "Seleccione no mínimo um endereço IP da lista para removê-lo.",
    'ip_alias__this_ip_used_for_domain' => "(%1) este endereço IP é usado para o domínio %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) este endereço IP é utilizado para alojamento virtual baseado em nome.",
    'ip_alias__unable_add_ip' => "Impossível adicionar o IP: %1",
    'ip_alias__unable_remove_ip' => "Impossível remover o(s) IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Você não pode alterar o tipo de endereço IP para partilhado, pois isto tornará o FTP anónimo para o domínio '%1' indisponível.",
    'ip_ctrl__ip_addr' => "Endereço IP %2 na interface %1",
    'ip_ctrl__ip_exists_many_pools' => "Não pode alterar o tipo de endereço IP. O endereço IP pertence aos repositórios de vários clientes ao mesmo tempo.",
    'ip_ctrl__ssl_cert' => "Certificado SSL/TLS",
    'ip_pool__ip_address_is_absend_in_pool' => "Endereço IP está faltando.",
    'ip_pool__ip_pool_for_client' => "Repositório de IP do cliente %1",
    'ip_pool__no_cliens_avail' => "Não há clientes disponíveis",
    'ip_pool__no_vacant_ips' => "Não existe um IP disponível",
    'ip_pool__pool_is_empty' => "O repositório de IP's está vazio.",
    'ip_pool__remove_ip_addr' => "Estes endereços IP serão removidos do repositório %1:",
    'ip_pool__select_free_ips' => "IP's livres",
    'limit__date_in_past' => "Período de validade é inválido. %1 é no passado.",
    'limit__enter_date' => "Insira data",
    'limit__max_db' => "Bases de dados",
    'limit__name_disk_space' => "espaço em disco",
    'limit__name_max_box' => "caixas de correio",
    'limit__name_max_db' => "Bases de dados do MySQL",
    'limit__name_max_dom' => "domínios",
    'limit__name_max_maillists' => "listas de envio",
    'limit__name_max_subdom' => "subdomínios",
    'limit__name_max_traffic' => "tráfego",
    'limit__name_max_wu' => "utilizadores de rede",
    'limit__name_mbox_quota' => "Quota da caixa de correio",
    'limit__name_max_mn' => "contas de correio",
    'limit__name_max_cl' => 'clientes',
    'limit__name_total_mboxes_quota' => "quota total da caixa de correio",
    'limit__name_mysql_dbase_space' => "Espaço da base de dados MySQL",
    'limit__name_mssql_dbase_space' => "Espaço da base de dados MSSQL",
    'limit__name_expiration' => 'data de validade',

    'locale_upload__title' => 'Adicionar Idioma',
    'locale_upload__file_name' => 'Caminho para arquivo local do pacote de idioma',
    'locale_upload__unable_to_install' => 'Não foi possível instalar o arquivo do pacote de idioma',
    'locale_upload__wrong_package' => 'O ficheiro carregado não contém um pacote de língua válido para esta versão do Plesk.',
    'locale_upload__wrong_locale' => 'O ficheiro carregado não contém um pacote de idioma válido.',

    'locales_remove__title' => 'Remoção de Idiomas',
    'locales_remove__select_locales_for_remove' => 'Seleccione os idiomas a serem removidos.',
    'locales__can_not_remove' => 'Não foi possível remover o pacote de idioma para o idioma %1: %2',

    'ma__create_title' => 'Criar nome alternativo de e-mail para %1',
    'ma__edit_title' => "Editar nome alternativo de e-mail %1",
    'ma__enter_new_alias' => "insira novo nome alternativo.",
    'ma__invalid_alias' => "Nome alternativo de e-mail inválido.",
    'ma__mail_aliases_mailname' => "Nomes alternativos de correio para a conta de correio %1",
    'ma__mailname_does_not_exist' => "A conta de correio não existe.",
    'ma__select_ma_for_remove' => "Seleccione nomes alternativos de e-mail a serem removidos.",
    'ma__unable_to_add_new_ma' => "Impossível adicionar um nome alternativo de e-mail: %1",

    'mail__white_list' => "Lista Branca",
    'mail__white_list_add' => 'Adicionar rede',
    'mail__white_list_remove' => 'As seguintes redes serão removidas:',
    'mail__white_list_remove_warning_webmail' => 'Ao remover as seguintes redes, pode impedir o envio de e-mail a partir do Webmail: %1.',
    'mail__white_list_member' => 'Redes permitidas',
    'mail__white_list_empty_selection_for_remove' => 'Seleccione as entradas a serem removidas.',
    'mail_queue__not_allowed_by_license_key' => 'A chave de licença não permite a gestão da fila de correio.',
    'maillist__' => "Lista de envio %1",
    'maillist__already_exists' => "A lista de envio já existe.",
    'maillist__mail_alias_already_exists_in_this_domain' => "O nome alternativo de correio %1 já existe neste domínio",
    'maillists__' => "Listas de envio %1",
    'maillists__limit_cl_max_maillists' => "O limite do número de listas de envio foi alcançado para este cliente (limite: %1 utilizado: %2)",
    'maillists__limit_dom_max_maillists' => "O limite do número de listas de envio foi alcançado para este domínio.",
    'maillists__list' => "Listas de envio",
    'maillists__mailman_not_installed_or_conf' => "Extensões do servidor Mailman não estão actualmente instaladas\nou bem configuradas no servidor. Contacte o administrador do servidor para ter as extensões do servidor Mailman instaladas ou bem configuradas.",
    'maillists__status' => "O serviço de envio foi ligado",
    'maillists__unable_to_delete__' => "Impossível eliminar a lista de envio: %1",
    'maillists__disabled_text' => 'Não pode administrar as listas de envio porque a componente do servidor Mailman não está instalada ou não está configurada.',
    'maillist_member__already_exists' => 'O membro da lista de envio já existe.',
    'maillist_member__not_exists' => 'Esse utilizador não existe na lista de envio.',
    'mailserver_switching_warning' => "Aviso!\n\nEstá quase a modificar o modo como o servidor executa a entrega do email.\nEsta operação deve ser efectuada somente na configuração inicial e não garante que todos os parâmetros serão salvos.\nCaso o servidor já tenha sido configurado pode provocar conflitos.\nNão conseguirá transferir os seus emails a partir do servidor de mail actual.\nSe este servidor estiver em produção, será melhor reconsiderar seriamente cancelar esta modificação.",
    'manager__access_denied' => "Acesso negado: %1",
    'manager__admin' => "Administrador",
    'manager__client' => 'Cliente',
    'manager__domain' => "Domínio",
    'manager__domain_cl_limit_exceeding' => "O limite do número de domínios está atingido nesta conta de cliente",
    'manager__domain_is_not_yours' => "domínio %1 não pertence a você",
    'manager__domain_key_limit_exceeding' => "O limite de criação de domínios definido pela sua chave de licença foi atingido",
    'manager__no_perm_to_call' => "Você não tem permissão para chamar %1",
    'manager__no_perm_to_create_domains' => "Você não tem permissão para criar domínios",
    'manager__no_perm_to_modify_domain' => "Você não tem permissão para modificar domínio %1",
    'manager__no_perm_to_modify_domains' => "Você não tem permissão para modificar domínios",
    'manager__no_perm_to_remove_domain' => "Você não tem permissão para remover domínio %1",
    'manager__no_perm_to_remove_domains' => "Você não tem permissão para remover domínios",
    'manager__node_doesnt_exist' => "%1 não existe.",
    'manager__user_disabled' => "A sua conta foi suspensa. Não pode operar o sistema.",
    'mail_quota_unsupported' => "Não suportado pelo servidor de e-mail",
    'mbox_quota_unsupported' => "Não suportado pelo servidor de e-mail",
    'mn__create_title' => "Criar conta de correio",
    'mn__edit_title' => "Configurações",
    'mn__files_list_title' => "Arquivos Anexados",
    'mn__files_remove' => "Remover ficheiros do repositório de anexos. Estes ficheiros são possivelmente usados por respostas automáticas. Eles serão removidos de ambos: os repositórios e as respostas automáticas que fazem uso destes ficheiros.",
    'mn__files_select_for_remove' => "Seleccione arquivos a serem removidos.",
    'mn__mail_alias_form' => "Formulário de nome alternativo de e-mail",
    'mn__mail_aliases_list' => "Nomes alternativos de e-mail",
    'mn__mailbox' => "Administração da caixa de correio",
    'mn__unable_define_mn' => "Impossível configurar as contas de correio: %1",
    'mn__unable_remove_mbox_quota' => "Impossível remover quota de caixa de mensagens: %1",
    'mn__upload_file' => "Carregar arquivo",
    'mn_edit__attach_filename_changed' => 'O nome do ficheiro carregado %1 foi alterado para %2, porque o nome original não contém só carateres ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Você deve adicionar um membro de grupo de e-mail antes de disponibilizar o grupo de e-mail.",
    'mn_edit__add_resp_or_turn_off_box' => "Deve adicionar uma resposta automática ou não selecionar a caixa de verificação da resposta automática.",
    'mn_edit__attachments' => "Anexos",
    'mn_edit__dom_quota_less_then_quota' => "O tamanho desta caixa de correio não pode exceder o limite do espaço de disco atribuído ás caixas de correio deste domínio.",
    'mn_edit__enter_external_rcpnt_email' => "Insira o endereço de e-mail do membro do grupo de e-mail externo",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Você deve redirecionar correio ou desselecionar a caixa de verificação de redirecionamento.",
    'mn_edit__ext_rcpnt_email_invalid' => "Endereço de e-mail do destinatário externo é inválido.",
    'mn_edit__file_exists' => "Arquivo já existe. Substituir?",
    'mn_edit__files_deld_from_repository' => "Estes ficheiros e respostas automáticas os contendo serão removidos do repositório. Deseja continuar?",
    'mn_edit__mail_name' => "Conta de correio",
    'mn_edit__mail_name_invalid' => "O nome da conta de correio é inválido.",
    'mn_edit__mail_redir' => "Redirecionamentos de e-mail",
    'mn_edit__mail_redir_add' => "Adicionar um membro ao Grupo de Correio",
    'mn_edit__mail_resps' => "Respostas automáticas",
    'mn_edit__mailbox' => "Caixa de Correio",
    'mn_edit__enable_mailbox' => "Caixa de Correio",
    'mn_edit__mailgroup' => "Grupo de e-mail",
    'mn_edit__mailgroup_addresses' => "Membros de Grupo de e-mail",
    'mn_edit__mailgroup_disabled' => "Apenas disponível após criar uma conta de correio.",
    'mn_edit__max_dom_quota' => "Predefinição para o domínio (%1)",
    'mn_edit__mbox_quota_invalid' => "O tamanho especificado da caixa de correio está incorrecto.",
    'mn_edit__new_resp_name' => "Novo nome de resposta automática",
    'mn_edit__no_autoresponders' => "Você deve adicionar no mínimo uma resposta automática antes de ligar ou desligar o serviço de respostas automáticas.",
    'mn_edit__no_file_sel' => "Não seleccionou um arquivo.",
    'mn_edit__no_mail_addresses' => "Nenhum endereço de e-mail foi inserido ou selecionado.",
    'mn_edit__none' => "Nenhum",
    'mn_edit__not_create_pass' => "Não será criada a palavra-passe para esta conta.\nSem palavra-passe, o utilizador não será capaz de visualizar e/ou enviar e-mail.",
    'mn_edit__redir_email_invalid' => "O endereço final de redirecionamento é inválido.",
    'mn_edit__redirect_addr' => "Redirecionar endereço",
    'mn_edit__remove_autoresp?' => "Você tem certeza de que deseja remover a resposta automática?",
    'mn_edit__remove_rcpnts?' => "Você tem certeza de que deseja remover estes receptores:",
    'mn_edit__repository' => "Repositório",
    'mn_edit__resps_attach' => "Ficheiros anexos de resposta automática",
    'mn_edit__select_rcpnt_from_list' => "Seleccione no mínimo um recipient da lista para remover.",
    'mn_edit__select_registered_users' => "Seleccione os utilizadores registados",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Você escolheu ter uma caixa de correio mas não definiu a senha para a mesma.",
    'mn_edit__unable_act_deact_mail_group' => "Impossível ativar/desativar grupo de e-mail: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Impossível ativar/desativar redirecionamento: %1",
    'mn_edit__unable_act_deact_postbox' => "Impossível ativar/desativar a caixa de correio: %1",
    'mn_edit__unable_act_deact_resp' => "Impossível ativar/desativar respostas automáticas: %1",
    'mn_edit__unable_add_attach' => "Impossível adicionar arquivo anexo: %1",
    'mn_edit__unable_add_mail_group_member' => "Impossível adicionar membro de grupo de e-mail: %1",
    'mn_edit__unable_add_resp' => "Impossível adicionar resposta automática: %1",
    'mn_edit__unable_change_mail_name' => "Impossível mudar o nome de correio: %1",
    'mn_edit__unable_deactivate_mail_group' => "Impossível desactivar grupo de e-mail: %1",
    'mn_edit__unable_deactivate_resp' => "Impossível desativar respostas automáticas: %1",
    'mn_edit__unable_define_resp_id' => "Impossível definir ID da resposta automática: %1",
    'mn_edit__unable_remove_attach' => "Impossível remover arquivo(s) anexo(s): %1",
    'mn_edit__unable_remove_autoresp' => "Impossível remover respostas automáticas: %1",
    'mn_edit__unable_remove_mail_group_member' => "Impossível remover membros de grupo de e-mail: %1",
    'mn_edit__wrong_way' => 'As mensagens enviadas a %1 não vão ser entregues, porque esta conta de correio não tem uma caixa de correio nem o reendereçamento ligado.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'A caixa de correio no endereço %1 foi desligada. As mensagens na caixa de correio não foram eliminadas, mas não as poderá obter pelos protocolos IMAP ou POP3.',
    'mn_list__mail_names_for_domain' => "Contas de correio no domínio %1",
    'mn_list__sa_cannot_unable' => "Impossível ligar o filtro de spam",
    'mn_list__tab_cp_access' => "N",
    'mn_list__tab_title_client' => 'Cliente',
    'mn_list__tab_title_domain' => 'Domínio',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nome",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "F",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Impossível remover as contas de correio: %1",
    'no_psa_mails_matched' => "Nenhumas contas de correio coincidem com o critério inserido.",
    'module_upload__module_was_installed' => 'Este módulo já se encontra instalado. Se deseja instalar uma versão mais recente deste módulo, desinstale este módulo através do Plesk e tente instalar de novo.',
    'module_upload__unable_to_install' => 'Não foi possível instalar o arquivo do pacote do módulo',
    'module_upload__wrong_package' => 'O ficheiro carregado não contém um pacote de módulo suportado.',
    'module_upload__wrong_module' => 'O ficheiro carregado não contém um pacote de módulo.',

    'news_articles_title' => 'Notícias do Plesk',
    'notification_text__invalid_subject_length' => "Comprimento do assunto do aviso inválido. Deve ser de 1 a 255 caracteres.",
    'notification_text__invalid_text_length' => "O comprimento do texto de notificação não é válido. Deve ser de 1 a 65533 caracteres.",
    'notification_text__subject' => "Assunto do aviso",
    'notification_text__text' => "Texto de notificação",
    'notification_text__title' => "Editar notificação",
    'notification_text__unable_set_text' => "Impossível modificar texto de notificação:",

    'odbc__cant_add_dsn' => "Impossível adicionar DSN %1: %2",
    'odbc__cant_build_connection_string' => "Impossível conectar usando os parâmetros especificados, por favor tente novamente usando diferentes parâmetros. Utilidade retornou: %1",
    'odbc__cant_connect' => "Impossível conectar à fonte de dados usando as configurações definidas. Servidor retornou: %1",
    'odbc__cant_delete_dsn' => "Impossível eliminar DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Incapaz de adquirir informações sobre os drivers",
    'odbc__cant_get_drivers' => "Impossível obter uma lista dos drivers ODBC: %1",
    'odbc__cant_get_list' => "Impossível obter uma lista dos DSNs existentes: %1",
    'odbc__cant_get_servers_list' => "Incapaz obter uma lista de servidores",
    'odbc__cant_open_info_file' => "Não pode abrir o ficheiro com a informação dos drivers de ODBC",
    'odbc__cant_parse_string' => "Impossível analisar a string de conexão",
    'odbc__connect_success' => "Conexão realizada com sucesso",
    'odbc__driver_not_set' => "Driver não está definido",
    'odbc__driver_or_name_not_set' => "Driver ou nome da conexão ODBC não foram definidos",
    'odbc__dsn_already_exists' => "Um DSN com este nome (%1) já existe no sistema",
    'odbc__dsn_not_exists' => "Este DSN não existe",
    'odbc__enter_connection_params' => "Configure uma Conexão ODBC",
    'odbc__enter_dsn_name' => "Insira nome do DSN",
    'odbc__invalid_dsn_name' => "Sintaxe errada para nome de conexão ODBC (%1): por favor use apenas símbolos alfanuméricos.",
    'odbc__no_such_driver' => "O driver ODBC com este nome (%1) não é suportado",
    'odbc__remove_page_title' => "As seguintes ligações ODBC DSN serão removidas:",
    'odbc__select_dsn_to_remove' => "Seleccione DSNs a serem removidas.",
    'odbc__unknown_driver' => "O nome do driver é desconhecido (%1)",
    'odbc_add_new' => "Adicionar um conexão DSN",
    'odbc_driver' => "Driver",
    'odbc_dsn_description' => "Descrição da conexão",
    'odbc_dsn_list' => "Conexões ODBC DSN",
    'odbc_dsn_name' => "Nome da conexão",
    'odbc_dsn_system' => "Sistema DSN",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => 'Adicionar um ODBC DSN',
    'odbc_req_field_not_set' => "Não foram fornecidos os parâmetros necessários.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'Caminho do ficheiro da base de dados',
    'odbc__access_pagetimeout' => 'O período de tempo, em decimas de segundo, que uma página não utilizada fica na buffer. Esta opção é aplicada a todas as fontes de dados que utilizam o driver do Microsoft Access.',
    'odbc__access_maxbuffersize' => 'O tamanho da buffer interna, em KB, alinhados ao limite de 256 KB.',
    'odbc__access_readonly' => 'Marca a base de dados como só de leitura para não permitir actualizações.',
    'odbc__access_exclusive' => 'Marca a base de dados como exclusiva para não permitir a partilha de actualizações.',
    'odbc__access_safetransactions' => 'Caso 0, predefinido, todas as transações são efetuadas imediatamente. Caso 1, todas as transações só são gravadas no disco após uma operação de escrita (commit operation), mas o desempenho é ligeiramente reduzido.',
    'odbc__access_threads' => 'O número de operações em background que o motor irá utilizar.',
    'odbc__access_maxscanrows' => "O número de linhas a serem varridas quando definir o tipo de dados de uma coluna baseado nos dados existentes.",
    'odbc__access_implicitcommitsync' => 'Especifica como as modificações efectuadas fora de uma transacção são escritas na base de dados.',
    'odbc__access_usercommitsync' => 'Especifica se o driver do MS Access executará as transacções explícitas, definidas pelo utilizador, assincronamente.',
    'odbc__mssql_server' => 'Servidor',
    'odbc__mssql_uid' => 'ID de Login',
    'odbc__mssql_pwd' => 'Senha',
    'odbc__mssql_database' => 'Base de dados predefinida para a fonte de dados ODBC',
    'odbc__mssql_app' => 'Nome da aplicação',
    'odbc__mssql_wid' => 'ID da estação de trabalho',
    'odbc__mssql_language' => 'Linguagem Nacional a utilizar por default',
    'odbc__mssql_oemtoansi' => 'Este parâmetro especifica se deve converter os carateres ANSI em valores OEM',
    'odbc__mysql_server' => 'O nome de host do servidor de MySQL',
    'odbc__mysql_database' => 'A base de dados predefinida',
    'odbc__mysql_user' => 'O nome de utilizador utilizado para ligar ao MySQL',
    'odbc__mysql_password' => 'A palavra-passe da conta de utilizador no servidor',
    'odbc__mysql_port' => 'A porta TCP/IP a utilizar se o servidor não for o localhost',
    'odbc__mysql_socket' => 'O \'Windows named pipe\' ao qual ligar se o servidor for localhost',
    'odbc__mysql_option' => 'Opções que especificam como MyODBC deve funcionar. Veja <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'Caminho do Ficheiro da BD',
    'odbc__excel_defaultdir' => 'Directório de dados predefinido',
    'odbc__excel_fil' => 'Versão da Base de Dados',
    'odbc__excel_maxbuffersize' => 'Tamanho Máximo da Buffer',
    'odbc__excel_pagetimeout' => 'Tempo de ócio da página',

    'pb__aliases' => "Nomes alternativos",
    'pb__anonftp' => "FTP Anónimo",
    'pb__autoinstaller_releases' => 'Sistema de actualizações',
    'pb__cert' => "Certificados",
    'pb__cl_pool' => "Endereços IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Configurações",
    'pb__cl_rpt' => "Relatório",
    'pb__cl_rpt_list' => "Personalizar",
    'pb__cl_templates' => "Modelos de cliente",
    'pb__cl_traffic' => "Tráfego",
    'pb__cl_traffic_history' => "Histórico de tráfego",
    'pb__cl_traffic_of' => "Tráfego de %1",
    'pb__client' => "%1",
    'pb__clients' => "Clientes",
    'pb__comp_info' => "Componentes do Servidor",
    'pb__common_acl' => 'Permitir a transferência ACL',
    'pb__cp_access' => "Acesso",
    'pb__crontab' => "Agenda de Tarefas",
    'pb__scheduler' => "Agenda de Tarefas",
    'pb__custom_buttons' => "Personalizar teclas",
    'pb__databases_db' => 'Bases de dados',
    'pb__sqlservers_db' => 'Servidores SQL',//to check
    'pb__db' => "Bases de dados",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Servidores de base de dados',
    'pb__dl_usr_ed' => "Administrador de domínio",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Limites do domínio",
    'pb__dom_pref' => "Configurações",
    'pb__dom_sum_report' => "Sumário de domínio",
    'pb__dom_templates' => "Modelos de Domínio",
    'pb__dom_traffic' => "Tráfego de %1",
    'pb__dom_traffic_history' => "Histórico do Tráfego",
    'pb__domains' => "Domínios",
    'pb__domain_aliases' => 'Nomes alternativos de Domínio',
    'pb__dumps_list' => "Armazenamento de ficheiros de cópia de segurança",
    'pb__forwarding_setup' => "Configurações de Reendereçamento",
    'pb__filemanager' => "Gestor de Ficheiros",
    'pb__ip_aliasing' => "Endereços IP",
    'pb__ip_clients' => "Remover endereços IP",
    'pb__license_management' => 'Gestão da Licença',
    'pb__locales' => 'Pacotes de idiomas',
    'pb__log_files' => "Arquivos de log",
    'pb__mail' => 'Correio.',
    'pb__mail_blocked_domains' => 'Lista negra',
    'pb__mail_name_files' => "Arquivos anexos",
    'pb__mail_name_redirects' => "Redirecionamentos de e-mail",
    'pb__mail_name_resp_attach_add' => "Novo anexo",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Respostas automáticas",
    'pb__mail_names' => "Correio.",
    'pb__mail_white_list' => 'Lista branca',
    'pb__maillists' => "Listas de envio",
    'pb__mimetypes' => 'MIME Type',
    'pb__modules' => 'Módulos',
    'pb__modules_management' => 'Administração de Módulos',
    'pb__notifications' => "Avisos",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Configurações de alojamento físico",
    'pb__prtd_dirs' => "Diretórios Protegidos",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Relatório",
    'pb__report_auto' => "Horário de entrega para %1",
    'pb__report_list' => "Personalizar",
    'pb__server' => "Servidor",
    'pb__sessions' => "Sessões",
    'pb__sapp_pool' => "Repositório de Aplicações Web",
    'pb__siteapp_install' => 'Instalação da aplicação web',
    'pb__site_app_pkgs' => 'Aplicações Web',
    'pb__site_apps' => "Aplicações Web",
    'pb__additional_key_info' => 'Propriedades da Chave',
    'pb__additional_key_properties' => 'Propriedades da Chave',
    'pb__skeleton' => 'Modelo de Alojamento Virtual',
    'pb__skins' => 'Skin',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtro de Spam",
    'pb__statistics' => "Estatísticas",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomínios",
    'pb__templates' => "Modelos",
    'pb__virtualdirs' => 'Directórios virtuais',
    'pb__web_users' => "Utilizadores de rede",
    'pb__webalizer_preferences' => 'Preferências das estatísticas de rede',
    'pdir__enter_dir_name' => "Insira o nome do directório.",
    'pdir__invalid_hst' => "Tipo de alojamento inválido. O tipo tem que ser físico.",
    'pdir__pd_id_is_undefined' => "ID de directório protegido indefinido.",
    'pdir__pdir_exist' => "Um directório com este nome já está protegido.",
    'pdir__pdir_not_exist' => "Directório protegido não existe.",
    'pdir__pdir_usr_not_exist' => "O utilizador de directório protegido não existe.",
    'pdir__prdirs_for_domain' => "Diretórios Protegidos Sob o Website %1",
    'pdir__prdirs_for_subdomain' => "Directórios protegidos para o sub-domínio %1",
    'pdir__remove_pdir_usrs' => "Serão removidos os seguintes utilizadores de diretório protegido %2 no domínio %1:",
    'pdir__remove_pdir_usrs_on_subdom' => "Os seguintes utilizadores do diretório protegido %2 no sub-domínio %1 serão removidos:",
    'pdir__remove_pdirs_on_dom' => "Esta operação resultará na remoção da proteção dos diretórios do domínio %2 do cliente %1. Os diretórios não serão eliminados.",
    'pdir__remove_pdirs_on_subdom' => "Esta operação resultará na remoção da proteção dos diretórios do sub-domínio %1 Os diretórios não serão eliminados.",
    'pdir__select_pdir_usrs_for_remove' => "Seleccione os utilizadores de directório protegido para remoção.",
    'pdir__select_pdirs_to_remove' => "Seleccione os directórios para remover a protecção.",
    'pdir__unable_define_pdir_users' => "Impossível definir utilizadores de directório protegido.",
    'pdir__unable_define_pdirs_properties' => "Impossível definir as propriedades dos directórios protegidos: %1",
    'pdir__unable_select_dom_param' => "Impossível seleccionar parâmetros do domínio: %1",
    'pdir_ed__create_pdir_for_domain' => "Criar um diretório protegido no site %1",
    'pdir_ed__create_pdir_for_subdomain' => "Criar um diretório protegido no sub-domínio %1",
    'pdir_ed__dir_already_protect' => "Este directório já está protegido.",
    'pdir_ed__head_txt' => "Título da área protegida",
    'pdir_ed__invalid_login' => "O nome do utilizador é inválido.",
    'pdir_ed__login_exists' => "Este utilizador já existe. Tente um outro nome de utilizador.",
    'pdir_ed__new_usr' => "Nome de utilizador",
    'pdir_ed__non_ssl' => "Não-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Nome do diretório",
    'pdir_ed__pdir_for_domain' => "Directório protegido %1 no domínio %2",
    'pdir_ed__pdir_for_subdomain' => "Protegeu o diretório %1 no sub-domínio %2",
    'pdir_ed__pdir_location' => "Localização do directório",
    'pdir_ed__pdir_users' => "Utilizadores de directório protegido",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "SSL/TLS não é suportado pelo site ou não fornecido com sua assinatura. Para ligar o suporte SSL/TLS, vá para a aba Websites & Domains e clique no seu nome de domínio na lista. Se o suporte SSL/TLS não é fornecido com sua assinatura, entre em contato com seu prestador de hospedagem para atualizar seu plano de hospedagem.",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "O SSL/TLS não é suportado neste domínio. Para ligar o suporte SSL/TLS, vá para a aba Websites & Domains e clique no seu nome de domínio na lista.",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "No mínimo uma caixa de verificação (SSL/TLS e/ou Não-SSL/TLS) deve ser selecionada.",
    'pdir_ed__unable_cr_pdir_usr' => "Impossível criar o utilizador de directório protegido: %1",
    'pdir_ed__unable_create_pdir' => "Impossível criar directório protegido: %1",
    'pdir_ed__unable_define_hst_type' => "Impossível definir tipo de alojamento.",
    'pdir_ed__unable_update_pdir' => "Impossível atualizar diretório protegido: %1",
    'pdir_ed__wrong_symbol_in_header' => "Por favor, não use símbolo %1 no cabeçalho do diretório",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Criar um utilizador para o directório protegido %1",
    'pdir_usr_ed__not_create_pass' => "Não será criada uma senha para o novo utilizador de directório protegido.\nSem senha o utilizador não poderá efectuar o login.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Senha para o utilizador de directório protegido %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Impossível seleccionar o utilizador de directório protegido: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Impossível definir utilizadores de directório protegido: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Impossível remover os utilizadores de directório protegido: %1",
    'pdirs_list__name' => "Nome",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "F",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "Impossível remover directórios protegidos: %1",
    'phosting__anonftp_disabled' => "O serviço de FTP Anónimo não está disponível neste domínio porque este endereço IP já se encontra a ser utilizado para o serviço de FTP Anónimo de outro domínio.",
    'phosting__anonftp_encrypt' => 'A senha de utilizador de FTP está codificada, não pode ser usada por proteger o directório /plesk-stat/webstat/. Por favor reintroduza a sua senha de FTP, ou não seleccione a opção "acessível por directório protegido por senha \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "O nome de domínio %%domain_name%% resolve para o endereço de IP %%dns_ip_address%%. Ao seu site Web foi atribuído o endereço IP %%hosting_ip_address%%. Se o seu site Web não for aberto no browser quando inserir o nome de domínio, vá á área de gestão de DNS (Domínios > Nome de Domínio > DNS) e altere as propriedades do registo de recursos A: atribuindo o endereço de IP %%hosting_ip_address%% ao nome de domínio %%domain_name%%.",
    'phosting__ip_change_warning' => "Endereço IP alterado. As alterações correspondentes foram também feitas na zona DNS do domínio.",
    'phosting__other_hosting_exists_on_ip' => "Impossível mudar o certificado porque este endereço de IP está a ser usado numa ou em várias contas de alojamento.",
    'phosting__unable_to_change_certificate' => "Impossível instalar o certificado: %1",
    'phosting__unable_to_change_ip_address' => "Impossível alterar o endereço IP: %1",
    'phosting__unable_to_set_cert' => "Impossível definir o certificado SSL/TLS: %1",
    'phosting__unable_update' => "Impossível atualizar preferências de alojamento: %1",
    'phosting__unable_manage' => "Não foi possível administrar o alojamento: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Não foi possível configurar o fail2ban para controlar os registos do domínio. Os registos serão automaticamente controlados da próxima vez que o serviço fail2ban reiniciar.\n%1",

    'picker_acl_record__tittle' => 'Seleccione um registo ACL',
    'picker_autoresponder__title' => 'Selecionar uma Resposta Automática',
    'picker_black_list__domain_name' => 'Seleccione um Nome de Domínio',
    'picker_certificate' => 'Seleccione o certificado SSL/TLS',

    'picker_dns_zone_template__title' => 'Seleccione um Registo de Recursos',
    'picker_domain__title' => 'Selecione um Domínio',
    'picker_domain_alias__title' => 'Seleccione um Nome alternativo de Domínio',
    'picker_resource_record__title' => 'Seleccione um Registo de Recursos',
    'picker_disabled_resource_record__title' => 'Seleccione um Servidor de Nome',
    'picker_ip_address__title' => 'Seleccionar um Endereço IP',
    'picker_ip_address_clients__title' => 'Selecionar os Clientes que Utilizam Este Endereço IP',
    'picker_mail_queue' => 'Selecionar as Mensagens de E-mail',
    'picker_site_application__title' => 'Seleccionar uma Aplicação Web',
    'picker_subdomain__title' => 'Seleccionar um Sub-domínio',
    'picker_web_user__title' => 'Seleccionar um Utilizador Web',
    'picker_custom_button__title' => 'Seleccionar um Botão Personalizado',
    'picker_license_key__title' => "Selecção da chave de licença",
    'picker_spamfilter_address__title' => 'Seleccione um Endereço do Filtro de Spam',
    'picker_white_list__networks' => 'Selecção das redes',

    'plesk_key__action_logs' => "Registo de ações realizadas pelos utilizadores do Plesk",
    'plesk_key__app_vault' => "Cofre de aplicações",
    'plesk_key__backup' => "Capacidade de usar as funções de backup",
    'plesk_key__client_templs' => "Capacidade de gerir os modelos de cliente",
    'plesk_key__clients' => "Número máximo de contas de utilizador",
    'plesk_key__resellers_only' => "Contas de utilizadores (revendedores)",
    'plesk_key__customers_only' => "Contas de utilizadores (clientes)",
    'plesk_key__domains' => "Domínios",
    'plesk_key__domain_aliases' => "Nomes alternativos de domínio",
    'plesk_key__manage_dashboard' => 'Capacidade de gerir a página Inicial',
    'plesk_key__drweb' => "Gestão de antivírus",
    'plesk_key__event_manager' => "Gestor de eventos",
    'plesk_key__expirations' => "Gerenciamento das datas de expiração de contas",
    'plesk_key__group_ops' => "Modificação de objetos mútiplos de uma vez",
    'plesk_key__expiration' => "Data limite da chave",
    'plesk_key__edition_name' => "Edição do Plesk",
    'plesk_key__key_number' => "Número da chave",
    'plesk_key__languages' => "Pacotes de idiomas",
    'plesk_key__mailnames' => "Contas de correio",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Capacidade de usar Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Links para adquirir certificados SSL/TLS e serviços de registro de domínio",
    'plesk_key__myplesk_server_id' => "Identificador de servidor slave MPC",
    'plesk_key__notifications' => "Gerenciamento das notificações",
    'plesk_key__postgresql' => "Capacidade de usar PostgreSQL",
    'plesk_key__qmail_queue' => 'Capacidade de gerir a fila de correio',
    'plesk_key__remote_db' => 'Host de Banco de Dados Remoto',
    'plesk_key__slave_servers' => "Servidores escravos",
    'plesk_key__spamassassin' => "Gestão do filtro spam",
    'plesk_key__subdomains' => "Gestão de subdomínios",
    'plesk_key__sys_access' => "Gestão do acesso ao servidor",
    'plesk_key__traffic_reports' => "Capacidade de usar relatório de tráfego",
    'plesk_key__tts' => "Central de Atendimento",
    'plesk_key__virtuozzo' => "Válido somente para o Virtuozzo containers",
    'plesk_key__webusers' => "Utilizadores de rede",
    'plesk_key__license_update_date' => 'Próximo update da chave de licença',
    'plesk_key__autoinstaller_config' => 'Gerenciamento das configurações do atualizador',
    'plesk_key_update__title' => 'Estado da actualização da Chave',
    'plesk_key_update__legend' => 'Estado da actualização da Chave',
    'plesk_key_update__new_additional_key' => 'Recebeu a nova chave adicional',
    'plesk_key__check_wrong' => "A chave de licença é inválida. De modo a poder utilizar o Plesk, obtenha e instale uma nova chave de licença válida.",
    'plesk_key__upload_check_wrong' => 'A chave de licença carregada não é válida.',
    'plesk_key__revert_check_wrong' => 'A chave de licença instalada anteriormente não é válida.',
    'plesk_key__update_check_wrong' => 'A chave de licença actualizada não é válida.',
    'plesk_key__viruozzo_only_key' => 'A chave de licença só pode ser utilizada no Plesk dentro do Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'Só é possível utilizar esta cópia licenciada do Plesk nos seguintes endereços IP: %2. Os seguintes endereços IP não estão abrangidos pela sua licença: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'A quantidade de recursos utilizados ​​atualmente excede os limites definidos pela sua licença.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'O número de sites Web alojados no servidor excede os limites definidos pela sua licença. Tem alojados %2 sites; a sua licença permite-lhe alojar só %1 sites.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'O número de nomes alternativos de domínio no servidor excede o limite definido pela sua licença. Existem %2 nomes alternativos de domínio; a sua licença permite-lhe alojar apenas %1 nomes alternativos de domínio.',
    'plesk_key__limits_exceeded_lim_cl' => 'O número de contas de cliente existentes excede os limites definidos pela sua licença. Serve atualmente %2 contas de cliente; a sua licença permite-lhe servir só %1 contas de cliente.',
    'plesk_key__limits_exceeded_lim_mn' => 'O número de contas de e-mail existentes excede os limites definidos pela sua licença. Serve atualmente %2 contas de e-mail; a sua licença permite-lhe servir só %1 contas de e-mail.',
    'plesk_key__limits_exceeded_lim_wu' => 'O numero de contas de utilizadores de rede existentes excede os limites definidos pela sua licença. Serve actualmente %2 contas de utilizadores de rede; a sua licença permite-lhe servir só %1 contas de utilizadores de rede.',
    'plesk_key__limits_exceeded_MLS' => 'O numero de pacotes de idiomas actualmente instalados, excede os limites definidos na sua licença. Existem %2 pacotes de idiomas instalados; a sua licença permite a instalação de apenas %1 pacotes de idiomas.',
    'plesk_key__wrong_version' => 'Está a tentar utilizar uma chave de licença criada para outra versão do Plesk. Contacte os representantes de vendas da Plesk para obter uma chave de licença adequada.',
    'plesk_key__other_product' => 'Está a tentar utilizar uma chave de licença criada para outro produto. Contacte os representantes de vendas da Plesk para obter uma chave de licença adequada.',
    'plesk_key__limits_exceeded_error' => 'Impossível instalar a chave de licença: Os recursos atualmente em uso no painel de controlo excedem os limites definidos da sua chave de licença carregada.',
    'plesk_key__limits_exceeded_note' => 'Os recursos atualmente em uso no painel de controlo excedem os limites definidos da sua chave de licença carregada.',
    'plesk_key__key_file_invalid' => 'O arquivo transferido não é válido ou não contém uma chave de licença.',
    'plesk_key__server_request_error' => 'Não foi possível atualizar a licença. Certifique-se de que as ligações com o servidor de licença ka.plesk.com na porta TCP %1 não estejam bloqueadas. <a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">Veja como o fazer</a>.',
    'key__title' => 'Gestão da Licença',
    'key__upload_title' => 'Carregamento da Chave de Licença',
    'key__no_key_file_in_zip' => 'O arquivo .zip transferido não contém ficheiro da chave',
    'key__key_upload' => 'Instalação da chave de licença',
    'key__tabs_plesk' => 'Chave de Licença do Plesk',
    'key__tabs_additional' => 'Chaves de Licença Adicionais',
    'key_revert__title' => 'Reverter a Chave de Licença',
    'key_revert__legend' => 'Confirmação da reversão da Chave de Licença',
    'key_revert__text' => 'A chave de licença com as seguintes propriedades será reposta:',
    'key__license_update_date_hint' => 'A data de expiração será automaticamente prolongada em %%license_update_date%%. Para actualizar automaticamente deve permitir a conexão a %%keyserver_host%%. Para mais informação, leia em %%help begin:lim_date%%o seguinte tópico de ajuda%%help end:lim_date%%.',
    'additional_key__info' => 'Propriedades da Chave Adicional',
    'additional_key__prop_name' => 'Propriedade',
    'additional_key__prop_value' => 'Valor',
    'additional_key__descr_name' => 'Nome da Chave',
    'additional_key__descr_key_number' => 'Número da chave',
    'additional_key__descr_key_vz' => "Esta chave de licença é apropriada para uso apenas no ambiente do Virtuozzo containers.",
    'additional_key__descr_lim_date' => 'Data de expiração',
    'additional_key__descr_license_update_date' => 'Próximo update da chave de licença',
    'additional_key__remove_title' => "A chave da aplicação web com as seguintes propriedades será removida:",
    'additional_keys__remove_title' => "As seguintes chaves adicionais serão removidas:",
    'additional_keys__select_to_remove' => 'Seleccione as chaves adicionais a serem removidas.',
    'additional_key__file_invalid' => 'O arquivo transferido não é válido ou não contém uma chave de licença.',
    'additional_key__file_incompatible' => 'O arquivo da chave transferido não é válido para esta aplicação.',
    'additional_key__expired' => 'A chave adicional expirou.',
    'additional_key__not_exists' => 'Sem chave de licença instalada.',
    'additional_key__viruozzo_only_key' => 'Esta chave de licença é destinada somente para uso com o Plesk instalado nos contentores Virtuozzo.',
    'additional_keys__legend' => 'Chaves adicionais',
    'additional_keys__list_header' => 'Chaves adicionais',
    'additional_key_update__result_response' => 'Resposta do servidor de licenças: %1',
    'additional_key_update__result_network' => 'Não foi possível conectar ao servidor de licenças. Assegure-se que a sua rede permite as comunicações para %1: %2.',
    'additional_key_update__result_lock' => 'A actualização da Chave já se encontra em progresso',
    'additional_key_update__result_internal_error' => 'Ocorreu um erro ao actualizar a chave da licença: %1',

    'additional_key_revert__title' => 'Por favor, confirme a operação',
    'additional_key_revert__legend' => 'Propriedades da chave adicional anteriormente utilizada',
    'additional_key_revert__confirm_text' => 'Reverter a chave',
    'additional_key_revert__confirm_required' => 'Por favor, confirme a operação.',

    'proceed_to_cl_pool' => "Prosseguir para configurar o repositório de IP do cliente",
    'proceed_to_hosting_setup' => "Continuar com a configuração de alojamento",
    'removeCerts__remove_certificates_cp' => "Os seguintes certificados serão removidos:",
    'removeCerts__remove_certificates_domain' => "Os seguintes certificados pertencentes à %1 serão removidos:",
    'removeClientsIP_remove_clients_ip' => "Este endereço IP será removido dos repositórios dos seguinte clientes:",
    'removeMailAliases__remove_mail_aliases' => "Os seguintes nomes alternativos de correio vão ser removidos da conta de correio %1:",
    'removeMailNames__remove_mailnames' => "As seguintes contas de correio e nomes alternativos vão ser removidos do domínio %1:",
    'removeMailNames__remove_mailnames_of_cl' => "As seguintes contas de correio e nomes alternativos vão ser removidos do domínio %2 do cliente %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Estas contas de correio não vão ser eliminadas.",
    'removeFtpSessions__remove_title' => "As seguintes sessões de FTP serão terminadas:",
    'removeTemplates__remove_templates' => "Os seguintes modelos serão removidos:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'Frequência',
    'report_auto__list_last' => 'Última data de entrega',
    'report_auto__list_recipient' => 'Entregue',
    'report_auto__list_select' => 'Reporte sobre',
    'report_auto__title' => 'Entrega programada para %1',
    'report_auto__recipient_email' => 'o endereço de e-mail que eu especifique',
    'report_auto__recipient_admin' => 'o administrador do servidor',
    'report_auto__recipient_client' => 'o cliente',
    'report_auto__recipient_domain' => 'o utilizador de domínio',
    'report_auto_edit__select' => 'Reporte sobre',
    'report_auto__select_client_report_all' => 'todos os clientes',
    'report_auto__select_client_report_current' => 'este cliente',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'todos os domínios',
    'report_auto__select_domain_report_other_client' => 'todos os domínios de %1',
    'report_auto__select_domain_report_client' => 'todos os domínios deste cliente',
    'report_auto__select_domain_report_reseller' => 'todos os domínios deste revendedor',
    'report_auto__select_domain_report_current' => 'este domínio',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Agenda de entregas',
    'report_auto__select_for_remove' => "Seleccione as entrega agendadas para ser removida.",
    'report_auto_remove__title' => "Os seguintes horários para entrega de relatório serão removidos:",
    'report_auto_edit__title' => 'Propriedades da agenda de entrega',
    'report_auto_edit__recipient' => 'Entregue',
    'report_auto_edit__target' => 'Reporte sobre',
    'report_auto_edit__auto' => 'Frequência da entrega',
    'resp_edit__always_respond' => "Sempre responder",
    'resp_edit__reply_subject' => "Assunto da resposta",
    'resp_edit__answer_subject' => "Responder com assunto",
    'resp_edit__answer_txt' => "Responder com texto",
    'resp_edit__attach' => "Anexar arquivos",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "para",
    'resp_edit__frw_rqst_email' => "Na resposta automática, encaminhe a mensagem original para o email especificado",
    'resp_edit__fwd_email_invalid' => "Endereço de encaminhamento é inválido.",
    'resp_edit__in_body' => "no corpo",
    'resp_edit__in_subject' => "no assunto",
    'resp_edit__invalid_resp_freq' => "Frequência de resposta é inválida.",
    'resp_edit__invalid_rqst_txt' => "Texto de solicitação inválido.",
    'resp_edit__invalid_store_lim_num' => "Valor limite é inválido.",
    'resp_edit__limits_title' => "Limites",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Número máximo de resposta por dia excede a taxa definida. Permitido: %1, necessário: %2",
    'resp_edit__no_files_sel' => "Não seleccionou um arquivo.",
    'resp_edit__no_txt_supplied' => "Nenhum texto fornecido.",
    'resp_edit__reply_title' => "Responder",
    'resp_edit__reply_to_address' => "Endereço de retorno",
    'resp_edit__reply_to_invalid' => "Endereço de retorno é inválido.",
    'resp_edit__reply_uniq_email' => "Responder para um único endereço, e não mais",
    'resp_edit__conditions_title' => "Condições",
    'resp_edit__request_title' => "Solicitar",
    'resp_edit__resp' => "Resposta automática",
    'resp_edit__resp_name' => "Nome da resposta automática",
    'resp_edit__resp_not_exist' => "Resposta automática não existe.",
    'resp_edit__resp_status' => "Estado de resposta automática",
    'resp_edit__rqst_txt' => 'Texto de solicitação',
    'resp_edit__select_files_on_server_for_attach' => "Seleccione os arquivos que você deseja anexar",
    'resp_edit__store_up_to' => "Gravar até",
    'resp_edit__subj_line_invalid' => "Linha de assunto está incorrecta.",
    'resp_edit__text_too_big' => "O texto da mensagem de resposta é muito grande.",
    'resp_edit__times_in_a_day' => "Vezes por dia.",
    'resp_edit__unable_define_resp_cond' => "Impossível definir a condição de resposta automática: %1",
    'resp_edit__unable_define_resp_status' => "Impossível definir estado da resposta automática: %1",
    'resp_edit__unable_turn_on_resp' => "Impossível ativar a resposta automática: %1",
    'resp_edit__uniq_email' => "Endereços de e-mail únicos",
    'resp_edit__content_type' => 'Formato do correio enviado',
    'resp_edit__content_type_text' => 'Texto',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Codificação',
    'restart__dns' => 'Servidor DNS(%1)',
    'restart__drweb' => 'Antivírus premium do Plesk',
    'restart__mail' => "Servidor IMAP/POP3 (%1)",
    'restart__mssql' => "Microsoft SQL server",
    'restart__mysql' => "Servidor MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Serviços",
    'restart__smtp' => "Servidor SMTP (%1)",
    'restart__spamd' => "Filtro de Spam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Servidor WEB (%1)",
    'restart__ftp' => "Servidor de FTP (%1)",
    'restart__service_start' => 'Por favor, aguarde algum tempo para que o serviço seja iniciado.',
    'restart__service_stop' => 'Por favor, aguarde algum tempo para que o serviço seja parado.',
    'restart__service_restart' => 'Por favor, aguarde algum tempo para que o serviço seja reiniciado.',
    'rm_domains__some_domains_are_not_exist' => "Alguns dos domínios especificados não existem. Eles foram possivelmente removidos por um outro utilizador.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "Gr.e-mail",
    'rpt_cl_dom_mail_lists' => "L.e-mail",
    'rpt_cl_dom_mail_resps' => "Resp.Autom",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivírus",
    'rpt_cl_dom_postboxes' => "Cx.Mens",
    'rpt_cl_dom_redirects' => "Redirecionamentos",
    'rpt_cl_dom_subdomains' => "Sub-dom",
    'rpt_cl_dom_domain_aliases' => "Nomes alternativos",
    'rpt_cl_dom_web_users' => "UtilizadoresW",
    'rpt_cl_report_for_admin__' => "Relatório para o administrador %1",
    'rpt_cl_report_for_reseller__' => "Relatório para o revendedor %1",
    'rpt_cl_report_for_cl__' => "Relatório sobre o cliente %1",
    'rpt_cl_section_domains' => "Domínios",
    'rpt_cl_section_full_domains' => "Domínios",
    'rpt_cl_section_general' => "Geral",
    'rpt_create' => "Criar relatório",
    'rpt_empty' => "O relatório deve conter no mínimo um secção",
    'rpt_default_report' => "Usar como relatório predefinido",
    'rpt_dom_report_for_dom__' => "Relatório do Domínio para %1",
    'rpt_dom_section_databases' => "Bases de dados",
    'rpt_dom_section_full_databases' => "Bases de dados",
    'rpt_dom_section_full_maillists' => "Listas de envio",
    'rpt_dom_section_full_mailnames' => "Contas de correio",
    'rpt_dom_section_full_webusers' => "Utilizadores de rede",
    'rpt_dom_section_full_siteapps' => 'Aplicações web',
    'rpt_dom_section_full_aspnetapps' => 'Aplicações Web ASP.NET',
    'rpt_dom_section_general' => "Geral",
    'rpt_dom_section_hosting' => "Alojamento",
    'rpt_dom_section_maillists' => "Listas de envio",
    'rpt_dom_section_mailnames' => "Contas de correio",
    'rpt_dom_section_siteapps' => 'Aplicações web',
    'rpt_dom_section_aspnetapps' => 'Aplicações Web ASP.NET',
    'rpt_dom_section_webusers' => "Utilizadores de rede",
    'rpt_dom_title_wa_status' => "F",
    'rpt_edit__' => "Editar relatório %1",
    'rpt_enter_email_address' => "Insira o endereço de e-mail para o qual o relatório será enviado.",
    'rpt_list' => "Formatos de relatório personalizado",
    'rpt_name' => "Nome do relatório",
    'rpt_remove_reports' => "Os seguintes formatos de relatório serão removidos:",
    'rpt_reports' => "Relatórios",
    'rpt_section_full' => "Completo",
    'rpt_section_none' => "Nenhum",
    'rpt_section_summary' => "Resumo",
    'rpt_select_reports_for_remove' => "Seleccione os formatos de relatório a serem removidos.",
    'rpt_default_full' => 'Relatório completo',
    'rpt_default_summary' => 'Relatório resumido',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Erro ao enviar o relatório: %1",
    'rpt_send_report_by_email_ok__' => "O relatório foi enviado para %1",
    'sa_action' => "Ação",
    'sa_action_del' => "Eliminar",
    'sa_action_desc' => "O que fazer com spam",
    'sa_action_save' => "Marcar como spam e gravar na caixa de correio",
    'sa_admin_blacklist' => "Lista preta do administrador",
    'sa_admin_whitelist' => "Lista branca do administrador",
    'sa_blacklist' => "Lista negra",
    'sa_blacklist_desc' => "Sempre marcar como spam mensagens do endereço",
    'sa_by_tag' => "por dia",
    'sa_conf_list_black' => "Tem a certeza que quer remover os padrões seleccionados na lista negra?",
    'sa_conf_list_ignore' => "Tem a certeza que quer remover os padrões seleccionados na lista de ignorados?",
    'sa_conf_list_white' => "Tem a certeza que quer remover os padrões seleccionados na lista branca?",
    'sa_db_del_confirm' => "Tem a certeza que deseja apagar a base de dados do Filtro de Spam ?",
    'sa_disabled__mailserv_not_support_sa_mbox_settings' => "O filtro de Spam está desligado: o servidor de correio não suporta definições de filtro de spam a nível de caixa de correio.",
    'sa_eml_in_ignorelist' => "Este e-mail está na lista de ignorados",
    'sa_eml_pattern' => "Padrão de e-mail",
    'sa_empty_email' => "Impossível adicionar um padrão de e-mail em branco.",
    'sa_exists_email' => "Este e-mail padrão já existe.",
    'sa_disabled__mailname_not_filtering' => "A actual configuração do servidor não permite a utilização de filtros de correio para esta conta de correio",
    'sa_disabled__filtering_is_disabled' => 'O filtro de Spam foi desligado pelo administrador do servidor',
    'sa_disabled__hasnt_mailbox' => "Impossível ligar o filtro de Spam sem uma caixa de correio",
    'sa_enable_filter' => "Ligar o filtro de spam",
    'bt_sa_clear_db' => 'Limpar a Base de dados do Filtro de Spam',
    'bt_sa_forget' => 'Ignorar',
    'bt_sa_learn_as_spam' => "É Spam!",
    'bt_sa_learn_as_nonspam' => "Não É Spam",
    'sa_forget' => "esqueça",
    'sa_from' => "De",
    'sa_ham' => "ham",
    'sa_ignorelist' => "Lista de ignorados do servidor",
    'sa_ignorelist_desc' => "Não filtre e-mail para estas contas",
    'sa_pattern_in_blacklist' => "Padrão já existe na lista preta",
    'sa_pattern_in_ignorelist' => "Padrão já existe na lista de ignorados",
    'sa_pattern_in_whitelist' => "Padrão já existe na lista branca",
    'sa_pattern_is_invalid' => "O padrão não é válido.",
    'sa_select_email' => "Selecione, pelo menos, um e-mail padrão da lista para eliminar.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Treino do filtro de Spam',
    'sa_trainer__tools_legend' => 'Ferramentas',
    'sa_trainer__info_legend' => 'Informações',
    'sa_trainer__messages_list_legend' => 'Mensagens na sua caixa de correio',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'N',
    'sa_trainer__subject' => 'Assunto',
    'sa_trainer__from' => 'De',
    'sa_trainer__date' => 'Data',
    'sa_trainer__info_text' => 'Mensagens aprendidas: %1 como spam, %2 não sendo spam, %3 total.',
    'sa_trainer__messages' => 'mensagem(s)',
    'sa_trainer__select__all' => 'Tudo',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Não-Spam',
    'sa_trainer__select__unknown_only' => 'Desconhecido',
    'sa_trainer__cannot_remove_messages' => 'Impossível remover as mensagens seleccionadas da caixa do correio.',
    'sa_trainer__remove_messages_confirm' => 'Tem a certeza que deseja remover as mensagens seleccionadas da caixa de correio?',
    'sa_srv_blacklist' => "Lista preta do servidor",
    'sa_srv_whitelist' => "Lista branca do servidor",
    'sa_subj' => "Assunto",
    'sa_training' => "Treino do filtro de Spam",
    'sa_training_legend' => "Treinamento de filtro bayesiano",
    'sa_use_srv_settings' => "Usar configurações do servidor",
    'sa_user_blacklist' => "A lista negra de utilizador",
    'sa_user_whitelist' => "A lista branca de utilizador",
    'sa_usr_disabled_by_srv' => "Não são permitidas definições individuais do filtro de spam pelo administrador",
    'sa_usr_no_postbox' => "Não é possível ativar a filtragem de spam porque a caixa de correio está desativada para esta conta de e-mail.",
    'sa_whitelist' => "Lista branca",
    'sa_whitelist_desc' => "Nunca marcar como spam mensagens do endereço",
    'sa_filters' => 'Filtros de Spam',
    'sa_max_mail' => 'Não filtrar se o tamanho do email ultrapassar o tamanho designado',
    'sa_size_limit_text' => 'limite do tamanho',
    'sa_invalid__max_spam_threads' => 'Valor inválido. Insira um valor entre 1 a 32.',
    'sa_max_threads' => 'Número de instâncias que o filtro de spam pode criar',
    'sa_max_threads_maximum' => '(máximo 32)',
    'sa_disabled__spamfilter_not_support_sa_max_threads_limit' => '(indisponível: este filtro de spam não suporta esta opção)',
    'spamfilter__tools_legend' => 'Ferramentas',
    'spamfilter__prefs_legend' => 'Configurações',
    'spamfilter__max_children' => 'Número máximo de processos spamd de trabalhador a executar',
    'spamfilter__rewrite_header_subject_hint' => 'Deixe este campo em branco se não quiser adicionar texto. Insira _SCORE_ se quiser incluir a avaliação no assunto da mensagem.',
    'spamfilter__reject_spam' => 'Eliminar o correio spam quando chegar à caixa de correio',
    'spamfilter__enabled' => 'Ligada',
    'spamfilter_addresses_list__tools_legend' => 'Ferramentas',
    'spamfilter_addresses_list__list_legend' => 'Endereços',
    'spamfilter_addresses_list__items' => 'endereços',
    'spamfilter_addresses_list__status' => 'F',
    'spamfilter_addresses_list__level' => 'N',
    'spamfilter_addresses_list__address' => 'Endereço',
    'spamfilter_addresses__file_legend' => 'Do ficheiro',
    'spamfilter_addresses__file_label' => 'Nome do ficheiro',
    'spamfilter_addresses__file_hint' => 'Carregar um ficheiro codificado em UTF-8.',
    'spamfilter_addresses__text_legend' => 'Da lista',
    'spamfilter_addresses__text_label' => 'Endereços de e-mail',
    'spamfilter_addresses__remove_title' => 'Os seguintes endereços vão ser removidos da lista:',
    'spamfilter_addresses__empty_selection' => 'Sem endereços seleccionados.',
    'server__admin_info' => "Informação do administrador",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Insira a descrição do bug abaixo",
    'server__power_management' => "Administração de energia",
    'server__services' => "Serviços",
    'server__system' => "Sistema",
    'server__title' => "Administração do Servidor",
    'server_preferences__admin_skin' => "Aparência da interface do administrador",
    'server_preferences__count_disk_space' => "Incluir o cálculo do uso de espaço em disco",
    'server_preferences__count_traffic' => "Incluir cálculo de tráfego",
    'server_preferences__count_type' => 'Contar ao calcular a utilização de espaço no disco',
    'server_preferences__count_type__byte' => 'tamanho do arquivo',
    'server_preferences__count_type__block' => 'quantidade de utilização de espaço no disco',
    'server_preferences__default_language' => "Linguagem predefinida",
    'server_preferences__default_skin' => "Skin predefinida",
    'server_preferences__include_databases' => "bases de dados",
    'server_preferences__include_domaindumps' => "Backup de arquivos do domínio",
    'server_preferences__include_incoming' => "Somente tráfego de entrada",
    'server_preferences__include_incoming_and_outgoing' => "Tráfego de entrada e saída",
    'server_preferences__include_logs' => "ficheiros de registro e relatórios de estatísticas",
    'server_preferences__include_mailboxes' => "caixas de correio",
    'server_preferences__include_maillists' => "listas de envio",
    'server_preferences__include_outgoing' => "Somente tráfego de saída",
    'server_preferences__include_remote_databases' => 'Bases de dados remotas',
    'server_preferences__keep_stats' => "Reter estatísticas de tráfego e Web por",
    'server_preferences__restart_apache_interval' => "Intervalo de reinício do Apache",
    'server_preferences__stat_warning' => "As alterações feitas para o esquema de cálculo de uso de espaço em disco serão aplicadas somente no próximo cálculo de estatísticas.",
    'server_preferences__title' => "Definições do Servidor",
    'server_preferences__system' => 'Preferências do Sistema',
    'server_mail__title' => "Preferências de Correio do Servidor",
    'mail__tabs_preferences' => "Configurações",
    'mail__tabs_white_list' => "Lista Branca",
    'mail__tabs_blocked_domains' => "Lista Negra",
    'mail__tabs_mail_queue' => "Fila do Correio",
    'server_preferences__use_vocabulary' => "Confirme as senhas para as caixas de correio no dicionário",
    'sessions__agreement' => "Sim, Eu desejo finalizar estas sessões.",
    'sessions__select_sessions_for_remove' => "Seleccione as sessões a serem finalizadas.",
    'sessions__tabs_cp_sessions' => 'Sessões do Plesk',
    'sessions__tabs_ftp_sessions' => 'Sessões FTP',
    'sessions__ftp_sessions_login' => 'Nome de utilizador FTP',
    'sessions__ftp_sessions_domain' => 'Nome do domínio',
    'sessions__ftp_sessions_path' => 'Localização atual',
    'sessions__ftp_sessions_file' => 'Nome do ficheiro',
    'sessions__ftp_sessions_action' => 'Estado',
    'sessions__ftp_sessions_speed' => 'Velocidade, KB/s',
    'sessions__ftp_sessions_comp' => 'Progresso, %',

    'site_apps__access_level' => 'Nível de acesso',
    'site_apps__access_level_commercial' => 'Comercial',
    'site_apps__access_level_free' => 'Livre',
    'site_apps__action_installer' => "Instalação da aplicação web",
    'site_apps__action_reconfigure' => "Reconfiguração de uma aplicação web",
    'site_apps__custom_button_level' => 'Deseja criar um botão personalizado para aceder esta aplicação?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Não',
    'site_apps__custom_button_level_domain_user_only' => 'Sim',
    'site_apps__custom_button_level_false' => 'Não',
    'site_apps__custom_button_level_domain' => 'Sim, e só disponibilize para o domínio actual.',
    'site_apps__custom_button_level_client' => 'Sim, e disponibilize para todos os domínios do cliente.',
    'site_apps__custom_button_level_admin' => 'Sim, e disponibilize para todos os domínios.',
    'site_apps__description' => "Descrição",
    'site_apps__dir_used_by_sapp__' => "O directório \"%1\" é usado por outra aplicação web",
    'site_apps__dir_used_by_unknown__' => "O directório \"%1\" já existe. O seu conteúdo será substituído se continuar.",
    'site_apps__dir_invalid_name__' => "O nome do directório %1 é incorrecto",
    'site_apps__file_name' => 'Nome do ficheiro da aplicação web',
    'site_apps__invalid_install_prefix' => "O prefixo da instalação é inválido",
    'site_apps__invalid_package' => "Aplicação web inválida",
    'site_apps__key_status' => 'A licenciar',
    'site_apps__key_status_free' => 'Distribuído livremente. Não requer uma chave de licença',
    'site_apps__key_status_ok' => 'A chave de licença exigida está instalada',
    'site_apps__key_status_problem' => 'A chave de licença exigida não está instalada',
    'site_apps__name' => "Nome",
    'site_apps__no_domains' => 'A aplicação web não pode ser instalada. Já existe outra aplicação web instalada no directório raiz deste domínio. Considere criar um sub-domínio para a aplicação web.',
    'site_apps__package_info_' => "Informação da Aplicação Web",
    'site_apps__package_integrated' => "aplicação de base, não pode ser removida",
    'site_apps__pool_select_packages_to_add' => 'Seleccione as aplicações web a adicionar ao repositório',
    'site_apps__release' => "Revisão",
    'site_apps__resource_used_by_sapp' => "Este recurso é utilizado pela aplicação web instalada",
    'site_apps__root_used_by_sapp' => "Este recurso é utilizado por uma aplicação web instalada",
    'site_apps__these_domains_will_not_delete' => 'Estes (sub)domínios não serão eliminados',
    'site_apps__upload_site_app_pkg_title' => 'Carregar uma nova aplicação web',
    'site_apps__version' => "Versão",
    'site_apps__access_to' => "Acesso a %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Modelo de alojamento virtual",
    'skeleton__client_label' => "%1 modelo de alojamento virtual",
    'skeleton__admin_page' => "Administre o Modelo de Alojamento Virtual",
    'skeleton__files_list' => "Ficheiros e directórios",
    'skeleton__archiver_not_installed' => "Impossível descomprimir o arquivo. Possivelmente o software de compressão não está instalado no servidor. Contacte o administrador do {$PROD_NAME} para ter este software instalado.",
    'skeleton__client_page' => "Administre o Modelo de Alojamento Virtual",
    'skeleton__archive_corrupted' => "A verificação de ficheiro descobriu que o arquivo ou está danificado ou este tipo de arquivo não é suportado.",
    'skeleton__archive_too_large' => "A verificação do arquivo constatou que o tamanho do mesmo é muito grande.",
    'skeleton__not_supported_archive_type' => "Este tipo de arquivo(arquivo %1) não é suportado",
    'skeleton__upload_archive_file' => "Carregar o arquivo",
    'skin_download__title' => 'Descarregar a Skin',
    'skin_download_now__title' => 'A descarregar a skin',
    'skin_download_now__text' => 'A criação do pacote da máscara está em processamento.<br>Este procedimento pode demorar algum tempo.<br>Quando a janela de diálogo aparecer, poderá continuar a operar o Plesk.',
    'skin_file__help_for_using_types' => "Por favor, use o arquivo de skin num dos seguintes formatos",
    'skin_info__title' => 'Propriedades da Skin',
    'skin_mng_err__rpm_not_skin' => 'Este RPM não é um pacote de máscara do Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Não foi possível instalar o RPM da Skin no local especificado.',
    'skin_mng_err__already_exists' => 'O directório de instalação da skin já existe, e contém um pacote de skin já instalado.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'O arquivo carregado não é um RPM de Skin válido.',
    'skin_mng_err__rpm_upgrade_noskin' => 'O arquivo carregado não é um pacote de Skin válido.',
    'skin_mng_err__rpm_upgrade_base' => "O arquivo carregado não é um {$PROD_NAME} pacote de Skin válido.",
    'skin_mng_err__rpm_upgrade_other' => 'Não foi possível instalar a skin: formato de skin inválido.',
    'skin_mng_err__no_a_skin' => "O arquivo carregado não é um {$PROD_NAME} pacote de Skin válido.",
    'skin_upload__title' => 'Carregar a nova skin',
    'skin_upload__already_exists' => "A skin '%1' já existe",
    'skin_upload__unable_to_apply' => "O ficheiro transferido não contém uma máscara do Plesk ou o formato de ficheiro não é suportado.",
    'skin_upload__unable_to_rename__' => "Impossível alterar o nome da skin de  %2 para %1: %3.",
    'skin_upload__file_name' => 'Caminho para o arquivo do pacote da skin',
    'skins_list__title' => 'Arquivo de skins',
    'skins_remove__title' => 'Remoção de skin',
    'skins_remove__select_skins_for_remove' => 'Seleccione as skins a serem removidas',

    'spamassassin__title' => "Configuração de filtro de spam",
    'spf_parameters' => 'Proteção contra spam SPF',
    'spf_enable_label' => 'Ativar proteção contra spam SPF para verificar e-mails recebidos',
    'spf_behavior' => 'Modo de verificação SPF',
    'spf_rules' => 'Regras locais de SPF',
    'spf_guess' => 'Regras de SPF',
    'spf_exp' => 'Texto da explicação SPF',
    'spf__unable_update' => 'Impossível actualizar os parâmetros SPF',
    'spf_bhv__create_headers_no_block' => 'Só criar os headers de Received-SPF, nunca bloquear',
    'spf_bhv__use_tmp_errors' => 'Utilizar avisos de erros temporários, quando tiver problemas de DNS lookup',
    'spf_bhv__reject_if_fail' => 'Rejeitar e-mail quando o SPF resolver para "fail" (negar)',
    'spf_bhv__reject_if_softfail' => 'Rejeitar e-mail quando o SPF não resolve para "softfail"',
    'spf_bhv__reject_if_neutral' => 'Rejeitar e-mail quando o SPF não resolve para "neutral"',
    'spf_bhv__reject_if_no_pass' => 'Rejeitar e-mail quando o SPF não resolver para "pass"',
    'sshterm__title' => 'Terminal da Shell Segura',
    'sshterm__password_authentication_warning' => 'Nota: A autenticação da senha está desligada na configuração local do servidor de SSH. Caso não consiga conectar utilizando o Terminal SSH, solicite ao administrador para colocar no ficheiro /etc/ssh/sshd_config a seguinte linha de configuração "PasswordAuthentication yes".',
    'sshterm__password_authentication_warning_admin' => 'Nota: A autenticação da senha está desligada na configuração local do servidor de SSH. Caso não consiga conectar utilizando o Terminal SSH, deve colocar no ficheiro /etc/ssh/sshd_config a seguinte linha de configuração "PasswordAuthentication yes".',
    'statistics__active_domains' => "Domínios activos",
    'statistics__clients' => "Clientes",
    'statistics__subdomains' => "Subdomínios",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Bases de dados",
    'statistics__db_users' => "Utilizadores de base de dados",
    'statistics__dirs' => "Directórios protegidos",
    'statistics__dom_active' => "Ativo",
    'statistics__dom_passive' => "Passivo",
    'statistics__dom_problem' => "Problema",
    'statistics__domains' => "Domínios",
    'statistics__domains_with_host' => "Domínios com alojamento",
    'statistics__doms' => "Domínios",
    'statistics__filesystem' => "Sistema de arquivos",
    'statistics__general' => "Geral",
    'statistics__hdd_available' => "Disponível",
    'statistics__hdd_capacity' => "Utilização",
    'statistics__hdd_total' => "Total",
    'statistics__hdd_usage' => "Uso de disco rígido",
    'statistics__hdd_used' => "Usada",
    'statistics__ip' => "Endereço IP",
    'statistics__key_number' => "Número da chave",
    'statistics__l1' => "Último 1 minuto",
    'statistics__l15' => "Últimos 15 minutos",
    'statistics__l5' => "Últimos 5 minutos",
    'statistics__la' => "Uso da CPU",
    'statistics__mail_autoresponders' => "Respostas automáticas",
    'statistics__mail_boxes' => "Caixas de correio",
    'statistics__mail_groups' => "Grupos de e-mail",
    'statistics__mail_lists' => "Listas de envio",
    'statistics__mail_redirects' => "Redirecionamentos de e-mail",
    'statistics__mem' => "Uso de memória",
    'statistics__mem_usage' => "Utilização",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Cached",
    'statistics__memory_free' => "Livre",
    'statistics__memory_shared' => "Partilhado",
    'statistics__memory_total' => "Total",
    'statistics__memory_used' => "Usada",
    'statistics__os' => "SO",
    'statistics__problem_clients' => "Clientes com problema",
    'statistics__problem_domains' => "Domínios com problema",
    'statistics__swap' => "Uso de Swap",
    'statistics__swap_free' => "Livre",
    'statistics__swap_total' => "Total",
    'statistics__swap_usage' => "Utilização",
    'statistics__swap_used' => "Usada",
    'statistics__system_stat' => "Informação do Servidor",
    'statistics__unable_define_active_doms' => "Impossível definir o número de domínios activos: %1",
    'statistics__unable_define_inactive_doms' => "Impossível definir o número de domínios inactivos: %1",
    'statistics__up_time' => "Tempo de funcionamento do sistema:",
    'statistics__ver' => "Versão",
    'statistics__web_users' => "Utilizadores de rede",
    'statistics__mem_win' => "Utilização da Memória Física",
    'statistics__memory_total_win' => "Total",
    'statistics__memory_used_win' => "Usada",
    'statistics__memory_free_win' => "Disponível",
    'statistics__swap_win' => "Utilização da Memória Virtual",
    'statistics__swap_total_win' => "Total",
    'statistics__swap_used_win' => "Usada",
    'statistics__swap_free_win' => "Disponível",
    'status__domain_has_reasons_to_be_off' => "O domínio ainda está suspenso devido á seguinte razão: %1",
    'subdomain__create__' => "Criar um sub-domínio no domínio %1",
    'subdomain__edit__' => "Gerir o sub-domínio %1",
    'subdomain__invalid_name' => "Nome de sub-domínio inválido: use só simbolos alfanuméricos e traços.",
    'subdomain__incorrect_name' => "Nome de sub-domínio inválido.",
    'subdomains__maillists_enabled_in_domain' => "O nome do sub-domínio.%1 é incorrecto: este nome de domínio já se encontra em uso pelas listas de envio do domínio %1.",
    'subdomains__dalias_exists' => 'Já existe um nome alternativo de domínio com esse nome.',
    'subdomains__name_exists' => "Já existe um subdomínio com esse nome.",
    'subdomains__regular_domain_exists' => "Já existe um domínio com esse nome.",
    'subdomains__domain_alias_exists' => 'Já existe um nome alternativo de domínio com esse nome.',
    'subdomains__remove_subdomains_on_domain' => "Os seguintes subdomínios para o domínio %1 serão removidos:",
    'subdomains__select_subdomains_for_remove' => "Seleccione os subdomínios a serem removidos.",
    'subdomains__webmail_enabled_in_domain' => "Nome do sub-domínio do webmail %1 é incorreto: este nome de domínio já se encontra em uso para acesso ao Webmail do domínio %1.",
    'subdomains__dns_record_already_exists' => 'Impossível criar o sub-domínio %1 porque já existe um registo DNS a apontar ao host %1.',
    'subdomains__www_prefix_in_domain' => "Nome de sub-domínio www.%1 incorrecto: o domínio %1 já tem o prefixo WWW.",
    'subdomains__user_type_quota_exceeds' => 'Impossível mudar a conta do utilizador porque iria exceder o espaço de disco atribuído.',
    'subdomains__creation_in_dns_slave' => "O servidor de nomes do Plesk está a funcionar como servidor de nome secundário (slave) deste domínio. Para que o seu subdomínio resolva convenientemente, assegure-se que o ficheiro da zona do servidor de nome primário (master) contém o registo %1",
    'sys_user__attributes_not_changed' => "Os seguintes atributos do utilizador de sistema não foram alterados: %1",
    'sys_user__no_access_without_password' => "Você não definiu a senha. O utilizador de sistema será criado, mas não será capaz de entrar no sistema, até que lhe seja dada uma senha. Deseja continuar?",
    'sys_user__no_hard_quota' => "não suportado",
    'sysuser__zero_quota_is_unlimited' => "0 para ilimitado",
    'template__num_excl_ips' => "Atribuir endereços IP exclusivos ao cliente",
    'template__sel_sh_ips' => "Os endereços IP partilhados seleccionados",
    'template__av_sh_ips' => "Endereços IP partilhados disponíveis",
    'template__up_to_excl_ip' => "Até %1 endereços IP",
    'templates__all_clients' => "todos os clientes",
    'templates__cl_domain_templates' => "Modelos para %1",
    'templates__cl_templates' => "Modelos de cliente",
    'time__day' => "Dia",
    'time__dom_name_ip' => "Nome do domínio ou IP",
    'time__hours' => "Horas",
    'time__invalid_ip' => "Endereço IP ou nome de domínio inválido.",
    'time__invalid_year' => "Ano inválido. Deve estar entre 1971 e 2036.",
    'time__invalid_month' => "O Mês não é válido. Deve estar entre 1 e 12.",
    'time__invalid_day' => "O Dia não é válido. Deve estar entre 1 e 31.",
    'time__invalid_hours' => "A Hora não é válida. Deve estar entre 0 e 24.",
    'time__invalid_minutes' => "Os Minutos não são válidos. Devem estar entre 0 e 59.",
    'time__invalid_seconds' => "Os Segundos não são válidos. Devem estar entre 0 e 59.",
    'time__minutes' => "Min",
    'time__month' => "Mês",
    'time__sec' => "Segundos",
    'time__syn_sys_time' => "Sincronizar hora do sistema",
    'time__system_datetime' => 'Data e hora',
    'time__system_date_update' => 'Actualizar a hora do sistema',
    'time__system_date' => "Data (Ano-Mês-Dia)",
    'time__system_time' => "Hora (Horas:Minutos:Segundos)",
    'time__system_date_title' => "Data e hora do sistema",
    'time__timezone_title' => 'Fuso Horário',
    'time__network_time' => 'Hora da rede',
    'time__timezone' => 'O seu Fuso Horário',
    'time__daylight' => 'Ajustar automaticamente o relógio para as alterações à hora de verão',
    'time__please_select_timezone' => 'Por favor, Seleccione um fuso horário',
    '__please_select_country' => 'Por favor, seleccione o seu país',
    'time__unable_set_time' => "Impossível definir hora do sistema: %1",
    'time__year' => "Ano",
    'tmpl__create' => "Criar modelo",
    'tmpl__edit__' => 'Modelo %1',
    'tmpl__logrotation_warn' => "Rotacionamento de log no domínio criado por este modelo será executado somente em caso de criação subsequente de conta de Alojamento físico para o mesmo.",
    'tmpl__name' => "Nome do modelo",
    'tmpl__dom_exist' => "Já existe um modelo de domínio com esse nome no repositório de modelos do administrador ou do cliente.",
    'tmpl__name_invalid' => "Nome do modelo está inválido ou vazio.",
    'tmpl__use_next_ip_addr' => "Será utilizado o próximo endereço IP livre",
    'tmpl_name_already_exists' => "O modelo com o nome '%1' já existe.",
    'traffic__no_periods_found' => "Impossível exibir estatísticas de rede e de tráfego. Esta função estará disponível somente após o próximo cálculo de estatísticas.",

    'vh_based__no_free_ip_for_vh' => "Não há endereços IP livres para o alojamento virtual baseado em IP. Por favor, adicione um endereço IP.",

    'wu__at_domains_text' => "Permitir o acesso no formato utilizadorweb@%1",
    'wu__unable_create' => "Impossível criar o utilizador web: %1",
    'wu_edit__disk_quota' => "Quota de disco",
    'wu_edit__invalid_pass' => "Senha é inválida.",
    'wu_edit__invalid_quota' => "O valor da quota especificado para o espaço de disco não é válido. Por favor, insira um numero positivo.",
    'wu_edit__invalid_quota_value' => "A quota de espaço de disco é menor que a que está em uso (%1MB). Algumas funcionalidades podem não ficar disponíveis. Tem a certeza que quer continuar?",
    'wu_edit__not_create_pass' => "Esta acção não irá criar uma senha para o novo utilizador web.\nSem senha o utilizador não será capaz de entrar no sistema.",
    'wu_edit__unable_update' => "Impossível actualizar a propriedade do utilizador web: %1",

    'dns__soa_settings_legend' => 'Configurações de SOA',
    'dns__default_ttl_legend' => 'TTL predefinido',
    'dns__soa_param_ttl' => 'TTL predefinido',
    'dns__soa_param_retry' => 'Intervalo para Repetir',
    'dns__soa_param_refresh' => 'Intervalo de Refresh',
    'dns__soa_param_expire' => 'Intervalo de Expire',
    'dns__soa_param_minimum' => 'TTL Mínimo',

    'bt_webdirs' => 'Diretórios Virtuais',

    'dns__tabs_general' => 'Definições da Zona',
    'dns__tabs_zone_settings' => 'Registos SOA',
    'soa__seconds' => 'segundos',
    'soa__minutes' => 'minutos',
    'soa__hours' => 'horas',
    'soa__days' => 'dias',

    'DomainSubdirectory' => 'Subdirectório de destino',

    'filemanager__select_codepage' => 'seleccione o Codepage:',

    'bt_server_app_add' => 'Adicionar aplicação de servidor',
    'packages_list' => 'Aplicações Locais',

    'bt_packages_management' => 'Administração de Pacotes',
    'pb__packages_management' => 'Administração de Aplicações',
    'bt_package_new' => 'Adicionar aplicação',
    '__packages' => 'Aplicações Locais',

    'dom_ctrl__mysql_dbase_space' => 'Quota total de bases de dado MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Quota total de bases de dado MS SQL',
    'server_preferences__include_mysql_databases' => 'Bases de dados do MySQL',
    'server_preferences__include_mssql_databases' => 'Bases de dados do Microsoft SQL',

    'check_permissions__domains_selection' => 'Vão ser verificadas as permissões de acesso dos ficheiros e directórios dos seguintes domínios',

    'dns_add__enter_ixfr_path' => 'Insira o caminho de IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Registo SPF TXT já existe. Não pode ser apenas um registro SPF. Para adicionar um registro, eliminação antes do existente.',

    'component_name__network' => 'Rede',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Skin de jogo',
    'bt_set_skin' => 'Skin de jogo',
    'firewall__rule_already_exists' => 'Regra com o nome %1 já existe',
    'pb__firewall' => 'Firewall',
    'ruleeditform__incorect_port_value' => 'O número da porta deveria estar entre 1 e 65535.',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'A localização do arquivo não é válida.',

    'error_doc__erorr_invalid_url_location' =>  'Formato de URL errado. Insira um URL absoluto dentro do alojamento virtual(site).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivírus',
    'antivirus__antivirus' => 'Protecção Antivírus',
    'antivirus__antivirus_direction_off' => 'Desligado',
    'antivirus__antivirus_direction_any' => 'Correio a entrar e a sair',
    'antivirus__antivirus_direction_from' => 'Só correio a sair',
    'antivirus__antivirus_direction_to' => 'Só correio a entrar',
    'antivirus__unable_to_update_settings' => 'Impossível modificar as configurações do antivírus: %1.',




    '__normal' => 'Normal',
    '__low' => 'Baixa',
    '__high' => 'Alta',

    'mail__antivirus' => "Antivírus interno do servidor de correio",
    'mail__use_internal_antivirus' => 'Utilize o antivírus interno',

    'sa__tabs_general' => 'Geral',
    'sa__tabs_whitelist' => 'Lista Branca',
    'sa__tabs_blacklist' => 'Lista Negra',
    'sa__tabs_trustednetworks' => 'Redes de confiança',
    'sa__alarm_message_text' => 'Texto de alerta de SPAM',
    'sa__ok_languages' => 'Idiomas de confiança',
    'sa__language_groups_available' => 'Idiomas disponíveis',
    'sa__language_groups_belonged' => 'Idiomas de confiança escolhidos',
    'sa__ok_locales' => 'Locales de confiança',
    'sa__locale_groups_available' => 'Grupos de locales disponíveis',
    'sa__locale_groups_belonged' => 'Grupos de locales de confiança escolhidos',

    'sa_trustednetworks' => 'Lista de redes de confiança',
    'sa_tn_address' => 'Rede/Máscara',
    'sa_trustednetworks_desc' => 'Redes de confiança escolhidas',

    '__mysql_databases' => 'Bases de dados do MySQL',

    'check_permissions__read_only' => 'Modo só de verificar',
    'check_permissions__notification_email' => 'Enviar notificação através de e-mail',

    'cl_perm__mysql_dbase_space' => 'Quota total de bases de dado MySQL',
    'cl_perm__mssql_dbase_space' => 'Quota total de bases de dado MS SQL',
    'cl_perm__max_mssql_db' => 'Número máximo de bases de dados do servidor Microsoft SQL',
    'cl_perm__total_mboxes_quota' => 'Quota total das caixas de correio',



    'time__date' => 'Data',
    'time__time' => 'Hora',

    'check_permissions_warning' => 'Este procedimento pode ser demorar muito tempo a completar, por favor seja paciente e não cancele o carregamento da página.',

    'i_i_cl_on' => 'A conta do cliente está ativada.',
    'i_i_cl_off_by_admin' => 'A conta do cliente foi suspensa pelo administrador.',

    'check_permissions__email_is_invalid' => 'O email fornecido não é válido.',

    'sa_invalid_tn_ip' => 'O valor do IP não é válido.',
    'sa_invalid_tn_mask' => 'O valor da máscara não é válido.',
    'sa_exists_tn' => 'A Rede já se encontra na lista.',
    'sa_select_tn' => 'Não foram seleccionadas redes para remoção.',
    'sa_conf_list_tn' => 'Confirme, por favor, a remoção da(s) rede(s) seleccionada(s).',

    'firewall__tabs_general' => 'Geral',
    'firewall_tabs_icmp' => 'Protocolo ICMP',

    'firewallicmpform__title' => 'Regras de Firewall do protocolo ICMP',
    'firewallicmpform__icmpsettings_list_legend' => 'Regras de Firewall do protocolo ICMP',
    'firewallicmpform__icmpsettingslist' => 'Regras',
    'icmpsettingslist__enabled' => 'F',
    'icmpsettingslist__type' => 'Nome da regra',
    'firewall__icmp_type_allowinboundrouterrequest' => 'Permitir a entrada do pedido do router',
    'firewall__icmp_type_allowinboundtimestamprequest' => 'Permitir a entrada do pedido de grupo data-hora',
    'firewall__icmp_type_allowinboundmaskrequest' => 'Permitir a entrada do pedido de máscara',
    'firewall__icmp_type_allowoutboundsourcequench' => 'Permitir a extinção da fonte da saída (source quench)',
    'firewall__icmp_type_allowoutboundparameterproblem' => 'Permitir problemas nos parâmetros de saída (parameter problem)',
    'firewall__icmp_type_allowredirect' => 'Permitir redireccionamento',
    'firewall__icmp_type_allowinboundechorequest' => 'Permitir a chegada do pedido de eco',
    'firewall__icmp_type_allowoutboundtimeexceeded' => 'Permitir exceder o tempo de saída (time exceeded)',
    'firewall__icmp_type_allowoutbounddestinationunreachable' => 'Permitir a saída para destino inatingível',


    'webdir__select_vdirs_to_remove' => 'Seleccione os directórios que quer eliminar',
    'webdir__select_mime_types_to_remove' => 'Seleccione os tipos MIME que quer eliminar',

    'defaultcomponents__not_activated' => 'inactivados',

    'bt_traffic_at_domains' => 'Tráfego',

    'firewall__icmpsettingslist' => 'Regras',
    'icmpsettingslist__name' => 'Nome da regra',

    '__awstats_perl_warning' => 'Sem o Perl instalado, o AWStats não vai permitir que os utilizadores verifiquem as estatísticas de anos anteriores.',

    'class_client__mysql_dbase_space' => 'O valor excede o limite do cliente',
    'class_client__mssql_dbase_space' => 'O valor excede o limite do cliente',
    'class_client__max_mssql_db' => 'O valor excede o limite do cliente',

    'firewall__icmp_reset_configuration' => 'Quer realmente reiniciar as configurações da Firewall parar a configuração inicial?',
    'firewall__icmp_panic_configuration' => 'Tem a certeza que quer ligar o Modo de Pânico? Alguns serviços de rede podem deixar de funcionar.',


    'dns__remove_transfer_restrictions_list_items' => 'As seguintes redes serão removidas da lista de controlo de acesso:',
    'dns__select_transfer_restrictions_list_items_to_remove' => 'Seleccione, por favor, as redes que deseja remover da lista de controlo de acesso',

    'firewall__select_rule_to_remove' => 'Seleccione as regras para remover',

    'bt_up' => "Cima",
    'bt_down' => "Baixo",
    'virtualdir__type_default_doc_name_to_add' => 'Insira o nome do ficheiro a adicionar à lista',
    'virtualdir__select_default_doc_to_remove' => 'Seleccione os ficheiros a remover da lista',

    'bt_install_selected' => 'Instalar as chaves de licença seleccionadas.', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'O domínio resolve para outro endereço IP: (%1). Por favor corrija as definições de DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'O servidor de correio que está a utilizar não suporta ter em simultâneo caixas de correio e grupos de correio ligados. Clique OK para permitir caixas de correio em detrimento dos grupos de correio. Clique Cancelar para deixar tudo igual.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'O servidor de correio que está a utilizar não suporta ter em simultâneo caixas de correio e grupos de correio ligados. Clique OK para permitir os grupos de correioem detrimento das caixas de correio. Clique Cancelar para deixar tudo igual.',

    'mysql_dbase_space_limit' => 'Limite do espaço da base de dados MySQL',
    'mysql_dbase_usage' => 'Utilização do espaço da base de dados MySQL',
    'mssql_dbase_space_limit' => 'Limite do espaço da base de dados Microsoft SQL',
    'mssql_dbase_usage' => 'Utilização do espaço da base de dados Microsoft SQL',

    '__statistics' => "estatísticas", //indirect

    'dns__soa_minimum_value_is_big' => 'Configurar o valor do TTL Mínimo para mais de 3 horas pode tornar o seu domínio inacessível a alguns dos administradores de domínio. É recomendado que só coloque esse valor, no caso do seu registar de nomes de domínio insistir.',

    'maillists__server_legend' => 'Definições do Mailman',
    'maillists__secure_links_text' => 'Utilizar ligações seguras nas listas de distribuição de correio',
    'maillists__secure_links_hint' => 'Ativar ou desativar a geração de ligações seguras (HTTPS) nas listas de distribuição de correio.',

    'virusfilter__interface_not_available' => 'Não estão disponíveis filtros de vírus.',
    'virusfilter__none_virus_filter' => 'Nenhum',
    'virusfilter__server_legend' => 'Preferências do antivírus',
    'virusfilter__server_text' => 'Antivírus usados',
    'virusfilter__mailname_status_text' => 'Antivírus (%1)',
    'virusfilter__status_none' => 'desligado',
    'virusfilter__status_any' => 'correio a entrar e a sair',
    'virusfilter__status_outgoing' => 'só correio a sair',
    'virusfilter__status_incoming' => 'só correio a entrar',

    'visibility__adminonly' => 'Só Admin',
    'visibility__button_sets' => 'Controlos',
    'visibility__control' => 'Clique para personalizar este controlo.',
    'visibility__customization_footnote' => 'Clique OK para finalizar a personalização deste ecrã.',
    'visibility__default' => 'Predefinido',
    'visibility__export_note' => "As personalizações efetuadas serão exportadas. Um script de shell será descarregado para o seu computador. Para aplicar estas configurações noutro servidor Paralles Plesk, substituindo as configurações existentes na interface, carregue e execute o script no servidor.\n\note que, caso tenha feito algumas modificações neste ecrã mas ainda não tenha clicado em OK, os dados exportados não incluirão as modificações mais recentes.",
    'visibility__hide' => 'Ocultar',
    'visibility__reset_all' => 'Repor todos para a predefinição',
    'visibility__reset_screen' => 'Repor o formato original deste ecrã',
    'visibility__root_override_parse_error' => 'Existe um erro de sintaxe no ficheiro %1 na linha %2.',
    'visibility__screen_title' => 'Gestão de interface',
    'visibility__set_billing_enabled' => 'Desligar Customer and Business Manager',
    'visibility__set_cert_puchasing' => 'Ocultar os botões de compra de certificados',
    'visibility__set_domain_registration' => 'Ocultar os botões para registo de domínios',
    'visibility__set_extras' => 'Ocultar os botões de serviços extra',
    'visibility__set_mail_bounce' => 'Ocultar os controlos de devolução para mensagens para endereços de correio não existentes',
    'visibility__show' => 'Apresentar',
    'visibility__show_toolbar' => 'Exibir a barra de ferramentas de gestão',
    'visibility__standby_footnote' => 'Clique para personalizar os controlos neste ecrã.',
    'visibility__standby_footnote_nocontrols' => 'Não existem controlos que se possam personalizar neste ecrã.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "A publicação automática não é permitida pelo componente",

    'component_name__cphosting' => "Hospedagem do Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'A configuração da quota das caixas de correio não é permitida por este servidor de correio.',
    '__unable_get_total_mboxes_quota' => 'A configuração da quota das caixas de correio não é permitida por este servidor de correio.',

    'install_prefix__parent_not_exists' => "O directório pai não existe.",

    'bt_change_version' => 'Alterar Versão',
    'aspdotnet__changeversion_title' => 'Seleccionar a Versão do ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Seleccionar Tudo",
    '__uncheck_all' => "Limpar Tudo",

    'dns__editing_domain_controller_zone' => "A modificação de registos de zona DNS de um controlador de domínio pode causar problemas de funcionamento do domínio",

    'pb__interface_management' => "Gestão de Interface",
    'interface_management__tabs_skins' => "Skin",
    'interface_management__tabs_interface_templates' => "Modelos de Interface",
    'interface_management__tabs_locales' => "Pacotes de idiomas",
    'locales_list__title' => "Repositório dos pacotes de idioma",
    'locales_list__legend' => "Idiomas disponíveis",
    'locales_list__active_title' => "F",
    'locales_list__locale_title' => "Pacote de linguagem",
    'locales_list__lang_title' => "Idioma",
    'locales_list__country_title' => "País",
    'locales_list__used_title' => "Usada",

    'backup__suspend_warning_during_backup' => "O domínio estará indisponível durante o processo de backup",
    'backup__suspend_warning_during_restore' => "O domínio estará indisponível durante o processo de reposição",
    'backup__suspend_domain' => "Suspender domínio",

    'locales_list__mls_limit' => "Sua licença atual do Plesk permite utilizar %2 línguas. Neste momento, tem %1 língua definida como disponível para os utilizadores, o que excede o número fornecido com a licença. Selecione %2 línguas que deseje utilizar e deixe o resto indisponível aos utilizadores clicando nos seus ícones da coluna 'S'.",

    'bt_change_owner' => 'Atribuir Novo Proprietário',
    'chown__new_owner' => 'Novo proprietário',
    'chown__selected_domains' => 'Assinaturas selecionadas',
    'chown__limits_legend' => 'Recursos',
    'chown__limit_name' => 'Nome do recurso',
    'chown__limit_value' => 'Recursos atribuídos',
    'chown__limit_assigned_before' => 'Antes da transferência',
    'chown__limit_assigned_after' => 'Após a transferência',
    'chown__error_limits' => "Impossível continuar a transferência da assinatura: esta assinatura requer mais recursos do que a conta do utilizador de destino pode disponibilizar",
    'chown__error_no_domains' => 'Habilite para continuar a transferência de assinatura: nenhuma assinatura selecionada ou assinaturas selecionadas que já pertencem ao usuário de destino.',
    'chown__error_empty_ip_pool' => "Impossível continuar a transferência da assinatura: O repositório de IP do novo proprietário está vazio. Por favor, primeiro, atribua um endereço IP ao cliente.",
    'chown__please_select_new_domain_owner' => 'Selecione o novo proprietário para esta assinatura',
    'chown__old_ip_address' => 'Endereço IP atual',
    'chown__new_ip_address' => 'Novo endereço IP',

    'chown__error_ssl_already_used' => "O suporte ao SSL/TLS já está a ser utilizado nos seguintes IP's de destino: %1 Por isso, os seguintes domínios com suporte SSL não puderam ser transferidos: %2. Por favor, resolva o problema e tente de novo",
    'chown__sitebuilder_not_installed' => 'O Presence Builder não está instalado',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domínio %1 não pode ser transferido para outro proprietário porque o Presence Builder não está instalado.',

    'backup__backup_time' => 'Hora do backup',
    'backup__backup_time_hour' => 'horas',
    'backup__backup_time_minute' => 'minutos',
    'backup__every' => 'a cada',
    'backup__day_of_month' => 'dia do mês',

    'subdomain__select_hst_type' => 'Seleccione o tipo de alojamento para o sub-domínio',
    'hst_sel__subdom_subfolder_hst' => 'Sub-domínio na sub-pasta',
    'subdomain__www_root_folder_not_exists' => 'O directório de inicio do site %1 não existe',
    '__site_home_dir' => 'Directório de inicio do site',
    'subdomain__aspnet_disabled_domain' => 'desligado pelo domínio',

    'domains__remove_description' => 'Todos os dados do domínio, incluindo o conteúdo e configurações do domínio e respectivos subdomínios, aplicações locais, conteúdos de caixas de correio, configurações dos filtros do antivírus e de spam, ficheiros de log, repositório dos dados de backup do domínio e certificados de SSL/TLS serão eliminados. Se não tiver um arquivo de backup na sua máquina local, todos os dados serão perdidos permanentemente.',
    'subdomains__remove_description' => 'Todos os dados do sub-domínio, incluindo o conteúdo e configurações sub-domínio, dados das aplicações locais e ficheiros de log serão eliminados. Se não tiver um arquivo de backup na sua máquina local, todos os dados serão perdidos permanentemente.',

    'mail__no_relay_networks' => 'Não usar restrições ao relay nas seguintes redes:',
    'mail__tabs_spam_filtering' => 'Filtro Spam',
    'mail__tabs_antivirus' => 'Antivírus',
    'server_mail__usage_policy_legend' => 'Termos de utilização',
    'server_mail__for_incoming_mail' => 'para correio a entrar',
    'server_mail__for_outgoing_mail' => 'para correio a sair',
    'server_mail__antivirus_direction_off' => 'Verificação desligada',
    'server_mail__antivirus_direction_any' => 'Verificar o correio tanto a entrar com a sair',
    'server_mail__antivirus_direction_from' => 'Verificar só o correio a sair',
    'server_mail__antivirus_direction_to' => 'Verificar só o correio a entrar',
    'antivirus__use_server_settings_scan' => 'Utilizar as definições predefinidas a nível de servidor (Procurar)',
    'antivirus__use_server_settings_no_scan' => 'Utilizar as definições predefinidas a nível de servidor (Não procurar)',
    'antivirus__check_for_viruses' => 'Procurar vírus',
    'antivirus__dont_check_for_viruses' => 'Não procurar vírus',
    'antivirus__incoming_mail' => 'Correio a entrar',
    'antivirus__outgoing_mail' => 'Correio a sair',

    'domain_alias__CNAME_dns_record_exists' => 'Já existe um registo CNAME de DNS com esse nome',
    'domain_alias__A_dns_record_exists' => 'Já existe um registo A de DNS com esse nome',
    'domain_alias__bad_prefix' => 'Prefixo errado para o nome alternativo do domínio',
    'domain_alias__domain_doesnt_exist' => "O domínio não existe",

    'dns__zone_ttl_message_info' => 'Se o valor TTL não for especificado, o valor TTL no SOA Record Template (%1) será utilizado para este registo DNS.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Será criado um ficheiro com o nome index.html de modo a reendereçar para a aplicação web seleccionada. Se já existir um ficheiro com o nome index.html, será copiado para index.html.old e substituído pelo novo. Carregue em OK para confirmar",

    'bt_ftp_ctrl' => "Contas FTP adicionais",
    'ftp_users_no_permission' => "Não tem permissão de gerir as contas FTP adicionais deste domínio",
    'ftp_users_limit_reached' => "Foi alcançado o limite de subcontas de FTP neste domínio",
    'pb__ftp_ctrl' => "Gestão de FTP",
    'class_client__max_subftp_users' => "Contas FTP adicionais",

    '__client_form_settings' => "Definições do cliente",
    '__sbnet_client_keep_sbnet' => "Mantenha a conta de utilizador correspondente no Presence Builder",
    '__sbnet_cant_add_more_sites' => "Este cliente alcançou o limite da quantidade de sites que pode utilizar no Presence Builder",
    '__sbnet_legend_text' => "Integração do Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Criar uma conta de utilizador correspondente no Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Está a tentar remover uma conta de utilizador do Presence Builder associado a este cliente. Esta ação removerá todos os sites Web e definições do utilizador no sistema do Presence Builder, impedindo a modificação de sites web existentes através do Presence Builder, mesmo que mais tarde ative esta opção. Se mais tarde criar este utilizador do Presence Builder de novo, vai ter de criar e publicar todos os sites web de raiz. Quer desligar a possibilidade de criar e publicar sites web através do Presence Builder?",
    'sb__build_site_with_subdomains' => "Criar subdomínios de Blog e de Galeria Fotográfica",
    '__sbnet_client_dont_have_sbuser' => "Não pode criar ou publicar o site utilizando Presence Builder: O utilizador do Presence Builder não existe",

    '__component_disabled' => "Componente desligada",

    'dns_t__remove_transfer_restrictions_list_items' => "As seguintes redes serão removidas da lista de controlo de acesso (ACL) do modelo de zona de DNS:",

    'subdomains__physical_path_not_exist' => "Existem ssubdomínios ligados a pastas físicas inexistentes",
    'dns__recursion_settings_legend' => "Definições da recursividade de DNS",
    'dns__recursion_on' => "Permitir todos os pedidos",
    'dns__recursion_local' => "Só permitir pedidos locais",
    'dns__recursion_off' => "Negar",

    'dnsserver_bind_to_msdns_switching_warning' => "Aviso: só os primeiros 254 endereços IP das subredes com máscaras /8 e /16 localizadas na Lista de Controlo de Acessos serão transferidos. Eles serão transferidos como endereços IP separados. Deseja continuar?",

    '__sbnet_net_framework_required_for_site' => "Os sites do Presence Builder podem necessitar de suporte do ASP.NET 2.0 no seu domínio. Recomendamos que ative o suporte ASP.NET 2.0 se está a utilizar o Presence Builder.",

    'subdomain_auto_create_dir' => "Criar directório físico para o sub-domínio",

    'sa_trainer__unable_to_get_messages_list' => "Não foi possível obter a lista das mensagens da caixa de correio: %1",
    'sa_trainer__pass_doesnt_exist' => "Falta a senha desta conta de correio",

    '__sitebuilder_error' => "Um erro ocorreu ao tentar se conectar ao Presence Builder. Entre em contato com o seu prestador de serviço para assistência.",
    'wsb_error_user_not_exist' => "O utilizador do Presence Builder não existe.",
    'wsb_error_site_already_exist' => "O site já existe no Presence Builder.",
    'wsb_error_site_limit_reached' => "Atingiu o limite do número de sites no Presence Builder.",
    'wsb_error_internal_error' => "Ocorreu um erro interno do Presence Builder. Por favor, contacte o administrador",
    'wsb_error_user_already_exist' => "Já existe um utilizador do Presence Builder com esse nome.",
    'sb_error_user_not_exist' => "O utilizador do Presence Builder não existe",
    'wsb_error_object_not_found' => "O Presence Builder não conseguiu encontrar a entrada correta do host",

    'mg_no_mail_groups' => "Sem grupos de correio",

    'drweb__drweb_incoming' => 'Verificação antivírus de correio a chegar',
    'drweb__drweb_outgoing' => 'Verificação antivírus de correio a sair',
    'drweb__disable_reason_serv' => 'O servidor de  correio não suporta a configuração do filtro de antivírus a nível da caixa de correio',

    'vz_sitebuilder3_client_cant_be_created' => "Impossível criar conta do cliente: Não está instalada uma versão do Presence Builder 3.1 ou mais recente",

    'chown__client_without_sitebuilder_support' => "Habilite para continuar a transferência de assinatura: O serviço Presence Builder não está incluído no novo plano de serviço do proprietário ou seu fornecedor.",

    // new limits

    'class_client__max_odbc' => "Ligações ODBC",
    'cl_perm__max_odbc' => "Número máximo de conexões ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'F',
    'domain_alias__list_name' => 'Nome do nome alternativo de domínio',
    'domain_alias__list_ascii_name' => 'Em formato ASCII',
    'dns_template__tabs_general' => "Modelo das Definições da Zona",
    'dns_template__tabs_zone_settings' => "Modelo Registos SOA",
    'dns_template__tabs_acl' => "Modelo das Restrições de Transferência",
    'dns_template__tabs_recursion' => "Recursividade de DNS",
    'dns_template__tabs_records_template' => "Modelo de Registos de Zona",


    // Interface Customization Templates
    'interface_preferences' => 'Gestão de Interface',
    'pb__interface_templates' => 'Gestão de interface',
    'pb__interface_clients' => 'Clientes a utilizar %1',

    // service management
    'bt_service_showall' => "Exibir Tudo",
    'bt_service_hideall' => "Ocultar Tudo",
    'bt_service_start' => "Iniciar",
    'bt_service_stop' => "Parar",
    'bt_service_restart' => "Reiniciar",
    'bt_service_disable' => "Desativar",
    'bt_service_manual' => "Manual",
    'bt_service_auto' => "Auto",
    'comp_info__statup_type' => 'Tipo de inicialização',
    'service_startup_auto' => 'Automático',
    'service_startup_manual' => 'Manual',
    'service_startup_disabled' => 'Desligado',
    'service_action_ok' => "A operação do serviço %1 foi completada com sucesso",
    'service_action_failed_disabled_service' => "Impossível completar a operação do serviço %1 porque está desligado",
    'service_action_failed_error' => "Impossível completar a operação: %1",
    'service_group_action_ok' => "A operação dos seguintes serviços foi completada com sucesso: %1",
    'service_group_action_disabled' => "Impossível completar a operação com os seguintes serviços porque estão desligados:\n%1",
    'service_group_action_failed' => "Impossível completar a operação nos seguintes serviços: %1. Para receber informação detalhada do erro, execute a operação separadamente em cada serviço",

    // php 4vs5
    'bt_php' => "Configurações PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Revendedores disponíveis',
    'massmail__resellers_list_selected' => 'Revendedores seleccionados',
    'massmail__clients_list_available_for_select' => 'Clientes disponíveis',
    'massmail__clients_list_selected' => 'Clientes selecionados',
    'massmail__advanced' => 'Avançado',
    'bt_massmail_send' => 'Enviar',
    'massmail__save_template_name' => 'Salvar o texto para um novo modelo com o nome',
    'massmail__template' => 'Modelo',
    'massmail__compose_mail' => 'Mensagem',
    'massmail__from' => 'De',
    'massmail__to' => 'Para',
    'massmail__subject' => 'Assunto',
    'massmail__body' => 'Texto da mensagem',
    'massmail__body_hint' => 'Utilize a variável <name> para inserir automaticamente a informação do nome do Contacto na mensagem',
    'massmail__send_to_clients' => "Clientes",
    'massmail__send_to_domainusers' => "Administradores de Domínio",
    'massmail__send_to_admins' => "Administradores do Plesk",
    'massmail_select' => 'Seleccionar Endereços',
    'massmail_showhide_selected' => "Mostrar/Ocultar a Selecção",
    'massmail_send_all' => "Tudo",
    'massmail_send_selected' => "Só a selecção",
    'massmail_send_except' => "Todos excepto os seleccionados",
    'bt_new_mass_mail_template' => "Adicionar Modelo de E-mail em Massa",
    '__mass_mail_templates_list' => "Lista dos modelos de mensagem de e-mail em massa",
    'massmail__template_name' => 'Nome do modelo',
    'massmail__receivers' => 'Destinatários',
    'massmail__created' => 'Remetente',
    'massmail__date_created' => 'Data de criação',
    'massmail__compose' => 'Enviar',
    'mass_mail__resellers_all' => 'Todos os revendedores',
    'mass_mail__clients_all' => 'Todos os clientes',
    'mass_mail__domainusers_all' => 'Todos os administradores de domínio',
    'mass_mail__resellers_selected' => 'Revendedores seleccionados',
    'mass_mail__clients_selected' => 'Clientes selecionados',
    'mass_mail__domainusers_selected' => 'Administradores de domínio seleccionados',
    'mass_mail__resellers_except' => 'Todos os revendedores excepto os seleccionados',
    'mass_mail__clients_except' => 'Todos os clientes exceto os selecionados',
    'mass_mail__domainusers_except' => 'Todos os administradores de domínio excepto os seleccionados',
    'mass_mail__admins_all' => 'Todos os administradores',
    'massmailtemplateslist__title' => 'Modelos de mensagem de e-mail em massa',
    'massmail__insert_from_template' => "Inserir dados do modelo",
    'massmail__select_template' => "Seleccione o modelo",
    'massmail__body_short_hint' => "(unicamente em texto)",
    'massmail__from_short_hint' => "(e-mail ou nome)",
    'bt_insert' => "Inserir",
    'massmail__mail_send_successfully' => "A mensagem foi enviada com sucesso",
    'massmail__mail_send_successfully_with_some_errors' => "A mensagem foi enviada, mas foram encontrados vários erros. Alguns dos destinatários podem não receber a mensagem. Para mais informação visualize o ficheiro de log: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "A mensagem não foi enviada. Certifique-se que, pelo menos, um destinatário foi selecionado e que o servidor de correio do Plesk está funcionamento corretamente. Para mais informações, veja o seguinte ficheiro de registo: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Os dados do modelo %1 foram inseridos com sucesso",
    'massmail__template_added_successfully' => "Os dados da mensagem de e-mail foram guardados num modelo com o nome %1",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Erro na base de dados do Presence Builder: Por favor, contacte o administrador",
    'wsb_error_sitebuilder_access_denied_error' => "Impossível abrir o ficheiro: Presence Builder não tem direitos de acesso para o ficheiro ou pasta necessário. Por favor, contacte o administrador",
    'wsb_error_sitebuilder_connection_failed' => "Impossível ligar o Presence Builder porque não há ligação. Por favor, contacte o administrador",
    'wsb_error_critical_during_operation' => "Ocorreu um erro critico no Presence Builder\n%1",
    'wsb_error_license_during_operation' => "Ocorreu um erro na licença do Presence Builder:\n%1",
    'wsb_error_during_operation' => "Ocorreu um erro no Presence Builder:\n%1",
    'wsb_error_license_error' => "Foi encontrado um limite na licença do Presence Builder",

    // Other
    '__confrim_service_stop' => "Atenção! A execução do Plesk pode parar caso o serviço %1 seja interrompido. Tem certeza que quer interromper o serviço %1?",
    'virtualdir__name_is_reserved' => "Este nome está reservado",
    'index_redirect_help_text' => 'Agora vai ser redirigido automaticamente para o site pedido. Se o seu browser não suportar a redirecção, por favor clique %1 aqui %2',
    'bt_default_settings' => "Repor Predefinições",
    'logfiles__remove_failed' => "Impossível eliminar o ficheiro %1: o ficheiro está bloqueado por outra aplicação. Por favor, tente mais tarde",
    'subdomain__invalid_homedirectory' => "O directório root, do sub-domínio, especificado é inválido",
    'scheduler_item__empty_filename' => "Por favor, introduza o ficheiro executável a executar.",
    'subdomains__overlapped_domain_exists' => 'O sub-domínio é sobreposto pela zona DNS do domínio %1',
    'subdomains__overlapped_domain_alias_exists' => 'O sub-domínio é sobreposto pela zona DNS do nome alternativo de domínio %1',
    'services_action_none_selected' => 'Impossível completar a operação: por favor seleccione os serviços necessários',
    'cl_perm__max_subftp_users' => "número máximo de contas FTP adicionais",
    'login_up__access_denied_no_cp_access' => 'Acesso recusado. No tem autorização para aceder ao Plesk.',
    'drweb__disable_reason_admin' => "Configurações do filtro do antivírus no e-mail não são permitidas pelas políticas do servidor.",

    'webdirs__name_is_invalid' => 'Utilize só carateres alfanuméricos, traço e sublinhado no nome do diretório Web',
    'webdirs__physical_path_is_invalid' => 'O caminho físico é inválido ou não existe',
    '__use_default' => 'Utilizar predefinição',
    'branding_pagetitle' => 'Configuração da personalização',
    'fieldset_titlebar_setup' => "Título das páginas do Plesk",
    'use_custom_titlebar' => "Texto do título",
    'odbc__dsn_list_legend' => 'Conexões ODBC DSN',

    'webalizer_preferences__title' => 'Preferências das estatísticas de rede',
    'webalizer_preferences__tab_hidden_referrers' => 'Originadores ocultados',
    'webalizer_preferences__tab_group_referrers' => 'Originadores agrupados',

    'webalizer_hidden_referrer__edit_title' => 'Propriedades do registo ocultado',
    'webalizer_hidden_referrer__edit_legend' => 'Registos ocultados',
    'webalizer_hidden_referrer__referrer_type' => 'Tipo de Originador',
    'webalizer_hidden_referrer__referrer' => 'Originador',
    'webalizer_hidden_referrer__list_header' => 'Originadores ocultados',
    'webalizer_hidden_referrer__list_legend' => 'Originadores ocultados',
    'webalizer_hidden_referrer__referrer_direct_request' => 'Pedido directo',
    'webalizer_hidden_referrer__referrer_custom_referrer' => 'Originador',
    'webalizer_hidden_referrer__remove_empty_selection' => 'Nenhum registo seleccionado',
    'webalizer_hidden_referrer__remove_title' => 'Os seguintes originadores não irão ser ocultados:',
    'webalizer_hidden_referrer__already_exist' => 'Esse registo já existe.',

    'webalizer_group_referrer__list_header' => 'Agrupar Origens (Referrers)',
    'webalizer_group_referrer__list_legend' => 'Agrupar Origens (Referrers)',
    'webalizer_group_referrer__edit_title' => 'Propriedades do Grupo Originador',
    'webalizer_group_referrer__edit_legend' => 'Propriedades do Grupo Originador',
    'webalizer_group_referrer__group' => 'Grupo',
    'webalizer_group_referrer__referrer' => 'Originador',
    'webalizer_group_referrer__already_exist' => 'Já existe um grupo de originadores com esse nome.',
    'webalizer_group_referrer__remove_empty_selection' => 'Nenhum originador seleccionado',
    'webalizer_group_referrer__remove_title' => 'Os seguintes sites de originadores serão desagrupados:',

    'pb__dashboard' => 'Início',

    'server_interface__page_title' => 'Preferências da Interface do Servidor',
    'server_interface__tabs_locales' => 'Pacotes de idiomas',
    'server_interface__tabs_skins' => 'Skin',
    'server_interface__tabs_interface_templates' => 'Modelos de Interface',
    'bt_server_interface' => 'Preferências da Interface',
    'pb__server_interface' => 'Preferências da Interface',

    'bt_wizard_next' => 'Seguinte >>',
    'bt_wizard_prev' => '<< Anterior',

    '__limit_exceeded_max_dom_server' => 'Não pode criar alojar domínios porque o servidor chegou ao limite do número de domínios permitido pela chave de licença. Por favor contacte o fornecedor do serviço para resolver este problema.',
    '__limit_exceeded_max_subdom_server' => 'Não pode alojar mais subdomínios neste servidor. Por favor, contacte o seu fornecedor de serviços.',
    '__limit_exceeded_max_dom_aliases_server' => 'Não pode alojar mais nomes alternativos neste servidor. Por favor, contacte o seu fornecedor de serviços.',
    '__limit_exceeded_max_wu_server' => 'Não pode criar mais utilizadores de rede porque alcançou o limite do número de utilizadores de rede permitidas no servidor pela sua chave de licença. Por favor contacte o fornecedor do serviço para resolver este problema.',
    '__limit_exceeded_max_mn_server' => 'Não pode criar mais contas de correio porque alcançou o limite do número de contas de correio permitidas no servidor pela sua chave de licença. Por favor contacte o fornecedor do serviço para resolver este problema.',

    '__limit_exceeded_max_cl_useradmin' => 'Alcançou o limite do número de contas de cliente definidas na sua chave de licença (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Alcançou o limite do numero de domínios definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Atingiu o limite do numero de subdomínios definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Alcançou o limite do numero de nomes alternativos de domínio definido pela sua chave de licença (%2).',
    '__limit_exceeded_disk_space_useradmin' => 'Não tem espaço de disco livre disponível',
    '__limit_exceeded_max_wu_useradmin' => 'Atingiu o limite do numero de contas de utilizador Web definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Alcançou o limite do numero de bases de dados definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Alcançou o limite do numero de caixas de correio definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Alcançou o limite do número de contas de e-mail definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Alcançou o limite do numero de listas de envio definido pela sua chave de licença (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Alcançou o limite do numero de domínios (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Chegou ao limite do numero de subdomínios (%2) permitidos pelo seu fornecedor do serviço.',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Alcançou o limite do numero de nomes alternativos de domínio (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Alcançou o limite de utilização do espaço de disco (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Alcançou o limite de utilização da quantidade de tráfego mensal (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Chegou ao limite do numero de utilizadores de rede (%2) permitidos pelo seu fornecedor do serviço.',
    '__limit_exceeded_max_db_userclient' => 'Alcançou o limite do numero de bases de dados (%2)',
    '__limit_exceeded_max_box_userclient' => 'Alcançou o limite do numero de caixas de correio (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Alcançou o limite do numero de listas de envio (%2)',
    '__limit_exceeded_expiration_userclient' => 'A sua conta expirou em %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Chegou ao limite do numero de subdomínios (%2) permitidos pelo seu fornecedor do serviço.',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Alcançou o limite do numero de nomes alternativos de domínio (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Alcançou o limite de utilização do espaço de disco (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Alcançou o limite de utilização da quantidade de tráfego mensal (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Atingiu o limite do numero de contas de utilizador Web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Alcançou o limite do numero de bases de dados (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Alcançou o limite do numero de caixas de correio (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Alcançou o limite do numero de listas de envio (%2)',
    '__limit_exceeded_expiration_userdomain' => 'A sua conta expirou em %2',

    'mmt__to_none' => 'Nenhum',
    'mmt__to_admin' => 'Administrador',
    'mmt__to_resellers_all' => 'Todos os revendedores',
    'mmt__to_resellers_select' => 'Revendedores seleccionados',
    'mmt__to_resellers_select__available' => 'Revendedores disponíveis',
    'mmt__to_resellers_except' => 'Todos os revendedores excepto os seleccionados',
    'mmt__to_clients_all' => 'Todos os clientes',
    'mmt__to_clients_select' => 'Clientes selecionados',
    'mmt__to_clients_select__available' => 'Clientes disponíveis',
    'mmt__to_clients_except' => 'Todos os clientes exceto os selecionados',

    'mmt__unable_send_empty_selection' => 'Impossível enviar correio em massa, não selecionou endereços de e-mail.',
    'mmt__unable_send_to__' => 'Impossível enviar e-mail em massa para:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Impossível validar a aplicação web porque um dos ficheiros necessários (%1) não foi encontrado. Contacte o suporte do Plesk para assistência.',
    'sapp_error_validation_spec_failed' => 'A aplicação web carregada não está conforme as especificações AppPacks: %1.',
    'sapp_error_validation_register' => 'Impossível registar a aplicação web  localizada no directório "%1": %2 Deve remover a aplicação web do servidor porque não irá funcionar convenientemente.',

    'sapp__install_failed' => 'A instalação da aplicação web falhou: %1',
    'sapp__install_res_failed' => 'Falha ao criar o recurso pedido.',

    'server_preferences__subdomains_blog_and_photo' => 'Criar subdomínios de Blog e Galeria Fotográfica por predefinição',
    'firewall__info' => 'Devido a razões de segurança, a firewall bloqueia todas as conexões excepto aquelas autorizadas explicitamente. Pode permitir uma conexão criando uma regra. Veja a documentação para mais informações',
    'plesk_key__blog_and_photo' => 'Funcionalidade de gerir o estado predefinido da checkbox Criar subdomínios de Blog e Galeria Fotográfica',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Impossível configurar o IP como exclusivo caso esteja atribuído a mais de um cliente',

    // 8.1.1


    'database_server_list__mssql_server_port_undefined' => "Impossível determinar o número da porta TCP utilizada pelo servidor Microsoft SQL '%1': O protocolo TCP/IP não está ativado na configuração de rede do servidor ou o servidor está configurado para utilizar portas TCP dinâmicas.\n Para permitir que os clientes configurem automaticamente a firewall para aceder remotamente à base de dados, configure o servidor SQL manualmente para verificar uma porta TCP específica.",
    '__local_server_mssql' => 'Servidor MS SQL local',
    'pb__db_server_databases' => 'Gestão do servidor de base de dados',

    '__write_modify_warning' => 'Ao seleccionar as permissões adicionais de escrita/modificação vai permitir que algumas aplicações Web funcionem correctamente, mas também vai aumentar significativamente os riscos de segurança',
    '__write_modify_subdomain_warning' => 'Ao seleccionar as permissões adicionais de escrita/modificação vai permitir que algumas aplicações Web funcionem correctamente, mas também vai aumentar significativamente os riscos de segurança',

    'phosting__php_incorrect_version_used' => "Foram detectados problemas na versão de PHP. Para resolver estes problemas, seleccione a checkbox com a versão de PHP necessária e clique OK. Para desactivar o PHP neste domínio, clique OK sem seleccionar a versão de PHP",
    'fp__mail_preferences' => 'Definições de correio',

    'mail__specify_patterns' => 'Endereços de e-mail',
    'mail__blocker_action_text' => 'Que fazer ao correio que corresponder ao critério:',
    'mail__action_delete' => 'Eliminar do servidor',
    'mail__action_spam' => 'Marcar como spam',
    'mail__action_with_mails' => 'Ação',
    'mail__white_list_action_text' => 'O correio que corresponder ao critério não será reconhecido como spam',
    'mail__invalid_white_pattern' => 'Especificou um entrada inválida. Por favor utilize o seguinte formato: correio@exemplo.com para o endereço de e-mail, exemplo.com para domínios ou 123.123.123.123/32 para IPs.',
    'mail__invalid_black_pattern' => 'Especificou um entrada inválida. Por favor utilize o seguinte formato: correio@exemplo.com para o endereço de e-mail, exemplo.com para domínios.',
    'mail__black_list_no_sa_warning' => 'As entradas não vão ser marcadas como spam porque o Spamassassin não está instalado ou está desligado',

    'resp_edit__reply_as_html' => 'Enviar como HTML',
    'exception__path_very_long' => "O caminho é muito longo. Por favor, certifique-se que existem menos de %1 carateres no caminho",

    // 8.2


    //SAPP
    'sapp_on' => 'Ligado',
    'sapp_off' => 'Desligado',
    'sapp_directive_aspect' => 'Necessário',
    'sapp_databases_num' => 'Bases de dados',
    'sapp_db_required' => 'Necessário',
    'sapp_Required' => 'Necessário',
    'sapp_Variant' => 'Variante',
    'sapp_db_id' => 'Id da base de dados',
    'sapp_db_id_type' => 'Tipo de DB (id: %1)',
    'sapp_db_id_min_version' => 'Versão min da DB (id: %1)',
    'sapp_db_id_table_prefix' => 'Prefixo da tabela DB (id: %1)',
    'sapp_Default' => 'Valor predefinido',
    'sapp_apache_mod_req' => 'Módulo Apache',
    'sapp_dbtype_not_installed' => 'não instalado',
    'sapp_apache_mod_not_installed' => 'não instalado',
    'sapp__value_error_empty' => 'Não é permitido um valor nulo',
    'sapp_error_invalid_type' => 'A aplicação "%1" não suporta a acção pedida.',
    'sapp_error_unknown_app_type' => 'Tipo de aplicação não suportado: %1.',
    'sapp__ssl_text' => 'Instalar a aplicação no alojamento em "http://" ou "https://"?',
    'sapp__app_to_upgrade' => 'Aplicações a ser actualizadas',
    'sapp__upgrade_apps_title' => 'Actualizar aplicações',
    'sapp__upgrade_to_ver' => 'Actualizar para a versão',
    'sapp__choose_pkg_ver' => 'Seleccione um pacote...',
    'sapp__pkg_cant_upgrade_pkg' => 'O pacote "%1" não pode ser utilizado para actualizar a aplicação web "%2".',
    'sapp__app_ugrade_error' => 'Impossível actualizar a aplicação: %1. Por favor contacte o administrador de sistema.',
    'sapp__no_suitable_db_found' => 'Não foi encontrada uma base de dados apropriada.',
    'sapp__upgrade_success' =>  'A actualização foi actualizada com sucesso.',
    'sapp__pkg_info_changelog' => 'Histórico das modificações',
    'sapp_requirement_legend' => 'Características do alojamento necessárias pela aplicação',

    // other
    'odbc__mssql_wsid' => 'ID da estação de trabalho',
    'odbc__mssql_driver' => 'Driver',
    'bt_apply' => 'Aplicar',
    'tsclient_disabled' => 'Não tem permissão para aceder ao sistema através do Desktop Remoto',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Para criar um nome alternativo de correio a caixa de correio deve estar ligada nesta conta de correio. Quer ligar a caixa de correio ?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Ao desligar a caixa de correio irá remover os nomes alternativos de correio porque não vão funcionar. Quer desligar a caixa de correio ?',
    'odbc__mysql_driver' => 'Driver MySQL ODBC',
    'antivirus__disable_reason_install' => 'Não pode gerir o antivírus porque não está instalado.',
    'antivirus__disable_reason_key' => 'Não pode ativar o antivírus porque não está ativo com uma chave de licença apropriada',
    'antivirus__disable_reason_deny_personal_settings' => 'Não pode gerir o antivírus porque a política do servidor impede de existir definições individuais de antivírus',
    'component_name__sqladminmssql' => 'Microsoft SQL Web Admin',
    'change_foreign_user_password' => 'Alterar senha',
    'change_foreign_user_password_hint' => "O utilizador não pertence a esta aplicação. Clique no link para ir para uma outra aplicação de modo a modificar a senha do utilizador. Para isso, tem de ter os direitos necssários na aplicação.",
    'cf_url_text' => 'URL JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Formato da String',
    'lang_unknown' => 'Idioma desconhecido',
    'odbc__access_driver' => 'Driver',
    'odbc__access_pwd' => 'Senha',
    'odbc__access_uid' => 'ID de Login',
    'odbc__excel_driver' => 'Driver',
    'pb__cl_ed' => 'Detalhes do cliente',
    'pb__actionlog' => 'Registo de ações',
    'pb__cl_limits' => 'Limites do cliente',
    'pb__edit' => 'Editar',
    'pb__subdom_edit' => 'Definições de alojamento',
    'cf__select_dsn_to_remove' => 'Seleccione pelo menos um nome de fonte de dados para remover',

    // NEW 8.3 FEATURES

    'firewall__port_range_warn_limit' => 'O processamento das regras para esta gama de portas pode demorar muito tempo.\\nContinuar?',
    'firewall__port_range_exceeds_limit' => 'A gama de portas especificada excede o valor disponível de portas de %1',

    'backup_mail_content' => 'Executar o backup do conteúdo das caixas de correio',

    'maillist_import_result' => "Quantidade de endereços de email no ficheiro: %1\nquantidade de endereços de email importados: %2\nquantidade de endereços de email já existentes: %3\nquantidade de endereços de email duplicados no ficheiro especificado: %4\nquantidade de endereços de email inválidos no ficheiro: %5",
    'maillist_import_error' => 'Impossível importar a lista de endereços de email',

    //  spaw

    'spaw__unable_to_edit_no_body' => "O ficheiro seleccionado ou está vazio ou não é um documento HTML válido no código seleccionado. Por favor, seleccione o código correcto ou simplesmente adicione conteúdo ao ficheiro.",

    'dom_pref__external_mail_srv' => "Redirecionar para um servidor de correio externo com o endereço IP:",
    'mn_edit__store_messages' => 'Caixa de Correio',

    // aps

    'sapp__before_upgrade_notice' => 'Recomendamos que execute um backup à aplicação e aos dados de utilizador antes de executar a actualização.',
    'sapp__application_properties' => 'Propriedades da aplicação',
    'sapp__application_root_descr' => 'A página principal da aplicação',

    'sapp__aps_license_invalid_id' => 'A chave de licença tem um ID inválido: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'A licença com a chave numero %1 já existe na base de dados.',
    'sapp__aps_lic_del_used' => 'Impossível eliminar a chave de licença, está a ser utilizada por uma das aplicações instaladas.',
    'sapp__aps_lic_del_unknown' => 'Impossivel eliminar a chave de licença: %1',
    'sapp__aps_cappi_duplicate' => "Esta aplicação já existe no repositório de aplicações do cliente",
    'sapp__appi_not_shared_no_install' => "Não existe essa aplicação no repositório de aplicações do cliente. Se quiser instalar esta aplicação num site, deve primeiro adicionar esta aplicação ao repositório de aplicações do cliente.",
    'sapp__appi_shared_not_client' => "Não existe essa aplicação no repositório de aplicações do cliente. Se quiser atualizar esta aplicação para a versão especificada, deve primeiro adicionar esta aplicação ao repositório do cliente.",
    'sapp__apply_license_script_not_found' => 'Impossível encontrar o script de "aplicação da licença" desta aplicação web.',
    'sapp__unable_to_activate_key' => 'Ocorreu um erro ao tentar activar a chave de licença: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Existem aplicações web instaladas que requerem a presença desta aplicação web no sistema.',
    'sapp__unable_to_delete_ai_in_pool' => 'Esta aplicação ainda está no repositório de um cliente. Se quer remover esta aplicação, tem de primeiro removê-la de todos os repositórios dos clientes ou definir com sendo grátis.',
    'sapp__unable_to_delete_app_template' => 'Impossível remover a aplicação #%1: %2',
    'sapp__limit_exceeded_client' => 'Atingiu o limite do numero de vezes que pode instalar esta aplicação web (%2).',


    // atis module

    '_week_on' => 'semana de',
    '__week_first' => 'primeiro',
    '__week_second' => 'segunda',
    '__week_third' => 'terceira',
    '__week_fourth' => 'quarta',
    '__week_last' => 'último',
    '__not_started' => 'Em espera',
    '__started' => 'Em execução',
    '__cancel_pending' => 'A cancelar',
    '__canceled' => 'Cancelado',
    '__error' => 'Erro',
    '__done' => 'Realizado',

    '__php_cgi_handler' => 'Aplicação CGI',
    '__php_isapi_handler' => 'Extensão ISAPI',
    '__php_fastcgi_handler' => 'Aplicação FasCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'correr como',

    'firewall_tabs_rules' => 'Regras da Firewall',

    'cf_dbfolder_text' =>'Pasta da Base de Dados',
    'cf_isnewdb_text' => 'Criar Base de Dados',
    'cf_isnewdb_title' => 'Selecione a caixa de verificação se a base de dados tiver de ser criada',

    'pb__site_apps_upgrade' => 'Actualização da aplicação web',

    'detach' => 'Desligar',
    'preferences' => "Alterar Palavra-passe",

    'toolsbar__switch_user?' => "Tem a certeza que deseja entrar sob outra conta de utilizador ?",
    '__aps_left' => 'Instalações restantes',
    'aps__license_key' => 'Chave de licença',
    'aps__download_code' => 'Descarregar a chave de licença e o código de activação',
    'aps__license_key_hint' => 'Obter a partir do servidor de licenças utilizando o código de activação',
    'aps__database_not_available' => 'não está disponível, por favor, verifique os limites do domínio ou do cliente',
    'aps__yes' => 'sim',
    'aps__no' => 'não',
    '__click_to_enlarge' => 'Clique para aumentar',
    'site_apps__back_to_list' => 'Voltar à lista',
    'sapp__pkg_info_installation_requirements' => 'Requisitos da instalação',
    '__close_window' => 'Fechar',

    //SAPP END

    'skin_info__already_default' => 'A skin já está definida como a predefinida',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Antivírus premium do Plesk',
    'drweb:properties_page_title' => 'Configurações do antivírus premium do Plesk  %1',
    'drweb:properties_legend' => 'Configurações',
    'drweb:status' => 'A verificar o correio por viroses',

    // sb integration
    'sitebuilder_wizard' => 'Assistente do Presence Builder',
    'dom_site_builder' => 'Clique para abrir o Assistente do Presence Builder.',
    'sb_plesk_admin_url' => 'URL do servidor do Presence Builder. Assegure-se que este endereço é resolvido no DNS',
    'sb_plesk_admin_login' => 'Nome do utilizador do administrador do Presence Builder',
    'sb_plesk_admin_password' => 'Senha do administrador',
    'sb_sitebuilder_preferences' => 'Credenciais do administrador do Presence Builder',
    'sb__server' => 'Preferências do Administrador do Sistema Presence Builder',
    'sb__sitebuilder_support' => 'Suporte do Presence Builder',
    'sb_keep_sb_user' => 'Mantenha a conta de utilizador correspondente no Presence Builder',
    'sb_create_sb_user' => 'Criar uma conta de utilizador correspondente no Presence Builder',
    'sb__build_site_using_sitebuilder' => "Criar o site Web utilizando o Presence Builder",
    'sb_no_current_sb_server_set' => 'Ainda não foi configurada a ligação ao Presence Builder: necessita de acrescentar um registo A ao modelo da zona DNS que irá apontar para o servidor do Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Impossível obter a informação a partir do sistema Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Impossível ligar ao Presence Builder: palavra-passe ou nome de utilizador errado.",
    'sb_init_sb_manager' => "A inicializar o administrador do Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Impossível ligar ao sistema Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Este cliente não tem uma conta de cliente no Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "O Presence Builder não está configurado.",
    'sb_err_you_dont_have_sbaccount' => "A autorização do Presence Builder falhou.",
    'sb_error_critical_during_operation' => "Ocorreu o seguinte erro no Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "O suporte ao Single sign-on está desligado no Plesk.",

    'forbid_create_dns_subzone' => "Não permitir que os utilizadores criem sub-zonas DNS nas super-zonas DNS de outros utilizadores",
    'warning__super_zone_exist' => "A zona %1 foi criada, no entanto, o nome da zona é uma sub-zona de outra já existente %2, que pertence ao utilizador %3. É possível de configurar, no entanto verifique que escolheu a conta de utilizador correcta.",
    'error__super_zone_exist' => "Impossível criar a zona DNS porque a super-zona pertence a outro utilizador.",

    'locales__files_not_exits' => 'Impossível mudar o idioma: os ficheiros do pacote de idioma de interface especificado não existem no sistema.',
    'locales__unavailable' => 'Impossível mudar o idioma: o pacote de idioma de interface especificado não está disponível.',

    // DB BU

    'pb__dbbackup_list' => 'Arquivos de backup da base de dados',
    // server
    'dbbackup__server_backup_settings' => 'Backup',
    'dbbackup__network_temp_dir' => 'Directório temporário da rede',
    'dbbackup__network_user' => 'Nome de utilizador',
    'dbbackup__network_pass' => 'Senha',
    // domain
    'dbbackup__add_database_legend' => 'Repor um backup de uma base de dados',
    'dbbackup__add_database_restore' => 'Repor a base de dados a partir de um arquivo de backup',
    'dbbackup__add_database_file' => 'Arquivo de backup da base de dados',
    'dbbackup__add_database_user' => 'Nome do utilizador predefinido',
    'dbbackup__add_database_pass' => 'Senha do utilizador predefinido',
    'dbbackup__add_database_pass2' => 'Confirmação da senha do utilizador predefinido',

    'bt_dbbackup_now' => 'Efetuar cópia de segurança',

    'bt_repair' => 'Reparar',

    'dbbackup__mssql_dump_upload_not_allowed' => 'O upload de descarregamento de SQL Server é proibido pelo fornecedor de alojamento.',

    // APS categories

    'cf_invalid_password' => 'A senha não pode ser maior que 16 caracteres',
    'cf_invalid_description_length' => 'A descrição não pode ser maior que 256 símbolos',
    'ip_addr__ip_used_by_external_mail_server' => 'O endereço IP %1 já está a ser usado por um servidor de correio externo',

    // 8.4.1

    '__ftp_login_is_invalid' => 'O nome de utilizador ou a palavra-passe do utilizador de FTP não é válida. Por favor, introduza as credenciais corretas do utilizador de FTP',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Foi atingido o limite das modificações ao número de série. Não podem ser efetuadas mais modificações á zona DNS, hoje.',
    'dns__serial_format_legend' => 'Formato do número de série da zona DNS',
    'dns__soa_param_serial_format_hint' => 'A utilização do formato do número de série recomendado pela IETF e RIPE pode resolver situações de recusa do registo e é obrigatório em muitos domínios registados em zonas DNS de alto nível.',
    'dns__soa_param_serial_format' => 'Utilizar o formato do numero de série recomendado pela IETF e RIPE',
    'dns__serial_format_dns_zone_update_delay' => 'Ao mudar entre formatos do numero de série da zona DNS pode causar um atraso na actualização da zona DNS',
    'dns__zone_apply_changes' => 'As modificações feitas aos registos DNS ainda não foram salvas. As modificações executadas estão destacadas em baixo. Clique Actualizar para aplicar as modificações á zona DNS ou clique Reverter para cancelar as modificações.',
    'dns__update_dns_zone' => 'Clique para salvar as modificações efectuadas aos registos DNS',
    'dns__revert_dns_zone' => 'Clique para cancelar as alterações feitas aos registos DNS',
    'bt_revert' => 'Reverter',
    'dns__dns_zone_has_beed_updated' => 'As modificações feitas aos registos DNS foram salvas.',
    'dns__dns_zone_has_beed_reverted' => 'As modificações feitas aos registos DNS foram canceladas',
    'db__nondefault_server_not_allowed' => 'Só é permitida a utilização de servidores de bases de dados predefinidos',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Domínios e contas do cliente %1.',
    'ui__client__disabled-warning' => 'A conta do cliente %1 está suspensa.',
    'ui__client__none-available' => 'Não existem contas de clientes configuradas.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Cliente %1',
    'ui__client_self__description' => 'Lista dos meus domínios.',
    'ui__client_self__short-title' => 'Os meus domínios',
    'ui__client_self__title' => 'Os meus domínios',


    'site_apps__non_removable' => 'Itens que não podem ser removidos',
    'site_apps__non_removable_items' => 'As seguintes aplicações web não podem ser removidas:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Não existem botões personalizados.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Não existem teclas personalizadas no Painel de Cliente do cliente %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Remover o botão %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Eliminar',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Remover o botão %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Remover teclas personalizadas do Painel de Cliente do cliente',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Eliminar',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Remover botões personalizados',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Remover botões',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Selecione o cliente cujos botões personalizados deseja remover e clique Seguinte >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Seleccione os botões que deseja remover e clique Seguinte >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Confirme a remoção dos botões seleccionando a checkbox neste ecrã e clique Finalizar.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Remover uma tecla personalizada do Painel de Cliente do cliente.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Eliminar',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Remover um botão personalizado',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Remover botão personalizado',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Selecione o cliente para o qual quer remover o botão personalizado e clique Seguinte >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Seleccione o botão personalizado que quer remover e clique Seguinte >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Confirme a remoção do botão personalizado seleccionando a checkbox neste écran e clique Finalizar.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Editar as propriedades do botão personalizado %1 a nível de cliente.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Configurações',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Modificar o botão personalizado %1 do cliente',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Adicionar botão personalizado',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selecionar o cliente para o qual quer criar uma tecla personalizada no Painel de Cliente e clicar em Seguinte>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Clique Finalizar para criar o botão.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Alterar as propriedades de uma tecla no Painel de Cliente do cliente.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Propriedades',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Alterar as propriedades de uma tecla no Painel de Cliente do cliente',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Mudar as propriedades do botão personalizado',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Selecione um cliente cujo botão personalizado deseja modificar e clique Seguinte >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Seleccione um botão personalizado deseja modificar e clique Seguinte >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Quando terminar de modificar as propriedades do botão, clique Finalizar para aplicar as modificações e sair do assistente.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Não disponibilizar o botão %1 aos seus clientes.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Indisponibilizar aos seus clientes',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Não disponibilizar o botão %1 aos seus clientes',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Deixar os clientes do seu cliente visualizar o botão %1.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Disponibilizar aos seus clientes',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Deixar os clientes do seu cliente visualizar o botão %1',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Disponibilize ou não um botão personalizado aos seus clientes.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Disponível/não disponível aos seus clientes',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Disponibilize ou não um botão personalizado aos seus clientes',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Disponibilize ou não um botão personalizado aos seus clientes.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Selecione o cliente cujos botões personalizados deseja disponibilizar aos seus clientes e clique Seguinte >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Seleccione um botão personalizado que deseja que fique disponível ou não aos seus clientes e clique Seguinte >>.',

    'ui__client/domain__description' => 'Gerir domínio %1.',
    'ui__client/domain__disabled-warning' => 'O domínio %1 está suspenso.',
    'ui__client/domain__none-available' => 'Não tem domínios.',
    'ui__client/domain__none-available__1' => 'A conta de %1 não tem domínios.',
    'ui__client/domain__none-available__2' => 'A conta de %1 não tem domínios.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domínio %1',
    'ui__client/domain_self__description' => 'Gerir o seu domínio.',
    'ui__client/domain_self__disabled-warning' => 'O seu domínio foi suspenso.',
    'ui__client/domain_self__quick-search' => 'Os meus domínios',
    'ui__client/domain_self__short-title' => 'O meu domínio',
    'ui__client/domain_self__title' => 'O meu domínio',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Não existem teclas personalizadas colocadas no Painel de Cliente do cliente.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'O cliente %1 não tem teclas personalizadas no Painel de Cliente.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Não existem botões personalizados para o domínio %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Remover o botão personalizado %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Eliminar',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Remover o botão personalizado %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Remover botões personalizados.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Remover botões personalizados',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Remover botões personalizados',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Selecione o cliente do qual deseja remover os botões do painel de gestão de domínio e clique Seguinte >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Seleccione o domínio ao qual quer remover os botões do painel de administração e clique seguinte >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Seleccione os botões que deseja remover e clique Seguinte >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Confirme a remoção dos botões seleccionando as respectivas checkbox  e clique Finalizar para remover os botões e sair do assistente.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Remover um botão personalizado.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Eliminar',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Remover um botão personalizado',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Remover um botão personalizado',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Selecione o cliente do qual deseja remover os botões personalizados do painel de gestão de domínio e clique Seguinte >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Seleccione o domínio ao qual quer remover o botão do painel de administração e clique seguinte >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Seleccione o botão personalizado que quer remover e clique Seguinte >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Confirme a remoção do botão seleccionando a checkbox e clique Finalizar para remover o botão e terminar o assistente.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Modificar as propriedades do botão personalizado %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Propriedades",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Alterar as propriedades de uma tecla personalizada %1 no Painel de Cliente.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Adicionar um botão',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selecionar o cliente em cujo Painel de Cliente pretende colocar a tecla e clicar em Seguinte>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Selecione a assinatura no qual quer modificar o botão do painel de controlo e clique Seguinte >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Clique Finalizar para criar o botão e sair do assistente.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Alterar as propriedades de uma tecla no Painel de Cliente do cliente.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Propriedades',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Alterar as propriedades de uma tecla no Painel de Cliente do cliente',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Modificar as propriedades do botão',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Seleccione o botão personalizado cujas propriedades deseja modificar e clique Seguinte >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Quando terminar as modificações das propriedades do botão, clique Finalizar para aplicar as modificações e sair do assistente.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Não disponibilizar o botão %1 aos utilizadores de correio deste domínio.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Indisponível para os utilizadores de correio',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Não disponibilizar o botão %1 aos utilizadores de correio deste domínio',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Deixar os utilizadores de correio deste domínio visualizarem o botão %1.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Acessível aos utilizadores de correio neste domínio',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Deixar os utilizadores de correio deste domínio visualizarem o botão personalizado %1',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Disponibilizar ou não um botão personalizado aos outros utilizadores.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Disponível/indisponível aos outros utilizadores',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Disponibilizar ou não um botão personalizado aos utilizadores de correio',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Disponibilizar ou não um botão personalizado aos outros utilizadores',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Seleccione o domínio onde o botão é colocado e clique Seguinte >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Seleccione um botão que deseja que fique disponível ou indisponível aos outros utilizadores e clique Seguinte >>.',

    'ui__client/domain/delete__description' => 'Remover o domínio %1.',
    'ui__client/domain/delete__short-title' => 'Eliminar',
    'ui__client/domain/delete__title' => 'Remover o domínio %1',
    'ui__client/domain/delete_multi__description' => 'Remover domínios.',

    'ui__client/domain/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/delete_multi__title' => 'Remover domínios',
    'ui__client/domain/delete_multi__wizard-title' => 'Remover domínios',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Seleccione os domínios que deseja remover e clique Seguinte >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Confirme a remoção dos domínios seleccionando a checkbox e clique Finalizar para remover e sair do assistente.',
    'ui__client/domain/delete_unknown__description' => 'Remover um domínio.',
    'ui__client/domain/delete_unknown__short-title' => 'Eliminar',
    'ui__client/domain/delete_unknown__title' => 'Remover domínio',
    'ui__client/domain/delete_unknown__wizard-title' => 'Remover um domínio',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Seleccione um domínio que queira remover e clique Seguinte >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Confirme a remoção do domínio seleccionando a checkbox, clique Finalizar para remove-lo e sair do assistente.',

    'ui__client/domain/hosting__none-available' => 'Não existem domínios configurados para alojamento web. Crie um domínio e configure-lhe o alojamento web para ter acesso a esta funcionalidade.',
    'ui__client/domain/hosting__none-available__1' => 'A conta de utilizador não tem nenhuns domínios configurados para alojamento web. Configure o alojamento web nos domínios que requerem esta funcionalidade.',
    'ui__client/domain/hosting__none-available__2' => 'O alojamento não está configurado no domínio %1. Configure o alojamento web no domínio %1 para aceder a esta funcionalidade.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'Gerir os seus ficheiros e directórios',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'Seleccione o domínio cujos ficheiros quer trabalhar.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'O alojamento ainda não está configurado no domínio. Por favor, configure o alojamento físico e clique Seguinte >> para prosseguir para o gestor de ficheiros.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'O alojamento ainda não está configurado no seu domínio. Por favor, configure o alojamento físico e clique Seguinte >> para ir para o gestor de arquivos.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'Quando terminar de gerir os ficheiros e diretórios, clique Finalizar para sair do assistente.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'Quando terminar de gerir os ficheiros e diretórios, clique Finalizar para sair do assistente.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'Ver as definições de configurações do alojamento',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'Ajustar as configurações de desempenho do alojamento Web',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'Seleccione o domínio que deseja ver as definições do desempenho do alojamento e clique Seguinte >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'Seleccione o domínio que deseja configurar as definições do desempenho do alojamento e clique Seguinte >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'Ajuste as configurações de desempenho do alojamento no domínio e clique Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'Quando acabar de ver as configurações de desempenho do alojamento no domínio, clique Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'Quando acabar de ver as configurações de desempenho do alojamento no seu domínio, clique Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'Quando acabar de ver as configurações de desempenho do alojamento no domínio, clique Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'Quando acabar de configurar as configurações de desempenho do alojamento no seu domínio, clique Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'Quando acabar de configurar as configurações de desempenho do alojamento no domínio, clique Finalizar.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Clientes",
    'ui__client/domain/hosting/application#list_header__description__title' => "Descrição",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Itens",
    'ui__client/domain/hosting/application#list_header__name__title' => "Nome",
    'ui__client/domain/hosting/application#list_header__release__title' => "Revisão",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Ordenar por clientes",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Ordenar por descrição",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Ordenar por itens",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Ordenar por nome",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Ordenar por revisão",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Ordenar por versão",
    'ui__client/domain/hosting/application#list_header__title' => "Aplicações web",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versões",

    'ui__client/domain/properties__client_ip_address_was_assigned' => 'O endereço IP %%ip_address%% foi atribuído ao cliente %%client_name%%.',
    'ui__client/domain/properties__client_ip_pool_is_empty' => 'O repositório de IP do cliente está vazio. O endereço IP seleccionado será atribuído á conta do utilizador correspondente.',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => 'O novo domínio será criado imediatamente após clicar Seguinte >>.',

    'ui__client/domain/properties_new__wizard-title' => 'Criar domínio',
    'ui__client/domain/properties_new__wizard__1_unknown' => 'Selecione o cliente para o qual quer criar o domínio.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => 'Seleccione o tipo de alojamento desejado e clique Seguinte >>.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => 'Quando acabar de configurar o reendereçamento para o seu domínio, clique Finalizar para aplicar as modificações e sair do assistente.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => 'Quando terminar de configurar o serviço de alojamento para o domínio, clique Finalizar para aplicar as modificações e sair do assistente.',

    'ui__client/domain/properties_unknown__wizard-title' => 'Configurar a conta de administração do domínio',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => 'Seleccione o domínio no qual quer definir uma conta de administrador de domínio.',
    'ui__client/domain/properties_unknown__wizard__3' => 'Para terminar a criação da conta de admnistrador de domínio, clique Finalizar.',
    'ui__client/domain/properties_unknown__wizard__3_self' => 'Para aplicar as modificações e sair do assistente, clique Finalizar.',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => 'Estatísticas do FTP anónimo para um domínio',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => 'Estatísticas do FTP anónimo',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => 'Estatísticas do FTP anónimo para um domínio',

    'ui__client/domain/report/ftp-stats_unknown__description' => 'Estatísticas de FTP para um domínio',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'Estatísticas FTP',
    'ui__client/domain/report/ftp-stats_unknown__title' => 'Estatísticas de FTP para um domínio',

    'ui__client/domain/report/traffic__description' => 'Ver a utilização da largura de banda do site %1',
    'ui__client/domain/report/traffic__short-title' => 'Utilização da largura de banda',
    'ui__client/domain/report/traffic__title' => 'Largura de banda utilizada pelo site %1',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => 'Estatísticas de visitas ao site seguro',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => 'Estatísticas de rede SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => 'Estatísticas de visitas ao site seguro',

    'rpt_reseller_section_general' => 'Geral',
    'rpt_reseller_section_domains' => 'Domínios',
    'rpt_reseller_section_clients' => 'Clientes',
    'statistics__cl_active_domains' => "Domínios activos",
    'rpt_reseller_cl_domains' => "Domínios",
    'rpt_reseller_cl_subdomains' => "Subdomínios",
    'by__cl_domains' => "domínios do cliente",
    'dom_ctrl__cl_mboxes' => "Caixas de correio",
    'rpt_reseller_cl_redirects' => "Redirecionamentos",
    'rpt_reseller_cl_mail_groups' => "Grupos de e-mail",
    'rpt_reseller_cl_mail_resps' => "Respostas automáticas",
    'rpt_reseller_cl_mail_lists' => "Listas de envio",
    'rpt_reseller_cl_web_users' => "Utilizadores de rede",
    'rpt_reseller_cl_data_bases' => "Bases de dados",

    'statistics__active_clients' => 'Clientes com assinaturas ativas',
    'statistics__clients_active_domains' => 'Domínios activos',
    'statistics__clients_doms' => 'Domínios',
    'statistics__cl_doms' => 'Domínios',
    '__clients_subdomains' => 'Subdomínios',
    '__clients_domains' => 'Domínios',
    'dom_ctrl__clients_mboxes' => 'Caixas de correio',
    'dom_ctrl__clients_redir' => 'Redirecionamentos',
    'dom_ctrl__clients_mg' => 'Grupos de e-mail',
    'dom_ctrl__clients_resp' => 'Respostas automáticas',
    'dom_ctrl__clients_maillists' => 'Listas de envio',
    'dom_ctrl__clients_wu' => 'Utilizadores de rede',
    'dom_ctrl__clients_db' => 'Bases de dados',

    'dom_ctrl__cl_redir' => 'Redirecionamentos', // to resolve!
    'dom_ctrl__cl_mg' => 'Grupos de e-mail', // to resolve!
    'dom_ctrl__cl_resp' => 'Respostas automáticas', // to resolve!
    'dom_ctrl__cl_maillists' => 'Listas de envio', // to resolve!
    'dom_ctrl__cl_wu' => 'Utilizadores de rede', // to resolve!
    'dom_ctrl__cl_db' => 'Bases de dados', // to resolve!

    'rpt_cl_section_clients' => 'Clientes',

    'rpt_admin_section_general' => 'Geral',
    'rpt_admin_section_resellers' => 'Revendedores',
    'rpt_admin_section_clients' => 'Clientes',
    'rpt_admin_section_personal_clients' => 'Clientes pessoais',
    'rpt_admin_section_domains' => 'Domínios',
    'rpt_admin_section_personal_domains' => 'Domínios directos',

    'rpt_reseller_section_personal_domains' => 'Domínios directos',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Selecione o domínio que quer suspender ou reativar.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Suspender ou reativar um domínio',

    'ui__client/ip-pool__description' => 'Atribuir e retirar endereços IP e certificados SSL/TLS ao cliente %1.',
    'ui__client/ip-pool__short-title' => 'Repositório de IP',
    'ui__client/ip-pool__title' => 'Repositório de IP do cliente %1.',
    'ui__client/ip-pool_self__description' => 'Visualizar o seu repositório de IP\'s.',
    'ui__client/ip-pool_self__short-title' => 'Repositório de IP',
    'ui__client/ip-pool_self__title' => 'O meu repositório de IP/\'s',
    'ui__client/ip-pool/properties__description' => 'Configurar o repositório de IP para o cliente %1.',

    'ui__client/ip-pool/properties__short-title' => 'Repositório de IP',
    'ui__client/ip-pool/properties__title' => 'Configurar o repositório de IP para o cliente %1',
    'ui__client/ip-pool/properties_self__description' => 'Visualizar o seu repositório de IP\'s.',

    'ui__client/ip-pool/properties_self__short-title' => 'O meu repositório de IP/\'s',
    'ui__client/ip-pool/properties_self__title' => 'O meu repositório de IP/\'s',
    'ui__client/ip-pool/properties_unknown__description' => 'Atribuir ou retirar endereços IP e certificados SSL/TLS ao cliente.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Repositório de IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Configurar o repositório de IP do cliente',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Configurar o repositório de IP do cliente',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Selecione o cliente ao qual quer configurar o repositório de IP\'s.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Quando terminar de configurar o repositório de IP\'s do cliente, clique Finalizar para aplicar as modificações e sair do assistente.',


    'ui__client/limits_readonly-unknown__description' => 'Ver os limites dos recursos de um cliente.',
    'ui__client/limits_readonly-unknown__short-title' => 'Limites de recursos',
    'ui__client/limits_readonly-unknown__title' => 'Ver os limites dos recursos de uma conta de cliente',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Ver ou alterar os limites dos recursos de um cliente',

    'ui__client/limits_unknown__wizard-title' => 'Ver ou alterar os limites dos recursos de um cliente',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Selecione o cliente que necessita.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Selecione o cliente que necessita.',
    'ui__client/limits_unknown__wizard__2' => 'Para aplicar as modificações, clique Finalizar.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Para sair do assistente, clique Finalizar.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Para sair do assistente, clique Finalizar.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Para sair do assistente, clique Finalizar.',

    'ui__client/permissions_unknown__wizard-title' => 'Ver ou modificar as permissões de um cliente',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Quando terminar de visualizar as suas permissões, clique Finalizar para aplicar as modificações e sair do assistente.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Selecione o cliente ao qual quer visualizar/editar as permissões.',
    'ui__client/permissions_unknown__wizard__2' => 'Quando terminar de editar as permissões do cliente, clique Finalizar para aplicar as modificações e sair do assistente.',

    'ui__client/preferences_unknown__wizard-title' => 'A editar as preferências do cliente',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Selecione o cliente ao qual quer gerir as preferências da sessão e da interface.',
    'ui__client/preferences_unknown__wizard__2' => 'Quando terminar de modificar as preferências do cliente, clique Finalizar.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Após modificar as suas preferências, clique Finalizar.',

    'ui__custom-buttons/custom-button__none-available' => 'Não tem botões personalizados.',
    'ui__custom-buttons/custom-button/delete__description' => 'Remover o botão personalizado %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Eliminar',
    'ui__custom-buttons/custom-button/delete__title' => 'Remover o botão personalizado %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Remover os botões personalizados.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Eliminar',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Remover botões personalizados',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Remover botões personalizados',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Seleccione os botões que deseja remover.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Confirme a remoção dos botões seleccionando a checkbox e clique Finalizar para terminar o assistente.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Remover botões personalizados.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Eliminar',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Remover botões personalizados',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Remover botões personalizados',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Seleccione qual o botão personalizado que quer remover.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Confirme a remoção do botão seleccionando a checkbox e clique Finalizar para terminar o assistente.',
    'ui__custom-buttons/custom-button/properties__description' => 'Mudar as propriedades do botão %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Propriedades',
    'ui__custom-buttons/custom-button/properties__title' => 'Mudar as propriedades do botão %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Criar um botão',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Clique Finalizar para criar o botão.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Mudar as propriedades de um botão personalizado.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Propriedades',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Mudar as propriedades de um botão personalizado',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Mudar as propriedades de um botão personalizado',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Seleccione o botão personalizado cujas propriedades deseja modificar.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Para aplicar as modificações, clique Finalizar.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Não disponibilizar o botão personalizado %1 aos outros utilizadores.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Indisponível para os outros utilizadores',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Não disponibilizar o botão personalizado %1 aos outros utilizadores',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Disponibilizar o botão personalizado %1 aos outros utilizadores.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Disponivel aos outros utilizadores',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Disponibilizar o botão personalizado %1 aos outros utilizadores',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Disponibilizar ou não o botão personalizado aos outros utilizadores.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Disponivel ou indisponivel aos outros utilizadores',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Disponibilizar ou não o botão personalizado aos outros utilizadores',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Disponibilizar ou não o botão personalizado aos outros utilizadores',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Seleccione o botão personalizado que deseja que fique disponível ou indisponivel aos outros utilizadores e clique Seguinte >>.',

    'ui__longtasks#list_header__name__title' => "Nome",
    'ui__longtasks#list_header__owner__title' => "Proprietário",
    'ui__longtasks#list_header__start_time__title' => "Hora de criação",
    'ui__longtasks#list_header__status__title' => "Estado",
    'ui__longtasks#list_header__title' => "Tarefas",
    'ui__longtasks#list_header__finish_time__title' => "Tempo decorrido",
    'ui__longtasks#task_list_legend__title' => "Tarefas",
    'ui__longtasks#tools_legend__title' => "Ferramentas",
    'ui__longtasks__description' => "Gerir tarefas em segundo plano",
    'ui__longtasks__short-title' => "Tarefas em Segundo Plano",
    'ui__longtasks__title' => "Tarefas em Segundo Plano",
    'ui__longtasks/longtask/properties#current_operation__title' => "Operação a decorrer:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Tempo estimado para terminar:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Geral",
    'ui__longtasks/longtask/properties#owner__title' => "Tarefa iniciada por:",
    'ui__longtasks/longtask/properties#progress__title' => "Progresso total:",
    'ui__longtasks/longtask/properties#start_time__title' => "Tarefa iniciada:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Estado da tarefa",
    'ui__longtasks/longtask/properties__description' => "Estado e informação da tarefa em segundo plano",

    'ui__longtasks/properties__description' => "Definições das tarefas em segundo plano",
    'ui__longtasks/properties__short-title' => "Configurações",
    'ui__longtasks/properties__title' => "Tarefas em segundo plano",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Modelos de mensagem de e-mail em massa',
    'ui__mass-mail/template#list_header__name__title' => 'Nome do modelo',
    'ui__mass-mail/template#list_header__from_email__title' => 'Remetente',
    'ui__mass-mail/template#list_header__to__title' => 'Destinatários',
    'ui__mass-mail/template#list_header__subject__title' => 'Assunto',
    'ui__mass-mail/template#list_header__cdate__title' => 'Data de criação',
    'ui__mass-mail/template#list_header__send__title' => 'Enviar',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Editar o Modelo de Mensagem de E-mail em Massa',
    'ui__mass-mail/template/properties__description' => 'Editar este modelo de mensagem de e-mail em massa.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Adicionar Modelo de E-mail em Massa',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Adicionar Modelo de E-mail em Massa',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Adicionar um modelo de mensagem de e-mail em massa.',
    'ui__mass-mail/send__short-title' => 'Enviar E-Mail em Massa',
    'ui__mass-mail/send__title' => 'Enviar Mensagem de E-Mail em Massa',
    'ui__mass-mail/send__description' => 'Enviar mensagem de e-mail em massa aos destinatários selecionados.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Remover Modelos de E-mail em Massa',
    'ui__mass-mail/template/delete_multi__title' => 'Remover estes modelos de mensagem de e-mail em massa:',
    'ui__mass-mail/template/delete_multi__description' => 'Remover os modelos de mensagem de e-mail em massa selecionados.',
    'ui__mass-mail/template/delete_multi__done' => 'Foram removidos os modelos de mensagem selecionados.',
    'ui__mass-mail/template/properties__invalid_values' => 'Especificou valores inválidos',


    // old
    'ui__mass-mail#body_text__description' => 'Poderá utilizar a <name>variável no texto da mensagem (mas não no cabeçalho). Será substituído pelo nome de contacto do cliente ou do revendedor.',
    'ui__mass-mail#body_text__title' => 'Texto da mensagem',
    'ui__mass-mail#compose_legend__title' => 'Mensagem',
    'ui__mass-mail#from_email_text__title' => 'De (endereço de email)',
    'ui__mass-mail#list_header__cdate__title' => 'Criado',
    'ui__mass-mail#list_header__from_email__title' => 'De',
    'ui__mass-mail#list_header__name__title' => 'Nome',
    'ui__mass-mail#list_header__send__title' => 'Criar mensagem',
    'ui__mass-mail#list_header__subject__title' => 'Assunto',
    'ui__mass-mail#list_header__title' => 'Modelos de mensagem de e-mail em massa',
    'ui__mass-mail#list_header__to__title' => 'Para',
    'ui__mass-mail#list_legend__title' => 'Modelos de mensagem de e-mail em massa',
    'ui__mass-mail#load_template_text__title' => 'Carregar',
    'ui__mass-mail#name_text__title' => 'Nome do modelo',
    'ui__mass-mail#option_mode_all__title' => 'Tudo',
    'ui__mass-mail#option_mode_except__title' => 'Todos excepto os seleccionados',
    'ui__mass-mail#option_mode_select__title' => 'Só a selecção',
    'ui__mass-mail#option_select_template__title' => '---Seleccione um modelo---',
    'ui__mass-mail#picker_legend__title' => 'Modelos de mensagem de e-mail',
    'ui__mass-mail#picker_title__title' => 'Seleccione um modelo',
    'ui__mass-mail#save_as_legend__title' => 'Salvar como modelo',
    'ui__mass-mail#save_as_text__title' => 'Salvar a mensagem definida para um novo modelo com o nome',
    'ui__mass-mail#subject_text__title' => 'Assunto',
    'ui__mass-mail#template_legend__title' => 'Modelo',
    'ui__mass-mail#to_admin_text__title' => 'Administrador Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Clientes',
    'ui__mass-mail#to_domains_text__title' => 'Administradores de domínio',
    'ui__mass-mail#to_select_text__title' => 'Seleccione os endereços',
    'ui__mass-mail#to_show_hide_text__title' => 'Exibir/ocultar selecção',
    'ui__mass-mail#to_text__title' => 'Para',
    'ui__mass-mail#tools_legend__title' => 'Ferramentas',
    'ui__mass-mail__already_exists' => 'Já existe um modelo com o nome %1',
    'ui__mass-mail__none-available' => 'Não tem modelos de mensagens.',

    'ui__mass-mail/delete__description' => 'Remover modelo de mensagem de e-mail em massa %1',

    'ui__mass-mail/delete__empty_selection' => 'Por favor, escolha os modelos que quer remover',
    'ui__mass-mail/delete__short-title' => 'Remover %1',
    'ui__mass-mail/delete__title' => 'Remover modelo de mensagem de e-mail em massa %1',
    'ui__mass-mail/delete_multi__description' => 'Remover modelos de mensagem de e-mail em massa.',

    'ui__mass-mail/delete_multi__short-title' => 'Eliminar',
    'ui__mass-mail/delete_multi__title' => 'Remover modelos de mensagem de e-mail em massa',
    'ui__mass-mail/delete_multi__wizard-title' => 'Remoção dos modelos de mensagem de e-mail em massa',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Selecione os modelos de mensagem de e-mail em massa que quer remover.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Confirme a remoção dos modelos seleccionando a checkbox e clique Finalizar para terminar o assistente.',
    'ui__mass-mail/delete_unknown__description' => 'Remover modelos de mensagem de e-mail em massa.',
    'ui__mass-mail/delete_unknown__short-title' => 'Eliminar',
    'ui__mass-mail/delete_unknown__title' => 'Remover modelos de mensagem de e-mail em massa',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Remoção dos modelos de mensagem de e-mail em massa.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Selecione o modelo de mensagem de e-mail em massa que quer remover.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Confirme a remoção do modelo seleccionando a checkbox e clique Finalizar para terminar o assistente.',

    'ui__mass-mail/properties__description' => 'Editar o modelo %1 da mensagem de e-mail.',

    'ui__mass-mail/properties__invalid_values' => 'Especificou valores incorrectos',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Editar o modelo %1 da mensagem de e-mail',

    'ui__mass-mail/properties_new__wizard-title' => 'Criar modelo de mensagem de e-mail em massa',
    'ui__mass-mail/properties_unknown-new__description' => 'Criar um modelo de mensagem de e-mail.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Adicionar modelo de mensagem de e-mail',
    'ui__mass-mail/properties_unknown-new__title' => 'Criar modelo de mensagem de e-mail',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Editar modelo de mensagem de e-mail em massa',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Seleccione o modelo que quer modificar e clique Seguinte >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Quando terminar de modificar o modelo, clique Finalizar para aplicar as modificações e sair do assistente.',

    'ui__mass-mail/send__invalid_values' => 'Especificou valores incorrectos',

    'ui__mass-mail/send_new__wizard-title' => 'Criar um Modelo de Mensagem e Enviar E-mail',
    'ui__mass-mail/send_unknown-new__description' => 'Enviar e-mail aos destinatários selecionados',

    'ui__mass-mail/send_unknown-new__short-title' => 'Enviar E-Mail em Massa',
    'ui__mass-mail/send_unknown-new__title' => 'Enviar Mensagem de E-Mail em Massa',
    'ui__mass-mail/send_unknown__description' => 'Enviar e-mail aos destinatários selecionados',

    'ui__mass-mail/send_unknown__short-title' => 'Enviar E-Mail em Massa',
    'ui__mass-mail/send_unknown__title' => 'Enviar Mensagem de E-Mail em Massa',
    'ui__mass-mail/send_unknown__wizard-title' => 'Enviar Mensagem de E-Mail em Massa',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Seleccione o modelo que necessita e clique Seguinte >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Quando terminar de modificar as propriedades do modelo, clique Finalizar para enviar a mensagem e sair do assistente.',

    'ui__mass-email/delete__description' => 'Remover os modelos de mensagem de e-mail em massa selecionados.',

    'ui__mass-email/delete__empty_selection' => "Por favor, selecione os modelos que quer remover",
    'ui__mass-email/delete__short-title' => "Remover %1",
    'ui__mass-email/delete__title' => "Remover modelo de mensagem de e-mail em massa %1",
    'ui__mass-email/delete_multi__description' => "Remover modelos de mensagem de e-mail em massa.",

    'ui__mass-email/delete_multi__short-title' => "Eliminar",
    'ui__mass-email/delete_multi__title' => "Remover modelos de mensagem de e-mail em massa",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Confirme a remoção dos modelos seleccionando a checkbox e clique Finalizar para terminar o assistente.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Selecione os modelos de mensagem de e-mail em massa que quer remover.",
    'ui__mass-email/delete_multi__wizard-title' => "Remoção dos modelos de mensagem de e-mail em massa",
    'ui__mass-email/delete_unknown__description' => "Remover modelos de mensagem de e-mail em massa.",
    'ui__mass-email/delete_unknown__short-title' => "Eliminar",
    'ui__mass-email/delete_unknown__title' => "Remover modelos de mensagem de e-mail em massa",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Confirme a remoção do modelo seleccionando a checkbox e clique Finalizar para terminar o assistente.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Selecione o modelo de mensagem de e-mail em massa que quer remover.",
    'ui__mass-email/delete_unknown__wizard-title' => "Remoção dos modelos de mensagem de e-mail em massa.",
    'ui__mass-email/send__description' => "Enviar e-mail aos destinatários selecionados",
    'ui__mass-email/send__short-title' => "Enviar e-mail em massa",
    'ui__mass-email/send__title' => "Enviar Mensagem de E-Mail em Massa",
    'ui__mass-email/send_main__description' => "Enviar e-mail aos destinatários selecionados",

    'ui__mass-email/send_main__short-title' => "Enviar e-mail em massa",
    'ui__mass-email/send_main__title' => "Enviar mensagens de e-mail em massa",
    'ui__mass-email/send_selectresellers__title' => 'Seleccione os revendedores',
    'ui__mass-email/send_selectresellers__short-title' => 'Revendedores',
    'ui__mass-email/send_selectresellers__description' => 'Seleccione as contas de revenda',

    'ui__mass-email/send_selectclients__description' => "Selecione as contas de cliente",

    'ui__mass-email/send_selectclients__short-title' => "Clientes",
    'ui__mass-email/send_selectclients__title' => "Selecione clientes",
    'ui__mass-email/send_selectdomainusers__description' => "Seleccione contas de administradores de domínio",

    'ui__mass-email/send_selectdomainusers__short-title' => "Administradores de domínio",
    'ui__mass-email/send_selectdomainusers__title' => "Seleccione os Administradores de domínio",
    'ui__mass-email/template/properties_main__description' => "Criar modelo de mensagem de e-mail em massa",
    'ui__mass-email/template/properties_main__short-title' => "Editar modelo",
    'ui__mass-email/template/properties_main__title' => "Editar modelo de mensagem de e-mail em massa",
    'ui__mass-email/template/properties_new-main__description' => "Criar um modelo para mensagens de e-mail em massa.",
    'ui__mass-email/template/properties_new-main__short-title' => "Criar modelo de mensagem de e-mail em massa",
    'ui__mass-email/template/properties_new-main__title' => "Criar modelo de mensagem de e-mail em massa",
    'ui__mass-email/template/properties_new-selectclients__description' => "Selecione os clientes que devem receber as mensagens de e-mail em massa baseado neste modelo",
    'ui__mass-email/template/properties_new-selectclients__title' => "Selecione os clientes que devem receber as mensagens de e-mail em massa baseado neste modelo",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Seleccione os administradores de domínio que devem receber as mensagens de e-mail em massa baseado neste modelo.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Seleccione os administradores de domínio que devem receber as mensagens de e-mail em massa baseado neste modelo.",
    'ui__mass-email/template/properties_selectclients__title' => "Selecione os clientes que devem receber as mensagens de e-mail em massa baseado neste modelo",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Seleccione os administradores de domínio que devem receber as mensagens de e-mail em massa baseado neste modelo.",

    'ui__mass-email/template/properties_unknown-new__description' => "Criar modelo de mensagem de e-mail em massa",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Criar modelo",
    'ui__mass-email/template/properties_unknown-new__title' => "Criação de modelo de mensagem de e-mail em massa",
    'ui__news/dismiss__description' => 'Clique para fechar a janela das noticias. O Plesk não irá mostrar esta janela até que os novos artigos sejam atualizados.',

    'ui__news/dismiss__title' => 'Fechar as notícias',

    'ui__server__description' => 'Gestão do servidor.',
    'ui__server__short-title' => 'Gerir o seu servidor',
    'ui__server__title' => 'Gestão do servidor',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'O endereço IP %1 não está disponível.',
    'ui__server/ip-address__none-available' => 'Não existem endereços IP.',
    'ui__server/ip-addresses/ip-address__title' => "Endereços IP",
    'ui__server/ip-address/client/properties_new__description' => "Atribua o endereço de IP %1 para revendedores.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Atribuir',
    'ui__server/ip-address/client/properties_new__title' => "Atribua o endereço de IP %1 para revendedores",
    'ui__server/ip-address/client__none-available' => 'Não existem contas de utilizador',
    'ui__server/ip-address/client_unknown__quick_search' => 'Utilizadores',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Lista de utilizadores que utilizam este endereço IP.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Por favor seleccione o endereço IP.',
    'ui__server/ip-address/client/delete__description' => 'Retire a atribuição do endereço de IP do revendedor.',
    'ui__server/ip-address/client/delete__short-title' => 'Eliminar',
    'ui__server/ip-address/client/delete__title' => 'Retire a atribuição do endereço de IP do revendedor',
    'ui__server/ip-address/client/delete_multi__description' => "Retire a atribuição do endereço de IP dos conjuntos de revendedores.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Eliminar',
    'ui__server/ip-address/client/delete_multi__title' => 'Retire a atribuição de um endereço de IP de um revendedor',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Remover endereços IP dos repositórios de utilizadores.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Seleccione o endereço IP que quer retirar dos utilizadores e clique Seguinte >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Seleccione os utilizadores dos quais quer retirar o endereço IP e clique Seguinte >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Confirme a remoção do endereço Ip dos utilizadores seleccionando a check box e clique Finalizar para terminar o assistente.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Retire a atribuição de um endereço de IP dos revendedores.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Eliminar',
    'ui__server/ip-address/client/delete_unknown__title' => 'Retire a atribuição do endereço de IP dos revendedores',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Remover um endereço IP de utilizadores',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Seleccione o endereço IP que quer retirar dos utilizadores e clique Seguinte >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Seleccione o utilizador do qual quer retirar o endereço IP e clique Seguinte >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Confirme a remoção do endereço Ip dos utilizadores seleccionando a check box e clique Finalizar para terminar o assistente.',

    'ui__server/ip-address/domain__description' => "Todos os domínios no endereço IP %1.",
    'ui__server/ip-address/domain__short-title' => "Domínios",
    'ui__server/ip-address/domain__title' => "Domínios no endereço IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Todos os domínios neste endereço IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domínios",
    'ui__server/ip-address/domain_unknown__title' => "Domínios no endereço IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Seleccione o endereço IP que necessita e clique Seguinte >>.",

    'ui__server/ip-address/properties__description' => 'Mudar as propriedades do endereço IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Propriedades',
    'ui__server/ip-address/properties__title' => 'Mudar as propriedades do endereço IP %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Adicionar endereço IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Quando terminar de mudar as propriedades do endereço IP, clique Finalizar para aplicar as modificações.',
    'ui__server/ip-address/properties_unknown__description' => 'Mudar as propriedades do endereço IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Propriedades',
    'ui__server/ip-address/properties_unknown__title' => 'Mudar as propriedades do endereço IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Mudar as propriedades do endereço IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Seleccione o endereço IP cujas propriedades quer mudar.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Quando terminar de mudar as propriedades do endereço IP, clique Finalizar para aplicar as modificações.',

    'ui__server/spam-filter/black-list__description' => 'Configurar a lista negra do filtro spam a nível de servidor.',
    'ui__server/spam-filter/black-list__short-title' => 'Lista negra',
    'ui__server/spam-filter/black-list__title' => 'Lista negra do filtro spam a nível de servidor',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Só os primeiros %1 endereços de e-mail únicos serão adicionados.',
    'ui__server/spam-filter/black-list/address__description' => 'Endereço da lista negra do filtro de spam.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Não existem endereços de e-mail na lista.',
    'ui__server/spam-filter/black-list/address__file_size' => 'O ficheiro carregado está vazio.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Os seguintes endereços de e-mail são inválidos: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Não existem endereços na lista negra do filtro de spam.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Endereço',
    'ui__server/spam-filter/black-list/address__title' => 'Endereço %1 da lista negra',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Adicionar endereços á lista negra.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Adicionar endereços',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Adicionar endereços á lista negra',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Remover endereço %1 da lista negra do servidor.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Eliminar',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Remover endereço %1 da lista negra do servidor',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Remover endereços da lista negra do servidor.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Eliminar',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Remover endereços da lista negra do servidor',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Remoção de endereços da lista negra do filtro de spam a nível de servidor',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Seleccione os endereços do filtro de spam que quer remover e clique Seguinte >>.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Confirme a remoção dos endereços do filtro de spam seleccionando a checkbox e clique Finalizar para os remover completamente e sair do assistente.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Remover endereço da lista negra do servidor.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Eliminar',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Remover endereço da lista negra do servidor',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Remoção de endereços da lista negra do filtro de spam a nível de servidor',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Seleccione o endereço do filtro de spam que quer remover e clique Seguinte >>.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Confirme a remoção do endereço do filtro de spam seleccionando a checkbox e clique Finalizar para o remover completamente e sair do assistente.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Só os primeiros %1 endereços de e-mail únicos serão adicionados.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Não existem endereços de e-mail na lista.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Impossível efetuar o carregamento do ficheiro. O tamanho máximo de um ficheiro a carregar é de %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Os seguintes endereços de e-mail são inválidos: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Adicionar endereços á lista negra.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Adicionar endereços',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Adicionar endereços á lista negra',

    'ui__server/spam-filter/properties__description' => 'Configurar o filtro spam a nível de servidor.',

    'ui__server/spam-filter/properties__short-title' => 'Configurações',
    'ui__server/spam-filter/properties__title' => 'Configurações do filtro de spam',

    'ui__server/spam-filter/toggle_disable__description' => 'Desactivar a filtragem de spam em todo o sistema.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Desativar',
    'ui__server/spam-filter/toggle_disable__title' => 'Desactivar a filtragem de  spam',
    'ui__server/spam-filter/toggle_enable__description' => 'Activar a filtragem de spam em todo o sistema.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Ativar',
    'ui__server/spam-filter/toggle_enable__title' => 'Activar a filtragem de spam',
    'ui__server/spam-filter/toggle_unknown__description' => 'Activar ou desactivar a filtragem do spam em todo o sistema.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Activar ou desactivar',
    'ui__server/spam-filter/toggle_unknown__title' => 'Activar ou desactivar a filtragem de spam',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Activar ou desactivar o filtro de spam',

    'ui__server/spam-filter/white-list__description' => 'Configurar a lista branca do filtro spam a nível de servidor.',
    'ui__server/spam-filter/white-list__short-title' => 'Lista branca',
    'ui__server/spam-filter/white-list__title' => 'Lista branca do filtro spam a nível de servidor',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Só os primeiros %1 endereços de e-mail únicos serão adicionados.',
    'ui__server/spam-filter/white-list/address__description' => 'Endereço da lista branca do filtro de spam.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Não existem endereços de e-mail na lista.',
    'ui__server/spam-filter/white-list/address__file_size' => 'O ficheiro carregado está vazio.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Os seguintes endereços de e-mail são inválidos: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Não existem endereços na lista branca do filtro de spam a nível de servidor.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Endereço',
    'ui__server/spam-filter/white-list/address__title' => 'Endereço da lista branca %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Adicionar endereços á lista branca.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Adicionar endereços',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Adicionar endereços á lista branca',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Remover endereço %1 da lista branca do servidor.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Eliminar',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Remover endereço %1 da lista branca do servidor',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Remover endereços da lista branca do servidor.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Eliminar',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Remover endereços da lista branca do servidor',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Remoção de endereços da lista branca do filtro de spam a nível de servidor',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Seleccione os endereços do filtro de spam que quer remover e clique Seguinte >>.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Confirme a remoção dos endereços do filtro de spam seleccionando a checkbox e clique Finalizar para os remover completamente e sair do assistente.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Remover endereço da lista branca do servidor.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Eliminar',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Remover endereço da lista branca do servidor',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Remoção de endereços da lista branca do filtro de spam a nível de servidor',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Seleccione o endereço do filtro de spam que quer remover e clique Seguinte >>.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Confirme a remoção do endereço do filtro de spam seleccionando a checkbox e clique Finalizar para o remover completamente e sair do assistente.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Só os primeiros %1 endereços de e-mail únicos serão adicionados.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Não existem endereços de e-mail na lista.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Impossível efetuar o carregamento do ficheiro. O tamanho máximo de um ficheiro a carregar é de %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Os seguintes endereços de e-mail são inválidos: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Adicionar endereços á lista branca.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Adicionar endereços',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Adicionar endereços á lista branca',

    'ui__server/mail/statistics#apply__description' => "Aplicar filtro",
    'ui__server/mail/statistics#apply__title' => "Aplicar",
    'ui__server/mail/statistics#custom_from__title' => "de",
    'ui__server/mail/statistics#custom_to__title' => "para",
    'ui__server/mail/statistics#period_all__title' => "Tudo",
    'ui__server/mail/statistics#period_custom__title' => "Personalizado",
    'ui__server/mail/statistics#period_month__title' => "Mês corrente",
    'ui__server/mail/statistics#period_prev_month__title' => "Mês anterior",
    'ui__server/mail/statistics#period_prev_week__title' => "Semana anterior",
    'ui__server/mail/statistics#period_today__title' => "Hoje",
    'ui__server/mail/statistics#period_week__title' => "Semana actual",
    'ui__server/mail/statistics#period_yesterday__title' => "Ontem",
    'ui__server/mail/statistics#show_for_period__title' => "Exibir período",
    'ui__server/mail/statistics#tools_legend__title' => "Ferramentas",
    'ui__server/mail/statistics__description' => "Ver estatísticas de spam e vírus",

    'ui__server/mail/statistics__short-title' => "Estatísticas",
    'ui__server/mail/statistics__title' => "Definições de correio",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Estatística de spam",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Ferramentas",
    'ui__server/mail/statistics/spam__description' => "Ver as estatísticas de spam",

    'ui__server/mail/statistics/spam__short-title' => "Estatística de spam",
    'ui__server/mail/statistics/spam__title' => "Estatística de spam",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Nome de correio",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% do total",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Ordenar por conta de correio",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Ordenar por % do total",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Ordenar por spam recebida",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "contas de correio",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Spam recebido",
    'ui__server/mail/statistics/spam/recipients__description' => "Destinatários",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Destinatários",
    'ui__server/mail/statistics/spam/recipients__title' => "Destinatários",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Limpos",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Infectados",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Estado",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% do total",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Contagem",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Protegidos",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Não verificados",
    'ui__server/mail/statistics/spam/summary__description' => "Resumo",

    'ui__server/mail/statistics/spam/summary__short-title' => "Resumo",
    'ui__server/mail/statistics/spam/summary__title' => "Resumo",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Estatísticas de vírus",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Ferramentas",
    'ui__server/mail/statistics/virus__description' => "Ver estatísticas de vírus",

    'ui__server/mail/statistics/virus__short-title' => "Estatísticas de vírus",
    'ui__server/mail/statistics/virus__title' => "Estatísticas de vírus",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Conta de correio",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% do total",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Ordenar por nome de correio",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Ordenar por % do total",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Ordenar por vírus recebidos",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Contas de correio",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Vírus recebidos",
    'ui__server/mail/statistics/virus/recipients__description' => "Destinatários",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Destinatários",
    'ui__server/mail/statistics/virus/recipients__title' => "Destinatários",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Limpos",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Infectados",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Estado",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% do total",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Contagem",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Protegidos",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Não verificados",
    'ui__server/mail/statistics/virus/summary__description' => "Resumo",

    'ui__server/mail/statistics/virus/summary__short-title' => "Resumo",
    'ui__server/mail/statistics/virus/summary__title' => "Resumo",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Nome",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% do total",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Ordenar por nome",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Ordenar por % do total",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Ordenar por objectos infectados",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Vírus",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Objectos infectados",
    'ui__server/mail/statistics/virus/viruses__description' => "Vírus",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Vírus",
    'ui__server/mail/statistics/virus/viruses__title' => "Vírus",

    'ui__support#param_company__title' => "Empresa",
    'ui__support#param_email__title' => "E-mail",
    'ui__support#param_firstname__title' => "Primeiro nome",
    'ui__support#param_keynumber__title' => "Numero da chave do produto",
    'ui__support#param_operatingsystem__title' => "Sistema operativo",
    'ui__support#param_phone__title' => "Telefone",
    'ui__support#param_psabuild__title' => "Compilação do Plesk",
    'ui__support#param_psainsttype__title' => "Tipo de instalação do Plesk",
    'ui__support#param_psaversion__title' => "Versão do Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Ferramentas",

    'ui__reseller/traffic-history_unknown__short-title' => "Ver Tráfego por Revendedores",
    'ui__reseller/traffic-history_unknown__title' => "Ver Tráfego por Revendedores",
    'ui__reseller/traffic-history_unknown__description' => "Ver tráfego por contas de revendedores.",
    'ui__reseller#list__title' => "Revendedores",
    'accounts_list__name__filter_title' => "Nome",
    'accounts_list__resource__filter_title' => "Utilização dos recursos",
    'resellers_list__filter_resource_usage_any' => "Qualquer",
    'resellers_list__filter_resource_usage_overuse' => "Sobre-utilização",
    'resellers_list__filter_resource_usage_normal' => "Dentro dos limites",
    'accounts_list__status__filter_title' => "Estado",
    'resellers_list__filter_status_any' => "Qualquer",
    'resellers_list__filter_status_blocked' => "Suspendido",
    'resellers_list__filter_status_active' => "Ativo",
    'resellers_list__filter_clients__filter_title' => "Apresentar",
    'resellers_list__filter_clients_on' => "Revendedores com os seus clientes",
    'resellers_list__filter_clients_off' => "Só revendedores",
    '__disk_usage' => "Espaço em disco utilizado",
    'ui__reseller/traffic_unknown__short-title' => "Ver Tráfego por Revendedores",
    'ui__reseller/traffic_unknown__title' => "Ver Tráfego por Revendedores",
    'ui__reseller/traffic#list__title' => "Tráfego por revendedor",
    'ui__reseller/traffic_unknown__description' => "Ver relatório de utilização de tráfego.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Tráfego por revendedor",

    '__reseller_name' => "Nome do revendedor",
    '__reseller' => "Revendedores",
    'resellertrafficlist_header' => "Ver Tráfego por Revendedores",
    '__reseller_personal' => "Tráfego utilizado pelos domínios do revendedor",
    'ui__reseller/traffic-history__short-title' => "Tráfego por revendedores",
    'ui__reseller/traffic-history__title' => "Tráfego por revendedores",
    'ui__reseller/traffic-history__description' => "Ver relatório de utilização de tráfego.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Permitir vender mais que os recursos atribuídos",
    'limits__reseller_oversell_description' => "A venda excessiva permite ao revendedor vender mais recursos que os que tem atribuídos Caso seja permitido, o revendedor é controlado pelos recursos reais utilizados em vez dos recursos inicialmente atribuídos",
    'limits__overuse_block_text' => "Politica de sobreutilização",
    'limits__overuse_block_true_text' => "A sobre-utilização não é permitida",
    'limits__reseller_overuse_block_true_description' => "Bloquear a utilização excessiva de recursos. A utilização real dos recursos não pode exceder a quantidade inicial de recursos atribuídos",
    'limits__overuse_block_false_text' => "A sobre-utilização é permitida",
    'limits__reseller_overuse_block_false_description' => "Permitir exceder o uso de recursos, permite que o revendedor utilize mais recursos que os inicialmente permitidos A utilização real dos recursos pode exceder os recursos atribuídos inicialmente.",
    'limits__reseller_overuse_notify_text' => "Avisar o revendedor ao atingir os limites de recursos",
    'reseller_perm__manage_sh_access_disabled' => "O revendedor não pode permitir ou retirar o acesso a shell",
    'reseller_perm__manage_sh_access_chrooted' => "O revendedor só pode permitir o acesso a ambiente chrooted",
    'reseller_perm__manage_sh_access_any' => "O revendedor não pode permitir o acesso a shell",
    'template__reseller_num_excl_ips' => "Atribuir endereços IP exclusivos ao revendedor",

    // Reseller's Home page
    'client_chown__no_clients_selected' => 'Por favor, escolha as contas de cliente às quais deseja atribuir um novo proprietário.',
    'ui__reseller#tools2__title' => "Conta",
    'ui__reseller#info__title' => "Informações",
    'ui__reseller#clientsTab__title' => "Clientes",
    'ui__reseller#domainsTab__title' => "Domínios",
    'ui__reseller__title' => "Gerir a Conta de Revenda de %1",
    'domains__reseller_info' => "%1 clientes, %2 domínios, %3 de disco utilizado, %4 de dados transferido.",
    'domains__reseller_info_hiding_traffic' => "%1 clientes, %2 domínios, %3 de disco utilizado.",
    'ui__reseller__description' => "Gerir a conta de revenda.",

    'ui__reseller/limits_unknown__wizard-title' => 'Ver ou alterar os limites dos recursos de um revendedor',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Seleccione o revendedor que necessita.',
    'ui__reseller/limits_unknown__wizard__2' => 'Para aplicar as modificações, clique Finalizar.',

    'ui__client/report_reseller__short-title' => "Relatório",
    'ui__client/report_reseller__title' => "Ver Relatório de Conta",
    'ui__client/report_reseller__description' => "Ver o relatório da conta de revenda.",
    'ui__client/ip-pool_reseller__short-title' => "Repositório de IP",
    'ui__client/ip-pool_reseller__description' => "Atribuir endereços IP e certificados SSL/TLS á conta de cliente.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Especifique as preferências da conta e clique Finalizar.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Ver ou modificar as permissões de um revendedor',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Seleccione o revendedor cujas permissões quer ver ou modificar.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Quando terminar de mudar as permissões do revendedor, clique Finalizar para aplicar as modificações e sair do assistente.',

    // Customers > create customer account

    '__resellers_list' => 'Revendedores',
    'picker_reseller__title' => 'Seleccione o revendedor',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Ferramentas",
    'ui__client#tools2__title' => "Conta",
    'ui__client#info__title' => "Informações",
    'ui__client#clientslist__title' => "Clientes",
    'ui__client#domainslist__title' => "Domínios",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Todas as aplicações locais estão agora ordenadas por categorias, ficando mais simples escolher a aplicação certa a instalar.",
    'feature__domainkeys__reseller' => "Pode utilizar o mecanismo de autenticação de e-mail DKIM para reduzir a quantidade de spam e e-mails de phishing.",

    '__reseller_form' => "Formulário de revendedor",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Selecione a conta de cliente cujas preferências quer modificar..",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Para alterar os limites dos recursos, clique Limites de Recursos.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Para alterar as autorizações das operações que o cliente pode executar no Plesk, clique em Permissões.",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "Para criar um domínio para a sua própria conta, clique Criar Domínio. Para criar um domínio para um dos seus clientes, clique o nome do cliente e depois, clique Criar Domínio.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Disponibilize este modelo a outros utilizadores",
    'template__shared_description' => "Seleccione esta opção se quer disponibilizar este modelo aos seus clientes.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Ferramentas',

    'ui__client/traffic-history_unknown__short-title' => 'Ver Tráfego por Cliente',
    'ui__client/traffic-history_unknown__title' => 'Tráfego por Clientes',
    'ui__client/traffic-history_unknown__description' => 'Ver o relatório de utilização de tráfego para todos os clientes',
    'ui__client/traffic-history__short-title' => 'Tráfego por Clientes',
    'ui__client/traffic-history__title' => 'Ver Tráfego por Cliente',
    'ui__client/traffic-history__description' => 'Ver o relatório de utilização de tráfego para todos os clientes',

    'ui__client/traffic#list__title' => 'Tráfego por clientes',
    'ui__reseller/client/traffic#list__title' => 'Tráfego por clientes',

    'clients_list__filter_type__filter_title' => 'Apresentar',
    'clients_list__filter_type_any' => 'Clientes e revendedores',
    'clients_list__filter_type_clients' => 'Só clientes',
    'clients_list__filter_type_resellers' => 'Só revendedores',
    'ui__client/domain_unknown-new__short-title' => "Criar domínio",

    // Customers > View traffic by customers
    '__personal' => "Tráfego utilizado pelos domínios do revendedor",
    'PersonalTrafficList_header_of_client__' => "Ver Relatório de Utilização de Tráfego da Sua Conta",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "O administrador de domínio não pode gerir o acesso de shell",
    'domain_perm__manage_sh_access_chrooted' => "O administrador de domínio pode permitir o acesso só a um ambiente de chrooted",
    'domain_perm__manage_sh_access_any' => "O administrador de domínio pode permitir o acesso a qualquer tipo de shell",

    // APS Catalog
    'bt_add_to_vault' => "Adicionar ao Repositório",
    'bt_hide_updates' => "Ocultar actualizações disponíveis",
    'bt_show_updates' => "Mostrar as actualizações disponíveis",

    '__site_apps__applications' => "Aplicações",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplicações seleccionadas para adicionar ao repositório",
    'site_apps__application_selected' => "Selecção",
    'site_apps__currently_in_vault' => "Outras versões no repositório:",
    'site_apps__new_versions' => "Novas versões:",
    'site_apps__patches' => "Correcções:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Numero de aplicações agendadas para adicionar ao repositório %1",
    'site_apps__applications_downloading_now' => "As seguintes aplicações estão agora a ser descarregadas: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Já existe no repositório",

    // Server > Action Log
    'bt_skin_edit' => "Editar a Descrição da Skin",
    'domains__you_want_change_the_status_of_the_reseller??' => "Tem a certeza que deseja modificar o estado da conta de revenda ?",
    'limits__oversell_legend' => "Vender em excesso",
    'limitsManager__limit_available_error' => "Impossível atribuir a quantidade de  recursos necessária (%%quantity%% %%limitName%%). Só estão disponíveis %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "Impossível definir o limite pretendido de utilização do recurso (%%quantity%% %%limitName%%) porque o novo valor é menor do que a quantidade de recursos reservados para os seus clientes ou utilizado por si (%%reserved%% %%limitName%%) .",
    'limitsManager__limit_used_error' => "Impossível definir o limite de utilização de recursos (%%quantity%% %%limitName%%) porque o novo valor é menor do que a quantidade de recursos já utilizados pela sua conta e sites (%%used%% %%limitName%%) .",

    'ui__client/domain/traffic#list__title' => "Uso da largura de banda por serviços",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Ver Relatório de Utilização de Tráfego",
    'ui__client/domain/traffic_unknown-reseller__title' => "Ver Relatório de Utilização de Tráfego",

    'ui__client/domain_new__short-title' => "Criar domínio",

    'ui__client_reseller__description' => "Gerir a conta de revenda de %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Gerir conta de revenda",

    '__owner_name' => "Nome do proprietário",
    'domains_list__resource__filter_title' => "Utilização de Recursos",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Catálogo de aplicações APS",
    'site_apps__applications_have_updates' => "Estão disponíveis actualizações para as seguintes aplicações:\n%1\nPara ver as actualizações, certifique-se que a área de Procura está visível, seleccione a checkbox <b>Ver somente as aplicações com actualizações disponíveis</b> e procure as aplicações que necessita.",
    'site_apps__progress_adding_to_vault' => "A adicionar ao repositório:",
    'site_apps__progress_done_message' => "Progresso:",
    'site_apps__progress_applications_left' => "Faltam %1 de %2 aplicações",
    'site_apps__download_item_long_task_title' => "Descarregar a aplicação APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Descarregar aplicações do Catálogo APS",
    'site_apps__last_check_for_updates' => "ultima verificação de actualizações: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Todas as aplicações agendadas foram adicionadas com sucesso ao Repositório de Aplicações",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 aplicações agendadas foram adicionadas ao Repositório de Aplicações com sucesso.",
    'site_apps__no_search_results' => 'Não foram encontradas aplicações. Tente um pedido diferente de procura ou navegue nas aplicações por categorias.',
    'site_apps__search_results_title' => 'Resultados da procura',
    '__site_apps__search_by_application' => 'Nome da aplicação',
    '__site_apps__search_by_vendor' => 'Vendedor',
    '__site_apps__search_by_vendor__all' => 'Todos os vendedores',
    '__site_apps__search_by_packager' => 'Empacotador',
    '__site_apps__search_by_certification_level' => 'Nível de certificação',
    '__site_apps__search_by_cert__any' => 'Qualquer',
    '__site_apps__search_by_cert__silver_and_higher' => 'Prata e acima',
    '__site_apps__search_by_cert__gold_and_higher' => 'Ouro e acima',
    '__retry' => 'Repetir',
    'site_apps__application_packager_site' => 'Empacotador',
    'site_apps__add_to_pool_message' => "As aplicações marcadas como \\\"available for all\\\" são automaticamente distribuídas a todos os revendedores e clientes com o número de instalações ilimitadas. As aplicações restringidas são distribuídas a todos os revendedores e clientes manualmente, individualmente, com o número de instalações explicitamente especificadas.",
    'site_apps__make_available_for_all' => "Disponibilizar as aplicações seleccionadas a todos os utilizadores",

    'site_apps__broadcast_app_text' => "As aplicações marcadas como \\\"available for all\\\" são automaticamente distribuídas a todos os revendedores e clientes com o número de instalações ilimitadas. As aplicações restringidas são distribuídas a todos os revendedores e clientes manualmente, individualmente, com o número de instalações explicitamente especificadas.",
    'site_apps__broadcast_app_name' => 'Disponibilizar a aplicação a todos os utilizadores',

    // User Application Pool per application
    'site_apps__available_clients' => 'Utilizadores disponíveis',
    'site_apps__no_more_clients_to_add_to_pool' => 'Não existem mais contas de utilizador a quem pode fornecer esta aplicação',

    // Installed application instances
    'site_apps__installations' => 'Instalações',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nome do domínio e endereço IP",
    '__assign_ip_address' => "Atribuir um endereço IP",
    '__switch_on_service' => "Ligar serviço",
    '__hosting_configuration' => "Configuração de alojamento",
    '__vrt_hst' => "Alojamento da página Web",
    '__vrt_hst_hint' => "Alojar um site Web neste servidor.",
    '__fwd' => "Redirecionamento",
    '__web_hosting_settings' => "Definições de alojamento",
    '__fwd_hint' => "Redirecionar as visitas para outro site Web.",
    '__none_hint' => "Não alojar, de momento, um site Web.",
    '__login_hint' => "O nome de utilizador é utilizado para aceder ao site Web por FTP",
    '__password_hint' => "A palavra-passe é utilizada para aceder ao site Web por FTP",
    '__advanced_hosting_setup' => "Configurar definições avançadas do alojamento Web",
    '__domain_creation_successful' => "O domínio foi criado.",
    'bt_hosting_settings' => "Configurações de alojamento",
    '__change_hosting_type' => "Mudar o tipo de alojamento do domínio %1",
    '__hosting_type_change_warning' => "Quando mudar o tipo de reendereçamento do alojamento, todos os ficheiros e directórios relacionados com o seu site vão ser removidos do servidor. Certifique-se que guardou uma copia local do seu site",
    '__current_hosting_type' => "Tipo de alojamento actual",
    '__new_hosting_type' => "Novo tipo de alojamento",
    '__fwd_settings' => "Definições de reendereçamento",
    '__fwd_settings_legend' => "Definições de reendereçamento",
    '__fwd_destination_url' => "URL destino",
    '__fwd_type' => "Tipo de re-endereçamento",
    '__fwd_type_standart' => "Reendereçamento padrão",
    '__fwd_type_standart_hint' => "Redirecionar as visitas do web site para outro site e exibir o endereço de destino, de modo a que se apercebam do redirecionamento.",
    '__fwd_type_frame' => "Re-endereçamento em Janela",
    '__fwd_type_frame_hint' => "Redirecionar as visitas do web site para outro site e não exibir o endereço de destino, de modo a que não se apercebam do redirecionamento.",
    '__hosting_type_template_warning' => "O tipo de alojamento que especificou é diferente do tipo especificado no modelo. Caso continue, as definições de alojamento Web no modelo selecionado vão ser ignoradas. Tem a certeza que deseja o tipo de alojamento selecionado?",

    'ui__client/domain/properties#vrt_hst__title' => "Alojamento da página Web",
    'ui__client/domain/properties#vrt_hst__description' => "Alojar um site Web neste servidor",
    'ui__client/domain/properties#fwd__title' => "Redirecionamento",
    'ui__client/domain/properties#fwd__description' => "Redirecionar as visitas para outro site Web",
    'ui__client/domain/properties#none__title' => "Sem alojamento",
    'ui__client/domain/properties#none__description' => "Não alojar, de momento, um site Web",

    '__no_resellers_selected' => "Tem de seleccionar pelo menos uma conta de revenda.",

    'ui__client/logo_unknown__wizard-title' => 'Configurar um logótipo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Por favor, selecione o cliente cujas propriedades do logo quer alterar.',
    'ui__client/logo_unknown__wizard__2' => 'Clique Finalizar para aplicar as modificações.',
    'ui__client/logo_unknown__wizard__2_self' => 'Clique Finalizar para aplicar as modificações.',

    'ui__client/ipaddress/properties_new__short-title' => "Adicionar Endereço IP",
    'ui__client/ipaddress/properties_new__title' => 'Adicionar Endereço IP',
    'ui__client/ipaddress/properties_new__description' => "Adicionar endereço IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Adicionar Endereço IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Adicionar Endereço IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Adicionar Endereço IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Remover Endereço IP",
    'ui__client/ipaddress/delete_multi__description' => "Remover endereços IP.",
    'ippool_Manager__no_available_ips' => "Não existem endereços IP vagos no repositório de IP's.",
    'ippool_Manager__ip_shared' => "partilhado",
    'ippool_Manager__ip_exclusive' => "dedicado",
    'ui__client/ipaddress/properties__title' => "Gerir Endereços IP",
    'ui__client/ipaddress/properties__description' => "Ver ou modificar as propriedades do endereço IP.",
    'ui__client/ipaddress_unknown-new__title' => "Adicionar Endereço IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Adicionar Endereço IP",
    'ui__client/ipaddress_unknown-new__description' => "Adicionar endereços IP.",

    'ui__mass-mail#to_resellers_text__title' => "Revendedores",
    'ui__mass-mail#to_domainusers_text__title' => "Administradores de domínio",
    'ui__mass-email#tools_legend__title' => "Ferramentas",
    'ui__mass-email#list_legend__title' => 'Modelos de mensagem de e-mail em massa',
    'ui__mass-email#template_legend__title' => "Modelo",
    'ui__mass-email#from_email_text__title' => "De",
    'ui__mass-email#to_text__title' => 'Para',
    'ui__mass-email#to_resellers_text__title' => "Revendedores",
    'ui__mass-email#to_clients_text__title' => "Clientes",
    'ui__mass-email#to_domainusers_text__title' => "Administradores de domínio",
    'ui__mass-email#to_admin_text__title' => "Administrador Plesk",
    'ui__mass-email#option_mode_all__title' => "Tudo",
    'ui__mass-email#option_mode_select__title' => "Só a selecção",
    'ui__mass-email#option_mode_except__title' => "Todos excepto os seleccionados",
    'ui__mass-email#option_select_template__title' => '---Seleccione um modelo---',
    'ui__mass-email#subject_text__title' => "Assunto",
    'ui__mass-email#body_text__title' => "Texto da mensagem",
    'ui__mass-email#save_as_legend__title' => "Salvar como modelo",
    'ui__mass-email#save_as_text__title' => "Salvar a mensagem definida para um novo modelo com o nome",
    'ui__reseller/preferences_unknown__wizard-title' => "Modificar Preferências da Conta",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Selecione o revendedor onde quer mudar as preferências da conta e clique Seguinte.",
    'ui__reseller/preferences_unknown__wizard__2' => "Especifique as preferências da conta e clique OK.",
    'ippoolManager__ip_shared' => "partilhado",
    'ippoolManager__ip_exclusive' => "dedicado",

    '__users_list' => "Utilizadores",
    '__users' => "Utilizadores",
    '__user_name' => "Nome do utilizador",

    'clientOwnerChanger__wrong_owner_type' => "Só pode transferir as contas de cliente selecionadas para uma conta de revenda.",
    'clientOwnerChanger__wrong_client_type' => 'A conta de utilizador seleccionada é uma conta de revenda. As contas de revenda não podem ser transferidas para um novo proprietário, dados que o proprietário é o administrador do servidor..',
    'ui__client/chowner_multi__description' => "Transferir as contas de utilizador para outro proprietário.",
    'client_chown__clients_list_legend' => "Contas de utilizador",
    'client_chown__client_name' => "Nome do utilizador",
    'client_chown__old_owner' => "Proprietário anterior",
    'client_chown__limits_legend' => "Recursos",
    'client_chown__limit_name' => "Nome do recurso",
    'client_chown__limit_value' => "Recursos atribuídos",
    'client_chown__usage_before' => "Antes da transferência",
    'client_chown_usage_after' => "Após a transferência",
    'limit__name_max_dom_aliases' => "nomes alternativos de domínio",
    'limit__name_max_subftp_users' => "contas FTP adicionais",
    'limit__name_max_mssql_db' => "Base de dados Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Repositórios de aplicações de IIS",
    'limit__name_max_odbc' => "Ligações ODBC",
    'total_mboxes_quota_unsupported' => 'Não suportado pelo servidor de e-mail',
    'limit_soft__disk_space' => 'Notifique ao atingir o espaço em disco',
    'limit_soft__max_traffic' => 'Notifique ao atingir o tráfego',
    'dsr__of_reseller_title' => "Utilização dos Recursos por Domínios",
    'client_chown__new_owner' => 'Novo proprietário',
    'ui__reseller/to-client__has_clients_warning' => 'Algumas das contas de revenda selecionadas não podem ser convertidas a contas de cliente porque têm contas de cliente subscritas aos seus serviços. Por favor remova as contas de cliente subscritas a este revendedor ou mova-as para outro revendedor.',
    'limitsManager__commit_failed' => "Impossível alterar o limite dos recursos.",
    'limitsManager__date_in_past' => "Data limite incorrecta %1.",
    'limitsManager__limit_not_supported' => "Os limites para o recurso de tipo %1 não podem ser definidos.",
    'limitsManager__limit_oversell_inconsistency' => "Impossível atribuir a quantidade de  recursos especificada com a permissão de venda excessiva desligada.",
    'limitsManager__limit_overuse_inconsistency' => "A utilização dos recursos excede os limites definidos.",
    'limitsManager__no_resource_available' => "Não existem mais recursos disponíveis deste tipo (%%limitName%%). Necessário: %%quantity%%; disponível: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Não existem recursos deste tipo (%%limitName%%) disponíveis no seu Fornecedor de Serviço. Necessário: %%quantity%%; disponível: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "A data de validade deve ser menor ou igual a %1.",
    'limitsManager__invalid_disk_space_limit' => "A quantidade de espaço em disco deve ser menor ou igual a %1.",
    'limitsManager__invalid_max_traffic_limit' => "A quantidade de tráfego deve ser menor ou igual a %1.",
    'ippoolManager__ip_has_suballocations' => "Impossível mudar o tipo, o endereço IP já foi atribuído a um utilizador. O endereço IP %%ip%% já foi atribuído a outro(s) utilizador(es) como endereço IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Este endereço IP já está atribuído a este utilizador.",
    'ippoolManager__ip_is_not_in_pool' => "O endereço IP não existe no repositório %%ip%%.",
    'ippoolManager__can_not_allocate_ip' => "O endereço IP %%ip%% está disponível apenas como %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "O endereço IP %%ip%% não pode ser atribuído como exclusivo.",
    'ippoolManager__ip_used_by_hst_or_frw' => "O endereço IP %%ip%% já está a ser utilizado nos alojamentos.",
    'ippoolManager__active_anon_ftp_on_ip' => "O acesso ao FTP Anónimo já está ligado para o endereço IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Não existem endereços IP vagos.",
    'ippoolManager__no_available_ips' => "Não existem endereços IP disponíveis.",
    'templates__dublicate_name' => "Já existe um modelo com esse nome. Selecione outro nome para este modelo.",
    'cl_perm__client_limits_exceeded' => "Os valores especificados para os limites de recursos excedem os valores permitidos pelo seu plano de alojamento, ou os valores fornecem menos recursos que os actualmente utilizados pelos seus sites.",
    'cl_perm__reseller_limits_exceeded' => "Os valores especificados para os limites de recursos excedem os valores permitidos pelo seu plano de alojamento, ou os valores fornecem menos recursos que os actualmente utilizados pelas suas contas de cliente e sites.",

    'site_apps__preferences_show_all_versions_title' => "Mostrar toda a lista de versões para cada aplicação obtida do catálogo",
    'site_apps__preferences_show_all_versions_hint' => "Se esta opção estiver seleccionada, pode implicar uma espera prolongada a obter todas as versões de cada aplicação cada vez que abre o catálogo. Se esta opção não estiver seleccionada, só as ultimas versões são exibidas.",
    '__select_user_template' => "Criar uma conta de utilizador baseada num modelo",
    'ip_already_added_to_all_clients' => "O endereço IP já está atribuído a todos os utilizadores.",
    'ui__server/ip-address/client/delete#legend__description' => "Os seguintes endereços IP vão ser retirados do sistema e do repositório dos utilizadores:",

    'dns__serial_format_timestamp' => "Formato do numero de série SOA com a data-hora UNIX",
    'dns__serial_format_yyyymmddnn' => "Formato do serial para o SOA recomendado pela IETF e RIPE",
    'site_apps__cancelled_apps' => "Cancelou a atribuição das seguintes aplicações: %2",

    'sb_url_is_not_resolved' => 'URL não pode ser resolvido: verificar suas configurações de DNS. URL %1 deve resolver o endereço IP do servidor com o Presence Builder instalado.',

    'ip_addr__is_last_on_interface' => 'Impossível remover o endereço IP %%ip%% porque é o ultimo endereço IP presente no interface de rede.',
    'ip_addr__used_for_current_session' => 'Impossível remover o endereço IP %%ip%% porque está a ser utilizado por uma sessão activa.',
    'ip_addr__used_for_hosting' => 'Impossível remover o endereço IP %%ip%% porque está a ser utilizado para alojar um site Web.',
    'ip_addr__is_main' => 'Impossível remover o endereço IP %%ip%% porque é o endereço IP primário do interface de rede.',
    'ip_addr__ip_used_by_message_submission' => 'Impossível remover o endereço IP %%ip%% porque está a ser utilizado para o serviço de correio alternativo.',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domínios de clientes',
    'excl_ip_num' => 'Endereço IP exclusivo',

    'sb_err_sitebuilder_not_installed' => 'O Presence Builder não está instalado.',

    '__perm_allow_oversell_can_not_be_revoked' => 'A permissão de venda excessiva não pode ser revogada ao utilizador porque o utilizador já atribuiu mais recursos que os disponíveis, a manter o modo de venda excessiva.',
    'limitsManager__invalid_limit_value' => 'Especificou um valor incorrecto %%value%% para o limite %%limit_name%%',
    'ip_alias__type' => "Endereço IP distribuído como",
    'ip_alias__in_type' => 'Endereços IP atribuídos como',
    'ui__client/ipaddress/delete_multi__title' => 'Remover Endereços IP',
    'ui__client/ipaddress/delete#legend__short-title' => 'Itens a remover',
    'ui__client/ipaddress/delete#legend__description' => "Os seguintes endereços IP vão ser removidos do repositório IP do utilizador:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'Itens que não podem ser removidos',
    'ui__client/ipaddress/delete#nlegend__description' => 'Os seguintes endereços IP não podem ser removidos:',
    'ui__server/ip-address/delete#legend__description' => 'Os seguintes endereços IP vão ser removidos do repositório de IP do servidor:',
    'confirmationForm_default_agreement_text' => 'Confirme a operação',
    'confirmationForm_default_confirm_message' => 'Por favor, confirme a operação.',
    'limit__max_mn' => 'Número máximo de contas de correio',

    'limits__client_overuse_description' => 'A politica de sobreutilização informa o Plesk sobre o que fazer quando os recursos são utilizados acima do inicialmente atribuído.',
    'limits__client_overuse_block_true_description' => 'Bloquear a utilização excessiva de recursos. A utilização real dos recursos não pode exceder a quantidade inicial de recursos atribuídos',
    'limits__client_overuse_block_false_description' => 'Permitir exceder a utilização de recursos, permite que o cliente utilize mais recursos que os inicialmente permitidos. A utilização real dos recursos não pode exceder a quantidade inicial de recursos atribuídos',
    'limits__client_overuse_notify_text' => 'Avisar o cliente ao atingir os limites de recursos',

    'limits__domain_overuse_description' => 'A politica de sobreutilização informa o Plesk sobre o que fazer quando os recursos são utilizados acima do inicialmente atribuído.',
    'limits__domain_overuse_block_true_description' => 'A política de sobreutilização informa o Plesk sobre o que fazer quando existe sobreutilização de recursos.',
    'limits__domain_overuse_block_false_description' => 'Permitir exceder o uso de recursos, permite que o domínio utilize mais recursos que os inicialmente permitidos A utilização real dos recursos pode exceder os recursos atribuídos inicialmente.',
    'limits__domain_overuse_notify_text' => 'Avisar o proprietário do domínio ao atingir os limites de recursos',


    'cancel_remove' => 'Desative quaisquer alterações e retorne para a página anterior.',
    'php_not_installed' => 'O PHP não está instalado.',

    'dns__dns_rr_delete' => 'Itens a remover',
    'dns__delete_rr' => 'Os seguintes registos DNS vão ser removidos da zona DNS:',
    'dns__dns_rr_delete_non_removable' => 'Itens que não podem ser removidos',
    'dns__non_delete_rr' => 'Os seguintes registos DNS não podem ser removidos:',
    'dns__dns_rr_delete_confirm_message' => 'Confirme a remoção dos registos DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'O formato da aplicação web é desconhecido: a aplicação web pode estar indisponível para instalação e utilização.',

    '__php_handler_type_desc' => 'Correr PHP como',
    'sfdk_domain_sign__failed' => 'Ocorreu um erro não identificado quando tentava ligar a assinatura de email com DKIM no domínio. Veja o log de erros do servidor para mais informação.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notificação de sucesso na atualização de chave do Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Aviso de deferimento na atualização da chave do Plesk',
    'pkey_notify__subj_update_error_notification' => 'Aviso de erro na atualização da chave do Plesk',
    'pkey_notify__update_successful' => '%1 actualização terminada com sucesso.',
    'pkey_notify__update_failed_no_more_try' => 'Impossível atualizar %1. A chave que está a tentar enviar é inválida. Já não pode tentar atualizá-la novamente.',
    'pkey_notify__update_failed_try_later' => 'Impossível actualizar %1: Ocorreu um erro ao processar a sua chave. Pode tentar obter manualmente a chave no Plesk (Ferramentas e definições>Gestão de Licenças) ou permitir que o Plesk tente atualizar nas próximas 24 horas. Se não quiser voltar a receber esta notificação, remova esta chave do Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Impossível desligar a filtragem de spam no servidor.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Impossível ligar a filtragem de spam no servidor.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Este revendedor',
    'report_auto__select_reseller_report_all' => 'Todos os revendedores',
    'report_auto__select_reseller_report_client' => 'Todos os revendedores deste cliente',
    'report_auto__select_reseller_report_current' => 'Este revendedor',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Todos os clientes deste revendedor',
    'report_auto__select_client_report_client' => 'Este cliente',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Revendedores, clientes e domínios',

    'rpt_reseller_section_full_domains' => 'Domínios',
    'rpt_reseller_dom_subdomains' => 'Sub-dom',
    'rpt_reseller_dom_domain_aliases' => 'Nomes alternativos',
    'rpt_reseller_dom_postboxes' => 'Cx.Mens',
    'rpt_reseller_dom_redirects' => 'Redirecionamentos',
    'rpt_reseller_dom_mail_groups' => 'Gr.e-mail',
    'rpt_reseller_dom_mail_resps' => 'Resp.Autom',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivírus',
    'rpt_reseller_dom_mail_lists' => 'L.e-mail',
    'rpt_reseller_dom_web_users' => 'UtilizadoresW',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Clientes',
    '__cl_name' => 'Nome de cliente',
    '__cl_creation_date' => 'Data de criação',
    '__clients_traffic' => 'Tráfego do cliente',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivírus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'O Presence Builder não está instalado.',
    'sitebuilder_disabled' => 'O Presence Builder está desligado.',
    'b_sitebuilder_disabled' => 'O Presence Builder está desligado.',
    'webmail_not_installed' => 'O software de webmail não está instalado.',
    'webmail_disabled' => 'Serviço de webmail está desligado.',
    'spamassassin_not_installed' => 'O SpamAssassin não está instalado.',
    // pfu:
    'anonymous_ftp_shared' => 'Impossível configurar o FTP anónimo: O tipo de endereço IP é partilhado.',
    'anonymous_ftp_used' => 'Impossível configurar o FTP anónimo: O endereço IP está a ser utilizado por outro domínio no serviço de FTP anónimo',
    'sshterm__not_installed' => 'O terminal SSH não está instalado',
    'sshterm__empty_shell' => 'De modo a utilizar o cliente de terminal, deve permitir o acesso de shell a este domínio.',
    // pfw:
    'aspdotnet_not_installed' => 'O ASP.NET não está instalado.',
    'tsclient__not_installed' => 'O Remote Desktop não está instalado.',
    'site_builder_no_package' => 'O Presence Builder não está disponível. Por favor verifique se o Presence Builder está instalado e selecione-o como um componente ativo.',
    'site_builder_not_configured' => 'O Presence Builder não está configurado.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Ferramentas',
    'ui__reseller/client#clientslist__title' => 'Clientes',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "Configurar fontes de dados ODBC para o domínio",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "Selecione o domínio no qual quer configurar as fontes de dados ODBC.",

    'ui__client/domain/hosting/tsclient_unknown__wizard-title' => "Aceda ao alojamento virtual de um domínio pelo Remote Desktop",
    'ui__client/domain/hosting/tsclient_unknown__wizard__2_unknown' => "Seleccione o domínio no qual quer aceder por Remote Desktop ao alojamento virtual.",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "Gerir os directórios virtuais no domínio",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "Seleccione o domínio no qual quer gerir os directórios virtuais.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Gerencie os Diretórios Virtuais em um Website',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Selecione o domínio no qual quer gerir os diretórios Web.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "Configurar protecção hotlink para o domínio",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "Seleccione o domínio no qual quer proteger os ficheiros contra hotlinking.",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "Configure as definições de PHP para o domínio",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "Seleccione o domínio no qual quer configurar as definições de PHP.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Configure o FTP anónimo no domínio',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Selecione o domínio no qual quer configurar o FTP anónimo.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Gerir os diretórios protegidos com palavra-passe do domínio',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Selecione o domínio onde quer gerir os diretórios protegidos por palavra-passe.',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => 'Ver as estatísticas de rede do domínio',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => 'Selecione o domínio onde quer ver as estatísticas de rede.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Configurar o gestor de log para o domínio e visualizar os ficheiros de log',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Seleccione o domínio onde quer configurar o gestor de log ou ver os ficheiros de log.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Gerir os certificados SSL/TLS do domínio',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Seleccione o domínio no qual deseja gerir os certificados SSL/TLS.',

    'ui__client/to-reseller_multi__wizard-title' => 'Converter contas de cliente para contas de revendedor',
    'ui__client/to-reseller_multi__wizard__1_multi' => 'Selecione as contas de cliente que deseja converter em contas de revenda.',

    'ui__reseller/to-client_multi__wizard-title' => 'Converter contas de revendedor para contas de cliente',
    'ui__reseller/to-client_multi__wizard__1_multi' => 'Selecione as contas de revenda que quer converter em contas de cliente.',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => 'Especifique  as definições de alojamento para o domínio.',







    'ui__client/domain/disable_multi__wizard-title' => 'Suspender Domínios',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Seleccione os domínios que quer suspender.',

    'ui__client/domain/enable_multi__wizard-title' => 'Domínios ativos',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Selecione os domínios que quer reativar.',

    'ui__client/domain_unknown__wizard-title' => 'Ver Domínios',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Selecione o cliente do qual deseja ver os domínios.',

    'ui__client/domain/to-client_multi__wizard-title' => 'Converter contas de administrador de domínio em contas de cliente',
    'ui__client/domain/to-client_multi__wizard__2_multi' => 'Selecione os domínios cujas contas de administrador quer converter a contas de cliente',

    'ui__client/domain/register_unknown__wizard-title' => 'Registar Domínios',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Seleccione o domínio que deseja registar.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Utilizar as Ferramentas do MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Seleccione o domínio que quer gerir com as ferramentas do MyPlesk.com.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'Acesso ao Servidor por SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'Seleccione o domínio ao qual quer connectar por SSH.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Utilizadores do Endereço IP',
    'ui__server/ip-address/client_unknown__title' => 'Utilizadores do Endereço IP',
    'ui__server/ip-address/client_unknown__description' => 'Utilizadores do endereço IP %1',

    'disabled_by_admin' => 'Desactivado pelo administrador do servidor',






    'ui__client/domain/chowner_multi__short-title' => 'Mudar proprietário',
    'ui__client/domain/chowner_multi__title' => 'Mudar o proprietário da assinatura',
    'ui__client/domain/chowner_multi__description' => 'Mudar o proprietário da assinatura.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Seleccione os domínios aos quais deseja modificar o proprietário e clique Seguinte >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Mudar proprietário',
    'ui__client/domain/chowner_unknown__title' => 'Mudar o proprietário da assinatura',
    'ui__client/domain/chowner_unknown__description' => 'Mudar o proprietário da assinatura.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Mudar o proprietário da assinatura',


    'ui__client/chowner__short-title' => 'Modificar Proprietário do Cliente',
    'ui__client/chowner__title' => 'Modificar Proprietário da Conta Cliente',
    'ui__client/chowner__description' => 'Atribuir novo proprietário a esta conta de cliente',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Não existem botões personalizados.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Não existem botões personalizados na interface do revendedor %1.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Remover o botão %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Eliminar',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Remover o botão %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Remover botões personalizados da interface do revendedor.',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Eliminar',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Remover botões personalizados',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Remover botões',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Seleccione o revendedor cujos botões personalizados quer remover e clique Seguinte >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Seleccione os botões que deseja remover e clique Seguinte >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Confirme a remoção dos botões seleccionando a checkbox neste ecrã e clique Finalizar.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Remover um botão personalizado da interface do revendedor.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Eliminar',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Remover um botão personalizado',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Remover botão personalizado',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Seleccione o revendedor cujo botão personalizado quer remover e clique Seguinte >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Seleccione o botão personalizado que quer remover e clique Seguinte >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Confirme a remoção do botão personalizado seleccionando a checkbox neste écran e clique Finalizar.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Editar as propriedades do botão personalizado a nível de revendedor %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Configurações',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Modificar o botão personalizado %1 do revendedor',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Adicionar botão personalizado',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selecione o revendedor em cuja interface deseja criar um botão personalizado e clique em Seguinte >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Clique Finalizar para criar o botão.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Mudar as propriedades de um botão na interface do revendedor.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Propriedades',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Mudar as propriedades de um botão na interface do revendedor',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Mudar as propriedades do botão personalizado',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Seleccione o revendedor cujo botão personalizado quer modificar e clique Seguinte >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Seleccione um botão personalizado deseja modificar e clique Seguinte >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Quando terminar de modificar as propriedades do botão, clique Finalizar para aplicar as modificações e sair do assistente.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Não disponibilizar o botão %1 aos seus clientes.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Indisponibilizar aos seus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Não disponibilizar o botão %1 aos seus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Disponibilizar o botão %1 aos cliente do revendedor.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Disponibilizar aos seus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Disponibilizar o botão %1 aos cliente do revendedor',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Disponibilize ou não um botão personalizado aos seus clientes.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Disponível/não disponível aos seus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Disponibilize ou não um botão personalizado aos seus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Disponibilize ou não um botão personalizado aos seus clientes.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Seleccione o revendedor cujo botão personalizado quer disponibilizar aos clientes do revendedor e clique Seguinte >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Seleccione um botão personalizado que deseja que fique disponível ou não aos seus clientes e clique Seguinte >>.',




    'ui__server/ip-addresses__short-title' => 'Endereços IP',
    'ui__server/ip-addresses__title' => 'Gestão de Endereços IP',
    'ui__server/ip-addresses__description' => 'Adicionar, remover e atribuir endereços IP.',

    'ip_ctrl__allow_ftps' => 'Permitir FTP sobre SSL/TLS',
    '__ftps' => 'FTP em SSL/TLS',
    '__not_allowed' => 'Não permitida',



    'ui__client/ipaddress/domain_unknown__short-title' => 'Domínios a utilizar %2',
    'ui__client/ipaddress/domain_unknown__title' => 'Domínios que Utilizam %1 endereço IP %2',
    'ui__client/ipaddress/domain_unknown__description' => 'Ver a lista de domínios que utilizam o endereço IP %1 %2',

    'ui__client/ipaddress__none-available' => 'Sem IP\'s disponíveis',
    'ui__client/ipaddress__none-available__1' => 'Sem IP\'s disponíveis',



    'ui__client/domain/report_unknown__wizard-title' => 'Ver o Relatório do Domínio',
    'ui__client/domain/report_unknown__wizard__2_unknown' => 'Seleccione o domínio do qual deseja ver o relatório.',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Seleccione o novo proprietário do domínio.',

    'ui__client/chowner__wizard__2_select' => 'Selecione o novo proprietário da conta de cliente.',

    '__ip_addr_state_unknown' => "O endereço IP não está operativo agora porque o sistema ainda está a processar o seu pedido. Por favor espere um minuto.",


    'resellers_list__accounts' => 'Utilizadores',

    'ip_addr__repair_is_not_allowed' => 'O endereço IP não pode ser reparado sob o ambiente do Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'O revendedor %1 não tem clientes.',

    'ippoolManager__ip_used_by_nohost_domain' => "O endereço %%ip%% não pode ser removido porque está a ser utilizado por um ou mais domínios sem alojamento.",
    'ippoolManager__ip_used_for_mail_service' => "O endereço %%ip%% não pode ser removido porque está a ser utilizado por um ou mais domínios para o endereço de IP do seu serviço de email.",
    'ippoolManager__ip_used_for_send_emails' => "O endereço IP %%ip%% não pode ser removido porque está a ser utilizado para enviar emails de um IP específico (consulte Definições do Servidor de Correio).",
    'ippoolManager__ip_used_in_dns_zone' => 'O endereço %%ip%% não pode ser removido porque está a ser utilizado na zona DNS de um ou mais domínios.',
    'ip_ctrl__cannot_manage_on_vz' => 'Esta instalação do Plesk está a funcionar no Virtuozzo containers. Só podem ser adicionados novos endereços IP pelo do nó do administrador do Virtuozzo containers.',

    'client_template__limits_auto_adjusted' => 'Os limites do modelo de cliente foram automaticamente ajustados.',

    '__entries' => 'Entradas',

    '__path_is_not_set' => 'O caminho não está especificado. Por favor especifique um caminho válido.',

    // license keys
    'key_new_plesk_key_is_uploaded' => 'Foi carregada uma nova chave do Plesk.',
    'key_new_additional_key_is_uploaded' => 'Foi carregada uma nova chave adicional.',

    'defaultcomponents__imap_required' => '(O servidor de correio actual não suporta IMAP)',
    'defaultcomponents__php_required' => '(O PHP não está instalado)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'A protecção Hotlink está ligada neste domínio.',
    'i_hotlinkprotection_off' => 'A protecção Hotlink está desligada neste domínio.',

    '__commercial_web_stats_not_installed' => 'Plesk suporta apenas softwares comerciais de estatísticas de rede para o cálculo das estatísticas do sub-domínio. Este software não está instalado no sistema.',

    'mail__spamassassin_personal_settings_disallowed' => 'A capacidade de aplicar definições de filtragem de spam está desligada pelo administrador do servidor. As definições de filtragem de spam especificadas em baixo não vão ser aplicadas',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => 'Impossível criar objecto %1 : %2',
    'cu_dom_pref__invalid_expiration_date' => 'Data limite inválida: %1',
    'cu_cl_pref__illegal_date_val' => 'Especificou um valor errado para a data (%1)',
    'cu_cl_pref__illegal_date_greater_less' => 'Insira o ano de "%1" a "%2"',
    'cu_initconf__unable_set_ip_alias_type' => 'Impossível definir o tipo de nome alternativo IP: %1',
    'cu_mlist__unable_change_status' => "Impossível modificar o estado da lista de envio: %1",
    'cu_initconf__unable_change_passwd' => "Impossível modificar a senha do administrador: %1",
    'cu_serverpref__option_description_include_remote_databases' => 'Inclui bases de dados MySQL remotas no cálculo de utilização de espaço em disco.',
    'cu_siteapp_item__add_to_pool_success' => 'A aplicação web foi adicionada ao repositório de aplicações web.',
    'cu_siteapp_item__remove_from_pool_success' => 'A aplicação web foi removida ao repositório de aplicações web.',
    'cu_traffic_command_description_add_user' => 'Regista uma quantidade específica de tráfego, como tendo já sido efetuado pelo cliente/revendedor',
    'cu_traffic_command_description_sub_user' => 'Subtrai uma quantidade específica de tráfego à quantidade registada no cliente/revendedor',
    'cu_traffic_command_description_add_batch_user' => 'Regista uma quantidade específica de tráfego, como tendo já sido efetuado pelo cliente/revendedor (modo em bloco)',
    'cu_traffic_command_description_del_user' => 'Repõe a zero a quantidade de tráfego registado para este cliente/revendedor.',
    'cu_resellerpref__option_lock_screen' => 'Impede que os utilizadores trabalhem no Plesk até que as interfaces estejam completamente carregadas',
];