<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => '別のユーザやサイトと IP アドレスを共有せず、専用 IP アドレスでサイトをホスティングしている場合、他のユーザが FTP 経由でファイルを匿名でアップロードまたはダウンロードできるディレクトリをサイト内にセットアップすることができます。匿名 FTP をオンにすると、ユーザは「ftp://ftp.your-domain.com」などのアドレスを持つディレクトリに「anonymous」というユーザ名と任意のパスワードを使用してログインできるようになります。',
    'anonymous-ftp.displayLogin' => 'ログインメッセージを表示',
    'anonymous-ftp.loginText' => 'メッセージテキスト',
    'anonymous-ftp.incomingDir' => '受信ディレクトリへのアップロードを許可',
    'anonymous-ftp.incomingSubDir' => '受信ディレクトリでのディレクトリの作成を許可',
    'anonymous-ftp.incomingReadable' => '受信ディレクトリからのダウンロードを許可',
    'anonymous-ftp.quota' => 'incoming ディレクトリのディスク容量を制限',
    'anonymous-ftp.maxConnections' => '同時接続の数を制限',
    'anonymous-ftp.bandwidth' => 'この仮想 FTP ドメイン用のダウンロード帯域幅の上限',
    'anonymous-ftp.unlimited' => '無制限',

    'aps.catalog.loading' => '読み込み中...',
    'aps.catalog.searchName' => 'アプリケーション',
    'aps.catalog.searchVendor' => 'ベンダー',
    'aps.catalog.searchPackager' => 'パッケージャ',
    'aps.catalog.searchLicenseType' => 'ライセンスタイプ',
    'aps.catalog.searchLicenseTypeAny' => 'すべて',
    'aps.catalog.searchLicenseTypeFreeware' => '無料',
    'aps.catalog.searchLicenseTypeCommercial' => '有料',
    'aps.catalog.showSearch' => '検索を表示する',
    'aps.catalog.hideSearch' => '検索エリアを隠す',
    'aps.catalog.buttonSearch' => '検索',
    'aps.catalog.buttonResetSearch' => '検索結果をリセット',
    'aps.catalog.showCategories' => 'カテゴリを選択することも、検索ボックスでアプリケーションを検索することもできます。',
    'aps.catalog.searchResults' => '検索結果',
    'aps.catalog.buttonInstall' => 'インストール',
    'aps.catalog.buttonInstallTooltip' => '最適なデフォルトパラメータで、アプリケーションの最新バージョンを簡易インストールします。',
    'aps.catalog.buttonAdvancedInstall' => 'インストール（カスタム）',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'すべてのパラメータをカスタマイズして、アプリケーションの最新バージョンをインストールします。',
    'aps.catalog.buttonInstallOldVersion' => 'インストールバージョン',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'すべてのパラメータをカスタマイズして、選択されたバージョンのアプリケーションをインストールします。',
    'aps.catalog.buttonInstallDescription' => '既にアクティベーションキーを所有しているか、アプリケーションを試用する場合は、サイトにアプリケーションをインストールしてください。',
    'aps.catalog.buttonInstallDescriptionFree' => 'この無料アプリケーションをサイトにインストールします。',
    'aps.catalog.version' => 'バージョン',
    'aps.catalog.moreVersions' => 'その他のバージョン',
    'aps.catalog.release' => 'リリース',
    'aps.catalog.overview' => '概要',
    'aps.catalog.noApplicationsInCategory' => 'このカテゴリにはアプリケーションがありません。 別のカテゴリを選択してください',
    'aps.catalog.noCategoriesSelected' => 'このカテゴリのすべてのアプリケーションを表示するには、カテゴリを選択してください',
    'aps.catalog.noSearchResults' => '検索条件を満たすアプリケーションがありません',
    'aps.catalog.connectionFailed' => 'アプリケーションカタログへの接続に失敗しました。 %%retryLink%%',
    'aps.catalog.retry' => '再試行',
    'aps.catalog.categoriesError' => '現在、カテゴリのリストを読む込むことができません',
    'aps.catalog.applicationsError' => '現在、アプリケーションのリストを読む込むことができません',
    'aps.catalog.detailsError' => '現在、アプリケーションの詳細を読む込むことができません',
    'aps.catalog.searchError' => '現在、検索結果を読み込むことができません',
    'aps.catalog.changelogEntry' => 'v%%version%%（リリース %%release%%）- %%description%%',
    'aps.catalog.changelog' => '変更履歴',
    'aps.catalog.officialApplicationSite' => 'ベンダー情報',
    'aps.catalog.returnToCategories' => '<< アプリケーションリストに戻る',
    'aps.catalog.buttonUninstall' => '削除',
    'aps.catalog.gotoHome' => 'ホーム',
    'aps.catalog.all' => 'すべて',
    'aps.catalog.buttonDetails' => 'さらに詳しく',
    'aps.catalog.buttonBuy' => '今すぐ購入',
    'aps.catalog.buttonBuyTooltip' => 'アプリケーションを購入',
    'aps.catalog.buttonBuyDescription' => 'ストアを訪問して、アプリケーションのアクティベーションキーを購入してください。',
    'aps.catalog.buttonDownload' => 'ダウンロード',
    'aps.catalog.buttonDownloadDescription' => '既にアクティベーションキーを所有しているか、アプリケーションを試用する場合は、アプリケーションをダウンロードしてください',
    'aps.catalog.marketplaceMoreInfo' => '詳細は、%%link%%を参照してください',
    'aps.catalog.marketplaceMoreInfoLink' => 'アプリケーションベンダーのウェブサイト',

    'aps.configure.installedAt' => "インストール場所",
    'aps.configure.otherSettings' => "その他",
    'aps.configure.globalSettings' => 'パッケージ設定',
    'aps.configure.passwordConfirmation' => 'パスワードの確認',
    'aps.configure.databaseParams' => 'データベースパラメータ',
    'aps.configure.noInstallationUrlAvailable' => 'なし（外部アプリケーション）',
    'aps.configure.updateSettingsSection' => 'アップデート設定',
    'aps.configure.forceUpdates' => 'アップデートの公開後、このアプリケーションを自動更新',
    'aps.configure.forceUpdatesHint' => 'このアプリケーションは新しいバージョンに自動更新されます。注意：このオプションを使用する場合、更新によってアプリケーションの機能が著しく影響を受ける可能性があるため、注意が必要です。例えば、別バージョンのアプリケーションでは、アプリケーション拡張が機能しなくなる場合があります。',

    'aps.install.showAllSettings' => 'すべての設定を表示',
    'aps.install.showLessSettings' => '最小限の設定の表示',
    'aps.install.install' => 'インストール',
    'aps.install.otherSettings' => 'その他の設定',
    'aps.install.globalSettings' => 'パッケージ設定',
    'aps.install.passwordConfirmation' => 'パスワードの確認',
    'aps.install.provisionsSectionLabel' => 'インストールパス',
    'aps.install.context' => 'このウェブアプリケーションのインストール先を指定します。',
    'aps.install.registerAsWebmailSection' => 'ウェブメール登録',
    'aps.install.registerAsWebmailDescription' => "アプリケーションがウェブメールクライアントである場合は、このオプションを選択してください。これにより、契約およびサービスプランのメール設定に、ウェブメールサービスの選択肢としてこのアプリケーションが表示されるようになります。管理者は、［サーバ管理］>［設定］>［ウェブメール］でウェブメールのパブリックアクセス URL を構成できます。",
    'aps.install.registerAsWebmailLabel' => 'ウェブメールサービスとして登録する',
    'aps.install.addItem' => '追加',
    'aps.install.removeItem' => '削除',
    'aps.install.updateSettingsSection' => 'アップデート設定',
    'aps.install.forceUpdates' => 'アップデートの公開後、このアプリケーションを自動更新',
    'aps.install.forceUpdatesHint' => 'このアプリケーションは新しいバージョンに自動更新されます。注意：このオプションを使用する場合、更新によってアプリケーションの機能が著しく影響を受ける可能性があるため、注意が必要です。例えば、別バージョンのアプリケーションでは、アプリケーション拡張が機能しなくなる場合があります。',

    'aps.invalid-requirements.requirementsLegend' => '要件',
    'aps.invalid-requirements.domainLegend' => 'ウェブサイト',
    'aps.invalid-requirements.context' => '別のウェブサイトの選択',
    'aps.invalid-requirements.backToApplicationList' => 'アプリケーションリストに戻る',

    'aps.license.title' => '%%packageName%% のインストール',
    'aps.license.doYouAcceptLicense' => 'このアプリケーションをインストールするには、エンドユーザライセンス契約をお読みになり同意していただく必要があります。',
    'aps.license.licenseAgree' => 'ライセンス契約に同意します。',

    'aps.services-list-customization.settings' => '設定',

    'asp-dot-net.change-version.frameworkVersion' => 'ASP.NET フレームワークバージョン',

    'asp-dot-net.settings.casSettingsSection' => "コードアクセスセキュリティ",
    'asp-dot-net.settings.clientScriptsSection' => "スクリプトライブラリ設定",
    'asp-dot-net.settings.connStringsSection' => "接続文字列マネージャ",
    'asp-dot-net.settings.customErrorsSection' => "カスタムエラー設定",
    'asp-dot-net.settings.frameworkVersionSection' => "フレームワークバージョン",
    'asp-dot-net.settings.globalizationSection' => "グローバリゼーション設定",
    'asp-dot-net.settings.otherSection' => "セッション設定",
    'asp-dot-net.settings.pageAndRuntimeSection' => "コンパイルおよびデバッグ",
    'asp-dot-net.settings.authMode' => "認証モード",
    'asp-dot-net.settings.connStrings' => "接続文字列",
    'asp-dot-net.settings.connStringName' => "名前",
    'asp-dot-net.settings.connStringValue' => "接続パラメータ",
    'asp-dot-net.settings.culture' => "カルチャー",
    'asp-dot-net.settings.customErrMode' => "カスタムエラーモード",
    'asp-dot-net.settings.customErrorRedirect' => "リダイレクト URL",
    'asp-dot-net.settings.customErrorStatus' => "ステータスコード",
    'asp-dot-net.settings.customErrorStatusInvalid' => "ステータスコードは整数値にしてください。",
    'asp-dot-net.settings.customErrors' => "カスタムエラー",
    'asp-dot-net.settings.debugMode' => "デバッグをオンにする",
    'asp-dot-net.settings.defLanguage' => "ウェブページのデフォルト言語",
    'asp-dot-net.settings.tempDirectory' => "一時ディレクトリ",
    'asp-dot-net.settings.fileEnc' => "ファイルのエンコーディング",
    'asp-dot-net.settings.fileEncInvalid' => "ファイルのエンコーディングに指定した値が無効です。",
    'asp-dot-net.settings.pathToLib' => "Microsoft スクリプトライブラリへのパス",
    'asp-dot-net.settings.pathToLibInstall' => "インストール",
    'asp-dot-net.settings.reqEnc' => "要求のエンコーディング",
    'asp-dot-net.settings.reqEncInvalid' => "要求のエンコーディングに指定した値が無効です。",
    'asp-dot-net.settings.resEnc' => "応答のエンコーディング",
    'asp-dot-net.settings.resEncInvalid' => "応答のエンコーディングに指定した値が無効です。",
    'asp-dot-net.settings.sessTimeout' => "セッションタイムアウト（分）",
    'asp-dot-net.settings.sessTimeoutInvalid' => "セッションタイムアウトパラメータに指定した値が無効です。%%max%% 以下の正の整数値を入力してください。",
    'asp-dot-net.settings.trustLevel' => "CAS 信頼レベル",
    'asp-dot-net.settings.uiCulture' => "UI カルチャー",
    'asp-dot-net.settings.version' => "バージョン",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'ウェブサイトでの CAS 信頼レベルのオーバーライドを許可',
    'asp-dot-net.settings.addConnStrings' => '接続文字列を追加',
    'asp-dot-net.settings.addCustomErrors' => 'カスタムエラーを追加',
    'asp-dot-net.settings.buttonRemove' => '削除',

    'database.clone.formDescription' => 'データベースの内容を新規データベースまたは既存のデータベースにコピーします。既存のデータベースにコピーする場合、コピー元のデータベースのテーブルが、コピー先のデータベースのテーブル一覧に追加されます。注意：テーブル名が競合する場合、コピー先のテーブルが移行元のテーブルに置換されます。',
    'database.clone.copyData' => 'フルコピーを作成する',
    'database.clone.copyDataHint' => '選択すると、データベース全体（構造とデータを含む）がコピーされます。クリアすると、テーブルの構造のみがコピーされます。',
    'database.clone.server' => 'コピー先データベースサーバ',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'その他...',
    'database.clone.database' => 'コピー先データベース',
    'database.clone.newDatabase' => '名前を指定してデータベースを作成する',
    'database.clone.existingDatabase' => '既存データベースにコピーする',
    'database.clone.externalDbHost' => 'ホスト名または IP アドレス',
    'database.clone.externalDbLogin' => 'ユーザ名',
    'database.clone.externalDbPassword' => 'パスワード',
    'database.clone.subscription' => 'コピー先契約',
    'database.clone.subscription_powerUser' => 'コピー先ウェブスペース',
    'database.clone.cloneInProgress' => 'データベース %%source%% からデータベース %%destination%% への複製を実行しています。進行状況はメールでお知らせします（%%email%%）。',
    'database.clone.unableToClone' => 'データベース「%%source%%」をコピーできません。',
    'database.clone.unableToCreateExternalDatabase' => '指定サーバでデータベース「%%destination%%」を作成できません。',
    'database.clone.databaseCloned' => 'データベース「%%source%%」がコピーされました。',
    'database.clone.emailSubjSuccess' => 'データベース「%%sourceDatabase%%」がコピーされました。',
    'database.clone.emailSubjFailure' => 'データベース「%%sourceDatabase%%」のコピーに失敗しました。',
    'database.clone.emailBodySuccess' => 'データベース「%%sourceDatabase%%」（%%sourceHost%%）はデータベース「%%destDatabase%%」（%%destHost%%）にコピーされました。',
    'database.clone.emailBodyFailure' => 'データベース「%%sourceDatabase%%」（%%sourceHost%%）をデータベース「%%destDatabase%%」（%%destHost%%）にコピーできません。 コピー作業が失敗しました。',
    'database.clone.localServer' => 'ローカルサーバ',

    'database.repair-orphaned.formDescription' => 'このユーザは、復元プロセス後に孤立しています。この問題を解決するには、このユーザにパスワードを指定してください。このユーザをパスワードなしの sys ユーザにする場合、パスワードフィールドを空欄にして修復ユーティリティを実行してください。',
    'database.repair-orphaned.login' => 'データベースユーザ名',
    'database.repair-orphaned.pass' => 'パスワード',
    'database.repair-orphaned.pass2' => 'パスワードの確認',
    'database.repair-orphaned.users' => '注意が必要なユーザがあります。正しく機能させるために修復が必要な孤立ユーザが複数存在します。',
    'database.repair-orphaned.orphaned' => 'ユーザは孤立しています。%%gui begin:link%%今すぐ修復%%gui end:link%%',
    'database.repair-orphaned.repair' => '修復',

    'database.repair.fixSelected' => '選択済みを修復',
    'database.repair.fix' => '修復',

    'database.user.password' => 'パスワード',
    'database.user.passwordConfirmation' => 'パスワードの確認',
    'database.user.server' => 'データベースサーバ',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'データベース',
    'database.user.anyDatabase' => 'すべて',
    'database.user.dataAccess' => 'データアクセス',
    'database.user.structureAccess' => '構造アクセス',
    'database.user.globalAccess' => 'グローバル権限',
    'database.user.globalAccessHint' => 'グローバル権限はこのホスティングアカウント内のすべてのデータベースに対して有効です。',
    'database.user.aclRadio' => 'アクセス制御',
    'database.user.aclLocalhost' => 'ローカル接続のみを許可',
    'database.user.aclAny' => '任意のホストからのリモート接続を許可',
    'database.user.aclCustom' => '以下からのリモート接続を許可',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\n指定したホストは、このユーザの代理としてデータベースにアクセスすることが許可されます。",
    'database.user.remoteAccess' => 'リモートアクセス',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n指定した IP アドレスは、このユーザの代理としてデータベースにアクセスすることが許可されます。このリストでの変更は、ホスティング事業者によって事前モデレーションされます。",
    'database.user.example' => "例：\n%%example%%",
    'database.user.denied' => 'システムファイアウォールルールを使用',
    'database.user.allowed' => '以下からのリモート接続を許可',
    'database.user.default' => 'デフォルトでこのユーザのクレデンシャルを %%webadmin%% へのアクセスに使用',
    'database.user.remoteAccessHint' => 'ホスティング事業者へお問い合わせの上、ここで指定したオプションが（MySQL への受信アクセスに関する）現在のファイアウォールルールに適合していることをご確認ください。',
    'database.user.phpMyAdmin' => 'PhpMyAdmin',
    'database.user.myLittleAdmin' => 'myLittleAdmin',
    'database.user.webAdmin' => 'Web Admin',
    'database.user.role' => '役割',
    'database.user.roleReadWrite' => '読取および書込',
    'database.user.roleWriteOnly' => '書込専用',
    'database.user.roleReadOnly' => '読取専用',
    'database.user.roleCustom' => 'カスタム',

    'database.generalSection' => '全般',
    'database.name' => 'データベース名',
    'database.server' => 'データベースサーバ',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => '関連サイト',
    'database.noDomainRelations' => '関連サイトなし',
    'database.userSection' => 'ユーザ',
    'database.userSectionDescription' => 'デフォルトのデータベースユーザを作成します。Plesk はこのユーザの代理としてデータベースにアクセスします。データベースにデータベースユーザが紐付けられていない場合、このデータベースにはアクセスできません。',
    'database.createUser' => '新しいデータベースユーザを作成',
    'database.username' => 'データベースユーザ名',
    'database.password' => 'パスワード',
    'database.passwordConfirmation' => 'パスワードの確認',
    'database.allDbAccess' => 'ユーザは選択した契約内のすべてのデータベースにアクセスできます。',
    'database.aclRadio' => 'アクセス制御',
    'database.aclLocalhost' => 'ローカル接続のみを許可',
    'database.aclAny' => '任意のホストからのリモート接続を許可',
    'database.aclCustom' => '以下からのリモート接続を許可',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\n指定したホストは、このユーザの代理としてデータベースにアクセスすることが許可されます。",
    'database.remoteAccess' => 'リモートアクセス',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n指定した IP アドレスは、このユーザの代理としてデータベースにアクセスすることが許可されます。このリストでの変更は、ホスティング事業者によって事前モデレーションされます。",
    'database.example' => "例：\n%%example%%",
    'database.denied' => 'システムファイアウォールルールを使用',
    'database.allowed' => '以下からのリモート接続を許可',

    'deployment-section.deploymentDisabledHint' => 'Git リポジトリからファイルをアップロード',
    'deployment-section.deploymentEnabledHint' => 'Git サポートを有効化',
    'deployment-section.deploymentSectionLegend' => 'ホスティングにコピーするファイル',
    'deployment-section.deploymentSectionDescriptionHint' => 'Git サポートを無効にすると、ルートディレクトリ（ウェブサイト/アプリケーションのルートおよびドキュメントルート）は空で作成され、ブラウザにはこのサイトのデフォルトページが表示されます。FTP またはファイルマネージャによってサイトのファイルをドキュメントルートにアップロードする必要があります。あるいは、［ウェブサイトとドメイン］で Git を今すぐ（または後で）有効化して、Git リポジトリからファイルをアップロードしてください。',

    'dns-zone.acl-record.addIpHint' => '当該 DNS ゾーンのコピーの受け入れが許可される DNS サーバの IP アドレスを追加します。',
    'dns-zone.acl-record.ipAddress' => 'IP アドレス',
    'dns-zone.acl-record.ipAddressWithMask' => 'IP アドレス/マスク',
    'dns-zone.acl-record.ipAddressDescription' => "例：2002:7b7b:7b7b::1、123.123.123.123",
    'dns-zone.acl-record.ipAddressWithMaskDescription' => "例：2002:7b7b:7b7b::1/48、123.123.123.123/16",
    'dns-zone.acl-record.addIpButton' => 'IP アドレスを追加',

    'dns-zone.record.type' => "レコードタイプ",
    'dns-zone.record.domainName' => "ドメイン名",
    'dns-zone.record.nameServer' => "ネームサーバ",
    'dns-zone.record.protocol' => "プロトコル",
    'dns-zone.record.priority' => "優先度",
    'dns-zone.record.priorityLow' => "低（%%priority%%）",
    'dns-zone.record.priorityHigh' => "最高（%%priority%%）",
    'dns-zone.record.weightLow' => "低（%%weight%%）",
    'dns-zone.record.weightHigh' => "最高（%%weight%%）",
    'dns-zone.record.ipAddress' => "IP アドレス",
    'dns-zone.record.ipAddressDescription' => "例：123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6 アドレス",
    'dns-zone.record.ipAddressV6Description' => "例：2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "例：2002:7b7b:7b7b::1/48、123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "例：2002:7b7b:7b7b::1、123.123.123.123",
    'dns-zone.record.canonicalName' => "正規名",
    'dns-zone.record.mailDomain' => "メールドメイン",
    'dns-zone.record.mxServer' => "メールエクスチェンジサーバ",
    'dns-zone.record.mxServerPriority' => "メールエクスチェンジサーバの優先度を指定",
    'dns-zone.record.txtRecord' => "TXT レコード",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "TXT レコードに正しくない値が指定されました。",
    'dns-zone.record.dsRecord' => "DS レコード",
    'dns-zone.record.dsRecordDescription' => "例：60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "DS レコードに正しくない値が指定されました。",
    'dns-zone.record.serviceName' => "サービス名",
    'dns-zone.record.serviceNameDescription' => "例：SIP",
    'dns-zone.record.srvWeight' => "同じ優先度のレコードに対する相対的な重み",
    'dns-zone.record.targetHost' => "ターゲットホスト",
    'dns-zone.record.targetHostDescription' => "例：example.com",
    'dns-zone.record.targetPort' => "ターゲットポート",
    'dns-zone.record.retrieveDataError' => "レコードデータが見つかりません。",
    'dns-zone.record.unknownTypeError' => "不明な DNS レコードタイプです。",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => '他の MX レコードが存在する場合、NULL MX レコードは設定できません',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'NULL MX レコードが存在する場合、非 NULL MX レコードは設定できません',
    'dns-zone.record.masterShouldBeRemote' => "2 つの権威ネームサーバが別々のホスト上に存在する必要があります。",
    'dns-zone.record.caaTag' => "タグ",
    'dns-zone.record.caaRecord' => "値",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.invalidValue' => '値は無効です。1 秒～2147483647 秒まで可能です。',
    'dns-zone.record.ttlDefaultValue' => 'デフォルト値：%%value%% 秒',

    'dns-zone.restore-default.formHint' => "サーバで使用されているデフォルト DNS テンプレート設定に従って元のゾーン構成に復元することができます。ゾーンの復元に使用する IP アドレスを選択し、www エイリアスがそのドメインに必要かどうかを指定します。",
    'dns-zone.restore-default.ipv4' => "IPv4 アドレス",
    'dns-zone.restore-default.ipv4Hint' => "例：123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6 アドレス",
    'dns-zone.restore-default.ipv6Hint' => "例：2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => '指定したメールアドレスは無効です。',
    'dns-zone.restore-default.customIpHint' => "この IP アドレスのレコードは、「ユーザが変更済み」だと見なされ、サーバ全体の DNS テンプレートと同期されません。",
    'dns-zone.restore-default.wwwPrefix' => "www プレフィックス",
    'dns-zone.restore-default.previewRecords' => "サイトプレビューに使用されるレコードを復元",

    'dns-zone.soa-record.soaMnameSection' => 'プライマリネームサーバ',
    'dns-zone.soa-record.soaMname' => 'ネームサーバ',
    'dns-zone.soa-record.soaMnameAutoselect' => '（Autoselect）',
    'dns-zone.soa-record.soaRecordSection' => 'SOA レコード',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => '更新（Refresh）',
    'dns-zone.soa-record.retry' => '再試行（Retry）',
    'dns-zone.soa-record.expire' => '期限（Expire）',
    'dns-zone.soa-record.minimum' => '最小（Minimum）',
    'dns-zone.soa-record.invalidValue' => '値は無効です。1 秒～68 年まで可能です',
    'dns-zone.soa-record.serialNumberFormatSection' => 'DNS ゾーンのシリアル番号フォーマット',
    'dns-zone.soa-record.serialNumberFormatText' => 'IETF および RIPE が推奨するシリアル番号フォーマットを使用することによって、レジストラから拒否される問題を解決できます。高レベル DNS ゾーンに登録された多くのドメインではこのフォーマットが必須となります。',
    'dns-zone.soa-record.serialNumberFormat' => 'IETF と RIPE が推奨するシリアル番号フォーマットを使用',
    'dns-zone.soa-record.serialNumberFormatHint' => '異なるシリアル番号フォーマットに切り替えると、DNS ゾーンの更新で遅延が発生する可能性があります。',
    'dns-zone.soa-record.restoreDefaultButton' => 'デフォルト設定を使用',
    'dns-zone.soa-record.zoneDefaultsSection' => 'ゾーンのデフォルト',

    'domain-info-section.domainName' => 'ドメイン名',
    'domain-info-section.emptyDomainName' => 'ドメイン名を入力してください。',
    'domain-info-section.ipAddress' => 'IP アドレス',
    'domain-info-section.shared' => '共用',
    'domain-info-section.exclusive' => '専用',
    'domain-info-section.ipAddressHint' => "ウェブサイトをホスティングしている IP アドレス。ウェブサイトの仮想ホストのネットワークアドレスです。この IP アドレスは、契約内で作成された全ウェブサイトに使用されます。",
    'domain-info-section.ipAddressHint_powerUser' => "ウェブサイトをホスティングしている IP アドレス。ウェブサイトの仮想ホストのネットワークアドレスです。この IP アドレスは、ウェブスペース内で作成された全ウェブサイトに使用されます。",
    'domain-info-section.userName' => 'ユーザ名',
    'domain-info-section.userNameHint' => 'ウェブスペースに紐付けられたシステムユーザアカウント。ホストされているファイルへの FTP および SSH 経由のアクセスに使用されます。',
    'domain-info-section.emptyLogin' => 'ユーザ名を入力してください。',
    'domain-info-section.password' => 'パスワード',
    'domain-info-section.emptyPassword' => 'パスワードを入力してください。',
    'domain-info-section.passwordConfirmation' => 'パスワード再入力',

    'email-address.generalTab' => '全般',
    'email-address.generalHint' => 'このメールアカウントに追加ユーザが紐付けられている（顧客パネルへのアクセスが有効である）場合、このページで行った変更が当該ユーザの設定にも適用されます。例えばメールアドレスとパスワードを変更すると、追加ユーザのログイン名とパスワードが新しい値に変わります。',
    'email-address.redirectTab' => '転送',
    'email-address.redirectHint' => '1 つ以上のメールアドレスへのメールメッセージの転送をセットアップします。',
    'email-address.aliasesTab' => 'メールエイリアス',
    'email-address.autoResponderTab' => '自動応答',
    'email-address.antispamTab' => 'スパムフィルタ',
    'email-address.autoResponderHint' => '自メールアドレス宛てのすべてのメールメッセージ用に自動応答をセットアップします。自動応答は出張や休暇で不在であることを送信者に伝えるための一般的な機能です。',
    'email-address.antivirusTab' => 'アンチウイルス',
    'email-address.name' => 'メールアドレス',
    'email-address.externalEmail' => '外部のメールアドレス',
    'email-address.externalEmailHint' => 'メインのメールアドレスにアクセスできなくなった場合に、パスワードのリセットに使用されます。',
    'email-address.user' => '割り当て先',
    'email-address.password' => 'パスワード',
    'email-address.passwordConfirmation' => 'パスワードの確認',
    'email-address.responderEnable' => '自動応答をオンにする',
    'email-address.responderSubject' => '自動応答メールの件名',
    'email-address.responderContentType' => 'メッセージ形式',
    'email-address.responderContentTypeHint' => 'テキスト形式はあらゆるメールクライアントプログラムで処理できます。したがって、メール作成者が作成した通りに受信者に表示されます。一方、HTML 形式では、さまざまなフォントスタイルを用いて書式付きのテキストを入力できるため、見栄えのするメールを作成できます。ただし、HTML メッセージに対応しないクライアントを使用している受信者には、書式付きテキストが表示されない可能性があります。',
    'email-address.responderContentTypeTextPlain' => 'テキスト',
    'email-address.responderContentTypeTextHtml' => 'HTML メール',
    'email-address.responderCodepage' => 'エンコーディング',
    'email-address.responderCodepageHint' => 'エンコーディングは、テキスト文字をどのように表示するかを決定します。推奨されるエンコーディングは UTF-8 です。',
    'email-address.responderReplyTo' => '転送先',
    'email-address.responderReplyToHint' => '自動応答の送信時に、ここで指定されたメールアドレスへオリジナルメッセージが転送されます。',
    'email-address.responderForwardAddress' => '転送先',
    'email-address.responderForwardAddressHint' => '自動応答の送信時に、ここで指定されたメールアドレスへオリジナルメッセージが転送されます。',
    'email-address.responderMessage' => '自動応答メールのテキスト',
    'email-address.responderReplyToEqualsEmail' => '指定した転送先アドレスは、このメールアドレスと同じです。',
    'email-address.responderForwardAddressEqualsEmail' => '指定した転送先アドレスは、このメールアドレスと同じです。',
    'email-address.responderReplyLimit' => '同一メールアドレスに対する自動応答の送信回数の上限（1 日あたり）',
    'email-address.buttonAddResponderAttachment' => '添付ファイルを追加',
    'email-address.buttonRemoveResponderAttachment' => '削除',
    'email-address.responderAttachment' => '添付ファイル',
    'email-address.redirectEnable' => 'メール転送をオンにする',
    'email-address.redirectRemoveEnable' => '転送されたメールのコピーを Plesk メールボックスに配信しない',
    'email-address.redirectAddress' => '受信メールを次のメールアドレスに転送',
    'email-address.redirectAddressHint' => 'メールアドレスを指定してください。複数のアドレスを入力する場合は、改行、スペース、コンマ、またはセミコロンで区切ります。',
    'email-address.role' => 'ユーザ役割',
    'email-address.roleHint' => 'ユーザ役割はユーザに対し、管理権限と、プロバイダがこの役割に対して選択したアプリケーションへのアクセス権を付与します。',
    'email-address.errorRedirectAddress' => '無効なメールアドレスを指定しました：%value%。',
    'email-address.errorRedirectAddressMultiple' => '無効なメールアドレスを指定しました：%value%。',
    'email-address.mailAlias' => "メールエイリアス",
    'email-address.mailAliasNone' => 'なし',
    'email-address.mailAliasHint' => "メールエイリアスとは、プライマリメールアドレスと紐付けられている代替メールアドレスです。メールエイリアス宛てのすべてのメールがプライマリメールアドレスで受信されます。",
    'email-address.buttonAddMailAlias' => 'メールエイリアスを追加',
    'email-address.buttonRemoveMailAlias' => '削除',
    'email-address.emptyEmail' => 'すべての受信メールの転送先とするメールアドレスを入力してください。',
    'email-address.emailsIsEqual' => '外部のメールアドレスがメインのメールアドレスと同じです。外部のメールアドレスに別のアドレスを指定してください。',
    'email-address.emptyPassword' => 'パスワードを入力してください。',
    'email-address.emptyPasswordConfirmation' => '確認のためもう一度パスワードを入力してください。',
    'email-address.emptyAlias' => "このメールアドレスのメールエイリアスを入力してください。",
    'email-address.aliasEqualsEmail' => '指定されたメールエイリアスがメールアドレスと同じです',
    'email-address.passwordHint' => 'メールボックスへのアクセス用と Plesk へのログイン用に使用されます（該当するオプションが有効である場合）。',
    'email-address.cyclicRedirect' => '自身に転送するようにメールアドレスをセットアップすることはできません。',
    'email-address.errorMailnameReserved' => '入力したメールアドレスは既に使用されています。',
    'email-address.antivirusEnable' => 'このメールアドレスに対してアンチウイルス保護をオンにする',
    'email-address.antivirusHint' => 'アンチウイルスサービスは、ウイルスが含まれるメールメッセージをブロックして送信者と受信者の両方に通知します。',
    'email-address.antivirusSettings' => 'ウイルスチェック',
    'email-address.antivirusSettingOnlyIncomingMail' => '受信メールのみ',
    'email-address.antivirusSettingOnlyOutgoingMail' => '送信メールのみ',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => '送信メールと受信メール',
    'email-address.antispamHint' => 'スパムフィルタリングサービスは、そのメールアドレス宛てに送信されたスパムメールを検出します。スパムメールを削除したり、件名にスパムとしてマークしたり、メールクライアントが IMAP アクセスできる特別なスパムフォルダにスパムメールを移動するように、スパムフィルタを設定できます。スパムフィルタは、スパムの署名を識別するために、さまざまなローカルテストとネットワークテストを行います。',
    'email-address.antispamEnable' => 'このメールアドレスに対してスパムフィルタをオンにする',
    'email-address.antispamSettings' => 'スパムとして分類されたメッセージに対する処理',
    'email-address.antispamSettingsMark' => 'スパムメッセージの件名に指定テキストを追加する',
    'email-address.antispamSettingsMarkHint' => 'テキストを追加したくない場合は、このフィールドを空白のまま残してください。メッセージの件名にスコアを含めたい場合は、_SCORE_ と入力してください。',
    'email-address.antispamReportTextHint' => 'スパムメール本文に追加するテキストを入力してください。',
    'email-address.antispamSettingsDelete' => 'スパムメッセージをすべて削除する',
    'email-address.antispamSettingsDeleteHint' => 'スパムメッセージは受信ボックスから削除されます。',
    'email-address.antispamSettingsMove' => 'スパムをスパムフォルダに移動する',
    'email-address.antispamSettingsMoveHint' => 'スパムメッセージをすべて「スパム」フォルダに移動します。 このフォルダは、メールクライアントプログラムまたはウェブメールからアクセスできます。 IMAP メールアカウントをご使用の場合は、スパムフォルダを用いてスパムフィルタを学習させることができます。',
    'email-address.antispamSettingsMoveWarning' => '［スパムをスパムフォルダに移動する］は、［転送］タブで［転送されたメールのコピーを配信しない］オプションを無効にしなければ機能しません。',
    'email-address.antispamSettingsMoveJunk' => 'スパムを「迷惑メール」フォルダに移動',
    'email-address.antispamSettingsMoveJunkHint' => 'スパムメッセージをすべて「迷惑メール」フォルダに移動します。このフォルダは、メールクライアントプログラムまたはウェブメールからアクセスできます。IMAP メールアカウントを使用している場合、「迷惑メール」フォルダをスパムフィルタの学習に使用できます。',
    'email-address.antispamShowAdvancedSection' => '詳細な設定を表示',
    'email-address.antispamHideAdvancedSection' => '詳細な設定を隠す',
    'email-address.antispamLearnMore' => 'スパムフィルタを学習させる方法の詳細は、こちらをご覧ください。',
    'email-address.antispamFilterScoreTitle' => 'フィルタ感度',
    'email-address.antispamFilterScoreHint' => 'スパムフィルタは、各メッセージのコンテンツと件名に対して複数のテストを実施します。その結果、各メッセージには複数のポイントが累積されます。ポイントが高いほど、メッセージがスパムである可能性が高くなります。デフォルトで、スコアが 7 ポイント以上のメッセージをスパムと分類するようにフィルタ感度が設定されています。現在の設定でスパムメッセージを大量に受信している場合、フィルタ値を小さくして（「6」など）フィルタ感度を上げます。必要なメールまで迷惑メールとして処理されている場合、フィルタ値を大きくして（「8」など）フィルタ感度を下げます。',
    'email-address.antispamFilterScore' => 'スパムフィルタの感度',
    'email-address.antispamWhiteListTitle' => 'ホワイトリスト',
    'email-address.antispamWhiteListHint' => 'ホワイトリストに含まれる送信者からのメールはチェックされません。',
    'email-address.antispamWhiteListField' => 'ホワイトリスト',
    'email-address.antispamWhiteListFieldHint' => 'ドメイン名を 1 行に 1 件ずつ入力してください。 アドレスにはワイルドカード（* および ?）を使用できます（例：*@domain.com, user?@*.com）。',
    'email-address.antispamBlackListTitle' => 'ブラックリスト',
    'email-address.antispamBlackListHint' => 'ブラックリストに含まれる送信者からのメールはスパムとして分類されます。',
    'email-address.antispamBlackListField' => 'ブラックリスト',
    'email-address.antispamBlackListFieldHint' => 'ドメイン名を 1 行に 1 件ずつ入力してください。 アドレスにはワイルドカード（* および ?）を使用できます（例：*@domain.com, user?@*.com）。',
    'email-address.antispamTrustedLanguagesTitle' => '信頼された言語',
    'email-address.antispamTrustedLanguagesHint' => 'これらの言語で書かれたメールメッセージは常にフィルタを通過します。',
    'email-address.antispamTrustedLocalesTitle' => '信頼できるロケール',
    'email-address.antispamTrustedLocalesHint' => '指定したロケールグループを使用するメールメッセージは常にフィルタを通過します。ロケールグループには、よく使用される文字セットが含まれます。例えば西洋（Western）文字セットには、英語と西ヨーロッパ言語で使用されるエンコーディングが含まれています。',
    'email-address.antispamTrustedNetworksTitle' => '信頼できるネットワーク',
    'email-address.antispamTrustedNetworksHint' => '信頼できるネットワークのリレーホストは、スパマが処理している可能性がなく、オープンリレーやオープンプロキシではないとみなされます。',
    'email-address.antispamIpAddressesField' => 'IP アドレス',
    'email-address.antispamIpAddressesFieldHint' => 'ネットワーク IP アドレスとマスクを指定してください。',
    'email-address.mailBoxQuotaDomainDefault' => 'デフォルトサイズ（%%domainMboxQuota%%）',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'デフォルトサイズ',
    'email-address.mailBoxOutgoingMessages' => '送信メールメッセージ数の上限',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'デフォルト（%%domainOutgoingMessages%% 通/時間）',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'メールボックスのカスタム値',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => '通',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'デフォルト',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'デフォルトサイズ',
    'email-address.mailBoxQuotaDomainSpecific' => '別のサイズ',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'メールボックスサイズ',
    'email-address.mailBoxQuotaUnlimited' => '無制限',
    'email-address.mailBoxLimitReached' => 'メールボックス数の上限に達しました。',
    'email-address.postboxEnabled' => 'メールボックス',
    'email-address.postboxEnabledYes' => 'オン',
    'email-address.postboxEnabledNo' => 'オフ',
    'email-address.description' => 'Plesk での説明',
    'email-address.descriptionHint' => 'この説明は、このメールアカウントにアクセスできるすべてのユーザに対して表示されます。',
    'email-address.longDescription' => '入力した説明が長すぎます。%%max%% 文字以内にしてください。',
    'email-address.loginAsUser' => 'Plesk へのログインに使用可能',
    'email-address.loginAsUserDescription' => '（ユーザ名：%%username%%）',
    'email-address.maxCustomSizeDesc' => 'メールボックスのサイズは、デフォルトサイズより大きくできません。',
    'email-address.endDateEnable' => '指定日に自動応答をオフにする',

    'failed-request.enable-tracing.description' => '失敗した要求のトレースはリソースを大量に消費します。トレースは %%days%% 日で自動的に停止します。いつでも手動で停止することができます。',
    'failed-request.enable-tracing.statusCodes' => 'ステータスコード',
    'failed-request.enable-tracing.statusCodesDescription' => '例：401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'プロバイダ',

    'file-manager.show.buttonReload' => '再読み込み',
    'file-manager.show.buttonSave' => '保存',
    'file-manager.show.buttonSaveAs' => '名前を付けて保存',
    'file-manager.show.buttonReset' => 'リセット',
    'file-manager.show.buttonTextCodeEditor' => 'コードエディタで編集',
    'file-manager.show.buttonTextEdit' => 'テキストエディタで編集',
    'file-manager.show.buttonWysiwygEdit' => 'HTML エディタで編集',
    'file-manager.show.eolLabel' => '改行タイプ：',
    'file-manager.show.saveAs' => '名前を付けて保存：',
    'file-manager.show.saveCodepage' => '次のエンコーディングで保存：',
    'file-manager.show.loadCodepage' => 'オリジナルファイルを次のエンコーディングで表示：',
    'file-manager.show.loadCodepageHint' => '警告：ファイルの再読み込みによって、未保存の変更がすべて失われます。',
    'file-manager.show.fileExists' => "ファイルまたはフォルダ %%fileName%% は既に存在します。同じ名前でフォルダとファイルを作成することはできません。",
    'file-manager.show.popupTitle' => '名前を付けて保存',
    'file-manager.show.popupFilename' => 'ファイル名：',

    'file-manager.permissions.filePermissions' => 'ファイルのパーミッション',
    'file-manager.permissions.directoryPermissions' => 'ディレクトリのパーミッション',
    'file-manager.permissions.buttonSubmit' => '保存',
    'file-manager.permissions.buttonApply' => '保存して再開',
    'file-manager.permissions.buttonCancel' => 'キャンセル',
    'file-manager.permissions.buttonAdvanced' => '詳細',

    'file-manager.unix-file-permissions.group' => 'グループ',
    'file-manager.unix-file-permissions.owner' => '所有者',
    'file-manager.unix-file-permissions.others' => 'その他',
    'file-manager.unix-file-permissions.readMode' => '読み取り',
    'file-manager.unix-file-permissions.writeMode' => '書き込み',
    'file-manager.unix-file-permissions.execMode' => '実行/検索',
    'file-manager.unix-file-permissions.changeRecursive' => 'パーミッションを再帰的に変更',

    'file-manager.windows-permissions.allow' => '許可',
    'file-manager.windows-permissions.deny' => '拒否',
    'file-manager.windows-permissions.inheritFromParent' => '親からこのオブジェクトおよびすべての子オブジェクトへの継承パーミッションのプロパゲーションを許可する。ここで明示的に定義したエントリも含む。',
    'file-manager.windows-permissions.replaceOnChildren' => 'すべての子オブジェクトのパーミッションエントリを、ここに表示されたエントリと置換する。',
    'file-manager.windows-permissions.buttonAdvanced' => '詳細',
    'file-manager.windows-permissions.applyTo' => '適用先：',
    'file-manager.windows-permissions.folderOnly' => 'このフォルダのみ',
    'file-manager.windows-permissions.subfolderOnly' => 'サブフォルダのみ',
    'file-manager.windows-permissions.filesOnly' => 'ファイルのみ',
    'file-manager.windows-permissions.permissionsFor' => 'パーミッション：',
    'file-manager.windows-permissions.applyOnto1' => 'このフォルダのみ',
    'file-manager.windows-permissions.applyOnto2' => 'サブフォルダのみ',
    'file-manager.windows-permissions.applyOnto3' => 'フォルダおよびサブフォルダ',
    'file-manager.windows-permissions.applyOnto4' => 'ファイルのみ',
    'file-manager.windows-permissions.applyOnto5' => 'このフォルダおよびファイル',
    'file-manager.windows-permissions.applyOnto6' => 'サブフォルダおよびファイルのみ',
    'file-manager.windows-permissions.applyOnto7' => 'このフォルダ、サブフォルダ、およびファイル',
    'file-manager.windows-permissions.notInherited' => '<継承されません>',

    'file-manager.editor.titleTextEditor' => 'テキストエディタ',
    'file-manager.editor.titleCodeEditor' => 'コードエディタ',
    'file-manager.editor.titleCodeViewer' => '表示',
    'file-manager.editor.buttonSubmit' => '保存',
    'file-manager.editor.buttonApply' => '保存して再開',
    'file-manager.editor.buttonSaveAs' => '名前を付けて保存 ...',
    'file-manager.editor.buttonCancel' => 'キャンセル',
    'file-manager.editor.exitConfirmationYes' => 'はい',
    'file-manager.editor.exitConfirmationNo' => 'いいえ',
    'file-manager.editor.fileOverwrite' => 'このファイルは既に存在します。',
    'file-manager.editor.fileOverwriteDescription' => 'この名前のファイルは既に存在します。上書きしますか？',
    'file-manager.editor.exitConfirmation' => 'ファイルを終了し、保存していない変更を破棄しますか？',
    'file-manager.editor.buttonCodeEditor' => 'コードエディタで編集',
    'file-manager.editor.buttonTextEditor' => 'テキストエディタで編集',
    'file-manager.editor.buttonHtmlEditor' => 'HTML エディタで編集',

    'file-manager.import-file.buttonSubmit' => 'インポート',
    'file-manager.import-file.fieldUrl' => 'ファイルの URL',
    'file-manager.import-file.fieldUrlDescription' => 'ソース URL（https://example.com/example.tgz など）を指定してください。',
    'file-manager.import-file.fieldUrlFullDescription' => '完全な URL のパターンは「https://user:password@example.com/example.tgz」です。ユーザ名とパスワードの指定は任意です。サポートされるプロトコルは http、https、ftp、ftps です。URL の一部に特殊文字やスペースが含まれる場合、URL エンコードを使用してください。',
    'file-manager.import-file.failure' => 'ファイルをインポートできません。',

    'file-manager.rotation-settings.title' => 'ごみ箱のローテーション設定',
    'file-manager.rotation-settings.rotationBySize' => 'サイズ基準のローテーション',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'The option deletes new files as long as the specified limit for the recycle bin is exceeded.',
    'file-manager.rotation-settings.rotationByDate' => '日付基準のローテーション',
    'file-manager.rotation-settings.rotationByDateUnits' => '日',
    'file-manager.rotation-settings.rotationByDateHint' => 'このオプションでは、ごみ箱に格納されたファイルが指定日数を経過すると削除します。',

    'ftp-user.description' => '自社のウェブサイトで他のユーザと共同作業したり、他のユーザにサブドメインをホスティングする場合、他のユーザのために個別の FTP アカウントを作成すると便利です。',
    'ftp-user.generalSection' => '全般',
    'ftp-user.login' => 'FTP アカウント名',
    'ftp-user.home' => 'ホームディレクトリ',
    'ftp-user.systemArea' => 'ホームディレクトリ外のファイルへのアクセス権のある FTP アカウントを作成',
    'ftp-user.password' => 'パスワード',
    'ftp-user.passwordConfirmation' => 'パスワードの確認',
    'ftp-user.hardQuotaSection' => 'ハードディスククォータ',
    'ftp-user.hardQuota' => 'ハードディスククォータ',
    'ftp-user.hardQuotaUnlimited' => '無制限',
    'ftp-user.permissionsSection' => 'パーミッション',
    'ftp-user.permissionRead' => '読み取りパーミッション',
    'ftp-user.permissionWrite' => '書き込みパーミッション',
    'ftp-user.popupTitle' => 'ディレクトリを選択',

    'mail-list.listName' => 'メーリングリストのアドレス',
    'mail-list.enabled' => 'オン',
    'mail-list.administratorEmail' => 'メーリングリスト管理者のメールアドレス',
    'mail-list.password' => 'パスワード',
    'mail-list.passwordConfirmation' => 'パスワードの確認',
    'mail-list.subscribers' => 'ML メンバー',
    'mail-list.subscribersHint' => 'メールアドレスを指定してください。複数のアドレスを入力する場合は、改行、スペース、コンマ、またはセミコロンで区切ります。',
    'mail-list.notify' => 'メーリングリストの作成を管理者に通知する',
    'mail-list.emptyPassword' => 'パスワードを入力してください。',
    'mail-list.emptyPasswordConfirmation' => 'パスワードを確認してください。',
    'mail-list.errorSubscribers' => 'メールアドレスが無効です。%value%。',
    'mail-list.errorMaillistReserved' => '入力したメーリングリストは既に使用されています。',

    'mail-settings.hint' => 'このドメインのメールサービス設定を変更することができます。',
    'mail-settings.service' => 'このドメインでメールサービスをアクティブ化',
    'mail-settings.nonExist' => '存在しないユーザへのメールの処理方法',
    'mail-settings.nonExistBounceWithMessage' => 'メッセージ付きでバウンス',
    'mail-settings.nonExistBounce' => 'バウンス',
    'mail-settings.nonExistCatch' => '指定アドレスに転送',
    'mail-settings.nonExistCatchDescription' => 'アドレスは、選択したドメインに属している必要があります。外部アドレスを指定したり、複数ドメインに 1 つのアドレスを指定できるのは、管理者のみです。',
    'mail-settings.nonExistExternal' => '指定 IP アドレスの外部メールサーバへリダイレクト',
    'mail-settings.nonExistReject' => '拒否',
    'mail-settings.nonExistDiscard' => '拒否',
    'mail-settings.webmail' => 'ウェブメール',
    'mail-settings.webmailNone' => 'なし',
    'mail-settings.webmailComponentNotInstalled' => 'ウェブメールコンポーネントがインストールされていません。',
    'mail-settings.webmailSubdomainAlreadyExists' => '%%subdomain%% という名前のサブドメインがあります。',
    'mail-settings.webmailCertificate' => 'ウェブメール用の SSL/TLS 証明書',
    'mail-settings.webmailCertificateNone' => '未選択',
    'mail-settings.mailCertificate' => 'メール用の SSL/TLS 証明書',
    'mail-settings.mailCertificateNone' => '未選択',
    'mail-settings.serverCertificateNotSelected' => '証明書が割り当てられましたが、ドメインのメールが保護されていません。ドメインのメールのセキュリティを強化するには、%%certLink%%してください。',
    'mail-settings.serverCertificatesList' => 'メールサーバをセキュリティ強化',
    'mail-settings.mailLists' => 'メーリングリストを有効化',
    'mail-settings.mailAutodiscovery' => 'メール自動検出を有効にする',
    'mail-settings.mailAutodiscoveryDescription' => '%%link%%で仕組みを確認',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'ナレッジベース',
    'mail-settings.domainKeys' => '送信メールメッセージに電子署名するために DKIM スパム防御システムを使用',
    'mail-settings.greyListing' => 'このドメイン下の全メールアカウントに対し、グレイリストスパム防御をオンにする',
    'mail-settings.howToConfigureExternalDns' => '外部 DNS の構成方法',
    'mail-settings.howToConfigureExternalDnsAlways' => '外部 DNS サーバを使用する場合に DKIM 署名を有効にするには、ご自分で DNS サーバで DKIM DNS レコードを構成する必要があります。',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'それには、以下の DKIM DNS レコードを使用してください。',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'メールの送信に使用するドメインエイリアスがある場合、それにも DKIM DNS レコードを追加してください。ドメインエイリアス名で、メインドメイン用と同じレコードを使用してください。',
    'mail-settings.howToConfigureExternalDnsDisabled' => '構成する必要がある DKIM DNS レコードを表示するには、［%%option%%］チェックボックスをオンにして適用し、このポップアップをもう一度開いてください。',

    'role.roleSection' => '全般',
    'role.name' => 'ユーザ役割名',
    'role.description' => '説明',
    'role.generalPermissionsSection' => 'Plesk サービスへのアクセス',
    'role.applicationsAccessSection' => 'アプリケーションへのアクセス',
    'role.permissionAllow' => '許可',
    'role.permissionDeny' => '拒否',
    'role.emptyRoleName' => '役割名を入力してください。',
    'role.installedAt' => 'インストール場所',
    'role.noInstallationUrlAvailable' => '外部アプリケーション',
    'role.invalidRoleName' => '入力したユーザ役割名が無効です。 疑問符と引用符を役割名に使用することはできません。',
    'role.longRoleName' => '入力したユーザ役割名が長すぎます。',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => '一部の処理を実行できません。現在選択している契約にこれらの処理を行うパーミッションが付与されていないか、これらの処理に必要な量のリソースが割り当てられていません。',
    'role.servicesPermissionsDescription' => 'この役割を持つすべてのユーザ用に、インストール済みアプリケーションまたは Plesk サービスへのアクセスを定義します。アプリケーションへのアクセス権をユーザに付与すると、このユーザは顧客パネルからこのアプリケーションを使用できるようになります。',
    'role.emailActivation' => 'この役割のアカウントをメールでアクティブ化',

    'service.admin-access.adminAccess' => '管理者アクセス',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'これらのクレデンシャルは、このアプリケーションに管理者としてアクセスするために使用されます。',
    'service.admin-access.login' => '管理ユーザ名',
    'service.admin-access.password' => '管理パスワード',
    'service.admin-access.passwordConfirmation' => 'パスワードの確認',

    'service.info.service-entry-point.availableAt' => '使用可能',
    'service.info.service-entry-point.customize' => 'ショートカットのカスタマイズ',
    'service.info.service-entry-point.displayNameLabel' => 'ショートカット名',
    'service.info.service-entry-point.displayNameDescription' => 'このショートカットの名前を入力してください。 この名前はショートカットアイコンの下に表¥示されます。 ショートカットは、このアプリケーションへのアクセスが許可されているユーザの［マイ・サービス］ページに配置されます　　　',
    'service.info.service-entry-point.descriptionLabel' => 'ショートカットの説明',
    'service.info.service-entry-point.descriptionDescription' => 'このショートカットの説明を入力してください。 ショートカットの上でマウスを動かすと、この説明がツールチップとして表示されます。',
    'service.info.service-entry-point.iconLabel' => 'ショートカットのアイコンを選択します。',
    'service.info.service-entry-point.iconCurrent' => '現在のアイコン',
    'service.info.service-entry-point.errorEmptyName' => 'ショートカット名を入力してください',
    'service.info.service-entry-point.errorLongName' => 'ショットカット名は半角 1 文字から 255 文字の間でなければいけません',
    'service.info.service-entry-point.errorLongDescription' => 'ショットカットの説明は半角 1 文字から 255 文字の間でなければいけません',
    'service.info.service-entry-point.hiddenLabel' => 'ショートカットの非表示',
    'service.info.service-entry-point.hiddenDescription' => 'このショートカットをユーザに表示しません',

    'service.info.service-permission.assignedUser' => "このユーザに管理者アクセスを付与する",
    'service.info.service-permission.assignedUserNone' => 'ユーザが割り当てられていません',

    'shared-ssl.master-ssl.switchedOn' => '共用 SSL/TLS をオンにする',
    'shared-ssl.master-ssl.domainName' => 'SSL/TLS 証明書を他のサイトと共有するサイトのドメイン名',
    'shared-ssl.master-ssl.none' => 'なし',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'SSL/TLS サポートが有効になっているドメインがないため、共用 SSL/TLS をオンにできません。',

    'user.email.email' => 'メールアドレス',
    'user.email.emptyEmail' => 'メールアドレスを入力してください。',
    'user.email.internalEmailHint' => 'Plesk で新しいメールアドレスを作成するか、外部のメールアドレスを使用します。',
    'user.email.longInternalEmail' => 'メールアドレスが長すぎます。',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'このメールサーバに対して、メールアドレスのユーザ名部分が長すぎます。%%max%% 文字以内のユーザ名を指定してください。',
    'user.email.longInternalEmailFullAddressMailServer' => 'このメールサーバに対してメールアドレスが長すぎます。%%max%% 文字以内のアドレスを指定してください。',
    'user.email.externalEmail' => '外部のメールアドレス',
    'user.email.externalEmailHint' => 'メインのメールアドレスにアクセスできなくなった場合に、パスワードのリセットに使用されます。',
    'user.email.emailsIsEqual' => '外部のメールアドレスがメインのメールアドレスと同じです。外部のメールアドレスに別のアドレスを指定してください。',

    'user.profileSection' => '一般情報',
    'user.contactName' => '担当者名',
    'user.email' => 'メールアドレス',
    'user.role' => 'ユーザ役割',
    'user.accountSection' => 'Plesk プリファレンス',
    'user.login' => 'ユーザ名',
    'user.password' => 'パスワード',
    'user.buttonBack' => '戻る',
    'user.generalTab' => '全般',
    'user.applicationsAccessSection' => 'サービス',
    'user.generalPermissionsSection' => '権限',
    'user.contactsTab' => '連絡先の詳細',
    'user.passwordConfirmation' => 'パスワードの確認',
    'user.internalEmailPasswordChanged' => 'パスワードを変更すると、内部メールアドレスのパスワードも変更されます。',
    'user.emailName' => 'メールアドレス',
    'user.emailType' => 'メールタイプ',
    'user.companyName' => '会社名',
    'user.phone' => '電話番号',
    'user.imNumber' => 'インスタントメッセンジャー',
    'user.fax' => 'ファックス番号',
    'user.address' => '住所',
    'user.city' => '市区町村',
    'user.state' => '都道府県',
    'user.zip' => '郵便番号',
    'user.country' => '国',
    'user.additionalInfo' => '追加情報',
    'user.additionalInfoHint' => 'テキスト形式：HTML タグはすべて無視されます。',
    'user.language' => 'Plesk 言語',
    'user.buttonChangePassword' => 'パスワード変更',
    'user.permissionAllow' => '許可',
    'user.permissionDeny' => '拒否',
    'user.permissionInherited' => '役割で却下',
    'user.emptyContactName' => '担当者の名前を入力してください。',
    'user.emptyLogin' => 'ユーザ名を入力してください。',
    'user.emptyPassword' => 'パスワードを入力してください。',
    'user.emptyPasswordConfirmation' => '確認のためパスワードをもう一度入力してください',
    'user.chooseDomainBoxTitle' => '別のドメインを選択：',
    'user.userIsActive' => 'アクティブなユーザ',
    'user.userIsActiveHint' => 'アクティブなユーザは Plesk にアクセスできます。',
    'user.emailActivation' => 'アカウントをメールでアクティブ化',
    'user.emailHint' => 'このサーバでホスティングされるメールアドレスをユーザに指定する場合、指定したメールアドレスを［メール］タブで作成し、このユーザに関連付けてください。',
    'user.emailContactHint' => 'このサーバでホスティングされるメールアドレスを使用する場合は、サービスプロバイダに連絡してください。',
    'user.personalEmailHint' => "このユーザのメールアドレスは［メール］タブで変更できます。",
    'user.externalMailRedirectHint' => '転送をアクティブ化できるのは、このサーバでホスティングされているメールアドレスに対してのみです。メールアドレスは［メール］タブで作成します。',
    'user.externalMailRedirectHint2' => '転送をアクティブ化できるのは、このサーバでホスティングされているメールアドレスに対してのみです。',
    'user.externalMailAutoResponderHint' => '自動応答をアクティブ化できるのは、このサーバでホスティングされているメールアドレスに対してのみです。メールアドレスは［メール］タブで作成します。',
    'user.externalMailAutoResponderHint2' => '自動応答をアクティブ化できるのは、このサーバでホスティングされているメールアドレスに対してのみです。',
    'user.roleHint' => 'ユーザに特定のユーザ役割を付与すると、この役割に設定されている管理権限とアプリケーションアクセス権がユーザに付与されます。',
    'user.cannotManageMail' => "メール設定とサービスを管理するパーミッションがありません",
    'user.longCompanyName' => '入力した会社名が長すぎます。',
    'user.longPhone' => '入力した電話番号が長すぎます。',
    'user.longFax' => '入力したファックス番号が長すぎます。',
    'user.longAddress' => '入力したアドレスが長すぎます。',
    'user.longCity' => '入力した市区町村名が長すぎます。',
    'user.phoneRegexNotMatch' => '入力した電話番号は無効です。',
    'user.faxRegexNotMatch' => '入力したファックス番号が無効です。',
    'user.shortCity' => '指定した市区町村名が短すぎます。',
    'user.limitSubscription' => '契約へのアクセス',
    'user.limitSubscriptionHint' => 'ユーザのアクセスを許可する契約を指定します。「すべて」を選択すると、ユーザはホスティングアカウント内のすべての契約にアクセスできるようになります。',
    'user.limitSubscriptionAll' => 'すべて',
    'user.deletedSubscription' => '削除済みの契約',

    'web.add-domain-alias.title' => 'ドメインエイリアスを追加',
    'web.add-domain-alias.createdSuccessfully' => "ドメインエイリアス %%name%% が作成されました。",
    'web.add-domain-alias.domainAliasName' => 'ドメインエイリアス名',
    'web.add-domain-alias.domainAliasNameHint' => '例えば example.net',
    'web.add-domain-alias.forDomain' => '対象ドメイン',
    'web.add-domain-alias.settingsSectionLegend' => '設定',
    'web.add-domain-alias.settingsDns' => 'プライマリドメインと DNS ゾーンを同期',
    'web.add-domain-alias.settingsMail' => 'メールサービス',
    'web.add-domain-alias.settingsWeb' => 'ウェブサービス',
    'web.add-domain-alias.settingsSeoRedirect' => 'HTTP 301 コードでリダイレクト',
    'web.add-domain-alias.settingsSeoRedirectHint' => '訪問者がエイリアスの URL を開くと、プライマリドメインの URL にリダイレクトされます。Plesk は検索エンジンフレンドリーな HTTP 301 リダイレクトを使用します。つまり、検索エンジンランキングではリダイレクト元 URL とリダイレクト先 URL が区別されません。',
    'web.add-domain-alias.settingsTomcat' => 'Java ウェブアプリケーション',
    'web.add-domain-alias.invalidDomainGuid' => '無効なドメイン',

    'web.add-domain.formTitle' => '新規ドメインの追加',
    'web.add-domain.formRegistrationHint' => '%%link%%で新しいドメイン名を登録できます。',
    'web.add-domain.portalLink' => 'サービスポータル',
    'web.add-domain.domainName' => 'ドメイン名',
    'web.add-domain.domainNameHint' => "例えば example.com",
    'web.add-domain.assignToCustomer' => 'このドメインを顧客に割り当てる',
    'web.add-domain.customer' => '顧客を選択',
    'web.add-domain.createNewCustomer' => '新規顧客を作成',
    'web.add-domain.selectExistingCustomer' => '既存の顧客を選択：',
    'web.add-domain.customerContactInfoHint' => '顧客の連絡先情報を入力します。後で、電話番号や住所などその他すべての情報を指定することができます。',
    'web.add-domain.customerLoginInfoHint' => '顧客パネルのクレデンシャル',
    'web.add-domain.target' => 'ウェブスペース',
    'web.add-domain.createNewTarget' => '新規契約を作成',
    'web.add-domain.createNewTarget_powerUser' => '新規ウェブスペースを作成',
    'web.add-domain.selectExistingTarget' => '既存の契約を選択：',
    'web.add-domain.selectExistingTarget_powerUser' => '既存のウェブスペースを選択：',
    'web.add-domain.dns' => 'DNS サービスをアクティブ化',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'メールサービスをアクティブ化',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => '契約の設定で、ドメインごとのメールパーミッションの管理が許可されている場合に機能します。許可しないと、実際のメールサービスのステータスは契約から取得されます。',
    'web.add-domain.hostingManagementOptions' => 'ホスティングタイプ',
    'web.add-domain.websiteHosting' => 'ウェブサイトホスティング',
    'web.add-domain.websiteForwarding' => '転送',
    'web.add-domain.websiteNoHosting' => 'ホスティングなし',
    'web.add-domain.hostingSettingsSectionLegend' => 'ホスティング設定',
    'web.add-domain.domainCreatedSuccessfully' => 'ドメイン %%domainName%% を作成しました',
    'web.add-domain.webspaceLegend' => 'ウェブスペース設定',
    'web.add-domain.addWhmWebsiteTitle' => '新規ウェブサイトの追加',
    'web.add-domain.addWhmWebsiteHint' => "サーバでウェブサイトをホストすることを選択できます。",
    'web.add-domain.selectWhmDomain' => 'ドメインを選択',
    'web.add-domain.customerLegend' => '顧客情報',
    'web.add-domain.credentials' => 'システムユーザのクレデンシャル',
    'web.add-domain.credentialsHint' => 'ホストされているファイルに FTP または SSH 経由でアクセスするために使用されます',
    'web.add-domain.credentialsHintWin' => 'ホストされているファイルに FTP または RDP 経由でアクセスするために使用されます',
    'web.add-domain.buttonAddDomain' => 'ドメインを追加',

    'web.add-subdomain.formTitle' => 'サブドメインを追加',
    'web.add-subdomain.formGeneralHint' => 'サブドメインは、ウェブサイトの別のセクション用のインターネットアドレスです。 メインドメイン名とプレフィックスを使用します。 例えば、ドメインが domain.com の場合、サブドメインは store.domain.com 等になります。',
    'web.add-subdomain.formGeneralHintAdditional' => 'また、名前の代わりに「*」記号を入力して、ワイルドカードサブドメインを作成することもできます。サイト訪問者は、ブラウザにどのようなサブドメイン名を入力しても、このサブドメインにリダイレクトされます。',
    'web.add-subdomain.subdomainName' => 'サブドメイン名',
    'web.add-subdomain.subdomainNameHint' => 'ワイルドカードサブドメインを作成するには「*」と入力してください。',
    'web.add-subdomain.forDomain' => '親ドメイン',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'サブドメインを作成しました',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'ホスティング設定',

    'web.change-hosting.formGeneralHint' => 'このサーバでウェブサイトをホスティングするか（ウェブサイトホスティング）、別のサイトへのウェブ転送をセットアップするか（転送）、このドメイン名でメールボックスを持つためにドメイン DNS ゾーンを使用するか（ホスティングなし）を選択できます。',
    'web.change-hosting.changed' => '%%domainName%% のホスティングタイプが正常に変更されました。',
    'web.change-hosting.hostingManagementOptions' => 'ホスティングタイプ',
    'web.change-hosting.websiteHosting' => 'ウェブサイトホスティング',
    'web.change-hosting.websiteForwarding' => '転送',
    'web.change-hosting.websiteNoHosting' => 'ウェブホスティングなし',
    'web.change-hosting.hostingSettingsSectionLegend' => 'ホスティング設定',
    'web.change-hosting.userName' => 'ユーザ名',
    'web.change-hosting.userNameHint' => '契約内のファイルとフォルダを管理するためのシステムユーザ',
    'web.change-hosting.userNameHint_powerUser' => 'ウェブスペース内のファイルとフォルダを管理するためのシステムユーザ',
    'web.change-hosting.emptyLogin' => 'ユーザ名を入力してください。',
    'web.change-hosting.password' => 'パスワード',
    'web.change-hosting.emptyPassword' => 'パスワードを入力してください。',
    'web.change-hosting.passwordConfirmation' => 'パスワードの確認',
    'web.change-hosting.warningInstalledApplications' => 'サイトにウェブサプリケーションがインストールされています。ホスティングタイプを変更すると、アクセスできなくなります。',
    'web.change-hosting.removeWebsiteHostingTitle' => '警告：ウェブサイトのコンテンツが削除されます。',
    'web.change-hosting.removeWebsiteHostingDescription' => 'ウェブサイトのホスティングタイプを変更しますか？',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => '以下のフォルダとその内容がすべて削除されます：',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'ウェブスペースのルートフォルダの内容がすべて削除されます。',

    'web.change-status.changed' => '%%domainName%% のウェブサイトステータスが正常に変更されました。',
    'web.change-status.statusManagementOptions' => 'ウェブサイトのステータス',
    'web.change-status.statusDisabled' => '無効（従来の「一時停止」）',
    'web.change-status.statusSuspended' => '一時停止',
    'web.change-status.statusActive' => 'アクティブ',
    'web.change-status.statusDisabledHint' => '今後、このウェブサイトはこのサーバ上でホスティングされなくなり、FTP クライアントとファイルマネージャ以外では使用不可になります。訪問者にはウェブサーバのデフォルトページが表示されます。メールサービスは使用できなくなります。',
    'web.change-status.statusSuspendedHint' => 'このウェブサイトはサーバ上に残されますが、サイト訪問者は、HTTP コード 503 でカスタムエラードキュメントページにリダイレクトされます。このメールサービスは今後も使用できます。ここで%%link%%できます。',
    'web.change-status.statusSuspendedHintNoLink' => '訪問者は、検索エンジンフレンドリーな HTTP コード 503 でカスタムエラードキュメントページにリダイレクトされますが、ウェブサイトはサーバ上に残されます。このメールサービスは今後も使用できます。',
    'web.change-status.error503PageLink' => 'カスタムエラードキュメントを編集',
    'web.change-status.statusActiveHint' => 'ウェブサイトは通常どおりに機能します。',
    'web.change-status.notActivatedSuspended' => 'ドメインまたはウェブサイト %%domainName%% はホスティング事業者によって一時停止されており、アクティブ化できません。',
    'web.change-status.notActivatedDisabled' => 'ドメインまたはウェブサイト %%domainName%% はホスティング事業者によって無効化されており、アクティブ化できません。',

    'web.edit.formTitle' => '%%name%% のウェブホスティングアクセス',
    'web.edit.formGeneralHint' => '契約に関連付けられた IP アドレスを参照したり、システムユーザアカウントのユーザ名とパスワードを変更できます。',
    'web.edit.formGeneralHint_powerUser' => 'ウェブスペースに関連付けられた IP アドレスを参照したり、システムユーザアカウントのユーザ名とパスワードを変更できます。',
    'web.edit.ipAddressesLegend' => 'IP アドレス',
    'web.edit.ipAddresses' => 'IP アドレス',
    'web.edit.certificateLegend' => '証明書',
    'web.edit.certificateFromDomainRepository' => '%%name%%（%%repositoryName%%）',
    'web.edit.certificateFromOtherRepository' => '%%name%% （別のユーザが所有）',
    'web.edit.userAccountLegend' => 'システムユーザ',
    'web.edit.systemUserHint' => 'FTP またはファイルマネージャを使用して契約内のファイルとフォルダを管理するためのシステムユーザを指定します。このシステムユーザは、SSH 経由（Linux）または RDP 経由（Windows）で Plesk にアクセスする際にも使用されます（必要なパーミッションが付与されている必要があります）。',
    'web.edit.systemUserHint_powerUser' => 'FTP またはファイルマネージャによってウェブスペース内のファイルとフォルダを管理するためのシステムユーザを指定します。このシステムユーザは、SSH 経由（Linux）または RDP 経由（Windows）で Plesk にアクセスする際にも使用されます（必要なパーミッションが付与されている必要があります）。',
    'web.edit.login' => 'ユーザ名',
    'web.edit.emptyLogin' => 'ユーザ名を入力してください。',
    'web.edit.password' => 'パスワード',
    'web.edit.passwordConfirmation' => 'パスワードの確認',
    'web.edit.emptyPassword' => 'パスワードを入力してください。',
    'web.edit.emptyPasswordConfirmation' => '確認のためもう一度パスワードを入力してください。',
    'web.edit.shellUnix' => "SSH 経由のサーバアクセス",
    'web.edit.shellHintUnix' => "システムユーザのクレデンシャルを使用して SSH 経由でサーバにアクセスします。",
    'web.edit.shellWin' => 'リモートデスクトップ経由でサーバにアクセス',
    'web.edit.shellHintWin' => "システムユーザのクレデンシャルを使用してリモートデスクトップ経由でサーバにアクセスします。",
    'web.edit.diskQuotaLegend' => 'ディスクスペースのハードクォータ',
    'web.edit.diskQuotaHint' => 'ディスクスペースのハードクォータとは、使用可能なディスクスペースの上限です。ハードクォータが設定されている場合、割り当てられたディスクスペースを使い切ると、ファイル操作ができなくなります。',
    'web.edit.diskQuota' => 'ディスクスペースのハードクォータ',
    'web.edit.diskQuotaUnlimited' => '無制限',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => '無制限。 ハードディスククォータはサーバファイルシステムの設定によりサポートされていません。',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'ホスティング設定が更新されました。',
    'web.edit.affectedDomainsLegend' => 'これらの設定を適用するウェブサイト',
    'web.edit.affectedDomainsHint' => '以下のウェブサイトが現在のシステムユーザと紐付けられています。このページでウェブホスティングアクセス設定を変更すると、これらすべてのウェブサイトに適用されます。',

    'web.mobile.create.formTitle' => 'モバイルサイトを作成',
    'web.mobile.create.formGeneralHint' => 'モバイルサイト名（モバイルサイトにアクセスする URL）を入力してください。 通常は、m、mob、mobi、mobile などのプレフィックスを使用します（例: mobile.example.com）。 これで、この URL を、レギュラーサイトの「モバイルバージョン」などのリンクに使用できるようになり、サイト訪問者はモバイルバージョンとレギュラーバージョンを切り替えることができます。',
    'web.mobile.create.prefix' => 'サイト名',
    'web.mobile.create.emptySiteName' => 'モバイルサイト名を、レギュラーウェブサイトと区別するため入力してください',

    'web.security-section.securitySectionLegend' => 'セキュリティ',
    'web.security-section.securitySectionHint' => 'サイトへのトランザクションをセキュリティ強化するには、SSL/TLS プロトコルを使用します。すべてのデータが暗号化され、セキュア接続経由で送信されます。SSL/TLS を導入するには、このサイトを専用 IP アドレスに移し、サイトに SSL/TLS 証明書をインストールして、以下でこの証明書を選択してください。',
    'web.security-section.securitySectionSniHint' => 'サイトへのトランザクションをセキュリティ強化するには、SSL/TLS プロトコルを使用します。すべてのデータが暗号化され、セキュア接続経由で送信されます。SSL/TLS を導入するには、サイトに SSL/TLS 証明書をインストールし、以下でこの証明書を選択してください。',
    'web.security-section.enableSslSupport' => 'SSL/TLS サポート',
    'web.security-section.enableSslRedirect' => 'SEO に対応する HTTP から HTTPS への恒久的 301 リダイレクト',

    'web.seo-settings.seoRedirectDirection' => '優先ドメイン',
    'web.seo-settings.seoRedirectDirectionHint' => 'SEO に対応する HTTP 301 リダイレクトによってサイト訪問者をリダイレクトする URL（www. プレフィックスあり/なし）を選択します。',
    'web.seo-settings.seoRedirectDirectionNone' => 'なし',

    'web.settings.formGeneralHint' => 'ウェブサイトホスティングの設定を行い、サイトで使用可能な機能を選択します。',
    'web.settings.hostingType' => 'ホスティングタイプ',
    'web.settings.websiteHosting' => 'ウェブサイト',
    'web.settings.forwardingHosting' => '転送',
    'web.settings.noHosting' => 'ホスティングなし',
    'web.settings.changeHosting' => '変更',
    'web.settings.websiteStatus' => 'ウェブサイトのステータス',
    'web.settings.changeStatus' => '変更',
    'web.settings.active' => 'アクティブ',
    'web.settings.suspended' => '一時停止',
    'web.settings.disabled' => '無効',
    'web.settings.webScriptingSectionLegend' => 'ウェブスクリプティングと統計',
    'web.settings.webScriptingSectionHint' => 'ウェブサーバで以下のどのプログラミング言語またはスクリプティング言語を割り込み、実行、または処理するのかを指定します。',
    'web.settings.__asp_win_support' => 'Microsoft ASP サポート',
    'web.settings.__asp_dot_net_support' => 'Microsoft ASP.NET サポート',
    'web.settings.__asp_dot_net_version' => 'バージョン',
    'web.settings.__asp_dot_net_version_readonly' => 'バージョン %%value%%',
    'web.settings.__ssi_support' => 'SSI サポート',
    'web.settings.__ssi_with_html' => '*.htm と *.html ファイルに SSI を使用',
    'web.settings.__php_support' => 'PHP サポート',
    'web.settings.__php_run_as' => 'PHP の実行タイプ',
    'web.settings.__php_served_by_apache' => '＋Apache',
    'web.settings.__php_served_by_nginx' => '＋nginx',
    'web.settings.__cgi_support' => 'CGI サポート',
    'web.settings.__cgi_bin_mode' => 'cgi-bin ディレクトリの場所：',
    'web.settings.__cgi_bin_mode_webspace' => 'ウェブスペースのルートディレクトリ',
    'web.settings.__cgi_bin_mode_www_root' => 'このドメインのドキュメントルート',
    'web.settings.__cgi_bin_mode_old_style' => 'このドメインの旧スタイルのルート',
    'web.settings.__cgi_bin_mode_readonly' => 'cgi-bin ディレクトリの場所：%%value%%',
    'web.settings.__perl_unix_support' => 'Perl サポート',
    'web.settings.__perl_win_support' => 'Perl サポート',
    'web.settings.__python_unix_support' => 'Python サポート',
    'web.settings.__python_win_support' => 'Python サポート',
    'web.settings.__fastcgi_unix_support' => 'FastCGI サポート',
    'web.settings.__webstat_support' => 'ウェブ統計',
    'web.settings.__plesk_stat_protect' => 'ウェブ統計へのアクセスを FTP ユーザ名とパスワードで保護する',
    'web.settings.__plesk_stat_protected' => 'ウェブ統計へのアクセスは FTP ユーザ名とパスワードで保護されています',
    'web.settings.__apache_errdocs' => 'カスタムエラードキュメント',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'FastCGI アプリケーション',
    'web.settings.__php_cgi_handler' => 'CGI アプリケーション',
    'web.settings.__php_isapi_handler' => 'ISAPI エクステンション',
    'web.settings.__php_version' => 'PHP バージョン',
    'web.settings.__hosting_write_modify' => '追加の書込/変更パーミッション',
    'web.settings.__hosting_webdeploy' => 'Web Deploy パブリッシング',
    'web.settings.awstats' => 'AWstats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'なし',
    'web.settings.activate' => 'アクティブ化',
    'web.settings.deactivate' => '一時停止',
    'web.settings.__php_support_readonly' => 'バージョン： %%version%%、ハンドラ： %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => '未登録',
    'web.settings.domainName' => 'ドメイン名',
    'web.settings.domainNameHint' => "例えば example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'レガシーオプション「SSL/TLS コンテンツと非 SSL/TLS コンテンツを分ける」用の互換モード',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'レガシーオプション「SSL コンテンツと非 SSL コンテンツを分ける」用に互換モードでウェブサイトを実行する',
    'web.settings.sameSslCompatibilityHint' => 'このセクションが表示されているのは、お客様がアップグレード前に「SSL/TLS コンテンツと非 SSL/TLS コンテンツを分ける」オプションを使用されていたためです。Plesk 11 ではこのオプションは廃止されています。Plesk 11 で作成されたすべてのウェブサイトは、HTTP 経由/HTTPS 経由でアクセスできるコンテンツを、同じディレクトリを使用して保存します。つまり、このサイトは引き続き互換モードで動作しますが、Plesk で管理することはできません。すべてのデータを httpsdocs/ ディレクトリから httpdocs/ ディレクトリに移動してから互換モードをオフにすることをお勧めします。互換モードをオフにすると、再びオンにすることはできず、このセクションは二度と表示されなくなります。互換モードがオンの状態で httpsdocs/ ディレクトリにアプリケーションをインストールすると、このアプリケーションはインターネット経由でアクセスできなくなります。httpsdocs/ ディレクトリにアプリケーションをインストールする場合は、互換モードをオフにしてください。',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'ウェブサイト設定は %%restartInterval%% 分以内に適用されます。',
    'web.settings.phpSettingsDescription' => 'このページには、ウェブサイトの PHP 構成が表示されます。これらの設定はウェブサイトに固有であり、契約の他のウェブサイトには影響を与えません。ホスティング事業者から該当するパーミッションが付与されていれば、PHP 構成を変更することができます。カスタム PHP 構成を使用することによって、PHP スクリプトによるシステムリソースの消費を抑えたり、特定のウェブアプリケーションの要件に対応することなどができます。パラメータの値をデフォルトに設定すると、PHP はサーバ全体の PHP 構成からパラメータ値を使用します。',
    'web.settings.phpSettingsAvailableVariables' => 'パラメータ値には以下のプレースホルダを使用できます。',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT}： ウェブサイトのドキュメントルートディレクトリ。現在の値は %%DOCROOT%% です。%%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'HTTPS ドキュメントルートディレクトリは http と同じです。',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'HTTPS ドキュメントルートディレクトリは %%DOCROOT%% です。',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT}： 契約のプライマリウェブサイトのドキュメントルートディレクトリ。',
    'web.settings.phpSettingsVariableTmp' => '{TMP}： 一時ファイルを保存するディレクトリ。',
    'web.settings.phpSettingsPhpVersion' => 'ご使用の PHP バージョンは %%version%% です。',
    'web.settings.phpSettingsPhpDisabled' => 'PHP はオフになっています。',
    'web.settings.phpHandlerTypeHint' => 'PHP ハンドラタイプを変更すると、このウェブサイト上の既存の PHP スクリプトの機能に障害が発生する可能性があります。',
    'web.settings.fpmDedicatedHandlerHint' => 'このハンドラを使用すると、ウェブサイトの安定性は向上しますが、メモリ消費量も増加します。',
    'web.settings.phpHandlerChangeHint' => 'PHP ハンドラの設定を変更しました。これらの変更を保存すると、サーバの構成のために、ウェブサイトの PHP スクリプトが %%interval%% 秒間停止する可能性があります。',
    'web.settings.phpHandlerTypeHelpLink' => '最も適切な PHP 設定を選択する方法について',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'PHP サポートは有効にできません。現在のホスティング構成に、このドメインで使用できる PHP が含まれていません。',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => '他の PHP バージョンを有効にする方法を確認してください。',
    'web.settings.phpHandlerBroken' => '現在選択されている PHP ハンドラが破損しています。別のハンドラを選択してください。',
    'web.settings.phpHandlerOutdated' => '（サポート終了）',
    'web.settings.phpHandlerDeprecated' => '（非推奨）',

    'web.setupService.formTitle' => 'セットアップサービス：%%serviceReference%%',
    'web.setupService.successfullyUpdated' => '「%%serviceReference%%」サービスが正常に更新されました。',

    'web.site-copy.subdomainsGroup' => '%%siteName%% サブドメイン：',
    'web.site-copy.destinationTypeSection' => 'コピー先',
    'web.site-copy.destinationType' => 'サイトファイルのコピー先を選択します。',
    'web.site-copy.destinationTypeSite' => 'Plesk 内のウェブサイト',
    'web.site-copy.destinationTypeSiteDescription' => 'このアカウントでホスティングしている別のサイトにサイトファイルをコピーします。 このサーバ上の他のアカウントへの FTP アクセスが可能である場合、［FTP ストレージ］オプションを使用してください。',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'このサーバ上でホスティングされている他のサイトにサイトファイルをコピーします。',
    'web.site-copy.destinationTypeSiteSelect' => 'サイト名',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "サイト %%source%% のファイルを %%destination%% にコピーできません。この理由は、%%destination%% がこれらのファイルの一部でもあるためです。つまり、ドキュメントルートが %%source%% ドキュメントルートのサブディレクトリとなっています。",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "サイト %%destination%% のファイルを削除できません。この理由は、%%source%% ファイルがこれらのファイルの一部であるためです。つまり、%%source%% ドキュメントルートは %%destination%% のサブディレクトリです。",
    'web.site-copy.destinationTypeFtp' => 'FTP ストレージ',
    'web.site-copy.destinationTypeFtpDescription' => 'このサーバまたは外部サーバ上の FTP アカウントにウェブサイトファイルをコピーします。',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => '外部サーバ上の FTP アカウントにウェブサイトファイルをコピーします。',
    'web.site-copy.destinationTypeFtpHost' => "サーバホスト名",
    'web.site-copy.destinationTypeFtpPort' => "ポート",
    'web.site-copy.destinationTypeFtpFolder' => 'ディレクトリ',
    'web.site-copy.destinationTypeFtpUser' => 'ユーザ名',
    'web.site-copy.destinationTypeFtpPassword' => 'パスワード',
    'web.site-copy.destinationTypeFtpMode' => 'FTP 接続方法',
    'web.site-copy.destinationTypeFtpModeActive' => 'アクティブモード',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'アクティブモードでは、Plesk は listen する IP アドレスとポート番号を外部サーバに送信し、そのサーバが TCP 接続を開始します。Plesk で管理するサーバがファイアウォールで保護されていない場合、このモードを推奨します。',
    'web.site-copy.destinationTypeFtpModePassive' => 'パッシブモード',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'パッシブモードは、Plesk で管理するサーバがファイアウォール内にあり、受信 TCP 接続を受け付けられない場合に使用可能です。',
    'web.site-copy.existingFiles' => '既存ファイルに対して行う操作',
    'web.site-copy.existingFilesKeep' => '既存ファイルをコピー先サイトに残す',
    'web.site-copy.existingFilesKeepDescription' => 'コピー先サイトにある名前の重複する既存ファイルを上書きします。',
    'web.site-copy.existingFilesDelete' => 'すべての既存ファイルを削除する',
    'web.site-copy.existingFilesDeleteDescription' => 'コピー先サイト内の全ファイルをコピー前に削除します。',
    'web.site-copy.emptyLogin' => 'FTP アカウントのユーザ名を指定します。',
    'web.site-copy.emptyHost' => 'サーバホスト名を指定します。',
    'web.site-copy.emptyPort' => 'サーバホストポートを指定します。',
    'web.site-copy.copyInProgress' => 'ウェブサイト %%sourceName%% から %%destinationName%% へのコピーを実行しています。進行状況はメールでお知らせします（%%email%%）。',
    'web.site-copy.unableToCopy' => 'ウェブサイトファイルのコピーに失敗しました。',
    'web.site-copy.siteCopied' => 'ウェブサイトファイルがコピーされました。',
    'web.site-copy.emailSubjSuccess' => 'ウェブサイト「%%source%%」ファイルがコピーされました。',
    'web.site-copy.emailSubjFailure' => 'ウェブサイト「%%source%%」ファイルのコピーに失敗しました。',
    'web.site-copy.emailBodySuccess' => 'ウェブサイト「%%source%%」ファイルが「%%destination%%」にコピーされました。',
    'web.site-copy.emailBodyFailure' => '「%%destination%%」へのウェブサイト「%%source%%」ファイルのコピーに失敗しました。%%message%%',

    'web._shared.forwardingSettingsSectionLegend' => '転送設定',
    'web._shared.forwardDestination' => '転送先アドレス',
    'web._shared.forwardDestinationHint' => 'ターゲットウェブサイトの URL',
    'web._shared.forwardingTypeOptions' => '転送タイプ',
    'web._shared.forwardingFrame' => 'フレーム転送',
    'web._shared.forwardingFrameHint' => 'ウェブサイトの訪問者を他のサイトへリダイレクトしますが、転送先のアドレスは表示しません。 そのため、訪問者は転送されていることを把握できまません。',
    'web._shared.forwardingHttpCode301' => '恒久的に移動（コード 301）',
    'web._shared.forwardingHttpCode301Hint' => 'ウェブサイト訪問者を別のサイトへリダイレクトし、リダイレクト先アドレスを訪問者に表示します。このようなリダイレクトによって、サイトの検索エンジンランキングを維持することができます。',
    'web._shared.forwardingHttpCode302' => '一時的に移動（コード 302）',
    'web._shared.forwardingHttpCode302Hint' => '検索エンジンに一時サイトをインデックスさせたくない時に、ウェブサイト訪問者を一時サイトコピーへリダイレクトします。',
    'web._shared.documentRoot' => 'ドキュメントルート',
    'web._shared.documentRootHint' => 'ウェブサイトのホームディレクトリへのパス',
    'web._shared.documentRootHintDisabledDueApplications' => 'このウェブサイトにウェブアプリケーションがインストールされているため、ドキュメントルートを変更できません',
    'web._shared.ipAddress' => 'IP アドレス',
    'web._shared.shared' => '共用',
    'web._shared.exclusive' => '専用',
    'web._shared.ipAddressHint' => "ウェブサイトをホスティングしている IP アドレス。ウェブサイトの仮想ホストのネットワークアドレスです。",
    'web._shared.certificateFromDomainRepository' => '%%name%%（%%repositoryName%%）',
    'web._shared.certificateFromOtherRepository' => '%%name%%（その他のリポジトリ）',
    'web._shared.certificate' => '証明書',
    'web._shared.sameCertificatesHint' => '選択した証明書は、同じ専用 IP アドレスでホスティングされているすべてのサイトに対して使用されます。',
    'web._shared.differentCertificatesHint' => 'この契約は、2 つの異なる証明書を持つ 2 つの専用 IP アドレスに関連付けられています。選択した証明書は、これら 2 つの IP アドレスでホスティングされているサイトにインストールされているいずれかの証明書に置き換えられます。',
    'web._shared.differentIpTypesCertificateHint' => 'この契約は 1 つの共有 IP アドレスと 1 つの専用 IP アドレスに関連付けられています。選択した証明書は、専用 IP アドレスでホスティングされている他のすべてのサイトに対しても使用されます。',
    'web._shared.certificateNotSelected' => '未選択',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'リポジトリに SSL/TLS 証明書がありません。証明書を追加するには、%%link%%に進みます。',
    'web._shared.sslCertificatesRepositoryLink' => 'このページ',

    'web-user.settings.allowScripts' => 'ウェブユーザにスクリプトの使用を許可',

    'web-user.name' => 'サーバに FTP 接続するためのユーザ名',
    'web-user.longName' => 'このユーザ名は長すぎます（最大 %max% 文字まで許可されます）。',
    'web-user.password' => 'パスワード',
    'web-user.passwordConfirmation' => 'パスワードの確認',
    'web-user.hardDiskQuota' => 'ハードディスククォータ',
    'web-user.hardDiskQuotaUnlimited' => '無制限',
    'web-user.hardDiskQuotaIsNotSupported' => '（ハードディスククォータは、サーバファイルシステムで構成されていないためサポートされていません。）',
    'web-user.megabytes' => 'MB',

    'requiredFields' => '必須フィールド',
];