<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Endereço IP ou sub-rede',
    'access-network.subnetOrIpAddressHint' => 'Por exemplo, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Informativos',
    'admin.announcement-settings.getConsentLoading' => 'Recuperando informações sobre boletins informativos...',
    'admin.announcement-settings.getConsentWarning' => 'Não foi possível recuperar o status de sua assinatura.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Gostaria de receber informativos do Plesk. Elas podem conter informações técnicas, relacionadas à segurança e produtos em geral. Eu concordo e autorizo o Plesk a coletar, processar e utilizar meus dados pessoais (e-mail), incluindo processamentos internacionais, em conformidade com as leis de proteção de dados vigentes para me enviar boletins informativos diretamente ou por meio de um serviço de terceiros. Desmarcar essa caixa de seleção revoga meus consentimentos e pedidos do Plesk interrompendo o envio de e-mails e removendo permanentemente meus dados pessoais de seus sistemas.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Sim, por favor, concordo em receber meu boletim informativo personalizado do Plesk. Plesk International GmbH e suas afiliadas podem armazenar e processar os dados que forneço com o objetivo de entregar o boletim de acordo com a %%privacyPolicy%%. Para personalizar suas mensagens e ofertas, o Plesk também pode usar informações adicionais para criação de perfil, como dados de uso e comportamento. Posso cancelar a inscrição da(s) lista(s) de discussão a qualquer momento.',
    'admin.announcement-settings.privacyPolicy' => 'Política de Privacidade Plesk',
    'admin.announcement-settings.noConsent' => 'Cancele a inscrição no boletim informativo do Plesk.',
    'admin.announcement-settings.reportConsentError' => 'Não foi possível salvar suas configurações para receber informações da Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Desculpe, não podemos atualizar seu perfil no momento. Tente novamente mais tarde.',
    'admin.announcement-settings.invalidConsentType' => "Tipo de consentimento desconhecido: '%%type%%'",
    'admin.announcement-settings.retry' => 'Tente novamente',
    'admin.announcement-settings.consentGivenInfo' => 'Esperamos que você tenha gostado do boletim informativo convencional do Plesk. Agora podemos fornecer uma alternativa melhorada – personalizado com informações e dicas úteis, de acordo com suas necessidades. Para receber seu boletim informativo personalizado do Plesk, escolha a primeira declaração abaixo e clique em OK.',
    'admin.announcement-settings.consentNotGivenInfo' => 'Parece que você não está inscrito na nossa newsletter convencional. Podemos fornecer uma alternativa melhor - uma newsletter personalizada, com informações e dicas úteis de acordo com suas necessidades.',

    'admin.personal-info.title' => 'Edição do Perfil do Administrador',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Configurações do Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Configurações',

    'admin-alias.login' => 'Nome do usuário',
    'admin-alias.password' => 'Senha',
    'admin-alias.passwordConfirmation' => 'Confirmar a senha',
    'admin-alias.email' => 'E-mail',
    'admin-alias.contact' => 'Nome de contato',
    'admin-alias.comments' => 'Comentários',
    'admin-alias.emptyLogin' => 'Forneça um nome de usuário.',
    'admin-alias.loginTooLong' => 'O tamanho do nome de usuário excede 20 caracteres.',
    'admin-alias.emptyEmail' => 'Forneça um e-mail.',
    'admin-alias.emptyContactName' => 'Forneça um nome de contato.',
    'admin-alias.contactNameTooLong' => 'O tamanho do nome de contato excede 255 símbolos.',
    'admin-alias.emptyPassword' => 'Forneça uma senha.',
    'admin-alias.commentsTooLong' => 'O tamanho do comentário excede 255 símbolos.',
    'admin-alias.emailActivation' => 'Ativar conta por e-mail',
    'admin-alias.simplePanel' => 'Habilitar Modo Restrito',
    'admin-alias.simplePanelHint' => 'Selecione essa opção para limitar o número de ações que o administrador adicional pode realizar no Plesk. Para alterar quais ações estão disponíveis, acesse %%link%%.',
    'admin-alias.simplePanelLink' => 'Ferramentas e Configurações > Configuração do Modo Restrito',
    'admin-alias.lockPowerUser' => 'Forçar exibição do Usuário Avançado para o administrador adicional',
    'admin-alias.lockPowerUserHint' => 'Capacidade de restringir a exibição para o administrador adicional do Plesk (sem acesso a clientes, revendedores e planos de serviço).',

    'admin-info.plesk-settings.multiplyLogin' => 'Permitir várias sessões nesta conta',
    'admin-info.plesk-settings.adminLanguage' => 'Idioma de interface do administrador',
    'admin-info.plesk-settings.password' => 'Senha',
    'admin-info.plesk-settings.passwordConfirmation' => 'Confirmar a senha',

    'admin-panel.form.contact-info.contactName' => 'Nome de contato',
    'admin-panel.form.contact-info.emptyContactName' => 'Forneça um nome de contato.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'O nome de contato é muito longo (são permitidos, no máximo, %max% símbolos).',
    'admin-panel.form.contact-info.email' => 'Endereço de e-mail',
    'admin-panel.form.contact-info.emptyEmail' => 'Forneça um endereço de e-mail.',
    'admin-panel.form.contact-info.companyName' => 'Nome da empresa',
    'admin-panel.form.contact-info.longCompanyName' => 'O nome da empresa é muito longo (são permitidos, no máximo, %max% símbolos).',
    'admin-panel.form.contact-info.phone' => 'Telefone',
    'admin-panel.form.contact-info.longPhone' => 'O número de telefone é muito longo (são permitidos, no máximo, %max% símbolos).',
    'admin-panel.form.contact-info.fax' => 'Número de fax',
    'admin-panel.form.contact-info.imNumber' => 'Mensageiro instantâneo',
    'admin-panel.form.contact-info.longFax' => 'O número de fax é muito longo (são permitidos, no máximo, %max% símbolos).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'O número de telefone especificado não é válido.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'O número de fax está incorreto.',
    'admin-panel.form.contact-info.address' => 'Endereço',
    'admin-panel.form.contact-info.longAddress' => 'O endereço é muito longo (são permitidos, no máximo, %max% símbolos).',
    'admin-panel.form.contact-info.city' => 'Cidade',
    'admin-panel.form.contact-info.longCity' => 'O nome da cidade é muito longo.',
    'admin-panel.form.contact-info.shortCity' => 'O nome da cidade é muito curto.',
    'admin-panel.form.contact-info.state' => 'Estado/província',
    'admin-panel.form.contact-info.postalCode' => 'Código postal/CEP',
    'admin-panel.form.contact-info.country' => 'País',
    'admin-panel.form.contact-info.additionalInfo' => 'Informações adicionais',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Apenas texto simples: Todas as tags de HTML serão ignoradas.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Já existe um usuário com esse endereço de e-mail no sistema.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Assinatura',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Propriedades do website fornecido com a assinatura.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Propriedades do website fornecido com a assinatura.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Propriedades do website fornecido com a assinatura.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Criar assinatura para o cliente',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Se não desejar criar uma assinatura de serviço de hospedagem ou configurar um website para o cliente neste momento, limpe essa caixa de seleção. Sem uma assinatura, o cliente não poderá efetuar o login no Painel do Cliente.',
    'admin-panel.form.domain-info-section.domainName' => 'Nome de domínio',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Você deve fornecer um nome de domínio.',
    'admin-panel.form.domain-info-section.shared' => 'compartilhado',
    'admin-panel.form.domain-info-section.exclusive' => 'dedicado',
    'admin-panel.form.domain-info-section.userName' => 'Nome do usuário',
    'admin-panel.form.domain-info-section.userNameHint' => 'A conta de usuário do sistema utilizada para gerenciar arquivos e pastas dos websites criados na assinatura.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Você deve fornecer um nome de usuário.',
    'admin-panel.form.domain-info-section.password' => 'Senha',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Você deve fornecer uma senha.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Confirme a senha',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "O endereço IP no qual o website está hospedado é um endereço de rede do host virtual do website.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Endereço IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "O endereço IP no qual o website está hospedado é um endereço de rede do host virtual do website.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Endereço IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Nenhum',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Configurações adicionais de assinatura',
    'admin-panel.form.domain-info-section.credentials' => 'Credenciais de usuário do sistema',
    'admin-panel.form.domain-info-section.credentialsHint' => 'para acessar arquivos hospedados por FTP e SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'para acessar arquivos hospedados por FTP e RDP',

    'admin-panel.form.login-info.userName' => 'Nome do usuário',
    'admin-panel.form.login-info.emptyUserName' => 'Forneça um nome de usuário.',
    'admin-panel.form.login-info.password' => 'Senha',
    'admin-panel.form.login-info.emptyPassword' => 'Forneça uma senha.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Repita a senha',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Alterar a senha também mudará a senha do endereço de e-mail interno',
    'admin-panel.form.login-info.emailActivation' => 'Ativar conta por e-mail',
    'admin-panel.form.login-info.emailActivationHint' => 'Uma conta criada permanece inativa até que o usuário a ative com o link enviado por e-mail ou que o administrador ative a conta manualmente.',

    'admin-panel.form.subscription-info-section.subscription' => 'Assinatura',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Plano de serviços',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Plano de serviços atual',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Novo plano de serviços',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Plano Simples',
    'admin-panel.form.subscription-info-section.none' => 'Nenhum',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Complementos',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Prossiga para customizar os parâmetros da assinatura, após a alteração da associação do plano. Observe que esse procedimento bloqueará a assinatura para a sincronização.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Continue personalizando os parâmetros de assinatura após sua criação.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Continue personalizando os parâmetros de assinatura após a criação do cliente.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Prossiga para customizar os parâmetros da assinatura, após sua criação. Observe que esse procedimento bloqueará a assinatura para a sincronização.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Observe que fazer isso bloqueará a assinatura para sincronização.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Adicionar Assinatura',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Não foi possível sincronizar a assinatura com o plano de serviços. As configurações a seguir da assinatura entram em conflito com o plano de serviços: %%problems%%.',

    'app.configure.otherSettings' => 'Outros',
    'app.configure.passwordConfirmation' => 'Confirme a senha',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Força as atualizações para os apps instalados',
    'app.update-settings.forceUpdatesHint' => 'Todos os apps dos clientes receberão as atualizações automaticamente assim que estiverem disponíveis.Os clientes não poderão desativar as atualizações automáticas para os seus apps.Advertência: Utilize esta opção com cuidado porque as atualizações podem afetar significantemente a funcionalidade do app. Por exemplo, as extensões de app podem parar de trabalhar com outra versão do app.',
    'app.update-settings.suggestUpdates' => 'Ative a opção "Atualizar automaticamente este app" por padrão',
    'app.update-settings.suggestUpdatesHint' => 'Para aplicativos recém-instalados, a opção "Atualizar automaticamente este app" nas configurações de apps serão ativadas.',

    'backup.server-settings.rotation' => 'Número máximo de arquivos de backup completo a serem armazenados (incluindo backups agendados e manuais)',
    'backup.server-settings.rotationDescription' => 'Os usuários podem armazenar esses diversos backups completos no armazenamento do servidor. Se o número de backups completos já no armazenamento exceder o limite, apenas os backups mais recentes serão mantidos. Os backups incrementais não são afetados.',
    'backup.server-settings.maxProcesses' => 'Quantidade máxima de processos de backup agendados sendo executados simultaneamente',
    'backup.server-settings.niceScheduled' => 'Execute os processos de backup agendados com baixa prioridade',
    'backup.server-settings.niceScheduledPriority' => 'Prioridade',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Digite um valor entre 1 e 19, o número maior é considerado a prioridade mais baixa.',
    'backup.server-settings.niceScheduledIoPriority' => 'Prioridade de IO',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Digite um valor entre 0 e 7, o número maior é considerado a prioridade mais baixa.',
    'backup.server-settings.niceAlways' => 'Execute todos os processos de backup com prioridade baixa',
    'backup.server-settings.niceAlwaysPriority' => 'Prioridade',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Digite um valor entre 1 e 19, o número maior é considerado a prioridade mais baixa.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Prioridade de IO',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Digite um valor entre 0 e 7, o número maior é considerado a prioridade mais baixa.',
    'backup.server-settings.compressionLevel' => 'Nível de compressão',
    'backup.server-settings.compressionLevelNoCompression' => 'Sem compressão',
    'backup.server-settings.compressionLevelFastest' => 'Mais rápido',
    'backup.server-settings.compressionLevelFast' => 'Rápido',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'Máximo',
    'backup.server-settings.freeSpaceRequired' => 'Inicie o backup somente se seu servidor tiver espaço livre suficiente em disco (em megabytes)',
    'backup.server-settings.checkBackupDiskSpace' => 'Inicie o backup apenas se o servidor tiver a quantidade suficiente de espaço livre em disco',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Utilizar a funcionalidade de backup MS SQL nativo (Para bancos de dados remotos, certifique-se de configurar as configurações do backup do servidor remoto MS SQL em Ferramentas e Configurações> Servidores do Banco de Dados)',
    'backup.server-settings.localFtpRestriction' => 'Permite a configuração do armazenamento de backup do FTP no servidor local',
    'backup.server-settings.backupSecuritySettings' => 'Configurações de segurança de backup',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Salvar backups no armazenamento do servidor se o upload para o armazenamento remoto falhar',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Os backups manuais e programados destinados ao armazenamento remoto serão salvos no armazenamento do servidor local se o upload para o armazenamento remoto falhar. Os usuários devem ter permissão para armazenar backups no armazenamento do servidor.',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => 'Clientes pertencentes ao admin',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => 'Todas as contas de clientes que pertenciam ao administrador na versão anterior do Plesk foram convertidas em contas de clientes pertencentes ao administrador: (1) Os recursos legados de cada cliente foram preservados (podem ser encontrados em \'Meus recursos\' no topo da lista de assinaturas de clientes). Esses recursos serão removidos, uma vez concluída a transição; (2) Todos os seus domínios foram convertidos em assinaturas (uma nova assinatura para cada domínio); (3) Os administradores de domínio foram convertidos em usuários do cliente que tem acesso somente à assinatura que contém seus domínios.',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => 'Estado de antigo cliente',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => 'Número de clientes',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => 'Esquema de transição',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => 'Um domínio; o ajuste de limites foi proibido.',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => 'Os novos recursos de assinatura são iguais ao mínimo dos limites do antigo cliente ou antigos domínios.',
    'business-model-upgrade.bunch.t1s1-apply' => 'Efetuar transição dos clientes',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => 'Um domínio; o ajuste de limites foi permitido.',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => 'Os novos recursos de assinatura são iguais aos limites do antigo cliente.',
    'business-model-upgrade.bunch.t1s2-apply' => 'Efetuar transição dos clientes',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => 'Vários domínios; a criação de domínios e o ajuste de limites foram proibidos.',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => 'Os novos recursos de assinatura são herdados dos limites do antigo domínio.',
    'business-model-upgrade.bunch.t1s3-apply' => 'Efetuar transição dos clientes',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => 'Vários domínios; a criação de domínios e o ajuste de limites foram permitidos.',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => 'Transição como:',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => 'Revendedor. Um antigo cliente passa a ser revendedor. Os recursos de assinatura de revendedor são herdados dos limites do antigo cliente. Se estava habilitada para um antigo domínio, a conta de administrador de domínio passa a ser uma conta de cliente, e a assinatura correspondente é associada a essa conta. Caso contrário, as assinaturas pertencem diretamente ao revendedor.',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => 'Cliente. Um antigo cliente permanece cliente. Os recursos dos clientes são igualmente distribuídos entre suas assinaturas.',
    'business-model-upgrade.bunch.t1s6r-solutionName' => 'Revendedores',
    'business-model-upgrade.bunch.t1s6c-solutionName' => 'Clientes',
    'business-model-upgrade.bunch.t1s6-apply' => 'Efetuar transição dos clientes como',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => 'Clientes pertencentes aos revendedores',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => 'Todas as contas de cliente que pertenciam ao revendedor no Plesk 9 foram convertidas em contas de cliente pertencentes aos respectivos revendedores: (1) Os recursos legados de cada cliente foram preservados (podem ser encontrados em \'Meus recursos\' no topo da lista de assinaturas de clientes). Esses recursos serão removidos, uma vez concluída a transição; (2) Todos os seus domínios foram convertidos em assinaturas (uma nova assinatura para cada domínio); (3) Os administradores de domínio foram convertidos em usuários do cliente que tem acesso somente à assinatura que contém seus domínios.',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => 'Estado de antigo cliente',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => 'Número de clientes',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => 'Esquema de transição',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => 'Um domínio; o ajuste de limites foi proibido.',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => 'Os novos recursos de assinatura são iguais ao mínimo dos limites do antigo cliente ou antigos domínios.',
    'business-model-upgrade.bunch.t2s1-apply' => 'Efetuar transição dos clientes',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => 'Um domínio; o ajuste de limites foi permitido.',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => 'Os novos recursos de assinatura são iguais aos limites do antigo cliente.',
    'business-model-upgrade.bunch.t2s2-apply' => 'Efetuar transição dos clientes',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => 'Vários domínios; a criação de domínios e o ajuste de limites foram proibidos.',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => 'Os novos recursos de assinatura são herdados dos limites do antigo domínio.',
    'business-model-upgrade.bunch.t2s3-apply' => 'Efetuar transição dos clientes',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => 'Vários domínios; a criação de domínios e o ajuste de limites foram permitidos.',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => 'Os recursos dos clientes são igualmente distribuídos entre suas assinaturas.',
    'business-model-upgrade.bunch.t2s6-apply' => 'Efetuar transição dos clientes',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => 'Assinaturas pertencentes ao admin',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Todos os domínios que pertenciam ao administrador em uma versão anterior do Plesk foram convertidos em assinaturas do próprio administrador. Os administradores de domínio foram convertidos para os usuários do Painel do Cliente e têm acesso somente à assinatura que contém seus domínios. Adote as ações recomendadas para a transição dessas assinaturas ou selecione um esquema de transição customizado para cada uma na guia \'Transição seletiva de assinaturas\'.',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => 'Estado de antigo domínio',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => 'Número de assinaturas',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => 'Esquema de transição',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => 'O domínio pertencia ao admin; a conta de administrador de domínio foi habilitada.',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => 'O administrador do antigo domínio passou a ser cliente e se tornou um assinante, o que significa que a assinatura lhe é atribuída.',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => 'Efetuar transição das assinaturas',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => 'Assinaturas pertencentes aos revendedores',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Todos os domínios que pertenciam aos revendedores em uma versão anterior do Plesk foram convertidos em assinaturas dos próprios revendedores, preservando a propriedade. Os administradores de domínio foram convertidos para os usuários do Painel do Cliente e têm acesso somente à assinatura que contém seus domínios. Adote as ações recomendadas para a transição dessas assinaturas ou selecione um esquema de transição customizado para cada uma na guia \'Transição seletiva de assinaturas\'.',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => 'Estado de antigo domínio',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => 'Número de assinaturas',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => 'Esquema de transição',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => 'O domínio pertencia a um revendedor; a conta de administrador de domínio foi habilitada.',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => 'O administrador do antigo domínio passou a ser cliente e se tornou um assinante, o que significa que a assinatura lhe é atribuída.',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => 'Efetuar transição das assinaturas',
    'business-model-upgrade.bunch.thereWereSomeErrors' => 'A transição de alguns dos clientes e assinaturas selecionadas não foi efetuada.',

    'change-current-subscription.hint' => 'Esta é a área em que você altera a associação aos planos de serviços da assinatura. Observe que selecionar \'nenhum\' como um novo plano de serviços desvincula a assinatura do plano de serviços e a torna \'Customizada\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Não foi possível sincronizar a assinatura com o plano de serviços. As configurações a seguir da assinatura entram em conflito com o plano de serviços: %%problems%%.',

    'change-password.oldPassword' => 'Senha antiga',
    'change-password.password' => 'Nova senha',
    'change-password.passwordConfirmation' => 'Confirmar senha',
    'change-password.oldPasswordIsIncorrect' => 'A senha antiga está incorreta. Tente novamente.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Impossível localizar a conta de administrador adicional.',
    'change-password.warningAboutAdminPasswordSyntax' => "A senha deve ter entre %%min%% - %%max%% caracteres e não deve conter o nome do usuário.\nNão utilize aspas, espaços e caracteres de alfabetos nacionais na senha.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Não utilize aspas, espaços e ponto e vírgula, e caracteres de alfabetos nacionais na senha.\nA senha deve ter entre %%min%% e %%max%% caracteres, e não deve conter o nome do usuário.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Política de overselling',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'O overselling é permitido',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'O overselling permite ao revendedor vender mais recursos do que os alocados pelo plano. Se o overselling for permitido, o revendedor será controlado pelo uso real de recursos em vez da alocação inicial de recursos.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'O overselling não é permitido',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Se o overselling não for permitido, o revendedor poderá vender apenas os recursos inicialmente alocados pelo plano, independentemente da quantidade realmente utilizada desses recursos.',

    'change-reseller-subscription.hint' => 'Esta é a área em que você altera a associação ao plano de serviços da assinatura de revendedor. Observe que selecionar \'nenhum\' como um novo plano de serviços desvincula a assinatura dos planos de serviços e a torna \'Customizada\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Não foi possível sincronizar a assinatura com o plano de serviços. As configurações a seguir da assinatura entram em conflito com o plano de serviços: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Novo plano',
    'change-reseller-subscription.oldSubscription' => 'Plano atual',
    'change-reseller-subscription.none' => 'nenhuma',
    'change-reseller-subscription.infoSubscriptionChanged' => 'A associação da assinatura ao plano de serviços foi atualizada.',
    'change-reseller-subscription.customizeSubscription' => 'Prossiga com a customização dos parâmetros de assinatura, após sua associação ao plano de serviços ser atualizada. Observe que esse procedimento bloqueará a assinatura para a sincronização.',

    'change-subscription.hint' => 'Esta é a área em que você altera a associação aos planos de serviços das assinaturas selecionadas.',
    'change-subscription.selectPlanLegend' => 'Plano de serviços',
    'change-subscription.selectPlanDescription' => 'Para mudar para outro plano de serviços, escolha o novo plano na lista. Observe que selecionar \'nenhum\' desvincula as assinaturas do plano de serviços e as torna \'Customizadas\'.',
    'change-subscription.servicePlan' => 'Novo plano de serviços',
    'change-subscription.selectAddonPlansLegend' => 'Planos de complementos',
    'change-subscription.selectAddonPlansDescription' => 'Adicionar ou remover planos de complementos.',
    'change-subscription.noChange' => 'sem alterações',
    'change-subscription.none' => 'nenhuma',
    'change-subscription.add' => 'adicionar',
    'change-subscription.del' => 'remover',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Endereço IP ou sub-rede',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Por exemplo, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Acesso ao Plesk com privilégios de administrador',
    'control-panel-access.settings.policyAllow' => 'Permitido, excluindo as redes na lista.',
    'control-panel-access.settings.policyDeny' => 'Negado a partir das redes que não estão listadas.',

    'create-subscription.title' => 'Adicionar uma Assinatura',
    'create-subscription.titleOwn' => 'Adicionando sua própria assinatura',
    'create-subscription.poolIsEmpty' => 'Não foi possível criar uma assinatura porque não existem endereços IP compartilhados e não existem endereços IP livres dedicados no Plesk.',
    'create-subscription.infoNewSubscriptionCreated' => 'A assinatura %%name%% foi criada.',
    'create-subscription.createBeforeAppInstall' => 'Você precisa ter uma assinatura para instalar o app.',

    'customer.hint' => 'Esta é a área em que você registra um novo cliente em seus serviços de hospedagem. Esse registro cria uma conta de cliente no Plesk e uma assinatura de um de seus planos de hospedagem e, opcionalmente, complementos. A assinatura também pode fornecer um conjunto totalmente customizado de recursos e serviços não vinculado a nenhum plano. Para isso, selecione \'Nenhum\' próximo do plano de serviço.',
    'customer.contactInfoSection' => 'Informações de contato',
    'customer.additionalInfoSection' => 'Informações adicionais do cliente',
    'customer.accessToPanelSection' => 'Acesso ao Plesk',
    'customer.contactInfoSectionHint' => 'Digite as informações de contato do cliente.',
    'customer.accessToPanelSectionHint' => 'As credenciais que o cliente utilizará para acessar seu Painel do Cliente.',
    'customer.unableCreateSubscription' => 'A assinatura não pode ser criada: %%reason%%',
    'customer.poolIsEmpty' => 'Pool de IP vazio',
    'customer.buttonOk' => 'Adicionar Cliente',

    'database-settings.dbPrefixRadio' => 'Adicionar o prefixo e sublinhado para o início dos nomes de bancos de dados',
    'database-settings.dbPrefixNone' => 'Nenhuma',
    'database-settings.dbPrefixUsername' => 'Nome do usuário',
    'database-settings.dbPrefixExternalId' => 'ID externo de uma assinatura',
    'database-settings.dbUserPrefix' => 'Adicionar nome de usuário e sublinhado ao início dos nomes de usuário de banco de dados',
    'database-settings.dbUserPrefixHint' => 'Os nomes de bancos de dados se assemelham a <plesk_username>_<database_ user_name>. Devido à restrição do banco de dados do tamanho do nome de usuário, <plesk_username> deve ser abreviado.',
    'database-settings.grantAlterDatabase' => 'Conceder a permissão ALTER DATABASE para todos os usuários de banco de dados Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Será concedida essa permissão para usuários novos e existentes.',
    'database-settings.enableBackupOperator' => 'Habilitar a permissão de afiliação db_backupoperator para todos os usuários do banco de dados Microsoft SQL Server',
    'database-settings.enableBackupOperatorHint' => 'Usuários novos e existentes serão um membro desta permissão.',
    'database-settings.aclRadio' => 'Configurações padrão para acesso remoto de usuários de banco de dados',
    'database-settings.aclLocalhost' => 'Permitir somente conexões locais',
    'database-settings.aclAny' => 'Permitir conexões remotas de qualquer host',
    'database-settings.aclCustom' => 'Permitir conexões remotas de',
    'database-settings.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOs hosts especificados têm permissão para acessar o banco de dados em nome deste usuário.",
    'database-settings.aclDescription' => 'Esta configuração modifica somente as permissões de users\'. Para habilitar o acesso remoto ao servidor MySQL local, selecione a opção correspondente em <a href="/server/db_server_edit.php?db_server_id=%d">Configurações Locais do MySQL</a>.',
    'database-settings.example' => "Por exemplo:\n%%example%%",

    'dns.template.synchronize-done' => 'O modelo de zona DNS foi aplicado com êxito.',
    'dns.template.synchronize-error' => 'O modelo de zona DNS não foi aplicado a algumas zonas DNS.',
    'dns.template.synchronize-progress' => 'Aplicando o modelo de zona DNS.',

    'domain-restriction.name' => 'Nome do domínio',
    'domain-restriction.nameDescription' => 'Você pode especificar um caractere curinga padrão utilizando o sinal de asterisco (*). Por exemplo, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'O nome de domínio especificado já está na lista.',

    'event-handler.eventLabel' => 'Evento',
    'event-handler.priorityLabel' => 'Prioridade',
    'event-handler.userLabel' => 'Usuário',
    'event-handler.commandLabel' => 'Comando',
    'event-handler.commandHint' => 'Para melhores resultados, insira um caminho completo para um arquivo de script no campo \'command\'. Não recomendamos entrar comandos do sistema já que eles podem não funcionar. Por exemplo, comandos com operadores de redirecionamento de saída /&gt; ou &lt; não funcionarão.',
    'event-handler.priorityHighestText' => 'maior',
    'event-handler.priorityHighText' => 'alta',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'baixa',
    'event-handler.priorityLowestText' => 'menor',
    'event-handler.priorityCustomText' => 'cstomização',
    'event-handler.priorityHighestOption' => 'mais alto (%%value%%)',
    'event-handler.priorityHighOption' => 'alto (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'baixo (%%value%%)',
    'event-handler.priorityLowestOption' => 'mais baixo (%%value%%)',

    'extension.upload.fileUpload' => 'Caminho para o arquivo de pacote de módulo',

    'external-webmail.hint' => 'Uma vez registrado no Plesk, um webmail adicional é disponibilizado aos seus clientes: o webmail será exibido como uma opção nas propriedades \'E-mail\' dos planos e assinaturas de hospedagem. O nome de webmail será exibido na lista de opções de webmail, e o URL será aberto quando o ícone de webmail for clicado próximo de uma caixa postal no Painel do Cliente .',
    'external-webmail.name' => 'Nome de serviço do webmail',
    'external-webmail.url' => 'URL de serviço do webmail',
    'external-webmail.enabled' => 'Disponível',

    'ftp-settings.generalSection' => 'Geral',
    'ftp-settings.portRange' => 'Porta ou intervalo de portas para as conexões em modo de FTP',
    'ftp-settings.hintPortRange' => '(valor padrão: %%defaultPortRange%%)',

    'health.upload.hint' => 'Efetue o upload da sua configuração do monitor de integridade do servidor. A configuração será aplicada tão logo o upload seja concluído.',
    'health.upload.selectFile' => 'Arquivo de configuração',

    'install-local-package.selectUploadType' => 'Escolha uma das seguintes opções:',
    'install-local-package.uploadAsFile' => 'Efetuar upload de um pacote APS',
    'install-local-package.downloadFromCatalog' => 'Selecione um aplicativo do catálogo de aplicativos.',
    'install-local-package.formInfo' => "Estenda a lista de aplicativos disponíveis com um novo aplicativo ou adicione um Catálogo de Aplicativo para obter mais opções de configuração.",
    'install-local-package.invalidFileExtension' => 'O aplicativo transferido por upload deve ser um arquivo ZIP com a extensão .zip.',
    'install-local-package.packagesNotSelected' => 'Nenhum dos pacotes foi selecionado.',
    'install-local-package.visible' => 'Disponibilizar para clientes',
    'install-local-package.isCommercial' => 'Este aplicativo é comercial e requer compra ou chave de licença.',
    'install-local-package.visibleDescription' => 'Disponibilizar o aplicativo para instalação pelos clientes.',

    'ip-address.generalSection' => 'Geral',
    'ip-address.interface' => 'Interface',
    'ip-address.addressAndSubnetPrefixLength' => 'Máscara de sub-rede e endereço IP',
    'ip-address.publicIp' => 'Endereço de IP público',
    'ip-address.hintPublicIp' => 'Você pode usar um endereço IP público se o seu servidor Plesk estiver por trás do NAT',
    'ip-address.distributionType' => 'O endereço IP é distribuído como',
    'ip-address.distributionTypeShared' => 'Compartilhado',
    'ip-address.distributionTypeExclusive' => 'Dedicado',
    'ip-address.certificate' => 'Certificado SSL/TLS',
    'ip-address.defaultSite' => 'Site-padrão',
    'ip-address.ftpOverSslNotSupportedByServer' => 'O servidor FTP instalado não suporta FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'O servidor de FTP instalado não suporta os endereços IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'Não é possível adicionar o endereço IP. Essa interface de rede obtém endereços IP automaticamente.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Observação: URL Plesk personalizado está habilitado para todos os domínios desconhecidos; A interface do Plesk será exibida em vez do site padrão em "https://%%ip%%/"',

    'ip-ban.filter.name' => 'Nome',
    'ip-ban.filter.content' => 'Conteúdo',
    'ip-ban.filter.filterExistsError' => 'Um filtro com esse nome já existe.',

    'ip-ban.jail.name' => 'Nome',
    'ip-ban.jail.filter' => 'Filtro',
    'ip-ban.jail.filterDescription' => 'Selecione o filtro.',
    'ip-ban.jail.action' => 'Ação',
    'ip-ban.jail.actionDescription' => 'Selecione uma ação e clique no botão para adicioná-la.',
    'ip-ban.jail.logPath' => 'Caminho do log',
    'ip-ban.jail.banTime' => 'Período de proibição do endereço IP',
    'ip-ban.jail.maxRetry' => 'O número máximo de falhas de tentativas de registro',
    'ip-ban.jail.timeUnit' => 'segundos',
    'ip-ban.jail.addAction' => 'Adicionar',
    'ip-ban.jail.chooseAction' => 'Selecione:',
    'ip-ban.jail.apache-auth-filter-description' => 'Falhas de autorização do Apache (ao fazer login no arquivo)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Falhas de autorização do Apache (qualquer registro)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Falhas de autorização do Apache (ao fazer login no  syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spam bots e rastreadores web ruins',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Falhas de autenticação no Courier IMAP e POP3',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Falhas de autenticação do Dovecot IMAP, POP3 e Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Falhas na autenticação Dovecot IMAP, POP3 e Sieve (modo agressivo)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Falhas de autenticação do webmail Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Firewall de Aplicação Web (ModSecurity) violações de segurança e controle de acesso',
    'ip-ban.jail.plesk-panel-filter-description' => 'Falhas de autenticação do Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Falhas de autenticação do QMail SMTP',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Falhas de autenticação do webmail Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Falhas na autenticação WordPress',
    'ip-ban.jail.postfix-filter-description' => 'Erros do cliente Postfix SMTP (incluindo RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Erros do cliente Postfix SMTP, falhas na autenticação, e ataques DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Falhas de autenticação do Postfix SMTP e SASL',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Ataques no Postfix SMTP DDoS',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Erros do cliente Postfix SMTP e falhas na autenticação',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Erros do cliente Postfix SMTP (incluindo RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Erros do cliente Postfix SMTP (somente no RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Falhas de login do ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Hosts banidos repetidamente pelo Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Falhas de login no SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Falhas no login SSH, falhas de negociação, e ataques DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Falhas no login SSH e ataques DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Login no SSH e falhas de negociação',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Proibir através do firewall em todas as portas',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Proibir através do firewall em múltiplas portas',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Proibir através do firewall em uma única porta',
    'ip-ban.jail.iptables-action-description' => 'Proibir através do firewall iptables em uma única porta',
    'ip-ban.jail.iptables-allports-action-description' => 'Proibir através do firewall iptables em todas as portas',
    'ip-ban.jail.iptables-multiport-action-description' => 'Proibir através do firewall iptables em múltiplas portas',
    'ip-ban.jail.sendmail-action-description' => 'Enviar notificação por e-mail através do Sendmail',
    'ip-ban.jail.jailExistsError' => 'Um jail com esse nome já existe.',
    'ip-ban.jail.invalidInteger' => 'O valor especificado é invalido. Especificar um número inteiro.',

    'ip-ban.settings.pageHint' => 'Aqui você pode configurar a proibição de endereço IP a fim de proteger o seu servidor e os web sites hospedados do tráfego malicioso.',
    'ip-ban.settings.detectionEnabled' => 'Ativar detecção de intrusos',
    'ip-ban.settings.banPeriod' => 'Período de proibição do endereço IP',
    'ip-ban.settings.banTimeWindow' => 'Intervalo de tempo para a detecção de ataques subsequentes',
    'ip-ban.settings.maxRetries' => 'Número de falhas antes que o endereço IP seja banido',
    'ip-ban.settings.timeUnit' => 'segundos',
    'ip-ban.settings.invalidInteger' => 'Um valor inválido foi fornecido. Fornece um número inteiro positivo.',

    'ip-ban.trusted-ip.ipAddress' => 'Endereço IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'Fornece um endereço IP, uma máscara CIDR ou um nome de host DNS.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'O endereço IP, endereço de rede ou nome do host é inválido.',

    'login-info.hint' => 'Esta é a área em que você altera o nome do usuário e a senha utilizados pelo cliente para acessar seu Painel do Cliente.',
    'login-info.resellerHint' => 'Esta é a área em que você altera o nome do usuário e/ou a senha utilizada pelo revendedor para acessar seu Plesk.',
    'login-info.myProfileHint' => 'Esta é a área em que você altera a senha utilizada para acessar seu Plesk.',

    'mail.lists-server-settings.email' => "E-mail do administrador de lista de mala direta",
    'mail.lists-server-settings.emptyEmail' => 'Forneça um endereço de e-mail.',
    'mail.lists-server-settings.newPassword' => 'Nova senha',
    'mail.lists-server-settings.emptyPassword' => 'Forneça uma senha.',
    'mail.lists-server-settings.passwordConfirmation' => 'Confirmar senha',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'O software de liista de envio foi configurado.',

    'mail.outgoing-messages.hint' => 'Aqui você pode especificar um limite de mensagens de saída de uma caixa de e-mail.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Número máximo de mensagens de e-mail de saída',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Padrão (%%domainOutgoingMessages%% mensagens por hora)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Valor customizado para esta caixa de e-mail',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'mensagens por hora',

    'mail-gate-settings.host' => 'Nome do host ou endereço IP',
    'mail-gate-settings.port' => 'Porta',
    'mail-gate-settings.login' => 'Nome do usuário',
    'mail-gate-settings.password' => 'Senha',
    'mail-gate-settings.encryption' => 'O SMTP servidor precisa de conexão criptografada',
    'mail-gate-settings.allowUsers' => 'Permitir que scripts de usuários enviem e-mail através deste servidor SMTP (usando o nome de usuário e senha especificados)',
    'mail-gate-settings.useDefaultSettings' => 'Usar o servidor de e-mail instalado com o Plesk e a conta de e-mail padrão criada por ele',

    'mail-gate.hint' => 'Aqui você pode especificar o servidor SMTP a ser usado quando o servidor de e-mail do Plesk não estiver instalado ou estiver proibido de enviar e-mails. Este servidor será usado como um relé de SMTP pelo Plesk e scripts de usuários para enviar e-mails, tais como notificações de e-mail.',
    'mail-gate.enableMailGate' => 'Permitir que Plesk enviem notificações de e-mail através deste servidor SMTP',
    'mail-gate.notifications' => 'Notificações de e-mail através do servidor SMTP externo',
    'mail-gate.smtpSettings' => 'Configurações do servidor SMTP externo',

    'optimization-settings.apacheModulesSection' => 'Módulos Apache',
    'optimization-settings.apacheSettingsSection' => 'Configurações gerais',
    'optimization-settings.additionalPageHint' => 'Alterne módulos apenas se você compreendeu completamente as consequências de suas ações. Observar que algumas modificações podem reduzir o desempenho do Apache ou até mesmo levar à inoperabilidade.',
    'optimization-settings.pageHint' => 'Aqui você pode otimizar o Plesk desligando os módulos Apache não usados. Essa otimização melhora a utilização da memória e permite que você atenda a mais clientes de hospedagem. Observar que alguns módulos são interdependentes e podem ser desligados (ligados) somente quando os módulos dos quais eles dependem estiverem desligados (ligados).',
    'optimization-settings.advancedUsersOnlyWarning' => 'Este recurso é apenas para usuários avançados.',
    'optimization-settings.apacheRestartInterval' => 'Intervalo de reinicialização do Apache (segundos)',
    'optimization-settings.apacheRestartIntervalHint' => 'Uma vez em um intervalo especificado, o Plesk verifica as alterações feitas em domínios e subdomínios. No caso de haver alterações que requerem a reinicialização do servidor da web, o Plesk reinicia o Apache.',
    'optimization-settings.gracefulRestart' => 'Reinicialização normal do Apache',
    'optimization-settings.gracefulRestartHint' => 'Selecione para evitar o tempo de inatividade de todos os sites hospedados no servidor, sempre que você alterar as configurações de hospedagem.',
    'optimization-settings.pipedLog' => 'Registros conduzidos',
    'optimization-settings.mpmMode' => 'Modo MPM',
    'optimization-settings.moduleDeprecated' => '(Descontinuada)',

    'personal-info.contactInfoSection' => 'Informações de contato',
    'personal-info.hint' => 'Esta é a área em que você edita as informações de contato do usuário.',
    'personal-info.hintMyProfile' => 'Esta é a área em que você edita suas informações de contato.',

    'php-handler.ini.formHint' => 'Este arquivo php.ini está sendo utilizado apenas por este manipulador.',
    'php-handler.ini.formHintSharedIni' => 'Este arquivo php.ini também está sendo utilizado pelos seguintes manipuladores do PHP: %%handlers%%. As configurações aplicam-se a todos os sites que utilizam estes manipuladores.',
    'php-handler.ini.incorrectTextForIniFile' => "As configurações especificadas estão incorretas e não puderam ser salvas no arquivo php.ini. Erro: %%message%%.",

    'php-handler.modules.formHint' => 'Estas configurações das extensões do PHP são apenas para este manipulador.',
    'php-handler.modules.formHintSharedModules' => 'Estas configurações são comuns para os seguintes manipuladores PHP: %%handlers%%. As configurações aplicam-se a todos os sites que utilizam estes manipuladores.',

    'plan-item-custom.planItemName' => 'Nome do serviço',
    'plan-item-custom.buttonLabel' => 'Esse nome também será utilizado como rótulo para o botão customizado.',
    'plan-item-custom.planItemDescription' => 'Descrição do serviço',
    'plan-item-custom.buttonTooltip' => 'Esse texto também será utilizado como dica de ferramenta para o botão customizado.',
    'plan-item-custom.url' => 'URL anexo ao botão customizado',
    'plan-item-custom.backgroundImage' => 'Imagem de fundo do botão customizado',
    'plan-item-custom.emptyItemName' => 'Forneça um rótulo para o serviço.',
    'plan-item-custom.emptyItemDescription' => 'Forneça um texto para a dica de ferramenta do serviço.',
    'plan-item-custom.emptyUrl' => 'Especifique um URL.',
    'plan-item-custom.longItemName' => 'O rótulo de serviço é muito longo. O número de caracteres máximo é de %max% símbolos.',
    'plan-item-custom.longItemDescription' => 'O texto de serviço é muito longo. O número de caracteres máximo é de %max% símbolos.',
    'plan-item-custom.longUrl' => 'O URL é muito longo. O número de caracteres máximo é de %max% símbolos.',
    'plan-item-custom.useCustomButton' => 'Utilizar o botão customizado para o serviço',
    'plan-item-custom.useCustomButtonHint' => 'Coloque um botão customizado na página inicial do usuário e nas páginas do website.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Abrir a URL no Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'O URL será aberto na mesma janela de navegador do Plesk.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Abra a página sem quadro no Painel de Controle',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Se você adicionar um botão personalizado que leva a um serviço (como um aplicativo ou módulo do Plesk) no Painel do Cliente, pode especificar como esse serviço deve ser apresentado: em um quatro ou parte de um Plesk GUI.',
    'plan-item-custom.includeDomId' => 'Incluir a ID de assinatura',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Incluir o nome de domínio principal',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Incluir o nome de usuário de FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Incluir a senha de FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Incluir a ID do cliente',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Incluir o nome da empresa do cliente",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Incluir o nome do contato do cliente",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Inclua o e-mail do cliente",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Escolha como pré-visualizar websites',
    'preview-domain-settings.previewQuick' => 'Pré-visualização Rápida Padrão',
    'preview-domain-settings.previewDisabled' => 'Desabilitar Pré-visualização rápida',
    'preview-domain-settings.previewQuickDescription' => 'Uma opção recomendada que funciona fora da caixa.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Visualização rápida em um nome de domínio no Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Selecione um dos websites servidos pelo Plesk para serem usados para a pré-visualização.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Para utilizar este recurso, %%link%% em pelo menos um domínio.',
    'preview-domain-settings.subscriptionCreateLink' => 'criar',
    'preview-domain-settings.previewZoneTypeExternal' => 'Visualização rápida em um nome de domínio externo',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Utilize um nome de domínimo externo ( zona DNS). Ao utilizar esta opção, acrescente o registro DNS a seguir (tipo A) à zona de domínio externo: *.<Plesk_IP>.external.dom. Eis <Plesk_IP />um IP do servidor Plesk onde os pontos (.) para o IPv4 ou os dois pontos (:) para o IPv6 são substituídos por traços (-). Por exemplo, *.192-0-2-12.external.dom. Se o Plesk tem mais do que um IP registrado, acrescente um registro para cada endereço.',
    'preview-domain-settings.sitePreviewProtection' => 'Requer autenticação',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Requer nome de usuário e senha FTP para acessar a visualização.',
    'preview-domain-settings.nginxNotInstalled' => 'Visualização Rápida Padrão não está disponível porque o servidor web nginx não está instalado.',
    'preview-domain-settings.nginxDisabled' => 'Visualização Rápida Padrão não está disponível porque o servidor web nginx está desativado.',

    'reseller-preferences.settingsSection' => 'Configurações',
    'reseller-preferences.multiLogin' => 'Permitir várias sessões',
    'reseller-preferences.language' => 'Idioma da interface',
    'reseller-preferences.interfaceView' => 'Selecione sua interface',
    'reseller-preferences.serviceProviderView' => 'Visualização de provedor de serviço',
    'reseller-preferences.serviceProviderViewHint' => 'Esta visualização destina-se aos revendedores que possuem clientes. Você pode gerenciar os clientes, bem como seus próprios sites e serviços de hospedagem nesta visualização.',
    'reseller-preferences.powerUserView' => 'Visualização de usuário com autorização',
    'reseller-preferences.powerUserViewHint' => 'Essa exibição fornece uma interface simples para os revendedores gerenciarem seus próprios websites, contas de e-mail e outros serviços de hospedagem. Nesta visualização, não é possível gerenciar os clientes.',

    'reseller.hint' => 'Esta é a área em que você registra um novo revendedor em seus serviços de hospedagem.',
    'reseller.contactInfoSection' => 'Informações de contato',
    'reseller.contactInfoSectionHint' => 'Digite as informações de contato do revendedor.',
    'reseller.accessToPanelSection' => 'Acesso ao Plesk',
    'reseller.accessToPanelSectionHint' => 'Credenciais a serem utilizadas pelo revendedor para acessar o Plesk para gerenciar serviços de sua assinatura.',
    'reseller.subscription' => 'Assinatura',
    'reseller.subscriptionSectionHint' => 'Selecione um plano de serviços do qual o revendedor será assinante.',
    'reseller.servicePlan' => 'Plano de serviços',
    'reseller.none' => 'nenhuma',
    'reseller.customizeSubscription' => 'Prossiga para customizar os parâmetros da assinatura, após a criação do revendedor. Observe que esse procedimento bloqueará a assinatura para a sincronização.',
    'reseller.subscriptionNotSynchronized' => 'Não foi possível sincronizar a assinatura com o plano de serviços. As configurações a seguir da assinatura entram em conflito com o plano de serviços: %%problems%%.',

    'security-policy.encryptionSection' => 'Criptografe senhas de usuários',
    'security-policy.encryptionSectionHint' => 'O modo de segurança otimizado apresenta proteção avançada para dados confidênciais no Plesk. Neste modo, o Plesk emprega vários mecanismos de segurança que são absolutamente transparentes para seus usuários. Recomendamos que você ative este modo a fim de melhorar a segurança do Plesk.',
    'security-policy.encryptionEnable' => 'Criptografe senhas de usuários',
    'security-policy.securePassword' => 'Criptografe senhas de usuários',
    'security-policy.strengthSection' => 'Força da senha',
    'security-policy.strengthSectionHint' => 'Quando os usuários definem uma nova senha no sistema (crie uma nova ou altere uma já existente), eles deverão ajustar a senha de acordo com os requisitos mínimos de força especificados nesta página. A força de uma senha é calculada com base no seu comprimento total e complexidade (uso de dígitos, letras maiúsculas e minúsculas, e caracteres especiais). Recomendamos que você force seus usuários a usar senhas mais fortes.',
    'security-policy.passwordStrength' => 'Força mínima da senha',
    'security-policy.passwordStrengthVeryWeakHint' => 'Essas senhas são normalmente curtas e usam apenas um tipo de caracteres (caracteres minúsculos ou maiúsculos ou dígitos). Exemplo: password. Esse nível de segurança impede os ataques mais simples de adivinhação de senhas.',
    'security-policy.passwordStrengthWeakHint' => 'Essas senhas são normalmente curtas e contêm ao menos um tipo de caractere (caracteres minúsculos ou maiúsculos ou dígitos) com dois caracteres de tipo diferente. Exemplo: password12. Essas senhas oferecem proteção básica a adivinhação de senha.',
    'security-policy.passwordStrengthMediocreHint' => 'Essas senhas são normalmente curtas e contêm ao menos dois tipos de caracteres (caracteres minúsculos ou maiúsculos, dígitos ou caracteres especiais). Exemplo: Senha12. Essas senhas oferecem proteção confiável a ataques que capturem senhas.',
    'security-policy.passwordStrengthStrongHint' => 'Essas senhas são de no mínimo 8 caracteres e devem incluir ao menos uma ocorrência de caracteres maiúsculos e minúsculos, dígitos e caracteres especiais. Exemplo: P@ssw0rd12. Essas senhas fornecem proteção forte contra ataques de força bruta.',
    'security-policy.passwordStrengthStrongerHint' => 'Essas senhas são de no mínimo 16 caracteres e incluem várias ocorrências de caracteres maiúsculos e minúsculos, dígitos e caracteres especiais. Exemplo: ~!my_P@$$w0rD123. Essas senhas fornecem a melhor proteção possível, embora elas sejam difíceis de lembrar.',
    'security-policy.secureFtpSection' => 'FTP Seguro',
    'security-policy.ftpOverSsl' => 'Política de Utilização de FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS é utilizado para proteger a comunicação entre o servidor FTP e os clientes externos de FTP utilizando o protocolo SSL/TLS. Aqui você pode selecionar quais tipos de conexões devem ser permitidos.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'O FTPS é utilizado para proteger a comunicação entre o servidor FTP e clientes externos de FTP utilizando o protocolo SSL/TLS. Aqui você pode selecionar quais tipos de conexões devem ser permitidos. A opção selecionada será aplicada a todos os endereços de IP no servidor. Para utilizar as configurações personalizadas por endereço de IP, selecione a opção correspondente e modifique a política de FTPS em Ferramentas & Configurações > Endereços de IP.',
    'security-policy.ftpOverSslCustomHint' => 'O FTPS é utilizado para proteger a comunicação entre o servidor FTP e clientes externos de FTP utilizando o protocolo SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'O FTPS é utilizado para proteger a comunicação entre o servidor FTP e clientes externos de FTP utilizando o protocolo SSL/TLS. Se você deseja ajustar as configurações de FTPS por endereço de IP, primeiro selecione a opção "Usar configurações personalizadas de FTPS por endereço de IP" em Ferramentas & Configurações > Política de segurança > FTP seguro."',
    'security-policy.ftpOverSslOptionRequired' => 'Permita somente as conexões seguras de FTPS',
    'security-policy.ftpOverSslOptionEnabled' => 'Permita as conexões seguras e não-seguras de FTPS',
    'security-policy.ftpOverSslOptionDisabled' => 'Permite somente as conexões não-seguras de FTP. Não utilize FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Utilize a política personalizada de FTPS pelo endereço de IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Customizar manuseadores de política',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Habilite esta opção para proibir os clientes de substituir os manipuladores do IIS definidos no nível do servidor por meio do arquivo web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Proibir a capacidade de substituir manipuladores via web.config',

    'service-instance.setup-instance.resourcesSection' => 'Recursos de Serviço',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Já instalado',
    'service-instance.setup-instance.requirementsSection' => 'Serviços Necessários',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'Não selecionado',

    'service-node.ipAddress' => 'Endereço IP do nó de serviço',
    'service-node.ipAddressLocal' => 'Nó de serviço local',
    'service-node.description' => 'Descrição do nó de serviço',
    'service-node.accessKey' => 'Senha',
    'service-node.useAccessKey' => 'Usar autenticação',
    'service-node.useAccessKeyDescription' => 'Dica sobre o uso da autenticação.',
    'service-node.oldAccessKey' => 'Senha antiga',
    'service-node.newAccessKey' => 'Nova senha',
    'service-node.noAccessKeySpecified' => 'A senha não foi especificada.',

    'service-plan.admin-plan.subscription_section' => 'Comum',
    'service-plan.admin-plan.tools_section' => 'Ferramentas & Recursos',
    'service-plan.admin-plan.apps_section' => 'Aplicativos e Bases de Dados',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Aparência do Plesk',
    'service-plan.admin-plan.statistics_section' => 'Estatísticas',
    'service-plan.admin-plan.general_section' => 'Informações gerais',
    'service-plan.admin-plan.mail_section' => 'E-mail',
    'service-plan.admin-plan.server_section' => 'Servidor',
    'service-plan.admin-plan.modules_section' => 'Módulos',
    'service-plan.admin-plan.simplePanel' => 'Modo Restrito',
    'service-plan.admin-plan.enabled' => 'Habilitar Modo Restrito',
    'service-plan.admin-plan.enabledDescription' => 'Selecione essa opção para limitar o número de ações que o administrador pode realizar no Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Selecione essa opção para limitar o número de ações que o administrador adicional pode realizar no Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Fornecer apenas aplicativos que eu selecionar.',
    'service-plan.applications-subscription.useFilterDescription' => 'Utilize esta opção para selecionar os aplicativos que devem ser disponibilizados para o assinante.',
    'service-plan.applications-subscription.applications' => 'Aplicativos',
    'service-plan.applications-subscription.isCommercial' => 'Este aplicativo é comercial e requer compra ou chave de licença.',

    'service-plan.applications.useFilterLabel' => 'Fornecer apenas aplicativos que eu selecionar.',
    'service-plan.applications.useFilterDescription' => 'Utilize esta opção para selecionar os aplicativos que devem ser disponibilizados para os assinantes.',
    'service-plan.applications.applications' => 'Aplicativos',
    'service-plan.applications.isCommercial' => 'Este aplicativo é comercial e requer compra ou chave de licença.',

    'service-plan.dns.dnsZoneType' => 'Zona DNS do domínio',
    'service-plan.dns.dnsZoneTypeMaster' => 'Mestre',
    'service-plan.dns.dnsZoneTypeSlave' => 'Escravo',

    'service-plan.extras.groupOtherServices' => 'Outros serviços',
    'service-plan.extras.none' => 'Nenhum',

    'service-plan.hosting.enablePhysicalHosting' => 'Habilitar hospedagem',
    'service-plan.hosting.sectionCoreHosting' => 'Propriedades gerais',
    'service-plan.hosting.sectionScripting' => 'Criação de scripts',
    'service-plan.hosting.defaultDatabaseServer' => 'Servidor do banco de dados padrão',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avançado',
    'service-plan.hosting.phpSettingsHelpLink' => 'Saiba como escolher as configurações de PHP mais adequadas',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Status dos sites se essa assinatura for suspensa',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Status dos sites em assinaturas suspensas',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'O status selecionado será aplicado a todos os sites de acordo com os planos de assinaturas quando a assinatura é suspensa (por exemplo, expira ou seu período pago expira).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'O status selecionado será aplicado a todos os sites de acordo com quando a assinatura é suspensa (por exemplo, expira ou seu período pago expira).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Desabilitado',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Visitantes do site serão redirecionados para a página padrão do servidor site.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Suspenso',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Os visitantes serão redirecionados com o código de mecanismo de pesquisa auxiliar 503 HTTP para a página de erro do documento personalizada.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Ativo',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Os sites permanecerão acessíveis pela Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Alocar endereços IP compartilhados',
    'service-plan.ip.allocateExclusiveIp' => 'Alocar endereços IP dedicados',
    'service-plan.ip.allocateExclusiveIpV4' => 'Alocar endereços IPv4 dedicados',
    'service-plan.ip.allocateExclusiveIpV6' => 'Alocar endereços IPv6 dedicados',

    'service-plan.mail.mailService' => 'Ativar o serviço de e-mail',
    'service-plan.mail.webMail' => 'WebMail',
    'service-plan.mail.mailingLists' => 'Ativar malas diretas',
    'service-plan.mail.mailToNonExistentUser' => 'Política de e-mail para usuários não existentes',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Devolução com mensagem',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Redirecionar para endereço',
    'service-plan.mail.mailToNonExistentUserReject' => 'Rejeitar',
    'service-plan.mail.mailAutodiscovery' => 'Ativar descoberta automática de e-mail',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Veja como funciona em <a href="%%link%%" target="_blank">base de conhecimento</a>',
    'service-plan.mail.bounceMessage' => 'Este endereço não aceita mais e-mails.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Redirecione um servidor de e-mail externo com o endereço de IP',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - desabilitado',

    'service-plan.misc.retainEnabled' => 'Manter estatísticas de tráfego e web para',
    'service-plan.misc.logRotation' => 'Rotação de logs',
    'service-plan.misc.logRotationCondition' => 'Condição de rotação de logs',
    'service-plan.misc.logRotationBySize' => 'Por tamanho',
    'service-plan.misc.logRotationByTime' => 'Por horário',
    'service-plan.misc.logRotationDaily' => 'Diário',
    'service-plan.misc.logRotationWeekly' => 'Semanal',
    'service-plan.misc.logRotationMonthly' => 'Mensal',
    'service-plan.misc.logRotationSizeDescription' => 'Valor de tamanho deve ser entre %%min%% e %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Número máximo de arquivos de log',
    'service-plan.misc.compress' => 'Comprima os arquivos de log',
    'service-plan.misc.sendLogToEmail' => 'Após o Plesk recuperar os dados dos arquivos de registro de internet e servidores de FTP, envie um e-mail com os registros para este endereço',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'meses',
    'service-plan.misc.logRotationPeriodGreater' => 'O período de rotação de log não pode ser maior que o limite de todo o servidor %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Se desativados, todos os sites de uma assinatura utilizam o mesmo pool do aplicativo IIS dedicado para a assinatura.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Selecione serviços e privilégios fornecidos com a assinatura.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Exibir mais permissões disponíveis',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Exibir menos permissões',
    'service-plan.permissions-subscription.noShellManagement' => 'Não permitido',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Gerenciamento de acesso ao servidor sobre SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Permite que os cliente mudem o SSH para seu usuário do sistema. Faz com que o parâmetro de hospedagem "acesso SSH ao shell do servidor sob a assinatura do usuário do sistema" aja como uma predefinição.',

    'service-plan.permissions.permissionsTabDescription' => 'Selecione os serviços e permissões fornecidos com o plano.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Selecione serviços e privilégios a serem adicionados às assinaturas com este plano de complementos. Observe que as permissões não selecionadas no complemento não modificarão de nenhum modo os parâmetros da assinatura.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'As permissões permitem que os clientes alterem configurações específicas de suas assinaturas. Quando uma assinatura é criada, o Plesk aplica os valores predefinidos do plano às configurações que o cliente pode alterar. Posteriormente, atualizar o plano ou aplicar um plano complementar não substitui as alterações feitas pelo cliente.',
    'service-plan.permissions.showMorePermissions' => 'Exibir mais permissões disponíveis',
    'service-plan.permissions.hideMorePermissions' => 'Exibir menos permissões',
    'service-plan.permissions.noShellManagement' => 'Não permitido',
    'service-plan.permissions.systemAccessLabel' => 'Gerenciamento de acesso ao servidor sobre SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Torna o parâmetro de hospedagem "Acesso SSH ao shell do servidor para o usuário do sistema da assinatura" um ajuste predefinido.',

    'service-plan.resources-subscription.overusePolicy' => 'Política de abuso na utilização',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'O abuso na utilização não é permitido',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Reprovar o uso excessivo de recursos. Uma assinatura é automaticamente suspensa se o uso do recurso exceder os valores limites.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'O uso excessivo de espaço de disco e tráfego é permitido',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Permitir o uso excessivo de espaço de disco e tráfego. Reprovar o uso excessivo de recursos.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'O uso exagerado é permitido (não recomendado)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Permitir que o assinante use mais recursos do que inicialmente fornecido com a assinatura.',
    'service-plan.resources-subscription.overuseNotify' => 'Notifique-me por e-mail em casos de uso excessivo.',
    'service-plan.resources-subscription.oversellPolicy' => 'Política de excesso de venda',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'O overselling é permitido',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'O overselling permite a um revendedor vender mais recursos que os alocados por uma assinatura. Se o overselling for permitido, o revendedor será controlado pelo uso real de recursos em vez da alocação inicial de recursos.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'O overselling não é permitido',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Se o excesso de venda não é permitido, o revendedor poderá vender apenas os recursos inicialmente alocados para eles com a assinatura, independentemente da quantidade de recursos realmente utilizada.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Defina os limites de utilização de recursos fornecidos com a assinatura.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Exibir mais recursos disponíveis',
    'service-plan.resources-subscription.hideMoreResources' => 'Exibir menos recursos',

    'service-plan.resources.overusePolicy' => 'Política de abuso na utilização',
    'service-plan.resources.overusePolicyNotAllowed' => 'O abuso na utilização não é permitido',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Reprovar o uso excessivo de recursos. Uma assinatura é automaticamente suspensa se o uso do recurso exceder os valores limites.',
    'service-plan.resources.overusePolicySoftAllowed' => 'O uso excessivo de espaço de disco e tráfego é permitido',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Permitir o uso excessivo de espaço de disco e tráfego. Reprovar o uso excessivo de recursos.',
    'service-plan.resources.overusePolicyAllowed' => 'O uso exagerado é permitido (não recomendado)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Permitir que os clientes usem mais recursos do que inicialmente fornecido pelo plano.',
    'service-plan.resources.overuseNotify' => 'Avisar-me por e-mail em casos de uso exagerado.',
    'service-plan.resources.oversellPolicy' => 'Política de excesso de venda',
    'service-plan.resources.oversellPolicyAllowed' => 'O overselling é permitido',
    'service-plan.resources.oversellPolicyAllowedHint' => 'O overselling permite ao revendedor vender mais recursos do que os alocados pelo plano. Se o overselling for permitido, o revendedor será controlado pelo uso real de recursos em vez da alocação inicial de recursos.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'O overselling não é permitido',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Se o overselling não for permitido, o revendedor poderá vender apenas os recursos inicialmente alocados pelo plano, independentemente da quantidade realmente utilizada desses recursos.',
    'service-plan.resources.mainGroupTitle' => 'Defina os recursos fornecidos com o plano.',
    'service-plan.resources.additionalGroupTitle' => 'Exibir mais recursos disponíveis',
    'service-plan.resources.hideMoreResources' => 'Exibir menos recursos',
    'service-plan.resources.allowSitebuilderUpsell' => 'Permitir ao cliente criar websites de teste do Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Esta configuração permite ao cliente criar mais websites do Presence Builder que os fornecidos pelo plano de serviços. O cliente terá de adquirir esses websites para publicá-los.',

    'service-plan.servicePlanName' => 'Nome do plano de serviços',
    'service-plan.resellerPlanName' => 'Nome do plano de revendedor',
    'service-plan.addonPlanName' => 'Nome do plano de complementos',
    'service-plan.adminPlanPermissionsTab' => 'Ferramentas Administrativas',
    'service-plan.adminPlanPermissionsTabDescription' => 'Selecione os recursos disponíveis para o administrador quando o Modo Restrito estiver habilitado.',
    'service-plan.hostingPermissionsTab' => 'Ferramentas de Hospedagem',
    'service-plan.hostingPermissionsTabDescription' => 'Selecione as ferramentas e configurações de hospedagem na Web disponíveis para o administrador na exibição do Usuário Avançado quando o Modo Restrito estiver habilitado.',
    'service-plan.resourcesTab' => 'Recursos',
    'service-plan.resourcesTabDescription' => 'Defina os recursos fornecidos com o plano e a política de utilização de recursos.',
    'service-plan.subscriptionResourcesTabDescription' => 'Defina os recursos fornecidos com a assinatura e a política de utilização de recursos.',
    'service-plan.hostingTab' => 'Parâmetros de hospedagem',
    'service-plan.hostingTabDescription' => 'Especifique os parâmetros do serviço de hospedagem fornecido com o plano. Observe que as configurações de hospedagem especificadas no plano de add-on não são aplicadas às assinaturas que receberam a permissão do "Gerenciamento das configurações de hospedagem" seja pelo plano de serviço ou pelo plano de add-on.',
    'service-plan.secureSettingsDescription' => 'Para garantir a máxima segurança da hospedagem fornecida, %%link%%. Observe que algumas das permissões, quando concedidas, permitem aos assinantes alterar essas configurações. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'aplique as configurações seguras predefinidas',
    'service-plan.secureSettingsHelpLink' => 'Conheça as configurações de hospedagem segura',
    'service-plan.mailTab' => 'E-mail',
    'service-plan.mailTabDescription' => 'Especifique os parâmetros do serviço de e-mail fornecido com o plano.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Especifique os parâmetros do serviço DNS fornecido com o plano.',
    'service-plan.performanceTab' => 'Desempenho',
    'service-plan.performanceTabDescription' => 'Especifique os parâmetros do sistema que afetam o desempenho de todos os serviços fornecidos com o plano.',
    'service-plan.permissionsTab' => 'Permissões',
    'service-plan.miscTab' => 'Logs e estatísticas',
    'service-plan.miscTabDescription' => 'Especifique como as estatísticas e logs das assinaturas do plano devem ser armazenados. Observe que estas configurações não sincronizam com as assinaturas.',
    'service-plan.miscTabAdminPlanDescription' => 'Especifique como as estatísticas e registros das assinaturas devem ser armazenados.',
    'service-plan.extrasTab' => 'Serviços adicionais',
    'service-plan.extrasTabDescription' => 'Selecione os serviços a serem incluídos no plano, além dos serviços de hospedagem web, DNS e e-mail.',
    'service-plan.ipTab' => 'Endereços IP',
    'service-plan.ipTabDescription' => 'Definir parâmetros de recursos IP fornecidos com o plano.',
    'service-plan.applicationsTab' => 'Aplicativos',
    'service-plan.applicationsTabDescription' => 'Selecione os aplicativos que devem ser disponibilizados no plano. Você pode optar por fornecer todos os aplicativos disponíveis no catálogo de aplicativos mais os transferidos por upload para o servidor ou selecionar os aplicativos manualmente. Se desejar fornecer todos os aplicativos disponíveis, você não precisará fazer nada nesta guia. Simplesmente, vá para a guia Permissões e selecione a opção Acesso ao catálogo de aplicativos. Para selecionar aplicativos manualmente, faça-o nesta guia.',
    'service-plan.applicationsTabDescription-addon' => 'Selecione os aplicativos que devem estar disponíveis no add-on.',
    'service-plan.applicationsTabDescription-subscription' => 'Selecione os aplicativos que devem ser disponibilizados na assinatura. Você pode optar por fornecer todos os aplicativos disponíveis no catálogo de aplicativos mais os transferidos por upload para o servidor ou selecionar os aplicativos manualmente. Se desejar fornecer todos os aplicativos disponíveis, você não precisará fazer nada nesta guia. Simplesmente, vá para a guia Permissões e selecione a opção Acesso ao catálogo de aplicativos. Para selecionar aplicativos manualmente, faça-o nesta guia.',
    'service-plan.planSyncSubsriptionWarning' => 'Algumas das assinaturas não foram sincronizadas com o plano. Tais assinaturas foram marcadas como \'Dessincronizadas\' na lista de assinaturas. Para tentar uma nova sincronização, vá para a página de visão geral de uma assinatura e clique no botão Sincronizar.',
    'service-plan.planSyncResellerWarning' => 'Alguns revendedores não foram sincronizados com o plano. Eles foram marcados como \'Dessincronizados\' na lista de revendedores. Para tentar uma nova sincronização, vá para a página de visão geral de um revendedor e clique no botão Sincronizar.',
    'service-plan.planSyncAdminWarning' => 'Não foi possível aplicar as alterações às assinaturas porque o Plesk não fornece alguns dos serviços ou recursos afetados por essas mudanças. O motivo: %%reason%%',
    'service-plan.duplicateName' => 'Um plano com o nome já existe.',
    'service-plan.phpSettingsTab' => 'Configurações do PHP',
    'service-plan.phpSettingsTabDescription' => 'Aqui é possível especificar as configurações PHP por assinatura que se sobrepõem às configurações definidas pelo arquivo php.ini de todo o servidor. Isso pode ser útil, por exemplo, quando se deseja limitar o consumo de recursos do sistema por scripts PHP dos clientes. Os clientes (se permitido) podem sobrepor essa configuração PHP com a sua própria configuração por domínio. Ao estabelecer um parâmetro para o valor Padrão, o PHP usará o valor do parâmetro da configuração PHP de todo o servidor. Note que os seguintes espaços reservados são suportados: {DOCROOT} e {WEBSPACEROOT} apóiam o diretório raiz do documento de um domínio e um diretório raiz de uma assinatura que recebe configuração PHP personalizada; {TMP} além do diretório que armazena arquivos temporários.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Aqui você pode especificar as configurações PHP por subscrição que substituem as configurações definidas pelo plano de serviço principal. Isso pode ser útil, por exemplo, quando você deseja remover algumas limitações PHP estabelecidas no plano do serviço principal. Ao estabelecer um parâmetro para o valor Padrão, o PHP usará o valor do parâmetro da configuração PHP de todo o servidor. Note que os seguintes espaços reservados são suportados: {DOCROOT} e {WEBSPACEROOT} apóiam o diretório raiz do documento de um domínio e um diretório raiz de uma assinatura que recebe configuração PHP personalizada; {TMP} além do diretório que armazena arquivos temporários.',
    'service-plan.phpSettingsPhpVersion' => 'Sua versão PHP atual é %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Aqui é possível especificar as configurações PHP por assinatura que se sobrepõem às configurações definidas pelo arquivo php.ini de todo o servidor. Ao estabelecer um parâmetro para o valor Padrão, o PHP irá usar o valor do parâmetro da configuração PHP de todo o servidor.',
    'service-plan.webServerSettingsTab' => 'Servidor de Internet',
    'service-plan.webServerSettingsTabDescription' => 'Aqui você pode especificar as configurações do servidor de internet Apache para este plano de serviço. Se o Apache estiver executando com o nginx como servidor frontend, você também poderá especificar as configurações do nginx nesta página. Todos os domínios recentemente criados servirão as configurações especificadas. No entanto, quando você modificar essas configurações, os domínios existentes não receberão as mudanças.',
    'service-plan.servicesTab' => 'Serviços',
    'service-plan.servicesTabDescription' => 'Aqui você pode especificar os serviços designados para o plano de serviço.',
    'service-plan.servicePropertiesTab' => '%%serviceName%% Propriedades',
    'service-plan.servicePropertiesTabDescription' => 'Aqui você pode especificar as propriedades de serviço de %%serviceName%% designado ao plano de serviço.',
    'service-plan.longTaskWarning' => 'Você tem %%subscriptionsCount%% assinaturas neste plano. Observe que a tarefa de sincronização pode exigir um certo tempo e será feita em segundo plano.',
    'service-plan.hostingParametersTab' => 'Parâmetros de Hospedagem',
    'service-plan.adminInfoSection' => 'Informação para o administrador',
    'service-plan.descriptionInPanel' => 'Descrição',
    'service-plan.longDescription' => 'A descrição especificada é muito longo.',
    'service-plan.conflictPermissions' => 'Impossível conceder as permissões a seguir porque elas entram em conflito com o plano do revendedor: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Tipo de inicialização',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automático',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manual',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Desativar',
    'services.change-startup-type.autoActionError' => 'Não foi possível definir o tipo de inicialização para \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Não foi possível definir o tipo de inicialização para \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Não foi possível definir o tipo de inicialização para \'disabled\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Redefinir para Padrão',
    'sessions.settings.restoreDefaultButtonDescription' => 'Restaurar parâmetros da sessão para os valores padrões.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Parâmetros da sessão têm valores padrões.',
    'sessions.settings.idleTime' => 'Tempo ocioso da sessão',
    'sessions.settings.disableCheckSessionIp' => 'Permitir alterações no endereço IP durante uma única sessão',
    'sessions.settings.minuteShortTitle' => 'mín',

    'settings-ui.controls.title' => 'Controles',

    'settings-ui.interface-views.description' => "Há várias visualizações de IU de produtos disponíveis para você. Dependendo de qual visualização você utilizar, os recursos e configurações podem estar localizados em diferentes locais ou até mesmo habilitados / desabilitados. Diferentes visualizações são mais apropriadas a diferentes tipos de usuários.",
    'settings-ui.interface-views.panelSimpleLink' => 'Ferramentas e Configurações > Configuração do Modo Restrito',
    'settings-ui.interface-views.useCustomView' => 'Habilitar Modo Restrito',
    'settings-ui.interface-views.useCustomViewHint' => 'Selecione essa opção para limitar o número de ações que o administrador pode realizar no Painel do Plesk. Para alterar a disponibilidade de ações, acesse %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => "Essa visualização designa-se a possibilitar uma única e simplificada interface para que os administradores do servidor gerenciem seus próprios sites, contas de e-mail e outros serviços.",
    'settings-ui.interface-views.selectUiModeTitle' => "Selecione sua interface",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Visualização de usuário com autorização",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Visualização de provedor de serviço",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "Essa visualização oferece interfaces para uso pelo administrador do servidor, revendedores e usuários finais de hospedagem.",

    'sitebuilder.trial.description' => 'Esta página permite que você configure o cenário de aquisição do cliente. Nesse cenário, o cliente pode criar um website com todas as funcionalidades disponíveis no aplicativo Presence Builder incluído. No entanto, a publicação de websites de teste não é disponibilizada aos clientes até que estes adquiram um plano de serviços de hospedagem ou um complemento de plano. O modo de teste também pode ser concedido aos seus clientes existentes por meio de um plano de hospedagem ou complemento de plano. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Consulte a documentação para obter mais informações.',
    'sitebuilder.trial.lifetimeLabel' => 'Vida útil do website de teste',
    'sitebuilder.trial.lifetimeUnits' => 'dias',
    'sitebuilder.trial.lifetimeDescription' => 'Deve haver este período antes que os websites de teste não adquiridos pelos clientes sejam removidos do servidor.',
    'sitebuilder.trial.signupLabel' => 'Habilitar o acesso público ao modo de teste',
    'sitebuilder.trial.signupDescription' => 'Se desejar atrair clientes, anunciando serviços de hospedagem por meio do Presence Builder e fornecendo sua versão demo, habilite o acesso público ao modo de teste e publique o URL de acesso a esse modo em seu website.',
    'sitebuilder.trial.signupLinkLabel' => 'URL de acesso ao modo de teste',
    'sitebuilder.trial.signupLinkDescription' => 'Este URL abrirá o Presence Builder no modo de teste. Publique este URL em seu website para anunciar a hospedagem por meio do Presence Builder e atrair clientes.',
    'sitebuilder.trial.promotionLabel' => 'Exibir notificação de modo de teste no editor do Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Utilize esta opção, se desejar exibir notificações adicionais sobre o Presence Builder ao trabalhar no modo de teste.',

    'update-settings.policyHintForPum' => 'Você pode configurar a instalação automática de atualizações aqui. E-mail de notificação pode ser enviado quando as atualizações estiverem disponíveis para instalação manual ou foram instaladas automaticamente.',
    'update-settings.policyHint' => 'E-mail de notificação pode ser enviado quando as atualizações estiverem disponíveis para instalação manual ou foram instaladas automaticamente.',
    'update-settings.branchDisabledDescription' => 'Não me avisar sobre upgrades disponíveis',
    'update-settings.automaticPatchesInstallation' => 'Instalar automaticamente atualizações do Plesk (Recomendado)',
    'update-settings.automaticPatchesInstallationHint' => 'As atualizações críticas de segurança sempre são instaladas automaticamente.',
    'update-settings.automaticPatchesThirdParty' => 'Instalar automaticamente atualizações para componentes de terceiros fornecidos pelo Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Instalar automaticamente atualizações dos pacotes do sistema',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Observe que isso também irá instalar atualizações automaticamente nos componentes de terceiros entregues pela Plesk.',
    'update-settings.automaticPatchesNotification' => 'Notificar sobre atualizações de pacotes de sistema disponíveis e instalados.',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Endereço de e-mail',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Frequência do e-mail de notificação',
    'update-settings.daily' => 'Diário',
    'update-settings.weekly' => 'Semanal',
    'update-settings.generalSection' => 'Geral',
    'update-settings.notificationsSection' => 'Notificações',
    'update-settings.safeUpdatesSection' => 'Atualizações Seguras',
    'update-settings.safeUpdatesSectionHint' => 'A Plesk assegura que as atualizações do pacotes do sistema são instaladas a partir do mesmo repositório por meio do qual os pacotes foram inicialmente instalados. Essas atualizações são consideradas seguras. Se você desabilitar atualizações seguras, seus gerenciadores de pacotes do sistema poderão ser instalados a partir de qualquer repositório no sistema.',
    'update-settings.safeUpdatesSectionWarn' => 'Recomendamos que você deixe as atualizações seguras habilitadas a menos que você seja um usuário avançado. Atualizações indiscriminadas dos pacotes do sistema a partir de diferentes repositórios podem afetar negativamente o funcionamento do seu servidor.',
    'update-settings.allowSafeUpdates' => 'Ativar as atualizações de segurança para os pacotes do sistema',

    'requiredFields' => 'Campos obrigatórios',
];