<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'title' => 'Vérification des journaux des sites Web',

    'regularCheck' => 'Vérification standard',
    'manualCheck' => 'Vérification manuelle',

    'promoTitle' => 'Détection rapide des dysfonctionnements ou de l\'indisponibilité de vos sites Web',
    'promoDescription' => 'Souvent les problèmes des sites Web sont visibles pour les utilisateurs mais invisibles en tant qu\'administrateur, sauf ci l\'administrateur analyse constamment les fichiers journaux du site Web. Notre nouveau système de vérification des fichiers journaux automatise ce processus et simplifie efficacement la résolution des problèmes.',
    'promoMore' => 'En savoir plus',
    'promoButton' => 'J\'ai compris !',
    'checkEnabledTitle' => 'La vérification standard est activée.',
    'checkDisabledTitle' => 'La vérification standard est désactivée.',
    'disabledDescription' => 'Activez la vérification pour savoir s\'il y a des problèmes sur vos sites Web qui entraînent leur dysfonctionnement ou leur indisponibilité.',
    'websitesChecked' => '{count, plural, one {# site Web est vérifié} other {# sites Web sont vérifiés}} tous les jours.',
    'websitesCheckedAt' => '{count, plural, one {# site Web est vérifié} other {# sites Web sont vérifiés}} tous les jours à %%time%%.',
    'websitesNotChecked' => 'La vérification est désactivée pour {count, plural, one {# site Web} other {# sites Web}}.',
    'checkedWebsites' => 'Liste des sites Web vérifiés',
    'lastCheckTitle' => 'Dernière vérification',
    'lastCheckDescription' => 'Réalisée le %%date%% à %%time%%, durée : %%duration%% minutes',
    'lastCheckError' => '%%problems%% détectés sur %%websites%%',
    'lastCheckErrorServerWide' => '%%problems%% détectés',
    'lastCheckSuccess' => 'Aucun problème trouvé',
    'lastCheckProblems' => '{count, plural, one {# problème} other {# problèmes}}',
    'lastCheckWebsites' => '{count, plural, one {# site Web} other {# sites Web}}',
    'durationLess' => 'moins de 0,1',
    'month0' => '%%date%% jan',
    'month1' => '%%date%% fév',
    'month2' => '%%date%% mar',
    'month3' => '%%date%% avr',
    'month4' => '%%date%% mai',
    'month5' => '%%date%% jun',
    'month6' => '%%date%% jul',
    'month7' => '%%date%% aoû',
    'month8' => '%%date%% sep',
    'month9' => '%%date%% oct',
    'month10' => '%%date%% nov',
    'month11' => '%%date%% déc',
    'exportTitle' => 'Le rapport est statique.',
    'exportDescription' => 'Il ne reflète pas les changements sur le site Web.',
    'export' => 'Exporter le rapport au format CSV',
    'buttonRun' => 'Exécuter une nouvelle vérification manuelle',
    'buttonRunDescription' => 'Trouvez les problèmes qui peuvent entraîner l\'indisponibilité ou le dysfonctionnement de vos sites Web',

    'websites.title' => 'Liste des sites Web vérifiés',
    'websites.description' => '%%selected%% sur %%total%% sites Web sont sélectionnés',
    'websites.search' => 'Trouver des sites Web...',
    'websites.new' => 'Tous les sites Web créés récemment',
    'websites.newHint' => 'If checked, all the new websites will automatically be included into the list',
    'websites.existing' => 'Tous les sites Web existants',
    'websites.buttonSave' => 'Enregistrer la liste',
    'websites.buttonCancel' => 'Annuler',
    'websites.updateSuccess' => 'Les paramètres ont été mis à jour',

    'tabs.problemDetails' => 'Détails du problème',
    'tabs.affectedWebsites' => 'Sites Web concernés',

    'chart.requests' => 'Requêtes',
    'chart.errors' => 'Erreurs',

    'affected-websites.selected' => '%%selectedCount%% sur %%totalCount%% sites Web ont été sélectionnés',
    'affected-websites.none' => 'Aucun',
    'affected-websites.all' => 'Tout',
    'affected-websites.searchForWebsite' => 'Rechercher des sites Web',
    'affected-websites.websites' => 'Sites Web',

    'problem-report.commonTitle' => 'Problème signalé',
    'problem-report.domainTitle' => 'Problème signalé sur %%domain%%',
    'problem-report.cumulativeTitle' => 'Problème signalé sur {count, plural, one {# site Web} other {# sites Web}}',
    'problem-report.serverwideTitle' => 'Problème signalé au niveau du serveur',
    'problem-report.problemAppearsOn' => 'Le problème apparaît sur un total de {count, plural, one {# site Web} other {# sites Web}} :',
    'problem-report.seeTheConsolidatedReport' => 'Voir le rapport consolidé',
    'problem-report.cause' => 'Cause principale',
    'problem-report.possibleSolution' => 'Solution possible',
    'problem-report.possibleSolutionNumber' => 'Solution possible n° %%number%%',
    'problem-report.useAnOption' => 'Utiliser une option pour une solution automatique',
    'problem-report.repairTheWebsite' => 'Réparer le site Web',
    'problem-report.selectAndRepair' => 'Sélectionner et réparer plusieurs sites Web',
    'problem-report.logEntries' => 'Exemples d\'entrées de journaux indiquant le problème',
    'problem-report.pleaseKeepInMind' => 'Attention : les journaux suivent la rotation en permanence et les entrées mentionnées sont éventuellement archivées ou supprimées.',
    'problem-report.numberOfEntries' => 'Nombre d\'entrées',
    'problem-report.logEntry' => 'Entrée du journal',
    'problem-report.logFile' => 'Fichier journal',
    'problem-report.openWebsiteLogs' => 'Ouvrir les journaux du site Web',
    'problem-report.thisIsServerWideProblem' => 'Il s\'agit d\'un problème de l\'ensemble du site Web qui affecte tous les sites Web hébergés.',
    'problem-report.serverWideTitle' => 'Problème signalé au niveau du serveur',

    'distribution-over-time.title' => 'Distribution du problème dans le temps',
    'distribution-over-time.serverTimezone' => 'Fuseau horaire du serveur (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Votre fuseau horaire (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'Nous vous recommandons de comparer le graphique de distribution des erreurs avec %%link%% dans Monitoring.',
    'distribution-over-time.resourceUsageCharts' => 'Graphique d\'utilisation des ressources',

    'report.title' => 'Rapport de la dernière vérification',
    'report.groupByWebsites' => 'Regroupé par sites Web',
    'report.groupByProblems' => 'Par type de problème',
    'report.columnWebsite' => 'Site Web',
    'report.columnStatus' => 'Résultat de la dernière vérification',
    'report.columnProblem' => 'Problème',
    'report.columnAppearedOn' => 'Date d\'apparition',
    'report.serverWideName' => 'Problèmes concernant l\'ensemble du serveur',
    'report.serverWideDescription' => 'Ces problèmes affectent l\'ensemble du serveur et tous les sites Web sur le serveur.',
    'report.statusProblems' => '{count, plural, one {# problème} other {# problèmes}}',
    'report.statusSuccess' => 'Tout va bien',
    'report.serverWide' => 'Tout le serveur',
    'report.appearedOn' => '{count, plural, one {# site Web} other {# sites Web}}',
    'report.actionPreview' => 'Afficher l\'aperçu du site Web',
    'report.actionManage' => 'Gérer le site Web',
    'report.actionLogs' => 'Journaux du site Web',
    'report.problemsList' => '{count, plural, one {# problème trouvé} other {# problèmes trouvés}}',
    'report.serverWideProblemsList' => 'Détection de {count, plural, one {# problème affectant tout le serveur} other {# problèmes affectant tout le serveur}}',
    'report.groupByWebsitesTotal' => '{totalRows, plural, one {# élément} other {# éléments}} au total',
    'report.searchWebsite' => 'Trouver des sites Web...',
    'report.searchProblem' => 'Détecter les problèmes...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# problème} other {# problèmes}} sur {websitesCount, plural, one {# site Web} other {# sites Web}}',
    'report.noProblemsTitle' => 'Aucun problème détecté sur {websitesCount, plural, one {# site Web} other {# sites Web}}',
    'report.noProblemsDescription' => 'Apparemment, vos sites Web fonctionnent bien, bravo !',

    'new-check.title' => 'Exécution d\'une nouvelle vérification manuelle',
    'new-check.description' => '%%selected%% sur %%total%% sites Web sont sélectionnés',
    'new-check.depth' => 'Degré de vérification',
    'new-check.hours' => 'dernières heures',
    'new-check.websites' => 'Sites Web à vérifier',
    'new-check.buttonSave' => 'Vérifier',
    'new-check.buttonCancel' => 'Annuler',
    'new-check.search' => 'Trouver des sites Web...',
    'new-check.manualCheckProblems' => 'Sites Web avec problèmes lors de la dernière vérification manuelle',
    'new-check.regularCheckProblems' => 'Sites Web avec problèmes lors de la dernière vérification standard',
    'new-check.allWebsites' => 'Tous les sites Web',
];