<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: wysłano zbyt duży nagłówek podczas odczytywania nagłówka odpowiedzi"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Wkrótce będzie gotowy.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Wewnętrzny błąd serwera: opcja FollowSymLinks nie jest tutaj dozwolona”',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Wkrótce będzie gotowy.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "serwer osiągnął ustawienie max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptomy</h4><ul><li><p>Witryny, które obsługują moduł obsługi PHP ustawiony jako <strong>aplikację FPM obsługiwaną przez Apache</strong> lub <strong>aplikację FPM application obsługiwaną przez nginx</strong> w <strong>Domeny</strong> &gt; <strong>example.com</strong> &gt; <strong>Ustawienia PHP</strong> doświadczają jednego z następujących problemów:</p><ul><li><p>powolne ładowanie</p></li><li><p>brak dostępności (całkowite lub okresowe) z błędem 50x w przeglądarce:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Następująca wiadomość błędu pojawia się w logach PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (gdzie <em>XX</em> jest wersją PHP używaną przez witryny):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>Wiadomość powyższa idzie zazwyczaj w parze z następującym błędem:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Jeśli nginx jest włączony na serwerze, jedna z następujących wiadomości błędu może się pojawić w dzienniku błędów domeny <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Parametr PHP-FPM <code>pm.max_children</code> został osiągnięty dla witryny lub witryn.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Zwiększ limit pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Zwiększ limit <code>pm.max_children</code> dla wybranych domen:</p><ol><li><p>Podłącz serwer Pleska przez <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Znajdź domeny dotknięte problemem, używając poniższej komendy:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Uwaga:</strong> Numer po lewej wskazuje, ile razy limit <code>pm.max_children</code> został osiągnięty przez witrynę.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Zaloguj się do Pleska</a>.</p></li><li><p>Przejdź do <strong>Domeny</strong> &gt; <strong>example.com</strong> &gt; <strong>Ustawienia PHP</strong> &gt; <strong>Ustawienia PHP-FPM</strong>.</p></li><li><p>Zwiększ wartość <code>pm.max_children</code> dla domeny i zastosuj zmiany. Zwiększ tę wartość dla wszystkich domen z listy kroku nr 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Za dużo otwartych plików"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx nie był w stanie uruchomić lub przeładować serwera Plesk: Zbyt dużo otwartych plików</p><h4>Symptomy</h4><ul><li><p>Usługa nginx nie uruchomiła się z następującym błędem w pliku <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Niektóre lub wszystkie witryny przestały być dostępne</p></li><li><p>Ostrzeżenie jest widoczne w <strong>Narzędzia &amp; Ustawienia &gt; Diagnoza &amp; Naprawa</strong>:</p><pre style="white-space: pre-wrap;">Sprawdzanie, czy wartość ULIMIT dla N domen została osiągnięta na serwerze. Problem z domyślnym ograniczeniem nginx w zakresie liczby otwartych plików jest możliwy w tym wypadku</pre></li><li><p>Aplikacje NodeJS i Ruby pokazują błąd 502 Bad Gateway, kiedy wykonują niektóre zadania Pleska, jak na przykład tworzenie domen, subskrypcji, zmian w Apache lub Nginx, etc:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>Po <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">zainstalowaniu nowego certyfikatu dla domeny</a>, poprzedni jest wciaż widoczny w przeglądarce, chociaż właściwy certyfikat jest wybrany na stronie <strong>Domeny &gt; example.com &gt; Ustawienia Hostingu</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Wirtualny host Nginx otwiera 4 pliki logów dla każdgo wirtualnego hosta z fizycznym hostingiem:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>W rezultacie maksymalna liczba otwartych plików jest przekroczona przez serwer nginx z powodu zbyt dużej liczby domen (zazwyczaj więcej niż 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Zwiększ limit otwartych plików',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Uwaga:</strong> Uruchomienie <code>websrv_ulimits</code> bez opcji <strong>--no-restart</strong> zainicjuje przebudowę plików konfiguracyjnych stron dla wszystkich domen i spowoduje znaczącą przerwę w dostępie do dużej liczby hostowanych serwisów.<br><br>Wykonaj tę komendę podczas przerwy administracyjnej.</div><p>Jest dobrą praktyką, by ustawić limit otwartych plików co najmniej na większy niż <strong>liczba domen w Plesk * 16</strong>. W poniższym przykładzie pokazujemy, jak ustawić limit na 4096:</p><ol><li><p>Podłącz się do serwera przez <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Ustaw limit otwartych plików na 4096 zarówno dla Apache, jak i Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Zrestartuj Apache i nginx w <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Narzędzia &amp; Ustawienia &gt; Zarządzanie usługami</strong>, aby zastosować zmiany.</p></li><li><p>Sprawdź, czy \'Max open files limit\' został ustawiony właściwie po tym, jak usługi sieciowe zostaną zrestartowane:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Jeśli powyższe rozwiązanie nie pomoże, ustaw limit poprzez <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Za duża treść odpowiedzi"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Wkrótce będzie gotowy.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Odmowa dostępu z kodem 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Objawy</h4><ul><li><p>ModSecurity jest instalowany i włączany w <strong>Narzędzia i ustawienia > Zapora aplikacji internetowej (ModSecurity) > Tryb zapory aplikacji internetowej > Wł.</strong>.</p></li><li>Witryna hostowana w Plesku nie ładuje się. Nie można wykonywać operacji na stronie internetowej, takich jak zarządzanie WordPress, dostęp do poczty internetowej lub dostęp do pliku <code>robots.txt</code>. Przeglądarka może wyświetlić jeden z następujących błędów:
<pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Wiadomość błędu ModSecurity jak ta poniżej pojawia się w pliku logów <code>/var/log/modsec_audit.log</code> na na stronie Logi w Plesku (<strong>Domeny</strong> &gt; <strong>example.com</strong> &gt; <strong>Logi</strong>): <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web Application Firewall jest włączony z bardzo restrykcyjnym zestawem reguł, takim jak OWASP, Comodo lub niestandardowym zestawem reguł, takim jak Imunify360. Restrykcyjne zestawy reguł mogą blokować niektóre operacje na stronie.</p><p><Strong>Uwaga:</strong> Błąd ModSecurity może wskazywać na atak na Twój serwer. Skorzystaj z poniższych rozwiązań tylko wtedy, gdy masz pewność, że ModSecurity blokuje prawidłowe korzystanie z Twojej witryny.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Wyłącz regułę ModSecurity ustawioną według identyfikatora lub tagu',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Znajdź identyfikator reguły, która blokuje legalne korzystanie z Twojej witryny. Identyfikatory można znaleźć w komunikatach o błędach w pliku logów <code>/var/log/modsec_audit.log</code>. Identyfikator jest liczbą całkowitą w cudzysłowie z prefiksem <code>id</code> w nawiasach kwadratowych, np. <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">Wyłącz określone zestawy reguł w Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Przełącz się na inny zestaw reguł ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Przełącz się na mniej restrykcyjny zestaw reguł ModSecurity, na przykład „Atomic ModSecurity Ruleset”. Aby to zrobić, przejdź do <strong>Narzędzia i ustawienia</strong> > <strong>Zapora aplikacji internetowej (ModSecurity)</strong> > <strong>Ustawienia</strong>, wybierz <strong>Atomic Standard</strong>, a następnie kliknij <strong>OK</strong>, aby zastosować zmiany.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Wewnętrzny błąd serwera 500: wyczerpano dozwolony rozmiar pamięci XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Objawy</h4><ul><li><p>Witryna hostowana w Plesku jest niedostępna:</p><pre>500 Internal Server Error</pre></li><li><p>W dzienniku witryny wyświetlany jest następujący błąd:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/try.me/httpdocs/somethingBig.php on line 3</pre></li></ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Witryna nie ma wystarczającej ilości pamięci przydzielonej do przetworzenia.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Zwiększ limit pamięci strony internetowej',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">Przeczytaj artykuł KB i postępuj zgodnie z instrukcjami</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "obowiązuje ograniczenie open_basedir"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Objawy</h4><ul><li><p>Strona nie jest dostępna z jednym z następujących błędów w przeglądarce internetowej:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Na stronie dzienników domeny pojawia się następujący komunikat o błędzie (<strong>Domeny</strong> > <strong>example.com</strong> > <strong>Logi</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Skrypt PHP próbuje uzyskać dostęp do katalogu, do którego dostęp nie jest dozwolony. To ograniczenie jest definiowane przez dyrektywę PHP <code>open_basedir</code> indywidualnie dla każdej domeny. Domyślnie <code>open_basedir</code> umożliwia dostęp do katalogów głównych dokumentów <code>tmp</code> i domeny, jak również do domyślnej ścieżki sesji systemu.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Dodaj dodatkową ścieżkę do dyrektywy open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">Przeczytaj artykuł KB i postępuj zgodnie z instrukcjami</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Wyłącz dyrektywę open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Przejdź do strony <strong>Domeny &gt example.com &gt Ustawienia PHP</strong> i ustaw dyrektywę <code>open_basedir</code> na "brak".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: klient odrzucony przez konfigurację serwera"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Objawy</h4><ul><li><p>Witryna wyświetla błąd podobny do następującego:</p><pre>Błąd serwera 403<br>Zabroniony</pre></li> <li><p>Plik dziennika <code>/var/www/vhosts/system/example.com/logs/error_log</code> zawiera następujące błędy:</p><pre>AH01797: odmowa klienta według konfiguracji serwera: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Niestandardowa konfiguracja Apache nie pozwala na dostęp do strony internetowej.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Sprawdź konfigurację serwera i pliki .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Przeczytaj artykuł KB i postępuj zgodnie z instrukcjami</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Nie można uzyskać dostępu do katalogu stron internetowych w Plesku: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Objawy</h4><ul><li><p>Nie można uzyskać dostępu do określonej lokalizacji witryny, na przykład <code>http://example.com/some_folder</code>. Występuje następujący błąd: </p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The following error appears in the <code>/var/www/vhosts/example.com/logs/error_log<code/> file:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Żądany katalog nie zawiera plików indeksu lub przeglądanie katalogów nie jest włączone.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Dodaj plik indeksu do katalogu',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Przeczytaj artykuł KB i postępuj zgodnie z instrukcjami</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Włącz przeglądanie katalogów',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Przeczytaj artykuł KB i postępuj zgodnie z instrukcjami</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Nie można uzyskać dostępu do katalogu witryny w Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Objawy</h4><ul><li><p>Nie można uzyskać dostępu do określonej lokalizacji witryny, na przykład, <code>http://example.com/some_folder</code>. Występuje następujący błąd:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The following error appears in the <code>/var/www/vhosts/example.com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Żądany katalog nie zawiera plików indeksu lub przeglądanie katalogów nie jest włączone.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Dodaj plik indeksu do katalogu',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Przeczytaj artykuł KB i postępuj zgodnie z instrukcjami</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Włącz przeglądanie katalogów',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Przeczytaj artykuł KB i postępuj zgodnie z instrukcjami</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "serwer osiągnął ustawienie MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Wkrótce będzie gotowy.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Limit treści żądania PHP "klient zamierza wysłać zbyt dużą treść"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Wkrótce będzie gotowy.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Limit treści żądania PHP "klient zamierza wysłać zbyt dużą treść"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Wkrótce będzie gotowy.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sesje PHP "503 Internal Server Error” lub "Nie udało się odczytać danych sesji"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Wkrótce będzie gotowy.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: nie można sprawdzić pliku htaccess, upewnij się, że jest możliwy do odczytu"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Objawy</h4><ul><li><p>Witryna hostowana w Plesku nie działa:</p><pre>Nie masz uprawnień dostępu na tym serwerze.<br> Ponadto, podczas próby użycia ErrorDocument do obsługi żądania wystąpił błąd 403 Forbidden.</pre><p>Zamiast powyższego błędu możesz również zobaczyć pustą stronę.</p></li><li><p>Błąd domeny podczas logowania <strong>Domeny &gt example.com &gt Logi</strong> zawiera następujący:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Nieprawidłowe uprawnienia do plików lub folderów domeny.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Napraw uprawnienia do zawartości witryny',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">Przeczytaj artykuł KB i postępuj zgodnie z instrukcjami</a>.</p></li></ol>',
];