<?xml version="1.0" encoding="utf-8"?>
<!-- Copyright 1999-2022. Plesk International GmbH. All rights reserved. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="text" indent="yes"/>
    <xsl:strip-space  elements="*"/>
    <xsl:variable name="newline">
               <xsl:text>
</xsl:text>
    </xsl:variable>
    <xsl:variable name="tab">
        <xsl:text>      </xsl:text>
    </xsl:variable>
    <xsl:template match="message">
        <xsl:value-of select="$newline"/>
        <xsl:choose>
            <xsl:when test="@severity='error'">ERROR</xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="@severity='warning'">WARNING</xsl:when>
                    <xsl:otherwise>INFO</xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>:<xsl:value-of select="$tab"/>(<xsl:if test="local-name(..)='object'">
        <xsl:value-of select="../@type"/> object '<xsl:value-of select="../@name"/>'</xsl:if>)<xsl:value-of select="$tab"/>
        <xsl:choose>
            <xsl:when test="description[@encoding = 'base64']">@BASE_64_BEGIN@<xsl:value-of select="description"/>@BASE_64_END@</xsl:when>
            <xsl:otherwise>@ESCAPE_VALUE_BEGIN@<xsl:value-of select="description"/>@ESCAPE_VALUE_END@</xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="$newline"/>
        <xsl:apply-templates select="message"/>
        <xsl:value-of select="$newline"/>
    </xsl:template>
</xsl:stylesheet>