<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Podsíť nebo IP adresa',
    'access-network.subnetOrIpAddressHint' => 'Například 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Novinky',
    'admin.announcement-settings.getConsentLoading' => 'Načítání informací o novinkách',
    'admin.announcement-settings.getConsentWarning' => 'Nelze načít stav vaší předplacené služby.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Chtěl bych dostávat novinky od společnosti Plesk. Mohou obsahovat informace související s bezpečností a další technické a všeobecné informace o produktu. Souhlasím a uděluji oprávnění společnosti Plesk ke shromažďování, zpracování a použití svých osobních údajů (e-mailová adresa), včetně přeshraničního zpracování, v souladu s aktuálně platnými zákony na ochranu dat, za účelem zasílání informací o novinkách, buď přímo nebo prostřednictvím služby poskytované 3. stranou. Zrušením zaškrtnutí tohoto políčka odvolávám svůj souhlas a přikazuji společnosti Plesk, aby zastavila odesílání e-mailů a trvale odebrala mé osobní údaje ze svých systémů.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Ano, souhlasím s odběrem svých osobních novinek Plesk. Společnost Plesk International GmbH a její přidružené společnosti mohou ukládat a zpracovávat data, která poskytuji za účelem dodávání novinek na základě dokumentu %%privacyPolicy%%. Kvůli zprávám sestavovaným na míru a nabídkám určeným pro mě může společnost Plesk využívat také další informace k vytváření profilů, např. data využití a uživatelského chování. Ze seznamu adresátů se mohu kdykoli odhlásit.',
    'admin.announcement-settings.privacyPolicy' => 'Zásady ochrany osobních údajů ve společnosti Plesk',
    'admin.announcement-settings.noConsent' => 'Odhlaste mě z odběru novinek Plesk.',
    'admin.announcement-settings.reportConsentError' => 'Nastavení pro načítání informací z prostředí Plesk nelze uložit: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Je nám líto, ale v tuto chvíli nelze váš profil aktualizovat. Zkuste to prosím později.',
    'admin.announcement-settings.invalidConsentType' => "Neznámý typ souhlasu: '%%type%%'",
    'admin.announcement-settings.retry' => 'Opakovat',
    'admin.announcement-settings.consentGivenInfo' => 'Doufáme, že si s našimi obecnými novinkami v podobě zpravodaje Plesk náležitě užijete. Můžeme vám poskytnout dokonalejší alternativu – osobní, na míru sestavovaný zpravodaj s užitečnými informacemi a praktickými tipy na základě vašich požadavků. Chcete-li dostávat své osobní novinky Plesk, vyberte nejprve níže uvedené prohlášení a klikněte na OK.',
    'admin.announcement-settings.consentNotGivenInfo' => 'Zdá se, že nejste přihlášeni k odběru našeho všeobecného zpravodaje. Můžeme vám poskytnout lepší alternativu – osobní, na míru sestavovaný zpravodaj novinek s užitečnými informacemi a tipy na základě vašich požadavků.',

    'admin.personal-info.title' => 'Úpravy profilu správce',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Nastavení prostředí Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Nastavení',

    'admin-alias.login' => 'Uživatelské jméno',
    'admin-alias.password' => 'Heslo',
    'admin-alias.passwordConfirmation' => 'Potvrdit heslo',
    'admin-alias.email' => 'E-mail',
    'admin-alias.contact' => 'Jméno kontaktu',
    'admin-alias.comments' => 'Komentáře',
    'admin-alias.emptyLogin' => 'Zadejte přihlašovací jméno.',
    'admin-alias.loginTooLong' => 'Přihlašovací jméno je delší než 20 znaků.',
    'admin-alias.emptyEmail' => 'Zadejte e-mailovou adresu.',
    'admin-alias.emptyContactName' => 'Zadejte jméno kontaktu.',
    'admin-alias.contactNameTooLong' => 'Jméno kontaktu je delší než 255 znaků.',
    'admin-alias.emptyPassword' => 'Zadejte heslo.',
    'admin-alias.commentsTooLong' => 'Komentář je delší než 255 znaků.',
    'admin-alias.emailActivation' => 'Aktivovat účet prostřednictvím e-mailu',
    'admin-alias.simplePanel' => 'Povolit Omezený režim',
    'admin-alias.simplePanelHint' => 'Tuto možnost vyberte, chcete-li omezit počet akcí, které může další správce podniknout v prostředí Plesk. Chcete-li změnit dostupnost akcí, přejděte na odkaz %%link%%.',
    'admin-alias.simplePanelLink' => 'Nástroje a nastavení> Nastavení Omezený režim',
    'admin-alias.lockPowerUser' => 'Vynutit režim zobrazení Power User (Zkušený uživatel) pro dalšího správce',
    'admin-alias.lockPowerUserHint' => 'Schopnost omezit zobrazení pro dalšího správce prostředí Plesk (žádný přístup k zákazníkům, distributorům a plánům služeb).',

    'admin-info.plesk-settings.multiplyLogin' => 'Povolit více relací pod tímto účtem',
    'admin-info.plesk-settings.adminLanguage' => 'Jazyk rozhraní správce',
    'admin-info.plesk-settings.password' => 'Heslo',
    'admin-info.plesk-settings.passwordConfirmation' => 'Potvrdit heslo',

    'admin-panel.form.contact-info.contactName' => 'Jméno kontaktu',
    'admin-panel.form.contact-info.emptyContactName' => 'Zadejte jméno kontaktu.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Jméno kontaktu je příliš dlouhé (je povoleno maximálně %max% symbolů).',
    'admin-panel.form.contact-info.email' => 'E-mailová adresa',
    'admin-panel.form.contact-info.emptyEmail' => 'Zadejte e-mailovou adresu.',
    'admin-panel.form.contact-info.companyName' => 'Název společnosti',
    'admin-panel.form.contact-info.longCompanyName' => 'Název společnosti je příliš dlouhý (je povoleno maximálně %max% symbolů).',
    'admin-panel.form.contact-info.phone' => 'Telefonní číslo',
    'admin-panel.form.contact-info.longPhone' => 'Toto telefonní číslo je příliš dlouhé (je povoleno maximálně %max% symbolů).',
    'admin-panel.form.contact-info.fax' => 'Faxové číslo',
    'admin-panel.form.contact-info.imNumber' => 'Rychlé zasílání zpráv',
    'admin-panel.form.contact-info.longFax' => 'Toto faxové číslo je příliš dlouhé (je povoleno maximálně %max% symbolů).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Zadané telefonní číslo je neplatné.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Faxové číslo je nesprávné.',
    'admin-panel.form.contact-info.address' => 'Adresa',
    'admin-panel.form.contact-info.longAddress' => 'Toto adresa je příliš dlouhá (je povoleno maximálně %max% symbolů).',
    'admin-panel.form.contact-info.city' => 'Město',
    'admin-panel.form.contact-info.longCity' => 'Název města je příliš dlouhý.',
    'admin-panel.form.contact-info.shortCity' => 'Název města je příliš krátký.',
    'admin-panel.form.contact-info.state' => 'Stát/Oblast',
    'admin-panel.form.contact-info.postalCode' => 'PSČ',
    'admin-panel.form.contact-info.country' => 'Země',
    'admin-panel.form.contact-info.additionalInfo' => 'Doplňující údaje',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Pouze Prostý text: všechny značky jazyka HTML budou ignorovány.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Uživatel s touto e-mailovou adresou již v systému existuje.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Předplacená služba',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Vlastnosti webu zajištěného současně s předplatným.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Vlastnosti webu zajištěného současně s předplatným.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Vlastnosti webu zajištěného současně s předplatným.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Vytvořit předplatné pro zákazníka',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Zrušte zaškrtnutí tohoto políčka, pokud momentálně nechcete vytvořit předplatné hostitelské služby nebo nastavit webové stránky pro zákazníka. Bez předplatného se zákazník nebude moci přihlásit do Panelu zákazníka.',
    'admin-panel.form.domain-info-section.domainName' => 'Název domény',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Musíte zadat název domény.',
    'admin-panel.form.domain-info-section.shared' => 'Sdílený',
    'admin-panel.form.domain-info-section.exclusive' => 'vyhrazený',
    'admin-panel.form.domain-info-section.userName' => 'Uživatelské jméno',
    'admin-panel.form.domain-info-section.userNameHint' => 'Účet uživatele systému používaný ke správě souborů a složek webů vytvořených v rámci předplatného.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Musíte zadat jméno uživatele.',
    'admin-panel.form.domain-info-section.password' => 'Heslo',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Musíte zadat heslo.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Potvrdit heslo',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Adresa IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Adresa IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Žádné',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Další nastavení předplatného',
    'admin-panel.form.domain-info-section.credentials' => 'Pověření uživatele systému',
    'admin-panel.form.domain-info-section.credentialsHint' => 'pro přístup k souborům hostovaným na FTP a SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'pro přístup k souborům hostovaným na FTP a RDP',

    'admin-panel.form.login-info.userName' => 'Uživatelské jméno',
    'admin-panel.form.login-info.emptyUserName' => 'Zadejte přihlašovací jméno.',
    'admin-panel.form.login-info.password' => 'Heslo',
    'admin-panel.form.login-info.emptyPassword' => 'Zadejte heslo.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Zopakovat heslo',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Změna hesla také změní interní heslo k e-mailové adrese',
    'admin-panel.form.login-info.emailActivation' => 'Aktivovat účet prostřednictvím e-mailu',
    'admin-panel.form.login-info.emailActivationHint' => 'Vytvořený účet je neaktivní, dokud si ho uživatel nezaktivuje v odkazu odeslaném emailem nebo správce nezaktivuje účet ručně.',

    'admin-panel.form.subscription-info-section.subscription' => 'Předplacená služba',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Plán služby',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Aktuální plán služby',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Nový plán služby',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Jednoduchý plán',
    'admin-panel.form.subscription-info-section.none' => 'Žádné',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Doplňky',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Po změně přiřazení plánu pokračujte na přizpůsobení parametrů předplatného. Pamatujte si, že tato akce uzamkne předplatné před synchronizací.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Po jeho vytvoření pokračujte v přizpůsobení parametrů předplatného.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Po vytvoření zákazníka pokračujte v přizpůsobení parametrů předplatného.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Po jeho vytvoření pokračujte v přizpůsobení parametrů předplatného. Pamatujte si, že tato akce uzamkne předplatné před synchronizací.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Pamatujte si, že tato akce uzamkne předplatné před synchronizací.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Přidat odběr',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Nelze synchronizovat předplatné s plánem služeb. Následující nastavení předplatného je v konfliktu s plánem služeb: %%problems%%.',

    'app.configure.otherSettings' => 'Ostatní',
    'app.configure.passwordConfirmation' => 'Potvrdit heslo',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Vynutit aktualizace pro všechny nainstalované aplikace',
    'app.update-settings.forceUpdatesHint' => 'Jakmile budou aktualizace k dispozici, všechny aplikace zákazníků budou aktualizovány automaticky. Zákazníci nebudou moci vypnout automatické aktualizace pro své aplikace. Varování: tuto možnost použijte uvážlivě, protože aktualizace mohou významně ovlivnit funkčnost aplikace. Například rozšíření aplikace může zastavit činnost jiné verze aplikace.',
    'app.update-settings.suggestUpdates' => 'Zapněte možnost "Automaticky aktualizovat tuto aplikace" jako výchozí',
    'app.update-settings.suggestUpdatesHint' => 'Pro nově nainstalované aplikace bude možnost "Automaticky aktualizovat tuto aplikaci" v nastavení aplikace zapnuta.',

    'backup.server-settings.rotation' => 'Maximální počet úplných záložních souborů, které lze uložit (včetně ručních a naplánovaných záloh)',
    'backup.server-settings.rotationDescription' => 'Uživatelé mohou ukládat mnoho úplných záloh na úložiště serveru. Pokud počet úplných záloh již v úložišti překročí limit, budou zachovány pouze nejnovější zálohy. Přírůstkové zálohy nejsou ovlivněny.',
    'backup.server-settings.maxProcesses' => 'Maximální počet současně spuštěných naplánovaných zálohování',
    'backup.server-settings.niceScheduled' => 'Spustit naplánované zálohování s nízkou prioritou',
    'backup.server-settings.niceScheduledPriority' => 'Priorita',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Zadejte hodnotu mezi 1 a 19 včetně, přičemž vyšší číslo znamená nižší prioritu.',
    'backup.server-settings.niceScheduledIoPriority' => 'Priorita vstup/výstup',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Zadejte hodnotu mezi 0 a 7 včetně, přičemž vyšší číslo znamená nižší prioritu.',
    'backup.server-settings.niceAlways' => 'Všechny zálohovací procesy spouštějte s nízkou prioritou',
    'backup.server-settings.niceAlwaysPriority' => 'Priorita',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Zadejte hodnotu mezi 1 a 19 včetně, přičemž vyšší číslo znamená nižší prioritu.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Priorita vstup/výstup',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Zadejte hodnotu mezi 0 a 7 včetně, přičemž vyšší číslo znamená nižší prioritu.',
    'backup.server-settings.compressionLevel' => 'Úroveň komprese',
    'backup.server-settings.compressionLevelNoCompression' => 'Žádná komprese',
    'backup.server-settings.compressionLevelFastest' => 'Nejrychlejší',
    'backup.server-settings.compressionLevelFast' => 'Rychlé',
    'backup.server-settings.compressionLevelNormal' => 'Normální',
    'backup.server-settings.compressionLevelMaximum' => 'Maximum',
    'backup.server-settings.freeSpaceRequired' => 'Zálohu spusťte pouze tehdy, pokud má váš server zadané množství volného místa na disku (v megabajtech)',
    'backup.server-settings.checkBackupDiskSpace' => 'Zálohování spusťte pouze tehdy, pokud má váš server dostatek volného místa na disku',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Použijte nativní funkci zálohování MS SQL (u vzdálené databáze se ujistěte, že jste pod položkou Nástroje a nastavení> Databázové servery nakonfigurovali nastavení zálohování vzdáleného serveru MS SQL)',
    'backup.server-settings.localFtpRestriction' => 'Umožnit instalaci úložiště záloh na místní server',
    'backup.server-settings.backupSecuritySettings' => 'Nastavení zabezpečení zálohy',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Uložit zálohy do úložiště serveru, pokud se přenos na vzdálené úložiště nezdaří',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Ruční a naplánované zálohy určené pro vzdálené úložiště budou uloženy na úložišti místního serveru, pokud se nahrávání na vzdálené úložiště nezdaří. Uživatelé musí mít oprávnění k ukládání záloh na úložiště serveru.',

    'change-current-subscription.hint' => 'Zde změníte přidružení s plány služeb pro předplatné. Všimněte si, že pokud jako nový plán služeb vyberete \\&amp;apos;none\\&amp;apos;, předplacená služba se odpojí od plánu služeb a stane se z ní \\&amp;apos;Custom\\&amp;apos;.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Nelze synchronizovat předplatné s plánem služeb. Následující nastavení předplatného je v konfliktu s plánem služeb: %%problems%%.',

    'change-password.oldPassword' => 'Staré heslo',
    'change-password.password' => 'Nové heslo',
    'change-password.passwordConfirmation' => 'Potvrdit heslo',
    'change-password.oldPasswordIsIncorrect' => 'Staré heslo je chybné. Zkuste to znovu.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Nelze najít další účet správce.',
    'change-password.warningAboutAdminPasswordSyntax' => "Heslo musí mít délku %%min%% až %%max%% znaků a nesmí obsahovat přihlašovací jméno.\nV heslu nepoužívejte uvozovky, mezery a znaky národních abeced.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "V heslu nepoužívejte uvozovky, mezery, středníky a znaky národních abeced.\nHeslo musí mít délku %%min%% až %%max%% znaků a nesmí obsahovat přihlašovací jméno.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Zásada nabídky',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Překročení nabídky je povoleno',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Překročení nabídky umožní prodejci prodat větší množství prostředků, než bylo přiděleno plánem. Pokud je překročení nabídky povoleno, prodejce se místo výchozího přidělení prostředků řídí skutečným využitím prostředků.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Překročení nabídky není povoleno',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Pokud není překročení nabídky povoleno, prodejce může prodat pouze tolik prostředků, kolik mu bylo zpočátku přiděleno plánem, bez ohledu na to, kolik těchto prostředků se skutečně využívá.',

    'change-reseller-subscription.hint' => 'Zde změníte přidružení s plánem služeb pro předplatné prodejce. Všimněte si, že pokud jako nový plán služeb vyberete \\&amp;apos;none\\&amp;apos;, předplacená služba se odpojí od plánu služeb a stane se z ní \\&amp;apos;Custom\\&amp;apos;.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Nelze synchronizovat předplatné s plánem služeb. Následující nastavení předplatného je v konfliktu s plánem služeb: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Nový plán',
    'change-reseller-subscription.oldSubscription' => 'Aktuální tarif',
    'change-reseller-subscription.none' => 'žádná',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Předplacená služba přidružená k plánu služeb byla aktualizována.',
    'change-reseller-subscription.customizeSubscription' => 'Po přidružení předplacené služby k aktualizovanému plánu služeb pokračujte v přizpůsobení jejích parametrů. Pamatujte si, že tato akce uzamkne předplatné před synchronizací.',

    'change-subscription.hint' => 'Zde změníte přidružení s plány služeb pro vybrané předplacené služby.',
    'change-subscription.selectPlanLegend' => 'Plán služby',
    'change-subscription.selectPlanDescription' => 'Chcete-li přepnout na jiný plán služeb, vyberte nový plán ze seznamu. Všimněte si, že pokud vyberete \\&amp;apos;none\\&amp;apos;, předplacené služby se odpojí od plánu služeb a stane se z nich \\&amp;apos;Custom\\&amp;apos;.',
    'change-subscription.servicePlan' => 'Nový plán služby',
    'change-subscription.selectAddonPlansLegend' => 'Rozšířené plány',
    'change-subscription.selectAddonPlansDescription' => 'Přidat nebo odebrat rozšířené plány.',
    'change-subscription.noChange' => 'beze změny',
    'change-subscription.none' => 'žádná',
    'change-subscription.add' => 'přidat',
    'change-subscription.del' => 'odebrat',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Podsíť nebo IP adresa',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Například 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Přístup k prostředí Plesk s oprávněním správce',
    'control-panel-access.settings.policyAllow' => 'Povoleno, kromě sítí v seznamu.',
    'control-panel-access.settings.policyDeny' => 'Odepřeno ze sítí, které nejsou v seznamu.',

    'create-subscription.title' => 'Přidání předplatného',
    'create-subscription.titleOwn' => 'Přidání vašeho vlastního předplatného',
    'create-subscription.poolIsEmpty' => 'Nelze vytvořit předplatné, protože v prostředí Plesk nejsou k dispozici žádné sdílené IP adresy a žádné volné vyhrazené IP adresy.',
    'create-subscription.infoNewSubscriptionCreated' => 'Byla vytvořena předplacená služba %%name%%.',
    'create-subscription.createBeforeAppInstall' => 'Abyste mohli nainstalovat aplikaci, musíte mít předplacenou službu.',

    'customer.hint' => 'Toto je místo, kde registrujete nového zákazníka do vašich služeb hostování. Tímto přihlášením vytvoříte v prostředí Plesk účet zákazníka a předplatné k jednomu ze svých plánů hostování, a případně doplňky. Předplatné může také poskytnout úplnou vlastní sadu prostředků a služeb nesvázaných s žádnými plány - z tohoto důvodu vyberte vedle Plánu služeb položku \\&amp;apos;None\\&amp;apos;.',
    'customer.contactInfoSection' => 'Kontaktní údaje',
    'customer.additionalInfoSection' => 'Doplňující údaje o zákazníkovi',
    'customer.accessToPanelSection' => 'Přístup k prostředí Plesk',
    'customer.contactInfoSectionHint' => 'Zadat kontaktní údaje zákazníka.',
    'customer.accessToPanelSectionHint' => 'Pověření, která zákazník použije pro přístup ke svému panelu zákazníka.',
    'customer.unableCreateSubscription' => 'Předplatné nelze vytvořit: %%reason%%',
    'customer.poolIsEmpty' => 'Fond IP adres je prázdný',
    'customer.buttonOk' => 'Přidat zákazníka',

    'database-settings.dbPrefixRadio' => 'Přidat předponu a podtržítko na začátek názvů databáze',
    'database-settings.dbPrefixNone' => 'Žádné',
    'database-settings.dbPrefixUsername' => 'Uživatelské jméno',
    'database-settings.dbPrefixExternalId' => 'Externí ID předplatného',
    'database-settings.dbPrefixCustom' => 'Vlastní předpona',
    'database-settings.dbUserPrefixRadio' => 'Přidat předponu a podtržítko na začátek jmen uživatelů databáze',
    'database-settings.dbUserPrefixHint' => 'Jména uživatelů databáze budou vypadat jako <prefix>_<database_user_name>. Kvůli omezení délky uživatelských jmen lze <prefix> zkracovat.',
    'database-settings.grantAlterDatabase' => 'Udělit oprávnění ALTER DATABASE pro všechny uživatele databáze Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Novým a stávajícím uživatelům bude poskytnuto toto oprávnění.',
    'database-settings.enableBackupOperator' => 'Povolit členskou roli db_backupoperator role pro všechny uživatele databáze Microsoft SQL Server',
    'database-settings.enableBackupOperatorHint' => 'Noví a stávající uživatelé budu členy této role.',
    'database-settings.aclRadio' => 'Výchozí nastavení pro vzdálený přístup uživatelů databáze MySQL',
    'database-settings.aclLocalhost' => 'Povolit pouze místní připojení',
    'database-settings.aclAny' => 'Povolit vzdálené připojení z libovolného hostitele',
    'database-settings.aclCustom' => 'Povolit vzdálené připojení od',
    'database-settings.aclDescription' => 'Toto nastavení upravuje pouze uživatelská oprávnění. Abyste aktivovali vzdálený přístup k lokálnímu serveru MySQL, vyberte odpovídající možnost v %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Lokální nastavení MySQL',
    'database-settings.example' => "Například:",
    'database-settings.aclExampleDescription' => "Zadané hostitelé mají povolen přístup do databáze jménem tohoto uživatele.",
    'database-settings.dbPrefixAlphaNumeric' => 'V předponě mohou být pouze alfanumerické znaky a podtržítka.',

    'dns.add-acl-record.description' => 'Přidat IP adresu serveru DNS, který má povoleno přijmout kopii zóny DNS.',
    'dns.add-acl-record.ipAddress' => 'IP adresa',
    'dns.add-acl-record.ipAddressWithMask' => 'IP adresa/maska',

    'dns.settings.recursion' => 'Rekurzivní dotazy DNS',
    'dns.settings.recursionOn' => 'Povolit pro všechny požadavky',
    'dns.settings.recursionLocal' => 'Povolit pouze pro místní požadavky',
    'dns.settings.recursionLocalnets' => 'Povolit požadavky pouze z místní sítě',
    'dns.settings.recursionOff' => 'Odmítnout všechny požadavky',
    'dns.settings.customConfiguration' => 'Další nastavení DNS',
    'dns.settings.customConfigurationPlaceholder' => 'Zde zadaná nastavení přepíší nastavení platná pro celý server.',
    'dns.settings.customConfigurationHint' => 'Pokud nemůžete najít konkrétní nastavení, přidejte jej do pole za využití syntaxe z named.conf.',
    'dns.settings.customConfigurationExample' => 'Abyste například skryli název hostitele serveru DNS, přidejte následující řádek: ',
    'dns.settings.restoreDefaultButton' => 'Použít výchozí nastavení',

    'dns.template.synchronize-done' => 'Šablona zóny DNS byla úspěšně použita.',
    'dns.template.synchronize-error' => 'Šablona zóny DNS nebyla použita na některé zóny DNS.',
    'dns.template.synchronize-progress' => 'Používání šablonu zóny DNS.',

    'domain-restriction.name' => 'Název domény',
    'domain-restriction.nameDescription' => 'Pomocí symbolu hvězdičky (*) můžete zadat vzor zástupných znaků. Například *.priklad.cz',
    'domain-restriction.domainAlreadyExists' => 'Zadaný název domény je již v seznamu.',

    'event-handler.eventLabel' => 'Událost',
    'event-handler.priorityLabel' => 'Priorita',
    'event-handler.userLabel' => 'Uživatel',
    'event-handler.commandLabel' => 'Příkaz',
    'event-handler.commandHint' => 'Nejlepších výsledků dosáhnete, zadáte-li úplnou cestu k souboru skriptu v poli \'command\'. Nedoporučujeme zadávat systémové příkazy, protože nemusí fungovat. Například příkazy s výstupním operátorem přesměrování /&gt; nebo &lt; nebudou fungovat.',
    'event-handler.priorityHighestText' => 'nejvyšší',
    'event-handler.priorityHighText' => 'vysoká',
    'event-handler.priorityNormalText' => 'normální',
    'event-handler.priorityLowText' => 'nízká',
    'event-handler.priorityLowestText' => 'nejnižší',
    'event-handler.priorityCustomText' => 'uživatelská',
    'event-handler.priorityHighestOption' => 'nejvyšší (%%value%%)',
    'event-handler.priorityHighOption' => 'vysoká (%%value%%)',
    'event-handler.priorityNormalOption' => 'normální (%%value%%)',
    'event-handler.priorityLowOption' => 'nízká (%%value%%)',
    'event-handler.priorityLowestOption' => 'nejnižší (%%value%%)',

    'extension.upload.fileUpload' => 'Cesta k souboru s balíčkem rozšíření',

    'external-webmail.hint' => 'Jakmile zaregistrujete další webové rozhraní pošty v prostředí Plesk, bude dostupné vašim zákazníkům: objeví se jako možnost ve vlastnostech \\&amp;apos;Mail\\&amp;apos; v plánech hostování a předplacených službách. Název webového rozhraní pošty se zobrazí v seznamu možností webového rozhraní pošty a adresa URL se otevře po kliknutí na ikonu webového rozhraní pošty vedle poštovní schránky na panelu zákazníka.',
    'external-webmail.name' => 'Název webového rozhraní pošty',
    'external-webmail.url' => 'Adresa URL webového rozhraní pošty',
    'external-webmail.enabled' => 'Dostupná',

    'ftp-settings.generalSection' => 'Obecné',
    'ftp-settings.portRange' => 'Port nebo rozsah portů pro připojení v pasivním režimu FTP',
    'ftp-settings.hintPortRange' => '(výchozí hodnota: %%defaultPortRange%%)',

    'health.upload.hint' => 'Nahrát konfiguraci monitorování stavu serveru. Konfigurace bude použita ihned po nahrání.',
    'health.upload.selectFile' => 'Konfigurační soubor',

    'install-local-package.selectUploadType' => 'Vyberte jednu z následujících položek:',
    'install-local-package.uploadAsFile' => 'Nahrát balíček APS',
    'install-local-package.downloadFromCatalog' => 'Vybrat aplikaci z katalogu aplikací',
    'install-local-package.formInfo' => "Rozšířit seznam dostupných aplikací nahráním nové aplikace nebo přidat aplikaci z katalogu aplikací pro další konfiguraci.",
    'install-local-package.invalidFileExtension' => 'Nahraná aplikace musí být archív ZIP s příponou .zip.',
    'install-local-package.packagesNotSelected' => 'Nebyl vybrán žádný balíček.',
    'install-local-package.visible' => 'Zpřístupnit pro zákazníky',
    'install-local-package.isCommercial' => 'Tato aplikace je komerčního charakteru a vyžaduje nákup licenčního klíče.',
    'install-local-package.visibleDescription' => 'Zpřístupnit aplikaci pro instalaci zákazníkům.',

    'ip-address.addTitle' => 'Přidat IP adresu',
    'ip-address.editTitle' => 'IP adresa %%address%% na rozhraní %%interface%%',
    'ip-address.generalSection' => 'Obecné',
    'ip-address.interface' => 'Rozhraní',
    'ip-address.addressAndSubnetPrefixLength' => 'IP adresa a maska podsítě',
    'ip-address.addressHintIPv4' => 'Například: 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Například: 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Veřejná IP adresa',
    'ip-address.hintPublicIp' => 'Pokud se váš server Plesk nachází za zařízením pro překlad adres NAT, můžete použít veřejnou IP adresu',
    'ip-address.distributionType' => 'IP adresa se šíří jako',
    'ip-address.distributionTypeShared' => 'Sdílené',
    'ip-address.distributionTypeExclusive' => 'Vyhrazený',
    'ip-address.certificate' => 'Certifikát SSL/TLS',
    'ip-address.defaultSite' => 'Výchozí pracoviště',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Nainstalovaný server FTP nepodporuje FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Nainstalovaný server FTP nepodporuje adresy IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'Nelze přidat IP adresu. Toto síťové rozhraní získává IP adresy automaticky.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Poznámka: Pro všechny neznámé domény bude povolena vlastní adresa URL Plesk; rozhraní Plesk se zobrazí místo výchozího webu na adrese „https://%%ip%%/“',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'Síťový adaptér %%interface%% neexistuje. Přesunout tuto IP adresu na jiný síťový adaptér nebo ji odebrat ze seznamu.',
    'ip-address.none' => 'žádná',

    'ip-ban.filter.name' => 'Jméno',
    'ip-ban.filter.content' => 'Obsah',
    'ip-ban.filter.filterExistsError' => 'Filtr s tímto názvem již existuje.',

    'ip-ban.jail.name' => 'Jméno',
    'ip-ban.jail.filter' => 'Filtrovat',
    'ip-ban.jail.filterDescription' => 'Vybrat filtr.',
    'ip-ban.jail.action' => 'Akce',
    'ip-ban.jail.actionDescription' => 'Vybrat akci a přidat ji kliknutím tlačítka.',
    'ip-ban.jail.logPath' => 'Cesta k protokolu',
    'ip-ban.jail.banTime' => 'Interval zákazu IP adresy',
    'ip-ban.jail.maxRetry' => 'Maximální počet neúspěšných pokusů o přihlášení',
    'ip-ban.jail.timeUnit' => 'sekundy',
    'ip-ban.jail.addAction' => 'Přidat',
    'ip-ban.jail.chooseAction' => 'Vybrat:',
    'ip-ban.jail.apache-auth-filter-description' => 'Neúspěšné autorizace Apache (při přihlašování do souboru)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Neúspěšné autorizace Apache (při každém přihlašování)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Neúspěšné autorizace Apache (při přihlašování do syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spamboty a špatné prohledávací moduly',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Chyby ověřování Courier IMAP a POP3',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Chyby ověřování Dovecot IMAP, POP3 a Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Chyby ověřování Dovecot IMAP, POP3 a Sieve (agresivní režim)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Chyby ověřování webového rozhraní pošty Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Webová aplikační brána firewall (ModSecurity) zabezpečení a narušení řízení přístupu',
    'ip-ban.jail.plesk-panel-filter-description' => 'Chyby ověřování prostředí Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Chyby ověřování QMail SMTP',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Chyby ověřování webového rozhraní pošty Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Chyby ověřování WordPress',
    'ip-ban.jail.postfix-filter-description' => 'Chyby klienta Postfix SMTP (včetně RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Chyby klienta Postfix SMTP, chyby ověřování a útoky DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Chyby ověřování Postfix SMTP a SASL',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Útoky DDoS Postfix SMTP',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Chyby klienta a ověřování Postfix SMTP',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Chyby klienta Postfix SMTP (včetně RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Chyby klienta Postfix SMTP (pouze RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Chyby přihlášení ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Hostitelé opakovaně zablokovány prostřednictvím Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Chyby přihlášení SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Chyby přihlášení SSH, chyby při vyjednávání a útoky DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Chyby přihlášení SSH a útoky DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Chyby přihlášení SSH a chyby při vyjednávání',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Zákaz prostřednictvím firewalld brány firewall, na všech portech',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Zákaz prostřednictvím firewalld brány firewall, na několika portech',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Zákaz prostřednictvím firewalld brány firewall, na jediném portu',
    'ip-ban.jail.iptables-action-description' => 'Zákaz prostřednictvím iptables brány firewall, na jediném portu',
    'ip-ban.jail.iptables-allports-action-description' => 'Zákaz prostřednictvím iptables brány firewall, na všech portech',
    'ip-ban.jail.iptables-multiport-action-description' => 'Zákaz prostřednictvím iptables brány firewall, na několika portech',
    'ip-ban.jail.sendmail-action-description' => 'Odeslat upozornění na poštu prostřednictvím aplikace Sendmail',
    'ip-ban.jail.jailExistsError' => 'Filtr typu jail s tímto názvem již existuje.',
    'ip-ban.jail.invalidInteger' => 'Specifikovaná hodnota je neplatná. Zadejte platné celé číslo.',

    'ip-ban.settings.pageHint' => 'Zde můžete nastavit blokování IP adresy kvůli ochraně svého serveru a hostovaných webových stránek před škodlivými datovými přenosy.',
    'ip-ban.settings.detectionEnabled' => 'Zapnout detekci neoprávněných vniknutí',
    'ip-ban.settings.banPeriod' => 'Interval zákazu IP adresy',
    'ip-ban.settings.banTimeWindow' => 'Časový interval zjišťování následných útoků',
    'ip-ban.settings.maxRetries' => 'Počet selhání před zablokováním IP adresy',
    'ip-ban.settings.timeUnit' => 'sekundy',
    'ip-ban.settings.invalidInteger' => 'Byla poskytnuta neplatná hodnota. Poskytnout kladné celé číslo.',

    'ip-ban.trusted-ip.ipAddress' => 'IP adresa',
    'ip-ban.trusted-ip.hintIpAddress' => 'IP adresa, maska CIDR nebo název hostitele DNS.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'Zadaná IP adresa, síťová adresa nebo název hostitele jsou neplatné.',
    'ip-ban.trusted-ip.ipAddressIsTooLong' => 'IP adresa nesmí být delší než %max% znaků.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Popis',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Vysvětlení, proč byla IP adresa přidána do seznamu důvěryhodných adres.',
    'ip-ban.trusted-ip.ipAddressDescriptionTooLong' => 'Popis nesmí mít více než %max% znaků.',

    'login-info.hint' => 'Zde změníte přihlašovací jméno a heslo, které zákazník používá k přístupu ke svému panelu zákazníka.',
    'login-info.resellerHint' => 'Zde změníte přihlašovací jméno a/nebo heslo, které prodejce používá k přístupu ke svému prostředí Plesk.',
    'login-info.myProfileHint' => 'Zde změníte heslo, které použijete k přístupu k prostředí Plesk.',

    'firewall-rule.titleEdit' => 'Úprava pravidla brány firewall',
    'firewall-rule.titleNew' => 'Přidávání pravidel',
    'firewall-rule.isEnabled' => 'Zapnout pravidlo',
    'firewall-rule.name' => 'Název pravidla',
    'firewall-rule.profiles' => 'Profily',
    'firewall-rule.profilesHint' => 'Je třeba vybrat alespoň jeden profil.',
    'firewall-rule.profileDomain' => 'Doména',
    'firewall-rule.profilePrivate' => 'Soukromý',
    'firewall-rule.profilePublic' => 'Veřejná',
    'firewall-rule.action' => 'Akce',
    'firewall-rule.actionAllow' => 'Povolit',
    'firewall-rule.actionBlock' => 'Odepřít',
    'firewall-rule.port' => 'Povolit připojení na následující port nebo rozsah portů',
    'firewall-rule.portHint' => 'Například: 1000 nebo 1000-1051',
    'firewall-rule.protocolTcp' => 'Protokol TCP',
    'firewall-rule.protocolUdp' => 'Protokol UDP',
    'firewall-rule.remoteAddresses' => 'Vzdálené adresy',
    'firewall-rule.remoteAddressesHint' => 'Například: 192.168.0.1 nebo 192.168.0.0/16',
    'firewall-rule.newRule' => 'Nové pravidlo',
    'firewall-rule.successNew' => 'Pravidlo brány firewall bylo přidáno.',
    'firewall-rule.successEdit' => 'Pravidlo brány firewall bylo aktualizováno.',

    'mail.lists-server-settings.email' => "E‑mail správce seznamu adresátů",
    'mail.lists-server-settings.emptyEmail' => 'Zadejte e-mailovou adresu.',
    'mail.lists-server-settings.newPassword' => 'Nové heslo',
    'mail.lists-server-settings.emptyPassword' => 'Zadejte heslo.',
    'mail.lists-server-settings.passwordConfirmation' => 'Potvrdit heslo',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Software pro seznam adresátů byl nakonfigurován.',

    'mail.outgoing-messages.hint' => 'Zde můžete zadat omezení počtu odchozích zpráv z poštovní schránky.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Maximální počet odchozích emailových zpráv:',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Výchozí (%%domainOutgoingMessages%% zpráv za hodinu)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Vlastní hodnota pro tuto poštovní schránku',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'zpráv za hodinu',

    'mail-gate-settings.host' => 'Název hostitele nebo IP adresa',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Uživatelské jméno',
    'mail-gate-settings.password' => 'Heslo',
    'mail-gate-settings.encryption' => 'SMTP server vyžaduje šifrované připojení',
    'mail-gate-settings.allowUsers' => 'Umožnit uživatelské skripty k odesílání e-mailů přes tento server SMTP (prostřednictvím zadaného přihlašovacího jména a hesla)',
    'mail-gate-settings.useDefaultSettings' => 'Použijte poštovní server nainstalovaný v prostředí Plesk a výchozí emailový účet vytvořený v prostředí Plesk',

    'mail-gate.hint' => 'Zde můžete zadat server SMTP, který se použije, když není nainstalován poštovní server Plesk nebo když má zákaz odesílání pošty. Tento server bude použit k SMTP přenosu v prostředí Plesk s uživatelskými skripty jako jsou oznámení o e-mailu.',
    'mail-gate.enableMailGate' => 'Umožnit, aby prostředí Plesk odesílalo e-mailová upozornění prostřednictvím tohoto serveru SMTP',
    'mail-gate.notifications' => 'E-mailová oznámení externím serverem SMTP',
    'mail-gate.smtpSettings' => 'Nastavení externího SMTP serveru',

    'optimization-settings.apacheModulesSection' => 'Moduly Apache',
    'optimization-settings.apacheSettingsSection' => 'Obecné nastavení',
    'optimization-settings.additionalPageHint' => 'Přepnout moduly, pouze pokud zcela rozumíte důsledkům vašich činností. Pamatujte si, že některé úpravy mohou snížit výkon Apache nebo dokonce způsobit jeho nefunkčnost.',
    'optimization-settings.pageHint' => 'Zde můžete vypnutím nepoužitých modulů Apache optimalizovat prostředí Plesk. Tato optimalizace zdokonaluje využití paměti a umožní vám obsloužit větší počet hostujících zákazníkům. Všimněte si, že některé moduly jsou nezávislé a lze je vypnout (zapnout) pouze tehdy, když moduly, na nichž závisí, jsou vypnuté (zapnuté).',
    'optimization-settings.advancedUsersOnlyWarning' => 'Tato funkce je pouze pro pokročilé uživatele.',
    'optimization-settings.apacheRestartInterval' => 'Interval restartu Apache (sekundy)',
    'optimization-settings.apacheRestartIntervalHint' => 'Jednou za zadaný interval Plesk kontroluje změny provedené v doménách a v subdoménách. V případě změn, které vyžadují restart webového serveru, prostředí Plesk restartuje Apache.',
    'optimization-settings.gracefulRestart' => 'Řádný restart Apache',
    'optimization-settings.gracefulRestartHint' => 'Vyberte položku, aby nedošlo k prostojům všech webů hostovaných na serveru při každé změně nastavení hostování.',
    'optimization-settings.pipedLog' => 'Protokoly předané kanálem',
    'optimization-settings.mpmMode' => 'Režim MPM',
    'optimization-settings.moduleDeprecated' => '(Nepoužívané)',

    'personal-info.contactInfoSection' => 'Kontaktní údaje',
    'personal-info.hint' => 'Zde můžete upravit kontaktní údaje uživatele.',
    'personal-info.hintMyProfile' => 'Zde můžete upravit své kontaktní údaje.',

    'php-handler.extension.title' => 'Instalovat balíček PECL',
    'php-handler.extension.description' => "Když k názvu balíčku přidáte dodatečné parametry, můžete nainstalovat betaverzi rozšíření, například 'msgpack-beta'.",
    'php-handler.extension.name' => 'Název balíčku',

    'php-handler.ini.formHint' => 'Tento soubor php.ini používá pouze tato obslužná rutina.',
    'php-handler.ini.formHintSharedIni' => 'Tento soubor php.ini také používají následující obslužné rutiny PHP: %%handlers%%. Nastavení platí pro všechny weby, které používají tyto obslužné rutiny.',
    'php-handler.ini.incorrectTextForIniFile' => "Zadané nastavení je nesprávné a nelze ho uložit do souboru php.ini. Chyba: %%message%%.",

    'plan-item-custom.planItemName' => 'Název služby',
    'plan-item-custom.buttonLabel' => 'Tento název se použijte také jako štítek pro uživatelské tlačítko.',
    'plan-item-custom.planItemDescription' => 'Popis služby',
    'plan-item-custom.buttonTooltip' => 'Tento text bude také použit jako popisek pro uživatelské tlačítko',
    'plan-item-custom.url' => 'Adresa URL připojená k uživatelskému tlačítku',
    'plan-item-custom.backgroundImage' => 'Obrázek pozadí pro uživatelské tlačítko',
    'plan-item-custom.emptyItemName' => 'Zadejte štítek pro službu.',
    'plan-item-custom.emptyItemDescription' => 'Zadejte text pro popisek služby.',
    'plan-item-custom.emptyUrl' => 'Zadejte adresu URL.',
    'plan-item-custom.longItemName' => 'Štítek služby je příliš dlouhý. Maximální povolená délka je %max% symbolů.',
    'plan-item-custom.longItemDescription' => 'Text služby je příliš dlouhý. Maximální povolená délka je %max% symbolů.',
    'plan-item-custom.longUrl' => 'Tato adresa URL je příliš dlouhá. Maximální povolená délka je %max% symbolů.',
    'plan-item-custom.useCustomButton' => 'Použít uživatelské tlačítko pro službu',
    'plan-item-custom.useCustomButtonHint' => 'Uživatelské tlačítko umístěte na domovskou stránku uživatele a webové stránky.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Otevřít adresu URL v prostředí Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Určete, zda chcete otevřít adresu URL na stránce Plesk nebo v novém okně prohlížeče.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Nepoužívat rámečky',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Pokud přidáte uživatelské tlačítko, které vede na rozšíření Plesk nebo na aplikaci na panelu zákazníka, můžete specifikovat, jak se má toto rozšíření/aplikace zobrazovat: v rámečku nebo jako součást grafického rozhraní (GUI) Plesk.',
    'plan-item-custom.includeDomId' => 'Zahrnout ID předplatného hostování',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Zahrnout hlavní název domény',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Zahrnout přihlašovací jméno FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Zahrnout heslo FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Zahrnout ID zákazníka',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Zahrnout název společnosti zákazníka",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Zahrnout název kontaktu zákazníka",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Zahrnout e-mail zákazníka",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Vybrat způsob, jak prohlížet náhledy webů',
    'preview-domain-settings.previewQuick' => 'Výchozí stručný přehled',
    'preview-domain-settings.previewDisabled' => 'Zakázat stručný přehled',
    'preview-domain-settings.previewQuickDescription' => 'Doporučená možnost, která pracuje ihned po vybalení.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Stručný přehled názvu domény v prostředí Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Vyberte jeden z webů obsluhovaných prostředím Plesk, který se použije pro náhled.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Abyste mohli použít tuto funkci, %%link%% nejméně jednu doménu.',
    'preview-domain-settings.subscriptionCreateLink' => 'vytvořit',
    'preview-domain-settings.previewZoneTypeExternal' => 'Stručný přehled externího názvu domény',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Použít název externí domény (zóna DNS). Pokud používáte tuto možnost, přidejte následující záznam (typu A) do externí zóny domény: *.<Plesk_IP>.external.dom. Zde <Plesk_IP>je IP adresa serveru Plesk, kde jsou tečky (.) pro IPv4 nebo dvojtečky (:) pro IPv6 nahrazeny pomlčkami (-). Například *.192-0-2-12.external.dom. Pokud má Plesk více než jednu zaregistrovanou IP adresu, přidejte záznam pro každou adresu.',
    'preview-domain-settings.sitePreviewProtection' => 'Požadovat ověření',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Požadovat přihlašovací jméno a heslo FTP pro přístup k náhledu.',
    'preview-domain-settings.nginxNotInstalled' => 'Výchozí stručný přehled není k dispozici, protože webový server nginx není nainstalován.',
    'preview-domain-settings.nginxDisabled' => 'Výchozí stručný přehled není k dispozici, protože webový server nginx je vypnutý.',

    'reseller-preferences.settingsSection' => 'Nastavení',
    'reseller-preferences.multiLogin' => 'Povolit více relací',
    'reseller-preferences.language' => 'Jazyk rozhraní',
    'reseller-preferences.interfaceView' => 'Vyberte své rozhraní',
    'reseller-preferences.serviceProviderView' => 'Režim zobrazení Poskytovatel služeb',
    'reseller-preferences.serviceProviderViewHint' => 'Toto zobrazení je určeno pro správce serveru, kteří poskytují a prodávají služby webového hostingu svým zákazníkům za využití servisních plánů.',
    'reseller-preferences.powerUserView' => 'Režim zobrazení Power User (Zkušený uživatel)',
    'reseller-preferences.powerUserViewHint' => 'Toto zobrazení se nejlépe hodí ke správě webů, jejich souborů, databází, e-mailových účtů, webových aplikací a dalších služeb.',

    'reseller.hint' => 'Zde můžete zaregistrovat nového prodejce pro vaše hostitelské služby.',
    'reseller.contactInfoSection' => 'Kontaktní údaje',
    'reseller.contactInfoSectionHint' => 'Zadat kontaktní údaje prodejce.',
    'reseller.accessToPanelSection' => 'Přístup k prostředí Plesk',
    'reseller.accessToPanelSectionHint' => 'Pověření, která prodejce použije k přístupu do prostředí Plesk a správě služeb, k nimž jsou zaregistrováni.',
    'reseller.subscription' => 'Předplacená služba',
    'reseller.subscriptionSectionHint' => 'Vyberte plán služeb, který bude mít prodejce přihlášen k odběru.',
    'reseller.servicePlan' => 'Plán služby',
    'reseller.none' => 'žádná',
    'reseller.customizeSubscription' => 'Po vytvoření prodejce pokračujte v přizpůsobení parametrů předplatného. Pamatujte si, že tato akce uzamkne předplatné před synchronizací.',
    'reseller.subscriptionNotSynchronized' => 'Nelze synchronizovat předplatné s plánem služeb. Následující nastavení předplatného je v konfliktu s plánem služeb: %%problems%%.',

    'security-policy.encryptionSection' => 'Rozšířený režim zabezpečení',
    'security-policy.encryptionSectionHint' => 'Režim rozšířeného zabezpečení zavádí rozšířenou ochranu citlivých dat v prostředí Plesk. V tomto režimu Plesk využívá větší počet bezpečnostních mechanizmů, které jsou absolutně transparentní pro uživatele Plesk. Chcete-li zabezpečení prostředí Plesk zvýšit, doporučujeme režim zapnout.',
    'security-policy.encryptionEnable' => 'Rozšířený režim zabezpečení',
    'security-policy.securePassword' => 'Rozšířený režim zabezpečení',
    'security-policy.strengthSection' => 'Složitost hesla',
    'security-policy.strengthSectionHint' => 'Většina hesel, které uživatelé v platformě Plesk nastavují nebo mění, se ověřuje z hlediska zde nastavených minimálních požadavků na sílu hesla. Silná hesla mají nejméně 9 až 12 znaků na délku a obsahují číslice, velká a malá písmena, speciální znaky a neobsahují žádné slovníkové výrazy. Je těžší je uhodnout, ale také si je zapamatovat. <a href="%%link%%" target="_blank">Zde zjistíte více o síle hesel</a>.',
    'security-policy.passwordStrength' => 'Minimální délka hesla',
    'security-policy.secureFtpSection' => 'Zabezpečit FTP',
    'security-policy.ftpOverSsl' => 'Zásady použití FTP',
    'security-policy.ftpOverSslHint' => 'FTPS slouží k ochraně komunikace mezi serverem FTP a externími FTP klienty pomocí protokolu SSL/TLS. Zde můžete vybrat typ připojení, který by měl být povolen.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS slouží k ochraně komunikace mezi serverem FTP a externími FTP klienty pomocí protokolu SSL/TLS. Zde můžete vybrat typ připojení, který by měl být povolen. Vybraná možnost se použije na všechny IP adresy na serveru. Chcete-li použít vlastní nastavení na IP adresu, vyberte odpovídající možnost a poté v nabídce Nástroje a nastavení> IP adresy změňte zásady FTPS.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS slouží k ochraně komunikace mezi serverem FTP a externími FTP klienty pomocí protokolu SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS slouží k ochraně komunikace mezi serverem FTP a externími FTP klienty pomocí protokolu SSL/TLS. Chcete-li upravit nastavení FTPS na IP adresu, nejprve vyberte v nabídce Nástroje a nastavení> Zásady zabezpečení> Zabezpečené FTP možnost "Použít vlastní nastavení FTPS na IP adresu".',
    'security-policy.ftpOverSslOptionRequired' => 'Povolit pouze zabezpečená připojení FTPS',
    'security-policy.ftpOverSslOptionEnabled' => 'Povolit zabezpečená připojení FTPS i nezabezpečená FTP',
    'security-policy.ftpOverSslOptionDisabled' => 'Povolit pouze nezabezpečená připojení FTP. Nepoužívat FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Použít vlastní zásady FTPS na IP adresu',
    'security-policy.prohibitWebConfigHandlersSection' => 'Vlastní zásady pro obslužné rutiny',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Povolením této možnosti zakážete zákazníkům potlačení obslužných rutin IIS definovaných na úrovni serveru prostřednictvím konfiguračního souboru web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Zakázat možnost přerušit obslužné podprocesy prostřednictvím web.config',

    'server-mail-antivirus.used' => 'Použitý antivirus',
    'server-mail-antivirus.policy' => 'Použít nastavení pro celý server',
    'server-mail-antivirus.policyOff' => 'Skenování vypnuto',
    'server-mail-antivirus.policyAny' => 'Prohledat příchozí i odchozí poštu',
    'server-mail-antivirus.policyFrom' => 'Prohledat pouze odchozí poštu',
    'server-mail-antivirus.policyTo' => 'Prohledat pouze příchozí poštu',
    'server-mail-antivirus.allowPersonalSettings' => 'Umožnit osobní nastavení',
    'server-mail-antivirus.incoming' => 'pro příchozí poštu',
    'server-mail-antivirus.outgoing' => 'pro odchozí poštu',
    'server-mail-antivirus.success' => 'Nastavení antiviru byla změněna.',

    'server-mail-black-list.title' => 'Přidat doménu na černou listinu',
    'server-mail-black-list.domainName' => 'Název domény',
    'server-mail-black-list.emailAddress' => 'E-mailové adresy',
    'server-mail-black-list.emailAddressHint' => 'Nalevo od znaku @ nesmí být žádné znaky jiné než ASCII. Adresy mohou obsahovat zástupné znaky „*“ a „?“ (například *@domain.com, user?@*.com). Části doménových jmen, které neobsahují znaky ASCII, nesmí obsahovat zástupné znaky.',
    'server-mail-black-list.action' => 'Co dělat se zprávami, které splňují kritérium:',
    'server-mail-black-list.actionDelete' => 'Smazat ze serveru',
    'server-mail-black-list.actionSpam' => 'Označit jako spam',
    'server-mail-black-list.success' => 'Doména byla přidána na černou listinu.',

    'server-mail-white-list.title' => 'Přidat síť na bílou listinu',
    'server-mail-white-list.descEmailAddress' => 'Zde zadané e-mailové adresy nebudou programem SpamAssassin rozpoznány jako spam.',
    'server-mail-white-list.descIpAddress' => 'Zde zadané IP adresy budou přidány do výjimek poštovního serveru.',
    'server-mail-white-list.ipAddress' => 'IP adresa/maska',
    'server-mail-white-list.ipAddressHint' => 'IP adresa může obsahovat zástupný znak nebo masku CIDR.',
    'server-mail-white-list.emailAddress' => 'E-mailové adresy',
    'server-mail-white-list.emailAddressHint' => 'Nalevo od znaku @ nesmí být žádné znaky jiné než ASCII. Adresy mohou obsahovat zástupné znaky „*“ a „?“ (například *@domain.com, user?@*.com). Části doménových jmen, které neobsahují znaky ASCII, nesmí obsahovat zástupné znaky.',
    'server-mail-white-list.emailAddressOrIp' => 'E-mailové nebo IP adresy',
    'server-mail-white-list.wildcardPattern' => 'IP adresy mohou obsahovat zástupné znaky (například 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'IP adresy mohou obsahovat masky CIDR (například 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Síť byla přidána na bílou listinu.',

    'server-mail-settings.general.title' => 'Obecné možnosti',
    'server-mail-settings.general.mailUiEnabled' => 'Povolit funkce správy e-mailů v prostředí Plesk',
    'server-mail-settings.general.serverName' => 'Nainstalovaný emailový server',
    'server-mail-settings.general.changeServerName' => 'nainstalovat a použít jiný e-mailový server',
    'server-mail-settings.general.imapServerName' => 'Nainstalovaný server IMAP/POP3',
    'server-mail-settings.general.changeImapServerName' => 'Nainstalovat a použít jiný server IMAP/POP3',
    'server-mail-settings.general.changeServerHint' => 'Můžete %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Maximální velikost zprávy',
    'server-mail-settings.general.kbytes' => 'kBytů',
    'server-mail-settings.general.maxConnections' => 'Maximální počet připojení (IMAP, POP3, IMAP přes SSL/TLS nebo POP3 přes SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'Byl zahájen maximální počet serverů (IMAP nebo POP3).',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'Maximální počet uživatelů e-mailu, kteří se mohou najednou přihlásit.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Maximální počet připojení na IP adresu',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Maximální počet připojení pro uživatele na IP adresu',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'Maximální počet připojení (IMAP, POP3, IMAP přes SSL/TLS nebo POP3 přes SSL/TLS), které lze přijmout ze stejné IP adresy.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'Maximální počet připojení (IMAP, POP3, IMAP přes SSL/TLS nebo POP3 přes SSL/TLS) povolených pro uživatele e-mailu z každé IP adresy.',
    'server-mail-settings.general.messageSubmission' => 'Povolit službu SMTP na portu 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Povolit službu SMTP na portu 587 na všech IP adresách.',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Zapnout',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'všechny IP adresy',
    'server-mail-settings.general.outgoingEmailMode' => 'Režim odchozí pošta',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Odeslat z IP adresy domény',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Odeslat z IP adresy domény a použít názvy domén v SMTP pozdravu',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Odeslat ze specifikované IP adresy',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Žádné',
    'server-mail-settings.general.subaddressing' => 'Povolit subadresování e-mailu',
    'server-mail-settings.general.subaddressingHint' => 'Tato možnost povoluje možnost konfigurovat e-mailové adresy %%verpStyleLink%% pro poštovní seznamy',
    'server-mail-settings.general.verpStyleLink' => 'Styl VERP',
    'server-mail-settings.general.mboxQuotaWarning' => 'Povolit upozornění na kvótu poštovní schránky',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Odešle oznámení uživatelům pošty, když jejich kvóta poštovní schránky přesáhne 95 %',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Úprava varování na kvótu výchozí poštovní schránky',
    'server-mail-settings.general.fixSender' => 'Oprava nekorektně nastaveného odesilatele pro odchozí poštu',
    'server-mail-settings.general.fixSenderHint' => 'Automaticky nastavuje platná záhlaví e-mailů a adresu odesilatele pro odchozí poštu z domény s cílem snížit šanci na označení za nevyžádanou poštu',

    'server-mail-settings.autodiscover.title' => 'Automatické zjišťování e-mailu',
    'server-mail-settings.autodiscover.description' => 'Na %%link%% si prohlédněte, jak pracuje',
    'server-mail-settings.autodiscover.link' => 'znalostní báze',
    'server-mail-settings.autodiscover.enabled' => 'Povolit funkci automatického zjišťování pošty',
    'server-mail-settings.autodiscover.enabledHint' => 'Povolení této funkce rekonfiguruje všechny domény, které mají zapnuté automatické zjišťování',
    'server-mail-settings.autodiscover.customServer' => 'Zadejte vlastní název domény pro automatické zjišťování e-mailu',
    'server-mail-settings.autodiscover.customServerHint' => 'Poznámka: Název domény musí být zabezpečen platným certifikátem SSL/TLS.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Rekonfigurovat automatické zjišťování záznamů DNS',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Povolení této funkce rekonfiguruje všechny záznamy automatického zjišťování DNS na doménách, které mají zapnuté automatické zjišťování',

    'server-mail-settings.relay.title' => 'Možnosti předávání',
    'server-mail-settings.relay.type' => "Předávání",
    'server-mail-settings.relay.open' => "otevřít",
    'server-mail-settings.relay.openSpamWarning' => "Když otevřete předávání své pošty, váš poštovní server bude zranitelný spamem.",
    'server-mail-settings.relay.openSpamChange' => "Toto nastavení ponechte pouze v případě, že chcete poštovní server dočasně testovat, nebo pokud je váš server platformy Plesk na vnitřní síti, k níž není možné se připojit z internetu.",
    'server-mail-settings.relay.closed' => "uzavřeno",
    'server-mail-settings.relay.auth' => "je požadována autorizace:",
    'server-mail-settings.relay.notSupported' => "nepodporováno e-mailovým serverem",
    'server-mail-settings.relay.change' => 'Chcete-li, aby vám Plesk posílal oznámení při uzavření přenosu, můžete %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'změnit nastavení SMTP',
    'server-mail-settings.relay.pop3' => "POP3 před SMTP",
    'server-mail-settings.relay.lockTime' => "časový zámek",
    'server-mail-settings.relay.min' => "min.",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Pro následující sítě nepoužít žádná omezení přenosu:',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP adresa/maska",

    'server-mail-settings.outgoing.title' => 'Omezení pro odchozí e-mailové zprávy',
    'server-mail-settings.outgoing.description' => 'Následující limity jsou výchozí. V každém plánu služeb a předplatném mohou být přepsány. Limity nepracují v rámci celého serveru, ale chovají se jako šablona pro plány a předplacené služby, pro které nebyly specifikovány žádné limity. Pamatujte si, že přepnutí na omezení odchozích e-mailových zpráv může ovlivnit výkon e-mailového serveru. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Zjistit více o omezení odchozí pošty',
    'server-mail-settings.outgoing.enabled' => 'Zapnout omezení pro odchozí e-mailové zprávy',
    'server-mail-settings.outgoing.countRecipients' => 'Počítat počet příjemců místo počtu zpráv',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Povoluje režim, který při omezování odchozí pošty a při vytváření statistik počítá počet příjemců a nikoli počet zpráv. Například jedna zpráva odeslaná 10 příjemcům bude počítána jako deset zpráv.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Výchozí limit odchozích zpráv z poštovní schránky (za hodinu)',
    'server-mail-settings.outgoing.domainLimit' => 'Výchozí limit odchozích zpráv z domény (za hodinu)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Výchozí limit odchozích zpráv z předplatného (za hodinu)',
    'server-mail-settings.outgoing.unlimited' => 'Neomezeno',
    'server-mail-settings.outgoing.sendmail' => 'Umožnit uživatelům až skriptům používat aplikaci Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Skripty a uživatelé budou moci odesílat e-mailové zprávy (jménem uživatele systému předplacených služeb) prostřednictvím aplikace Sendmail, i když budou překročeny limity pro poštovní schránku a doménu. Maximální počet zpráv, které lze odeslat prostřednictvím aplikace Sendmail, bude dán jejich limitem pro celý odběr. Toto nastavení neumožňuje, aby skripty používaly aplikaci Sendmail po celém serveru, ale jedná se o výchozí nastavení pro plány služeb a předplatné.',
    'server-mail-settings.outgoing.reportPeriod' => 'Zobrazit sestavy vycházející ze statistik za posledních',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Vytváří se sestavy a na domovské stránce se zobrazuje výstraha o pokusech překročit limity odchozí pošty během zadaného období.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Odeslat upozornění e-mailem každých',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Upozornění poskytují statistiky pokusů o překročení limitů odchozí pošty během zadaného období.',
    'server-mail-settings.outgoing.periodP1D' => '1 den',
    'server-mail-settings.outgoing.periodP1W' => '1 týden',
    'server-mail-settings.outgoing.periodP2W' => '2 týdny',
    'server-mail-settings.outgoing.periodP1M' => '1 měsíc',
    'server-mail-settings.outgoing.periodPT15M' => '15 minut',
    'server-mail-settings.outgoing.periodPT1H' => '1 hodina',
    'server-mail-settings.outgoing.periodPT6H' => '6 hodin',
    'server-mail-settings.outgoing.periodPT12H' => '12 hodin',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Limity odchozí pošty nebudou pracovat pro odesílatele pošty, jejichž IP adresy jsou na bílé listině e-mailového serveru. Například pokud bude položka localhost (127.0.0.0 / 8, ::1 / 128) zařazena do bílé listiny, veškerá pošta z místního serveru bude úspěšně odeslána bez ohledu na omezení. Odesílatelé e-mailu mohou použít buď místní IP adresy (weby a vlastní skripty hostované na místním serveru) nebo externí (zákazníci, kteří odeslali e-mail z e-mailových klientů nainstalovaných na svých počítačích nebo mobilních zařízení). Aby byly limity funkční pro všechny odesílatele (místní i externí), odeberte všechny IP adresy a sítě z bílé listiny. Všimněte si, že pokud odeberete položku localhost (127.0.0.0 / 8, ::1 / 128) z bílé listiny, provoz webů a skriptů, které odesílají poštu z tohoto serveru, se může narušit. Podrobnosti týkající se omezení odchozí pošty naleznete v dokumentu Příručka pro správce, Ochrana před odchozím spamem.',
    'server-mail-settings.outgoing.relayIsOpen' => 'Předávání pošty je otevřeno: Limity odchozí pošty nebudou pracovat.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'Omezení odchozích zpráv pro doménu (%%value%%) nemůže být větší než limit pro předplatné (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'Omezení odchozích zpráv pro e-mailovou adresu (%%value%%) nemůže být větší než limit pro doménu (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'Limit odchozích zpráv pro e-mailovou adresu (%%value%%) nemůže být větší než limit pro předplatné (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Nastavení pošty',
    'server-mail-settings.mailman.secureLinks' => 'V poštovních seznamech používejte zabezpečené odkazy',
    'server-mail-settings.mailman.secureLinksHint' => 'Povolte nebo zakažte vytváření zabezpečeného (HTTPS) odkazu v poštovních seznamech.',
    'server-mail-settings.mailman.noLocalhost' => 'Chcete-li použít seznamy adresátů, musíte na bílou listinu e-mailového serveru zařadit položku localhost (127.0.0.0/8, ::1/128). Pokud ale chcete použít zabezpečení odchozí pošty, položku localhost nesmíte zařadit na bílou listinu. Kompromis: pokud jste aktivovali zabezpečení odchozí pošty, můžete místo seznamů adresátů použít předávání e-mailů na poštovní schránku.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Chcete-li použít seznamy adresátů, musíte na bílou listinu e-mailového serveru zařadit položku localhost. Pokud ale chcete použít zabezpečení odchozí pošty, položku localhost nesmíte zařadit na bílou listinu. Kompromis: pokud jste aktivovali zabezpečení odchozí pošty, můžete místo seznamů adresátů použít předávání e-mailů na poštovní schránku. Pamatujte si, že na bílé listině nyní nejsou žádné IPv4 adresy localhost (127.0.0.0/8), takže zabezpečení odchozí pošty bude pracovat pro adresy IPv4.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Chcete-li použít seznamy adresátů, musíte na bílou listinu e-mailového serveru zařadit položku localhost. Pokud ale chcete použít zabezpečení odchozí pošty, položku localhost nesmíte zařadit na bílou listinu. Kompromis: pokud jste aktivovali zabezpečení odchozí pošty, můžete místo seznamů adresátů použít předávání e-mailů na poštovní schránku. Pamatujte si, že na bílé listině nyní nejsou žádné IPv6 adresy localhost (::1/128), takže zabezpečení odchozí pošty bude pracovat pro adresy IPv6.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Povolit mechanismus DMARC ke kontrole příchozí pošty',
    'server-mail-settings.spam-filter.dmarcHint' => 'Tato možnost je k dispozici, pokud jsou u příchozí pošty zapnuty funkce DKIM a SPF.',
    'server-mail-settings.spam-filter.dkim' => 'Antispamová ochrana DKIM',
    'server-mail-settings.spam-filter.singOutgoing' => 'Povolit podepisování odchozí pošty',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Ověření příchozí pošty',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Tuto možnost nelze vypnout, pokud je pro příchozí poštu zapnut mechanismus DMARC.',
    'server-mail-settings.spam-filter.spf' => 'Antispamová ochrana SPF',
    'server-mail-settings.spam-filter.spfEnabled' => 'Povolit antispamovou ochranu SPF a kontrolovat příchozí poštu',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Tuto možnost nelze vypnout, pokud je pro příchozí poštu zapnut mechanismus DMARC.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'Pokud nastanou s vyhledáváním DNS problémy, kontrola SPF bude pokračovat',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'SPF nejprve zahájí vyhledávání DNS. Tuto možnost vyberte, chcete-li pokračovat v kontrole, zdali vyhledávání DNS selže. Pokud to nebude mít při současném režimu kontroly žádný efekt, výběr této možnosti bude zrušen.',
    'server-mail-settings.spam-filter.behavior' => 'Režim kontroly SPF',
    'server-mail-settings.spam-filter.behaviorHint' => 'Poté SPF použije místní a odhadovaná pravidla. Na základě vybraného režimu kontroly a výsledků kontroly může být zpráva odmítnuta.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Pouze vytvořit přijaté hlavičky SPF, nikdy neblokovat',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Použijte dočasná chybová hlášení, pokud máte problémy s vyhledáváním DNS',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Zamítnout e-mail, který SPF vyhodnotí jako "selhání" (odmítnout)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Zamítnout e-mail, který SPF vyhodnotí jako "lehké selhání"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Zamítnout e-mail, který SPF vyhodnotí jako "neutrální"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Zamítnout mail, který SPF nevyhodnotí jako "předat"',
    'server-mail-settings.spam-filter.localRules' => 'Místní pravidla SPF',
    'server-mail-settings.spam-filter.guessRules' => 'Odhad pravidla SPF',
    'server-mail-settings.spam-filter.explanationText' => 'Vysvětlení SPF',
    'server-mail-settings.spam-filter.rbl' => "Antispamová ochrana založená na seznamech DNS Blackhole",
    'server-mail-settings.spam-filter.rblEnabled' => "Zapnout antispamovou ochranu založenou na seznamech DNS Blackhole",
    'server-mail-settings.spam-filter.rblServer' => "Zóny DNS pro službu DNSBL",
    'server-mail-settings.spam-filter.rblServerHint' => "Záznamy oddělujte středníkem, například: 'zen.spamhaus.org;dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Přídavná záhlaví automatické odpovědi',
    'server-mail-settings.auto-reply-headers.description' => 'Nastavte přídavná záhlaví pro zprávu automatické odpovědi ze serveru Plesk.',
    'server-mail-settings.auto-reply-headers.extra' => 'Přídavná záhlaví',

    'server-mail-settings.pop3-names.title' => "Názvy pro e-mailové účty POP3/IMAP",
    'server-mail-settings.pop3-names.disabled' => "Lze použít pouze plná jména poštovních účtů POP3/IMAP",
    'server-mail-settings.pop3-names.enabled' => "Lze použít krátká jména (správce webového serveru) a plná jména (webmaster@domain.com) poštovních účtů POP3/IMAP.",

    'server-mail-settings.success' => 'Nastavení e-mailového serveru se změnilo.',

    'server-mail-spam-filter.general' => 'Obecné',
    'server-mail-spam-filter.isEnabled' => 'Zapnout filtrování nevyžádané pošty SpamAssassin na celém serveru',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Použít individuální nastavení pro filtrování nevyžádané pošty',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "Filtr nevyžádané pošty je vypnutý: poštovní server nepodporuje nastavení filtru nevyžádané pošty na úrovni poštovní schránky.",
    'server-mail-spam-filter.settings' => 'Nastavení SpamAssassin',
    'server-mail-spam-filter.requiredHits' => 'Výsledek, který musí zpráva obdržet, aby byla kvalifikována jako nevyžádaná',
    'server-mail-spam-filter.maxMailLimit' => 'Nefiltrovat, pokud velikost e-mailu překračuje tuto hodnotu',
    'server-mail-spam-filter.maxMailLimitText' => 'omezení velikosti',
    'server-mail-spam-filter.kbytes' => "kBytů",
    'server-mail-spam-filter.maxThreadsLimit' => 'Počet podprocesů, které může filtr nevyžádané pošty vytvořit',
    'server-mail-spam-filter.tag' => 'Přidat následující text na začátek předmětu každé zprávy vyhodnocené jako nevyžádaná',
    'server-mail-spam-filter.byTag' => 'podle tagu',
    'server-mail-spam-filter.alarmMessage' => 'Výstražný text pro detekci nevyžádané pošty',
    'server-mail-spam-filter.languages' => 'Důvěryhodné jazyky',
    'server-mail-spam-filter.locales' => 'Důvěryhodná národní prostředí',
    'server-mail-spam-filter.success' => 'Nastavení filtru nevyžádané pošty se změnilo.',

    'service-instance.setup-instance.resourcesSection' => 'Prostředky služby',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Již nainstalováno',
    'service-instance.setup-instance.requirementsSection' => 'Požadované služby',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'Nevybráno',

    'service-node.ipAddress' => 'IP adresa uzlu služby',
    'service-node.ipAddressLocal' => 'Místní uzel služby',
    'service-node.description' => 'Popis uzlu služby',
    'service-node.accessKey' => 'Heslo',
    'service-node.useAccessKey' => 'Použít ověření',
    'service-node.useAccessKeyDescription' => 'Upozornění k ověřování.',
    'service-node.oldAccessKey' => 'Staré heslo',
    'service-node.newAccessKey' => 'Nové heslo',
    'service-node.noAccessKeySpecified' => 'Heslo není zadáno',

    'service-plan.admin-plan.subscription_section' => 'Společné',
    'service-plan.admin-plan.tools_section' => 'Nástroje a prostředky',
    'service-plan.admin-plan.apps_section' => 'Aplikace a databáze',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Vzhled prostředí Plesk',
    'service-plan.admin-plan.statistics_section' => 'Statistiky',
    'service-plan.admin-plan.general_section' => 'Obecné',
    'service-plan.admin-plan.mail_section' => 'Pošta',
    'service-plan.admin-plan.server_section' => 'Server',
    'service-plan.admin-plan.modules_section' => 'Rozšíření',
    'service-plan.admin-plan.troubleshooting_section' => 'Podpora a Poradenství při potížích',
    'service-plan.admin-plan.simplePanel' => 'Omezený režim',
    'service-plan.admin-plan.enabled' => 'Povolit Omezený režim',
    'service-plan.admin-plan.enabledDescription' => 'Tuto možnost vyberte, chcete-li omezit počet akcí, které může správce podniknout v prostředí Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Tuto možnost vyberte, chcete-li omezit počet akcí, které může další správce podniknout v prostředí Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Poskytnout pouze aplikace, které vyberu',
    'service-plan.applications-subscription.useFilterDescription' => 'Tuto možnost použijte k volbě aplikací, které musí být dostupné uživateli.',
    'service-plan.applications-subscription.applications' => 'Aplikace',
    'service-plan.applications-subscription.isCommercial' => 'Tato aplikace je komerčního charakteru a vyžaduje nákup licenčního klíče.',

    'service-plan.applications.useFilterLabel' => 'Poskytnout pouze aplikace, které vyberu',
    'service-plan.applications.useFilterDescription' => 'Tuto možnost použijte k volbě aplikací, které musí být dostupné odběratelům.',
    'service-plan.applications.applications' => 'Aplikace',
    'service-plan.applications.isCommercial' => 'Tato aplikace je komerčního charakteru a vyžaduje nákup licenčního klíče.',

    'service-plan.dns.dnsZoneType' => 'Zóna DNS domény',
    'service-plan.dns.dnsZoneTypeMaster' => 'Primární',
    'service-plan.dns.dnsZoneTypeSlave' => 'Sekundární',

    'service-plan.extras.groupOtherServices' => 'Další služby',
    'service-plan.extras.none' => 'Žádné',

    'service-plan.hosting.enablePhysicalHosting' => 'Povolit hostování',
    'service-plan.hosting.sectionCoreHosting' => 'Obecné vlastnosti',
    'service-plan.hosting.sectionScripting' => 'Skriptování',
    'service-plan.hosting.defaultDatabaseServer' => 'Výchozí databázový server',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Rozšířený',
    'service-plan.hosting.phpSettingsHelpLink' => 'Naučte se, jak vybrat nejvhodnější nastavení PHP',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Stavy webů tohoto předplatného jsou pozastaveny',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Stav webů v pozastavených předplacených službách',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Vybraný stav se použije na všechny weby v plánech přeplacených služeb, když je předplatné pozastaveno (například když vyprší nebo skončí jeho placené období).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Vybraný stav se použije na weby, když je předplatné pozastaveno (například když vyprší nebo skončí jeho placené období).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Zakázáno',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Návštěvníci webových stránek budou přesměrováni na výchozí stránku webového serveru.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Pozastaveno',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Návštěvníci webu budou přesměrováni s kódem 503 HTTP (uživatelsky přívětivým pro vyhledávače) na stránku vlastních chybových dokumentů.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Aktivní',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Webové stránky zůstanou přístupné z internetu.',

    'service-plan.ip.sharedIpAddresses' => 'Přidělit sdílené IP adresy',
    'service-plan.ip.allocateExclusiveIp' => 'Přidělit vyhrazené IP adresy',
    'service-plan.ip.allocateExclusiveIpV4' => 'Přidělit vyhrazené adresy IPv4',
    'service-plan.ip.allocateExclusiveIpV6' => 'Přidělit vyhrazené adresy IPv6',

    'service-plan.mail.mailService' => 'Zapnout poštovní službu',
    'service-plan.mail.mailServiceDisabled' => 'Zakázáno',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Zakázáno pro příchozí poštu',
    'service-plan.mail.mailServiceDisabledHint' => 'Platforma Plesk nebude pro tuto doménu poskytovat žádné poštovní služby.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Platforma Plesk bude poskytovat služby pouze pro odchozí e-maily. E-maily bude možné odesílat pomocí funkce sendmail při dodržení limitů nastavených v možnostech pošty na platformě Plesk.',
    'service-plan.mail.mailServiceEnabled' => 'Povoleno',
    'service-plan.mail.mailServiceEnabledHint' => 'Platforma Plesk bude poskytovat služby pro příchozí o odchozí e-maily.',
    'service-plan.mail.mailServiceNotConfigured' => 'Nenakonfigurováno',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Platforma Plesk nebude na této doméně poskytovat žádné poštovní služby.',
    'service-plan.mail.webMail' => 'Webmail',
    'service-plan.mail.mailingLists' => 'Zapnout seznamy adresátů',
    'service-plan.mail.mailToNonExistentUser' => 'Zásady pošty pro neexistující uživatele',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Vrátit odesílateli se zprávou',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Předat na adresu',
    'service-plan.mail.mailToNonExistentUserReject' => 'Zamítnout',
    'service-plan.mail.mailAutodiscovery' => 'Povolit funkci automatického zjišťování pošty',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Prohlédněte si ve znalostní bázi <a href="%%link%%" target="_blank">, jak pracuje</a>',
    'service-plan.mail.bounceMessage' => 'Tato adresa již nadále neakceptuje e-maily.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Přesměrovat na externí e-mailový server s IP adresou',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - zakázáno',

    'service-plan.misc.retainEnabled' => 'Uchovat statistiky webu a přenosu po dobu',
    'service-plan.misc.logRotation' => 'Rotace souborů protokolu',
    'service-plan.misc.logRotationCondition' => 'Podmínka rotace souboru protokolu',
    'service-plan.misc.logRotationBySize' => 'Podle velikosti',
    'service-plan.misc.logRotationByTime' => 'Podle času',
    'service-plan.misc.logRotationDaily' => 'Denně',
    'service-plan.misc.logRotationWeekly' => 'Týdně',
    'service-plan.misc.logRotationMonthly' => 'Měsíčně',
    'service-plan.misc.logRotationSizeDescription' => 'Hodnota musí být v rozmezí %%min%% a %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Maximální počet souborů protokolu',
    'service-plan.misc.compress' => 'Komprimovat soubory protokolu',
    'service-plan.misc.sendLogToEmail' => 'Až Plesk obnoví data ze souborů protokolu webových a FTP serverů, zašlete soubory protokolu e-mailem na tuto adresu',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'měsíce',
    'service-plan.misc.logRotationPeriodGreater' => 'Interval rotace souboru protokolu nemůže být delší než limit %%max%% pro celý server.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Pokud je vypnutý, všechny weby předplatného používají stejný fond aplikací IIS vyhrazený pro předplatné.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Vybrat služby a oprávnění poskytované s předplatným.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Zobrazit více dostupných oprávnění',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Zobrazit méně oprávnění',
    'service-plan.permissions-subscription.noShellManagement' => 'Nepovoleno',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Správa přístupu k serveru prostřednictvím SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Umožní zákazníkům zapnout SSH pro jejich uživatele systému. Umožňuje, aby se parametr hostování "Přístup do prostředí serveru prostřednictvím SSH pod systémovým uživatelem předplatného " choval jako předvolba.',

    'service-plan.permissions.permissionsTabDescription' => 'Vyberte služby a oprávnění poskytnutá s plánem.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Vyberte služby a oprávnění, která budou přidána do předplacených služeb prostřednictvím tohoto rozšířeného plánu. Pamatujte si, že oprávnění, která nebudou vybrána v doplňku, žádným způsobem neupraví parametry předplacené služby.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Oprávnění umožňují zákazníkům měnit konkrétní nastavení předplatného. Při vytvoření předplatného platforma Plesk aplikuje předem připravené hodnoty z plánu na nastavení, která pak zákazník může změnit. Další aktualizace plánu nebo použití přídavného plánu nepřepíše změny, které zákazník provede.',
    'service-plan.permissions.showMorePermissions' => 'Zobrazit více dostupných oprávnění',
    'service-plan.permissions.hideMorePermissions' => 'Zobrazit méně oprávnění',
    'service-plan.permissions.noShellManagement' => 'Nepovoleno',
    'service-plan.permissions.systemAccessLabel' => 'Správa přístupu k serveru prostřednictvím SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Umožňuje, aby parametr hostování "Přístup do prostředí serveru prostřednictvím SSH pod systémovým uživatelem předplatného" fungoval jako předvolba.',

    'service-plan.resources-subscription.overusePolicy' => 'Zásady nadměrné využití',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Nadměrné využití není povoleno',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Nepovolit nadměrné využití prostředků. Předplacená služba se automaticky pozastaví, pokud využití prostředků překročí hodnoty limitů.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Nadměrné využití místa na disku a přenosu je povoleno',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Povolit nadměrné využití místa na disku a přenosu. Nepovolit nadměrné využití ostatních prostředků.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Nadměrné využití je povoleno (nedoporučuje se)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Umožnit odběrateli využít více prostředků, než bylo původně poskytnuto v předplatném.',
    'service-plan.resources-subscription.overuseNotify' => 'Upozornit mě e-mailem v případě nadměrného využití',
    'service-plan.resources-subscription.oversellPolicy' => 'Zásady překročení nabídky',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Překročení nabídky je povoleno',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Překročení nabídky umožní prodejci prodat větší množství prostředků, než mu bylo přiděleno předplatným. Pokud je překročení nabídky povoleno, prodejce se místo výchozího přidělení prostředků řídí skutečným využitím prostředků.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Překročení nabídky není povoleno',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Pokud není překročení nabídky povoleno, prodejce může prodat pouze tolik prostředků, kolik mu bylo zpočátku přiděleno předplatným, bez ohledu na to, kolik těchto prostředků se skutečně využívá.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Zadat limity využití prostředků poskytovaných s předplatným.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Zobrazit více dostupných prostředků',
    'service-plan.resources-subscription.hideMoreResources' => 'Zobrazit méně prostředků',

    'service-plan.resources.overusePolicy' => 'Zásady nadměrné využití',
    'service-plan.resources.overusePolicyNotAllowed' => 'Nadměrné využití není povoleno',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Nepovolit nadměrné využití prostředků. Předplacená služba se automaticky pozastaví, pokud využití prostředků překročí hodnoty limitů.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Nadměrné využití místa na disku a přenosu je povoleno',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Povolit nadměrné využití místa na disku a přenosu. Nepovolit nadměrné využití ostatních prostředků.',
    'service-plan.resources.overusePolicyAllowed' => 'Nadměrné využití je povoleno (nedoporučuje se)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Umožnit zákazníkům využít více prostředků, než bylo plánem původně poskytnuto.',
    'service-plan.resources.overuseNotify' => 'Upozornit mě e-mailem v případě nadměrného využití',
    'service-plan.resources.oversellPolicy' => 'Zásady překročení nabídky',
    'service-plan.resources.oversellPolicyAllowed' => 'Překročení nabídky je povoleno',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Překročení nabídky umožní prodejci prodat větší množství prostředků, než bylo přiděleno plánem. Pokud je překročení nabídky povoleno, prodejce se místo výchozího přidělení prostředků řídí skutečným využitím prostředků.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Překročení nabídky není povoleno',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Pokud není překročení nabídky povoleno, prodejce může prodat pouze tolik prostředků, kolik mu bylo zpočátku přiděleno plánem, bez ohledu na to, kolik těchto prostředků se skutečně využívá.',
    'service-plan.resources.mainGroupTitle' => 'Definovat prostředky poskytnuté s plánem.',
    'service-plan.resources.additionalGroupTitle' => 'Zobrazit více dostupných prostředků',
    'service-plan.resources.hideMoreResources' => 'Zobrazit méně prostředků',
    'service-plan.resources.allowSitebuilderUpsell' => 'Umožnit zákazníkům, aby vytvořili zkušební weby systému Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Toto nastavení umožňuje, aby si zákazník vytvořil více webů systému Presence Builder, než poskytuje plán služeb. Zákazník si musí tyto weby zakoupit, aby je mohl publikovat.',

    'service-plan.servicePlanName' => 'Název plánu služeb',
    'service-plan.resellerPlanName' => 'Název plánu prodejce',
    'service-plan.addonPlanName' => 'Název rozšířeného plánu',
    'service-plan.adminPlanPermissionsTab' => 'Nástroje pro správu',
    'service-plan.adminPlanPermissionsTabDescription' => 'Vyberte funkce dostupné správci, když je povolen Omezený režim.',
    'service-plan.hostingPermissionsTab' => 'Nástroje hostování',
    'service-plan.hostingPermissionsTabDescription' => 'Vyberte nástroje webhostingu a nastavení dostupné pro správce v režimu zobrazení Power User (Zkušený uživatel), když je povolen Omezený režim.',
    'service-plan.resourcesTab' => 'Prostředky',
    'service-plan.resourcesTabDescription' => 'Definovat prostředky poskytnuté k plánu a zásady využití prostředků.',
    'service-plan.subscriptionResourcesTabDescription' => 'Definovat prostředky poskytnuté k předplacené službě a zásady využití prostředků.',
    'service-plan.hostingTab' => 'Parametry hostování',
    'service-plan.hostingTabDescription' => 'Zadejte parametry služby hostování poskytnuté s plánem. Všimněte si, že nastavení hostování zadané v rozšíření plánu nejsou použita pro předplacené služby, kterým bylo uděleno oprávnění "Správa nastavení hostování" plánem služeb nebo rozšířeným plánem.',
    'service-plan.secureSettingsDescription' => 'Chcete-li, aby byl poskytnutý hosting co nejbezpečnější, %%link%%. Všimněte si, že některá oprávnění, pokud byla udělena, umožňují odběratelům tato nastavení změnit. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'použit předvolbu zabezpečeného nastavení',
    'service-plan.secureSettingsHelpLink' => 'Další informace o nastavení zabezpečeného hostování',
    'service-plan.mailTab' => 'Pošta',
    'service-plan.mailTabDescription' => 'Zadat parametry e-mailové služby poskytnuté s plánem.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Zadat parametry služby DNS poskytnuté s plánem.',
    'service-plan.performanceTab' => 'Výkon',
    'service-plan.performanceTabDescription' => 'Zadejte parametry systému, které ovlivní výkon všech služeb poskytovaných s plánem.',
    'service-plan.permissionsTab' => 'Oprávnění',
    'service-plan.miscTab' => 'Protokoly a statistiky',
    'service-plan.miscTabDescription' => 'Zadejte, jak musí být uloženy statistiky a protokoly plánů přeplacených služeb. Všimněte si, že tato nastavení nejsou synchronní s předplatným.',
    'service-plan.miscTabAdminPlanDescription' => 'Zadejte, jak musí být uloženy statistiky a protokoly předplacených služeb.',
    'service-plan.extrasTab' => 'Další služby',
    'service-plan.extrasTabDescription' => 'Vyberte služby, které by měly být zahrnuty do plánu navíc, k webovému rozhraní pošty, DNS a poštovním službám.',
    'service-plan.ipTab' => 'IP adresy',
    'service-plan.ipTabDescription' => 'Zadat parametry prostředků IP poskytnutých s plánem.',
    'service-plan.applicationsTab' => 'Aplikace',
    'service-plan.applicationsTabDescription' => 'Vyberte aplikace, které musí být dostupné v plánu. Můžete si vybrat, zda poskytnete všechny aplikace dostupné v katalogu aplikací plus aplikace, které jste nahráli na server, nebo zda vyberete aplikace ručně. Pokud chcete poskytnout všechny dostupné aplikace, na této záložce není nutno nic dělat, stačí přejít na záložku Oprávnění a vybrat možnost Přístup ke katalogu aplikací. Chcete-li vybrat aplikace ručně, můžete tak učinit na této záložce.',
    'service-plan.applicationsTabDescription-addon' => 'Vybrat aplikace, které by měly být dostupné v doplňku.',
    'service-plan.applicationsTabDescription-subscription' => 'Vyberte aplikace, které musí být dostupné v předplatném. Můžete si vybrat, zda poskytnete všechny aplikace dostupné v katalogu aplikací plus aplikace, které jste nahráli na server, nebo zda vyberete aplikace ručně. Pokud chcete poskytnout všechny dostupné aplikace, na této záložce není nutno nic dělat, stačí přejít na záložku Oprávnění a vybrat možnost Přístup ke katalogu aplikací. Chcete-li vybrat aplikace ručně, můžete tak učinit na této záložce.',
    'service-plan.planSyncSubsriptionWarning' => 'Některé předplacené služby nebyly synchronizovány s plánem. V seznamu předplatných byly označeny jako \\&amp;apos;Unsynced\\&amp;apos;. Chcete-li zkusit synchronizaci znovu, přejděte na stránku s přehledem předplacených služeb a klikněte na tlačítko Sync.',
    'service-plan.planSyncResellerWarning' => 'Někteří prodejci nebyli synchronizováni s plánem. V seznamu prodejců byli označeni jako \\&amp;apos;Unsynced\\&amp;apos;. Chcete-li zkusit synchronizaci znovu, přejděte na stránku s přehledem prodejců a klikněte na tlačítko Sync.',
    'service-plan.planSyncAdminWarning' => 'Změny nelze použít na předplacené služby, protože Plesk poskytuje některé ze služeb nebo prostředků ovlivněných těmito změnami. Příčina: %%reason%%',
    'service-plan.duplicateName' => 'Plán s tímto názvem již existuje.',
    'service-plan.phpSettingsTab' => 'Nastavení PHP',
    'service-plan.phpHandlerNotFound' => 'Nelze získat informace o verzi PHP v plánu. Přeinstalujte ji, nebo vyberte pro servisní plán jinou verzi PHP.',
    'service-plan.phpHandlerNotRegistered' => "Verze PHP %%fullVersion%% není nainstalována. Skriptování PHP pro domény nebude s využitím tohoto servisního plánu k dispozici. Nainstalujte PHP <nobr>ve verzi %%fullVersion%%</nobr>, nebo vyberte jinou verzi PHP pro servisní plán.",

    'service-plan.phpSettingsTabDescription' => 'Zde lze určit nastavení PHP pro předplatné, které přepíše nastavení určené souborem php.ini celého serveru. Toto může být užitečné, například když chcete omezit spotřebu systémových prostředků zákaznickými skripty PHP. Odběratelé (pokud jsou povoleni) mohou přerušit tuto konfiguraci PHP prostřednictvím svých vlastních konfigurací domény. Pokud nastavíte parametr na výchozí hodnotu, PHP použije hodnotu parametru z konfigurace PHP celého serveru. Všimněte si, že jsou podporovány následující zástupné symboly: {DOCROOT} a {WEBSPACEROOT} představují adresář kořene dokumentu domény a kořen dokumentu předplacené služby, která má vlastní konfiguraci PHP; {TMP} představuje adresář k ukládání dočasných souborů.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Zde lze určit nastavení PHP pro předplatné, které přepíše nastavení určené hlavním plánem služeb. Toto může být užitečné, například když chcete odebrat některá omezení PHP nastavená v hlavním plánu služeb. Pokud nastavíte parametr na výchozí hodnotu, PHP použije hodnotu parametru z konfigurace PHP plánu služeb. Všimněte si, že jsou podporovány následující zástupné symboly: {DOCROOT} a {WEBSPACEROOT} představují adresář kořene dokumentu domény a kořen dokumentu předplacené služby, která má vlastní konfiguraci PHP; {TMP} představuje adresář k ukládání dočasných souborů.',
    'service-plan.phpSettingsPhpVersion' => 'Vaše aktuální verze PHP je %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Zde lze určit nastavení PHP pro předplatné, které přepíše nastavení určené souborem php.ini celého serveru. Pokud nastavíte parametr na výchozí hodnotu, PHP použije hodnotu parametru z konfigurace PHP celého serveru.',
    'service-plan.webServerSettingsTab' => 'Webový server',
    'service-plan.webServerSettingsTabDescription' => 'Zde můžete zadat nastavení webového serveru Apache přiřazené k plánu služeb. Pokud je Apache spuštěno s nginx jako front-end server, můžete na této stránce zadat také nastavení nginx. Všechny nově vytvořené domény přijmou zadané nastavení. Pokud však nastavení změníte, existující domény změny nepřijmou.',
    'service-plan.servicesTab' => 'Služby',
    'service-plan.servicesTabDescription' => 'Zde můžete zadat služby přiřazené k plánu služeb.',
    'service-plan.servicePropertiesTab' => 'Vlastnosti %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Zde můžete zadat vlastnosti %%serviceName%% služby přiřazené k plánu služeb.',
    'service-plan.longTaskWarning' => 'Máte %%subscriptionsCount%% předplatných v tomto plánu. Pamatujte si, že synchronizace úlohy může vyžadovat významnou dobu a bude probíhat na pozadí.',
    'service-plan.hostingParametersTab' => 'Parametry hostování',
    'service-plan.adminInfoSection' => 'Informace pro správce',
    'service-plan.descriptionInPanel' => 'Popis',
    'service-plan.longDescription' => 'Zadaný popis je příliš dlouhý.',
    'service-plan.conflictPermissions' => 'Nelze udělit následující oprávnění, protože jsou v konfliktu s plánem prodejce: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Typ spouštění',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automaticky',
    'services.change-startup-type.manualStartupTypeLabel' => 'Ruční',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Vypnout',
    'services.change-startup-type.autoActionError' => 'Nelze nastavit typ spouštění na \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Nelze nastavit typ spouštění na \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Nelze nastavit typ spouštění na \'disabled\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Obnovit výchozí',
    'sessions.settings.restoreDefaultButtonDescription' => 'Obnovit výchozí hodnoty parametrů relace.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Parametry relace mají výchozí hodnoty.',
    'sessions.settings.idleTime' => 'Doba nečinnosti relace',
    'sessions.settings.disableCheckSessionIp' => 'Povolit změny IP adresy během jediné relace',
    'sessions.settings.minuteShortTitle' => 'min.',

    'settings-ui.controls.title' => 'Ovládací prvky',

    'settings-ui.interface-views.description' => "K dispozici máte několik zobrazení uživatelského rozhraní produktů. Podle toho, jaké zobrazení si vyberete, mohou být funkce a nastavení umístěny na různých místech nebo dokonce zapnuty / vypnuty. Rozdílná zobrazení jsou vhodnější pro různé typy uživatelů.",
    'settings-ui.interface-views.panelSimpleLink' => 'Nástroje a nastavení> Nastavení Omezený režim',
    'settings-ui.interface-views.useCustomView' => 'Povolit Omezený režim',
    'settings-ui.interface-views.useCustomViewHint' => 'Tuto možnost vyberte, chcete-li omezit počet akcí, které může správce podniknout v aplikaci Plesk Panel. Chcete-li změnit dostupnost akcí, přejděte na %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Toto zobrazení se nejlépe hodí ke správě webů, jejich souborů, databází, e-mailových účtů, webových aplikací a dalších služeb.',
    'settings-ui.interface-views.selectUiModeTitle' => "Vyberte své rozhraní",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Zobrazení pro zkušené uživatele (pro vývojáře a webové agentury)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Zobrazení poskytovatele služeb (pro poskytovatele webového hostingu)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Toto zobrazení je určeno pro správce serveru, kteří poskytují a prodávají služby webového hostingu svým zákazníkům za využití servisních plánů.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Skrýt rozbalovací ovládací prvky',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Skryje tlačítko, které umožňuje nastavit způsob zpracování pošty odeslané na neexistující e-mailové adresy',

    'settings-ui.branding.description' => 'Označte rozhraní Plesk tím, že změníte způsob zobrazení stránky v záhlaví prohlížeče a/nebo náhradou loga Plesk v levém horním rohu.',
    'settings-ui.branding.buttonDefault' => 'Výchozí logo',
    'settings-ui.branding.sectionTitle' => 'Vlastní název',
    'settings-ui.branding.enableCustomTitle' => 'Povolit vlastní název na stránkách Plesk',
    'settings-ui.branding.customTitle' => 'Text nadpisu',
    'settings-ui.branding.sectionLogo' => 'Vlastní logo',
    'settings-ui.branding.enableCustomLogo' => 'Povolit vlastní logo panelu',
    'settings-ui.branding.logo' => 'Soubor loga',
    'settings-ui.branding.logoUrl' => 'Adresa URL loga',
    'settings-ui.branding.logoUrlEnabled' => 'Vlastní',
    'settings-ui.branding.logoUrlDisabled' => 'Výchozí',
    'settings-ui.branding.sectionFavicon' => 'Vlastní favicon',
    'settings-ui.branding.enableCustomFavicon' => 'Povolit vlastní favicon',
    'settings-ui.branding.sectionFaviconDesc' => 'Ten samý favicon je nutné nahrát v obou formátech, aby došlo k zajištění lepší podpory v různých prohlížečích.',
    'settings-ui.branding.faviconSvg' => 'SVG souboru favicon',
    'settings-ui.branding.faviconSvgHint' => 'Povolený formát: SVG',
    'settings-ui.branding.faviconIco' => 'ICO souboru favicon',
    'settings-ui.branding.faviconIcoHint' => 'Povolený formát: ICO',
    'settings-ui.branding.show' => 'Zobrazit',
    'settings-ui.branding.updateSuccess' => 'Vlastnosti brandingu prostředí Plesk se změnily.',

    'sitebuilder.trial.description' => 'Na této stránce lze konfigurovat zkušební režim (Try and Buy, dříve akviziční režim zákazníka). V tomto režimu může zákazník prostřednictvím dodávané aplikace Presence Builder vytvořit webové stránky se všemi dostupnými funkcemi. Publikování zkušebních verzí webů však není dostupné zákazníkům, dokud si nezakoupí plán hostitelských služeb nebo doplněk plánu. Zkušební režim Try and Buy lze také přidělit vašim stávajícím zákazníkům prostřednictvím plánu hostování nebo doplňku služby. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Další informace naleznete v dokumentaci.',
    'sitebuilder.trial.lifetimeLabel' => 'Životnost zkušební verze webu',
    'sitebuilder.trial.lifetimeUnits' => 'dny',
    'sitebuilder.trial.lifetimeDescription' => 'Jedná se o to, kolik času musí uplynout, než budou tyto zkušební webové stránky, které si zákazníci nezakoupili, odstraněny ze serveru.',
    'sitebuilder.trial.signupLabel' => 'Povolit veřejný přístup do zkušebního režimu',
    'sitebuilder.trial.signupDescription' => 'Pokud chcete zaujmout zákazníky reklamou na hostování v systému Presence Builder a poskytnou jim demoverzi Presence Builder, povolte veřejný přístup do zkušebního režimu a na svém webu zveřejněte přístupovou adresu URL zkušebního režimu.',
    'sitebuilder.trial.signupLinkLabel' => 'Adresa URL pro přístup do zkušebního režimu',
    'sitebuilder.trial.signupLinkDescription' => 'Tato adresa URL otevře systém Presence Builder ve zkušebním režimu. Chcete-li vytvořit reklamu na hostování v systému Presence Builder a zaujmout zákazníky, zveřejněte na svém webu tuto adresu URL.',
    'sitebuilder.trial.promotionLabel' => 'Zobrazit oznámení o zkušebním režimu v editoru Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Tuto možnost použijte, pokud chcete zobrazit další oznámení o systému Presence Builder pracujícím ve zkušebním režimu.',

    'update-settings.policyHintForPum' => 'Zde můžete nastavit automatickou instalaci aktualizací. Oznamovací e-mail lze odeslat, když jsou dostupné aktualizace pro ruční instalaci nebo byly nainstalovány automaticky.',
    'update-settings.policyHint' => 'Oznamovací e-mail lze odeslat, když jsou dostupné aktualizace pro ruční instalaci nebo byly nainstalovány automaticky.',
    'update-settings.branchDisabledDescription' => 'Neupozorňovat na dostupné aktualizace',
    'update-settings.automaticPatchesInstallation' => 'Automaticky instalovat aktualizace Plesk (doporučeno)',
    'update-settings.automaticPatchesThirdParty' => 'Automaticky instalovat aktualizace pro součásti třetích stran dodávané společností Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Automaticky instalovat aktualizace systémových balíčků',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Pamatujte si, že se také automaticky nainstalují aktualizace pro součásti třetích stran dodávané společností Plesk',
    'update-settings.automaticPatchesNotification' => 'Oznámit dostupné a nainstalované aktualizace systémových balíčků',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'E-mailová adresa',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Četnost oznamovacích e-mailů',
    'update-settings.daily' => 'Denně',
    'update-settings.weekly' => 'Týdně',
    'update-settings.generalSection' => 'Obecné',
    'update-settings.notificationsSection' => 'Oznámení',
    'update-settings.safeUpdatesSection' => 'Bezpečné aktualizace',
    'update-settings.safeUpdatesSectionHint' => 'Prostředí Plesk zajistí, aby se aktualizace systémových balíčků instalovaly ze stejného úložiště, z něhož byly instalovány výchozí balíčky. Tyto aktualizace jsou považovány za bezpečné. Pokud bezpečné aktualizace zakážete, správce systémových balíčků může nainstalovat aktualizace z každého úložiště v systému.',
    'update-settings.safeUpdatesSectionWarn' => 'Pokud nejste zkušeným uživatelem, doporučujeme, abyste ponechali bezpečné aktualizace povoleny. Nerozlišitelné aktualizace systémových balíčků z odlišných úložišť mohou negativně ovlivnit funkčnost serveru.',
    'update-settings.allowSafeUpdates' => 'Povolit bezpečné aktualizace pro systémové balíčky',

    'requiredFields' => 'Požadovaná pole',
];