<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Instalando %%name%% em %%path%%...',
    'aps-install.queueNoPath' => 'Instalando %%name%%...',
    'aps-install.done' => '%%name%% foi instalado com sucesso em %%path%%. É possível ver suas credenciais para acessar o aplicativo abaixo. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% foi instalado com sucesso. É possível ver suas credenciais para acessar o aplicativo abaixo. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% foi instalado com sucesso em %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% foi instalado com sucesso. %%additionalMessage%%',
    'aps-install.error' => 'A instalação do %%name%% em %%path%% falhou. %%errorMessage%%',
    'aps-install.errorNoPath' => 'A instalação do %%name%% falhou. %%errorMessage%%',

    'aps-update.queueDownload' => 'Fazendo o download %%packageName%%...',
    'aps-update.errorDownload' => 'O download do %%packageName%% falhou:',
    'aps-update.queueInstall' => 'Atualização de uma instalação de %%name%% para %%domainName%%…',
    'aps-update.doneInstall' => 'A instalação do %%name%% para o %%domainName%% foi atualizada com sucesso.',
    'aps-update.errorInstall' => 'A atualização de uma instalação de %%name%% para %%domainName%% falhou:',
    'aps-update.queueInstallMulti' => 'Atualizando as instalações %%instances%% de %%name%%…',
    'aps-update.doneInstallMulti' => '%%successes%% as instalações do %%name%% foram atualizadas com sucesso.',
    'aps-update.errorInstallMulti' => 'A atualização das instalações de %%failures%% do %%name%% falhou:',
    'aps-update.incorrectUpdateInformation' => 'Informações de atualização incorretas.',

    'common.hideCompletedTasks' => 'Ocultar concluído',
    'common.progressBarHide' => 'Ocultar',
    'common.progressBarShow' => 'Mostrar',
    'common.close' => 'Fechar',
    'common.refresh' => 'Atualizar página',
    'common.taskInProgress' => '%%count%% tarefas em andamento…',
    'common.percentCompleted' => '%%percent%%% concluído',
    'common.allTasksCompleted' => 'Todas as tarefas %%num%% tarefas foram concluídas com êxito.',
    'common.minimize' => 'Minimizar',
    'common.statusDone' => 'Pronto',
    'common.statusError' => 'Falhou',
    'common.statusNotStarted' => 'Enfileirado',
    'common.statusCanceled' => 'Cancelado',
    'common.progressDialogLink' => 'progresso detalhado',

    'database-check.queue' => 'Verificando tabelas da base de dados %%database%%…',
    'database-check.done' => 'A base de dados %%database%% não tem erros.',
    'database-check.error' => 'Impossível verificar a base de dados %%database%% quanto a erros.',
    'database-check.done-with-errors' => "A base de dados %%database%% tem %%number%% problemas. \n %%link%%",
    'database-check.info-link-title' => 'Veja os Detalhes e Solucione',

    'database-download.queue' => 'Preparando um despejo da %%database%% para exportação…',
    'database-download.done' => 'O despejo da %%database%% está pronto. Você pode %%downloadLink%%.',
    'database-download.downloadLink' => 'download',
    'database-download.error' => 'Impossível exportar um despejo da %%database%%:',

    'database-repair.queue' => 'Reparando as tabelas da base de dados %%database%%…',
    'database-repair.done' => 'A base de dados %%database%% não tem erros.',
    'database-repair.error' => 'Impossível reparar a base de dado %%database%%.',
    'database-repair.done-with-errors' => "A base de dados %%database%% tem %%number%% problemas. \n %%link%%",
    'database-repair.info-link-title' => 'Veja os Detalhes',

    'database-upload.queue' => 'Importando um despejo da %%database%%….',
    'database-upload.done' => 'O upload do despejo da %%database%% foi importado.',
    'database-upload.error' => 'Impossível importar um despejo da %%database%%:',
    'database-upload.done-with-errors' => "O upload do despejo da %%database%% foi importado com erros.",
    'database-upload.orphanedUsersSuccess' => 'A base de dados %%database%% foi importada com sucesso. No entanto, alguns usuários ficaram órfãos (sem ter logins associados no servidor da base de dados). Para poder acessar suas bases de dados, atribua os logins a esses usuários. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Os usuários a seguir ficaram órfãos (sem logins associados no servidor do banco de dados): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Visualizar usuários',

    'domain-app-scan.queue' => 'Verificando por aplicativos...',
    'domain-app-scan.done' => 'Verificando por aplicativos concluídos.',
    'domain-app-scan.error' => 'Verificando por aplicativos concluídos com erros.',

    'domain-move.queue' => 'Transferindo %%domainName%% para %%webspaceName%%',
    'domain-move.done' => '%%domainName%% foi transferido para %%webspaceName%%',
    'domain-move.error' => '%%domainName%% não foi transferido para %%webspaceName%%',

    'domain-split.queue' => 'Movendo %%domainName%% para uma nova assinatura',
    'domain-split.done' => '%%domainName%% foi movido para nova assinatura',
    'domain-split.error' => '%%domainName%% não foi movido para nova assinatura',

    'file-manager-import-file.done' => 'O arquivo %%fileName%% foi importado para <a href="%%listUrl%%">a pasta %%fileDir%% </a>.',
    'file-manager-import-file.error' => 'Não foi possível importar o arquivo %%fileName%%: %%errorMessage%%.<br><a href="%%url%%">Baixar para meu computador</a>',
    'file-manager-import-file.queue' => 'Importando o arquivo %%fileName%% de %%host%%.',
    'file-manager-import-file.progress' => 'Importando o arquivo %%fileName%% de %%host%% (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'Ocorreu um erro de autenticação. Certifique-se de fornecer o login e a senha corretos',
    'file-manager-import-file.errors.resolve' => 'Não foi possível resolver o hostname %%host%%. Certifique-se de fornecer a URL correto',
    'file-manager-import-file.errors.connect' => 'Não foi possível conectar ao servidor %%host%%. Certifique-se de fornecer a URL correta',
    'file-manager-import-file.errors.notFound' => 'O arquivo remoto não foi encontrado ou não está acessível. Certifique-se de fornecer a URL correta e de que o arquivo esteja acessível',
    'file-manager-import-file.errors.maxSize' => 'O limite de espaço em disco ou espaço livre %%diskSpaceLimit%% foi excedido',
    'file-manager-import-file.errors.lowSpeedTime' => 'Não foi possível importar o arquivo porque a velocidade de transferência era muito lenta: menos de %%lowSpeedLimit%% bytes foram transferidos durante os últimos %%lowSpeedTime%% segundos. O site em que o arquivo está hospedado pode estar apresentando muito tráfego no momento. Tente importar o arquivo mais tarde',
    'file-manager-import-file.errors.certificate' => 'Não foi possível importar o arquivo porque o certificado SSL/TLS do servidor %%host%% não é confiável. Certifique-se de que o site em que o arquivo está hospedado esteja protegido por um certificado confiável',
    'file-manager-import-file.errors.redirects' => 'O número máximo de redirecionamentos (%%maxRedirects%%) foi excedido. Certifique-se de que o servidor %%host%% funcione corretamente',

    'force-log-rotation.queue' => 'Aplicando as configurações globais de rotação de log',
    'force-log-rotation.done' => 'As configurações globais de rotação de log foram aplicadas.',
    'force-log-rotation.error' => 'Aplicação global de rotação de log concluída com erros',
    'force-log-rotation.systemLogRotationError' => 'Logs do sistema: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Plano de serviço %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domínio %%name%%: %%error%%',

    'initial-setup.queue' => 'Inicializando o Plesk...',
    'initial-setup.done' => 'O Plesk foi inicializado.',
    'initial-setup.doneWithErrors' => 'Ocorreu um erro ao inicializar o Plesk.',
    'initial-setup.error' => 'A inicialização do Plesk falhou.',
    'initial-setup.step.setupPanel' => 'Configurando o Painel Plesk',
    'initial-setup.step.requestLicense' => 'Solicitando Licença',
    'initial-setup.step.configureServer' => 'Configurando o Servidor Web',
    'initial-setup.step.secureServer' => 'Protegendo o Servidor',

    'ip-update.queue' => 'Atualizando endereço IP',
    'ip-update.done' => 'Endereço IP atualizado.',
    'ip-update.error' => 'Atualização do Endereço IP terminou com erros',
    'ip-update.updating' => 'Atualizando endereço IP',
    'ip-update.updatingWebServer' => 'Atualizando endereço IP: atualizando servidor web',
    'ip-update.updatingFtpServer' => 'Atualizando endereço IP: atualizando servidor FTP',
    'ip-update.updatingDnsZones' => 'Atualizando endereço IP: atualizando zonas DNS',
    'ip-update.restartingDnsService' => 'Atualizando endereço IP: reiniciando servidor DNS',

    'ip-reload-public.queue' => 'Atualizando endereços IP públicos usando metadados de nuvem',
    'ip-reload-public.done' => 'Endereços IP públicos foram atualizados',

    'logrotate_anonymize_ips.queue' => 'Tornar os endereços IP anônimos nos logs',
    'logrotate_anonymize_ips.queueRevert' => 'Desanonimizar endereços IP em registros',
    'logrotate_anonymize_ips.done' => 'Os endereços IP tornaram-se anônimos.',
    'logrotate_anonymize_ips.doneRevert' => 'Endereços IP foram desanonimizado.',
    'logrotate_anonymize_ips.error' => 'Endereços IP anônimos concluídos com erros',
    'logrotate_anonymize_ips.errorRevert' => 'Endereços IP desanonimizado concluídos com erros',

    'panel-components-install.queue' => 'O componente escolhido está sendo instalado.',
    'panel-components-install.done' => 'Os componentes escolhidos foram instalados com sucesso.',
    'panel-components-install.error' => 'Não foi possível instalar os componentes. A notificação com a descrição de erro foi enviada para o seu e-mail.',

    'panel-update.queue' => 'O Plesk está instalando atualizações. Isso pode levar algum tempo. %%warning%%',
    'panel-update.warning' => 'Não realizar quaisquer operações de gerenciamento no Plesk até que a atualização seja concluída.',
    'panel-update.done' => 'O Plesk foi atualizado. Veja mais informações no %%changelog%%.',
    'panel-update.changelog' => 'Registro de alterações do Plesk',
    'panel-update.error' => 'Falha na atualização do Plesk. %%errorDetails%%',
    'panel-update.support' => 'Para resolver este problema, você pode enviar o registro de atualização para o suporte do Plesk. %%failedLog%% Copie o registro para seu computador antes de fechar esta mensagem.',
    'panel-update.failedLog' => 'Veja o registro de atualização de %%date%%.',

    'pum-update-packages.queue' => 'Atualizando %%count%% pacote(s)...',
    'pum-update-packages.done' => 'Os pacotes %%count%% foram atualizados com êxito.',
    'pum-update-packages.error' => 'Falha na atualização.',

    'scheduler-run-task.queue' => 'Executando a tarefa "%%task%%"...',
    'scheduler-run-task.done' => 'Tarefa "%%task%%" concluída com sucesso em %%seconds%% segundos.',
    'scheduler-run-task.error' => 'Tarefa "%%task%%" concluída com erro em %%seconds%% segundos.',
    'scheduler-run-task.popupSeeDetails' => 'Veja os Detalhes',
    'scheduler-run-task.popupTitle' => 'Executar a tarefa agendada',
    'scheduler-run-task.popupDone' => 'Tarefa "%%task%%" concluída com sucesso em %%seconds%% segundos, saída:',
    'scheduler-run-task.popupError' => 'Tarefa "%%task%%" concluída com erro em %%seconds%% segundos, saída:',
    'scheduler-run-task.popupClose' => 'Fechar',

    'sdk.queue' => 'A tarefa "%%name%%" está em progresso.',
    'sdk.error' => 'A tarefa "%%name%%" falhou.',
    'sdk.done' => 'A tarefa "%%name%%" terminou.',
    'sdk.canceled' => 'A tarefa "%%name%%" foi cancelada.',

    'sync-php-settings.queue' => 'Aplicando configurações globais de PHP %%version%% aos domínios',
    'sync-php-settings.done' => 'As configurações globais de PHP %%version%% foram aplicadas com sucesso aos domínios',
    'sync-php-settings.error' => 'Ocorreu um erro ao aplicar a configuração global do PHP %%version%% aos domínios',

    'sync-service-plan.queue' => 'Sincronizando plano de serviço %%name%% com assinaturas',
    'sync-service-plan.done' => 'O plano de serviço %%name%% foi sincronizado com sucesso com as assinaturas',
    'sync-service-plan.doneWithErrors' => 'A sincronização do plano de serviço %%name%% foi concluída. Algumas assinaturas não foram sincronizadas com o plano',
    'sync-service-plan.error' => 'Ocorreu um erro ao sincronizar o plano de serviço %%name%% com as assinaturas',

    'domain-create.queue' => 'Criando domínio %%domainName%%',
    'domain-create.done' => 'Domínio %%domainName%% criado',
    'domain-create.error' => 'Falha na criação do domínio %%domainName%%',
    'domain-create.warning' => 'Domínio %%domainName%% criado com alguns problemas:<br> %%problems%%',
    'domain-create.refreshUrl' => 'Exibir',
    'domain-create.steps.createCustomer' => 'Criando cliente',
    'domain-create.steps.createSubscription' => 'Criando uma assinatura',
    'domain-create.steps.createDomain' => 'Adicionando um domínio',
    'domain-create.steps.configureDns' => 'Configurando a zona DNS',
    'domain-create.steps.createHosting' => 'Criando hospedagem física',
    'domain-create.steps.configurePhp' => 'Configurando PHP',
    'domain-create.steps.configureMail' => 'Configurando e-mail',

    'domain-delete.queue' => 'Exclusão de processamento de domínios',
    'domain-delete.done' => 'Domínios excluídos',
    'domain-delete.error' => 'A exclusão de domínios falhou',
    'domain-delete.step.domains' => 'Excluindo domínios…',

    'domain-resolve-checking.warning' => 'Domínio %%domainName%% resolve os problemas detectados: <br> %%errors%%',

    'customer-create.queue' => 'Criação do processamento do cliente %%customerName%%',
    'customer-create.done' => 'Cliente %%customerName%% criado',
    'customer-create.error' => 'Falha na criação do cliente %%customerName%%',
    'customer-create.warning' => 'Cliente %%customerName%% criado com alguns problemas:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Você pode tentar sincronizá-lo manualmente.',

    'customer-delete.queue' => 'Exclusão de processamento de clientes',
    'customer-delete.done' => 'Clientes excluídos',
    'customer-delete.error' => 'A exclusão dos clientes falhou',

    'reseller-delete.queue' => 'Exclusão de processamento de revendedores',
    'reseller-delete.done' => 'Revendedores excluídos',
    'reseller-delete.error' => 'A exclusão dos revendedores falhou',

    'subscription-create.queue' => 'Processando criação de inscrição %%subscriptionName%%',
    'subscription-create.done' => 'Assinatura %%subscriptionName%% criada',
    'subscription-create.error' => 'Falha na criação da assinatura %%subscriptionName%%',
    'subscription-create.warning' => 'Assinatura %%subscriptionName%% criada com alguns problemas:<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Você pode tentar sincronizá-lo manualmente.',

    'subscription-delete.queue' => 'Exclusão do processamento de assinaturas',
    'subscription-delete.done' => 'Assinaturas excluídas',
    'subscription-delete.error' => 'Falha na exclusão de assinaturas',

    'websites-diagnostic.queue' => 'Diagnóstico de websites em execução',
    'websites-diagnostic.done' => 'O diagnóstico de websites foi concluído',
    'websites-diagnostic.error' => 'O diagnóstico de websites foi concluído com erros',

    'install-php-extension.queue' => 'Instalando o pacote %%extensionName%% no manipulador PHP %%phpHandlerName%%',
    'install-php-extension.done' => 'O pacote %%extensionName%% foi instalado no manipulador PHP %%phpHandlerName%%',
    'install-php-extension.error' => 'Falha ao instalar o pacote %%extensionName%% no manipulador PHP %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Verificando requisitos',
    'install-php-extension.step.dependencies' => 'Resolvendo dependências',
    'install-php-extension.step.process' => 'Instalando o pacote',
    'install-php-extension.step.enable' => 'Habilitando extensão',
    'install-php-extension.step.sync' => 'Sincronizando websites',
    'install-php-extension.errorReason' => 'A lista de pacotes disponíveis é fornecida pelo PECL. Os motivos mais comuns para a falha na instalação são os seguintes:',
    'install-php-extension.errorReasonDependencies' => '- O pacote possui dependências externas em bibliotecas adicionais.',
    'install-php-extension.errorReasonRequirements' => '- O pacote não atende aos requisitos de instalação (SO, versão do PHP e assim por diante).',
    'install-php-extension.errorReasonOutdated' => '- O pacote está desatualizado.',
    'install-php-extension.errorOutput' => 'Para identificar o motivo da falha na instalação, examine a saída do utilitário.',

    'uninstall-php-extension.queue' => 'Desinstalando o pacote %%extensionName%% do manipulador PHP %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'O pacote %%extensionName%% foi desinstalado do manipulador PHP %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Falha ao desinstalar o pacote %%extensionName%% do manipulador PHP %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Verificando requisitos',
    'uninstall-php-extension.step.process' => 'Desinstalando pacote',
    'uninstall-php-extension.step.sync' => 'Sincronizando websites',
];