<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'Key number',
    'additional-keys.keyName' => 'Key name',
    'additional-keys.keyApp' => 'Application',
    'additional-keys.addGroup' => 'Add',
    'additional-keys.upload' => 'Install New Key',
    'additional-keys.uploadDescription' => 'Upload and install a new license key.',
    'additional-keys.actionsGroup' => 'Actions',
    'additional-keys.install' => 'Install',
    'additional-keys.installAll' => 'Install All',
    'additional-keys.installDescription' => 'Install the selected license keys.',
    'additional-keys.installNoSelection' => 'Select one or more additional license keys to install, or click "Install All".',
    'additional-keys.installSuccess' => 'License key installation has started.',
    'additional-keys.removeGroup' => 'Remove',
    'additional-keys.remove' => 'Remove',
    'additional-keys.removeDescription' => 'Remove the selected license keys.',
    'additional-keys.removeNoSelection' => 'Select one or more additional license keys to remove.',
    'additional-keys.removeConfirmation' => 'Remove {count, plural, =1 {the {name} license key} one {the # selected license key} other {the # selected license keys}}?',
    'additional-keys.removeSuccess' => 'The selected license keys were removed.',
    'additional-keys.download' => 'Download Key',
    'additional-keys.downloadDescription' => 'Download the license key.',
    'additional-keys.emptyViewTitle' => 'No additional license keys',

    'backup.tasks.startDate' => 'Started on',
    'backup.tasks.targetRepo' => 'Target storage',
    'backup.tasks.progress' => 'Task progress',
    'backup.tasks.repoTypeLocal' => 'Server',
    'backup.tasks.repoTypeFtp' => 'Personal FTP',
    'backup.tasks.buttonRemoveTask' => 'Remove',
    'backup.tasks.hintRemoveTask' => 'Remove the selected backup tasks.',
    'backup.tasks.buttonReload' => 'Reload',
    'backup.tasks.hintReload' => 'Reload the tasks list to obtain the actual status.',
    'backup.tasks.statusTaskWarnings' => 'Warnings',
    'backup.tasks.statusTaskInfo' => 'Information',
    'backup.tasks.statusTaskFailed' => 'Failed',

    'backup.disabledSelectHint' => 'The backup cannot be removed because it is a part of a server, reseller, or customer backup.',
    'backup.buttonBackup' => 'Back Up',
    'backup.hintBackup' => 'Create a backup.',
    'backup.buttonSchedule' => 'Schedule',
    'backup.hintSchedule' => 'Specify settings for a scheduled backup task.',
    'backup.buttonReload' => 'Reload',
    'backup.hintReload' => 'Reload the backup list.',
    'backup.buttonUpload' => 'Upload',
    'backup.hintUpload' => 'Upload a backup file from your computer to the server backup storage.',
    'backup.buttonSettings' => 'Settings',
    'backup.hintSettings' => 'Configure the global data backup settings to reduce server CPU load.',
    'backup.buttonRemoteStorages' => 'Remote Storage Settings',
    'backup.hintRemoteStorages' => 'Configure your personal remote storage for storing backup files.',
    'backup.buttonRemove' => 'Remove',
    'backup.hintRemove' => 'Remove the selected backups from the server storage.',
    'backup.systemNotes' => 'System notes',
    'backup.incremental' => 'Incremental.',
    'backup.multiVolume' => 'Multi-volume.',
    'backup.remoteStorage' => 'In the storage: %%storage%%',
    'backup.status' => 'S',
    'backup.statusOff' => 'This is not a valid backup. Data cannot be restored from this file. Click the backup name to see the details.',
    'backup.statusWarning' => 'This backup is not entirely valid. Click the backup name to see the details.',
    'backup.statusInfo' => 'This is a valid backup. Data can be restored from this backup but some minor issues might occur with the way the data is stored.',
    'backup.statusOn' => 'This is a valid backup. Data can be restored from this backup.',
    'backup.date' => 'Creation date',
    'backup.name' => 'Name',
    'backup.comment' => 'Comments',
    'backup.size' => 'Size',
    'backup.download' => 'Download the backup file to your local computer.',
    'backup.downloadDisabled' => 'Downloading of the backup file is temporarily unavailable. Please try later or contact your service provider.',
    'backup.total' => 'Total backups: %%total%%, size: %%totalSize%%',
    'backup.totalFound' => '%%found%% backups found (%%total%% total), size: %%totalSize%%',
    'backup.confirmOnDelete' => 'Do you want to remove the selected backups?',
    'backup.incrementsRemovalLoading' => 'Loading...',
    'backup.incrementsRemovalConfirmation' => 'I confirm I want to remove the selected backups.',
    'backup.backupHasIncrements' => 'The backup %%backupName%% will be removed together with its increments: %%backupIncrements%%',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Incorrect username or password for FTP storage',
    'backup.ftpStorageErrorResolveHost' => "Unable to resolve the host name",
    'backup.ftpStorageErrorConnection' => "Unable to connect to the remote server",
    'backup.unableToGetFtpDumpList' => 'Could not display the list of backups in the FTP Storage: %%errorMessage%%. Please check the <a href="%%ftpSettingsUrl%%">FTP storage settings</a>.',
    'backup.unableToGetExtDumpList' => 'Could not display the list of backups in the %%storageTitle%% storage: %%errorMessage%%. Please check the storage settings.',
    'backup.unableToGetLocalDumpList' => 'Could not display the list of backups stored on the server: %%errorMessage%%',
    'backup.skippedFilesAtExtStorage' => 'Some of the files in the storage %%storageTitle%% are not shown in the list because the names of those files do not conform to the naming convention of backup files. If you are sure that those files are valid backups, rename them to match the following pattern: "backup_%%objectName%%&lt;YYMMDDHHmm&gt;.%%ext%%"',
    'backup.multiVolumeShow' => 'Show Volumes',
    'backup.multiVolumeHide' => 'Hide Volumes',
    'backup.backEncryptionRequired' => 'For security reasons, we recommend that you protect data contained in backups. Please go to %%link%% and update backup security settings.',
    'backup.backupSettingPage' => 'Backup Settings',
    'backup.statusTaskProgress' => 'The backup task is in progress.',
    'backup.statusTaskWarnings' => 'The backup task finished with warnings.',
    'backup.statusTaskInfo' => 'Information.',
    'backup.statusTaskFailed' => 'The backup task failed.',
    'backup.statusTaskStopping' => 'The backup task is stopping.',
    'backup.statusTaskStopped' => 'The backup task was stopped.',

    'backup.schedule.columnSchedule' => 'Schedule',
    'backup.schedule.columnContent' => 'Content',
    'backup.schedule.columnStorage' => 'Storage',
    'backup.schedule.periodHourly' => 'Hourly',
    'backup.schedule.periodHourlySchedule' => '(every {period, plural, one {# hour} other {# hours}})',
    'backup.schedule.periodDaily' => 'Daily',
    'backup.schedule.periodDailySchedule' => '(at %%hours%%:%%minutes%%)',
    'backup.schedule.periodWeekly' => 'Weekly',
    'backup.schedule.periodWeeklySchedule' => '(on %%day%% at %%hours%%:%%minutes%%)',
    'backup.schedule.periodMonthly' => 'Monthly',
    'backup.schedule.periodMonthlySchedule' => '(on %%day%% day at %%hours%%:%%minutes%%)',
    'backup.schedule.periodCustom' => 'Custom',
    'backup.schedule.dayFirst' => 'first',
    'backup.schedule.dayLast' => 'last',
    'backup.schedule.day' => '{day, selectordinal, one {#st} two {#nd} few {#rd} other {#th}}',
    'backup.schedule.storageLocal' => 'Server storage',
    'backup.schedule.storageBoth' => 'Both server storage and %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'Scheduled backup was deactivated',

    'custombuttons.buttonAdd' => 'Add Link to Service',
    'custombuttons.buttonAddDescription' => 'Add a link to an online service and place it in Plesk.',
    'custombuttons.buttonRemove' => 'Remove',
    'custombuttons.buttonRemoveDescription' => 'Delete the selected links.',
    'custombuttons.removeConfirmMessage' => 'Remove the selected links?',
    'custombuttons.headerPublic' => 'A',
    'custombuttons.headerLocation' => 'L',
    'custombuttons.headerImage' => 'Image',
    'custombuttons.headerPriority' => 'Priority',
    'custombuttons.headerLabel' => 'Label',
    'custombuttons.headerUrl' => 'URL',
    'custombuttons.headerDescription' => 'Description',
    'custombuttons.publicEnabledDescription' => 'The link is visible to users.',
    'custombuttons.publicDisabledDescription' => 'The link is not visible to users.',
    'custombuttons.altPublicEnabledIcon' => 'Public',
    'custombuttons.altPublicDisabledIcon' => 'Private',
    'custombuttons.placeNavigationDescription' => 'The link is located on all pages.',
    'custombuttons.placeAdminDescription' => 'The link is located on the administrator\'s home page.',
    'custombuttons.placeAdminSettingsDescription' => 'The link is located on the administrator\'s Tools & Settings page.',
    'custombuttons.placeResellerDescription' => 'The link is located on the reseller\'s home page',
    'custombuttons.placeResellerSettingsDescription' => 'The link is located on the reseller\'s Tools & Utilities page.',
    'custombuttons.placeClientDescription' => 'The link is located on the customer\'s home page.',
    'custombuttons.placeDomainDescription' => 'The link is located on the Websites & Domains page of the Subscription.',
    'custombuttons.placeDomainPropertiesDescription' => 'The link is located in the website tools area, which opens on the Websites & Domains page by clicking Show More below a domain name.',

    'databaseservers.addGroup' => 'Add',
    'databaseservers.addDatabaseServer' => 'Add Database Server',
    'databaseservers.addDatabaseServerDescription' => 'Add a database server.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'Remote database hosting are not supported by the license key.',
    'databaseservers.actionsGroup' => 'Actions',
    'databaseservers.hostingSettings' => 'Settings',
    'databaseservers.hostingSettingsDescription' => 'Database hosting settings.',
    'databaseservers.refresh' => 'Refresh',
    'databaseservers.refreshDescription' => 'Refresh information about database servers.',
    'databaseservers.removeGroup' => 'Remove',
    'databaseservers.remove' => 'Remove',
    'databaseservers.removeDescription' => 'Delete the selected database servers.',
    'databaseservers.lastError' => 'S',
    'databaseservers.type' => 'Server type',
    'databaseservers.host' => 'Host name',
    'databaseservers.hostLink' => 'View or modify the properties of database server.',
    'databaseservers.port' => 'Port',
    'databaseservers.version' => 'Version',
    'databaseservers.databasesCount' => 'Databases',
    'databaseservers.databasesCountLink' => 'Manage the databases hosted on this server.',
    'databaseservers.webadmin' => 'Webadmin',
    'databaseservers.webadminHint' => 'Access this server via DB Webadmin.',
    'databaseservers.downloadMsSqlClient' => 'Download a local SQL Client',
    'databaseservers.downloadMsSqlClientHint' => 'Download a local SQL Client',
    'databaseservers.changePassword' => 'Change Administrator\'s Password',
    'databaseservers.changePasswordHint' => 'Change database server administrator\'s password.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Microsoft SQL Server',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'default for MySQL',
    'databaseservers.default_for_mssql' => 'default for MS SQL',
    'databaseservers.default_for_postgresql' => 'default for PostgreSQL',
    'databaseservers.default_for_mariadb' => 'default for MariaDB',
    'databaseservers.default_for_percona' => 'default for Percona',
    'databaseservers.status_no_error' => 'The last attempt to connect to this server was successful.',
    'databaseservers.status_connection_failed' => 'The last attempt to connect to this server failed because of network problems.',
    'databaseservers.status_permission_denied' => 'During the last attempt to connect to this server, access was denied. Please check the administrator credentials for the server.',
    'databaseservers.status_other_error' => 'During the last attempt to connect to this server, an error has occurred.',
    'databaseservers.status_credentials_not_set' => 'You need to supply a valid administrator username and password before Plesk can connect to this server.',
    'databaseservers.mssqlServerPortUndefined' => 'Unable to determine the TCP port number used by Microsoft SQL server \'%%host%%\': TCP/IP protocol is not enabled in the server network configuration or the server is configured to use dynamic TCP ports.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'To allow your customers to automatically configure firewall for remote database access, manually configure the SQL server to listen on a specific fixed TCP port.',
    'databaseservers.removeEmptySelection' => 'No database servers selected.',
    'databaseservers.removeConfirmation' => 'Are you sure to remove {count, plural, =1 {the {name} database server} one {the # selected database server} other {the # selected database servers}}?',
    'databaseservers.removeSuccess' => 'The selected database servers were successfully removed.',

    'databaseserverdatabases.actionsGroup' => 'Actions',
    'databaseserverdatabases.assignToSubscription' => 'Move to Subscription',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'Move the selected databases to another subscription.',
    'databaseserverdatabases.removeGroup' => 'Remove',
    'databaseserverdatabases.remove' => 'Remove',
    'databaseserverdatabases.removeDescription' => 'Delete the selected databases.',
    'databaseserverdatabases.name' => 'Name',
    'databaseserverdatabases.subscription' => 'Subscription',
    'databaseserverdatabases.client' => 'Subscriber',
    'databaseserverdatabases.manageDatabase' => 'Manage Hosting',
    'databaseserverdatabases.manageDatabaseDescription' => 'Manage the database.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Open in Reseller Panel',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Manage the database in the subscriber\'s Reseller Panel.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Open in Customer Panel',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Manage the database in the subscriber\'s Customer Panel.',
    'databaseserverdatabases.emptySelection' => 'No databases selected.',
    'databaseserverdatabases.removeConfirmation' => 'Are you sure to remove {count, plural, =1 {the {name} database} one {the # selected database} other {the # selected databases}}?',
    'databaseserverdatabases.removeSuccess' => 'The selected database servers were successfully removed.',

    'logbrowser.issuesFoundInTheLogs' => 'Issues in the website logs',
    'logbrowser.learnAboutProblemsFaster' => 'Catch website issues faster',
    'logbrowser.noProblemsFound' => 'No issues in the website logs',
    'logbrowser.lastCheckDetectsProblems' => '%%checkType%% check of the logs has detected issues that can affect your website operation. To see the details and possible solutions, click “Open check report”.',
    'logbrowser.lastCheckDetectsNoProblems' => '%%checkType%% check of the log has detected no issues that can affect your website operation.',
    'logbrowser.noChecksResults' => 'An automatic daily check is enabled, but no any checks were conducted.',
    'logbrowser.manual' => 'A manual',
    'logbrowser.regular' => 'An automatic daily',
    'logbrowser.enableRegularCheck' => 'A daily check of the logs detects issues that can affect your website operation. If any issues appear, Plesk will inform you and provide possible solutions.',
    'logbrowser.new' => 'NEW',
    'logbrowser.openCheckReport' => 'Open check report',
    'logbrowser.openCheckSettings' => 'Open check settings',

    'logbrowser.buttonStartRealtime' => 'Start real-time updates',
    'logbrowser.buttonStartRealtimeHint' => 'Update log data in real time.',
    'logbrowser.buttonStopRealtime' => 'Stop real-time updates',
    'logbrowser.buttonStopRealtimeHint' => 'Stop updating log data in real time.',
    'logbrowser.buttonRefresh' => 'Refresh',
    'logbrowser.buttonRefreshHint' => 'Refresh log data.',
    'logbrowser.buttonClear' => 'Clear',
    'logbrowser.buttonClearHint' => 'Hide already loaded entries.',
    'logbrowser.buttonAddCustom' => 'Add to Log Browser as Custom file',
    'logbrowser.buttonAddCustomHint' => 'The file will be displayed in Log Browser with other log files.',
    'logbrowser.date' => 'Date',
    'logbrowser.dateFilterPlaceholder' => 'From',
    'logbrowser.type' => 'Type',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Code',
    'logbrowser.codeFilterPlaceholder' => 'Code',
    'logbrowser.message' => 'Message',
    'logbrowser.messageFilterPlaceholder' => 'Message',
    'logbrowser.source' => 'Source',
    'logbrowser.sourceFilterFiles' => '%%count%% files',
    'logbrowser.sourceFilterAllLogs' => 'All logs',
    'logbrowser.sourceFilterNoLogs' => 'No logs',
    'logbrowser.manageLogFiles' => 'Manage Log Files',
    'logbrowser.addCustomLogFile' => 'Add custom log',
    'logbrowser.customLogPopupTitle' => 'Add Custom Log',
    'logbrowser.invalidLogFormat' => 'The log file has unsupported format',
    'logbrowser.referer' => 'R',
    'logbrowser.refererHint' => 'Referer',
    'logbrowser.agent' => 'Agent',
    'logbrowser.agentHint' => 'User agent',
    'logbrowser.size' => 'Size',
    'logbrowser.unknown' => 'Unknown',
    'logbrowser.more' => 'More ',
    'logbrowser.less' => ' Less',
    'logbrowser.any' => 'Any',
    'logbrowser.none' => 'None',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% or use filters to narrow down the list of entries.',
    'logbrowser.loadMore' => 'Load previous entries',
    'logbrowser.clear' => 'Clear',
    'logbrowser.hourAgo' => 'Hour Ago',
    'logbrowser.prevDay' => 'Prev Day',
    'logbrowser.linkInMessageToViewFile' => 'Click to view the file.',
    'logbrowser.buttonUnlinkHint' => 'Click to stop tracking updates in this file in Log Browser',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Are you sure you want to stop tracking updates in this file in Log Browser?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Yes',
    'logbrowser.buttonUnlinkConfirmationNo' => 'No',
    'logbrowser.logRotation' => 'Log Rotation',
    'logbrowser.logRotationHint' => 'Set up the log rotation settings for the website.',
    'logbrowser.logRotationTitle' => 'Configure Log Rotation',

    'notifications.title' => 'Set Up Sending of Email Notices on System Events',
    'notifications.legendNotifications' => 'Notifications',
    'notifications.legendSettings' => 'Settings',
    'notifications.headerEvent' => 'Event',
    'notifications.headerSendTo' => 'Send notice to:',
    'notifications.headerText' => 'Text',
    'notifications.headerPreview' => 'Preview',
    'notifications.headerAdmin' => 'Administrator',
    'notifications.headerReseller' => 'Reseller',
    'notifications.headerClient' => 'Customer',
    'notifications.headerEmailAddress' => 'Email address',
    'notifications.expirationTime' => 'Send expiration warnings',
    'notifications.days' => ' days in advance',
    'notifications.smtpSettings' => 'To enable Plesk to send notifications when the relay is closed, you can %%link%%',
    'notifications.smtpSettingsLink' => 'change SMTP settings',
    'notifications.editHint' => 'Edit notice text.',
    'notifications.previewHint' => 'See how the notification looks in emails.',
    'notifications.reseller_creation' => 'Reseller account creation',
    'notifications.reseller_limits_exceed' => 'Resource usage limits exceeded by reseller account',
    'notifications.reseller_blocked' => 'Reseller account suspended due to resource overuse',
    'notifications.reseller_overuse_block' => 'Reseller\'s resource usage limits reached by reseller\'s subscriptions due to overselling',
    'notifications.client_creation' => 'Customer account creation',
    'notifications.domain_creation' => 'Site creation',
    'notifications.domain_exp_warning' => 'Subscription expiration warning',
    'notifications.domain_expiration' => 'Subscription expiration',
    'notifications.domain_limits_exceed' => 'Resource usage limits exceeded by subscription',
    'notifications.domain_blocked' => 'Subscription suspended due to resource overuse',
    'notifications.admin_aps_app_updates' => 'APS application updates (administrator\'s digest)',
    'notifications.reseller_aps_app_updates' => 'APS application updates (reseller\'s digest)',
    'notifications.client_aps_app_updates' => 'APS application updates (customer\'s digest)',
    'notifications.admin_pum_updates' => 'System Updates: notifications about new updates',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'Outgoing mail has exceeded limits',
    'notifications.subscription_cgroups_limits_exceed' => 'RAM, CPU, and Disk I/O (Cgroups)',
    'notifications.admin_postponed_feedback' => 'Feedback reminder',
    'notifications.errorInvalidEmail' => 'Incorrect email address.',
    'notifications.errorInvalidExpTime' => 'Number of days is invalid.',
    'notifications.errorUpdate' => 'Unable to update notification: %%error%%',
    'notifications.updated' => 'Notifications settings were updated',

    'outgoingmail.name' => 'Name',
    'outgoingmail.maxOutgoingMessages' => 'Limit per Hour',
    'outgoingmail.numOfExceedingAttempts' => 'Attempts after Reaching the Limit',
    'outgoingmail.lastAttemptAt' => 'Last Attempt',
    'outgoingmail.mailStatus' => 'Mail Status',
    'outgoingmail.mailStatusSending' => 'Sending',
    'outgoingmail.mailStatusNotSending' => 'Not Sending',
    'outgoingmail.mailStatusSendingDesc' => 'Mail is being sent.',
    'outgoingmail.mailStatusNotSendingDesc' => 'Mail is not being sent.',
    'outgoingmail.limitValueUnlimited' => 'Unlimited',

    'scheduler.tasks.headerCommand' => 'Command',
    'scheduler.tasks.headerSchedule' => 'Schedule',
    'scheduler.tasks.headerSubscription' => 'Subscription',
    'scheduler.tasks.headerSubscription_powerUser' => 'Webspace',
    'scheduler.tasks.buttonToggleHintOn' => 'The task is activated. Click to deactivate the task.',
    'scheduler.tasks.buttonToggleHintOff' => 'The task is deactivated. Click to activate the task.',
    'scheduler.tasks.add' => 'Add Task',
    'scheduler.tasks.hintAdd' => 'Schedule a new task.',
    'scheduler.tasks.remove' => 'Remove',
    'scheduler.tasks.hintRemove' => 'Remove the selected tasks.',
    'scheduler.tasks.confirmOnDelete' => 'Do you want to remove the selected tasks?',
    'scheduler.tasks.sync' => 'Refresh',
    'scheduler.tasks.hintSync' => 'Reload the task list to obtain the actual data.',
    'scheduler.tasks.settings' => 'Settings',
    'scheduler.tasks.hintSettings' => 'Edit scheduled tasks settings.',
    'scheduler.tasks.deleteSuccess' => 'The scheduled tasks were removed.',
    'scheduler.tasks.serverTask' => 'server (user:%%user%%)',
    'scheduler.tasks.unknownUser' => 'unknown',
    'scheduler.tasks.runTaskNow' => 'Run Now',
    'scheduler.tasks.runTaskNowHint' => 'Run the task now.',
    'scheduler.tasks.runningTask' => 'Running the task "%%task%%"...',

    'server-components.bcTitle' => 'Server components',
    'server-components.title' => 'Plesk components',
    'server-components.name' => 'Component name',
    'server-components.version' => 'Component version',
    'server-components.refresh' => 'Refresh',
    'server-components.componentName' => 'Enter component name...',
    'server-components.noComponents' => 'No components found',
    'server-components.componentsListUpdated' => 'The list of components was updated',

    'server-components.componentName.urlrewrite' => 'URL Rewrite',
    'server-components.componentName.dbconnector' => "Database Connector",
    'server-components.componentName.mysqlserver' => 'MySQL Server',
    'server-components.componentName.troubleshooting' => 'Troubleshooting',
    'server-components.componentName.waf' => 'Web Application Firewall',
    'server-components.componentName.vcs' => 'Version Control System',
    'server-components.componentName.dotnetcore' => '.NET Core',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Application Initialization",
    'server-components.componentName.httpcompression' => 'HTTP Content Compression',
    'server-components.componentName.antivirus' => "Antivirus",
    'server-components.componentName.database' => "SQL Server",
    'server-components.componentName.sqladmin' => "MySQL Webadmin",
    'server-components.componentName.sqladminmysql' => "MySQL Webadmin",
    'server-components.componentName.dnsserver' => "DNS Server",
    'server-components.componentName.firewall' => "Firewall",
    'server-components.componentName.ftpserver' => "FTP Server",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "Mail Server",
    'server-components.componentName.local_mailserver' => "Local Mail Server",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Web Scripting",
    'server-components.componentName.spamfilter' => "Spam Filter",
    'server-components.componentName.stats' => "Web Statistics",
    'server-components.componentName.stunnel' => "SSL/TLS Wrapper",
    'server-components.componentName.webmail' => "Webmail",
    'server-components.componentName.webpublish' => "Web Publishing",
    'server-components.componentName.webserver' => "Web Server",
    'server-components.componentName.network' => 'Networking',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Plesk Hosting",
    'server-components.componentName.savi' => 'Sophos Anti-Virus Interface',

    'server-components.tooltip.disabled' => 'Switched off',
    'server-components.tooltip.active' => 'Active',
    'server-components.tooltip.notConfigured' => 'Not configured',
    'server-components.tooltip.notStarted' => 'Not started, check component settings',

    'server-components.defaultComponents.circularDependencies' => "Circular dependencies were found between %%cat1%% and %%cat2%% categories",
    'server-components.defaultComponents.not_installed' => "(not installed)",
    'server-components.defaultComponents.not_configured' => "(not configured)",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Some services categories contain invalid selections, or no selections were made.",
    'server-components.defaultComponents.depends_on' => "(requires %%name%%)",
    'server-components.defaultComponents.not_activated' => 'not activated',
    'server-components.defaultComponents.imap_required' => '(Current mail server does not support IMAP)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(FTP server does not support IPv6 addresses.)",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(the required delegation rule \'appPoolPipeline, appPoolNetFx\' does not exist)',
    'server-components.defaultComponents.not_supported_version' => '(not supported version)',
    'server-components.defaultComponents.no_license' => '(not allowed by license key)',
    'server-components.defaultComponents.license_expired' => '(license key has expired)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(license key mailboxes limit exceeded)',
    'server-components.defaultComponents.title' => 'Select default %%name%% component',
    'server-components.defaultComponents.none' => 'None',
    'server-components.defaultComponents.yes' => 'Yes',
    'server-components.defaultComponents.no' => 'No',
    'server-components.defaultComponents.warning' => 'Warning!',
    'server-components.defaultComponents.parametersOfComponent' => 'Parameters of %%component%%',
    'server-components.defaultComponents.success' => 'Default component was updated',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "Changing mail server is intended only for initial setup and, if the server is already in use, causes the following problems: loss of settings and mailboxes content, and, in cases when the server you switch to is already configured, various conflicts.\nIf this server is in use now and you are certain about switching to another, you can notify your customers about the operation so that they could download and save their mail.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Only the first 254 IP addresses of subnets with /8 and /16 masks located in the Access Control List will be transferred. They will be transferred as separate IP addresses. Do you wish to continue?",

    'server-components.componentConf.title' => 'Parameters of %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'Parameter is required',
    'server-components.componentConf.parameterShouldBeNumber' => 'Parameter should be a number',
    'server-components.componentConf.success' => 'Parameters were updated',

    'tasks.pollingOff' => 'Off',
    'tasks.pollingDelay' => '%%delay%% s',
    'tasks.stopTaskConfirm' => 'Are you sure you want to stop the task?',
    'tasks.stopTaskError' => 'Failed to stop task',
    'tasks.stopTask' => 'Stop task',
    'tasks.processedLoadFailed' => 'Failed to load processes list',
    'tasks.retryTask' => 'Retry task',
    'tasks.retryTaskFailed' => 'Failed to retry task',
    'tasks.taskCreated' => 'New task successfully created',
    'tasks.moreDetails' => 'See panel log for details',
    'tasks.searchTitle' => 'Search',
    'tasks.searchPlaceholder' => 'Search string',
    'tasks.refresh' => 'Refresh',
    'tasks.refreshDescription' => 'Refresh tasks list',
    'tasks.createTask' => 'Create Task',
    'tasks.openSwagger' => 'Open Swagger',
    'tasks.statusTitle' => 'Status',
    'tasks.createdTitle' => 'Created',
    'tasks.descriptionTitle' => 'Description',
    'tasks.processes.dataLoadFailed' => 'Failed to get data from server',
    'tasks.processes.commandLineLoadFailed' => 'Failed to get task command line',
    'tasks.processes.stopProcess' => 'Stop process',
    'tasks.processes.stopProcessFailed' => 'Failed to stop process',
    'tasks.processes.stopProcessConfirm' => 'Are you sure you want to stop the process?',
    'tasks.processes.copyToClipboard' => 'Copy to clipboard',
    'tasks.processes.concurrency' => 'Concurrency',
    'tasks.processes.taskIdSection' => 'Task ID',
    'tasks.processes.requestorIdSection' => 'Requestor ID',
    'tasks.processes.timeoutSection' => 'Timeout',
    'tasks.processes.createdSection' => 'Created',
    'tasks.processes.updatedSection' => 'Updated',
    'tasks.processes.environmentSection' => 'Environment',
    'tasks.processes.idTitle' => 'ID',
    'tasks.processes.statusTitle' => 'Status',
    'tasks.processes.startedTitle' => 'Started',
    'tasks.processes.completedTitle' => 'Completed',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Exit Code',

    'ts-sessions.columnStateTitle' => 'State',
    'ts-sessions.columnUserTitle' => 'User',
    'ts-sessions.columnNameTitle' => 'Name',
    'ts-sessions.refresh' => 'Refresh',
    'ts-sessions.logoff' => 'Log off',
    'ts-sessions.logoffConfirmation' => 'Log off %%count%% session(s)?',
    'ts-sessions.logoffConfirmationSingle' => 'Log off the %%name%% session?',
    'ts-sessions.logoffConfirmationButton' => 'Yes, log off',
    'ts-sessions.logoffNoSelection' => 'Select one or more sessions to log off',
    'ts-sessions.logoffSuccess' => 'The selected sessions were logged off.',
    'ts-sessions.disconnect' => 'Disconnect',
    'ts-sessions.disconnectConfirmation' => 'Disconnect %%count%% session(s)?',
    'ts-sessions.disconnectConfirmationSingle' => 'Disconnect the %%name%% session?',
    'ts-sessions.disconnectConfirmationButton' => 'Yes, disconnect',
    'ts-sessions.disconnectSuccess' => 'The selected sessions were disconnected.',
    'ts-sessions.disconnectNoSelection' => 'Select one or more sessions to disconnect',
    'ts-sessions.disconnectNotAvailable' => 'You can only disconnect active or connected sessions.',

    'client-ip-address.title' => 'IP Addresses',
    'client-ip-address.status' => 'Status',
    'client-ip-address.type' => 'Type',
    'client-ip-address.ipAddress' => 'IP Address',
    'client-ip-address.certificate' => 'Certificate',
    'client-ip-address.hosting' => 'Hosting',
    'client-ip-address.adminCertificateRepository' => "Administrator's repository",
    'client-ip-address.domainCertificateRepository' => 'Repository of domain %%owner%%',
    'client-ip-address.typeShared' => 'Shared',
    'client-ip-address.typeExclusive' => 'Dedicated',
    'client-ip-address.removeConfirmation' => 'Remove {count, plural, =1 {the {name} IP addresses} one {the # selected IP addresses} other {the # selected IP addresses}} from the user\'s IP pool?',
    'client-ip-address.noItemsToRemove' => 'Select one or more items to remove.',
    'client-ip-address.ftpOverSSL' => 'FTP over SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Yes',
    'client-ip-address.ftpOverSSL-no' => 'No',
    'client-ip-address.ftpOverSSL-allow' => 'Allow',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Not allowed',
    'client-ip-address.add' => 'Add IP Address',
    'client-ip-address.noAvailableIps' => 'There are no available IP addresses.',
    'client-ip-address.isOk' => 'IP address functions properly.',
    'client-ip-address.isBroken' => 'IP address is not present on the interface.',
    'client-ip-address.properties.title' => 'IP address %%address%% on the interface %%interface%%',
    'client-ip-address.properties.distributedType' => 'IP address distributed as',
    'client-ip-address.properties.allocatedType' => 'IP address allocated as',
    'client-ip-address.properties.none' => 'None',
    'client-ip-address.properties.certificate' => 'SSL/TLS certificate',
    'client-ip-address.properties.defaultSite' => 'Default website',
    'client-ip-address.assign.title' => 'Select IP addresses',
    'client-ip-address.assign.description' => 'Vacant IPs',
    'client-ip-address.assign.success' => '{count, plural, =1 {the {name} IP address} one {the # selected IP addresses} other {the # selected IP addresses}} was successfully added to the user\'s IP pool',

    'ip-address-reseller-usage.title' => 'Resellers who use %%type%% IP address %%ipAddress%%',
    'ip-address-reseller-usage.nameColumnHeader' => 'Resellers',
    'ip-address-reseller-usage.assignButton' => 'Assign to reseller',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'This IP address is already assigned to all users.',
    'ip-address-reseller-usage.removeButton' => 'Remove',
    'ip-address-reseller-usage.removeSuccess' => 'The IP address was removed from {count, plural, =1 {the {name} pool} one {the # selected resellers\' pools} other {the # selected resellers\' IP pools}}.',
    'ip-address-reseller-usage.removeConfirmation' => 'Remove the IP address from {count, plural, =1 {the {name} IP pool} one {the # selected resellers\' IP pools} other {the # selected resellers\' IP pools}}?',
    'ip-address-reseller-usage.typeSHARED' => 'Shared',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Dedicated',
    'ip-address-reseller-usage.assign.title' => "Add %%ipAddress%% to the reseller IP pool",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Resellers to add',
    'ip-address-reseller-usage.assign.success' => 'The IP address was added to {count, plural, =1 {the {name} IP pool} one {the # selected resellers\' IP pools} other {the # selected resellers\' IP pools}}.'
];
