<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Va fi gata în curând.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Va fi gata în curând.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Simptome</h4><ul><li><p>Site-urile care au handlerul PHP setat la <strong>Aplicația FPM de la Apache</strong> sau <strong>Aplicația FPM de la nginx</strong> în <strong>Domenii</strong> &gt; <strong>exemplu.ro</strong> &gt; <strong>Setări PHP</strong> se confruntă cu una dintre următoarele probleme:</p><ul><li><p>se încarcă încet</p></li><li><p>sunt inaccesibile (continuu sau ocazional) cu eroare 50x în browser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Următorul mesaj apare în jurnalul de erori PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (unde <em>XX</em> este versiunea de PHP folosită de site-uri):</p><pre>AVERTIZARE: [pool exemplu.ro] server reached max_children setting (*), luați în calcul mărirea setării</pre><ul><li><p>De obicei, mesajul de mai sus este însoțit de următoarea eroare:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Dacă nginx este activat pe server, în jurnalul de erori al domeniului poate apărea unul dintre următoarele mesaje <code>/var/www/vhosts/system/exemplu.ro/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> a fost atins de site(-uri).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Mărirea limitei pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Măriți limita <code>pm.max_children</code> pentru domeniile afectate:</p><ol><li><p>Conectați-vă la serverul Plesk prin <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Găsiți domeniile afectate, folosind comanda:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Observație:</strong> Numărul din stânga indică de câte ori a atins site-ul limita <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 exemplu.ro<br>50 exemplu.net<br>25 exemplu.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Conectați-vă la Plesk</a>.</p></li><li><p>Accesați <strong>Domenii</strong> &gt; <strong>exemplu.ro</strong> &gt; <strong>Setări PHP</strong> &gt; <strong>Setări PHP-FPM</strong>.</p></li><li><p>Măriți valoarea <code>pm.max_children</code> pentru domeniu și aplicați modificările. Măriți această valoare pentru toate domeniile menționate în pasul 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx nu pornește/nu se reîncarcă pe un server Plesk: Too many open files</p><h4>Simptome</h4><ul><li><p>Serviciul nginx nu pornește/nu se reîncarcă și apare următoarea eroare în fișierul <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Unele site-uri (sau toate) nu sunt accesibile</p></li><li><p>Apare o avertizare în <strong>Instrumente &amp; Setări &gt; Diagnosticare și reparare</strong>:</p><pre style="white-space: pre-wrap;">Se verifică valoarea nginx ULIMIT. S-au găsit N domenii pe server. Pot apărea probleme cu limita implicită de fișiere deschise în nginx</pre></li><li><p>Aplicațiile web NodeJS și Ruby afișează eroarea 502 Bad Gateway la executarea unor sarcini Plesk, cum ar fi crearea de domenii, abonamente, modificări în Apache sau Nginx etc.:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Serverul web a primit răspuns incorect în timp ce executa o funcție de gateway sau de server proxy.</pre></li><li><p>După <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instalarea unui certificat nou pentru domeniu</a>, cel vechi continuă să apară în browser, dar în pagina <strong>Domenii &gt; exemplu.ro &gt; Setări de găzduire</strong> este selectat certificatul corect.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Gazda virtuală nginx deschide 4 fișiere jurnal pentru fiecare gazdă virtuală cu găzduire fizică:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Drept urmare, numărul maxim de fișiere deschise este depășit de serverul nginx din cauza numărului mare de domenii (de obicei, peste 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Mărirea numărului limită de fișiere deschise',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Avertizare:</strong> Executarea utilitarului <code>websrv_ulimits</code> fără opțiunea <strong>--no-restart</strong> declanșează regenerarea fișierelor de configurare web pentru toate domeniile și poate duce la indisponibilitate prelungită dacă numărul de site-uri găzduite este mare.<br><br>Executați comanda în perioada de întreținere.</div><p>Este o practică bună să setați numărul limită de fișiere deschise la o valoare cel puțin mai mare decât <strong>numărul domeniilor în Plesk * 16</strong>. În exemplul de mai jos, prezentăm acțiunile necesare pentru a seta limita la 4096:</p><ol><li><p>Conectați-vă la server prin <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Setați limita de fișiere deschise la 4096, atât pentru Apache, cât și pentru nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Reporniți serviciile Apache și nginx prin <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Instrumente &amp; Setări &gt; Administrare servicii</strong> pentru a aplica modificările.</p></li><li><p>Verificați dacă s-a aplicat corect „Max open files limit”, după repornirea serviciilor web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Dacă abordarea de mai sus nu a rezolvat problema, setați limita folosind utilitarul <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Va fi gata în curând.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Simptome</h4><ul><li><p>ModSecurity este instalat și activat în <strong>Instrumente și setări > Firewall de aplicații web (ModSecurity) > Mod firewall de aplicații web > Pornit</strong>.</p></li><li>Un site găzduit în Plesk nu se încarcă. Pe site nu se pot executa operații cum ar fi administrarea WordPress, accesarea webmailului sau accesarea fișierului <code>robots.txt</code>. Browserul poate afișa una dintre următoarele erori: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>În fișierul jurnal <code>/var/log/modsec_audit.log</code> sau în pagina Jurnale din Plesk (<strong>Domenii</strong> &gt; <strong>example.com</strong> &gt; <strong>Jurnale</strong>) apare un mesaj de eroare ModSecurity cum ar fi: <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Firewallul de aplicații web ModSecurity este activat cu un set de reguli foarte restrictive, cum ar fi OWASP, Comodo sau cu un set de reguli personalizate, cum ar fi Imunify360. Seturile de reguli restrictive pot bloca anumite operații pe site.</p><p><Strong>Observație:</strong> Eroarea ModSecurity poate indica un atac asupra serverului. Utilizați soluțiile de mai jos numai dacă știți sigur că ModSecurity blochează acțiuni legitime pe site.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Dezactivarea setului de reguli ModSecurity după ID sau Etichetă',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Căutați ID-ul regulii care blochează utilizarea legitimă a site-ului. ID-urile se găsesc în mesajele de eroare din fișierul jurnal <code>/var/log/modsec_audit.log</code>. ID-ul este un număr întreg trecut între ghilimele, cu prefixul <code>id</code> între paranteze drepte, de exemplu, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Dezactivarea seturilor de reguli individuale în Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Comutare la alt set de reguli ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Comutați la un set de reguli ModSecurity mai puțin restrictive, de exemplu, „Atomic ModSecurity Ruleset”. Pentru a face acest lucru, accesați <strong>Instrumente și setări</strong> > <strong>Firewall de aplicații web (ModSecurity)</strong> > <strong>Setări</strong>, selectați <strong>Atomic Standard</strong>, apoi faceți clic pe <strong>OK</strong> pentru a aplica modificările.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Simptome</h4><ul><li><p>Un site găzduit în Plesk nu este accesibil:</p><pre>500 Internal Server Error</pre></li><li><p>În jurnalul site-ului apare următoarea eroare:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Site-ul nu are destulă memorie alocată pentru procesare.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Mărirea parametrului memory_limit al site-ului',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Citiți articolul KB și urmați instrucțiunile</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Simptome</h4><ul><li><p>Un site nu poate fi accesat, iar în browser apare una dintre următoarele erori:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Mesajul de eroare de mai jos apare în pagina Jurnale a domeniului (<strong>Domenii</strong> > <strong>example.com</strong> > <strong>Jurnale</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Scriptul PHP încearcă să acceseze directorul la care nu este permis accesul. Această restricție este definită de directiva PHP <code>open_basedir</code>, individual pentru fiecare domeniu. Implicit, <code>open_basedir</code> permite accesul la <code>tmp</code> și la directorul rădăcină de documente al domeniului, precum și la calea implicită de sesiuni a sistemului.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Adăugați calea suplimentară în directiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Citiți articolul KB și urmați instrucțiunile</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Dezactivarea directivei open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Accesați pagina <strong>Domenii &gt example.com &gt Setări PHP</strong> și setați directiva <code>open_basedir</code> la „none”.</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Simptome</h4><ul><li><p>Site-ul afișează un mesaj de eroare asemănător cu următorul:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Fișierul jurnal <code>/var/www/vhosts/system/example.com/logs/error_log</code> conține erori asemănătoare cu următoarea:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Configurația Apache actuală nu permite accesul la site.</p><p>Acest lucru este normal la fișiere ca .htaccess și .htpasswd, pentru că acestea nu trebuie să fie accesibile prin serverul web.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Verificarea fișierelor de configurare a serverului și a fișierului .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Citiți articolul KB și urmați instrucțiunile</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Simptome</h4><ul><li><p>Nu se poate accesa o anumită locație a site-ului, de exemplu, <code>http://example.com/some_folder</code>. Apare următoarea eroare:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Apare următoarea eroare în fișierul <code>/var/www/vhosts/example.com/logs/error_log<code/>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Directorul solicitat nu conține fișiere index sau navigarea în directoare nu este activată.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Adăugarea unui fișier index în director',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Citiți articolul KB și urmați instrucțiunile</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Activarea navigării în directoare',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Citiți articolul KB și urmați instrucțiunile</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Simptome</h4><ul><li><p>Nu se poate accesa o anumită locație a site-ului, de exemplu, <code>http://example.com/some_folder</code>. Apare Următoarea eroare:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Apare următoarea eroare în fișierul <code>/var/www/vhosts/example.com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Directorul solicitat nu conține fișiere index sau navigarea în directoare nu este activată.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Adăugarea unui fișier index în director',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Citiți articolul KB și urmați instrucțiunile</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Activarea navigării în directoare',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Citiți articolul KB și urmați instrucțiunile</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Va fi gata în curând.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Va fi gata în curând.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Va fi gata în curând.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sesiuni PHP "503 Internal Server Error" sau "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Va fi gata în curând.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Simptome</h4><ul><li><p>Un site găzduit în Plesk nu funcționează:</p><pre>Nu aveți permisiunea de a accesa / pe acest server. <br> De asemenea, a apărut eroarea 403 Forbidden la încercarea de a gestiona solicitarea cu un ErrorDocument.</pre><p>În locul erorii de mai sus poate să apară o pagină goală.</p></li><li><p>Jurnalul de erori de domeniu din <strong>Domenii &gt example.com &gt Jurnale</strong> conține următoarele:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Permisiuni incorecte pentru fișierele sau folderele din domeniu.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Repararea permisiunilor pentru conținutul site-ului',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Citiți articolul KB și urmați instrucțiunile</a>.</p></li></ol>',
];