<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream enviou cabeçalho muito grande ao ler o cabeçalho de resposta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Ficará pronto em breve.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Opção FollowSymLinks não permitida aqui"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Ficará pronto em breve.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "servidor atingiu a configuração max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Sintomas</h4><ul><li><p>Webites que têm manipulador PHP definido como <strong>aplicativo FPM servido por Apache</strong> ou <strong>aplicativo FPM servido por nginx</strong> em <strong>Domínios</strong> &gt; <strong>example.com</strong> &gt; As <strong>Configurações do PHP</strong> apresentam um dos seguintes problemas:</p><ul><li><p>carregamento lento</p></li><li><p>não acessível (permanentemente ou periodicamente) com um erro de 50x em um navegador da Web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Serviço temporariamente indisponível</pre><hr><pre>504 Tempo limite do gateway</pre></li></ul></li><li><p>A seguinte mensagem aparece no arquivo de log de erros PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (onde <em>XX</em> é uma versão PHP usada pelos websites):</p><pre>AVISO: servidor [pool example.com] alcançado configuração max_children (*), considere aumentá-la</pre><ul><li><p>A mensagem acima geralmente é acompanhada com este erro:</p><pre>não é possível ler o que o filho diz: Descritor de arquivo incorreto (9)</pre></li></ul></li><li><p>Se o nginx estiver habilitado no servidor, uma das seguintes mensagens de erro pode aparecer no arquivo de log de erros do domínio <code>/var/ www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 conectar() para unix:///var/www/vhosts/system /example.com/php-fpm.sock falhou (11: Recurso temporariamente indisponível) durante a conexão com upstream, cliente: 203.0.113.2, servidor: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream conexão fechada prematuramente ao ler o cabeçalho de resposta do upstream, cliente: 203.0.113.2, servidor: example.com, solicitação: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>O PHP-FPM <code>pm.max_children</code> foi alcançado pelo(s) website(s).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Aumente o limite pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Aumente o limite de <code>pm.max_children</code> para os domínios afetados:</p><ol><li><p>Conecte-se ao servidor Plesk via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Encontre os domínios afetados usando o comando abaixo:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Observação:</strong> o número à esquerda indica quantas vezes o limite de <code>pm.max_children</code> foi atingido pelo website.</div><pre style="white-space: pre-wrap;"># grep -r "servidor alcançado configuração max_children" /var/log/*php*-fpm/error.log | corte -d\' \' -f5 | tr -d \']\' | classificar | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Faça login no Plesk</a>.</p></li><li><p>Vá para <strong>Domínios</strong> &gt; <strong>example.com</strong> &gt; <strong>Configurações do PHP</strong> &gt; <strong>Configurações do PHP-FPM</strong>.</p></li><li><p>Aumente o valor <code>pm.max_children</code> para o domínio e aplique as alterações. Aumente esse valor para todos os domínios listados na etapa 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Muitos arquivos abertos"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx falha ao iniciar/recarregar em um servidor Plesk: muitos arquivos abertos</p><h4>Sintomas</h4><ul><li><p>O serviço nginx falha ao iniciar/recarregar com o seguinte erro no arquivo <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com /logs/proxy_access_ssl_log" falhou (24: muitos arquivos abertos)</pre></li><li><p>Alguns ou todos os websites não estão acessíveis</p></li><li><p>Aviso é mostrado em <strong>Ferramentas &amp; Configurações &gt; Diagnosticar &amp; reparar</strong>:</p><pre style="white-space: pre-wrap;">Verificando para nginx ULIMIT value N domínios foram encontrados no servidor. Problema com o limite padrão do nginx para arquivos abertos é possível</pre></li><li><p>Aplicativos da web NodeJS e Ruby estão mostrando o erro 502 Bad Gateway ao executar algumas tarefas do Plesk, como criar domínios, assinaturas, alterações no Apache ou Nginx, etc:</p><pre style="white-space: pre-wrap;">Erro de Servidor<br>502 Bad Gateway <br>O servidor Web recebeu uma resposta inválida enquanto atuava como um gateway ou servidor proxy.</pre></li><li><p>Após <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instalar um novo certificado para o domínio</a>, o antigo ainda é exibido em um navegador da Web, no entanto, o certificado correto é selecionado em <strong>Domínios &gt; example.com &gt; Página de configurações de hospedagem</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>O host virtual do Nginx abre 4 arquivos de log para cada host virtual com hospedagem física:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Como resultado deste fato, o número máximo de arquivos abertos é excedido pelo servidor nginx devido a um grande número de domínios (geralmente, mais de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Aumente o limite de arquivos abertos',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Aviso:</strong> Execução do utilitário <code>websrv_ulimits</code> sem <strong>- A opção -no-restart</strong> inicia a reconstrução dos arquivos de configuração da Web para todos os domínios e pode causar um tempo de inatividade significativo no caso de um grande número de websites hospedados.<br><br>Execute o comando durante o período de manutenção.</div><p>É uma boa prática definir o valor limite de arquivos abertos acima do <strong>número de domínios no Plesk * 16</strong> pelo menos. No exemplo abaixo forneceu ações como definir o limite para 4096:</p><ol><li><p>Conecte-se ao servidor via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Defina o limite de arquivos abertos para 4096 para Apache e Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Reinicie os serviços Apache e nginx em <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Ferramentas &amp; Configurações &gt; Gerenciamento de serviços</strong> para aplicar as alterações.</p></li><li><p>Verifique se \'Limite máximo de arquivos abertos\' foi aplicado corretamente após a reinicialização dos serviços da Web:</p><pre># grep \'Máximo de arquivos abertos\' /proc/$(cat /var/run/nginx.pid)/limits<br>Máximo de arquivos abertos 4096 4096 file</pre></li><li><p>Se a solução acima fez não ajudou, defina o limite usando o utilitário <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Corpo de resposta muito grande"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Ficará pronto em breve.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Acesso negado com código 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Sintomas</h4><ul><li><p>ModSecurity está instalado e ativado em <strong>Ferramentas & Configurações > Firewall de aplicativo da Web (ModSecurity) > Modo de firewall de aplicativo da Web > Ativado</strong>.</p></li><li>Um website hospedado no Plesk não carrega. Não é possível realizar operações no website como gerenciar o WordPress, acessar o webmail ou acessar o arquivo <code>robots.txt</code>. O navegador pode exibir um dos seguintes erros: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Uma mensagem de erro ModSecurity como a abaixo aparece no arquivo de log <code>/var/log/modsec_audit.log</code> ou na página de Logs no Plesk (<strong>Domínios</strong> &gt; <strong>exemplo.com</strong> &gt; <strong>Logs</strong>): <pre>ModSecurity: Acesso negado com código 403 (fase 2). Operador GE acertou 5 no TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Pontuação de anomalia de entrada excedida (pontuação total: 5)"] [gravidade "CRÍTICA"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>O ModSecurity Web Application Firewall é habilitado com um conjunto de regras muito restritivo, como OWASP, Comodo, ou um conjunto de regras personalizado, como Imunify360. Conjuntos de regras restritivas podem bloquear algumas operações no website.</p><p><Strong>Observação:</strong> O erro ModSecurity pode indicar um ataque ao seu servidor. Use as soluções abaixo apenas se tiver certeza de que o ModSecurity bloqueia o uso válido do seu website.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Desabilite a regra ModSecurity definida por ID ou Tag',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Encontre o ID da regra que bloqueia o uso legítimo do seu website. Você pode encontrar os IDs dentro das mensagens de erro no arquivo de log <code>/var/log/modsec_audit.log</code>. O ID é um número inteiro entre aspas com o prefixo <code>id</code> entre colchetes, por exemplo, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Desabilitar conjuntos de regras específicas no Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Mudar para outro conjunto de regras ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Mude para um conjunto de regras ModSecurity menos restritivo, por exemplo, "Atomic ModSecurity Ruleset". Para fazer isso, vá para <strong>Ferramentas e configurações</strong> > <strong>Firewall de aplicativos da Web (ModSecurity)</strong> > <strong>Configurações</strong>, selecione <strong>Atomic Standard</strong> e clique em <strong>OK</strong> para aplicar as alterações.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Erro de servidor interno 500: tamanho de memória permitido de XXX esgotado"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Sintomas</h4><ul><li><p>Um website hospedado no Plesk não está acessível:</p><pre>500 Internal Server Error</pre></li><li><p>O seguinte erro é mostrado no log do website:</p><pre>Ocorreu o erro "Mensagem PHP: Erro fatal do PHP: Tamanho de memória permitido de 4194304 bytes esgotado (tentou alocar 4000032 bytes) em /var/www/vhosts/example.com/httpdocs/somethingBig.php na linha 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>O website não tem memória suficiente alocada para ser processado.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Aumente o memory_limit do website',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restrição open_basedir em vigor"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Sintomas</h4><ul><li><p>Um site não está acessível com um dos seguintes erros no navegador da Web:</p><pre>arquivo 404 não encontrado</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restrição em vigor. Arquivp(/path/to/the/directory) não está dentro do(s) caminho(s) permitido(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>A seguinte mensagem de erro aparece na página de registros do domínio (<strong>Domínios</strong> > <strong>example.com</strong> > <strong>Logs</strong>):</p><pre><...> open_basedirrestrição em vigor. Arquivo(/path/to/the/directory) não está dentro do(s) caminho(s) permitido(s) <...></pre><hr><pre>Exceção não capturada: Sessão: o caminho de salvamento configurado "/path/to/the/directory" não é um diretório, não existem ou não podem ser criados.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'O script PHP está tentando acessar o diretório para o qual o acesso não é permitido. Esta restrição é definida pela diretiva PHP <code>open_basedir</code> individualmente para cada domínio. Por padrão, <code>open_basedir</code> permite acesso ao <code>tmp</code> e diretórios raiz de documentos do domínio, bem como ao caminho de sessões padrão do sistema.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Adicione o caminho adicional à diretiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Desabilite a diretiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Vá para a página <strong>Domínios &gt example.com &gt Configurações PHP </strong> e defina a diretiva <code>open_basedir</code> como "none".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Proibido AH01797: cliente negado pela configuração do servidor"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Sintomas</h4><ul><li><p>O website mostra um erro semelhante ao seguinte:</p><pre>Server Error 403<br>Forbidden</pre></li> <li><p>O arquivo de log <code>/var/www/vhosts/system/example.com/logs/error_log</code> contém erros como este:</p><pre>AH01797: cliente negado pela configuração do servidor: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>A configuração atual do Apache não permite acesso ao website.</p><p>Para arquivos como .htaccess e .htpasswd, é esperado porque esses arquivos não devem ser acessíveis através do servidor web.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Verifique a configuração do servidor e os arquivos .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Não é possível acessar um diretório de websites no Plesk: 403 Proibido"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Sintomas</h4><ul><li><p>Não é possível acessar um local específico de um website, por exemplo, <code>http://example.com/some_folder</code>. Ocorre o seguinte erro:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>O seguinte erro aparece no <code>/var/www/vhosts/example.com/logs/error_log<code/> arquivo:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) encontrado e índice de diretório gerado pelo servidor proibido pela diretiva Opções</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>O diretório solicitado não contém arquivos de índice ou a navegação no diretório não está ativada.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Adicionar um arquivo de índice ao diretório',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Ativar a navegação no diretório',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Não é possível acessar um diretório de websites no Plesk: 403 Proibido"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Sintomas</h4><ul><li><p>Não é possível acessar um local específico de um website, por exemplo, <code>http://example.com/some_folder</code>. Ocorre o seguinte erro:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>O seguinte erro aparece no <code>/var/www/vhosts/example.com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) encontrado e índice de diretório gerado pelo servidor proibido pela diretiva Opções</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>O diretório solicitado não contém arquivos de índice ou a navegação no diretório não está ativada.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Adicionar um arquivo de índice ao diretório',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Ativar a navegação no diretório',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "servidor atingiu a configuração MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Ficará pronto em breve.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Limite do corpo da solicitação PHP "cliente destinado a enviar corpo muito grande"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Ficará pronto em breve.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Limite do corpo da solicitação PHP "cliente destinado a enviar corpo muito grande"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Ficará pronto em breve.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sessões PHP "503 Erro Interno do Servidor" ou "Falha ao ler os dados da sessão"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Ficará pronto em breve.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: não foi possível verificar o arquivo htaccess, certifique-se de que seja legível"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Sintomas</h4><ul><li><p>Um website hospedado no Plesk não está funcionando:</p><pre>Você não tem permissão para acessar / neste servidor. <br> Adicionalmente, um erro 403 Forbidden foi encontrado ao tentar usar um ErrorDocument para lidar com a solicitação.</pre><p>Em vez do erro acima, você também pode ver a página em branco.</p></li><li><p>O registro de erro de domínio em <strong>Domínios &gt example.com &gt Logs</strong> contém o seguinte:</p><pre>(13)Permissão negada: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: incapaz de verificar o arquivo htaccess, certifique-se de que ele seja legível e que "/var/www/vhosts/example.com/httpdocs/" é executável</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Permissões incorretas para os arquivos ou pastas do domínio.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Permissões de reparo para o conteúdo do website',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
];